/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.confirmdialog;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.internal.OverlayClassListProxy;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Optional;

@Tag(value="vaadin-confirm-dialog")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.3.7"), @NpmPackage(value="@vaadin/confirm-dialog", version="24.3.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/confirm-dialog/src/vaadin-confirm-dialog.js")})
public class ConfirmDialog
extends Component
implements HasSize,
HasStyle,
HasOrderedComponents {
    private String height;
    private String width;
    private Registration afterProgrammaticNavigationListenerRegistration;
    private boolean autoAddedToTheUi;

    public void setWidth(String width) {
        this.width = width;
        this.updateWidth();
    }

    private void updateWidth() {
        this.getElement().executeJs("this._contentWidth = $0", new Serializable[]{this.width});
    }

    public void setHeight(String height) {
        this.height = height;
        this.updateHeight();
    }

    public void updateHeight() {
        this.getElement().executeJs("this._contentHeight = $0", new Serializable[]{this.height});
    }

    public void setClassName(String className) {
        this.getClassNames().clear();
        if (className != null) {
            this.addClassNames(className.split(" "));
        }
    }

    public ClassList getClassNames() {
        return new OverlayClassListProxy((HasStyle)this);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("ConfirmDialog does not support adding styles to overlay");
    }

    public void setAriaDescribedBy(String describedBy) {
        this.getElement().setProperty("accessibleDescriptionRef", describedBy);
    }

    public Optional<String> getAriaDescribedBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleDescriptionRef"));
    }

    public ConfirmDialog() {
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (!this.isOpened()) {
                this.setModality(false);
            }
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this();
        this.setHeader(header);
        this.setText(text);
        this.setConfirmButton(confirmText, confirmListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener);
        this.setCancelButton(cancelText, cancelListener);
    }

    public ConfirmDialog(String header, String text, String confirmText, ComponentEventListener<ConfirmEvent> confirmListener, String rejectText, ComponentEventListener<RejectEvent> rejectListener, String cancelText, ComponentEventListener<CancelEvent> cancelListener) {
        this(header, text, confirmText, confirmListener, cancelText, cancelListener);
        this.setRejectButton(rejectText, rejectListener);
    }

    public void setCancelable(boolean cancelable) {
        this.getElement().setProperty("cancelButtonVisible", cancelable);
    }

    public void setRejectable(boolean rejectable) {
        this.getElement().setProperty("rejectButtonVisible", rejectable);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener) {
        this.setRejectable(true);
        this.setRejectText(buttonText);
        this.addRejectListener(rejectListener);
    }

    public void setRejectButton(String buttonText, ComponentEventListener<RejectEvent> rejectListener, String theme) {
        this.setRejectButton(buttonText, rejectListener);
        this.setRejectButtonTheme(theme);
    }

    public void setRejectButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"reject-button", (Component[])new Component[]{component});
    }

    @Deprecated(forRemoval=true)
    public void setRejectButton(Element element) {
        SlotUtils.setSlot((HasElement)this, (String)"reject-button", (Element[])new Element[]{element});
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener) {
        this.setCancelable(true);
        this.setCancelText(buttonText);
        this.addCancelListener(cancelListener);
    }

    public void setCancelButton(String buttonText, ComponentEventListener<CancelEvent> cancelListener, String theme) {
        this.setCancelButton(buttonText, cancelListener);
        this.setCancelButtonTheme(theme);
    }

    public void setCancelButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"cancel-button", (Component[])new Component[]{component});
    }

    @Deprecated(forRemoval=true)
    public void setCancelButton(Element element) {
        SlotUtils.setSlot((HasElement)this, (String)"cancel-button", (Element[])new Element[]{element});
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener) {
        this.setConfirmText(buttonText);
        this.addConfirmListener(confirmListener);
    }

    public void setConfirmButton(String buttonText, ComponentEventListener<ConfirmEvent> confirmListener, String theme) {
        this.setConfirmButton(buttonText, confirmListener);
        this.setConfirmButtonTheme(theme);
    }

    public void setConfirmButton(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"confirm-button", (Component[])new Component[]{component});
    }

    @Deprecated(forRemoval=true)
    public void setConfirmButton(Element element) {
        SlotUtils.setSlot((HasElement)this, (String)"confirm-button", (Element[])new Element[]{element});
    }

    public void setText(String message) {
        this.getElement().setProperty("message", message);
    }

    public void setText(Component component) {
        this.getElement().appendChild(new Element[]{component.getElement()});
    }

    @Deprecated(forRemoval=true)
    public void setText(Element element) {
        this.getElement().appendChild(new Element[]{element});
    }

    public void setConfirmText(String confirmText) {
        this.getElement().setProperty("confirmText", confirmText);
    }

    public void setConfirmButtonTheme(String confirmTheme) {
        this.getElement().setProperty("confirmTheme", confirmTheme);
    }

    public Registration addConfirmListener(ComponentEventListener<ConfirmEvent> listener) {
        return ComponentUtil.addListener((Component)this, ConfirmEvent.class, listener);
    }

    public void setCancelText(String cancelText) {
        this.getElement().setProperty("cancelText", cancelText);
    }

    public void setCancelButtonTheme(String cancelTheme) {
        this.getElement().setProperty("cancelTheme", cancelTheme);
    }

    public Registration addCancelListener(ComponentEventListener<CancelEvent> listener) {
        return ComponentUtil.addListener((Component)this, CancelEvent.class, listener);
    }

    public void setRejectText(String rejectText) {
        this.getElement().setProperty("rejectText", rejectText);
    }

    public void setRejectButtonTheme(String rejectTheme) {
        this.getElement().setProperty("rejectTheme", rejectTheme);
    }

    public Registration addRejectListener(ComponentEventListener<RejectEvent> listener) {
        return ComponentUtil.addListener((Component)this, RejectEvent.class, listener);
    }

    public void setHeader(String header) {
        this.getElement().setProperty("header", header);
    }

    public void setHeader(Component component) {
        SlotUtils.setSlot((HasElement)this, (String)"header", (Component[])new Component[]{component});
    }

    @Deprecated(forRemoval=true)
    public void setHeader(Element element) {
        SlotUtils.setSlot((HasElement)this, (String)"header", (Element[])new Element[]{element});
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
        }
        this.setModality(opened);
        this.getElement().setProperty("opened", opened);
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        Shortcuts.setShortcutListenOnElement((String)"this._overlayElement", (Component)this);
    }

    private void setModality(boolean modal) {
        if (this.isAttached()) {
            this.getUI().ifPresent(ui -> ui.setChildComponentModal((Component)this, modal));
        }
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        UI ui = this.getCurrentUI();
        StateTree.ExecutionRegistration addToUiRegistration = ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
            if (this.getElement().getNode().getParent() == null) {
                ui.addToModalComponent((Component)this);
                this.autoAddedToTheUi = true;
                this.updateWidth();
                this.updateHeight();
                ui.setChildComponentModal((Component)this, true);
            }
            if (this.afterProgrammaticNavigationListenerRegistration != null) {
                this.afterProgrammaticNavigationListenerRegistration.remove();
            }
        });
        if (ui.getSession() != null) {
            this.afterProgrammaticNavigationListenerRegistration = ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> {
                if (event.getLocationChangeEvent().getTrigger() == NavigationTrigger.PROGRAMMATIC) {
                    addToUiRegistration.remove();
                    this.afterProgrammaticNavigationListenerRegistration.remove();
                }
            });
        }
    }

    @DomEvent(value="confirm")
    public static class ConfirmEvent
    extends ComponentEvent<ConfirmDialog> {
        public ConfirmEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="cancel")
    public static class CancelEvent
    extends ComponentEvent<ConfirmDialog> {
        public CancelEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    @DomEvent(value="reject")
    public static class RejectEvent
    extends ComponentEvent<ConfirmDialog> {
        public RejectEvent(ConfirmDialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

