/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.GeneratedVaadinContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

@HtmlImport.Container(value={@HtmlImport(value="flow-component-renderer.html"), @HtmlImport(value="frontend://bower_components/vaadin-list-box/src/vaadin-list-box.html")})
@JavaScript(value="frontend://contextMenuConnector.js")
public abstract class ContextMenuBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends GeneratedVaadinContextMenu<C>
implements HasComponents {
    private Component target;
    private MenuManager<C, I, S> menuManager;
    private boolean updateScheduled = false;
    private final Element container = new Element("div");
    private String openOnEventName = "vaadin-contextmenu";
    private Registration targetBeforeOpenRegistration;
    private boolean autoAddedToTheUi;

    public ContextMenuBase() {
        this.getElement().appendVirtualChild(new Element[]{this.container});
        this.getElement().setProperty("opened", false);
        this.setOpenOn("none");
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
        this.addAttachListener((ComponentEventListener & Serializable)event -> this.resetContent());
    }

    public void setTarget(Component target) {
        if (this.getTarget() != null) {
            this.targetBeforeOpenRegistration.remove();
            this.getTarget().getElement().callFunction("$contextMenuConnector.removeConnector", new Serializable[0]);
        }
        this.target = target;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJavaScript("$0.listenOn=$1", new Serializable[]{this, target})));
        if (target == null) {
            return;
        }
        target.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse(target, (SerializableConsumer & Serializable)context -> {
            ui.getInternals().addComponentDependencies(ContextMenuBase.class);
            ui.getPage().executeJavaScript("window.Vaadin.Flow.contextMenuConnector.init($0)", new Serializable[]{target.getElement()});
        }));
        this.updateOpenOn();
        this.targetBeforeOpenRegistration = target.getElement().addEventListener("vaadin-context-menu-before-open", (DomEventListener & Serializable)event -> {
            this.beforeOpen();
            target.getElement().callFunction("$contextMenuConnector.openMenu", new Serializable[]{this.getElement()});
        });
    }

    public Component getTarget() {
        return this.target;
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnEventName = openOnClick ? "click" : "vaadin-contextmenu";
        this.updateOpenOn();
    }

    public boolean isOpenOnClick() {
        return "click".equals(this.openOnEventName);
    }

    @Override
    public void close() {
        super.close();
    }

    public I addItem(String text) {
        return this.getMenuManager().addItem(text);
    }

    public I addItem(Component component) {
        return this.getMenuManager().addItem(component);
    }

    public void add(Component ... components) {
        this.getMenuManager().add(components);
    }

    public void remove(Component ... components) {
        this.getMenuManager().remove(components);
    }

    public void removeAll() {
        this.getMenuManager().removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.getMenuManager().addComponentAtIndex(index, component);
    }

    public Stream<Component> getChildren() {
        return this.getMenuManager().getChildren();
    }

    public List<I> getItems() {
        return this.getMenuManager().getItems();
    }

    public boolean isOpened() {
        return super.isOpenedBoolean();
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinContextMenu.OpenedChangeEvent<C>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    protected MenuManager<C, I, S> getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = this.createMenuManager(this::resetContent);
        }
        return this.menuManager;
    }

    protected abstract MenuManager<C, I, S> createMenuManager(SerializableRunnable var1);

    private void resetContent() {
        if (this.updateScheduled) {
            return;
        }
        this.updateScheduled = true;
        this.runBeforeClientResponse(ui -> {
            this.container.removeAllChildren();
            this.getItems().forEach(this::resetContainers);
            int containerNodeId = this.createNewContainer(this.getChildren());
            String appId = ui.getInternals().getAppId();
            ui.getPage().executeJavaScript("window.Vaadin.Flow.contextMenuConnector.generateItems($0, $1, $2)", new Serializable[]{this.getElement(), appId, Integer.valueOf(containerNodeId)});
            this.updateScheduled = false;
        });
    }

    private void resetContainers(I menuItem) {
        if (!((MenuItemBase)((Object)menuItem)).isParentItem()) {
            menuItem.getElement().removeProperty("_containerNodeId");
            return;
        }
        Object subMenu = ((MenuItemBase)((Object)menuItem)).getSubMenu();
        int containerNodeId = this.createNewContainer(((SubMenuBase)subMenu).getChildren());
        menuItem.getElement().setProperty("_containerNodeId", (double)containerNodeId);
        ((SubMenuBase)subMenu).getItems().forEach(this::resetContainers);
    }

    private int createNewContainer(Stream<Component> components) {
        Element subContainer = new Element("div");
        this.container.appendChild(new Element[]{subContainer});
        components.forEach(child -> {
            Element cfr_ignored_0 = (Element)subContainer.appendChild(new Element[]{child.getElement()});
        });
        return subContainer.getNode().getId();
    }

    private void runBeforeClientResponse(Consumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept((UI)ui)));
    }

    private void updateOpenOn() {
        if (this.target != null) {
            this.target.getElement().callFunction("$contextMenuConnector.updateOpenOn", new Serializable[]{this.openOnEventName});
        }
    }

    private void beforeOpen() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }
}

