/**
 * Copyright (C) 2000-2024 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.shared.Registration;

import elemental.json.JsonObject;

/**
 * <p>
 * Description copied from corresponding location in WebComponent:
 * </p>
 * <p>
 * &lt;vaadin-context-menu&gt; &lt;template&gt; &lt;vaadin-list-box&gt;
 * &lt;vaadin-item&gt;First menu item&lt;/vaadin-item&gt;
 * &lt;vaadin-item&gt;Second menu item&lt;/vaadin-item&gt;
 * &lt;/vaadin-list-box&gt; &lt;/template&gt; &lt;/vaadin-context-menu&gt;
 * </p>
 * <h3>“vaadin-contextmenu” Gesture Event</h3>
 * <p>
 * {@code vaadin-contextmenu} is a gesture event (a custom event fired by
 * Polymer), which is dispatched after either {@code contextmenu} and long touch
 * events. This enables support for both mouse and touch environments in a
 * uniform way.
 * </p>
 * <p>
 * {@code <vaadin-context-menu>} opens the menu overlay on the
 * {@code vaadin-contextmenu} event by default.
 * </p>
 * <h3>Menu Listener</h3>
 * <p>
 * By default, the {@code <vaadin-context-menu>} element listens for the menu
 * opening event on itself. In order to have a context menu on your content,
 * wrap your content with the {@code <vaadin-context-menu>} element, and add a
 * template element with a menu. Example:
 * </p>
 * <p>
 * &lt;vaadin-context-menu&gt; &lt;template&gt; &lt;vaadin-list-box&gt;
 * &lt;vaadin-item&gt;First menu item&lt;/vaadin-item&gt;
 * &lt;vaadin-item&gt;Second menu item&lt;/vaadin-item&gt;
 * &lt;/vaadin-list-box&gt; &lt;/template&gt;
 * </p>
 * <p>
 * &lt;p&gt;This paragraph has the context menu provided in the above
 * template.&lt;/p&gt; &lt;p&gt;Another paragraph with the context
 * menu.&lt;/p&gt; &lt;/vaadin-context-menu&gt;
 * </p>
 * <p>
 * In case if you do not want to wrap the page content, you can listen for
 * events on an element outside the {@code <vaadin-context-menu>} by setting the
 * {@code listenOn} property:
 * </p>
 * <p>
 * &lt;vaadin-context-menu id=&quot;customListener&quot;&gt; &lt;template&gt;
 * &lt;vaadin-list-box&gt; ... &lt;/vaadin-list-box&gt; &lt;/template&gt;
 * &lt;/vaadin-context-menu&gt;
 * </p>
 * <p>
 * &lt;div id=&quot;menuListener&quot;&gt;The element that listens for the
 * context menu.&lt;/div&gt;
 * </p>
 * <p>
 * &amp;lt;script&amp;gt; const contextMenu =
 * document.querySelector('vaadin-context-menu#customListener');
 * contextMenu.listenOn = document.querySelector('#menuListener');
 * &amp;lt;/script&amp;gt;
 * </p>
 * <h3>Filtering Menu Targets</h3>
 * <p>
 * By default, the listener element and all its descendants open the context
 * menu. You can filter the menu targets to a smaller set of elements inside the
 * listener element by setting the {@code selector} property.
 * </p>
 * <p>
 * In the following example, only the elements matching {@code .has-menu} will
 * open the context menu:
 * </p>
 * <p>
 * &lt;vaadin-context-menu selector=&quot;.has-menu&quot;&gt; &lt;template&gt;
 * &lt;vaadin-list-box&gt; ... &lt;/vaadin-list-box&gt; &lt;/template&gt;
 * </p>
 * <p>
 * &lt;p class=&quot;has-menu&quot;&gt;This paragraph opens the context
 * menu&lt;/p&gt; &lt;p&gt;This paragraph does not open the context
 * menu&lt;/p&gt; &lt;/vaadin-context-menu&gt;
 * </p>
 * <h3>Menu Context</h3>
 * <p>
 * You can bind to the following properties in the menu template:
 * </p>
 * <ul>
 * <li>{@code target} is the menu opening event target, which is the element
 * that the user has called the context menu for</li>
 * <li>{@code detail} is the menu opening event detail</li>
 * </ul>
 * <p>
 * In the following example, the menu item text is composed with the contents of
 * the element that opened the menu:
 * </p>
 * <p>
 * &lt;vaadin-context-menu selector=&quot;li&quot;&gt; &lt;template&gt;
 * &lt;vaadin-list-box&gt; &lt;vaadin-item&gt;The menu target:
 * [[target.textContent]]&lt;/vaadin-item&gt; &lt;/vaadin-list-box&gt;
 * &lt;/template&gt;
 * </p>
 * <p>
 * &lt;ul&gt; &lt;li&gt;Foo&lt;/li&gt; &lt;li&gt;Bar&lt;/li&gt;
 * &lt;li&gt;Baz&lt;/li&gt; &lt;/ul&gt; &lt;/vaadin-context-menu&gt;
 * </p>
 * <h3>Styling</h3>
 * <p>
 * See
 * <a href="https://github.com/vaadin/vaadin-themable-mixin/wiki">ThemableMixin
 * – how to apply styles for shadow parts</a>
 * </p>
 *
 * @deprecated since v23.3, generated classes will be removed in v24.
 */
@Deprecated
@Tag("vaadin-context-menu")
@NpmPackage(value = "@vaadin/polymer-legacy-adapter", version = "23.5.3")
@JsModule("@vaadin/polymer-legacy-adapter/style-modules.js")
@NpmPackage(value = "@vaadin/context-menu", version = "23.5.3")
@NpmPackage(value = "@vaadin/vaadin-context-menu", version = "23.5.3")
@JsModule("@vaadin/context-menu/src/vaadin-context-menu.js")
@JsModule("@vaadin/polymer-legacy-adapter/template-renderer.js")
public abstract class GeneratedVaadinContextMenu<R extends ContextMenuBase<R, ?, ?>>
        extends Component implements HasStyle, ClickNotifier<R> {

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * CSS selector that can be used to target any child element of the context
     * menu to listen for {@code openOn} events.
     * <p>
     * This property is not synchronized automatically from the client side, so
     * the returned value may not be the same as in client side.
     * </p>
     *
     * @return the {@code selector} property from the webcomponent
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected String getSelectorString() {
        return getElement().getProperty("selector");
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * CSS selector that can be used to target any child element of the context
     * menu to listen for {@code openOn} events.
     * </p>
     *
     * @param selector
     *            the String value to set
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void setSelector(String selector) {
        getElement().setProperty("selector", selector == null ? "" : selector);
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * True if the overlay is currently displayed.
     * <p>
     * This property is synchronized automatically from client side when a
     * 'opened-changed' event happens.
     * </p>
     *
     * @return the {@code opened} property from the webcomponent
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    @Synchronize(property = "opened", value = "opened-changed")
    protected boolean isOpenedBoolean() {
        return getElement().getProperty("opened", false);
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Event name to listen for opening the context menu.
     * <p>
     * This property is not synchronized automatically from the client side, so
     * the returned value may not be the same as in client side.
     * </p>
     *
     * @return the {@code openOn} property from the webcomponent
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected String getOpenOnString() {
        return getElement().getProperty("openOn");
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Event name to listen for opening the context menu.
     * </p>
     *
     * @param openOn
     *            the String value to set
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void setOpenOn(String openOn) {
        getElement().setProperty("openOn", openOn == null ? "" : openOn);
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * The target element that's listened to for context menu opening events. By
     * default the vaadin-context-menu listens to the target's
     * {@code vaadin-contextmenu} events.
     * <p>
     * This property is not synchronized automatically from the client side, so
     * the returned value may not be the same as in client side.
     * </p>
     *
     * @return the {@code listenOn} property from the webcomponent
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected JsonObject getListenOnJsonObject() {
        return (JsonObject) getElement().getPropertyRaw("listenOn");
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * The target element that's listened to for context menu opening events. By
     * default the vaadin-context-menu listens to the target's
     * {@code vaadin-contextmenu} events.
     * </p>
     *
     * @param listenOn
     *            the JsonObject value to set
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void setListenOn(JsonObject listenOn) {
        getElement().setPropertyJson("listenOn", listenOn);
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Event name to listen for closing the context menu.
     * <p>
     * This property is not synchronized automatically from the client side, so
     * the returned value may not be the same as in client side.
     * </p>
     *
     * @return the {@code closeOn} property from the webcomponent
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected String getCloseOnString() {
        return getElement().getProperty("closeOn");
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Event name to listen for closing the context menu.
     * </p>
     *
     * @param closeOn
     *            the String value to set
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void setCloseOn(String closeOn) {
        getElement().setProperty("closeOn", closeOn == null ? "" : closeOn);
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Closes the overlay.
     * </p>
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void close() {
        getElement().callFunction("close");
    }

    /**
     * <p>
     * Description copied from corresponding location in WebComponent:
     * </p>
     * <p>
     * Opens the overlay.
     * </p>
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    protected void open() {
        getElement().callFunction("open");
    }

    /**
     * @deprecated since v23.3, generated classes will be removed in v24. Use
     *             {@link ContextMenuBase.OpenedChangeEvent} instead.
     */
    @Deprecated
    public static class OpenedChangeEvent<C extends ContextMenuBase<C, ?, ?>>
            extends ComponentEvent<C> {
        private final boolean opened;

        public OpenedChangeEvent(C source, boolean fromClient) {
            super(source, fromClient);
            this.opened = source.isOpenedBoolean();
        }

        public boolean isOpened() {
            return opened;
        }
    }

    /**
     * Adds a listener for {@code opened-changed} events fired by the
     * webcomponent.
     *
     * @param listener
     *            the listener
     * @return a {@link Registration} for removing the event listener
     *
     * @deprecated since v23.3, generated classes will be removed in v24. Use
     *             {@link ContextMenuBase#addOpenedChangeListener} instead.
     */
    @Deprecated
    protected Registration addOpenedChangeListener(
            ComponentEventListener<ContextMenuBase.OpenedChangeEvent<R>> listener) {
        return getElement().addPropertyChangeListener("opened",
                event -> listener.onComponentEvent(
                        new ContextMenuBase.OpenedChangeEvent<>((R) this,
                                event.isUserOriginated())));
    }

    /**
     * Has no effect for ContextMenu because the element for ContextMenu is not
     * clickable. Therefore, this method should not be used.
     *
     * @see #addClickListener(ComponentEventListener)
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    @Override
    public Registration addClickListener(
            ComponentEventListener<ClickEvent<R>> listener) {
        return ClickNotifier.super.addClickListener(listener);
    }

    /**
     * Has no effect for ContextMenu because the element for ContextMenu is not
     * clickable. Therefore, this method should not be used.
     *
     * @see #addClickShortcut(Key, KeyModifier...)
     *
     * @deprecated since v23.3, generated classes will be removed in v24.
     */
    @Deprecated
    @Override
    public ShortcutRegistration addClickShortcut(Key key,
            KeyModifier... keyModifiers) {
        return ClickNotifier.super.addClickShortcut(key, keyModifiers);
    }
}
