/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.GeneratedVaadinContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItemBase;
import com.vaadin.flow.component.contextmenu.MenuItemsArrayGenerator;
import com.vaadin.flow.component.contextmenu.MenuManager;
import com.vaadin.flow.component.contextmenu.SubMenuBase;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;

@JsModule.Container(value={@JsModule(value="flow-component-renderer.js"), @JsModule(value="@vaadin/vaadin-list-box/src/vaadin-list-box.js"), @JsModule(value="./contextMenuConnector-es6.js")})
@NpmPackage(value="@vaadin/vaadin-list-box", version="1.1.0")
@HtmlImport.Container(value={@HtmlImport(value="flow-component-renderer.html"), @HtmlImport(value="frontend://bower_components/vaadin-list-box/src/vaadin-list-box.html")})
@JavaScript(value="frontend://contextMenuConnector.js")
public abstract class ContextMenuBase<C extends ContextMenuBase<C, I, S>, I extends MenuItemBase<C, I, S>, S extends SubMenuBase<C, I, S>>
extends GeneratedVaadinContextMenu<C>
implements HasComponents {
    private Component target;
    private MenuManager<C, I, S> menuManager;
    private MenuItemsArrayGenerator<I> menuItemsArrayGenerator;
    private String openOnEventName = "vaadin-contextmenu";
    private Registration targetBeforeOpenRegistration;
    private Registration targetAttachRegistration;
    private boolean autoAddedToTheUi;

    public ContextMenuBase() {
        this.getElement().setProperty("opened", false);
        this.setOpenOn("none");
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
        this.menuItemsArrayGenerator = new MenuItemsArrayGenerator(this);
        this.addAttachListener((ComponentEventListener & Serializable)event -> this.resetContent());
    }

    public void setTarget(Component target) {
        if (this.getTarget() != null) {
            this.targetBeforeOpenRegistration.remove();
            this.targetAttachRegistration.remove();
            this.getTarget().getElement().callFunction("$contextMenuConnector.removeConnector", new Serializable[0]);
        }
        this.target = target;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> ui.getPage().executeJavaScript("$0.listenOn=$1", new Serializable[]{this, target})));
        if (target == null) {
            return;
        }
        target.getUI().ifPresent(this::onTargetAttach);
        this.targetAttachRegistration = target.addAttachListener((ComponentEventListener & Serializable)e -> this.onTargetAttach(e.getUI()));
        this.targetBeforeOpenRegistration = target.getElement().addEventListener("vaadin-context-menu-before-open", (DomEventListener & Serializable)event -> {
            this.beforeOpen();
            target.getElement().callFunction("$contextMenuConnector.openMenu", new Serializable[]{this.getElement()});
        });
    }

    public Component getTarget() {
        return this.target;
    }

    public void setOpenOnClick(boolean openOnClick) {
        this.openOnEventName = openOnClick ? "click" : "vaadin-contextmenu";
        this.updateOpenOn();
    }

    public boolean isOpenOnClick() {
        return "click".equals(this.openOnEventName);
    }

    @Override
    public void close() {
        super.close();
    }

    public I addItem(String text) {
        return this.getMenuManager().addItem(text);
    }

    public I addItem(Component component) {
        return this.getMenuManager().addItem(component);
    }

    public void add(Component ... components) {
        this.getMenuManager().add(components);
    }

    public void remove(Component ... components) {
        this.getMenuManager().remove(components);
    }

    public void removeAll() {
        this.getMenuManager().removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.getMenuManager().addComponentAtIndex(index, component);
    }

    public Stream<Component> getChildren() {
        return this.getMenuManager().getChildren();
    }

    public List<I> getItems() {
        return this.getMenuManager().getItems();
    }

    public boolean isOpened() {
        return super.isOpenedBoolean();
    }

    @Override
    public Registration addOpenedChangeListener(ComponentEventListener<GeneratedVaadinContextMenu.OpenedChangeEvent<C>> listener) {
        return super.addOpenedChangeListener(listener);
    }

    protected MenuManager<C, I, S> getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = this.createMenuManager(this::resetContent);
        }
        return this.menuManager;
    }

    protected abstract MenuManager<C, I, S> createMenuManager(SerializableRunnable var1);

    private void resetContent() {
        this.menuItemsArrayGenerator.generate();
    }

    private void onTargetAttach(UI ui) {
        ui.getInternals().addComponentDependencies(ContextMenu.class);
        ui.getPage().executeJs("window.Vaadin.Flow.contextMenuConnector.init($0)", new Serializable[]{this.target});
        this.updateOpenOn();
    }

    private void updateOpenOn() {
        if (this.target != null) {
            this.target.getElement().callFunction("$contextMenuConnector.updateOpenOn", new Serializable[]{this.openOnEventName});
        }
    }

    private void beforeOpen() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }
}

