/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.cookieconsent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import java.util.Locale;

@Tag(value="vaadin-cookie-consent")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.0.3"), @NpmPackage(value="@vaadin/cookie-consent", version="23.0.3"), @NpmPackage(value="@vaadin/vaadin-cookie-consent", version="23.0.3")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/cookie-consent/src/vaadin-cookie-consent.js")})
public class CookieConsent
extends Component {
    public CookieConsent() {
    }

    public CookieConsent(String message, String dismissLabel, String learnMoreLabel, String learnMoreLink, Position position) {
        this.setMessage(message);
        this.setDismissLabel(dismissLabel);
        this.setLearnMoreLabel(learnMoreLabel);
        this.setLearnMoreLink(learnMoreLink);
        this.setPosition(position);
    }

    public void setMessage(String message) {
        this.getElement().setProperty("message", message);
    }

    public void setDismissLabel(String dismissLabel) {
        this.getElement().setProperty("dismiss", dismissLabel);
    }

    public void setLearnMoreLabel(String learnMoreLabel) {
        this.getElement().setProperty("learnMore", learnMoreLabel);
    }

    public void setLearnMoreLink(String learnMoreLink) {
        this.getElement().setProperty("learnMoreLink", learnMoreLink);
    }

    public void setPosition(Position position) {
        this.getElement().setProperty("position", position.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public void setCookieName(String cookieName) {
        this.getElement().setProperty("cookieName", cookieName);
    }

    public static enum Position {
        TOP,
        BOTTOM,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

