/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.cookieconsent;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

@Tag(value="vaadin-cookie-consent")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.1"), @NpmPackage(value="@vaadin/cookie-consent", version="24.2.1")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/cookie-consent/src/vaadin-cookie-consent.js"), @JsModule(value="./cookieConsentConnector.js")})
public class CookieConsent
extends Component
implements HasStyle {
    public CookieConsent() {
    }

    public CookieConsent(String message, String dismissLabel, String learnMoreLabel, String learnMoreLink, Position position) {
        this.setMessage(message);
        this.setDismissLabel(dismissLabel);
        this.setLearnMoreLabel(learnMoreLabel);
        this.setLearnMoreLink(learnMoreLink);
        this.setPosition(position);
    }

    public void setMessage(String message) {
        this.getElement().setProperty("message", message);
    }

    public void setDismissLabel(String dismissLabel) {
        this.getElement().setProperty("dismiss", dismissLabel);
    }

    public void setLearnMoreLabel(String learnMoreLabel) {
        this.getElement().setProperty("learnMore", learnMoreLabel);
    }

    public void setLearnMoreLink(String learnMoreLink) {
        this.getElement().setProperty("learnMoreLink", learnMoreLink);
    }

    public void setPosition(Position position) {
        this.getElement().setProperty("position", position.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public void setCookieName(String cookieName) {
        this.getElement().setProperty("cookieName", cookieName);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("CookieConsent does not support adding styles");
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().executeJs("return this._getPopup().className.replace('cc-invisible', '').trim();", new Serializable[0]).then((SerializableConsumer & Serializable)result -> {
            String classValue = result.asString();
            String[] parts = classValue.split("\\s+");
            this.getClassNames().addAll(Arrays.asList(parts));
            this.initConnector();
        });
    }

    private void initConnector() {
        this.getElement().executeJs("window.Vaadin.Flow.cookieConsentConnector.initLazy(this)", new Serializable[0]);
    }

    public static enum Position {
        TOP,
        BOTTOM,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

