/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.crud;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.crud.CrudEditor;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;

public class BinderCrudEditor<E>
implements CrudEditor<E> {
    private final Binder<E> binder;
    private final Component view;
    private E item;

    public BinderCrudEditor(Binder<E> binder) {
        this(binder, null);
    }

    public BinderCrudEditor(Binder<E> binder, Component view) {
        this.binder = binder;
        this.view = view;
    }

    @Override
    public void setItem(E item, boolean validate) {
        this.item = item;
        this.binder.readBean(item);
        if (validate) {
            this.binder.validate();
        }
    }

    @Override
    public E getItem() {
        return this.item;
    }

    @Override
    public void writeItemChanges() {
        try {
            this.binder.writeBean(this.item);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void clear() {
        this.item = null;
        this.binder.readBean(null);
        this.binder.getFields().forEach(HasValue::clear);
    }

    @Override
    public boolean validate() {
        return this.binder.validate().isOk();
    }

    @Override
    public Component getView() {
        return this.view;
    }
}

