package com.vaadin.flow.component.crud;

/**
 * Copyright (C) 2000-2022 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */

/**
 * The set of theme variants applicable to the {@code vaadin-crud} component.
 */
public enum CrudVariant {

    NO_BORDER("no-border");

    private final String variant;

    CrudVariant(String variant) {
        this.variant = variant;
    }

    /**
     * Gets the variant name.
     *
     * @return variant name
     */
    public String getVariantName() {
        return variant;
    }
}
