/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.crud.testbench;

import com.vaadin.flow.component.button.testbench.ButtonElement;
import com.vaadin.flow.component.grid.testbench.GridElement;
import com.vaadin.flow.component.grid.testbench.GridTHTDElement;
import com.vaadin.flow.component.grid.testbench.GridTRElement;
import com.vaadin.flow.component.textfield.testbench.TextFieldElement;
import com.vaadin.testbench.ElementQuery;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Element(value="vaadin-crud")
public class CrudElement
extends TestBenchElement {
    public GridElement getGrid() {
        return (GridElement)this.$(GridElement.class).first();
    }

    public Optional<TestBenchElement> getNewItemButton() {
        ElementQuery newButtonQuery = this.$(TestBenchElement.class).attribute("new-button", "");
        return newButtonQuery.exists() ? Optional.of(newButtonQuery.last()) : Optional.empty();
    }

    public List<TextFieldElement> getFilterFields() {
        return this.$(TextFieldElement.class).attribute("crud-role", "Search").all();
    }

    public List<TestBenchElement> getToolbar() {
        return this.$(TestBenchElement.class).attribute("slot", "toolbar").all();
    }

    public void openRowForEditing(int row) {
        if (this.isEditOnClick()) {
            this.getGrid().getCell(row, 0).click();
        } else {
            GridTRElement editedRow = this.getGrid().getRow(row);
            GridTHTDElement editCell = (GridTHTDElement)this.getGrid().getAllColumns().stream().map(column -> editedRow.getCell(column)).filter(cell -> cell.getInnerHTML().contains("vaadin-crud-edit")).collect(Collectors.toList()).get(0);
            editCell.$("vaadin-crud-edit").get(0).click();
        }
    }

    public ButtonElement getEditorSaveButton() {
        return this.getEditorButton(0);
    }

    public ButtonElement getEditorCancelButton() {
        return this.getEditorButton(1);
    }

    public ButtonElement getEditorDeleteButton() {
        return this.getEditorButton(2);
    }

    private ButtonElement getEditorButton(int index) {
        return (ButtonElement)this.getEditor().$(ButtonElement.class).attribute("slot", "footer").get(index);
    }

    public boolean isEditorOpen() {
        if (this.getEditorPosition().isEmpty()) {
            return this.$("vaadin-dialog-overlay").onPage().attribute("opened", "").exists();
        }
        return this.getPropertyBoolean(new String[]{"editorOpened"});
    }

    public String getEditorPosition() {
        return this.getPropertyString(new String[]{"editorPosition"});
    }

    public boolean isEditOnClick() {
        return this.getPropertyBoolean(new String[]{"editOnClick"});
    }

    public TestBenchElement getEditor() {
        if (this.getEditorPosition().isEmpty()) {
            return this.$("vaadin-dialog-overlay").onPage().attribute("opened", "").first();
        }
        return this.$("vaadin-dialog-layout").first();
    }
}

