/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.customfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasHelper;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-custom-field")
@NpmPackage(value="@vaadin/vaadin-custom-field", version="20.0.0")
@JsModule(value="@vaadin/vaadin-custom-field/src/vaadin-custom-field.js")
public abstract class CustomField<T>
extends AbstractField<CustomField<T>, T>
implements HasSize,
HasValidation,
Focusable<CustomField>,
HasHelper {
    public CustomField() {
        this(null);
    }

    public CustomField(T defaultValue) {
        super(defaultValue);
        this.getElement().addEventListener("change", (DomEventListener & Serializable)e -> this.updateValue());
    }

    protected abstract T generateModelValue();

    protected abstract void setPresentationValue(T var1);

    protected void updateValue() {
        this.setModelValue(this.generateModelValue(), true);
    }

    protected void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            Element parent = component.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(CustomField.class).debug("Remove of a component with no parent does nothing.");
                return;
            }
            if (!this.getElement().equals((Object)parent)) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    @Synchronize(property="invalid", value={"invalid-changed"})
    public boolean isInvalid() {
        return this.getElement().getProperty("invalid", false);
    }

    public void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    public void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage);
    }

    public String getErrorMessage() {
        return this.getElement().getProperty("errorMessage");
    }

    public String getLabel() {
        return this.getElement().getProperty("label", null);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label);
    }
}

