/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.customfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.customfield.CustomFieldVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Tag(value="vaadin-custom-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.0-beta1"), @NpmPackage(value="@vaadin/custom-field", version="24.9.0-beta1")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/custom-field/src/vaadin-custom-field.js")})
public abstract class CustomField<T>
extends AbstractField<CustomField<T>, T>
implements Focusable<CustomField<T>>,
InputField<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T>,
HasTheme,
HasValidationProperties {
    public CustomField() {
        this(null);
    }

    public CustomField(T defaultValue) {
        this(defaultValue, false);
    }

    public CustomField(T defaultValue, boolean manualValueUpdate) {
        super(defaultValue);
        if (!manualValueUpdate) {
            this.getElement().addEventListener("change", (DomEventListener & Serializable)e -> this.updateValue());
        }
        this.getElement().setProperty("manualValidation", true);
    }

    protected abstract T generateModelValue();

    protected abstract void setPresentationValue(T var1);

    protected void updateValue() {
        this.setModelValue(this.generateModelValue(), true);
    }

    protected void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.getElement().appendChild(new Element[]{component.getElement()});
        }
    }

    protected void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            Element parent = component.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(CustomField.class).debug("Remove of a component with no parent does nothing.");
                return;
            }
            if (!this.getElement().equals((Object)parent)) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.getElement().removeChild(new Element[]{component.getElement()});
        }
    }

    public String getLabel() {
        return this.getElement().getProperty("label", null);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label);
    }

    public void addThemeVariants(CustomFieldVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(CustomFieldVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(CustomFieldVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(CustomFieldVariant::getVariantName).collect(Collectors.toList()));
    }
}

