/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.datepicker.DatePickerVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasPrefix;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-date-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.4.0"), @NpmPackage(value="@vaadin/date-picker", version="24.4.0"), @NpmPackage(value="date-fns", version="2.29.3")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/date-picker/src/vaadin-date-picker.js"), @JsModule(value="./datepickerConnector.js")})
public class DatePicker
extends AbstractSinglePropertyField<DatePicker, LocalDate>
implements Focusable<DatePicker>,
HasAllowedCharPattern,
HasAriaLabel,
HasAutoOpen,
HasClearButton,
HasClientValidation,
InputField<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>, LocalDate>,
HasOverlayClassName,
HasPrefix,
HasThemeVariant<DatePickerVariant>,
HasValidationProperties,
HasValidator<LocalDate>,
HasPlaceholder {
    private DatePickerI18n i18n;
    private static final SerializableFunction<String, LocalDate> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDate.parse(s);
    private static final SerializableFunction<LocalDate, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.toString();
    private Locale locale;
    private LocalDate max;
    private LocalDate min;
    private boolean required;
    private StateTree.ExecutionRegistration pendingI18nUpdate;
    private boolean manualValidationEnabled = false;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<LocalDate>> validationStatusChangeListeners = new CopyOnWriteArrayList();

    public DatePicker() {
        this((LocalDate)null, true);
    }

    public DatePicker(LocalDate initialDate) {
        this(initialDate, false);
    }

    private DatePicker(LocalDate initialDate, boolean isInitialValueOptional) {
        super("value", (Object)initialDate, String.class, PARSER, FORMATTER);
        if (this.getElement().getProperty("value") == null || !isInitialValueOptional) {
            this.setPresentationValue(initialDate);
        }
        this.setInvalid(false);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)event -> {
            this.validate();
            this.fireValidationStatusChangeEvent();
        });
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
        this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> this.fireEvent(new InvalidChangeEvent(this, event.isUserOriginated())));
    }

    public DatePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DatePicker(String label, LocalDate initialDate) {
        this(initialDate);
        this.setLabel(label);
    }

    public DatePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.addValueChangeListener(listener);
    }

    public DatePicker(String label, LocalDate initialDate, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DatePicker, LocalDate>> listener) {
        this(initialDate);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DatePicker(LocalDate initialDate, Locale locale) {
        this(initialDate);
        this.setLocale(locale);
    }

    public void setMin(LocalDate min) {
        String minAsString = (String)FORMATTER.apply((Object)min);
        this.getElement().setProperty("min", minAsString == null ? "" : minAsString);
        this.min = min;
    }

    public LocalDate getMin() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDate max) {
        String maxAsString = (String)FORMATTER.apply((Object)max);
        this.getElement().setProperty("max", maxAsString == null ? "" : maxAsString);
        this.max = max;
    }

    public LocalDate getMax() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.requestI18nUpdate();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setAriaLabelledBy(String labelledBy) {
        this.getElement().setProperty("accessibleNameRef", labelledBy);
    }

    public Optional<String> getAriaLabelledBy() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleNameRef"));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.initConnector();
        this.requestI18nUpdate();
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }

    private void initConnector() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> ui.getPage().executeJs("window.Vaadin.Flow.datepickerConnector.initLazy($0)", new Serializable[]{this.getElement()}));
    }

    public DatePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DatePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.requestI18nUpdate();
    }

    private void requestI18nUpdate() {
        this.getUI().ifPresent(ui -> {
            if (this.pendingI18nUpdate != null) {
                this.pendingI18nUpdate.remove();
            }
            this.pendingI18nUpdate = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
                this.pendingI18nUpdate = null;
                this.executeI18nUpdate();
            });
        });
    }

    private void executeI18nUpdate() {
        JsonObject i18nObject = this.getI18nAsJsonObject();
        Locale appliedLocale = this.getLocale();
        Object languageTag = !appliedLocale.toLanguageTag().contains("lvariant") ? appliedLocale.toLanguageTag() : (appliedLocale.getCountry().isEmpty() ? appliedLocale.getLanguage() : appliedLocale.getLanguage() + "-" + appliedLocale.getCountry());
        this.getElement().callJsFunction("$connector.updateI18n", new Serializable[]{languageTag, i18nObject});
    }

    private JsonObject getI18nAsJsonObject() {
        if (this.i18n == null) {
            return null;
        }
        JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        if (this.i18n.getReferenceDate() != null) {
            i18nObject.put("referenceDate", this.i18n.getReferenceDate().format(DateTimeFormatter.ISO_DATE));
        }
        this.removeNullValuesFromJsonObject(i18nObject);
        return i18nObject;
    }

    private void removeNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public Validator<LocalDate> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.checkValidity((LocalDate)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDate> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    private void fireValidationStatusChangeEvent() {
        ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
        this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<LocalDate>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
    }

    private ValidationResult checkValidity(LocalDate value) {
        boolean hasNonParsableValue;
        boolean bl = hasNonParsableValue = this.valueEquals(value, (LocalDate)this.getEmptyValue()) && this.isInputValuePresent();
        if (hasNonParsableValue) {
            return ValidationResult.error((String)"");
        }
        ValidationResult greaterThanMax = ValidationUtil.checkGreaterThanMax((Comparable)value, (Comparable)this.max);
        if (greaterThanMax.isError()) {
            return greaterThanMax;
        }
        ValidationResult smallerThanMin = ValidationUtil.checkSmallerThanMin((Comparable)value, (Comparable)this.min);
        if (smallerThanMin.isError()) {
            return smallerThanMin;
        }
        return ValidationResult.ok();
    }

    private boolean isInvalid(LocalDate value) {
        ValidationResult requiredValidation = ValidationUtil.checkRequired((boolean)this.required, (Object)value, (Object)((LocalDate)this.getEmptyValue()));
        return requiredValidation.isError() || this.checkValidity(value).isError();
    }

    @Synchronize(property="_hasInputValue", value={"has-input-value-changed"})
    protected boolean isInputValuePresent() {
        return this.getElement().getProperty("_hasInputValue", false);
    }

    public void setValue(LocalDate value) {
        LocalDate oldValue = (LocalDate)this.getValue();
        boolean isOldValueEmpty = this.valueEquals(oldValue, (LocalDate)this.getEmptyValue());
        boolean isNewValueEmpty = this.valueEquals(value, (LocalDate)this.getEmptyValue());
        boolean isValueRemainedEmpty = isOldValueEmpty && isNewValueEmpty;
        boolean isInputValuePresent = this.isInputValuePresent();
        if (isNewValueEmpty) {
            this.getElement().setProperty("_hasInputValue", false);
        }
        super.setValue((Object)value);
        if (isValueRemainedEmpty && isInputValuePresent) {
            this.getElement().executeJs("if (!this.value) this._inputElementValue = ''", new Serializable[0]);
            this.validate();
            this.fireValidationStatusChangeEvent();
        }
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setInitialPosition(LocalDate initialPosition) {
        String initialPositionString = (String)FORMATTER.apply((Object)initialPosition);
        this.getElement().setProperty("initialPosition", initialPositionString == null ? "" : initialPositionString);
    }

    public LocalDate getInitialPosition() {
        return (LocalDate)PARSER.apply((Object)this.getElement().getProperty("initialPosition"));
    }

    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
        this.required = required;
    }

    public void setRequiredIndicatorVisible(boolean required) {
        super.setRequiredIndicatorVisible(required);
        this.required = required;
    }

    public boolean isRequired() {
        return this.getElement().getProperty("required", false);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.getElement().setProperty("showWeekNumbers", weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.getElement().getProperty("showWeekNumbers", false);
    }

    public void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public void open() {
        this.setOpened(true);
    }

    protected void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setName(String name) {
        this.getElement().setProperty("name", name == null ? "" : name);
    }

    public String getName() {
        return this.getElement().getProperty("name");
    }

    public void setManualValidation(boolean enabled) {
        this.manualValidationEnabled = enabled;
    }

    protected void validate() {
        if (!this.manualValidationEnabled) {
            this.setInvalid(this.isInvalid((LocalDate)this.getValue()));
        }
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    public Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent> listener) {
        return this.addListener(InvalidChangeEvent.class, listener);
    }

    public static class DatePickerI18n
    implements Serializable {
        private List<String> monthNames;
        private List<String> weekdays;
        private List<String> weekdaysShort;
        private List<String> dateFormats;
        private int firstDayOfWeek;
        private String today;
        private String cancel;
        private LocalDate referenceDate;

        public List<String> getMonthNames() {
            return this.monthNames;
        }

        public DatePickerI18n setMonthNames(List<String> monthNames) {
            this.monthNames = monthNames;
            return this;
        }

        public List<String> getWeekdays() {
            return this.weekdays;
        }

        public DatePickerI18n setWeekdays(List<String> weekdays) {
            this.weekdays = weekdays;
            return this;
        }

        public List<String> getWeekdaysShort() {
            return this.weekdaysShort;
        }

        public DatePickerI18n setWeekdaysShort(List<String> weekdaysShort) {
            this.weekdaysShort = weekdaysShort;
            return this;
        }

        public List<String> getDateFormats() {
            return this.dateFormats;
        }

        public DatePickerI18n setDateFormat(String dateFormat) {
            this.setDateFormats(dateFormat, new String[0]);
            return this;
        }

        public DatePickerI18n setDateFormats(String primaryFormat, String ... additionalParsingFormats) {
            Objects.requireNonNull(additionalParsingFormats, "Additional parsing formats must not be null");
            if (primaryFormat == null) {
                this.dateFormats = null;
            } else {
                this.dateFormats = new ArrayList<String>();
                this.dateFormats.add(primaryFormat);
                this.dateFormats.addAll(Stream.of(additionalParsingFormats).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            return this;
        }

        public int getFirstDayOfWeek() {
            return this.firstDayOfWeek;
        }

        public DatePickerI18n setFirstDayOfWeek(int firstDayOfWeek) {
            if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
                throw new IllegalArgumentException("First day of the week needs to be in range of 0 to 6.");
            }
            this.firstDayOfWeek = firstDayOfWeek;
            return this;
        }

        public String getToday() {
            return this.today;
        }

        public DatePickerI18n setToday(String today) {
            this.today = today;
            return this;
        }

        public String getCancel() {
            return this.cancel;
        }

        public DatePickerI18n setCancel(String cancel) {
            this.cancel = cancel;
            return this;
        }

        public LocalDate getReferenceDate() {
            return this.referenceDate;
        }

        public DatePickerI18n setReferenceDate(LocalDate referenceDate) {
            this.referenceDate = referenceDate;
            return this;
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<DatePicker> {
        private final boolean opened;

        public OpenedChangeEvent(DatePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    public static class InvalidChangeEvent
    extends ComponentEvent<DatePicker> {
        private final boolean invalid;

        public InvalidChangeEvent(DatePicker source, boolean fromClient) {
            super((Component)source, fromClient);
            this.invalid = source.isInvalid();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

