/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerDatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerTimePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePickerVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasAutoOpen;
import com.vaadin.flow.component.shared.HasClientValidation;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.ValidationUtil;
import com.vaadin.flow.component.shared.internal.ValidationController;
import com.vaadin.flow.component.timepicker.StepsUtil;
import com.vaadin.flow.data.binder.HasValidator;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;

@Tag(value="vaadin-date-time-picker")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.9.2"), @NpmPackage(value="@vaadin/date-time-picker", version="24.9.2")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/date-time-picker/src/vaadin-date-time-picker.js")})
public class DateTimePicker
extends AbstractSinglePropertyField<DateTimePicker, LocalDateTime>
implements Focusable<DateTimePicker>,
HasAutoOpen,
HasClientValidation,
InputField<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>, LocalDateTime>,
HasOverlayClassName,
HasThemeVariant<DateTimePickerVariant>,
HasValidationProperties,
HasValidator<LocalDateTime> {
    private final DateTimePickerDatePicker datePicker = new DateTimePickerDatePicker();
    private final DateTimePickerTimePicker timePicker = new DateTimePickerTimePicker();
    private DatePicker.DatePickerI18n datePickerI18n;
    private DateTimePickerI18n i18n;
    private Locale locale;
    private String dateAriaLabel;
    private String timeAriaLabel;
    private static final SerializableFunction<String, LocalDateTime> PARSER = (SerializableFunction & Serializable)s -> s == null || s.isEmpty() ? null : LocalDateTime.parse(s);
    private static final SerializableFunction<LocalDateTime, String> FORMATTER = (SerializableFunction & Serializable)d -> d == null ? "" : d.truncatedTo(ChronoUnit.MILLIS).toString();
    private LocalDateTime max;
    private LocalDateTime min;
    private final CopyOnWriteArrayList<ValidationStatusChangeListener<LocalDateTime>> validationStatusChangeListeners = new CopyOnWriteArrayList();
    private final Validator<LocalDateTime> defaultValidator = (Validator & Serializable)(value, context) -> {
        ValidationResult requiredResult;
        boolean fromComponent;
        boolean bl = fromComponent = context == null;
        if (this.isInputUnparsable()) {
            return ValidationResult.error((String)this.getI18nErrorMessage(DateTimePickerI18n::getBadInputErrorMessage));
        }
        if (Objects.equals(value, this.getEmptyValue()) && !this.datePicker.isEmpty()) {
            LocalDate maxDate = this.max != null ? this.max.toLocalDate() : null;
            LocalDate minDate = this.min != null ? this.min.toLocalDate() : null;
            ValidationResult maxResult = ValidationUtil.validateMaxConstraint((String)this.getI18nErrorMessage(DateTimePickerI18n::getMaxErrorMessage), (Comparable)((ChronoLocalDate)this.datePicker.getValue()), (Comparable)maxDate);
            if (maxResult.isError()) {
                return maxResult;
            }
            ValidationResult minResult = ValidationUtil.validateMinConstraint((String)this.getI18nErrorMessage(DateTimePickerI18n::getMinErrorMessage), (Comparable)((ChronoLocalDate)this.datePicker.getValue()), (Comparable)minDate);
            if (minResult.isError()) {
                return minResult;
            }
        }
        if (this.isInputIncomplete()) {
            return ValidationResult.error((String)this.getI18nErrorMessage(DateTimePickerI18n::getIncompleteInputErrorMessage));
        }
        if (fromComponent && (requiredResult = ValidationUtil.validateRequiredConstraint((String)this.getI18nErrorMessage(DateTimePickerI18n::getRequiredErrorMessage), (boolean)this.isRequiredIndicatorVisible(), (Object)value, (Object)((LocalDateTime)this.getEmptyValue()))).isError()) {
            return requiredResult;
        }
        ValidationResult maxResult = ValidationUtil.validateMaxConstraint((String)this.getI18nErrorMessage(DateTimePickerI18n::getMaxErrorMessage), (Comparable)value, (Comparable)this.max);
        if (maxResult.isError()) {
            return maxResult;
        }
        ValidationResult minResult = ValidationUtil.validateMinConstraint((String)this.getI18nErrorMessage(DateTimePickerI18n::getMinErrorMessage), (Comparable)value, (Comparable)this.min);
        if (minResult.isError()) {
            return minResult;
        }
        return ValidationResult.ok();
    };
    private ValidationController<DateTimePicker, LocalDateTime> validationController = new ValidationController((Component)this);

    public DateTimePicker() {
        this((LocalDateTime)null);
    }

    public DateTimePicker(String label) {
        this();
        this.setLabel(label);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime) {
        this(initialDateTime);
        this.setLabel(label);
    }

    public DateTimePicker(LocalDateTime initialDateTime) {
        super("value", null, String.class, PARSER, FORMATTER);
        this.setSynchronizedEvent("change");
        if (initialDateTime != null) {
            initialDateTime = this.sanitizeValue(initialDateTime);
            this.setPresentationValue(initialDateTime);
            this.synchronizeChildComponentValues(initialDateTime);
        } else if (this.getElement().getProperty("value") == null) {
            this.setPresentationValue(null);
        }
        SlotUtils.addToSlot((HasElement)this, (String)"date-picker", (Component[])new Component[]{this.datePicker});
        SlotUtils.addToSlot((HasElement)this, (String)"time-picker", (Component[])new Component[]{this.timePicker});
        this.getElement().setProperty("manualValidation", true);
        this.setInvalid(false);
        this.addValidationListeners();
    }

    public DateTimePicker(HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(String label, LocalDateTime initialDateTime, HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>> listener) {
        this(initialDateTime);
        this.setLabel(label);
        this.addValueChangeListener(listener);
    }

    public DateTimePicker(LocalDateTime initialDateTime, Locale locale) {
        this(initialDateTime);
        this.setLocale(locale);
    }

    private void addValidationListeners() {
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)e -> this.validate(true));
        this.datePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.handlePickerValueChange());
        this.timePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.handlePickerValueChange());
    }

    private void handlePickerValueChange() {
        if (!this.isRequiredIndicatorVisible()) {
            return;
        }
        if (this.isInvalid()) {
            return;
        }
        if (this.isEmpty() && this.timePicker.isEmpty() && this.datePicker.isEmpty() && !this.isInputUnparsable()) {
            this.validate(true);
        }
    }

    public void setValue(LocalDateTime value) {
        LocalDateTime oldValue = (LocalDateTime)this.getValue();
        value = this.sanitizeValue(value);
        boolean shouldFireValidationStatusChangeEvent = oldValue == null && value == null && (this.isInputUnparsable() || this.isInputIncomplete());
        super.setValue((Object)value);
        this.synchronizeChildComponentValues(value);
        if (shouldFireValidationStatusChangeEvent) {
            this.validate(true);
        }
    }

    private LocalDateTime sanitizeValue(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return value.truncatedTo(ChronoUnit.MILLIS);
    }

    private void synchronizeChildComponentValues(LocalDateTime value) {
        if (value != null) {
            this.datePicker.setValue(value.toLocalDate());
            this.timePicker.setValue(value.toLocalTime());
        } else {
            this.datePicker.setValue(null);
            this.timePicker.setValue(null);
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.timePicker.setReadOnly(readOnly);
    }

    public void setInvalid(boolean invalid) {
        super.setInvalid(invalid);
        this.datePicker.setInvalid(invalid);
        this.timePicker.setInvalid(invalid);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("accessibleName", ariaLabel);
    }

    public Optional<String> getAriaLabel() {
        return Optional.ofNullable(this.getElement().getProperty("accessibleName"));
    }

    public void setDateAriaLabel(String dateLabel) {
        this.dateAriaLabel = dateLabel;
        this.updateI18n();
    }

    public Optional<String> getDateAriaLabel() {
        return Optional.ofNullable(this.dateAriaLabel);
    }

    public void setTimeAriaLabel(String timeLabel) {
        this.timeAriaLabel = timeLabel;
        this.updateI18n();
    }

    public Optional<String> getTimeAriaLabel() {
        return Optional.ofNullable(this.timeAriaLabel);
    }

    public void setDatePlaceholder(String placeholder) {
        this.datePicker.setPlaceholder(placeholder);
    }

    public String getDatePlaceholder() {
        return this.datePicker.getPlaceholder();
    }

    public void setTimePlaceholder(String placeholder) {
        this.timePicker.setPlaceholder(placeholder);
    }

    public String getTimePlaceholder() {
        return this.timePicker.getPlaceholder();
    }

    public void setStep(Duration step) {
        Objects.requireNonNull(step, "Step cannot be null");
        this.getElement().setProperty("step", StepsUtil.convertDurationToStepsValue((Duration)step));
        this.timePicker.setStep(step);
    }

    public Duration getStep() {
        if (!this.getElement().hasProperty("step")) {
            return StepsUtil.DEFAULT_WEB_COMPONENT_STEP;
        }
        double stepsValue = this.getElement().getProperty("step", 0.0);
        return StepsUtil.convertStepsValueToDuration((double)stepsValue);
    }

    public void setWeekNumbersVisible(boolean weekNumbersVisible) {
        this.datePicker.setWeekNumbersVisible(weekNumbersVisible);
    }

    public boolean isWeekNumbersVisible() {
        return this.datePicker.isWeekNumbersVisible();
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale must not be null.");
        this.locale = locale;
        this.datePicker.setLocale(locale);
        this.timePicker.setLocale(locale);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    private void synchronizeTheme() {
        String theme = this.getThemeName();
        theme = theme != null ? theme : "";
        this.datePicker.getElement().setAttribute("theme", theme);
        this.timePicker.getElement().setAttribute("theme", theme);
    }

    public void addThemeName(String themeName) {
        super.addThemeName(themeName);
        this.synchronizeTheme();
    }

    public boolean removeThemeName(String themeName) {
        boolean result = super.removeThemeName(themeName);
        this.synchronizeTheme();
        return result;
    }

    public void setThemeName(String themeName) {
        super.setThemeName(themeName);
        this.synchronizeTheme();
    }

    public void setThemeName(String themeName, boolean set) {
        super.setThemeName(themeName, set);
        this.synchronizeTheme();
    }

    public void addThemeNames(String ... themeNames) {
        super.addThemeNames(themeNames);
        this.synchronizeTheme();
    }

    public void removeThemeNames(String ... themeNames) {
        super.removeThemeNames(themeNames);
        this.synchronizeTheme();
    }

    private boolean isInputUnparsable() {
        return this.datePicker.isPickerInputUnparsable() || this.timePicker.isPickerInputUnparsable();
    }

    private boolean isInputIncomplete() {
        return this.datePicker.isEmpty() != this.timePicker.isEmpty();
    }

    public Validator<LocalDateTime> getDefaultValidator() {
        return this.defaultValidator;
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<LocalDateTime> listener) {
        return Registration.addAndRemove(this.validationStatusChangeListeners, listener);
    }

    public void setManualValidation(boolean enabled) {
        this.validationController.setManualValidation(enabled);
    }

    protected void validate() {
        this.validationController.validate((Object)((LocalDateTime)this.getValue()));
    }

    private void validate(boolean shouldFireValidationStatusChangeEvent) {
        this.validate();
        if (shouldFireValidationStatusChangeEvent) {
            ValidationStatusChangeEvent event = new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid());
            this.validationStatusChangeListeners.forEach((Consumer<ValidationStatusChangeListener<LocalDateTime>>)((Consumer<ValidationStatusChangeListener>)listener -> listener.validationStatusChanged(event)));
        }
    }

    public void setMin(LocalDateTime min) {
        this.getElement().setProperty("min", (String)FORMATTER.apply((Object)min));
        this.min = min;
    }

    public LocalDateTime getMin() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("min"));
    }

    public void setMax(LocalDateTime max) {
        this.getElement().setProperty("max", (String)FORMATTER.apply((Object)max));
        this.max = max;
    }

    public LocalDateTime getMax() {
        return (LocalDateTime)PARSER.apply((Object)this.getElement().getProperty("max"));
    }

    public DatePicker.DatePickerI18n getDatePickerI18n() {
        return this.datePickerI18n;
    }

    public void setDatePickerI18n(DatePicker.DatePickerI18n i18n) {
        this.datePickerI18n = Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.datePicker.setI18n(i18n);
    }

    public DateTimePickerI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(DateTimePickerI18n i18n) {
        Objects.requireNonNull(i18n, "The i18n properties object should not be null");
        this.i18n = i18n;
        this.updateI18n();
    }

    private void updateI18n() {
        DateTimePickerI18n i18nObject = this.i18n != null ? this.i18n : new DateTimePickerI18n();
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)i18nObject);
        if (this.dateAriaLabel != null) {
            i18nJson.put("dateLabel", this.dateAriaLabel);
        }
        if (this.timeAriaLabel != null) {
            i18nJson.put("timeLabel", this.timeAriaLabel);
        }
        i18nJson.remove("badInputErrorMessage");
        i18nJson.remove("requiredErrorMessage");
        i18nJson.remove("minErrorMessage");
        i18nJson.remove("maxErrorMessage");
        this.getElement().setPropertyJson("i18n", (JsonValue)i18nJson);
    }

    public void setAutoOpen(boolean autoOpen) {
        this.getElement().setProperty("autoOpenDisabled", !autoOpen);
        this.datePicker.setAutoOpen(autoOpen);
        this.timePicker.setAutoOpen(autoOpen);
    }

    private String getI18nErrorMessage(Function<DateTimePickerI18n, String> getter) {
        return Optional.ofNullable(this.i18n).map(getter).orElse("");
    }

    public static class DateTimePickerI18n
    implements Serializable {
        private String dateLabel;
        private String timeLabel;
        private String badInputErrorMessage;
        private String incompleteInputErrorMessage;
        private String requiredErrorMessage;
        private String minErrorMessage;
        private String maxErrorMessage;

        public String getDateLabel() {
            return this.dateLabel;
        }

        public DateTimePickerI18n setDateLabel(String dateLabel) {
            this.dateLabel = dateLabel;
            return this;
        }

        public String getTimeLabel() {
            return this.timeLabel;
        }

        public DateTimePickerI18n setTimeLabel(String timeLabel) {
            this.timeLabel = timeLabel;
            return this;
        }

        public String getBadInputErrorMessage() {
            return this.badInputErrorMessage;
        }

        public DateTimePickerI18n setBadInputErrorMessage(String errorMessage) {
            this.badInputErrorMessage = errorMessage;
            return this;
        }

        public String getIncompleteInputErrorMessage() {
            return this.incompleteInputErrorMessage;
        }

        public DateTimePickerI18n setIncompleteInputErrorMessage(String errorMessage) {
            this.incompleteInputErrorMessage = errorMessage;
            return this;
        }

        public String getRequiredErrorMessage() {
            return this.requiredErrorMessage;
        }

        public DateTimePickerI18n setRequiredErrorMessage(String errorMessage) {
            this.requiredErrorMessage = errorMessage;
            return this;
        }

        public String getMinErrorMessage() {
            return this.minErrorMessage;
        }

        public DateTimePickerI18n setMinErrorMessage(String errorMessage) {
            this.minErrorMessage = errorMessage;
            return this;
        }

        public String getMaxErrorMessage() {
            return this.maxErrorMessage;
        }

        public DateTimePickerI18n setMaxErrorMessage(String errorMessage) {
            this.maxErrorMessage = errorMessage;
            return this;
        }
    }
}

