/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datetimepicker.testbench;

import com.vaadin.testbench.ElementQuery;
import com.vaadin.testbench.HasHelper;
import com.vaadin.testbench.HasLabel;
import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;

@Element(value="vaadin-date-time-picker")
public class DateTimePickerElement
extends TestBenchElement
implements HasLabel,
HasHelper {
    private static final String VALUE_PROPERTY = "value";

    public void clear() {
        this.setDateTime(null);
    }

    public void setDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            this.setValue("");
        } else {
            this.setValue(dateTime.toString());
        }
    }

    public LocalDateTime getDateTime() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return null;
        }
        return LocalDateTime.parse(value);
    }

    public void setDate(LocalDate date) {
        if (date == null) {
            this.setDateValue("");
        } else {
            this.setDateValue(date.toString());
        }
    }

    public LocalDate getDate() {
        String value = this.getDateValue();
        if (value.isEmpty()) {
            return null;
        }
        return LocalDate.parse(value);
    }

    public void setTime(LocalTime time) {
        if (time == null) {
            this.setTimeValue("");
        } else {
            this.setTimeValue(time.truncatedTo(ChronoUnit.MILLIS).toString());
        }
    }

    public LocalTime getTime() {
        String value = this.getTimeValue();
        if (value.isEmpty()) {
            return null;
        }
        return LocalTime.parse(value);
    }

    private void setValue(String value) {
        this.setProperty(VALUE_PROPERTY, value);
    }

    private String getValue() {
        return this.getPropertyString(new String[]{VALUE_PROPERTY});
    }

    private void setDateValue(String value) {
        this.getDatePicker().setProperty(VALUE_PROPERTY, value);
        this.triggerChange(this.getDatePicker());
    }

    private String getDateValue() {
        return this.getDatePicker().getPropertyString(new String[]{VALUE_PROPERTY});
    }

    private void setTimeValue(String value) {
        this.getTimePicker().setProperty(VALUE_PROPERTY, value);
        this.triggerChange(this.getTimePicker());
    }

    private String getTimeValue() {
        return this.getTimePicker().getPropertyString(new String[]{VALUE_PROPERTY});
    }

    private void triggerChange(TestBenchElement pickerElement) {
        this.executeScript("arguments[0].dispatchEvent(new CustomEvent('change', { bubbles: true }));", new Object[]{pickerElement});
    }

    public String getDatePresentation() {
        return this.getDatePicker().getPropertyString(new String[]{"_inputValue"});
    }

    public String getTimePresentation() {
        return this.getTimePicker().getPropertyString(new String[]{"inputElement", VALUE_PROPERTY});
    }

    public boolean isAutoOpen() {
        return this.getPropertyBoolean(new String[]{"autoOpenDisabled"}) == false;
    }

    private TestBenchElement getDatePicker() {
        return this.$("vaadin-date-picker").attribute("slot", "date-picker").first();
    }

    private TestBenchElement getTimePicker() {
        return this.$("vaadin-time-picker").attribute("slot", "time-picker").first();
    }

    public TestBenchElement getHelperComponent() {
        TestBenchElement last;
        ElementQuery query = this.$(TestBenchElement.class).attribute("slot", "helper");
        if (query.exists() && !"slot".equals((last = query.last()).getTagName()) && this.equals(last.getPropertyElement(new String[]{"parentElement"}))) {
            return last;
        }
        return null;
    }
}

