/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.details;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-details")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.0.7"), @NpmPackage(value="@vaadin/details", version="23.0.7"), @NpmPackage(value="@vaadin/vaadin-details", version="23.0.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/details/src/vaadin-details.js")})
public class Details
extends Component
implements HasEnabled,
HasTheme,
HasStyle,
HasSize {
    private Component summary;
    private final Div contentContainer = new Div();

    public Details() {
        this.getElement().appendChild(new Element[]{this.contentContainer.getElement()});
    }

    public Details(String summary, Component content) {
        this();
        this.setSummaryText(summary);
        this.setContent(content);
    }

    public Details(Component summary, Component content) {
        this();
        this.setSummary(summary);
        this.setContent(content);
    }

    public void setSummary(Component summary) {
        if (this.summary != null) {
            this.summary.getElement().removeAttribute("slot");
            this.summary.getElement().removeFromParent();
        }
        this.summary = summary;
        if (summary == null) {
            return;
        }
        summary.getElement().setAttribute("slot", "summary");
        this.getElement().appendChild(new Element[]{summary.getElement()});
    }

    public Component getSummary() {
        return this.summary;
    }

    public void setSummaryText(String summary) {
        if (summary == null) {
            summary = "";
        }
        this.setSummary((Component)new Span(summary));
    }

    public String getSummaryText() {
        return this.summary.getElement().getText();
    }

    public void setContent(Component content) {
        this.contentContainer.getElement().removeAllChildren();
        if (content == null) {
            return;
        }
        this.contentContainer.add(new Component[]{content});
    }

    public void addContent(Component ... components) {
        this.contentContainer.add(components);
    }

    public Stream<Component> getContent() {
        return this.contentContainer.getChildren();
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public void addThemeVariants(DetailsVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(DetailsVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(DetailsVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(DetailsVariant::getVariantName).collect(Collectors.toList()));
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return ComponentUtil.addListener((Component)this, OpenedChangeEvent.class, listener);
    }

    @DomEvent(value="opened-changed")
    public static class OpenedChangeEvent
    extends ComponentEvent<Details> {
        private final boolean opened;

        public OpenedChangeEvent(Details source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

