/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.details;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Stream;

@Tag(value="vaadin-details")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.6.7"), @NpmPackage(value="@vaadin/details", version="24.6.7")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/details/src/vaadin-details.js")})
public class Details
extends Component
implements HasComponents,
HasSize,
HasThemeVariant<DetailsVariant>,
HasTooltip {
    private Component summary;
    private final Component summaryContainer;
    private final Div contentContainer = new Div();

    public Details() {
        this.getElement().appendChild(new Element[]{this.contentContainer.getElement()});
        this.summaryContainer = this.createSummaryContainer();
        SlotUtils.addToSlot((HasElement)this, (String)"summary", (Component[])new Component[]{this.summaryContainer});
        if (this.getElement().getPropertyRaw("opened") == null) {
            this.setOpened(false);
        }
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> this.fireEvent(new OpenedChangeEvent(this, event.isUserOriginated())));
    }

    public Details(String summary) {
        this();
        this.setSummaryText(summary);
    }

    public Details(Component summary) {
        this();
        this.setSummary(summary);
    }

    public Details(String summary, Component content) {
        this();
        this.setSummaryText(summary);
        this.add(new Component[]{content});
    }

    public Details(Component summary, Component content) {
        this();
        this.setSummary(summary);
        this.add(new Component[]{content});
    }

    public Details(String summary, Component ... components) {
        this(summary);
        this.add(components);
    }

    public Details(Component summary, Component ... components) {
        this(summary);
        this.add(components);
    }

    protected Component createSummaryContainer() {
        return new DetailsSummary();
    }

    public void setSummary(Component summary) {
        this.summaryContainer.getElement().removeAllChildren();
        if (summary == null) {
            return;
        }
        this.summary = summary;
        this.summaryContainer.getElement().appendChild(new Element[]{summary.getElement()});
    }

    public Component getSummary() {
        return this.summary;
    }

    public void setSummaryText(String summary) {
        if (summary == null) {
            summary = "";
        }
        this.setSummary((Component)new Span(summary));
    }

    public String getSummaryText() {
        return this.summary == null ? "" : this.summary.getElement().getText();
    }

    @Deprecated
    public void setContent(Component content) {
        this.removeAll();
        this.add(new Component[]{content});
    }

    @Deprecated
    public void addContent(Component ... components) {
        this.add(components);
    }

    public void add(Collection<Component> components) {
        this.contentContainer.add(components);
    }

    public void add(String text) {
        this.contentContainer.add(text);
    }

    public void remove(Collection<Component> components) {
        this.contentContainer.remove(components);
    }

    public void removeAll() {
        this.contentContainer.removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.contentContainer.addComponentAtIndex(index, component);
    }

    public Stream<Component> getContent() {
        return this.contentContainer.getChildren();
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.addListener(OpenedChangeEvent.class, listener);
    }

    @Tag(value="vaadin-details-summary")
    static class DetailsSummary
    extends Component {
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Details> {
        private final boolean opened;

        public OpenedChangeEvent(Details source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

