import{i as i$2,r as registerStyles$1,T as ThemableMixin,e as e$2,s as s$2,y,a as i$3,b as ThemePropertyMixin,Z as Z$1,c as i$4,d as b,t as t$2,x,f as e$4,w as w$1,g as color$h,h as typography,j as themeRegistry,k as r$1}from"./indexhtml-42583338.js";import{e as e$3}from"./custom-element-73470d87.js";/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$b=document.createElement("template");template$b.innerHTML=`
  <style>
    @font-face {
      font-family: 'lumo-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,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) format('woff');
      font-weight: normal;
      font-style: normal;
    }

    html {
      --lumo-icons-align-center: "\\ea01";
      --lumo-icons-align-left: "\\ea02";
      --lumo-icons-align-right: "\\ea03";
      --lumo-icons-angle-down: "\\ea04";
      --lumo-icons-angle-left: "\\ea05";
      --lumo-icons-angle-right: "\\ea06";
      --lumo-icons-angle-up: "\\ea07";
      --lumo-icons-arrow-down: "\\ea08";
      --lumo-icons-arrow-left: "\\ea09";
      --lumo-icons-arrow-right: "\\ea0a";
      --lumo-icons-arrow-up: "\\ea0b";
      --lumo-icons-bar-chart: "\\ea0c";
      --lumo-icons-bell: "\\ea0d";
      --lumo-icons-calendar: "\\ea0e";
      --lumo-icons-checkmark: "\\ea0f";
      --lumo-icons-chevron-down: "\\ea10";
      --lumo-icons-chevron-left: "\\ea11";
      --lumo-icons-chevron-right: "\\ea12";
      --lumo-icons-chevron-up: "\\ea13";
      --lumo-icons-clock: "\\ea14";
      --lumo-icons-cog: "\\ea15";
      --lumo-icons-cross: "\\ea16";
      --lumo-icons-download: "\\ea17";
      --lumo-icons-dropdown: "\\ea18";
      --lumo-icons-edit: "\\ea19";
      --lumo-icons-error: "\\ea1a";
      --lumo-icons-eye: "\\ea1b";
      --lumo-icons-eye-disabled: "\\ea1c";
      --lumo-icons-menu: "\\ea1d";
      --lumo-icons-minus: "\\ea1e";
      --lumo-icons-ordered-list: "\\ea1f";
      --lumo-icons-phone: "\\ea20";
      --lumo-icons-photo: "\\ea21";
      --lumo-icons-play: "\\ea22";
      --lumo-icons-plus: "\\ea23";
      --lumo-icons-redo: "\\ea24";
      --lumo-icons-reload: "\\ea25";
      --lumo-icons-search: "\\ea26";
      --lumo-icons-undo: "\\ea27";
      --lumo-icons-unordered-list: "\\ea28";
      --lumo-icons-upload: "\\ea29";
      --lumo-icons-user: "\\ea2a";
    }
  </style>
`;document.head.appendChild(template$b.content);/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const sizing=i$2`
  :host {
    --lumo-size-xs: 1.625rem;
    --lumo-size-s: 1.875rem;
    --lumo-size-m: 2.25rem;
    --lumo-size-l: 2.75rem;
    --lumo-size-xl: 3.5rem;

    /* Icons */
    --lumo-icon-size-s: 1.25em;
    --lumo-icon-size-m: 1.5em;
    --lumo-icon-size-l: 2.25em;
    /* For backwards compatibility */
    --lumo-icon-size: var(--lumo-icon-size-m);
  }
`,$tpl$1=document.createElement("template");$tpl$1.innerHTML=`<style>${sizing.toString().replace(":host","html")}</style>`;document.head.appendChild($tpl$1.content);registerStyles$1("vaadin-checkbox",i$2`
    :host {
      color: var(--lumo-body-text-color);
      font-size: var(--lumo-font-size-m);
      font-family: var(--lumo-font-family);
      line-height: var(--lumo-line-height-s);
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
      -webkit-tap-highlight-color: transparent;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      cursor: default;
      outline: none;
      --_checkbox-size: var(--vaadin-checkbox-size, calc(var(--lumo-size-m) / 2));
    }

    :host([has-label]) ::slotted(label) {
      padding-block: var(--lumo-space-xs);
      padding-inline: var(--lumo-space-xs) var(--lumo-space-s);
    }

    [part='checkbox'] {
      width: var(--_checkbox-size);
      height: var(--_checkbox-size);
      margin: var(--lumo-space-xs);
      position: relative;
      border-radius: var(--lumo-border-radius-s);
      background-color: var(--lumo-contrast-20pct);
      transition: transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2), background-color 0.15s;
      cursor: var(--lumo-clickable-cursor);
    }

    :host([indeterminate]) [part='checkbox'],
    :host([checked]) [part='checkbox'] {
      background-color: var(--lumo-primary-color);
    }

    /* Checkmark */
    [part='checkbox']::after {
      pointer-events: none;
      font-family: 'lumo-icons';
      content: var(--lumo-icons-checkmark);
      color: var(--lumo-primary-contrast-color);
      font-size: calc(var(--_checkbox-size) + 2px);
      line-height: 1;
      position: absolute;
      top: -1px;
      left: -1px;
      contain: content;
      opacity: 0;
    }

    :host([checked]) [part='checkbox']::after {
      opacity: 1;
    }

    /* Indeterminate checkmark */
    :host([indeterminate]) [part='checkbox']::after {
      content: '';
      opacity: 1;
      top: 45%;
      height: 10%;
      left: 22%;
      right: 22%;
      width: auto;
      border: 0;
      background-color: var(--lumo-primary-contrast-color);
    }

    /* Focus ring */
    :host([focus-ring]) [part='checkbox'] {
      box-shadow: 0 0 0 1px var(--lumo-base-color), 0 0 0 3px var(--lumo-primary-color-50pct);
    }

    /* Disabled */
    :host([disabled]) {
      pointer-events: none;
      color: var(--lumo-disabled-text-color);
    }

    :host([disabled]) ::slotted(label) {
      color: inherit;
    }

    :host([disabled]) [part='checkbox'] {
      background-color: var(--lumo-contrast-10pct);
    }

    :host([disabled]) [part='checkbox']::after {
      color: var(--lumo-contrast-30pct);
    }

    :host([indeterminate][disabled]) [part='checkbox']::after {
      background-color: var(--lumo-contrast-30pct);
    }

    /* RTL specific styles */
    :host([dir='rtl'][has-label]) ::slotted(label) {
      padding: var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-xs) var(--lumo-space-s);
    }

    /* Used for activation "halo" */
    [part='checkbox']::before {
      pointer-events: none;
      color: transparent;
      width: 100%;
      height: 100%;
      line-height: var(--_checkbox-size);
      border-radius: inherit;
      background-color: inherit;
      transform: scale(1.4);
      opacity: 0;
      transition: transform 0.1s, opacity 0.8s;
    }

    /* Hover */
    :host(:not([checked]):not([indeterminate]):not([disabled]):hover) [part='checkbox'] {
      background-color: var(--lumo-contrast-30pct);
    }

    /* Disable hover for touch devices */
    @media (pointer: coarse) {
      :host(:not([checked]):not([indeterminate]):not([disabled]):hover) [part='checkbox'] {
        background-color: var(--lumo-contrast-20pct);
      }
    }

    /* Active */
    :host([active]) [part='checkbox'] {
      transform: scale(0.9);
      transition-duration: 0.05s;
    }

    :host([active][checked]) [part='checkbox'] {
      transform: scale(1.1);
    }

    :host([active]:not([checked])) [part='checkbox']::before {
      transition-duration: 0.01s, 0.01s;
      transform: scale(0);
      opacity: 0.4;
    }
  `,{moduleId:"lumo-checkbox"});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/window.JSCompiler_renameProperty=function(j,E){return j};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let CSS_URL_RX=/(url\()([^)]*)(\))/g,ABS_URL=/(^\/[^\/])|(^#)|(^[\w-\d]*:)/,workingURL,resolveDoc;function resolveUrl(j,E){if(j&&ABS_URL.test(j)||j==="//")return j;if(workingURL===void 0){workingURL=!1;try{const a=new URL("b","http://a");a.pathname="c%20d",workingURL=a.href==="http://a/c%20d"}catch{}}if(E||(E=document.baseURI||window.location.href),workingURL)try{return new URL(j,E).href}catch{return j}return resolveDoc||(resolveDoc=document.implementation.createHTMLDocument("temp"),resolveDoc.base=resolveDoc.createElement("base"),resolveDoc.head.appendChild(resolveDoc.base),resolveDoc.anchor=resolveDoc.createElement("a"),resolveDoc.body.appendChild(resolveDoc.anchor)),resolveDoc.base.href=E,resolveDoc.anchor.href=j,resolveDoc.anchor.href||j}function resolveCss(j,E){return j.replace(CSS_URL_RX,function(a,k,tt,et){return k+"'"+resolveUrl(tt.replace(/["']/g,""),E)+"'"+et})}function pathFromUrl(j){return j.substring(0,j.lastIndexOf("/")+1)}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const useShadow=!window.ShadyDOM||!window.ShadyDOM.inUse;Boolean(!window.ShadyCSS||window.ShadyCSS.nativeCss);const supportsAdoptingStyleSheets=useShadow&&"adoptedStyleSheets"in Document.prototype&&"replaceSync"in CSSStyleSheet.prototype&&(()=>{try{const j=new CSSStyleSheet;j.replaceSync("");const E=document.createElement("div");return E.attachShadow({mode:"open"}),E.shadowRoot.adoptedStyleSheets=[j],E.shadowRoot.adoptedStyleSheets[0]===j}catch{return!1}})();let rootPath=window.Polymer&&window.Polymer.rootPath||pathFromUrl(document.baseURI||window.location.href),sanitizeDOMValue=window.Polymer&&window.Polymer.sanitizeDOMValue||void 0;window.Polymer&&window.Polymer.setPassiveTouchGestures;let strictTemplatePolicy=window.Polymer&&window.Polymer.strictTemplatePolicy||!1,allowTemplateFromDomModule=window.Polymer&&window.Polymer.allowTemplateFromDomModule||!1,legacyOptimizations=window.Polymer&&window.Polymer.legacyOptimizations||!1,legacyWarnings=window.Polymer&&window.Polymer.legacyWarnings||!1,syncInitialRender=window.Polymer&&window.Polymer.syncInitialRender||!1,legacyUndefined=window.Polymer&&window.Polymer.legacyUndefined||!1,orderedComputed=window.Polymer&&window.Polymer.orderedComputed||!1,removeNestedTemplates=window.Polymer&&window.Polymer.removeNestedTemplates||!1,fastDomIf=window.Polymer&&window.Polymer.fastDomIf||!1,suppressTemplateNotifications=window.Polymer&&window.Polymer.suppressTemplateNotifications||!1;window.Polymer&&window.Polymer.legacyNoObservedAttributes;let useAdoptedStyleSheetsWithBuiltCSS=window.Polymer&&window.Polymer.useAdoptedStyleSheetsWithBuiltCSS||!1;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let dedupeId$1=0;const dedupingMixin=function(j){let E=j.__mixinApplications;E||(E=new WeakMap,j.__mixinApplications=E);let a=dedupeId$1++;function k(tt){let et=tt.__mixinSet;if(et&&et[a])return tt;let rt=E,nt=rt.get(tt);if(!nt){nt=j(tt),rt.set(tt,nt);let ot=Object.create(nt.__mixinSet||et||null);ot[a]=!0,nt.__mixinSet=ot}return nt}return k};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let modules={},lcModules={};function setModule(j,E){modules[j]=lcModules[j.toLowerCase()]=E}function findModule(j){return modules[j]||lcModules[j.toLowerCase()]}function styleOutsideTemplateCheck(j){j.querySelector("style")&&console.warn("dom-module %s has style outside template",j.id)}class DomModule extends HTMLElement{static get observedAttributes(){return["id"]}static import(E,a){if(E){let k=findModule(E);return k&&a?k.querySelector(a):k}return null}attributeChangedCallback(E,a,k,tt){a!==k&&this.register()}get assetpath(){if(!this.__assetpath){const E=window.HTMLImports&&HTMLImports.importForElement?HTMLImports.importForElement(this)||document:this.ownerDocument,a=resolveUrl(this.getAttribute("assetpath")||"",E.baseURI);this.__assetpath=pathFromUrl(a)}return this.__assetpath}register(E){if(E=E||this.id,E){if(strictTemplatePolicy&&findModule(E)!==void 0)throw setModule(E,null),new Error(`strictTemplatePolicy: dom-module ${E} re-registered`);this.id=E,setModule(E,this),styleOutsideTemplateCheck(this)}}}DomModule.prototype.modules=modules;customElements.define("dom-module",DomModule);/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const MODULE_STYLE_LINK_SELECTOR="link[rel=import][type~=css]",INCLUDE_ATTR="include",SHADY_UNSCOPED_ATTR="shady-unscoped";function importModule(j){return DomModule.import(j)}function styleForImport(j){let E=j.body?j.body:j;const a=resolveCss(E.textContent,j.baseURI),k=document.createElement("style");return k.textContent=a,k}function stylesFromModules(j){const E=j.trim().split(/\s+/),a=[];for(let k=0;k<E.length;k++)a.push(...stylesFromModule(E[k]));return a}function stylesFromModule(j){const E=importModule(j);if(!E)return console.warn("Could not find style data in module named",j),[];if(E._styles===void 0){const a=[];a.push(..._stylesFromModuleImports(E));const k=E.querySelector("template");k&&a.push(...stylesFromTemplate(k,E.assetpath)),E._styles=a}return E._styles}function stylesFromTemplate(j,E){if(!j._styles){const a=[],k=j.content.querySelectorAll("style");for(let tt=0;tt<k.length;tt++){let et=k[tt],rt=et.getAttribute(INCLUDE_ATTR);rt&&a.push(...stylesFromModules(rt).filter(function(nt,ot,st){return st.indexOf(nt)===ot})),E&&(et.textContent=resolveCss(et.textContent,E)),a.push(et)}j._styles=a}return j._styles}function stylesFromModuleImports(j){let E=importModule(j);return E?_stylesFromModuleImports(E):[]}function _stylesFromModuleImports(j){const E=[],a=j.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);for(let k=0;k<a.length;k++){let tt=a[k];if(tt.import){const et=tt.import,rt=tt.hasAttribute(SHADY_UNSCOPED_ATTR);if(rt&&!et._unscopedStyle){const nt=styleForImport(et);nt.setAttribute(SHADY_UNSCOPED_ATTR,""),et._unscopedStyle=nt}else et._style||(et._style=styleForImport(et));E.push(rt?et._unscopedStyle:et._style)}}return E}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const wrap$f=window.ShadyDOM&&window.ShadyDOM.noPatch&&window.ShadyDOM.wrap?window.ShadyDOM.wrap:window.ShadyDOM?j=>ShadyDOM.patch(j):j=>j;/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isPath(j){return j.indexOf(".")>=0}function root(j){let E=j.indexOf(".");return E===-1?j:j.slice(0,E)}function isAncestor(j,E){return j.indexOf(E+".")===0}function isDescendant(j,E){return E.indexOf(j+".")===0}function translate$1(j,E,a){return E+a.slice(j.length)}function matches(j,E){return j===E||isAncestor(j,E)||isDescendant(j,E)}function normalize$1(j){if(Array.isArray(j)){let E=[];for(let a=0;a<j.length;a++){let k=j[a].toString().split(".");for(let tt=0;tt<k.length;tt++)E.push(k[tt])}return E.join(".")}else return j}function split(j){return Array.isArray(j)?normalize$1(j).split("."):j.toString().split(".")}function get$6(j,E,a){let k=j,tt=split(E);for(let et=0;et<tt.length;et++){if(!k)return;let rt=tt[et];k=k[rt]}return a&&(a.path=tt.join(".")),k}function set$1(j,E,a){let k=j,tt=split(E),et=tt[tt.length-1];if(tt.length>1){for(let rt=0;rt<tt.length-1;rt++){let nt=tt[rt];if(k=k[nt],!k)return}k[et]=a}else k[E]=a;return tt.join(".")}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const caseMap={},DASH_TO_CAMEL=/-[a-z]/g,CAMEL_TO_DASH=/([A-Z])/g;function dashToCamelCase(j){return caseMap[j]||(caseMap[j]=j.indexOf("-")<0?j:j.replace(DASH_TO_CAMEL,E=>E[1].toUpperCase()))}function camelToDashCase(j){return caseMap[j]||(caseMap[j]=j.replace(CAMEL_TO_DASH,"-$1").toLowerCase())}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let microtaskCurrHandle$1=0,microtaskLastHandle$1=0,microtaskCallbacks$1=[],microtaskNodeContent$1=0,microtaskScheduled$1=!1,microtaskNode$1=document.createTextNode("");new window.MutationObserver(microtaskFlush$1).observe(microtaskNode$1,{characterData:!0});function microtaskFlush$1(){microtaskScheduled$1=!1;const j=microtaskCallbacks$1.length;for(let E=0;E<j;E++){let a=microtaskCallbacks$1[E];if(a)try{a()}catch(k){setTimeout(()=>{throw k})}}microtaskCallbacks$1.splice(0,j),microtaskLastHandle$1+=j}const timeOut$1={after(j){return{run(E){return window.setTimeout(E,j)},cancel(E){window.clearTimeout(E)}}},run(j,E){return window.setTimeout(j,E)},cancel(j){window.clearTimeout(j)}},animationFrame$1={run(j){return window.requestAnimationFrame(j)},cancel(j){window.cancelAnimationFrame(j)}},idlePeriod$1={run(j){return window.requestIdleCallback?window.requestIdleCallback(j):window.setTimeout(j,16)},cancel(j){window.cancelIdleCallback?window.cancelIdleCallback(j):window.clearTimeout(j)}},microTask$1={run(j){return microtaskScheduled$1||(microtaskScheduled$1=!0,microtaskNode$1.textContent=microtaskNodeContent$1++),microtaskCallbacks$1.push(j),microtaskCurrHandle$1++},cancel(j){const E=j-microtaskLastHandle$1;if(E>=0){if(!microtaskCallbacks$1[E])throw new Error("invalid async handle: "+j);microtaskCallbacks$1[E]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const microtask=microTask$1,PropertiesChanged=dedupingMixin(j=>{class E extends j{static createProperties(k){const tt=this.prototype;for(let et in k)et in tt||tt._createPropertyAccessor(et)}static attributeNameForProperty(k){return k.toLowerCase()}static typeForProperty(k){}_createPropertyAccessor(k,tt){this._addPropertyToAttributeMap(k),this.hasOwnProperty(JSCompiler_renameProperty("__dataHasAccessor",this))||(this.__dataHasAccessor=Object.assign({},this.__dataHasAccessor)),this.__dataHasAccessor[k]||(this.__dataHasAccessor[k]=!0,this._definePropertyAccessor(k,tt))}_addPropertyToAttributeMap(k){this.hasOwnProperty(JSCompiler_renameProperty("__dataAttributes",this))||(this.__dataAttributes=Object.assign({},this.__dataAttributes));let tt=this.__dataAttributes[k];return tt||(tt=this.constructor.attributeNameForProperty(k),this.__dataAttributes[tt]=k),tt}_definePropertyAccessor(k,tt){Object.defineProperty(this,k,{get(){return this.__data[k]},set:tt?function(){}:function(et){this._setPendingProperty(k,et,!0)&&this._invalidateProperties()}})}constructor(){super(),this.__dataEnabled=!1,this.__dataReady=!1,this.__dataInvalid=!1,this.__data={},this.__dataPending=null,this.__dataOld=null,this.__dataInstanceProps=null,this.__dataCounter=0,this.__serializing=!1,this._initializeProperties()}ready(){this.__dataReady=!0,this._flushProperties()}_initializeProperties(){for(let k in this.__dataHasAccessor)this.hasOwnProperty(k)&&(this.__dataInstanceProps=this.__dataInstanceProps||{},this.__dataInstanceProps[k]=this[k],delete this[k])}_initializeInstanceProperties(k){Object.assign(this,k)}_setProperty(k,tt){this._setPendingProperty(k,tt)&&this._invalidateProperties()}_getProperty(k){return this.__data[k]}_setPendingProperty(k,tt,et){let rt=this.__data[k],nt=this._shouldPropertyChange(k,tt,rt);return nt&&(this.__dataPending||(this.__dataPending={},this.__dataOld={}),this.__dataOld&&!(k in this.__dataOld)&&(this.__dataOld[k]=rt),this.__data[k]=tt,this.__dataPending[k]=tt),nt}_isPropertyPending(k){return!!(this.__dataPending&&this.__dataPending.hasOwnProperty(k))}_invalidateProperties(){!this.__dataInvalid&&this.__dataReady&&(this.__dataInvalid=!0,microtask.run(()=>{this.__dataInvalid&&(this.__dataInvalid=!1,this._flushProperties())}))}_enableProperties(){this.__dataEnabled||(this.__dataEnabled=!0,this.__dataInstanceProps&&(this._initializeInstanceProperties(this.__dataInstanceProps),this.__dataInstanceProps=null),this.ready())}_flushProperties(){this.__dataCounter++;const k=this.__data,tt=this.__dataPending,et=this.__dataOld;this._shouldPropertiesChange(k,tt,et)&&(this.__dataPending=null,this.__dataOld=null,this._propertiesChanged(k,tt,et)),this.__dataCounter--}_shouldPropertiesChange(k,tt,et){return Boolean(tt)}_propertiesChanged(k,tt,et){}_shouldPropertyChange(k,tt,et){return et!==tt&&(et===et||tt===tt)}attributeChangedCallback(k,tt,et,rt){tt!==et&&this._attributeToProperty(k,et),super.attributeChangedCallback&&super.attributeChangedCallback(k,tt,et,rt)}_attributeToProperty(k,tt,et){if(!this.__serializing){const rt=this.__dataAttributes,nt=rt&&rt[k]||k;this[nt]=this._deserializeValue(tt,et||this.constructor.typeForProperty(nt))}}_propertyToAttribute(k,tt,et){this.__serializing=!0,et=arguments.length<3?this[k]:et,this._valueToNodeAttribute(this,et,tt||this.constructor.attributeNameForProperty(k)),this.__serializing=!1}_valueToNodeAttribute(k,tt,et){const rt=this._serializeValue(tt);(et==="class"||et==="name"||et==="slot")&&(k=wrap$f(k)),rt===void 0?k.removeAttribute(et):k.setAttribute(et,rt===""&&window.trustedTypes?window.trustedTypes.emptyScript:rt)}_serializeValue(k){switch(typeof k){case"boolean":return k?"":void 0;default:return k!=null?k.toString():void 0}}_deserializeValue(k,tt){switch(tt){case Boolean:return k!==null;case Number:return Number(k);default:return k}}}return E});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const nativeProperties={};let proto=HTMLElement.prototype;for(;proto;){let j=Object.getOwnPropertyNames(proto);for(let E=0;E<j.length;E++)nativeProperties[j[E]]=!0;proto=Object.getPrototypeOf(proto)}const isTrustedType=(()=>window.trustedTypes?j=>trustedTypes.isHTML(j)||trustedTypes.isScript(j)||trustedTypes.isScriptURL(j):()=>!1)();function saveAccessorValue(j,E){if(!nativeProperties[E]){let a=j[E];a!==void 0&&(j.__data?j._setPendingProperty(E,a):(j.__dataProto?j.hasOwnProperty(JSCompiler_renameProperty("__dataProto",j))||(j.__dataProto=Object.create(j.__dataProto)):j.__dataProto={},j.__dataProto[E]=a))}}const PropertyAccessors=dedupingMixin(j=>{const E=PropertiesChanged(j);class a extends E{static createPropertiesForAttributes(){let tt=this.observedAttributes;for(let et=0;et<tt.length;et++)this.prototype._createPropertyAccessor(dashToCamelCase(tt[et]))}static attributeNameForProperty(tt){return camelToDashCase(tt)}_initializeProperties(){this.__dataProto&&(this._initializeProtoProperties(this.__dataProto),this.__dataProto=null),super._initializeProperties()}_initializeProtoProperties(tt){for(let et in tt)this._setProperty(et,tt[et])}_ensureAttribute(tt,et){const rt=this;rt.hasAttribute(tt)||this._valueToNodeAttribute(rt,et,tt)}_serializeValue(tt){switch(typeof tt){case"object":if(tt instanceof Date)return tt.toString();if(tt){if(isTrustedType(tt))return tt;try{return JSON.stringify(tt)}catch{return""}}default:return super._serializeValue(tt)}}_deserializeValue(tt,et){let rt;switch(et){case Object:try{rt=JSON.parse(tt)}catch{rt=tt}break;case Array:try{rt=JSON.parse(tt)}catch{rt=null,console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${tt}`)}break;case Date:rt=isNaN(tt)?String(tt):Number(tt),rt=new Date(rt);break;default:rt=super._deserializeValue(tt,et);break}return rt}_definePropertyAccessor(tt,et){saveAccessorValue(this,tt),super._definePropertyAccessor(tt,et)}_hasAccessor(tt){return this.__dataHasAccessor&&this.__dataHasAccessor[tt]}_isPropertyPending(tt){return Boolean(this.__dataPending&&tt in this.__dataPending)}}return a});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const templateExtensions={"dom-if":!0,"dom-repeat":!0};let placeholderBugDetect=!1,placeholderBug=!1;function hasPlaceholderBug(){if(!placeholderBugDetect){placeholderBugDetect=!0;const j=document.createElement("textarea");j.placeholder="a",placeholderBug=j.placeholder===j.textContent}return placeholderBug}function fixPlaceholder(j){hasPlaceholderBug()&&j.localName==="textarea"&&j.placeholder&&j.placeholder===j.textContent&&(j.textContent=null)}const copyAttributeWithTemplateEventPolicy=(()=>{const j=window.trustedTypes&&window.trustedTypes.createPolicy("polymer-template-event-attribute-policy",{createScript:E=>E});return(E,a,k)=>{const tt=a.getAttribute(k);if(j&&k.startsWith("on-")){E.setAttribute(k,j.createScript(tt,k));return}E.setAttribute(k,tt)}})();function wrapTemplateExtension(j){let E=j.getAttribute("is");if(E&&templateExtensions[E]){let a=j;for(a.removeAttribute("is"),j=a.ownerDocument.createElement(E),a.parentNode.replaceChild(j,a),j.appendChild(a);a.attributes.length;){const{name:k}=a.attributes[0];copyAttributeWithTemplateEventPolicy(j,a,k),a.removeAttribute(k)}}return j}function findTemplateNode(j,E){let a=E.parentInfo&&findTemplateNode(j,E.parentInfo);if(a){for(let k=a.firstChild,tt=0;k;k=k.nextSibling)if(E.parentIndex===tt++)return k}else return j}function applyIdToMap(j,E,a,k){k.id&&(E[k.id]=a)}function applyEventListener(j,E,a){if(a.events&&a.events.length)for(let k=0,tt=a.events,et;k<tt.length&&(et=tt[k]);k++)j._addMethodEventListenerToNode(E,et.name,et.value,j)}function applyTemplateInfo(j,E,a,k){a.templateInfo&&(E._templateInfo=a.templateInfo,E._parentTemplateInfo=k)}function createNodeEventHandler(j,E,a){return j=j._methodHost||j,function(tt){j[a]?j[a](tt,tt.detail):console.warn("listener method `"+a+"` not defined")}}const TemplateStamp=dedupingMixin(j=>{class E extends j{static _parseTemplate(k,tt){if(!k._templateInfo){let et=k._templateInfo={};et.nodeInfoList=[],et.nestedTemplate=Boolean(tt),et.stripWhiteSpace=tt&&tt.stripWhiteSpace||k.hasAttribute&&k.hasAttribute("strip-whitespace"),this._parseTemplateContent(k,et,{parent:null})}return k._templateInfo}static _parseTemplateContent(k,tt,et){return this._parseTemplateNode(k.content,tt,et)}static _parseTemplateNode(k,tt,et){let rt=!1,nt=k;return nt.localName=="template"&&!nt.hasAttribute("preserve-content")?rt=this._parseTemplateNestedTemplate(nt,tt,et)||rt:nt.localName==="slot"&&(tt.hasInsertionPoint=!0),fixPlaceholder(nt),nt.firstChild&&this._parseTemplateChildNodes(nt,tt,et),nt.hasAttributes&&nt.hasAttributes()&&(rt=this._parseTemplateNodeAttributes(nt,tt,et)||rt),rt||et.noted}static _parseTemplateChildNodes(k,tt,et){if(!(k.localName==="script"||k.localName==="style"))for(let rt=k.firstChild,nt=0,ot;rt;rt=ot){if(rt.localName=="template"&&(rt=wrapTemplateExtension(rt)),ot=rt.nextSibling,rt.nodeType===Node.TEXT_NODE){let lt=ot;for(;lt&&lt.nodeType===Node.TEXT_NODE;)rt.textContent+=lt.textContent,ot=lt.nextSibling,k.removeChild(lt),lt=ot;if(tt.stripWhiteSpace&&!rt.textContent.trim()){k.removeChild(rt);continue}}let st={parentIndex:nt,parentInfo:et};this._parseTemplateNode(rt,tt,st)&&(st.infoIndex=tt.nodeInfoList.push(st)-1),rt.parentNode&&nt++}}static _parseTemplateNestedTemplate(k,tt,et){let rt=k,nt=this._parseTemplate(rt,tt);return(nt.content=rt.content.ownerDocument.createDocumentFragment()).appendChild(rt.content),et.templateInfo=nt,!0}static _parseTemplateNodeAttributes(k,tt,et){let rt=!1,nt=Array.from(k.attributes);for(let ot=nt.length-1,st;st=nt[ot];ot--)rt=this._parseTemplateNodeAttribute(k,tt,et,st.name,st.value)||rt;return rt}static _parseTemplateNodeAttribute(k,tt,et,rt,nt){return rt.slice(0,3)==="on-"?(k.removeAttribute(rt),et.events=et.events||[],et.events.push({name:rt.slice(3),value:nt}),!0):rt==="id"?(et.id=nt,!0):!1}static _contentForTemplate(k){let tt=k._templateInfo;return tt&&tt.content||k.content}_stampTemplate(k,tt){k&&!k.content&&window.HTMLTemplateElement&&HTMLTemplateElement.decorate&&HTMLTemplateElement.decorate(k),tt=tt||this.constructor._parseTemplate(k);let et=tt.nodeInfoList,rt=tt.content||k.content,nt=document.importNode(rt,!0);nt.__noInsertionPoint=!tt.hasInsertionPoint;let ot=nt.nodeList=new Array(et.length);nt.$={};for(let st=0,lt=et.length,ht;st<lt&&(ht=et[st]);st++){let ut=ot[st]=findTemplateNode(nt,ht);applyIdToMap(this,nt.$,ut,ht),applyTemplateInfo(this,ut,ht,tt),applyEventListener(this,ut,ht)}return nt=nt,nt}_addMethodEventListenerToNode(k,tt,et,rt){rt=rt||k;let nt=createNodeEventHandler(rt,tt,et);return this._addEventListenerToNode(k,tt,nt),nt}_addEventListenerToNode(k,tt,et){k.addEventListener(tt,et)}_removeEventListenerFromNode(k,tt,et){k.removeEventListener(tt,et)}}return E});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */let dedupeId=0;const NOOP=[],TYPES={COMPUTE:"__computeEffects",REFLECT:"__reflectEffects",NOTIFY:"__notifyEffects",PROPAGATE:"__propagateEffects",OBSERVE:"__observeEffects",READ_ONLY:"__readOnly"},COMPUTE_INFO="__computeInfo",capitalAttributeRegex=/[A-Z]/;function ensureOwnEffectMap(j,E,a){let k=j[E];if(!k)k=j[E]={};else if(!j.hasOwnProperty(E)&&(k=j[E]=Object.create(j[E]),a))for(let tt in k){let et=k[tt],rt=k[tt]=Array(et.length);for(let nt=0;nt<et.length;nt++)rt[nt]=et[nt]}return k}function runEffects(j,E,a,k,tt,et){if(E){let rt=!1;const nt=dedupeId++;for(let ot in a){let st=tt?root(ot):ot,lt=E[st];if(lt)for(let ht=0,ut=lt.length,dt;ht<ut&&(dt=lt[ht]);ht++)(!dt.info||dt.info.lastRun!==nt)&&(!tt||pathMatchesTrigger(ot,dt.trigger))&&(dt.info&&(dt.info.lastRun=nt),dt.fn(j,ot,a,k,dt.info,tt,et),rt=!0)}return rt}return!1}function runEffectsForProperty(j,E,a,k,tt,et,rt,nt){let ot=!1,st=rt?root(k):k,lt=E[st];if(lt)for(let ht=0,ut=lt.length,dt;ht<ut&&(dt=lt[ht]);ht++)(!dt.info||dt.info.lastRun!==a)&&(!rt||pathMatchesTrigger(k,dt.trigger))&&(dt.info&&(dt.info.lastRun=a),dt.fn(j,k,tt,et,dt.info,rt,nt),ot=!0);return ot}function pathMatchesTrigger(j,E){if(E){let a=E.name;return a==j||!!(E.structured&&isAncestor(a,j))||!!(E.wildcard&&isDescendant(a,j))}else return!0}function runObserverEffect(j,E,a,k,tt){let et=typeof tt.method=="string"?j[tt.method]:tt.method,rt=tt.property;et?et.call(j,j.__data[rt],k[rt]):tt.dynamicFn||console.warn("observer method `"+tt.method+"` not defined")}function runNotifyEffects(j,E,a,k,tt){let et=j[TYPES.NOTIFY],rt,nt=dedupeId++;for(let st in E)E[st]&&(et&&runEffectsForProperty(j,et,nt,st,a,k,tt)||tt&&notifyPath(j,st,a))&&(rt=!0);let ot;rt&&(ot=j.__dataHost)&&ot._invalidateProperties&&ot._invalidateProperties()}function notifyPath(j,E,a){let k=root(E);if(k!==E){let tt=camelToDashCase(k)+"-changed";return dispatchNotifyEvent(j,tt,a[E],E),!0}return!1}function dispatchNotifyEvent(j,E,a,k){let tt={value:a,queueProperty:!0};k&&(tt.path=k),wrap$f(j).dispatchEvent(new CustomEvent(E,{detail:tt}))}function runNotifyEffect(j,E,a,k,tt,et){let nt=(et?root(E):E)!=E?E:null,ot=nt?get$6(j,nt):j.__data[E];nt&&ot===void 0&&(ot=a[E]),dispatchNotifyEvent(j,tt.eventName,ot,nt)}function handleNotification(j,E,a,k,tt){let et,rt=j.detail,nt=rt&&rt.path;nt?(k=translate$1(a,k,nt),et=rt&&rt.value):et=j.currentTarget[a],et=tt?!et:et,(!E[TYPES.READ_ONLY]||!E[TYPES.READ_ONLY][k])&&E._setPendingPropertyOrPath(k,et,!0,Boolean(nt))&&(!rt||!rt.queueProperty)&&E._invalidateProperties()}function runReflectEffect(j,E,a,k,tt){let et=j.__data[E];sanitizeDOMValue&&(et=sanitizeDOMValue(et,tt.attrName,"attribute",j)),j._propertyToAttribute(E,tt.attrName,et)}function runComputedEffects(j,E,a,k){let tt=j[TYPES.COMPUTE];if(tt)if(orderedComputed){dedupeId++;const et=getComputedOrder(j),rt=[];for(let ot in E)enqueueEffectsFor(ot,tt,rt,et,k);let nt;for(;nt=rt.shift();)runComputedEffect(j,"",E,a,nt)&&enqueueEffectsFor(nt.methodInfo,tt,rt,et,k);Object.assign(a,j.__dataOld),Object.assign(E,j.__dataPending),j.__dataPending=null}else{let et=E;for(;runEffects(j,tt,et,a,k);)Object.assign(a,j.__dataOld),Object.assign(E,j.__dataPending),et=j.__dataPending,j.__dataPending=null}}const insertEffect=(j,E,a)=>{let k=0,tt=E.length-1,et=-1;for(;k<=tt;){const rt=k+tt>>1,nt=a.get(E[rt].methodInfo)-a.get(j.methodInfo);if(nt<0)k=rt+1;else if(nt>0)tt=rt-1;else{et=rt;break}}et<0&&(et=tt+1),E.splice(et,0,j)},enqueueEffectsFor=(j,E,a,k,tt)=>{const et=tt?root(j):j,rt=E[et];if(rt)for(let nt=0;nt<rt.length;nt++){const ot=rt[nt];ot.info.lastRun!==dedupeId&&(!tt||pathMatchesTrigger(j,ot.trigger))&&(ot.info.lastRun=dedupeId,insertEffect(ot.info,a,k))}};function getComputedOrder(j){let E=j.constructor.__orderedComputedDeps;if(!E){E=new Map;const a=j[TYPES.COMPUTE];let{counts:k,ready:tt,total:et}=dependencyCounts(j),rt;for(;rt=tt.shift();){E.set(rt,E.size);const nt=a[rt];nt&&nt.forEach(ot=>{const st=ot.info.methodInfo;--et,--k[st]===0&&tt.push(st)})}et!==0&&console.warn(`Computed graph for ${j.localName} incomplete; circular?`),j.constructor.__orderedComputedDeps=E}return E}function dependencyCounts(j){const E=j[COMPUTE_INFO],a={},k=j[TYPES.COMPUTE],tt=[];let et=0;for(let rt in E){const nt=E[rt];et+=a[rt]=nt.args.filter(ot=>!ot.literal).length+(nt.dynamicFn?1:0)}for(let rt in k)E[rt]||tt.push(rt);return{counts:a,ready:tt,total:et}}function runComputedEffect(j,E,a,k,tt){let et=runMethodEffect(j,E,a,k,tt);if(et===NOOP)return!1;let rt=tt.methodInfo;return j.__dataHasAccessor&&j.__dataHasAccessor[rt]?j._setPendingProperty(rt,et,!0):(j[rt]=et,!1)}function computeLinkedPaths(j,E,a){let k=j.__dataLinkedPaths;if(k){let tt;for(let et in k){let rt=k[et];isDescendant(et,E)?(tt=translate$1(et,rt,E),j._setPendingPropertyOrPath(tt,a,!0,!0)):isDescendant(rt,E)&&(tt=translate$1(rt,et,E),j._setPendingPropertyOrPath(tt,a,!0,!0))}}}function addBinding(j,E,a,k,tt,et,rt){a.bindings=a.bindings||[];let nt={kind:k,target:tt,parts:et,literal:rt,isCompound:et.length!==1};if(a.bindings.push(nt),shouldAddListener(nt)){let{event:st,negate:lt}=nt.parts[0];nt.listenerEvent=st||camelToDashCase(tt)+"-changed",nt.listenerNegate=lt}let ot=E.nodeInfoList.length;for(let st=0;st<nt.parts.length;st++){let lt=nt.parts[st];lt.compoundIndex=st,addEffectForBindingPart(j,E,nt,lt,ot)}}function addEffectForBindingPart(j,E,a,k,tt){if(!k.literal)if(a.kind==="attribute"&&a.target[0]==="-")console.warn("Cannot set attribute "+a.target+' because "-" is not a valid attribute starting character');else{let et=k.dependencies,rt={index:tt,binding:a,part:k,evaluator:j};for(let nt=0;nt<et.length;nt++){let ot=et[nt];typeof ot=="string"&&(ot=parseArg(ot),ot.wildcard=!0),j._addTemplatePropertyEffect(E,ot.rootProperty,{fn:runBindingEffect,info:rt,trigger:ot})}}}function runBindingEffect(j,E,a,k,tt,et,rt){let nt=rt[tt.index],ot=tt.binding,st=tt.part;if(et&&st.source&&E.length>st.source.length&&ot.kind=="property"&&!ot.isCompound&&nt.__isPropertyEffectsClient&&nt.__dataHasAccessor&&nt.__dataHasAccessor[ot.target]){let lt=a[E];E=translate$1(st.source,ot.target,E),nt._setPendingPropertyOrPath(E,lt,!1,!0)&&j._enqueueClient(nt)}else{let lt=tt.evaluator._evaluateBinding(j,st,E,a,k,et);lt!==NOOP&&applyBindingValue(j,nt,ot,st,lt)}}function applyBindingValue(j,E,a,k,tt){if(tt=computeBindingValue(E,tt,a,k),sanitizeDOMValue&&(tt=sanitizeDOMValue(tt,a.target,a.kind,E)),a.kind=="attribute")j._valueToNodeAttribute(E,tt,a.target);else{let et=a.target;E.__isPropertyEffectsClient&&E.__dataHasAccessor&&E.__dataHasAccessor[et]?(!E[TYPES.READ_ONLY]||!E[TYPES.READ_ONLY][et])&&E._setPendingProperty(et,tt)&&j._enqueueClient(E):j._setUnmanagedPropertyToNode(E,et,tt)}}function computeBindingValue(j,E,a,k){if(a.isCompound){let tt=j.__dataCompoundStorage[a.target];tt[k.compoundIndex]=E,E=tt.join("")}return a.kind!=="attribute"&&(a.target==="textContent"||a.target==="value"&&(j.localName==="input"||j.localName==="textarea"))&&(E=E??""),E}function shouldAddListener(j){return Boolean(j.target)&&j.kind!="attribute"&&j.kind!="text"&&!j.isCompound&&j.parts[0].mode==="{"}function setupBindings(j,E){let{nodeList:a,nodeInfoList:k}=E;if(k.length)for(let tt=0;tt<k.length;tt++){let et=k[tt],rt=a[tt],nt=et.bindings;if(nt)for(let ot=0;ot<nt.length;ot++){let st=nt[ot];setupCompoundStorage(rt,st),addNotifyListener(rt,j,st)}rt.__dataHost=j}}function setupCompoundStorage(j,E){if(E.isCompound){let a=j.__dataCompoundStorage||(j.__dataCompoundStorage={}),k=E.parts,tt=new Array(k.length);for(let rt=0;rt<k.length;rt++)tt[rt]=k[rt].literal;let et=E.target;a[et]=tt,E.literal&&E.kind=="property"&&(et==="className"&&(j=wrap$f(j)),j[et]=E.literal)}}function addNotifyListener(j,E,a){if(a.listenerEvent){let k=a.parts[0];j.addEventListener(a.listenerEvent,function(tt){handleNotification(tt,E,a.target,k.source,k.negate)})}}function createMethodEffect(j,E,a,k,tt,et){et=E.static||et&&(typeof et!="object"||et[E.methodName]);let rt={methodName:E.methodName,args:E.args,methodInfo:tt,dynamicFn:et};for(let nt=0,ot;nt<E.args.length&&(ot=E.args[nt]);nt++)ot.literal||j._addPropertyEffect(ot.rootProperty,a,{fn:k,info:rt,trigger:ot});return et&&j._addPropertyEffect(E.methodName,a,{fn:k,info:rt}),rt}function runMethodEffect(j,E,a,k,tt){let et=j._methodHost||j,rt=et[tt.methodName];if(rt){let nt=j._marshalArgs(tt.args,E,a);return nt===NOOP?NOOP:rt.apply(et,nt)}else tt.dynamicFn||console.warn("method `"+tt.methodName+"` not defined")}const emptyArray=[],IDENT="(?:[a-zA-Z_$][\\w.:$\\-*]*)",NUMBER$1="(?:[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)",SQUOTE_STRING="(?:'(?:[^'\\\\]|\\\\.)*')",DQUOTE_STRING='(?:"(?:[^"\\\\]|\\\\.)*")',STRING="(?:"+SQUOTE_STRING+"|"+DQUOTE_STRING+")",ARGUMENT="(?:("+IDENT+"|"+NUMBER$1+"|"+STRING+")\\s*)",ARGUMENTS="(?:"+ARGUMENT+"(?:,\\s*"+ARGUMENT+")*)",ARGUMENT_LIST="(?:\\(\\s*(?:"+ARGUMENTS+"?)\\)\\s*)",BINDING="("+IDENT+"\\s*"+ARGUMENT_LIST+"?)",OPEN_BRACKET="(\\[\\[|{{)\\s*",CLOSE_BRACKET="(?:]]|}})",NEGATE="(?:(!)\\s*)?",EXPRESSION=OPEN_BRACKET+NEGATE+BINDING+CLOSE_BRACKET,bindingRegex=new RegExp(EXPRESSION,"g");function literalFromParts(j){let E="";for(let a=0;a<j.length;a++){let k=j[a].literal;E+=k||""}return E}function parseMethod(j){let E=j.match(/([^\s]+?)\(([\s\S]*)\)/);if(E){let k={methodName:E[1],static:!0,args:emptyArray};if(E[2].trim()){let tt=E[2].replace(/\\,/g,"&comma;").split(",");return parseArgs(tt,k)}else return k}return null}function parseArgs(j,E){return E.args=j.map(function(a){let k=parseArg(a);return k.literal||(E.static=!1),k},this),E}function parseArg(j){let E=j.trim().replace(/&comma;/g,",").replace(/\\(.)/g,"$1"),a={name:E,value:"",literal:!1},k=E[0];switch(k==="-"&&(k=E[1]),k>="0"&&k<="9"&&(k="#"),k){case"'":case'"':a.value=E.slice(1,-1),a.literal=!0;break;case"#":a.value=Number(E),a.literal=!0;break}return a.literal||(a.rootProperty=root(E),a.structured=isPath(E),a.structured&&(a.wildcard=E.slice(-2)==".*",a.wildcard&&(a.name=E.slice(0,-2)))),a}function getArgValue(j,E,a){let k=get$6(j,a);return k===void 0&&(k=E[a]),k}function notifySplices(j,E,a,k){const tt={indexSplices:k};legacyUndefined&&!j._overrideLegacyUndefined&&(E.splices=tt),j.notifyPath(a+".splices",tt),j.notifyPath(a+".length",E.length),legacyUndefined&&!j._overrideLegacyUndefined&&(tt.indexSplices=[])}function notifySplice(j,E,a,k,tt,et){notifySplices(j,E,a,[{index:k,addedCount:tt,removed:et,object:E,type:"splice"}])}function upper(j){return j[0].toUpperCase()+j.substring(1)}const PropertyEffects=dedupingMixin(j=>{const E=TemplateStamp(PropertyAccessors(j));class a extends E{constructor(){super(),this.__isPropertyEffectsClient=!0,this.__dataClientsReady,this.__dataPendingClients,this.__dataToNotify,this.__dataLinkedPaths,this.__dataHasPaths,this.__dataCompoundStorage,this.__dataHost,this.__dataTemp,this.__dataClientsInitialized,this.__data,this.__dataPending,this.__dataOld,this.__computeEffects,this.__computeInfo,this.__reflectEffects,this.__notifyEffects,this.__propagateEffects,this.__observeEffects,this.__readOnly,this.__templateInfo,this._overrideLegacyUndefined}get PROPERTY_EFFECT_TYPES(){return TYPES}_initializeProperties(){super._initializeProperties(),this._registerHost(),this.__dataClientsReady=!1,this.__dataPendingClients=null,this.__dataToNotify=null,this.__dataLinkedPaths=null,this.__dataHasPaths=!1,this.__dataCompoundStorage=this.__dataCompoundStorage||null,this.__dataHost=this.__dataHost||null,this.__dataTemp={},this.__dataClientsInitialized=!1}_registerHost(){if(hostStack.length){let tt=hostStack[hostStack.length-1];tt._enqueueClient(this),this.__dataHost=tt}}_initializeProtoProperties(tt){this.__data=Object.create(tt),this.__dataPending=Object.create(tt),this.__dataOld={}}_initializeInstanceProperties(tt){let et=this[TYPES.READ_ONLY];for(let rt in tt)(!et||!et[rt])&&(this.__dataPending=this.__dataPending||{},this.__dataOld=this.__dataOld||{},this.__data[rt]=this.__dataPending[rt]=tt[rt])}_addPropertyEffect(tt,et,rt){this._createPropertyAccessor(tt,et==TYPES.READ_ONLY);let nt=ensureOwnEffectMap(this,et,!0)[tt];nt||(nt=this[et][tt]=[]),nt.push(rt)}_removePropertyEffect(tt,et,rt){let nt=ensureOwnEffectMap(this,et,!0)[tt],ot=nt.indexOf(rt);ot>=0&&nt.splice(ot,1)}_hasPropertyEffect(tt,et){let rt=this[et];return Boolean(rt&&rt[tt])}_hasReadOnlyEffect(tt){return this._hasPropertyEffect(tt,TYPES.READ_ONLY)}_hasNotifyEffect(tt){return this._hasPropertyEffect(tt,TYPES.NOTIFY)}_hasReflectEffect(tt){return this._hasPropertyEffect(tt,TYPES.REFLECT)}_hasComputedEffect(tt){return this._hasPropertyEffect(tt,TYPES.COMPUTE)}_setPendingPropertyOrPath(tt,et,rt,nt){if(nt||root(Array.isArray(tt)?tt[0]:tt)!==tt){if(!nt){let ot=get$6(this,tt);if(tt=set$1(this,tt,et),!tt||!super._shouldPropertyChange(tt,et,ot))return!1}if(this.__dataHasPaths=!0,this._setPendingProperty(tt,et,rt))return computeLinkedPaths(this,tt,et),!0}else{if(this.__dataHasAccessor&&this.__dataHasAccessor[tt])return this._setPendingProperty(tt,et,rt);this[tt]=et}return!1}_setUnmanagedPropertyToNode(tt,et,rt){(rt!==tt[et]||typeof rt=="object")&&(et==="className"&&(tt=wrap$f(tt)),tt[et]=rt)}_setPendingProperty(tt,et,rt){let nt=this.__dataHasPaths&&isPath(tt),ot=nt?this.__dataTemp:this.__data;return this._shouldPropertyChange(tt,et,ot[tt])?(this.__dataPending||(this.__dataPending={},this.__dataOld={}),tt in this.__dataOld||(this.__dataOld[tt]=this.__data[tt]),nt?this.__dataTemp[tt]=et:this.__data[tt]=et,this.__dataPending[tt]=et,(nt||this[TYPES.NOTIFY]&&this[TYPES.NOTIFY][tt])&&(this.__dataToNotify=this.__dataToNotify||{},this.__dataToNotify[tt]=rt),!0):!1}_setProperty(tt,et){this._setPendingProperty(tt,et,!0)&&this._invalidateProperties()}_invalidateProperties(){this.__dataReady&&this._flushProperties()}_enqueueClient(tt){this.__dataPendingClients=this.__dataPendingClients||[],tt!==this&&this.__dataPendingClients.push(tt)}_flushClients(){this.__dataClientsReady?this.__enableOrFlushClients():(this.__dataClientsReady=!0,this._readyClients(),this.__dataReady=!0)}__enableOrFlushClients(){let tt=this.__dataPendingClients;if(tt){this.__dataPendingClients=null;for(let et=0;et<tt.length;et++){let rt=tt[et];rt.__dataEnabled?rt.__dataPending&&rt._flushProperties():rt._enableProperties()}}}_readyClients(){this.__enableOrFlushClients()}setProperties(tt,et){for(let rt in tt)(et||!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][rt])&&this._setPendingPropertyOrPath(rt,tt[rt],!0);this._invalidateProperties()}ready(){this._flushProperties(),this.__dataClientsReady||this._flushClients(),this.__dataPending&&this._flushProperties()}_propertiesChanged(tt,et,rt){let nt=this.__dataHasPaths;this.__dataHasPaths=!1;let ot;runComputedEffects(this,et,rt,nt),ot=this.__dataToNotify,this.__dataToNotify=null,this._propagatePropertyChanges(et,rt,nt),this._flushClients(),runEffects(this,this[TYPES.REFLECT],et,rt,nt),runEffects(this,this[TYPES.OBSERVE],et,rt,nt),ot&&runNotifyEffects(this,ot,et,rt,nt),this.__dataCounter==1&&(this.__dataTemp={})}_propagatePropertyChanges(tt,et,rt){this[TYPES.PROPAGATE]&&runEffects(this,this[TYPES.PROPAGATE],tt,et,rt),this.__templateInfo&&this._runEffectsForTemplate(this.__templateInfo,tt,et,rt)}_runEffectsForTemplate(tt,et,rt,nt){const ot=(st,lt)=>{runEffects(this,tt.propertyEffects,st,rt,lt,tt.nodeList);for(let ht=tt.firstChild;ht;ht=ht.nextSibling)this._runEffectsForTemplate(ht,st,rt,lt)};tt.runEffects?tt.runEffects(ot,et,nt):ot(et,nt)}linkPaths(tt,et){tt=normalize$1(tt),et=normalize$1(et),this.__dataLinkedPaths=this.__dataLinkedPaths||{},this.__dataLinkedPaths[tt]=et}unlinkPaths(tt){tt=normalize$1(tt),this.__dataLinkedPaths&&delete this.__dataLinkedPaths[tt]}notifySplices(tt,et){let rt={path:""},nt=get$6(this,tt,rt);notifySplices(this,nt,rt.path,et)}get(tt,et){return get$6(et||this,tt)}set(tt,et,rt){rt?set$1(rt,tt,et):(!this[TYPES.READ_ONLY]||!this[TYPES.READ_ONLY][tt])&&this._setPendingPropertyOrPath(tt,et,!0)&&this._invalidateProperties()}push(tt,...et){let rt={path:""},nt=get$6(this,tt,rt),ot=nt.length,st=nt.push(...et);return et.length&&notifySplice(this,nt,rt.path,ot,et.length,[]),st}pop(tt){let et={path:""},rt=get$6(this,tt,et),nt=Boolean(rt.length),ot=rt.pop();return nt&&notifySplice(this,rt,et.path,rt.length,0,[ot]),ot}splice(tt,et,rt,...nt){let ot={path:""},st=get$6(this,tt,ot);et<0?et=st.length-Math.floor(-et):et&&(et=Math.floor(et));let lt;return arguments.length===2?lt=st.splice(et):lt=st.splice(et,rt,...nt),(nt.length||lt.length)&&notifySplice(this,st,ot.path,et,nt.length,lt),lt}shift(tt){let et={path:""},rt=get$6(this,tt,et),nt=Boolean(rt.length),ot=rt.shift();return nt&&notifySplice(this,rt,et.path,0,0,[ot]),ot}unshift(tt,...et){let rt={path:""},nt=get$6(this,tt,rt),ot=nt.unshift(...et);return et.length&&notifySplice(this,nt,rt.path,0,et.length,[]),ot}notifyPath(tt,et){let rt;if(arguments.length==1){let nt={path:""};et=get$6(this,tt,nt),rt=nt.path}else Array.isArray(tt)?rt=normalize$1(tt):rt=tt;this._setPendingPropertyOrPath(rt,et,!0,!0)&&this._invalidateProperties()}_createReadOnlyProperty(tt,et){this._addPropertyEffect(tt,TYPES.READ_ONLY),et&&(this["_set"+upper(tt)]=function(rt){this._setProperty(tt,rt)})}_createPropertyObserver(tt,et,rt){let nt={property:tt,method:et,dynamicFn:Boolean(rt)};this._addPropertyEffect(tt,TYPES.OBSERVE,{fn:runObserverEffect,info:nt,trigger:{name:tt}}),rt&&this._addPropertyEffect(et,TYPES.OBSERVE,{fn:runObserverEffect,info:nt,trigger:{name:et}})}_createMethodObserver(tt,et){let rt=parseMethod(tt);if(!rt)throw new Error("Malformed observer expression '"+tt+"'");createMethodEffect(this,rt,TYPES.OBSERVE,runMethodEffect,null,et)}_createNotifyingProperty(tt){this._addPropertyEffect(tt,TYPES.NOTIFY,{fn:runNotifyEffect,info:{eventName:camelToDashCase(tt)+"-changed",property:tt}})}_createReflectedProperty(tt){let et=this.constructor.attributeNameForProperty(tt);et[0]==="-"?console.warn("Property "+tt+" cannot be reflected to attribute "+et+' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.'):this._addPropertyEffect(tt,TYPES.REFLECT,{fn:runReflectEffect,info:{attrName:et}})}_createComputedProperty(tt,et,rt){let nt=parseMethod(et);if(!nt)throw new Error("Malformed computed expression '"+et+"'");const ot=createMethodEffect(this,nt,TYPES.COMPUTE,runComputedEffect,tt,rt);ensureOwnEffectMap(this,COMPUTE_INFO)[tt]=ot}_marshalArgs(tt,et,rt){const nt=this.__data,ot=[];for(let st=0,lt=tt.length;st<lt;st++){let{name:ht,structured:ut,wildcard:dt,value:ft,literal:pt}=tt[st];if(!pt)if(dt){const gt=isDescendant(ht,et),yt=getArgValue(nt,rt,gt?et:ht);ft={path:gt?et:ht,value:yt,base:gt?get$6(nt,ht):yt}}else ft=ut?getArgValue(nt,rt,ht):nt[ht];if(legacyUndefined&&!this._overrideLegacyUndefined&&ft===void 0&&tt.length>1)return NOOP;ot[st]=ft}return ot}static addPropertyEffect(tt,et,rt){this.prototype._addPropertyEffect(tt,et,rt)}static createPropertyObserver(tt,et,rt){this.prototype._createPropertyObserver(tt,et,rt)}static createMethodObserver(tt,et){this.prototype._createMethodObserver(tt,et)}static createNotifyingProperty(tt){this.prototype._createNotifyingProperty(tt)}static createReadOnlyProperty(tt,et){this.prototype._createReadOnlyProperty(tt,et)}static createReflectedProperty(tt){this.prototype._createReflectedProperty(tt)}static createComputedProperty(tt,et,rt){this.prototype._createComputedProperty(tt,et,rt)}static bindTemplate(tt){return this.prototype._bindTemplate(tt)}_bindTemplate(tt,et){let rt=this.constructor._parseTemplate(tt),nt=this.__preBoundTemplateInfo==rt;if(!nt)for(let ot in rt.propertyEffects)this._createPropertyAccessor(ot);if(et)if(rt=Object.create(rt),rt.wasPreBound=nt,!this.__templateInfo)this.__templateInfo=rt;else{const ot=tt._parentTemplateInfo||this.__templateInfo,st=ot.lastChild;rt.parent=ot,ot.lastChild=rt,rt.previousSibling=st,st?st.nextSibling=rt:ot.firstChild=rt}else this.__preBoundTemplateInfo=rt;return rt}static _addTemplatePropertyEffect(tt,et,rt){let nt=tt.hostProps=tt.hostProps||{};nt[et]=!0;let ot=tt.propertyEffects=tt.propertyEffects||{};(ot[et]=ot[et]||[]).push(rt)}_stampTemplate(tt,et){et=et||this._bindTemplate(tt,!0),hostStack.push(this);let rt=super._stampTemplate(tt,et);if(hostStack.pop(),et.nodeList=rt.nodeList,!et.wasPreBound){let nt=et.childNodes=[];for(let ot=rt.firstChild;ot;ot=ot.nextSibling)nt.push(ot)}return rt.templateInfo=et,setupBindings(this,et),this.__dataClientsReady&&(this._runEffectsForTemplate(et,this.__data,null,!1),this._flushClients()),rt}_removeBoundDom(tt){const et=tt.templateInfo,{previousSibling:rt,nextSibling:nt,parent:ot}=et;rt?rt.nextSibling=nt:ot&&(ot.firstChild=nt),nt?nt.previousSibling=rt:ot&&(ot.lastChild=rt),et.nextSibling=et.previousSibling=null;let st=et.childNodes;for(let lt=0;lt<st.length;lt++){let ht=st[lt];wrap$f(wrap$f(ht).parentNode).removeChild(ht)}}static _parseTemplateNode(tt,et,rt){let nt=E._parseTemplateNode.call(this,tt,et,rt);if(tt.nodeType===Node.TEXT_NODE){let ot=this._parseBindings(tt.textContent,et);ot&&(tt.textContent=literalFromParts(ot)||" ",addBinding(this,et,rt,"text","textContent",ot),nt=!0)}return nt}static _parseTemplateNodeAttribute(tt,et,rt,nt,ot){let st=this._parseBindings(ot,et);if(st){let lt=nt,ht="property";capitalAttributeRegex.test(nt)?ht="attribute":nt[nt.length-1]=="$"&&(nt=nt.slice(0,-1),ht="attribute");let ut=literalFromParts(st);return ut&&ht=="attribute"&&(nt=="class"&&tt.hasAttribute("class")&&(ut+=" "+tt.getAttribute(nt)),tt.setAttribute(nt,ut)),ht=="attribute"&&lt=="disable-upgrade$"&&tt.setAttribute(nt,""),tt.localName==="input"&&lt==="value"&&tt.setAttribute(lt,""),tt.removeAttribute(lt),ht==="property"&&(nt=dashToCamelCase(nt)),addBinding(this,et,rt,ht,nt,st,ut),!0}else return E._parseTemplateNodeAttribute.call(this,tt,et,rt,nt,ot)}static _parseTemplateNestedTemplate(tt,et,rt){let nt=E._parseTemplateNestedTemplate.call(this,tt,et,rt);const ot=tt.parentNode,st=rt.templateInfo,lt=ot.localName==="dom-if",ht=ot.localName==="dom-repeat";removeNestedTemplates&&(lt||ht)&&(ot.removeChild(tt),rt=rt.parentInfo,rt.templateInfo=st,rt.noted=!0,nt=!1);let ut=st.hostProps;if(fastDomIf&&lt)ut&&(et.hostProps=Object.assign(et.hostProps||{},ut),removeNestedTemplates||(rt.parentInfo.noted=!0));else{let dt="{";for(let ft in ut){let pt=[{mode:dt,source:ft,dependencies:[ft],hostProp:!0}];addBinding(this,et,rt,"property","_host_"+ft,pt)}}return nt}static _parseBindings(tt,et){let rt=[],nt=0,ot;for(;(ot=bindingRegex.exec(tt))!==null;){ot.index>nt&&rt.push({literal:tt.slice(nt,ot.index)});let st=ot[1][0],lt=Boolean(ot[2]),ht=ot[3].trim(),ut=!1,dt="",ft=-1;st=="{"&&(ft=ht.indexOf("::"))>0&&(dt=ht.substring(ft+2),ht=ht.substring(0,ft),ut=!0);let pt=parseMethod(ht),gt=[];if(pt){let{args:yt,methodName:mt}=pt;for(let wt=0;wt<yt.length;wt++){let Mt=yt[wt];Mt.literal||gt.push(Mt)}let xt=et.dynamicFns;(xt&&xt[mt]||pt.static)&&(gt.push(mt),pt.dynamicFn=!0)}else gt.push(ht);rt.push({source:ht,mode:st,negate:lt,customEvent:ut,signature:pt,dependencies:gt,event:dt}),nt=bindingRegex.lastIndex}if(nt&&nt<tt.length){let st=tt.substring(nt);st&&rt.push({literal:st})}return rt.length?rt:null}static _evaluateBinding(tt,et,rt,nt,ot,st){let lt;return et.signature?lt=runMethodEffect(tt,rt,nt,ot,et.signature):rt!=et.source?lt=get$6(tt,et.source):st&&isPath(rt)?lt=get$6(tt,rt):lt=tt.__data[rt],et.negate&&(lt=!lt),lt}}return a}),hostStack=[];/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function register$2(j){}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function normalizeProperties(j){const E={};for(let a in j){const k=j[a];E[a]=typeof k=="function"?{type:k}:k}return E}const PropertiesMixin=dedupingMixin(j=>{const E=PropertiesChanged(j);function a(et){const rt=Object.getPrototypeOf(et);return rt.prototype instanceof tt?rt:null}function k(et){if(!et.hasOwnProperty(JSCompiler_renameProperty("__ownProperties",et))){let rt=null;if(et.hasOwnProperty(JSCompiler_renameProperty("properties",et))){const nt=et.properties;nt&&(rt=normalizeProperties(nt))}et.__ownProperties=rt}return et.__ownProperties}class tt extends E{static get observedAttributes(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__observedAttributes",this))){this.prototype;const rt=this._properties;this.__observedAttributes=rt?Object.keys(rt).map(nt=>this.prototype._addPropertyToAttributeMap(nt)):[]}return this.__observedAttributes}static finalize(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__finalized",this))){const rt=a(this);rt&&rt.finalize(),this.__finalized=!0,this._finalizeClass()}}static _finalizeClass(){const rt=k(this);rt&&this.createProperties(rt)}static get _properties(){if(!this.hasOwnProperty(JSCompiler_renameProperty("__properties",this))){const rt=a(this);this.__properties=Object.assign({},rt&&rt._properties,k(this))}return this.__properties}static typeForProperty(rt){const nt=this._properties[rt];return nt&&nt.type}_initializeProperties(){this.constructor.finalize(),super._initializeProperties()}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this._enableProperties()}disconnectedCallback(){super.disconnectedCallback&&super.disconnectedCallback()}}return tt});/**
 * @fileoverview
 * @suppress {checkPrototypalTypes}
 * @license Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */const version="3.5.1",builtCSS=window.ShadyCSS&&window.ShadyCSS.cssBuild,ElementMixin$1=dedupingMixin(j=>{const E=PropertiesMixin(PropertyEffects(j));function a(ot){if(!ot.hasOwnProperty(JSCompiler_renameProperty("__propertyDefaults",ot))){ot.__propertyDefaults=null;let st=ot._properties;for(let lt in st){let ht=st[lt];"value"in ht&&(ot.__propertyDefaults=ot.__propertyDefaults||{},ot.__propertyDefaults[lt]=ht)}}return ot.__propertyDefaults}function k(ot){return ot.hasOwnProperty(JSCompiler_renameProperty("__ownObservers",ot))||(ot.__ownObservers=ot.hasOwnProperty(JSCompiler_renameProperty("observers",ot))?ot.observers:null),ot.__ownObservers}function tt(ot,st,lt,ht){lt.computed&&(lt.readOnly=!0),lt.computed&&(ot._hasReadOnlyEffect(st)?console.warn(`Cannot redefine computed property '${st}'.`):ot._createComputedProperty(st,lt.computed,ht)),lt.readOnly&&!ot._hasReadOnlyEffect(st)?ot._createReadOnlyProperty(st,!lt.computed):lt.readOnly===!1&&ot._hasReadOnlyEffect(st)&&console.warn(`Cannot make readOnly property '${st}' non-readOnly.`),lt.reflectToAttribute&&!ot._hasReflectEffect(st)?ot._createReflectedProperty(st):lt.reflectToAttribute===!1&&ot._hasReflectEffect(st)&&console.warn(`Cannot make reflected property '${st}' non-reflected.`),lt.notify&&!ot._hasNotifyEffect(st)?ot._createNotifyingProperty(st):lt.notify===!1&&ot._hasNotifyEffect(st)&&console.warn(`Cannot make notify property '${st}' non-notify.`),lt.observer&&ot._createPropertyObserver(st,lt.observer,ht[lt.observer]),ot._addPropertyToAttributeMap(st)}function et(ot,st,lt,ht){if(!builtCSS){const ut=st.content.querySelectorAll("style"),dt=stylesFromTemplate(st),ft=stylesFromModuleImports(lt),pt=st.content.firstElementChild;for(let yt=0;yt<ft.length;yt++){let mt=ft[yt];mt.textContent=ot._processStyleText(mt.textContent,ht),st.content.insertBefore(mt,pt)}let gt=0;for(let yt=0;yt<dt.length;yt++){let mt=dt[yt],xt=ut[gt];xt!==mt?(mt=mt.cloneNode(!0),xt.parentNode.insertBefore(mt,xt)):gt++,mt.textContent=ot._processStyleText(mt.textContent,ht)}}if(window.ShadyCSS&&window.ShadyCSS.prepareTemplate(st,lt),useAdoptedStyleSheetsWithBuiltCSS&&builtCSS&&supportsAdoptingStyleSheets){const ut=st.content.querySelectorAll("style");if(ut){let dt="";Array.from(ut).forEach(ft=>{dt+=ft.textContent,ft.parentNode.removeChild(ft)}),ot._styleSheet=new CSSStyleSheet,ot._styleSheet.replaceSync(dt)}}}function rt(ot){let st=null;if(ot&&(!strictTemplatePolicy||allowTemplateFromDomModule)&&(st=DomModule.import(ot,"template"),strictTemplatePolicy&&!st))throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${ot}`);return st}class nt extends E{static get polymerElementVersion(){return version}static _finalizeClass(){E._finalizeClass.call(this);const st=k(this);st&&this.createObservers(st,this._properties),this._prepareTemplate()}static _prepareTemplate(){let st=this.template;st&&(typeof st=="string"?(console.error("template getter must return HTMLTemplateElement"),st=null):legacyOptimizations||(st=st.cloneNode(!0))),this.prototype._template=st}static createProperties(st){for(let lt in st)tt(this.prototype,lt,st[lt],st)}static createObservers(st,lt){const ht=this.prototype;for(let ut=0;ut<st.length;ut++)ht._createMethodObserver(st[ut],lt)}static get template(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_template",this))){let st=this.prototype.hasOwnProperty(JSCompiler_renameProperty("_template",this.prototype))?this.prototype._template:void 0;typeof st=="function"&&(st=st()),this._template=st!==void 0?st:this.hasOwnProperty(JSCompiler_renameProperty("is",this))&&rt(this.is)||Object.getPrototypeOf(this.prototype).constructor.template}return this._template}static set template(st){this._template=st}static get importPath(){if(!this.hasOwnProperty(JSCompiler_renameProperty("_importPath",this))){const st=this.importMeta;if(st)this._importPath=pathFromUrl(st.url);else{const lt=DomModule.import(this.is);this._importPath=lt&&lt.assetpath||Object.getPrototypeOf(this.prototype).constructor.importPath}}return this._importPath}constructor(){super(),this._template,this._importPath,this.rootPath,this.importPath,this.root,this.$}_initializeProperties(){this.constructor.finalize(),this.constructor._finalizeTemplate(this.localName),super._initializeProperties(),this.rootPath=rootPath,this.importPath=this.constructor.importPath;let st=a(this.constructor);if(st)for(let lt in st){let ht=st[lt];if(this._canApplyPropertyDefault(lt)){let ut=typeof ht.value=="function"?ht.value.call(this):ht.value;this._hasAccessor(lt)?this._setPendingProperty(lt,ut,!0):this[lt]=ut}}}_canApplyPropertyDefault(st){return!this.hasOwnProperty(st)}static _processStyleText(st,lt){return resolveCss(st,lt)}static _finalizeTemplate(st){const lt=this.prototype._template;if(lt&&!lt.__polymerFinalized){lt.__polymerFinalized=!0;const ht=this.importPath,ut=ht?resolveUrl(ht):"";et(this,lt,st,ut),this.prototype._bindTemplate(lt)}}connectedCallback(){window.ShadyCSS&&this._template&&window.ShadyCSS.styleElement(this),super.connectedCallback()}ready(){this._template&&(this.root=this._stampTemplate(this._template),this.$=this.root.$),super.ready()}_readyClients(){this._template&&(this.root=this._attachDom(this.root)),super._readyClients()}_attachDom(st){const lt=wrap$f(this);if(lt.attachShadow)return st?(lt.shadowRoot||(lt.attachShadow({mode:"open",shadyUpgradeFragment:st}),lt.shadowRoot.appendChild(st),this.constructor._styleSheet&&(lt.shadowRoot.adoptedStyleSheets=[this.constructor._styleSheet])),syncInitialRender&&window.ShadyDOM&&window.ShadyDOM.flushInitial(lt.shadowRoot),lt.shadowRoot):null;throw new Error("ShadowDOM not available. PolymerElement can create dom as children instead of in ShadowDOM by setting `this.root = this;` before `ready`.")}updateStyles(st){window.ShadyCSS&&window.ShadyCSS.styleSubtree(this,st)}resolveUrl(st,lt){return!lt&&this.importPath&&(lt=resolveUrl(this.importPath)),resolveUrl(st,lt)}static _parseTemplateContent(st,lt,ht){return lt.dynamicFns=lt.dynamicFns||this._properties,E._parseTemplateContent.call(this,st,lt,ht)}static _addTemplatePropertyEffect(st,lt,ht){return legacyWarnings&&!(lt in this._properties)&&!(ht.info.part.signature&&ht.info.part.signature.static)&&!ht.info.part.hostProp&&!st.nestedTemplate&&console.warn(`Property '${lt}' used in template but not declared in 'properties'; attribute will not be observed.`),E._addTemplatePropertyEffect.call(this,st,lt,ht)}}return nt});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const policy=window.trustedTypes&&trustedTypes.createPolicy("polymer-html-literal",{createHTML:j=>j});class LiteralString{constructor(E,a){assertValidTemplateStringParameters(E,a);const k=a.reduce((tt,et,rt)=>tt+literalValue(et)+E[rt+1],E[0]);this.value=k.toString()}toString(){return this.value}}function literalValue(j){if(j instanceof LiteralString)return j.value;throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${j}`)}function htmlValue(j){if(j instanceof HTMLTemplateElement)return j.innerHTML;if(j instanceof LiteralString)return literalValue(j);throw new Error(`non-template value passed to Polymer's html function: ${j}`)}const html=function(E,...a){assertValidTemplateStringParameters(E,a);const k=document.createElement("template");let tt=a.reduce((et,rt,nt)=>et+htmlValue(rt)+E[nt+1],E[0]);return policy&&(tt=policy.createHTML(tt)),k.innerHTML=tt,k},assertValidTemplateStringParameters=(j,E)=>{if(!Array.isArray(j)||!Array.isArray(j.raw)||E.length!==j.length-1)throw new TypeError("Invalid call to the html template tag")};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const PolymerElement=ElementMixin$1(HTMLElement),DEV_MODE_CODE_REGEXP=/\/\*\*\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,FlowClients=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function isMinified(){function j(){return!0}return uncommentAndRun(j)}function isDevelopmentMode(){try{return isForcedDevelopmentMode()?!0:isLocalhost()?FlowClients?!isFlowProductionMode():!isMinified():!1}catch{return!1}}function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}function isFlowProductionMode(){return!!(FlowClients&&Object.keys(FlowClients).map(E=>FlowClients[E]).filter(E=>E.productionMode).length>0)}function uncommentAndRun(j,E){if(typeof j!="function")return;const a=DEV_MODE_CODE_REGEXP.exec(j.toString());if(a)try{j=new Function(a[1])}catch(k){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",k)}return j(E)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(j,E){if(window.Vaadin.developmentMode)return uncommentAndRun(j,E)};window.Vaadin.developmentMode===void 0&&(window.Vaadin.developmentMode=isDevelopmentMode());function maybeGatherAndSendStats(){}const usageStatistics=function(){if(typeof runIfDevelopmentMode=="function")return runIfDevelopmentMode(maybeGatherAndSendStats)};/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */let microtaskCurrHandle=0,microtaskLastHandle=0;const microtaskCallbacks=[];let microtaskNodeContent=0,microtaskScheduled=!1;const microtaskNode=document.createTextNode("");function microtaskFlush(){microtaskScheduled=!1;const j=microtaskCallbacks.length;for(let E=0;E<j;E++){const a=microtaskCallbacks[E];if(a)try{a()}catch(k){setTimeout(()=>{throw k})}}microtaskCallbacks.splice(0,j),microtaskLastHandle+=j}new window.MutationObserver(microtaskFlush).observe(microtaskNode,{characterData:!0});const timeOut={after(j){return{run(E){return window.setTimeout(E,j)},cancel(E){window.clearTimeout(E)}}},run(j,E){return window.setTimeout(j,E)},cancel(j){window.clearTimeout(j)}},animationFrame={run(j){return window.requestAnimationFrame(j)},cancel(j){window.cancelAnimationFrame(j)}},idlePeriod={run(j){return window.requestIdleCallback?window.requestIdleCallback(j):window.setTimeout(j,16)},cancel(j){window.cancelIdleCallback?window.cancelIdleCallback(j):window.clearTimeout(j)}},microTask={run(j){microtaskScheduled||(microtaskScheduled=!0,microtaskNode.textContent=microtaskNodeContent,microtaskNodeContent+=1),microtaskCallbacks.push(j);const E=microtaskCurrHandle;return microtaskCurrHandle+=1,E},cancel(j){const E=j-microtaskLastHandle;if(E>=0){if(!microtaskCallbacks[E])throw new Error(`invalid async handle: ${j}`);microtaskCallbacks[E]=null}}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const debouncerQueue$1=new Set;let Debouncer$1=class E3{static debounce(E,a,k){return E instanceof E3?E._cancelAsync():E=new E3,E.setConfig(a,k),E}constructor(){this._asyncModule=null,this._callback=null,this._timer=null}setConfig(E,a){this._asyncModule=E,this._callback=a,this._timer=this._asyncModule.run(()=>{this._timer=null,debouncerQueue$1.delete(this),this._callback()})}cancel(){this.isActive()&&(this._cancelAsync(),debouncerQueue$1.delete(this))}_cancelAsync(){this.isActive()&&(this._asyncModule.cancel(this._timer),this._timer=null)}flush(){this.isActive()&&(this.cancel(),this._callback())}isActive(){return this._timer!=null}};function enqueueDebouncer$1(j){debouncerQueue$1.add(j)}function flushDebouncers$1(){const j=Boolean(debouncerQueue$1.size);return debouncerQueue$1.forEach(E=>{try{E.flush()}catch(a){setTimeout(()=>{throw a})}}),j}const flush$1=()=>{let j;do j=flushDebouncers$1();while(j)};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const directionSubscribers=[];function alignDirs(j,E,a=j.getAttribute("dir")){E?j.setAttribute("dir",E):a!=null&&j.removeAttribute("dir")}function getDocumentDir(){return document.documentElement.getAttribute("dir")}function directionUpdater(){const j=getDocumentDir();directionSubscribers.forEach(E=>{alignDirs(E,j)})}const directionObserver=new MutationObserver(directionUpdater);directionObserver.observe(document.documentElement,{attributes:!0,attributeFilter:["dir"]});const DirMixin=j=>class extends j{static get properties(){return{dir:{type:String,value:"",reflectToAttribute:!0,converter:{fromAttribute:a=>a||"",toAttribute:a=>a===""?null:a}}}}get __isRTL(){return this.getAttribute("dir")==="rtl"}connectedCallback(){super.connectedCallback(),(!this.hasAttribute("dir")||this.__restoreSubscription)&&(this.__subscribe(),alignDirs(this,getDocumentDir(),null))}attributeChangedCallback(a,k,tt){if(super.attributeChangedCallback(a,k,tt),a!=="dir")return;const et=getDocumentDir(),rt=tt===et&&directionSubscribers.indexOf(this)===-1,nt=!tt&&k&&directionSubscribers.indexOf(this)===-1;rt||nt?(this.__subscribe(),alignDirs(this,et,tt)):tt!==et&&k===et&&this.__unsubscribe()}disconnectedCallback(){super.disconnectedCallback(),this.__restoreSubscription=directionSubscribers.includes(this),this.__unsubscribe()}_valueToNodeAttribute(a,k,tt){tt==="dir"&&k===""&&!a.hasAttribute("dir")||super._valueToNodeAttribute(a,k,tt)}_attributeToProperty(a,k,tt){a==="dir"&&!k?this.dir="":super._attributeToProperty(a,k,tt)}__subscribe(){directionSubscribers.includes(this)||directionSubscribers.push(this)}__unsubscribe(){directionSubscribers.includes(this)&&directionSubscribers.splice(directionSubscribers.indexOf(this),1)}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */window.Vaadin||(window.Vaadin={});window.Vaadin.registrations||(window.Vaadin.registrations=[]);window.Vaadin.developmentModeCallback||(window.Vaadin.developmentModeCallback={});window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]=function(){usageStatistics()};let statsJob;const registered=new Set,ElementMixin=j=>class extends DirMixin(j){static get version(){return"24.0.0"}static finalize(){super.finalize();const{is:a}=this;a&&!registered.has(a)&&(window.Vaadin.registrations.push(this),registered.add(a),window.Vaadin.developmentModeCallback&&(statsJob=Debouncer$1.debounce(statsJob,idlePeriod,()=>{window.Vaadin.developmentModeCallback["vaadin-usage-statistics"]()}),enqueueDebouncer$1(statsJob)))}constructor(){super(),document.doctype===null&&console.warn('Vaadin components require the "standards mode" declaration. Please add <!DOCTYPE html> to the HTML document.')}};/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function newSplice(j,E,a){return{index:j,removed:E,addedCount:a}}const EDIT_LEAVE=0,EDIT_UPDATE=1,EDIT_ADD=2,EDIT_DELETE=3;function calcEditDistances(j,E,a,k,tt,et){let rt=et-tt+1,nt=a-E+1,ot=new Array(rt);for(let st=0;st<rt;st++)ot[st]=new Array(nt),ot[st][0]=st;for(let st=0;st<nt;st++)ot[0][st]=st;for(let st=1;st<rt;st++)for(let lt=1;lt<nt;lt++)if(equals$3(j[E+lt-1],k[tt+st-1]))ot[st][lt]=ot[st-1][lt-1];else{let ht=ot[st-1][lt]+1,ut=ot[st][lt-1]+1;ot[st][lt]=ht<ut?ht:ut}return ot}function spliceOperationsFromEditDistances(j){let E=j.length-1,a=j[0].length-1,k=j[E][a],tt=[];for(;E>0||a>0;){if(E==0){tt.push(EDIT_ADD),a--;continue}if(a==0){tt.push(EDIT_DELETE),E--;continue}let et=j[E-1][a-1],rt=j[E-1][a],nt=j[E][a-1],ot;rt<nt?ot=rt<et?rt:et:ot=nt<et?nt:et,ot==et?(et==k?tt.push(EDIT_LEAVE):(tt.push(EDIT_UPDATE),k=et),E--,a--):ot==rt?(tt.push(EDIT_DELETE),E--,k=rt):(tt.push(EDIT_ADD),a--,k=nt)}return tt.reverse(),tt}function calcSplices(j,E,a,k,tt,et){let rt=0,nt=0,ot,st=Math.min(a-E,et-tt);if(E==0&&tt==0&&(rt=sharedPrefix(j,k,st)),a==j.length&&et==k.length&&(nt=sharedSuffix(j,k,st-rt)),E+=rt,tt+=rt,a-=nt,et-=nt,a-E==0&&et-tt==0)return[];if(E==a){for(ot=newSplice(E,[],0);tt<et;)ot.removed.push(k[tt++]);return[ot]}else if(tt==et)return[newSplice(E,[],a-E)];let lt=spliceOperationsFromEditDistances(calcEditDistances(j,E,a,k,tt,et));ot=void 0;let ht=[],ut=E,dt=tt;for(let ft=0;ft<lt.length;ft++)switch(lt[ft]){case EDIT_LEAVE:ot&&(ht.push(ot),ot=void 0),ut++,dt++;break;case EDIT_UPDATE:ot||(ot=newSplice(ut,[],0)),ot.addedCount++,ut++,ot.removed.push(k[dt]),dt++;break;case EDIT_ADD:ot||(ot=newSplice(ut,[],0)),ot.addedCount++,ut++;break;case EDIT_DELETE:ot||(ot=newSplice(ut,[],0)),ot.removed.push(k[dt]),dt++;break}return ot&&ht.push(ot),ht}function sharedPrefix(j,E,a){for(let k=0;k<a;k++)if(!equals$3(j[k],E[k]))return k;return a}function sharedSuffix(j,E,a){let k=j.length,tt=E.length,et=0;for(;et<a&&equals$3(j[--k],E[--tt]);)et++;return et}function calculateSplices(j,E){return calcSplices(j,0,j.length,E,0,E.length)}function equals$3(j,E){return j===E}/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/function isSlot(j){return j.localName==="slot"}let FlattenedNodesObserver=class{static getFlattenedNodes(j){const E=wrap$f(j);return isSlot(j)?(j=j,E.assignedNodes({flatten:!0})):Array.from(E.childNodes).map(a=>isSlot(a)?(a=a,wrap$f(a).assignedNodes({flatten:!0})):[a]).reduce((a,k)=>a.concat(k),[])}constructor(j,E){this._shadyChildrenObserver=null,this._nativeChildrenObserver=null,this._connected=!1,this._target=j,this.callback=E,this._effectiveNodes=[],this._observer=null,this._scheduled=!1,this._boundSchedule=()=>{this._schedule()},this.connect(),this._schedule()}connect(){isSlot(this._target)?this._listenSlots([this._target]):wrap$f(this._target).children&&(this._listenSlots(wrap$f(this._target).children),window.ShadyDOM?this._shadyChildrenObserver=window.ShadyDOM.observeChildren(this._target,j=>{this._processMutations(j)}):(this._nativeChildrenObserver=new MutationObserver(j=>{this._processMutations(j)}),this._nativeChildrenObserver.observe(this._target,{childList:!0}))),this._connected=!0}disconnect(){isSlot(this._target)?this._unlistenSlots([this._target]):wrap$f(this._target).children&&(this._unlistenSlots(wrap$f(this._target).children),window.ShadyDOM&&this._shadyChildrenObserver?(window.ShadyDOM.unobserveChildren(this._shadyChildrenObserver),this._shadyChildrenObserver=null):this._nativeChildrenObserver&&(this._nativeChildrenObserver.disconnect(),this._nativeChildrenObserver=null)),this._connected=!1}_schedule(){this._scheduled||(this._scheduled=!0,microTask$1.run(()=>this.flush()))}_processMutations(j){this._processSlotMutations(j),this.flush()}_processSlotMutations(j){if(j)for(let E=0;E<j.length;E++){let a=j[E];a.addedNodes&&this._listenSlots(a.addedNodes),a.removedNodes&&this._unlistenSlots(a.removedNodes)}}flush(){if(!this._connected)return!1;window.ShadyDOM&&ShadyDOM.flush(),this._nativeChildrenObserver?this._processSlotMutations(this._nativeChildrenObserver.takeRecords()):this._shadyChildrenObserver&&this._processSlotMutations(this._shadyChildrenObserver.takeRecords()),this._scheduled=!1;let j={target:this._target,addedNodes:[],removedNodes:[]},E=this.constructor.getFlattenedNodes(this._target),a=calculateSplices(E,this._effectiveNodes);for(let tt=0,et;tt<a.length&&(et=a[tt]);tt++)for(let rt=0,nt;rt<et.removed.length&&(nt=et.removed[rt]);rt++)j.removedNodes.push(nt);for(let tt=0,et;tt<a.length&&(et=a[tt]);tt++)for(let rt=et.index;rt<et.index+et.addedCount;rt++)j.addedNodes.push(E[rt]);this._effectiveNodes=E;let k=!1;return(j.addedNodes.length||j.removedNodes.length)&&(k=!0,this.callback.call(this._target,j)),k}_listenSlots(j){for(let E=0;E<j.length;E++){let a=j[E];isSlot(a)&&a.addEventListener("slotchange",this._boundSchedule)}}_unlistenSlots(j){for(let E=0;E<j.length;E++){let a=j[E];isSlot(a)&&a.removeEventListener("slotchange",this._boundSchedule)}}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getAncestorRootNodes(j){const E=[];for(;j;){if(j.nodeType===Node.DOCUMENT_NODE){E.push(j);break}if(j.nodeType===Node.DOCUMENT_FRAGMENT_NODE){E.push(j),j=j.host;continue}if(j.assignedSlot){j=j.assignedSlot;continue}j=j.parentNode}return E}function deserializeAttributeValue(j){return j?new Set(j.split(" ")):new Set}function serializeAttributeValue(j){return[...j].join(" ")}function addValueToAttribute(j,E,a){const k=deserializeAttributeValue(j.getAttribute(E));k.add(a),j.setAttribute(E,serializeAttributeValue(k))}function removeValueFromAttribute(j,E,a){const k=deserializeAttributeValue(j.getAttribute(E));if(k.delete(a),k.size===0){j.removeAttribute(E);return}j.setAttribute(E,serializeAttributeValue(k))}function isEmptyTextNode(j){return j.nodeType===Node.TEXT_NODE&&j.textContent.trim()===""}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let uniqueId=0;function generateUniqueId(){return uniqueId++}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotController extends EventTarget{static generateId(E,a){return`${a||"default"}-${E.localName}-${generateUniqueId()}`}constructor(E,a,k,tt={}){super();const{initializer:et,multiple:rt,observe:nt,useUniqueId:ot}=tt;this.host=E,this.slotName=a,this.tagName=k,this.observe=typeof nt=="boolean"?nt:!0,this.multiple=typeof rt=="boolean"?rt:!1,this.slotInitializer=et,rt&&(this.nodes=[]),ot&&(this.defaultId=this.constructor.generateId(E,a))}hostConnected(){this.initialized||(this.multiple?this.initMultiple():this.initSingle(),this.observe&&this.observeSlot(),this.initialized=!0)}initSingle(){let E=this.getSlotChild();E?(this.node=E,this.initAddedNode(E)):(E=this.attachDefaultNode(),this.initNode(E))}initMultiple(){const E=this.getSlotChildren();if(E.length===0){const a=this.attachDefaultNode();this.nodes=[a],this.initNode(a)}else this.nodes=E,E.forEach(a=>{this.initAddedNode(a)})}attachDefaultNode(){const{host:E,slotName:a,tagName:k}=this;let tt=this.defaultNode;return!tt&&k&&(tt=document.createElement(k),tt instanceof Element&&(a!==""&&tt.setAttribute("slot",a),this.node=tt,this.defaultNode=tt)),tt&&E.appendChild(tt),tt}getSlotChildren(){const{slotName:E}=this;return Array.from(this.host.childNodes).filter(a=>a.nodeType===Node.ELEMENT_NODE&&a.slot===E||a.nodeType===Node.TEXT_NODE&&a.textContent.trim()&&E==="")}getSlotChild(){return this.getSlotChildren()[0]}initNode(E){const{slotInitializer:a}=this;a&&a(E,this.host)}initCustomNode(E){}teardownNode(E){}initAddedNode(E){E!==this.defaultNode&&(this.initCustomNode(E),this.initNode(E))}observeSlot(){const{slotName:E}=this,a=E===""?"slot:not([name])":`slot[name=${E}]`,k=this.host.shadowRoot.querySelector(a);this.__slotObserver=new FlattenedNodesObserver(k,tt=>{const et=this.multiple?this.nodes:[this.node],rt=tt.addedNodes.filter(nt=>!isEmptyTextNode(nt)&&!et.includes(nt));tt.removedNodes.length&&tt.removedNodes.forEach(nt=>{this.teardownNode(nt)}),rt&&rt.length>0&&(et.forEach(nt=>{nt&&nt.isConnected&&nt.parentNode.removeChild(nt)}),this.multiple?(this.nodes=rt,rt.forEach(nt=>{this.initAddedNode(nt)})):(this.node=rt[0],this.initAddedNode(this.node)))})}}/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class TooltipController extends SlotController{constructor(E){super(E,"tooltip"),this.setTarget(E)}initCustomNode(E){E.target=this.target,this.context!==void 0&&(E.context=this.context),this.manual!==void 0&&(E.manual=this.manual),this.opened!==void 0&&(E.opened=this.opened),this.position!==void 0&&(E._position=this.position),this.shouldShow!==void 0&&(E.shouldShow=this.shouldShow)}setContext(E){this.context=E;const a=this.node;a&&(a.context=E)}setManual(E){this.manual=E;const a=this.node;a&&(a.manual=E)}setOpened(E){this.opened=E;const a=this.node;a&&(a.opened=E)}setPosition(E){this.position=E;const a=this.node;a&&(a._position=E)}setShouldShow(E){this.shouldShow=E;const a=this.node;a&&(a.shouldShow=E)}setTarget(E){this.target=E;const a=this.node;a&&(a.target=E)}}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DisabledMixin=dedupingMixin(j=>class extends j{static get properties(){return{disabled:{type:Boolean,value:!1,observer:"_disabledChanged",reflectToAttribute:!0}}}_disabledChanged(a){this._setAriaDisabled(a)}_setAriaDisabled(a){a?this.setAttribute("aria-disabled","true"):this.removeAttribute("aria-disabled")}click(){this.disabled||super.click()}});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/const passiveTouchGestures=!1,wrap$e=j=>j,HAS_NATIVE_TA=typeof document.head.style.touchAction=="string",GESTURE_KEY="__polymerGestures",HANDLED_OBJ="__polymerGesturesHandled",TOUCH_ACTION="__polymerGesturesTouchAction",TAP_DISTANCE=25,TRACK_DISTANCE=5,TRACK_LENGTH=2,MOUSE_EVENTS=["mousedown","mousemove","mouseup","click"],MOUSE_WHICH_TO_BUTTONS=[0,1,4,2],MOUSE_HAS_BUTTONS=function(){try{return new MouseEvent("test",{buttons:1}).buttons===1}catch{return!1}}();function isMouseEvent(j){return MOUSE_EVENTS.indexOf(j)>-1}let supportsPassive=!1;(function(){try{const j=Object.defineProperty({},"passive",{get(){supportsPassive=!0}});window.addEventListener("test",null,j),window.removeEventListener("test",null,j)}catch{}})();function PASSIVE_TOUCH(j){if(!(isMouseEvent(j)||j==="touchend")&&HAS_NATIVE_TA&&supportsPassive&&passiveTouchGestures)return{passive:!0}}const IS_TOUCH_ONLY=navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/u),canBeDisabled={button:!0,command:!0,fieldset:!0,input:!0,keygen:!0,optgroup:!0,option:!0,select:!0,textarea:!0};function hasLeftMouseButton(j){const E=j.type;if(!isMouseEvent(E))return!1;if(E==="mousemove"){let k=j.buttons===void 0?1:j.buttons;return j instanceof window.MouseEvent&&!MOUSE_HAS_BUTTONS&&(k=MOUSE_WHICH_TO_BUTTONS[j.which]||0),Boolean(k&1)}return(j.button===void 0?0:j.button)===0}function isSyntheticClick(j){if(j.type==="click"){if(j.detail===0)return!0;const E=_findOriginalTarget(j);if(!E.nodeType||E.nodeType!==Node.ELEMENT_NODE)return!0;const a=E.getBoundingClientRect(),k=j.pageX,tt=j.pageY;return!(k>=a.left&&k<=a.right&&tt>=a.top&&tt<=a.bottom)}return!1}const POINTERSTATE={mouse:{target:null,mouseIgnoreJob:null},touch:{x:0,y:0,id:-1,scrollDecided:!1}};function firstTouchAction(j){let E="auto";const a=getComposedPath(j);for(let k=0,tt;k<a.length;k++)if(tt=a[k],tt[TOUCH_ACTION]){E=tt[TOUCH_ACTION];break}return E}function trackDocument(j,E,a){j.movefn=E,j.upfn=a,document.addEventListener("mousemove",E),document.addEventListener("mouseup",a)}function untrackDocument(j){document.removeEventListener("mousemove",j.movefn),document.removeEventListener("mouseup",j.upfn),j.movefn=null,j.upfn=null}const getComposedPath=window.ShadyDOM&&window.ShadyDOM.noPatch?window.ShadyDOM.composedPath:j=>j.composedPath&&j.composedPath()||[],gestures={},recognizers=[];function deepTargetFind(j,E){let a=document.elementFromPoint(j,E),k=a;for(;k&&k.shadowRoot&&!window.ShadyDOM;){const tt=k;if(k=k.shadowRoot.elementFromPoint(j,E),tt===k)break;k&&(a=k)}return a}function _findOriginalTarget(j){const E=getComposedPath(j);return E.length>0?E[0]:j.target}function _handleNative(j){const E=j.type,k=j.currentTarget[GESTURE_KEY];if(!k)return;const tt=k[E];if(!tt)return;if(!j[HANDLED_OBJ]&&(j[HANDLED_OBJ]={},E.startsWith("touch"))){const rt=j.changedTouches[0];if(E==="touchstart"&&j.touches.length===1&&(POINTERSTATE.touch.id=rt.identifier),POINTERSTATE.touch.id!==rt.identifier)return;HAS_NATIVE_TA||(E==="touchstart"||E==="touchmove")&&_handleTouchAction(j)}const et=j[HANDLED_OBJ];if(!et.skip){for(let rt=0,nt;rt<recognizers.length;rt++)nt=recognizers[rt],tt[nt.name]&&!et[nt.name]&&nt.flow&&nt.flow.start.indexOf(j.type)>-1&&nt.reset&&nt.reset();for(let rt=0,nt;rt<recognizers.length;rt++)nt=recognizers[rt],tt[nt.name]&&!et[nt.name]&&(et[nt.name]=!0,nt[E](j))}}function _handleTouchAction(j){const E=j.changedTouches[0],a=j.type;if(a==="touchstart")POINTERSTATE.touch.x=E.clientX,POINTERSTATE.touch.y=E.clientY,POINTERSTATE.touch.scrollDecided=!1;else if(a==="touchmove"){if(POINTERSTATE.touch.scrollDecided)return;POINTERSTATE.touch.scrollDecided=!0;const k=firstTouchAction(j);let tt=!1;const et=Math.abs(POINTERSTATE.touch.x-E.clientX),rt=Math.abs(POINTERSTATE.touch.y-E.clientY);j.cancelable&&(k==="none"?tt=!0:k==="pan-x"?tt=rt>et:k==="pan-y"&&(tt=et>rt)),tt?j.preventDefault():prevent("track")}}function addListener(j,E,a){return gestures[E]?(_add(j,E,a),!0):!1}function removeListener(j,E,a){return gestures[E]?(_remove(j,E,a),!0):!1}function _add(j,E,a){const k=gestures[E],tt=k.deps,et=k.name;let rt=j[GESTURE_KEY];rt||(j[GESTURE_KEY]=rt={});for(let nt=0,ot,st;nt<tt.length;nt++)ot=tt[nt],!(IS_TOUCH_ONLY&&isMouseEvent(ot)&&ot!=="click")&&(st=rt[ot],st||(rt[ot]=st={_count:0}),st._count===0&&j.addEventListener(ot,_handleNative,PASSIVE_TOUCH(ot)),st[et]=(st[et]||0)+1,st._count=(st._count||0)+1);j.addEventListener(E,a),k.touchAction&&setTouchAction(j,k.touchAction)}function _remove(j,E,a){const k=gestures[E],tt=k.deps,et=k.name,rt=j[GESTURE_KEY];if(rt)for(let nt=0,ot,st;nt<tt.length;nt++)ot=tt[nt],st=rt[ot],st&&st[et]&&(st[et]=(st[et]||1)-1,st._count=(st._count||1)-1,st._count===0&&j.removeEventListener(ot,_handleNative,PASSIVE_TOUCH(ot)));j.removeEventListener(E,a)}function register$1(j){recognizers.push(j),j.emits.forEach(E=>{gestures[E]=j})}function _findRecognizerByEvent(j){for(let E=0,a;E<recognizers.length;E++){a=recognizers[E];for(let k=0,tt;k<a.emits.length;k++)if(tt=a.emits[k],tt===j)return a}return null}function setTouchAction(j,E){HAS_NATIVE_TA&&j instanceof HTMLElement&&microTask.run(()=>{j.style.touchAction=E}),j[TOUCH_ACTION]=E}function _fire(j,E,a){const k=new Event(E,{bubbles:!0,cancelable:!0,composed:!0});if(k.detail=a,wrap$e(j).dispatchEvent(k),k.defaultPrevented){const tt=a.preventer||a.sourceEvent;tt&&tt.preventDefault&&tt.preventDefault()}}function prevent(j){const E=_findRecognizerByEvent(j);E.info&&(E.info.prevent=!0)}register$1({name:"downup",deps:["mousedown","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["down","up"],info:{movefn:null,upfn:null},reset(){untrackDocument(this.info)},mousedown(j){if(!hasLeftMouseButton(j))return;const E=_findOriginalTarget(j),a=this,k=et=>{hasLeftMouseButton(et)||(downupFire("up",E,et),untrackDocument(a.info))},tt=et=>{hasLeftMouseButton(et)&&downupFire("up",E,et),untrackDocument(a.info)};trackDocument(this.info,k,tt),downupFire("down",E,j)},touchstart(j){downupFire("down",_findOriginalTarget(j),j.changedTouches[0],j)},touchend(j){downupFire("up",_findOriginalTarget(j),j.changedTouches[0],j)}});function downupFire(j,E,a,k){E&&_fire(E,j,{x:a.clientX,y:a.clientY,sourceEvent:a,preventer:k,prevent(tt){return prevent(tt)}})}register$1({name:"track",touchAction:"none",deps:["mousedown","touchstart","touchmove","touchend"],flow:{start:["mousedown","touchstart"],end:["mouseup","touchend"]},emits:["track"],info:{x:0,y:0,state:"start",started:!1,moves:[],addMove(j){this.moves.length>TRACK_LENGTH&&this.moves.shift(),this.moves.push(j)},movefn:null,upfn:null,prevent:!1},reset(){this.info.state="start",this.info.started=!1,this.info.moves=[],this.info.x=0,this.info.y=0,this.info.prevent=!1,untrackDocument(this.info)},mousedown(j){if(!hasLeftMouseButton(j))return;const E=_findOriginalTarget(j),a=this,k=et=>{const rt=et.clientX,nt=et.clientY;trackHasMovedEnough(a.info,rt,nt)&&(a.info.state=a.info.started?et.type==="mouseup"?"end":"track":"start",a.info.state==="start"&&prevent("tap"),a.info.addMove({x:rt,y:nt}),hasLeftMouseButton(et)||(a.info.state="end",untrackDocument(a.info)),E&&trackFire(a.info,E,et),a.info.started=!0)},tt=et=>{a.info.started&&k(et),untrackDocument(a.info)};trackDocument(this.info,k,tt),this.info.x=j.clientX,this.info.y=j.clientY},touchstart(j){const E=j.changedTouches[0];this.info.x=E.clientX,this.info.y=E.clientY},touchmove(j){const E=_findOriginalTarget(j),a=j.changedTouches[0],k=a.clientX,tt=a.clientY;trackHasMovedEnough(this.info,k,tt)&&(this.info.state==="start"&&prevent("tap"),this.info.addMove({x:k,y:tt}),trackFire(this.info,E,a),this.info.state="track",this.info.started=!0)},touchend(j){const E=_findOriginalTarget(j),a=j.changedTouches[0];this.info.started&&(this.info.state="end",this.info.addMove({x:a.clientX,y:a.clientY}),trackFire(this.info,E,a))}});function trackHasMovedEnough(j,E,a){if(j.prevent)return!1;if(j.started)return!0;const k=Math.abs(j.x-E),tt=Math.abs(j.y-a);return k>=TRACK_DISTANCE||tt>=TRACK_DISTANCE}function trackFire(j,E,a){if(!E)return;const k=j.moves[j.moves.length-2],tt=j.moves[j.moves.length-1],et=tt.x-j.x,rt=tt.y-j.y;let nt,ot=0;k&&(nt=tt.x-k.x,ot=tt.y-k.y),_fire(E,"track",{state:j.state,x:a.clientX,y:a.clientY,dx:et,dy:rt,ddx:nt,ddy:ot,sourceEvent:a,hover(){return deepTargetFind(a.clientX,a.clientY)}})}register$1({name:"tap",deps:["mousedown","click","touchstart","touchend"],flow:{start:["mousedown","touchstart"],end:["click","touchend"]},emits:["tap"],info:{x:NaN,y:NaN,prevent:!1},reset(){this.info.x=NaN,this.info.y=NaN,this.info.prevent=!1},mousedown(j){hasLeftMouseButton(j)&&(this.info.x=j.clientX,this.info.y=j.clientY)},click(j){hasLeftMouseButton(j)&&trackForward(this.info,j)},touchstart(j){const E=j.changedTouches[0];this.info.x=E.clientX,this.info.y=E.clientY},touchend(j){trackForward(this.info,j.changedTouches[0],j)}});function trackForward(j,E,a){const k=Math.abs(E.clientX-j.x),tt=Math.abs(E.clientY-j.y),et=_findOriginalTarget(a||E);!et||canBeDisabled[et.localName]&&et.hasAttribute("disabled")||(isNaN(k)||isNaN(tt)||k<=TAP_DISTANCE&&tt<=TAP_DISTANCE||isSyntheticClick(E))&&(j.prevent||_fire(et,"tap",{x:E.clientX,y:E.clientY,sourceEvent:E,preventer:a}))}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardMixin=dedupingMixin(j=>class extends j{ready(){super.ready(),this.addEventListener("keydown",a=>{this._onKeyDown(a)}),this.addEventListener("keyup",a=>{this._onKeyUp(a)})}_onKeyDown(a){switch(a.key){case"Enter":this._onEnter(a);break;case"Escape":this._onEscape(a);break}}_onKeyUp(a){}_onEnter(a){}_onEscape(a){}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ActiveMixin=j=>class extends DisabledMixin(KeyboardMixin(j)){get _activeKeys(){return[" "]}ready(){super.ready(),addListener(this,"down",a=>{this._shouldSetActive(a)&&this._setActive(!0)}),addListener(this,"up",()=>{this._setActive(!1)})}disconnectedCallback(){super.disconnectedCallback(),this._setActive(!1)}_shouldSetActive(a){return!this.disabled}_onKeyDown(a){super._onKeyDown(a),this._shouldSetActive(a)&&this._activeKeys.includes(a.key)&&(this._setActive(!0),document.addEventListener("keyup",k=>{this._activeKeys.includes(k.key)&&this._setActive(!1)},{once:!0}))}_setActive(a){this.toggleAttribute("active",a)}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let keyboardActive=!1;window.addEventListener("keydown",()=>{keyboardActive=!0},{capture:!0});window.addEventListener("mousedown",()=>{keyboardActive=!1},{capture:!0});function isKeyboardActive(){return keyboardActive}function isElementHiddenDirectly(j){const E=j.style;if(E.visibility==="hidden"||E.display==="none")return!0;const a=window.getComputedStyle(j);return a.visibility==="hidden"||a.display==="none"}function hasLowerTabOrder(j,E){const a=Math.max(j.tabIndex,0),k=Math.max(E.tabIndex,0);return a===0||k===0?k>a:a>k}function mergeSortByTabIndex(j,E){const a=[];for(;j.length>0&&E.length>0;)hasLowerTabOrder(j[0],E[0])?a.push(E.shift()):a.push(j.shift());return a.concat(j,E)}function sortElementsByTabIndex(j){const E=j.length;if(E<2)return j;const a=Math.ceil(E/2),k=sortElementsByTabIndex(j.slice(0,a)),tt=sortElementsByTabIndex(j.slice(a));return mergeSortByTabIndex(k,tt)}function isElementHidden(j){return j.offsetParent===null?!0:isElementHiddenDirectly(j)}function isElementFocusable(j){return j.matches('[tabindex="-1"]')?!1:j.matches("input, select, textarea, button, object")?j.matches(":not([disabled])"):j.matches("a[href], area[href], iframe, [tabindex], [contentEditable]")}function isElementFocused(j){return j.getRootNode().activeElement===j}function normalizeTabIndex(j){if(!isElementFocusable(j))return-1;const E=j.getAttribute("tabindex")||0;return Number(E)}function collectFocusableNodes(j,E){if(j.nodeType!==Node.ELEMENT_NODE||isElementHiddenDirectly(j))return!1;const a=j,k=normalizeTabIndex(a);let tt=k>0;k>=0&&E.push(a);let et=[];return a.localName==="slot"?et=a.assignedNodes({flatten:!0}):et=(a.shadowRoot||a).children,[...et].forEach(rt=>{tt=collectFocusableNodes(rt,E)||tt}),tt}function getFocusableElements(j){const E=[];return collectFocusableNodes(j,E)?sortElementsByTabIndex(E):E}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FocusMixin=dedupingMixin(j=>class extends j{get _keyboardActive(){return isKeyboardActive()}ready(){this.addEventListener("focusin",a=>{this._shouldSetFocus(a)&&this._setFocused(!0)}),this.addEventListener("focusout",a=>{this._shouldRemoveFocus(a)&&this._setFocused(!1)}),super.ready()}disconnectedCallback(){super.disconnectedCallback(),this.hasAttribute("focused")&&this._setFocused(!1)}_setFocused(a){this.toggleAttribute("focused",a),this.toggleAttribute("focus-ring",a&&this._keyboardActive)}_shouldSetFocus(a){return!0}_shouldRemoveFocus(a){return!0}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const TabindexMixin=j=>class extends DisabledMixin(j){static get properties(){return{tabindex:{type:Number,reflectToAttribute:!0,observer:"_tabindexChanged"},_lastTabIndex:{type:Number}}}_disabledChanged(a,k){super._disabledChanged(a,k),a?(this.tabindex!==void 0&&(this._lastTabIndex=this.tabindex),this.tabindex=-1):k&&(this.tabindex=this._lastTabIndex)}_tabindexChanged(a){this.disabled&&a!==-1&&(this._lastTabIndex=a,this.tabindex=-1)}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateFocusMixin=dedupingMixin(j=>class extends FocusMixin(TabindexMixin(j)){static get properties(){return{autofocus:{type:Boolean},focusElement:{type:Object,readOnly:!0,observer:"_focusElementChanged"},_lastTabIndex:{value:0}}}constructor(){super(),this._boundOnBlur=this._onBlur.bind(this),this._boundOnFocus=this._onFocus.bind(this)}ready(){super.ready(),this.autofocus&&!this.disabled&&requestAnimationFrame(()=>{this.focus(),this.setAttribute("focus-ring","")})}focus(){!this.focusElement||this.disabled||(this.focusElement.focus(),this._setFocused(!0))}blur(){this.focusElement&&(this.focusElement.blur(),this._setFocused(!1))}click(){this.focusElement&&!this.disabled&&this.focusElement.click()}_focusElementChanged(a,k){a?(a.disabled=this.disabled,this._addFocusListeners(a),this.__forwardTabIndex(this.tabindex)):k&&this._removeFocusListeners(k)}_addFocusListeners(a){a.addEventListener("blur",this._boundOnBlur),a.addEventListener("focus",this._boundOnFocus)}_removeFocusListeners(a){a.removeEventListener("blur",this._boundOnBlur),a.removeEventListener("focus",this._boundOnFocus)}_onFocus(a){a.stopPropagation(),this.dispatchEvent(new Event("focus"))}_onBlur(a){a.stopPropagation(),this.dispatchEvent(new Event("blur"))}_shouldSetFocus(a){return a.target===this.focusElement}_disabledChanged(a,k){super._disabledChanged(a,k),this.focusElement&&(this.focusElement.disabled=a),a&&this.blur()}_tabindexChanged(a){this.__forwardTabIndex(a)}__forwardTabIndex(a){a!==void 0&&this.focusElement&&(this.focusElement.tabIndex=a,a!==-1&&(this.tabindex=void 0)),this.disabled&&a&&(a!==-1&&(this._lastTabIndex=a),this.tabindex=void 0)}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DelegateStateMixin=dedupingMixin(j=>class extends j{static get properties(){return{stateTarget:{type:Object,observer:"_stateTargetChanged"}}}static get delegateAttrs(){return[]}static get delegateProps(){return[]}ready(){super.ready(),this._createDelegateAttrsObserver(),this._createDelegatePropsObserver()}_stateTargetChanged(a){a&&(this._ensureAttrsDelegated(),this._ensurePropsDelegated())}_createDelegateAttrsObserver(){this._createMethodObserver(`_delegateAttrsChanged(${this.constructor.delegateAttrs.join(", ")})`)}_createDelegatePropsObserver(){this._createMethodObserver(`_delegatePropsChanged(${this.constructor.delegateProps.join(", ")})`)}_ensureAttrsDelegated(){this.constructor.delegateAttrs.forEach(a=>{this._delegateAttribute(a,this[a])})}_ensurePropsDelegated(){this.constructor.delegateProps.forEach(a=>{this._delegateProperty(a,this[a])})}_delegateAttrsChanged(...a){this.constructor.delegateAttrs.forEach((k,tt)=>{this._delegateAttribute(k,a[tt])})}_delegatePropsChanged(...a){this.constructor.delegateProps.forEach((k,tt)=>{this._delegateProperty(k,a[tt])})}_delegateAttribute(a,k){this.stateTarget&&(a==="invalid"&&this._delegateAttribute("aria-invalid",k?"true":!1),typeof k=="boolean"?this.stateTarget.toggleAttribute(a,k):k?this.stateTarget.setAttribute(a,k):this.stateTarget.removeAttribute(a))}_delegateProperty(a,k){this.stateTarget&&(this.stateTarget[a]=k)}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const InputMixin=dedupingMixin(j=>class extends j{static get properties(){return{inputElement:{type:Object,readOnly:!0,observer:"_inputElementChanged"},type:{type:String,readOnly:!0},value:{type:String,value:"",observer:"_valueChanged",notify:!0},_hasInputValue:{type:Boolean,value:!1,observer:"_hasInputValueChanged"}}}constructor(){super(),this._boundOnInput=this.__onInput.bind(this),this._boundOnChange=this._onChange.bind(this)}get _hasValue(){return this.value!=null&&this.value!==""}clear(){this._hasInputValue=!1,this.value="",this.inputElement&&(this.inputElement.value="")}_addInputListeners(a){a.addEventListener("input",this._boundOnInput),a.addEventListener("change",this._boundOnChange)}_removeInputListeners(a){a.removeEventListener("input",this._boundOnInput),a.removeEventListener("change",this._boundOnChange)}_forwardInputValue(a){this.inputElement&&(a!=null?this.inputElement.value=a:this.inputElement.value="")}_inputElementChanged(a,k){a?this._addInputListeners(a):k&&this._removeInputListeners(k)}_hasInputValueChanged(a,k){(a||k)&&this.dispatchEvent(new CustomEvent("has-input-value-changed"))}__onInput(a){this._setHasInputValue(a),this._onInput(a)}_onInput(a){const k=a.composedPath()[0];this.__userInput=a.isTrusted,this.value=k.value,this.__userInput=!1}_onChange(a){}_toggleHasValue(a){this.toggleAttribute("has-value",a)}_valueChanged(a,k){this._toggleHasValue(this._hasValue),!(a===""&&k===void 0)&&(this.__userInput||this._forwardInputValue(a))}_setHasInputValue(a){const k=a.composedPath()[0];this._hasInputValue=k.value.length>0}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CheckedMixin=dedupingMixin(j=>class extends DelegateStateMixin(DisabledMixin(InputMixin(j))){static get properties(){return{checked:{type:Boolean,value:!1,notify:!0,reflectToAttribute:!0}}}static get delegateProps(){return[...super.delegateProps,"checked"]}_onChange(a){const k=a.target;this._toggleChecked(k.checked),isElementFocused(k)||k.focus()}_toggleChecked(a){this.checked=a}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class InputController extends SlotController{constructor(E,a){super(E,"input","input",{initializer:(k,tt)=>{tt.value&&k.setAttribute("value",tt.value),tt.type&&k.setAttribute("type",tt.type),k.id=this.defaultId,typeof a=="function"&&a(k)},useUniqueId:!0})}}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ControllerMixin=dedupingMixin(j=>class extends j{constructor(){super(),this.__controllers=new Set}connectedCallback(){super.connectedCallback(),this.__controllers.forEach(a=>{a.hostConnected&&a.hostConnected()})}disconnectedCallback(){super.disconnectedCallback(),this.__controllers.forEach(a=>{a.hostDisconnected&&a.hostDisconnected()})}addController(a){this.__controllers.add(a),this.$!==void 0&&this.isConnected&&a.hostConnected&&a.hostConnected()}removeController(a){this.__controllers.delete(a)}});/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SlotChildObserveController extends SlotController{constructor(E,a,k,tt={}){super(E,a,k,{...tt,useUniqueId:!0})}initCustomNode(E){this.__updateNodeId(E),this.__notifyChange(E)}teardownNode(E){const a=this.getSlotChild();a&&a!==this.defaultNode?this.__notifyChange(a):(this.restoreDefaultNode(),this.updateDefaultNode(this.node))}attachDefaultNode(){const E=super.attachDefaultNode();return E&&this.__updateNodeId(E),E}restoreDefaultNode(){}updateDefaultNode(E){this.__notifyChange(E)}observeNode(E){this.__nodeObserver&&this.__nodeObserver.disconnect(),this.__nodeObserver=new MutationObserver(a=>{a.forEach(k=>{const tt=k.target,et=tt===this.node;k.type==="attributes"?et&&this.__updateNodeId(tt):(et||tt.parentElement===this.node)&&this.__notifyChange(this.node)})}),this.__nodeObserver.observe(E,{attributes:!0,attributeFilter:["id"],childList:!0,subtree:!0,characterData:!0})}__hasContent(E){return E?E.nodeType===Node.ELEMENT_NODE&&(customElements.get(E.localName)||E.children.length>0)||E.textContent&&E.textContent.trim()!=="":!1}__notifyChange(E){this.dispatchEvent(new CustomEvent("slot-content-changed",{detail:{hasContent:this.__hasContent(E),node:E}}))}__updateNodeId(E){const a=!this.nodes||E===this.nodes[0];E.nodeType===Node.ELEMENT_NODE&&a&&!E.id&&(E.id=this.defaultId)}}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class LabelController extends SlotChildObserveController{constructor(E){super(E,"label","label")}setLabel(E){this.label=E,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{label:E}=this;if(E&&E.trim()!==""){const a=this.attachDefaultNode();this.observeNode(a)}}updateDefaultNode(E){E&&(E.textContent=this.label),super.updateDefaultNode(E)}initCustomNode(E){super.initCustomNode(E),this.observeNode(E)}}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const LabelMixin=dedupingMixin(j=>class extends ControllerMixin(j){static get properties(){return{label:{type:String,observer:"_labelChanged"}}}constructor(){super(),this._labelController=new LabelController(this),this._labelController.addEventListener("slot-content-changed",a=>{this.toggleAttribute("has-label",a.detail.hasContent)})}get _labelId(){const a=this._labelNode;return a&&a.id}get _labelNode(){return this._labelController.node}ready(){super.ready(),this.addController(this._labelController)}_labelChanged(a){this._labelController.setLabel(a)}});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class LabelledInputController{constructor(E,a){this.input=E,this.__preventDuplicateLabelClick=this.__preventDuplicateLabelClick.bind(this),a.addEventListener("slot-content-changed",k=>{this.__initLabel(k.detail.node)}),this.__initLabel(a.node)}__initLabel(E){E&&(E.addEventListener("click",this.__preventDuplicateLabelClick),this.input&&E.setAttribute("for",this.input.id))}__preventDuplicateLabelClick(){const E=a=>{a.stopImmediatePropagation(),this.input.removeEventListener("click",E)};this.input.addEventListener("click",E)}}/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CheckboxMixin=j=>class extends LabelMixin(CheckedMixin(DelegateFocusMixin(ActiveMixin(j)))){static get properties(){return{indeterminate:{type:Boolean,notify:!0,value:!1,reflectToAttribute:!0},name:{type:String,value:""}}}static get delegateProps(){return[...super.delegateProps,"indeterminate"]}static get delegateAttrs(){return[...super.delegateAttrs,"name"]}constructor(){super(),this._setType("checkbox"),this.value="on"}ready(){super.ready(),this.addController(new InputController(this,a=>{this._setInputElement(a),this._setFocusElement(a),this.stateTarget=a,this.ariaTarget=a})),this.addController(new LabelledInputController(this.inputElement,this._labelController))}_shouldSetActive(a){return a.target.localName==="a"?!1:super._shouldSetActive(a)}_toggleChecked(a){this.indeterminate&&(this.indeterminate=!1),super._toggleChecked(a)}};/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const checkboxStyles=i$2`
  :host {
    display: inline-block;
  }

  :host([hidden]) {
    display: none !important;
  }

  :host([disabled]) {
    -webkit-tap-highlight-color: transparent;
  }

  .vaadin-checkbox-container {
    display: grid;
    grid-template-columns: auto 1fr;
    align-items: baseline;
  }

  [part='checkbox'],
  ::slotted(input),
  ::slotted(label) {
    grid-row: 1;
  }

  [part='checkbox'],
  ::slotted(input) {
    grid-column: 1;
  }

  [part='checkbox'] {
    width: var(--vaadin-checkbox-size, 1em);
    height: var(--vaadin-checkbox-size, 1em);
  }

  [part='checkbox']::before {
    display: block;
    content: '\\202F';
    line-height: var(--vaadin-checkbox-size, 1em);
    contain: paint;
  }

  /* visually hidden */
  ::slotted(input) {
    opacity: 0;
    cursor: inherit;
    margin: 0;
    align-self: stretch;
    -webkit-appearance: none;
  }
`;/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-checkbox",checkboxStyles,{moduleId:"vaadin-checkbox-styles"});class Checkbox extends CheckboxMixin(ElementMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-checkbox"}static get template(){return html`
      <div class="vaadin-checkbox-container">
        <div part="checkbox" aria-hidden="true"></div>
        <slot name="input"></slot>
        <slot name="label"></slot>
      </div>
      <slot name="tooltip"></slot>
    `}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}customElements.define(Checkbox.is,Checkbox);registerStyles$1("vaadin-grid",i$2`
    :host {
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-m);
      line-height: var(--lumo-line-height-s);
      color: var(--lumo-body-text-color);
      background-color: var(--lumo-base-color);
      box-sizing: border-box;
      -webkit-text-size-adjust: 100%;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;

      /* For internal use only */
      --_lumo-grid-border-color: var(--lumo-contrast-20pct);
      --_lumo-grid-secondary-border-color: var(--lumo-contrast-10pct);
      --_lumo-grid-border-width: 1px;
      --_lumo-grid-selected-row-color: var(--lumo-primary-color-10pct);
    }

    /* No (outer) border */

    :host(:not([theme~='no-border'])) {
      border: var(--_lumo-grid-border-width) solid var(--_lumo-grid-border-color);
    }

    :host([disabled]) {
      opacity: 0.7;
    }

    /* Cell styles */

    [part~='cell'] {
      min-height: var(--lumo-size-m);
      background-color: var(--lumo-base-color);
    }

    [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      cursor: default;
      padding: var(--lumo-space-xs) var(--lumo-space-m);
    }

    /* Apply row borders by default and introduce the "no-row-borders" variant */
    :host(:not([theme~='no-row-borders'])) [part~='cell']:not([part~='details-cell']) {
      border-top: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
    }

    /* Hide first body row top border */
    :host(:not([theme~='no-row-borders'])) [part~='first-row'] [part~='cell']:not([part~='details-cell']) {
      border-top: 0;
      min-height: calc(var(--lumo-size-m) - var(--_lumo-grid-border-width));
    }

    /* Focus-ring */

    [part~='row'] {
      position: relative;
    }

    [part~='row']:focus,
    [part~='focused-cell']:focus {
      outline: none;
    }

    :host([navigating]) [part~='row']:focus::before,
    :host([navigating]) [part~='focused-cell']:focus::before {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      pointer-events: none;
      box-shadow: inset 0 0 0 2px var(--lumo-primary-color-50pct);
    }

    :host([navigating]) [part~='row']:focus::before {
      transform: translateX(calc(-1 * var(--_grid-horizontal-scroll-position)));
      z-index: 3;
    }

    /* Drag and Drop styles */
    :host([dragover])::after {
      content: '';
      position: absolute;
      z-index: 100;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      pointer-events: none;
      box-shadow: inset 0 0 0 2px var(--lumo-primary-color-50pct);
    }

    [part~='row'][dragover] {
      z-index: 100 !important;
    }

    [part~='row'][dragover] [part~='cell'] {
      overflow: visible;
    }

    [part~='row'][dragover] [part~='cell']::after {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      height: calc(var(--_lumo-grid-border-width) + 2px);
      pointer-events: none;
      background: var(--lumo-primary-color-50pct);
    }

    [part~='row'][dragover] [part~='cell'][last-frozen]::after {
      right: -1px;
    }

    :host([theme~='no-row-borders']) [dragover] [part~='cell']::after {
      height: 2px;
    }

    [part~='row'][dragover='below'] [part~='cell']::after {
      top: 100%;
      bottom: auto;
      margin-top: -1px;
    }

    :host([all-rows-visible]) [part~='last-row'][dragover='below'] [part~='cell']::after {
      height: 1px;
    }

    [part~='row'][dragover='above'] [part~='cell']::after {
      top: auto;
      bottom: 100%;
      margin-bottom: -1px;
    }

    [part~='row'][details-opened][dragover='below'] [part~='cell']:not([part~='details-cell'])::after,
    [part~='row'][details-opened][dragover='above'] [part~='details-cell']::after {
      display: none;
    }

    [part~='row'][dragover][dragover='on-top'] [part~='cell']::after {
      height: 100%;
      opacity: 0.5;
    }

    [part~='row'][dragstart] [part~='cell'] {
      border: none !important;
      box-shadow: none !important;
    }

    [part~='row'][dragstart] [part~='cell'][last-column] {
      border-radius: 0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;
    }

    [part~='row'][dragstart] [part~='cell'][first-column] {
      border-radius: var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);
    }

    #scroller [part~='row'][dragstart]:not([dragstart=''])::after {
      display: block;
      position: absolute;
      left: var(--_grid-drag-start-x);
      top: var(--_grid-drag-start-y);
      z-index: 100;
      content: attr(dragstart);
      align-items: center;
      justify-content: center;
      box-sizing: border-box;
      padding: calc(var(--lumo-space-xs) * 0.8);
      color: var(--lumo-error-contrast-color);
      background-color: var(--lumo-error-color);
      border-radius: var(--lumo-border-radius-m);
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-xxs);
      line-height: 1;
      font-weight: 500;
      text-transform: initial;
      letter-spacing: initial;
      min-width: calc(var(--lumo-size-s) * 0.7);
      text-align: center;
    }

    /* Headers and footers */

    [part~='header-cell'] ::slotted(vaadin-grid-cell-content),
    [part~='footer-cell'] ::slotted(vaadin-grid-cell-content),
    [part~='reorder-ghost'] {
      font-size: var(--lumo-font-size-s);
      font-weight: 500;
    }

    [part~='footer-cell'] ::slotted(vaadin-grid-cell-content) {
      font-weight: 400;
    }

    [part~='row']:only-child [part~='header-cell'] {
      min-height: var(--lumo-size-xl);
    }

    /* Header borders */

    /* Hide first header row top border */
    :host(:not([theme~='no-row-borders'])) [part~='row']:first-child [part~='header-cell'] {
      border-top: 0;
    }

    [part~='row']:last-child [part~='header-cell'] {
      border-bottom: var(--_lumo-grid-border-width) solid transparent;
    }

    :host(:not([theme~='no-row-borders'])) [part~='row']:last-child [part~='header-cell'] {
      border-bottom-color: var(--_lumo-grid-secondary-border-color);
    }

    /* Overflow uses a stronger border color */
    :host([overflow~='top']) [part~='row']:last-child [part~='header-cell'] {
      border-bottom-color: var(--_lumo-grid-border-color);
    }

    /* Footer borders */

    [part~='row']:first-child [part~='footer-cell'] {
      border-top: var(--_lumo-grid-border-width) solid transparent;
    }

    :host(:not([theme~='no-row-borders'])) [part~='row']:first-child [part~='footer-cell'] {
      border-top-color: var(--_lumo-grid-secondary-border-color);
    }

    /* Overflow uses a stronger border color */
    :host([overflow~='bottom']) [part~='row']:first-child [part~='footer-cell'] {
      border-top-color: var(--_lumo-grid-border-color);
    }

    /* Column reordering */

    :host([reordering]) [part~='cell'] {
      background: linear-gradient(var(--lumo-shade-20pct), var(--lumo-shade-20pct)) var(--lumo-base-color);
    }

    :host([reordering]) [part~='cell'][reorder-status='allowed'] {
      background: var(--lumo-base-color);
    }

    :host([reordering]) [part~='cell'][reorder-status='dragging'] {
      background: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct)) var(--lumo-base-color);
    }

    [part~='reorder-ghost'] {
      opacity: 0.85;
      box-shadow: var(--lumo-box-shadow-s);
      /* TODO Use the same styles as for the cell element (reorder-ghost copies styles from the cell element) */
      padding: var(--lumo-space-s) var(--lumo-space-m) !important;
    }

    /* Column resizing */

    [part='resize-handle'] {
      width: 3px;
      background-color: var(--lumo-primary-color-50pct);
      opacity: 0;
      transition: opacity 0.2s;
    }

    :host(:not([reordering])) *:not([column-resizing]) [part~='cell']:hover [part='resize-handle'],
    [part='resize-handle']:active {
      opacity: 1;
      transition-delay: 0.15s;
    }

    /* Column borders */

    :host([theme~='column-borders']) [part~='cell']:not([last-column]):not([part~='details-cell']) {
      border-right: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
    }

    /* Frozen columns */

    [last-frozen] {
      border-right: var(--_lumo-grid-border-width) solid transparent;
      overflow: hidden;
    }

    :host([overflow~='start']) [part~='cell'][last-frozen]:not([part~='details-cell']) {
      border-right-color: var(--_lumo-grid-border-color);
    }

    [first-frozen-to-end] {
      border-left: var(--_lumo-grid-border-width) solid transparent;
    }

    :host([overflow~='end']) [part~='cell'][first-frozen-to-end]:not([part~='details-cell']) {
      border-left-color: var(--_lumo-grid-border-color);
    }

    /* Row stripes */

    :host([theme~='row-stripes']) [part~='even-row'] [part~='body-cell'],
    :host([theme~='row-stripes']) [part~='even-row'] [part~='details-cell'] {
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
      background-repeat: repeat-x;
    }

    /* Selected row */

    /* Raise the selected rows above unselected rows (so that box-shadow can cover unselected rows) */
    :host(:not([reordering])) [part~='row'][selected] {
      z-index: 1;
    }

    :host(:not([reordering])) [part~='row'][selected] [part~='body-cell']:not([part~='details-cell']) {
      background-image: linear-gradient(var(--_lumo-grid-selected-row-color), var(--_lumo-grid-selected-row-color));
      background-repeat: repeat;
    }

    /* Cover the border of an unselected row */
    :host(:not([theme~='no-row-borders'])) [part~='row'][selected] [part~='cell']:not([part~='details-cell']) {
      box-shadow: 0 var(--_lumo-grid-border-width) 0 0 var(--_lumo-grid-selected-row-color);
    }

    /* Compact */

    :host([theme~='compact']) [part~='row']:only-child [part~='header-cell'] {
      min-height: var(--lumo-size-m);
    }

    :host([theme~='compact']) [part~='cell'] {
      min-height: var(--lumo-size-s);
    }

    :host([theme~='compact']) [part~='first-row'] [part~='cell']:not([part~='details-cell']) {
      min-height: calc(var(--lumo-size-s) - var(--_lumo-grid-border-width));
    }

    :host([theme~='compact']) [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      padding: var(--lumo-space-xs) var(--lumo-space-s);
    }

    /* Wrap cell contents */

    :host([theme~='wrap-cell-content']) [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      white-space: normal;
    }

    /* RTL specific styles */

    :host([dir='rtl']) [part~='row'][dragstart] [part~='cell'][last-column] {
      border-radius: var(--lumo-border-radius-s) 0 0 var(--lumo-border-radius-s);
    }

    :host([dir='rtl']) [part~='row'][dragstart] [part~='cell'][first-column] {
      border-radius: 0 var(--lumo-border-radius-s) var(--lumo-border-radius-s) 0;
    }

    :host([dir='rtl'][theme~='column-borders']) [part~='cell']:not([last-column]):not([part~='details-cell']) {
      border-right: none;
      border-left: var(--_lumo-grid-border-width) solid var(--_lumo-grid-secondary-border-color);
    }

    :host([dir='rtl']) [last-frozen] {
      border-right: none;
      border-left: var(--_lumo-grid-border-width) solid transparent;
    }

    :host([dir='rtl']) [first-frozen-to-end] {
      border-left: none;
      border-right: var(--_lumo-grid-border-width) solid transparent;
    }

    :host([dir='rtl'][overflow~='start']) [part~='cell'][last-frozen]:not([part~='details-cell']) {
      border-left-color: var(--_lumo-grid-border-color);
    }

    :host([dir='rtl'][overflow~='end']) [part~='cell'][first-frozen-to-end]:not([part~='details-cell']) {
      border-right-color: var(--_lumo-grid-border-color);
    }
  `,{moduleId:"lumo-grid"});/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function processTemplates(j){if(window.Vaadin&&window.Vaadin.templateRendererCallback){window.Vaadin.templateRendererCallback(j);return}j.querySelector("template")&&console.warn(`WARNING: <template> inside <${j.localName}> is no longer supported. Import @vaadin/polymer-legacy-adapter/template-renderer.js to enable compatibility.`)}/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getBodyRowCells(j){return Array.from(j.querySelectorAll('[part~="cell"]:not([part~="details-cell"])'))}function iterateChildren(j,E){[...j.children].forEach(E)}function updateColumnOrders(j,E,a){let k=1;j.forEach(tt=>{k%10===0&&(k+=1),tt._order=a+k*E,k+=1})}function updateState(j,E,a){switch(typeof a){case"boolean":j.toggleAttribute(E,a);break;case"string":j.setAttribute(E,a);break;default:j.removeAttribute(E);break}}function updatePart(j,E,a){E||E===""?addValueToAttribute(j,"part",a):removeValueFromAttribute(j,"part",a)}function updateCellsPart(j,E,a){j.forEach(k=>{updatePart(k,a,E)})}function updateRowStates(j,E,a){const k=getBodyRowCells(j);Object.entries(E).forEach(([tt,et])=>{updateState(j,tt,et);const rt=a?`${tt}-${et}-row`:`${tt}-row`;updatePart(j,et,rt),updateCellsPart(k,`${rt}-cell`,et)})}function updateCellState(j,E,a,k,tt){updateState(j,E,a),tt&&updatePart(j,!1,tt),updatePart(j,a,k||`${E}-cell`)}/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ColumnBaseMixin=j=>class extends j{static get properties(){return{resizable:{type:Boolean,value(){if(this.localName==="vaadin-grid-column-group")return;const a=this.parentNode;return a&&a.localName==="vaadin-grid-column-group"&&a.resizable||!1}},frozen:{type:Boolean,value:!1},frozenToEnd:{type:Boolean,value:!1},hidden:{type:Boolean,value:!1},header:{type:String},textAlign:{type:String},_lastFrozen:{type:Boolean,value:!1},_firstFrozenToEnd:{type:Boolean,value:!1},_order:Number,_reorderStatus:Boolean,_emptyCells:Array,_headerCell:Object,_footerCell:Object,_grid:Object,__initialized:{type:Boolean,value:!0},headerRenderer:Function,_headerRenderer:{type:Function,computed:"_computeHeaderRenderer(headerRenderer, header, __initialized)"},footerRenderer:Function,_footerRenderer:{type:Function,computed:"_computeFooterRenderer(footerRenderer, __initialized)"},__gridColumnElement:{type:Boolean,value:!0}}}static get observers(){return["_widthChanged(width, _headerCell, _footerCell, _cells.*)","_frozenChanged(frozen, _headerCell, _footerCell, _cells.*)","_frozenToEndChanged(frozenToEnd, _headerCell, _footerCell, _cells.*)","_flexGrowChanged(flexGrow, _headerCell, _footerCell, _cells.*)","_textAlignChanged(textAlign, _cells.*, _headerCell, _footerCell)","_orderChanged(_order, _headerCell, _footerCell, _cells.*)","_lastFrozenChanged(_lastFrozen)","_firstFrozenToEndChanged(_firstFrozenToEnd)","_onRendererOrBindingChanged(_renderer, _cells, _cells.*, path)","_onHeaderRendererOrBindingChanged(_headerRenderer, _headerCell, path, header)","_onFooterRendererOrBindingChanged(_footerRenderer, _footerCell)","_resizableChanged(resizable, _headerCell)","_reorderStatusChanged(_reorderStatus, _headerCell, _footerCell, _cells.*)","_hiddenChanged(hidden, _headerCell, _footerCell, _cells.*)"]}get _grid(){return this._gridValue||(this._gridValue=this._findHostGrid()),this._gridValue}get _allCells(){return[].concat(this._cells||[]).concat(this._emptyCells||[]).concat(this._headerCell).concat(this._footerCell).filter(a=>a)}connectedCallback(){super.connectedCallback(),requestAnimationFrame(()=>{this._grid&&this._allCells.forEach(a=>{a._content.parentNode||this._grid.appendChild(a._content)})})}disconnectedCallback(){super.disconnectedCallback(),requestAnimationFrame(()=>{this._grid||this._allCells.forEach(a=>{a._content.parentNode&&a._content.parentNode.removeChild(a._content)})}),this._gridValue=void 0}ready(){super.ready(),processTemplates(this)}_findHostGrid(){let a=this;for(;a&&!/^vaadin.*grid(-pro)?$/u.test(a.localName);)a=a.assignedSlot?a.assignedSlot.parentNode:a.parentNode;return a||void 0}_renderHeaderAndFooter(){this._renderHeaderCellContent(this._headerRenderer,this._headerCell),this._renderFooterCellContent(this._footerRenderer,this._footerCell)}_flexGrowChanged(a){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("flexGrow"),this._allCells.forEach(k=>{k.style.flexGrow=a})}_orderChanged(a){this._allCells.forEach(k=>{k.style.order=a})}_widthChanged(a){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("width"),this._allCells.forEach(k=>{k.style.width=a})}_frozenChanged(a){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("frozen",a),this._allCells.forEach(k=>{updateCellState(k,"frozen",a)}),this._grid&&this._grid._frozenCellsChanged&&this._grid._frozenCellsChanged()}_frozenToEndChanged(a){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("frozenToEnd",a),this._allCells.forEach(k=>{this._grid&&k.parentElement===this._grid.$.sizer||updateCellState(k,"frozen-to-end",a)}),this._grid&&this._grid._frozenCellsChanged&&this._grid._frozenCellsChanged()}_lastFrozenChanged(a){this._allCells.forEach(k=>{updateCellState(k,"last-frozen",a)}),this.parentElement&&this.parentElement._columnPropChanged&&(this.parentElement._lastFrozen=a)}_firstFrozenToEndChanged(a){this._allCells.forEach(k=>{this._grid&&k.parentElement===this._grid.$.sizer||updateCellState(k,"first-frozen-to-end",a)}),this.parentElement&&this.parentElement._columnPropChanged&&(this.parentElement._firstFrozenToEnd=a)}_generateHeader(a){return a.substr(a.lastIndexOf(".")+1).replace(/([A-Z])/gu,"-$1").toLowerCase().replace(/-/gu," ").replace(/^./u,k=>k.toUpperCase())}_reorderStatusChanged(a){const k=this.__previousReorderStatus,tt=k?`reorder-${k}-cell`:"",et=`reorder-${a}-cell`;this._allCells.forEach(rt=>{updateCellState(rt,"reorder-status",a,et,tt)}),this.__previousReorderStatus=a}_resizableChanged(a,k){a===void 0||k===void 0||k&&[k].concat(this._emptyCells).forEach(tt=>{if(tt){const et=tt.querySelector('[part~="resize-handle"]');if(et&&tt.removeChild(et),a){const rt=document.createElement("div");rt.setAttribute("part","resize-handle"),tt.appendChild(rt)}}})}_textAlignChanged(a){if(a===void 0)return;if(["start","end","center"].indexOf(a)===-1){console.warn('textAlign can only be set as "start", "end" or "center"');return}let k;getComputedStyle(this._grid).direction==="ltr"?a==="start"?k="left":a==="end"&&(k="right"):a==="start"?k="right":a==="end"&&(k="left"),this._allCells.forEach(tt=>{tt._content.style.textAlign=a,getComputedStyle(tt._content).textAlign!==a&&(tt._content.style.textAlign=k)})}_hiddenChanged(a){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("hidden",a),!!a!=!!this._previousHidden&&this._grid&&(a===!0&&this._allCells.forEach(k=>{k._content.parentNode&&k._content.parentNode.removeChild(k._content)}),this._grid._debouncerHiddenChanged=Debouncer$1.debounce(this._grid._debouncerHiddenChanged,animationFrame,()=>{this._grid&&this._grid._renderColumnTree&&this._grid._renderColumnTree(this._grid._columnTree)}),this._grid._debounceUpdateFrozenColumn&&this._grid._debounceUpdateFrozenColumn(),this._grid._resetKeyboardNavigation&&this._grid._resetKeyboardNavigation()),this._previousHidden=a}_runRenderer(a,k,tt){const et=[k._content,this];tt&&tt.item&&et.push(tt),a.apply(this,et)}__renderCellsContent(a,k){this.hidden||!this._grid||k.forEach(tt=>{if(!tt.parentElement)return;const et=this._grid.__getRowModel(tt.parentElement);a&&(tt._renderer!==a&&this._clearCellContent(tt),tt._renderer=a,(et.item||a===this._headerRenderer||a===this._footerRenderer)&&this._runRenderer(a,tt,et))})}_clearCellContent(a){a._content.innerHTML="",delete a._content._$litPart$}_renderHeaderCellContent(a,k){!k||!a||(this.__renderCellsContent(a,[k]),this._grid&&k.parentElement&&this._grid.__debounceUpdateHeaderFooterRowVisibility(k.parentElement))}_onHeaderRendererOrBindingChanged(a,k,...tt){this._renderHeaderCellContent(a,k)}_renderBodyCellsContent(a,k){!k||!a||this.__renderCellsContent(a,k)}_onRendererOrBindingChanged(a,k,...tt){this._renderBodyCellsContent(a,k)}_renderFooterCellContent(a,k){!k||!a||(this.__renderCellsContent(a,[k]),this._grid&&k.parentElement&&this._grid.__debounceUpdateHeaderFooterRowVisibility(k.parentElement))}_onFooterRendererOrBindingChanged(a,k){this._renderFooterCellContent(a,k)}__setTextContent(a,k){a.textContent!==k&&(a.textContent=k)}__textHeaderRenderer(){this.__setTextContent(this._headerCell._content,this.header)}_defaultHeaderRenderer(){this.path&&this.__setTextContent(this._headerCell._content,this._generateHeader(this.path))}_defaultRenderer(a,k,{item:tt}){this.path&&this.__setTextContent(a,this.get(this.path,tt))}_defaultFooterRenderer(){}_computeHeaderRenderer(a,k){return a||(k!=null?this.__textHeaderRenderer:this._defaultHeaderRenderer)}_computeRenderer(a){return a||this._defaultRenderer}_computeFooterRenderer(a){return a||this._defaultFooterRenderer}};class GridColumn extends ColumnBaseMixin(DirMixin(PolymerElement)){static get is(){return"vaadin-grid-column"}static get properties(){return{width:{type:String,value:"100px"},flexGrow:{type:Number,value:1},renderer:Function,_renderer:{type:Function,computed:"_computeRenderer(renderer, __initialized)"},path:{type:String},autoWidth:{type:Boolean,value:!1},_focusButtonMode:{type:Boolean,value:!1},_cells:Array}}}customElements.define(GridColumn.is,GridColumn);/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-grid",i$2`
    @keyframes vaadin-grid-appear {
      to {
        opacity: 1;
      }
    }

    :host {
      display: block;
      animation: 1ms vaadin-grid-appear;
      height: 400px;
      flex: 1 1 auto;
      align-self: stretch;
      position: relative;
    }

    :host([hidden]) {
      display: none !important;
    }

    :host([disabled]) {
      pointer-events: none;
    }

    #scroller {
      display: block;
      transform: translateY(0);
      width: auto;
      height: auto;
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
    }

    :host([all-rows-visible]) {
      height: auto;
      align-self: flex-start;
      flex-grow: 0;
      width: 100%;
    }

    :host([all-rows-visible]) #scroller {
      width: 100%;
      height: 100%;
      position: relative;
    }

    :host([all-rows-visible]) #items {
      min-height: 1px;
    }

    #table {
      display: flex;
      flex-direction: column;
      width: 100%;
      height: 100%;
      overflow: auto;
      position: relative;
      outline: none;
      /* Workaround for a Desktop Safari bug: new stacking context here prevents the scrollbar from getting hidden */
      z-index: 0;
    }

    #header,
    #footer {
      display: block;
      position: -webkit-sticky;
      position: sticky;
      left: 0;
      overflow: visible;
      width: 100%;
      z-index: 1;
    }

    #header {
      top: 0;
    }

    th {
      text-align: inherit;
    }

    /* Safari doesn't work with "inherit" */
    [safari] th {
      text-align: initial;
    }

    #footer {
      bottom: 0;
    }

    #items {
      flex-grow: 1;
      flex-shrink: 0;
      display: block;
      position: -webkit-sticky;
      position: sticky;
      width: 100%;
      left: 0;
      overflow: visible;
    }

    [part~='row'] {
      display: flex;
      width: 100%;
      box-sizing: border-box;
      margin: 0;
    }

    [part~='row'][loading] [part~='body-cell'] ::slotted(vaadin-grid-cell-content) {
      opacity: 0;
    }

    #items [part~='row'] {
      position: absolute;
    }

    #items [part~='row']:empty {
      height: 100%;
    }

    [part~='cell']:not([part~='details-cell']) {
      flex-shrink: 0;
      flex-grow: 1;
      box-sizing: border-box;
      display: flex;
      width: 100%;
      position: relative;
      align-items: center;
      padding: 0;
      white-space: nowrap;
    }

    [part~='cell'] > [tabindex] {
      display: flex;
      align-items: inherit;
      outline: none;
      position: absolute;
      top: 0;
      bottom: 0;
      left: 0;
      right: 0;
    }

    [part~='details-cell'] {
      position: absolute;
      bottom: 0;
      width: 100%;
      box-sizing: border-box;
      padding: 0;
    }

    [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      display: block;
      width: 100%;
      box-sizing: border-box;
      overflow: hidden;
      text-overflow: ellipsis;
    }

    [hidden] {
      display: none !important;
    }

    [frozen],
    [frozen-to-end] {
      z-index: 2;
      will-change: transform;
    }

    [no-scrollbars][safari] #table,
    [no-scrollbars][firefox] #table {
      overflow: hidden;
    }

    /* Reordering styles */
    :host([reordering]) [part~='cell'] ::slotted(vaadin-grid-cell-content),
    :host([reordering]) [part~='resize-handle'],
    #scroller[no-content-pointer-events] [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      pointer-events: none;
    }

    [part~='reorder-ghost'] {
      visibility: hidden;
      position: fixed;
      pointer-events: none;
      opacity: 0.5;

      /* Prevent overflowing the grid in Firefox */
      top: 0;
      left: 0;
    }

    :host([reordering]) {
      -moz-user-select: none;
      -webkit-user-select: none;
      user-select: none;
    }

    /* Resizing styles */
    [part~='resize-handle'] {
      position: absolute;
      top: 0;
      right: 0;
      height: 100%;
      cursor: col-resize;
      z-index: 1;
    }

    [part~='resize-handle']::before {
      position: absolute;
      content: '';
      height: 100%;
      width: 35px;
      transform: translateX(-50%);
    }

    [last-column] [part~='resize-handle']::before,
    [last-frozen] [part~='resize-handle']::before {
      width: 18px;
      transform: none;
      right: 0;
    }

    [frozen-to-end] [part~='resize-handle'] {
      left: 0;
      right: auto;
    }

    [frozen-to-end] [part~='resize-handle']::before {
      left: 0;
      right: auto;
    }

    [first-frozen-to-end] [part~='resize-handle']::before {
      width: 18px;
      transform: none;
    }

    [first-frozen-to-end] {
      margin-inline-start: auto;
    }

    /* Hide resize handle if scrolled to end */
    :host(:not([overflow~='end'])) [first-frozen-to-end] [part~='resize-handle'] {
      display: none;
    }

    #scroller[column-resizing] {
      -ms-user-select: none;
      -moz-user-select: none;
      -webkit-user-select: none;
      user-select: none;
    }

    /* Sizer styles */
    #sizer {
      display: flex;
      position: absolute;
      visibility: hidden;
    }

    #sizer [part~='details-cell'] {
      display: none !important;
    }

    #sizer [part~='cell'][hidden] {
      display: none !important;
    }

    #sizer [part~='cell'] {
      display: block;
      flex-shrink: 0;
      line-height: 0;
      height: 0 !important;
      min-height: 0 !important;
      max-height: 0 !important;
      padding: 0 !important;
      border: none !important;
    }

    #sizer [part~='cell']::before {
      content: '-';
    }

    #sizer [part~='cell'] ::slotted(vaadin-grid-cell-content) {
      display: none !important;
    }

    /* RTL specific styles */

    :host([dir='rtl']) #items,
    :host([dir='rtl']) #header,
    :host([dir='rtl']) #footer {
      left: auto;
    }

    :host([dir='rtl']) [part~='reorder-ghost'] {
      left: auto;
      right: 0;
    }

    :host([dir='rtl']) [part~='resize-handle'] {
      left: 0;
      right: auto;
    }

    :host([dir='rtl']) [part~='resize-handle']::before {
      transform: translateX(50%);
    }

    :host([dir='rtl']) [last-column] [part~='resize-handle']::before,
    :host([dir='rtl']) [last-frozen] [part~='resize-handle']::before {
      left: 0;
      right: auto;
    }

    :host([dir='rtl']) [frozen-to-end] [part~='resize-handle'] {
      right: 0;
      left: auto;
    }

    :host([dir='rtl']) [frozen-to-end] [part~='resize-handle']::before {
      right: 0;
      left: auto;
    }
  `,{moduleId:"vaadin-grid-styles"});/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/let scheduled=!1,beforeRenderQueue=[],afterRenderQueue=[];function schedule(){scheduled=!0,requestAnimationFrame(function(){scheduled=!1,flushQueue(beforeRenderQueue),setTimeout(function(){runQueue(afterRenderQueue)})})}function flushQueue(j){for(;j.length;)callMethod(j.shift())}function runQueue(j){for(let E=0,a=j.length;E<a;E++)callMethod(j.shift())}function callMethod(j){const E=j[0],a=j[1],k=j[2];try{a.apply(E,k)}catch(tt){setTimeout(()=>{throw tt})}}function beforeNextRender(j,E,a){scheduled||schedule(),beforeRenderQueue.push([j,E,a])}function afterNextRender(j,E,a){scheduled||schedule(),afterRenderQueue.push([j,E,a])}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const testUserAgent=j=>j.test(navigator.userAgent),testPlatform=j=>j.test(navigator.platform),testVendor=j=>j.test(navigator.vendor),isAndroid=testUserAgent(/Android/u),isChrome=testUserAgent(/Chrome/u)&&testVendor(/Google Inc/u),isFirefox$4=testUserAgent(/Firefox/u),isIPad=testPlatform(/^iPad/u)||testPlatform(/^Mac/u)&&navigator.maxTouchPoints>1,isIPhone=testPlatform(/^iPhone/u),isIOS=isIPhone||isIPad,isSafari=testUserAgent(/^((?!chrome|android).)*safari/iu),isTouch=(()=>{try{return document.createEvent("TouchEvent"),!0}catch{return!1}})();/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
 */const IOS=navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/u),IOS_TOUCH_SCROLLING=IOS&&IOS[1]>=8,DEFAULT_PHYSICAL_COUNT=3,ironList={_ratio:.5,_scrollerPaddingTop:0,_scrollPosition:0,_physicalSize:0,_physicalAverage:0,_physicalAverageCount:0,_physicalTop:0,_virtualCount:0,_estScrollHeight:0,_scrollHeight:0,_viewportHeight:0,_viewportWidth:0,_physicalItems:null,_physicalSizes:null,_firstVisibleIndexVal:null,_lastVisibleIndexVal:null,_maxPages:2,_templateCost:0,get _physicalBottom(){return this._physicalTop+this._physicalSize},get _scrollBottom(){return this._scrollPosition+this._viewportHeight},get _virtualEnd(){return this._virtualStart+this._physicalCount-1},get _hiddenContentSize(){return this._physicalSize-this._viewportHeight},get _maxScrollTop(){return this._estScrollHeight-this._viewportHeight+this._scrollOffset},get _maxVirtualStart(){const j=this._virtualCount;return Math.max(0,j-this._physicalCount)},get _virtualStart(){return this._virtualStartVal||0},set _virtualStart(j){j=this._clamp(j,0,this._maxVirtualStart),this._virtualStartVal=j},get _physicalStart(){return this._physicalStartVal||0},set _physicalStart(j){j%=this._physicalCount,j<0&&(j=this._physicalCount+j),this._physicalStartVal=j},get _physicalEnd(){return(this._physicalStart+this._physicalCount-1)%this._physicalCount},get _physicalCount(){return this._physicalCountVal||0},set _physicalCount(j){this._physicalCountVal=j},get _optPhysicalSize(){return this._viewportHeight===0?1/0:this._viewportHeight*this._maxPages},get _isVisible(){return Boolean(this.offsetWidth||this.offsetHeight)},get firstVisibleIndex(){let j=this._firstVisibleIndexVal;if(j==null){let E=this._physicalTop+this._scrollOffset;j=this._iterateItems((a,k)=>{if(E+=this._getPhysicalSizeIncrement(a),E>this._scrollPosition)return k})||0,this._firstVisibleIndexVal=j}return j},get lastVisibleIndex(){let j=this._lastVisibleIndexVal;if(j==null){let E=this._physicalTop+this._scrollOffset;this._iterateItems((a,k)=>{E<this._scrollBottom&&(j=k),E+=this._getPhysicalSizeIncrement(a)}),this._lastVisibleIndexVal=j}return j},get _scrollOffset(){return this._scrollerPaddingTop+this.scrollOffset},_scrollHandler(){const j=Math.max(0,Math.min(this._maxScrollTop,this._scrollTop));let E=j-this._scrollPosition;const a=E>=0;if(this._scrollPosition=j,this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,Math.abs(E)>this._physicalSize&&this._physicalSize>0){E-=this._scrollOffset;const k=Math.round(E/this._physicalAverage);this._virtualStart+=k,this._physicalStart+=k,this._physicalTop=Math.min(Math.floor(this._virtualStart)*this._physicalAverage,this._scrollPosition),this._update()}else if(this._physicalCount>0){const k=this._getReusables(a);a?(this._physicalTop=k.physicalTop,this._virtualStart+=k.indexes.length,this._physicalStart+=k.indexes.length):(this._virtualStart-=k.indexes.length,this._physicalStart-=k.indexes.length),this._update(k.indexes,a?null:k.indexes),this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,0),microTask)}},_getReusables(j){let E,a,k;const tt=[],et=this._hiddenContentSize*this._ratio,rt=this._virtualStart,nt=this._virtualEnd,ot=this._physicalCount;let st=this._physicalTop+this._scrollOffset;const lt=this._physicalBottom+this._scrollOffset,ht=this._scrollPosition,ut=this._scrollBottom;for(j?(E=this._physicalStart,a=ht-st):(E=this._physicalEnd,a=lt-ut);k=this._getPhysicalSizeIncrement(E),a-=k,!(tt.length>=ot||a<=et);)if(j){if(nt+tt.length+1>=this._virtualCount||st+k>=ht-this._scrollOffset)break;tt.push(E),st+=k,E=(E+1)%ot}else{if(rt-tt.length<=0||st+this._physicalSize-k<=ut)break;tt.push(E),st-=k,E=E===0?ot-1:E-1}return{indexes:tt,physicalTop:st-this._scrollOffset}},_update(j,E){if(!(j&&j.length===0||this._physicalCount===0)){if(this._assignModels(j),this._updateMetrics(j),E)for(;E.length;){const a=E.pop();this._physicalTop-=this._getPhysicalSizeIncrement(a)}this._positionItems(),this._updateScrollerSize()}},_isClientFull(){return this._scrollBottom!==0&&this._physicalBottom-1>=this._scrollBottom&&this._physicalTop<=this._scrollPosition},_increasePoolIfNeeded(j){const a=this._clamp(this._physicalCount+j,DEFAULT_PHYSICAL_COUNT,this._virtualCount-this._virtualStart)-this._physicalCount;let k=Math.round(this._physicalCount*.5);if(!(a<0)){if(a>0){const tt=window.performance.now();[].push.apply(this._physicalItems,this._createPool(a));for(let et=0;et<a;et++)this._physicalSizes.push(0);this._physicalCount+=a,this._physicalStart>this._physicalEnd&&this._isIndexRendered(this._focusedVirtualIndex)&&this._getPhysicalIndex(this._focusedVirtualIndex)<this._physicalEnd&&(this._physicalStart+=a),this._update(),this._templateCost=(window.performance.now()-tt)/a,k=Math.round(this._physicalCount*.5)}this._virtualEnd>=this._virtualCount-1||k===0||(this._isClientFull()?this._physicalSize<this._optPhysicalSize&&this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,this._clamp(Math.round(50/this._templateCost),1,k)),idlePeriod):this._debounce("_increasePoolIfNeeded",this._increasePoolIfNeeded.bind(this,k),microTask))}},_render(){if(!(!this.isAttached||!this._isVisible))if(this._physicalCount!==0){const j=this._getReusables(!0);this._physicalTop=j.physicalTop,this._virtualStart+=j.indexes.length,this._physicalStart+=j.indexes.length,this._update(j.indexes),this._update(),this._increasePoolIfNeeded(0)}else this._virtualCount>0&&(this.updateViewportBoundaries(),this._increasePoolIfNeeded(DEFAULT_PHYSICAL_COUNT))},_itemsChanged(j){j.path==="items"&&(this._virtualStart=0,this._physicalTop=0,this._virtualCount=this.items?this.items.length:0,this._physicalIndexForKey={},this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,this._physicalItems||(this._physicalItems=[]),this._physicalSizes||(this._physicalSizes=[]),this._physicalStart=0,this._scrollTop>this._scrollOffset&&this._resetScrollPosition(0),this._debounce("_render",this._render,animationFrame))},_iterateItems(j,E){let a,k,tt,et;if(arguments.length===2&&E){for(et=0;et<E.length;et++)if(a=E[et],k=this._computeVidx(a),(tt=j.call(this,a,k))!=null)return tt}else{for(a=this._physicalStart,k=this._virtualStart;a<this._physicalCount;a++,k++)if((tt=j.call(this,a,k))!=null)return tt;for(a=0;a<this._physicalStart;a++,k++)if((tt=j.call(this,a,k))!=null)return tt}},_computeVidx(j){return j>=this._physicalStart?this._virtualStart+(j-this._physicalStart):this._virtualStart+(this._physicalCount-this._physicalStart)+j},_positionItems(){this._adjustScrollPosition();let j=this._physicalTop;this._iterateItems(E=>{this.translate3d(0,`${j}px`,0,this._physicalItems[E]),j+=this._physicalSizes[E]})},_getPhysicalSizeIncrement(j){return this._physicalSizes[j]},_adjustScrollPosition(){const j=this._virtualStart===0?this._physicalTop:Math.min(this._scrollPosition+this._physicalTop,0);if(j!==0){this._physicalTop-=j;const E=this._scrollPosition;!IOS_TOUCH_SCROLLING&&E>0&&this._resetScrollPosition(E-j)}},_resetScrollPosition(j){this.scrollTarget&&j>=0&&(this._scrollTop=j,this._scrollPosition=this._scrollTop)},_updateScrollerSize(j){const E=this._physicalBottom+Math.max(this._virtualCount-this._physicalCount-this._virtualStart,0)*this._physicalAverage;this._estScrollHeight=E,(j||this._scrollHeight===0||this._scrollPosition>=E-this._physicalSize||Math.abs(E-this._scrollHeight)>=this._viewportHeight)&&(this.$.items.style.height=`${E}px`,this._scrollHeight=E)},scrollToIndex(j){if(typeof j!="number"||j<0||j>this.items.length-1||(flush$1(),this._physicalCount===0))return;j=this._clamp(j,0,this._virtualCount-1),(!this._isIndexRendered(j)||j>=this._maxVirtualStart)&&(this._virtualStart=j-1),this._assignModels(),this._updateMetrics(),this._physicalTop=this._virtualStart*this._physicalAverage;let E=this._physicalStart,a=this._virtualStart,k=0;const tt=this._hiddenContentSize;for(;a<j&&k<=tt;)k+=this._getPhysicalSizeIncrement(E),E=(E+1)%this._physicalCount,a+=1;this._updateScrollerSize(!0),this._positionItems(),this._resetScrollPosition(this._physicalTop+this._scrollOffset+k),this._increasePoolIfNeeded(0),this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null},_resetAverage(){this._physicalAverage=0,this._physicalAverageCount=0},_resizeHandler(){this._debounce("_render",()=>{this._firstVisibleIndexVal=null,this._lastVisibleIndexVal=null,this._isVisible?(this.updateViewportBoundaries(),this.toggleScrollListener(!0),this._resetAverage(),this._render()):this.toggleScrollListener(!1)},animationFrame)},_isIndexRendered(j){return j>=this._virtualStart&&j<=this._virtualEnd},_getPhysicalIndex(j){return(this._physicalStart+(j-this._virtualStart))%this._physicalCount},_clamp(j,E,a){return Math.min(a,Math.max(E,j))},_debounce(j,E,a){this._debouncers||(this._debouncers={}),this._debouncers[j]=Debouncer$1.debounce(this._debouncers[j],a,E.bind(this)),enqueueDebouncer$1(this._debouncers[j])}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MAX_VIRTUAL_COUNT=1e5,OFFSET_ADJUST_MIN_THRESHOLD=1e3;class IronListAdapter{constructor({createElements:E,updateElement:a,scrollTarget:k,scrollContainer:tt,elementsContainer:et,reorderElements:rt}){this.isAttached=!0,this._vidxOffset=0,this.createElements=E,this.updateElement=a,this.scrollTarget=k,this.scrollContainer=tt,this.elementsContainer=et||tt,this.reorderElements=rt,this._maxPages=1.3,this.__placeholderHeight=200,this.__elementHeightQueue=Array(10),this.timeouts={SCROLL_REORDER:500,IGNORE_WHEEL:500,FIX_INVALID_ITEM_POSITIONING:100},this.__resizeObserver=new ResizeObserver(()=>this._resizeHandler()),getComputedStyle(this.scrollTarget).overflow==="visible"&&(this.scrollTarget.style.overflow="auto"),getComputedStyle(this.scrollContainer).position==="static"&&(this.scrollContainer.style.position="relative"),this.__resizeObserver.observe(this.scrollTarget),this.scrollTarget.addEventListener("scroll",()=>this._scrollHandler()),this._scrollLineHeight=this._getScrollLineHeight(),this.scrollTarget.addEventListener("wheel",nt=>this.__onWheel(nt)),this.reorderElements&&(this.scrollTarget.addEventListener("mousedown",()=>{this.__mouseDown=!0}),this.scrollTarget.addEventListener("mouseup",()=>{this.__mouseDown=!1,this.__pendingReorder&&this.__reorderElements()}))}get scrollOffset(){return 0}get adjustedFirstVisibleIndex(){return this.firstVisibleIndex+this._vidxOffset}get adjustedLastVisibleIndex(){return this.lastVisibleIndex+this._vidxOffset}scrollToIndex(E){if(typeof E!="number"||isNaN(E)||this.size===0||!this.scrollTarget.offsetHeight)return;E=this._clamp(E,0,this.size-1);const a=this.__getVisibleElements().length;let k=Math.floor(E/this.size*this._virtualCount);this._virtualCount-k<a?(k=this._virtualCount-(this.size-E),this._vidxOffset=this.size-this._virtualCount):k<a?E<OFFSET_ADJUST_MIN_THRESHOLD?(k=E,this._vidxOffset=0):(k=OFFSET_ADJUST_MIN_THRESHOLD,this._vidxOffset=E-k):this._vidxOffset=E-k,this.__skipNextVirtualIndexAdjust=!0,super.scrollToIndex(k),this.adjustedFirstVisibleIndex!==E&&this._scrollTop<this._maxScrollTop&&!this.grid&&(this._scrollTop-=this.__getIndexScrollOffset(E)||0),this._scrollHandler()}flush(){this.scrollTarget.offsetHeight!==0&&(this._resizeHandler(),flush$1(),this._scrollHandler(),this.__fixInvalidItemPositioningDebouncer&&this.__fixInvalidItemPositioningDebouncer.flush(),this.__scrollReorderDebouncer&&this.__scrollReorderDebouncer.flush(),this.__debouncerWheelAnimationFrame&&this.__debouncerWheelAnimationFrame.flush())}update(E=0,a=this.size-1){this.__getVisibleElements().forEach(k=>{k.__virtualIndex>=E&&k.__virtualIndex<=a&&this.__updateElement(k,k.__virtualIndex,!0)})}_updateMetrics(E){flush$1();let a=0,k=0;const tt=this._physicalAverageCount,et=this._physicalAverage;this._iterateItems((rt,nt)=>{k+=this._physicalSizes[rt],this._physicalSizes[rt]=Math.ceil(this.__getBorderBoxHeight(this._physicalItems[rt])),a+=this._physicalSizes[rt],this._physicalAverageCount+=this._physicalSizes[rt]?1:0},E),this._physicalSize=this._physicalSize+a-k,this._physicalAverageCount!==tt&&(this._physicalAverage=Math.round((et*tt+a)/this._physicalAverageCount))}__getBorderBoxHeight(E){const a=getComputedStyle(E),k=parseFloat(a.height)||0;if(a.boxSizing==="border-box")return k;const tt=parseFloat(a.paddingBottom)||0,et=parseFloat(a.paddingTop)||0,rt=parseFloat(a.borderBottomWidth)||0,nt=parseFloat(a.borderTopWidth)||0;return k+tt+et+rt+nt}__updateElement(E,a,k){E.style.paddingTop&&(E.style.paddingTop=""),!this.__preventElementUpdates&&(E.__lastUpdatedIndex!==a||k)&&(this.updateElement(E,a),E.__lastUpdatedIndex=a);const tt=E.offsetHeight;if(tt===0)E.style.paddingTop=`${this.__placeholderHeight}px`,requestAnimationFrame(()=>this._resizeHandler());else{this.__elementHeightQueue.push(tt),this.__elementHeightQueue.shift();const et=this.__elementHeightQueue.filter(rt=>rt!==void 0);this.__placeholderHeight=Math.round(et.reduce((rt,nt)=>rt+nt,0)/et.length)}}__getIndexScrollOffset(E){const a=this.__getVisibleElements().find(k=>k.__virtualIndex===E);return a?this.scrollTarget.getBoundingClientRect().top-a.getBoundingClientRect().top:void 0}get size(){return this.__size}set size(E){if(E===this.size)return;this.__fixInvalidItemPositioningDebouncer&&this.__fixInvalidItemPositioningDebouncer.cancel(),this._debouncers&&this._debouncers._increasePoolIfNeeded&&this._debouncers._increasePoolIfNeeded.cancel(),this.__preventElementUpdates=!0;let a,k;if(E>0&&(a=this.adjustedFirstVisibleIndex,k=this.__getIndexScrollOffset(a)),this.__size=E,this._itemsChanged({path:"items"}),flush$1(),E>0){a=Math.min(a,E-1),this.scrollToIndex(a);const tt=this.__getIndexScrollOffset(a);k!==void 0&&tt!==void 0&&(this._scrollTop+=k-tt)}this.elementsContainer.children.length||requestAnimationFrame(()=>this._resizeHandler()),this.__preventElementUpdates=!1,this._resizeHandler(),flush$1()}get _scrollTop(){return this.scrollTarget.scrollTop}set _scrollTop(E){this.scrollTarget.scrollTop=E}get items(){return{length:Math.min(this.size,MAX_VIRTUAL_COUNT)}}get offsetHeight(){return this.scrollTarget.offsetHeight}get $(){return{items:this.scrollContainer}}updateViewportBoundaries(){const E=window.getComputedStyle(this.scrollTarget);this._scrollerPaddingTop=this.scrollTarget===this?0:parseInt(E["padding-top"],10),this._isRTL=Boolean(E.direction==="rtl"),this._viewportWidth=this.elementsContainer.offsetWidth,this._viewportHeight=this.scrollTarget.offsetHeight,this._scrollPageHeight=this._viewportHeight-this._scrollLineHeight,this.grid&&this._updateGridMetrics()}setAttribute(){}_createPool(E){const a=this.createElements(E),k=document.createDocumentFragment();return a.forEach(tt=>{tt.style.position="absolute",k.appendChild(tt),this.__resizeObserver.observe(tt)}),this.elementsContainer.appendChild(k),a}_assignModels(E){this._iterateItems((a,k)=>{const tt=this._physicalItems[a];tt.hidden=k>=this.size,tt.hidden?delete tt.__lastUpdatedIndex:(tt.__virtualIndex=k+(this._vidxOffset||0),this.__updateElement(tt,tt.__virtualIndex))},E)}_isClientFull(){return setTimeout(()=>{this.__clientFull=!0}),this.__clientFull||super._isClientFull()}translate3d(E,a,k,tt){tt.style.transform=`translateY(${a})`}toggleScrollListener(){}_scrollHandler(){this._adjustVirtualIndexOffset(this._scrollTop-(this.__previousScrollTop||0));const E=this.scrollTarget.scrollTop-this._scrollPosition;if(super._scrollHandler(),this._physicalCount!==0){const a=E>=0,k=this._getReusables(!a);k.indexes.length&&(this._physicalTop=k.physicalTop,a?(this._virtualStart-=k.indexes.length,this._physicalStart-=k.indexes.length):(this._virtualStart+=k.indexes.length,this._physicalStart+=k.indexes.length),this._resizeHandler())}E&&(this.__fixInvalidItemPositioningDebouncer=Debouncer$1.debounce(this.__fixInvalidItemPositioningDebouncer,timeOut.after(this.timeouts.FIX_INVALID_ITEM_POSITIONING),()=>this.__fixInvalidItemPositioning())),this.reorderElements&&(this.__scrollReorderDebouncer=Debouncer$1.debounce(this.__scrollReorderDebouncer,timeOut.after(this.timeouts.SCROLL_REORDER),()=>this.__reorderElements())),this.__previousScrollTop=this._scrollTop,this._scrollTop===0&&this.firstVisibleIndex!==0&&Math.abs(E)>0&&this.scrollToIndex(0)}__fixInvalidItemPositioning(){if(!this.scrollTarget.isConnected)return;const E=this._physicalTop>this._scrollTop,a=this._physicalBottom<this._scrollBottom,k=this.adjustedFirstVisibleIndex===0,tt=this.adjustedLastVisibleIndex===this.size-1;if(E&&!k||a&&!tt){const et=a,rt=this._ratio;this._ratio=0,this._scrollPosition=this._scrollTop+(et?-1:1),this._scrollHandler(),this._ratio=rt}}__onWheel(E){if(E.ctrlKey||this._hasScrolledAncestor(E.target,E.deltaX,E.deltaY))return;let a=E.deltaY;if(E.deltaMode===WheelEvent.DOM_DELTA_LINE?a*=this._scrollLineHeight:E.deltaMode===WheelEvent.DOM_DELTA_PAGE&&(a*=this._scrollPageHeight),this._deltaYAcc||(this._deltaYAcc=0),this._wheelAnimationFrame){this._deltaYAcc+=a,E.preventDefault();return}a+=this._deltaYAcc,this._deltaYAcc=0,this._wheelAnimationFrame=!0,this.__debouncerWheelAnimationFrame=Debouncer$1.debounce(this.__debouncerWheelAnimationFrame,animationFrame,()=>{this._wheelAnimationFrame=!1});const k=Math.abs(E.deltaX)+Math.abs(a);this._canScroll(this.scrollTarget,E.deltaX,a)?(E.preventDefault(),this.scrollTarget.scrollTop+=a,this.scrollTarget.scrollLeft+=E.deltaX,this._hasResidualMomentum=!0,this._ignoreNewWheel=!0,this._debouncerIgnoreNewWheel=Debouncer$1.debounce(this._debouncerIgnoreNewWheel,timeOut.after(this.timeouts.IGNORE_WHEEL),()=>{this._ignoreNewWheel=!1})):this._hasResidualMomentum&&k<=this._previousMomentum||this._ignoreNewWheel?E.preventDefault():k>this._previousMomentum&&(this._hasResidualMomentum=!1),this._previousMomentum=k}_hasScrolledAncestor(E,a,k){if(E===this.scrollTarget||E===this.scrollTarget.getRootNode().host)return!1;if(this._canScroll(E,a,k)&&["auto","scroll"].indexOf(getComputedStyle(E).overflow)!==-1)return!0;if(E!==this&&E.parentElement)return this._hasScrolledAncestor(E.parentElement,a,k)}_canScroll(E,a,k){return k>0&&E.scrollTop<E.scrollHeight-E.offsetHeight||k<0&&E.scrollTop>0||a>0&&E.scrollLeft<E.scrollWidth-E.offsetWidth||a<0&&E.scrollLeft>0}_getScrollLineHeight(){const E=document.createElement("div");E.style.fontSize="initial",E.style.display="none",document.body.appendChild(E);const a=window.getComputedStyle(E).fontSize;return document.body.removeChild(E),a?window.parseInt(a):void 0}__getVisibleElements(){return Array.from(this.elementsContainer.children).filter(E=>!E.hidden)}__reorderElements(){if(this.__mouseDown){this.__pendingReorder=!0;return}this.__pendingReorder=!1;const E=this._virtualStart+(this._vidxOffset||0),a=this.__getVisibleElements(),tt=a.find(nt=>nt.contains(this.elementsContainer.getRootNode().activeElement)||nt.contains(this.scrollTarget.getRootNode().activeElement))||a[0];if(!tt)return;const et=tt.__virtualIndex-E,rt=a.indexOf(tt)-et;if(rt>0)for(let nt=0;nt<rt;nt++)this.elementsContainer.appendChild(a[nt]);else if(rt<0)for(let nt=a.length+rt;nt<a.length;nt++)this.elementsContainer.insertBefore(a[nt],a[0]);if(isSafari){const{transform:nt}=this.scrollTarget.style;this.scrollTarget.style.transform="translateZ(0)",setTimeout(()=>{this.scrollTarget.style.transform=nt})}}_adjustVirtualIndexOffset(E){if(this._virtualCount>=this.size)this._vidxOffset=0;else if(this.__skipNextVirtualIndexAdjust)this.__skipNextVirtualIndexAdjust=!1;else if(Math.abs(E)>1e4){const a=this._scrollTop/(this.scrollTarget.scrollHeight-this.scrollTarget.offsetHeight),k=a*this.size;this._vidxOffset=Math.round(k-a*this._virtualCount)}else{const a=this._vidxOffset,k=OFFSET_ADJUST_MIN_THRESHOLD,tt=100;this._scrollTop===0?(this._vidxOffset=0,a!==this._vidxOffset&&super.scrollToIndex(0)):this.firstVisibleIndex<k&&this._vidxOffset>0&&(this._vidxOffset-=Math.min(this._vidxOffset,tt),super.scrollToIndex(this.firstVisibleIndex+(a-this._vidxOffset)));const et=this.size-this._virtualCount;this._scrollTop>=this._maxScrollTop&&this._maxScrollTop>0?(this._vidxOffset=et,a!==this._vidxOffset&&super.scrollToIndex(this._virtualCount-1)):this.firstVisibleIndex>this._virtualCount-k&&this._vidxOffset<et&&(this._vidxOffset+=Math.min(et-this._vidxOffset,tt),super.scrollToIndex(this.firstVisibleIndex-(this._vidxOffset-a)))}}}Object.setPrototypeOf(IronListAdapter.prototype,ironList);class Virtualizer{constructor(E){this.__adapter=new IronListAdapter(E)}get firstVisibleIndex(){return this.__adapter.adjustedFirstVisibleIndex}get lastVisibleIndex(){return this.__adapter.adjustedLastVisibleIndex}get size(){return this.__adapter.size}set size(E){this.__adapter.size=E}scrollToIndex(E){this.__adapter.scrollToIndex(E)}update(E=0,a=this.size-1){this.__adapter.update(E,a)}flush(){this.__adapter.flush()}}/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const A11yMixin=j=>class extends j{static get observers(){return["_a11yUpdateGridSize(size, _columnTree, _columnTree.*)"]}_a11yGetHeaderRowCount(a){return a.filter(k=>k.some(tt=>tt.headerRenderer||tt.path||tt.header)).length}_a11yGetFooterRowCount(a){return a.filter(k=>k.some(tt=>tt.headerRenderer)).length}_a11yUpdateGridSize(a,k){if(a===void 0||k===void 0)return;const tt=k[k.length-1];this.$.table.setAttribute("aria-rowcount",a+this._a11yGetHeaderRowCount(k)+this._a11yGetFooterRowCount(k)),this.$.table.setAttribute("aria-colcount",tt&&tt.length||0),this._a11yUpdateHeaderRows(),this._a11yUpdateFooterRows()}_a11yUpdateHeaderRows(){iterateChildren(this.$.header,(a,k)=>{a.setAttribute("aria-rowindex",k+1)})}_a11yUpdateFooterRows(){iterateChildren(this.$.footer,(a,k)=>{a.setAttribute("aria-rowindex",this._a11yGetHeaderRowCount(this._columnTree)+this.size+k+1)})}_a11yUpdateRowRowindex(a,k){a.setAttribute("aria-rowindex",k+this._a11yGetHeaderRowCount(this._columnTree)+1)}_a11yUpdateRowSelected(a,k){a.setAttribute("aria-selected",Boolean(k)),iterateChildren(a,tt=>{tt.setAttribute("aria-selected",Boolean(k))})}_a11yUpdateRowExpanded(a){this.__isRowExpandable(a)?a.setAttribute("aria-expanded","false"):this.__isRowCollapsible(a)?a.setAttribute("aria-expanded","true"):a.removeAttribute("aria-expanded")}_a11yUpdateRowLevel(a,k){k>0||this.__isRowCollapsible(a)||this.__isRowExpandable(a)?a.setAttribute("aria-level",k+1):a.removeAttribute("aria-level")}_a11ySetRowDetailsCell(a,k){iterateChildren(a,tt=>{tt!==k&&tt.setAttribute("aria-controls",k.id)})}_a11yUpdateCellColspan(a,k){a.setAttribute("aria-colspan",Number(k))}_a11yUpdateSorters(){Array.from(this.querySelectorAll("vaadin-grid-sorter")).forEach(a=>{let k=a.parentNode;for(;k&&k.localName!=="vaadin-grid-cell-content";)k=k.parentNode;k&&k.assignedSlot&&k.assignedSlot.parentNode.setAttribute("aria-sort",{asc:"ascending",desc:"descending"}[String(a.direction)]||"none")})}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const isFocusable=j=>{if(!j.parentNode)return!1;const a=Array.from(j.parentNode.querySelectorAll("[tabindex], button, input, select, textarea, object, iframe, a[href], area[href]")).filter(k=>{const tt=k.getAttribute("part");return!(tt&&tt.includes("body-cell"))}).includes(j);return!j.disabled&&a&&j.offsetParent&&getComputedStyle(j).visibility!=="hidden"},ActiveItemMixin=j=>class extends j{static get properties(){return{activeItem:{type:Object,notify:!0,value:null}}}ready(){super.ready(),this.$.scroller.addEventListener("click",this._onClick.bind(this)),this.addEventListener("cell-activate",this._activateItem.bind(this)),this.addEventListener("row-activate",this._activateItem.bind(this))}_activateItem(a){const k=a.detail.model,tt=k?k.item:null;tt&&(this.activeItem=this._itemsEqual(this.activeItem,tt)?null:tt)}_onClick(a){if(a.defaultPrevented)return;const k=a.composedPath(),tt=k[k.indexOf(this.$.table)-3];if(!tt||tt.getAttribute("part").indexOf("details-cell")>-1)return;const et=tt._content,rt=this.getRootNode().activeElement;!et.contains(rt)&&!this._isFocusable(a.target)&&!(a.target instanceof HTMLLabelElement)&&this.dispatchEvent(new CustomEvent("cell-activate",{detail:{model:this.__getRowModel(tt.parentElement)}}))}_isFocusable(a){return isFocusable(a)}};function get$5(j,E){return j.split(".").reduce((a,k)=>a[k],E)}function checkPaths(j,E,a){if(a.length===0)return!1;let k=!0;return j.forEach(({path:tt})=>{if(!tt||tt.indexOf(".")===-1)return;const et=tt.replace(/\.[^.]*$/u,"");get$5(et,a[0])===void 0&&(console.warn(`Path "${tt}" used for ${E} does not exist in all of the items, ${E} is disabled.`),k=!1)}),k}function normalizeEmptyValue(j){return[void 0,null].indexOf(j)>=0?"":isNaN(j)?j.toString():j}function compare(j,E){return j=normalizeEmptyValue(j),E=normalizeEmptyValue(E),j<E?-1:j>E?1:0}function multiSort(j,E){return j.sort((a,k)=>E.map(tt=>tt.direction==="asc"?compare(get$5(tt.path,a),get$5(tt.path,k)):tt.direction==="desc"?compare(get$5(tt.path,k),get$5(tt.path,a)):0).reduce((tt,et)=>tt!==0?tt:et,0))}function filter(j,E){return j.filter(a=>E.every(k=>{const tt=normalizeEmptyValue(get$5(k.path,a)),et=normalizeEmptyValue(k.value).toString().toLowerCase();return tt.toString().toLowerCase().includes(et)}))}const createArrayDataProvider=j=>(E,a)=>{let k=j?[...j]:[];E.filters&&checkPaths(E.filters,"filtering",k)&&(k=filter(k,E.filters)),Array.isArray(E.sortOrders)&&E.sortOrders.length&&checkPaths(E.sortOrders,"sorting",k)&&(k=multiSort(k,E.sortOrders));const tt=Math.min(k.length,E.pageSize),et=E.page*tt,rt=et+tt,nt=k.slice(et,rt);a(nt,k.length)};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ArrayDataProviderMixin=j=>class extends j{static get properties(){return{items:Array}}static get observers(){return["__dataProviderOrItemsChanged(dataProvider, items, isAttached, items.*, _filters, _sorters)"]}__setArrayDataProvider(a){const k=createArrayDataProvider(this.items);k.__items=a,this.setProperties({_arrayDataProvider:k,size:a.length,dataProvider:k})}__dataProviderOrItemsChanged(a,k,tt){tt&&(this._arrayDataProvider?a!==this._arrayDataProvider?this.setProperties({_arrayDataProvider:void 0,items:void 0}):k?this._arrayDataProvider.__items===k?(this.clearCache(),this.size=this._effectiveSize):this.__setArrayDataProvider(k):(this.setProperties({_arrayDataProvider:void 0,dataProvider:void 0,size:0}),this.clearCache()):k&&this.__setArrayDataProvider(k))}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ColumnReorderingMixin=j=>class extends j{static get properties(){return{columnReorderingAllowed:{type:Boolean,value:!1},_orderBaseScope:{type:Number,value:1e7}}}static get observers(){return["_updateOrders(_columnTree)"]}ready(){super.ready(),addListener(this,"track",this._onTrackEvent),this._reorderGhost=this.shadowRoot.querySelector('[part="reorder-ghost"]'),this.addEventListener("touchstart",this._onTouchStart.bind(this)),this.addEventListener("touchmove",this._onTouchMove.bind(this)),this.addEventListener("touchend",this._onTouchEnd.bind(this)),this.addEventListener("contextmenu",this._onContextMenu.bind(this))}_onContextMenu(a){this.hasAttribute("reordering")&&(a.preventDefault(),isTouch||this._onTrackEnd())}_onTouchStart(a){this._startTouchReorderTimeout=setTimeout(()=>{this._onTrackStart({detail:{x:a.touches[0].clientX,y:a.touches[0].clientY}})},100)}_onTouchMove(a){this._draggedColumn&&a.preventDefault(),clearTimeout(this._startTouchReorderTimeout)}_onTouchEnd(){clearTimeout(this._startTouchReorderTimeout),this._onTrackEnd()}_onTrackEvent(a){if(a.detail.state==="start"){const k=a.composedPath(),tt=k[k.indexOf(this.$.header)-2];if(!tt||!tt._content||tt._content.contains(this.getRootNode().activeElement)||this.$.scroller.hasAttribute("column-resizing"))return;this._touchDevice||this._onTrackStart(a)}else a.detail.state==="track"?this._onTrack(a):a.detail.state==="end"&&this._onTrackEnd(a)}_onTrackStart(a){if(!this.columnReorderingAllowed)return;const k=a.composedPath&&a.composedPath();if(k&&k.some(et=>et.hasAttribute&&et.hasAttribute("draggable")))return;const tt=this._cellFromPoint(a.detail.x,a.detail.y);if(!(!tt||!tt.getAttribute("part").includes("header-cell"))){for(this.toggleAttribute("reordering",!0),this._draggedColumn=tt._column;this._draggedColumn.parentElement.childElementCount===1;)this._draggedColumn=this._draggedColumn.parentElement;this._setSiblingsReorderStatus(this._draggedColumn,"allowed"),this._draggedColumn._reorderStatus="dragging",this._updateGhost(tt),this._reorderGhost.style.visibility="visible",this._updateGhostPosition(a.detail.x,this._touchDevice?a.detail.y-50:a.detail.y),this._autoScroller()}}_onTrack(a){if(!this._draggedColumn)return;const k=this._cellFromPoint(a.detail.x,a.detail.y);if(!k)return;const tt=this._getTargetColumn(k,this._draggedColumn);if(this._isSwapAllowed(this._draggedColumn,tt)&&this._isSwappableByPosition(tt,a.detail.x)){const et=this._columnTree.findIndex(lt=>lt.includes(tt)),rt=this._getColumnsInOrder(et),nt=rt.indexOf(this._draggedColumn),ot=rt.indexOf(tt),st=nt<ot?1:-1;for(let lt=nt;lt!==ot;lt+=st)this._swapColumnOrders(this._draggedColumn,rt[lt+st])}this._updateGhostPosition(a.detail.x,this._touchDevice?a.detail.y-50:a.detail.y),this._lastDragClientX=a.detail.x}_onTrackEnd(){this._draggedColumn&&(this.toggleAttribute("reordering",!1),this._draggedColumn._reorderStatus="",this._setSiblingsReorderStatus(this._draggedColumn,""),this._draggedColumn=null,this._lastDragClientX=null,this._reorderGhost.style.visibility="hidden",this.dispatchEvent(new CustomEvent("column-reorder",{detail:{columns:this._getColumnsInOrder()}})))}_getColumnsInOrder(a=this._columnTree.length-1){return this._columnTree[a].filter(k=>!k.hidden).sort((k,tt)=>k._order-tt._order)}_cellFromPoint(a=0,k=0){this._draggedColumn||this.$.scroller.toggleAttribute("no-content-pointer-events",!0);const tt=this.shadowRoot.elementFromPoint(a,k);if(this.$.scroller.toggleAttribute("no-content-pointer-events",!1),tt&&tt._column)return tt}_updateGhostPosition(a,k){const tt=this._reorderGhost.getBoundingClientRect(),et=a-tt.width/2,rt=k-tt.height/2,nt=parseInt(this._reorderGhost._left||0),ot=parseInt(this._reorderGhost._top||0);this._reorderGhost._left=nt-(tt.left-et),this._reorderGhost._top=ot-(tt.top-rt),this._reorderGhost.style.transform=`translate(${this._reorderGhost._left}px, ${this._reorderGhost._top}px)`}_updateGhost(a){const k=this._reorderGhost;k.textContent=a._content.innerText;const tt=window.getComputedStyle(a);return["boxSizing","display","width","height","background","alignItems","padding","border","flex-direction","overflow"].forEach(et=>{k.style[et]=tt[et]}),k}_updateOrders(a){a!==void 0&&(a[0].forEach(k=>{k._order=0}),updateColumnOrders(a[0],this._orderBaseScope,0))}_setSiblingsReorderStatus(a,k){iterateChildren(a.parentNode,tt=>{/column/u.test(tt.localName)&&this._isSwapAllowed(tt,a)&&(tt._reorderStatus=k)})}_autoScroller(){if(this._lastDragClientX){const a=this._lastDragClientX-this.getBoundingClientRect().right+50,k=this.getBoundingClientRect().left-this._lastDragClientX+50;a>0?this.$.table.scrollLeft+=a/10:k>0&&(this.$.table.scrollLeft-=k/10)}this._draggedColumn&&setTimeout(()=>this._autoScroller(),10)}_isSwapAllowed(a,k){if(a&&k){const tt=a!==k,et=a.parentElement===k.parentElement,rt=a.frozen&&k.frozen||a.frozenToEnd&&k.frozenToEnd||!a.frozen&&!a.frozenToEnd&&!k.frozen&&!k.frozenToEnd;return tt&&et&&rt}}_isSwappableByPosition(a,k){const tt=Array.from(this.$.header.querySelectorAll('tr:not([hidden]) [part~="cell"]')).find(nt=>a.contains(nt._column)),et=this.$.header.querySelector("tr:not([hidden]) [reorder-status=dragging]").getBoundingClientRect(),rt=tt.getBoundingClientRect();return rt.left>et.left?k>rt.right-et.width:k<rt.left+et.width}_swapColumnOrders(a,k){[a._order,k._order]=[k._order,a._order],this._debounceUpdateFrozenColumn(),this._updateFirstAndLastColumn()}_getTargetColumn(a,k){if(a&&k){let tt=a._column;for(;tt.parentElement!==k.parentElement&&tt!==this;)tt=tt.parentElement;return tt.parentElement===k.parentElement?tt:a._column}}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ColumnResizingMixin=j=>class extends j{ready(){super.ready();const a=this.$.scroller;addListener(a,"track",this._onHeaderTrack.bind(this)),a.addEventListener("touchmove",k=>a.hasAttribute("column-resizing")&&k.preventDefault()),a.addEventListener("contextmenu",k=>k.target.getAttribute("part")==="resize-handle"&&k.preventDefault()),a.addEventListener("mousedown",k=>k.target.getAttribute("part")==="resize-handle"&&k.preventDefault())}_onHeaderTrack(a){const k=a.target;if(k.getAttribute("part")==="resize-handle"){let et=k.parentElement._column;for(this.$.scroller.toggleAttribute("column-resizing",!0);et.localName==="vaadin-grid-column-group";)et=et._childColumns.slice(0).sort((ht,ut)=>ht._order-ut._order).filter(ht=>!ht.hidden).pop();const rt=this.__isRTL,nt=a.detail.x,ot=Array.from(this.$.header.querySelectorAll('[part~="row"]:last-child [part~="cell"]')),st=ot.find(ht=>ht._column===et);if(st.offsetWidth){const ht=getComputedStyle(st._content),ut=10+parseInt(ht.paddingLeft)+parseInt(ht.paddingRight)+parseInt(ht.borderLeftWidth)+parseInt(ht.borderRightWidth)+parseInt(ht.marginLeft)+parseInt(ht.marginRight);let dt;const ft=st.offsetWidth,pt=st.getBoundingClientRect();st.hasAttribute("frozen-to-end")?dt=ft+(rt?nt-pt.right:pt.left-nt):dt=ft+(rt?pt.left-nt:nt-pt.right),et.width=`${Math.max(ut,dt)}px`,et.flexGrow=0}ot.sort((ht,ut)=>ht._column._order-ut._column._order).forEach((ht,ut,dt)=>{ut<dt.indexOf(st)&&(ht._column.width=`${ht.offsetWidth}px`,ht._column.flexGrow=0)});const lt=this._frozenToEndCells[0];if(lt&&this.$.table.scrollWidth>this.$.table.offsetWidth){const ht=lt.getBoundingClientRect(),ut=nt-(rt?ht.right:ht.left);(rt&&ut<=0||!rt&&ut>=0)&&(this.$.table.scrollLeft+=ut)}a.detail.state==="end"&&(this.$.scroller.toggleAttribute("column-resizing",!1),this.dispatchEvent(new CustomEvent("column-resize",{detail:{resizedColumn:et}}))),this._resizeHandler()}}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemCache=class T9{constructor(E,a,k){this.grid=E,this.parentCache=a,this.parentItem=k,this.itemCaches={},this.items={},this.effectiveSize=0,this.size=0,this.pendingRequests={}}isLoading(){return Boolean(Object.keys(this.pendingRequests).length||Object.keys(this.itemCaches).filter(E=>this.itemCaches[E].isLoading())[0])}getItemForIndex(E){const{cache:a,scaledIndex:k}=this.getCacheAndIndex(E);return a.items[k]}updateSize(){this.effectiveSize=!this.parentItem||this.grid._isExpanded(this.parentItem)?this.size+Object.keys(this.itemCaches).reduce((E,a)=>{const k=this.itemCaches[a];return k.updateSize(),E+k.effectiveSize},0):0}ensureSubCacheForScaledIndex(E){if(!this.itemCaches[E]){const a=new T9(this.grid,this,this.items[E]);this.itemCaches[E]=a,this.grid._loadPage(0,a)}}getCacheAndIndex(E){let a=E;for(const[k,tt]of Object.entries(this.itemCaches)){const et=Number(k);if(a<=et)return{cache:this,scaledIndex:a};if(a<=et+tt.effectiveSize)return tt.getCacheAndIndex(a-et-1);a-=tt.effectiveSize}return{cache:this,scaledIndex:a}}},DataProviderMixin=j=>class extends j{static get properties(){return{size:{type:Number,notify:!0},pageSize:{type:Number,value:50,observer:"_pageSizeChanged"},dataProvider:{type:Object,notify:!0,observer:"_dataProviderChanged"},loading:{type:Boolean,notify:!0,readOnly:!0,reflectToAttribute:!0},_cache:{type:Object,value(){return new ItemCache(this)}},_hasData:{type:Boolean,value:!1},itemHasChildrenPath:{type:String,value:"children",observer:"__itemHasChildrenPathChanged"},itemIdPath:{type:String,value:null},expandedItems:{type:Object,notify:!0,value:()=>[]},__expandedKeys:{type:Object,computed:"__computeExpandedKeys(itemIdPath, expandedItems.*)"}}}static get observers(){return["_sizeChanged(size)","_expandedItemsChanged(expandedItems.*)"]}_sizeChanged(a){const k=a-this._cache.size;this._cache.size+=k,this._cache.effectiveSize+=k,this._effectiveSize=this._cache.effectiveSize}__itemHasChildrenPathChanged(a,k){!k&&a==="children"||this.requestContentUpdate()}_getItem(a,k){if(a>=this._effectiveSize)return;k.index=a;const{cache:tt,scaledIndex:et}=this._cache.getCacheAndIndex(a),rt=tt.items[et];rt?(this.__updateLoading(k,!1),this._updateItem(k,rt),this._isExpanded(rt)&&tt.ensureSubCacheForScaledIndex(et)):(this.__updateLoading(k,!0),this._loadPage(this._getPageForIndex(et),tt))}__updateLoading(a,k){const tt=getBodyRowCells(a);updateState(a,"loading",k),updateCellsPart(tt,"loading-row-cell",k)}getItemId(a){return this.itemIdPath?this.get(this.itemIdPath,a):a}_isExpanded(a){return this.__expandedKeys.has(this.getItemId(a))}_expandedItemsChanged(){this._cache.updateSize(),this._effectiveSize=this._cache.effectiveSize,this.__updateVisibleRows()}__computeExpandedKeys(a,k){const tt=k.base||[],et=new Set;return tt.forEach(rt=>{et.add(this.getItemId(rt))}),et}expandItem(a){this._isExpanded(a)||(this.expandedItems=[...this.expandedItems,a])}collapseItem(a){this._isExpanded(a)&&(this.expandedItems=this.expandedItems.filter(k=>!this._itemsEqual(k,a)))}_getIndexLevel(a){let{cache:k}=this._cache.getCacheAndIndex(a),tt=0;for(;k.parentCache;)k=k.parentCache,tt+=1;return tt}_loadPage(a,k){if(!k.pendingRequests[a]&&this.dataProvider){this._setLoading(!0),k.pendingRequests[a]=!0;const tt={page:a,pageSize:this.pageSize,sortOrders:this._mapSorters(),filters:this._mapFilters(),parentItem:k.parentItem};this.dataProvider(tt,(et,rt)=>{rt!==void 0?k.size=rt:tt.parentItem&&(k.size=et.length);const nt=Array.from(this.$.items.children).map(ot=>ot._item);et.forEach((ot,st)=>{const lt=a*this.pageSize+st;k.items[lt]=ot,this._isExpanded(ot)&&nt.indexOf(ot)>-1&&k.ensureSubCacheForScaledIndex(lt)}),this._hasData=!0,delete k.pendingRequests[a],this._debouncerApplyCachedData=Debouncer$1.debounce(this._debouncerApplyCachedData,timeOut.after(0),()=>{this._setLoading(!1),this._cache.updateSize(),this._effectiveSize=this._cache.effectiveSize,iterateChildren(this.$.items,ot=>{ot.hidden||this._cache.getItemForIndex(ot.index)&&this._getItem(ot.index,ot)}),this.__scrollToPendingIndex()}),this._cache.isLoading()||this._debouncerApplyCachedData.flush(),this.__itemsReceived()})}}_getPageForIndex(a){return Math.floor(a/this.pageSize)}clearCache(){this._cache=new ItemCache(this),this._cache.size=this.size||0,this._cache.updateSize(),this._hasData=!1,this.__updateVisibleRows(),this._effectiveSize||this._loadPage(0,this._cache)}_pageSizeChanged(a,k){k!==void 0&&a!==k&&this.clearCache()}_checkSize(){this.size===void 0&&this._effectiveSize===0&&console.warn("The <vaadin-grid> needs the total number of items in order to display rows, which you can specify either by setting the `size` property, or by providing it to the second argument of the `dataProvider` function `callback` call.")}_dataProviderChanged(a,k){k!==void 0&&this.clearCache(),this._ensureFirstPageLoaded(),this._debouncerCheckSize=Debouncer$1.debounce(this._debouncerCheckSize,timeOut.after(2e3),this._checkSize.bind(this))}_ensureFirstPageLoaded(){this._hasData||this._loadPage(0,this._cache)}_itemsEqual(a,k){return this.getItemId(a)===this.getItemId(k)}_getItemIndexInArray(a,k){let tt=-1;return k.forEach((et,rt)=>{this._itemsEqual(et,a)&&(tt=rt)}),tt}scrollToIndex(a){super.scrollToIndex(a),!isNaN(a)&&(this._cache.isLoading()||!this.clientHeight)&&(this.__pendingScrollToIndex=a)}__scrollToPendingIndex(){if(this.__pendingScrollToIndex&&this.$.items.children.length){const a=this.__pendingScrollToIndex;delete this.__pendingScrollToIndex,this.scrollToIndex(a)}}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DropMode={BETWEEN:"between",ON_TOP:"on-top",ON_TOP_OR_BETWEEN:"on-top-or-between",ON_GRID:"on-grid"},DropLocation={ON_TOP:"on-top",ABOVE:"above",BELOW:"below",EMPTY:"empty"},usesDnDPolyfill=!("draggable"in document.createElement("div")),DragAndDropMixin=j=>class extends j{static get properties(){return{dropMode:String,rowsDraggable:Boolean,dragFilter:Function,dropFilter:Function,__dndAutoScrollThreshold:{value:50}}}static get observers(){return["_dragDropAccessChanged(rowsDraggable, dropMode, dragFilter, dropFilter, loading)"]}ready(){super.ready(),this.$.table.addEventListener("dragstart",this._onDragStart.bind(this)),this.$.table.addEventListener("dragend",this._onDragEnd.bind(this)),this.$.table.addEventListener("dragover",this._onDragOver.bind(this)),this.$.table.addEventListener("dragleave",this._onDragLeave.bind(this)),this.$.table.addEventListener("drop",this._onDrop.bind(this)),this.$.table.addEventListener("dragenter",a=>{this.dropMode&&(a.preventDefault(),a.stopPropagation())})}_onDragStart(a){if(this.rowsDraggable){let k=a.target;if(k.localName==="vaadin-grid-cell-content"&&(k=k.assignedSlot.parentNode.parentNode),k.parentNode!==this.$.items)return;if(a.stopPropagation(),this.toggleAttribute("dragging-rows",!0),this._safari){const nt=k.style.transform;k.style.top=/translateY\((.*)\)/u.exec(nt)[1],k.style.transform="none",requestAnimationFrame(()=>{k.style.top="",k.style.transform=nt})}const tt=k.getBoundingClientRect();usesDnDPolyfill?a.dataTransfer.setDragImage(k):a.dataTransfer.setDragImage(k,a.clientX-tt.left,a.clientY-tt.top);let et=[k];this._isSelected(k._item)&&(et=this.__getViewportRows().filter(nt=>this._isSelected(nt._item)).filter(nt=>!this.dragFilter||this.dragFilter(this.__getRowModel(nt)))),a.dataTransfer.setData("text",this.__formatDefaultTransferData(et)),updateRowStates(k,{dragstart:et.length>1?`${et.length}`:""}),this.style.setProperty("--_grid-drag-start-x",`${a.clientX-tt.left+20}px`),this.style.setProperty("--_grid-drag-start-y",`${a.clientY-tt.top+10}px`),requestAnimationFrame(()=>{updateRowStates(k,{dragstart:null}),this.style.setProperty("--_grid-drag-start-x",""),this.style.setProperty("--_grid-drag-start-y","")});const rt=new CustomEvent("grid-dragstart",{detail:{draggedItems:et.map(nt=>nt._item),setDragData:(nt,ot)=>a.dataTransfer.setData(nt,ot),setDraggedItemsCount:nt=>k.setAttribute("dragstart",nt)}});rt.originalEvent=a,this.dispatchEvent(rt)}}_onDragEnd(a){this.toggleAttribute("dragging-rows",!1),a.stopPropagation();const k=new CustomEvent("grid-dragend");k.originalEvent=a,this.dispatchEvent(k)}_onDragLeave(a){a.stopPropagation(),this._clearDragStyles()}_onDragOver(a){if(this.dropMode){if(this._dropLocation=void 0,this._dragOverItem=void 0,this.__dndAutoScroll(a.clientY)){this._clearDragStyles();return}let k=a.composedPath().find(tt=>tt.localName==="tr");if(!this._effectiveSize||this.dropMode===DropMode.ON_GRID)this._dropLocation=DropLocation.EMPTY;else if(!k||k.parentNode!==this.$.items){if(k)return;if(this.dropMode===DropMode.BETWEEN||this.dropMode===DropMode.ON_TOP_OR_BETWEEN)k=Array.from(this.$.items.children).filter(tt=>!tt.hidden).pop(),this._dropLocation=DropLocation.BELOW;else return}else{const tt=k.getBoundingClientRect();if(this._dropLocation=DropLocation.ON_TOP,this.dropMode===DropMode.BETWEEN){const et=a.clientY-tt.top<tt.bottom-a.clientY;this._dropLocation=et?DropLocation.ABOVE:DropLocation.BELOW}else this.dropMode===DropMode.ON_TOP_OR_BETWEEN&&(a.clientY-tt.top<tt.height/3?this._dropLocation=DropLocation.ABOVE:a.clientY-tt.top>tt.height/3*2&&(this._dropLocation=DropLocation.BELOW))}if(k&&k.hasAttribute("drop-disabled")){this._dropLocation=void 0;return}a.stopPropagation(),a.preventDefault(),this._dropLocation===DropLocation.EMPTY?this.toggleAttribute("dragover",!0):k?(this._dragOverItem=k._item,k.getAttribute("dragover")!==this._dropLocation&&updateRowStates(k,{dragover:this._dropLocation},!0)):this._clearDragStyles()}}__dndAutoScroll(a){if(this.__dndAutoScrolling)return!0;const k=this.$.header.getBoundingClientRect().bottom,tt=this.$.footer.getBoundingClientRect().top,et=k-a+this.__dndAutoScrollThreshold,rt=a-tt+this.__dndAutoScrollThreshold;let nt=0;if(rt>0?nt=rt*2:et>0&&(nt=-et*2),nt){const ot=this.$.table.scrollTop;if(this.$.table.scrollTop+=nt,ot!==this.$.table.scrollTop)return this.__dndAutoScrolling=!0,setTimeout(()=>{this.__dndAutoScrolling=!1},20),!0}}__getViewportRows(){const a=this.$.header.getBoundingClientRect().bottom,k=this.$.footer.getBoundingClientRect().top;return Array.from(this.$.items.children).filter(tt=>{const et=tt.getBoundingClientRect();return et.bottom>a&&et.top<k})}_clearDragStyles(){this.removeAttribute("dragover"),iterateChildren(this.$.items,a=>{updateRowStates(a,{dragover:null},!0)})}_onDrop(a){if(this.dropMode){a.stopPropagation(),a.preventDefault();const k=a.dataTransfer.types&&Array.from(a.dataTransfer.types).map(et=>({type:et,data:a.dataTransfer.getData(et)}));this._clearDragStyles();const tt=new CustomEvent("grid-drop",{bubbles:a.bubbles,cancelable:a.cancelable,detail:{dropTargetItem:this._dragOverItem,dropLocation:this._dropLocation,dragData:k}});tt.originalEvent=a,this.dispatchEvent(tt)}}__formatDefaultTransferData(a){return a.map(k=>Array.from(k.children).filter(tt=>!tt.hidden&&tt.getAttribute("part").indexOf("details-cell")===-1).sort((tt,et)=>tt._column._order>et._column._order?1:-1).map(tt=>tt._content.textContent.trim()).filter(tt=>tt).join("	")).join(`
`)}_dragDropAccessChanged(){this.filterDragAndDrop()}filterDragAndDrop(){iterateChildren(this.$.items,a=>{a.hidden||this._filterDragAndDrop(a,this.__getRowModel(a))})}_filterDragAndDrop(a,k){const tt=this.loading||a.hasAttribute("loading"),et=!this.rowsDraggable||tt||this.dragFilter&&!this.dragFilter(k),rt=!this.dropMode||tt||this.dropFilter&&!this.dropFilter(k);iterateChildren(a,nt=>{et?nt._content.removeAttribute("draggable"):nt._content.setAttribute("draggable",!0)}),updateRowStates(a,{"drag-disabled":!!et,"drop-disabled":!!rt})}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function arrayEquals(j,E){if(!j||!E||j.length!==E.length)return!1;for(let a=0,k=j.length;a<k;a++)if(j[a]instanceof Array&&E[a]instanceof Array){if(!arrayEquals(j[a],E[a]))return!1}else if(j[a]!==E[a])return!1;return!0}const DynamicColumnsMixin=j=>class extends j{static get properties(){return{_columnTree:Object}}ready(){super.ready(),this._addNodeObserver()}_hasColumnGroups(a){return a.some(k=>k.localName==="vaadin-grid-column-group")}_getChildColumns(a){return FlattenedNodesObserver.getFlattenedNodes(a).filter(this._isColumnElement)}_flattenColumnGroups(a){return a.map(k=>k.localName==="vaadin-grid-column-group"?this._getChildColumns(k):[k]).reduce((k,tt)=>k.concat(tt),[])}_getColumnTree(){const a=FlattenedNodesObserver.getFlattenedNodes(this).filter(this._isColumnElement),k=[a];let tt=a;for(;this._hasColumnGroups(tt);)tt=this._flattenColumnGroups(tt),k.push(tt);return k}_updateColumnTree(){const a=this._getColumnTree();arrayEquals(a,this._columnTree)||(this._columnTree=a)}_addNodeObserver(){this._observer=new FlattenedNodesObserver(this,a=>{const k=tt=>tt.filter(this._isColumnElement).length>0;if(k(a.addedNodes)||k(a.removedNodes)){const tt=a.removedNodes.flatMap(rt=>rt._allCells),et=rt=>tt.filter(nt=>nt._content.contains(rt)).length;this.__removeSorters(this._sorters.filter(et)),this.__removeFilters(this._filters.filter(et)),this._updateColumnTree()}this._debouncerCheckImports=Debouncer$1.debounce(this._debouncerCheckImports,timeOut.after(2e3),this._checkImports.bind(this)),this._ensureFirstPageLoaded()})}_checkImports(){["vaadin-grid-column-group","vaadin-grid-filter","vaadin-grid-filter-column","vaadin-grid-tree-toggle","vaadin-grid-selection-column","vaadin-grid-sort-column","vaadin-grid-sorter"].forEach(a=>{const k=this.querySelector(a);k&&!(k instanceof PolymerElement)&&console.warn(`Make sure you have imported the required module for <${a}> element.`)})}_updateFirstAndLastColumn(){Array.from(this.shadowRoot.querySelectorAll("tr")).forEach(a=>this._updateFirstAndLastColumnForRow(a))}_updateFirstAndLastColumnForRow(a){Array.from(a.querySelectorAll('[part~="cell"]:not([part~="details-cell"])')).sort((k,tt)=>k._column._order-tt._column._order).forEach((k,tt,et)=>{updateCellState(k,"first-column",tt===0),updateCellState(k,"last-column",tt===et.length-1)})}_isColumnElement(a){return a.nodeType===Node.ELEMENT_NODE&&/\bcolumn\b/u.test(a.localName)}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const EventContextMixin=j=>class extends j{getEventContext(a){const k={},tt=a.__composedPath||a.composedPath(),et=tt[tt.indexOf(this.$.table)-3];return et&&(k.section=["body","header","footer","details"].find(rt=>et.getAttribute("part").indexOf(rt)>-1),et._column&&(k.column=et._column),(k.section==="body"||k.section==="details")&&Object.assign(k,this.__getRowModel(et.parentElement))),k}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const FilterMixin=j=>class extends j{static get properties(){return{_filters:{type:Array,value:()=>[]}}}ready(){super.ready(),this.addEventListener("filter-changed",this._filterChanged.bind(this))}_filterChanged(a){a.stopPropagation(),this.__addFilter(a.target),this.__applyFilters()}__removeFilters(a){a.length!==0&&(this._filters=this._filters.filter(k=>a.indexOf(k)<0),this.__applyFilters())}__addFilter(a){this._filters.indexOf(a)===-1&&this._filters.push(a)}__applyFilters(){this.dataProvider&&this.isAttached&&this.clearCache()}_mapFilters(){return this._filters.map(a=>({path:a.path,value:a.value}))}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardNavigationMixin=j=>class extends j{static get properties(){return{_headerFocusable:{type:Object,observer:"_focusableChanged"},_itemsFocusable:{type:Object,observer:"_focusableChanged"},_footerFocusable:{type:Object,observer:"_focusableChanged"},_navigatingIsHidden:Boolean,_focusedItemIndex:{type:Number,value:0},_focusedColumnOrder:Number,_focusedCell:{type:Object,observer:"_focusedCellChanged"},interacting:{type:Boolean,value:!1,reflectToAttribute:!0,readOnly:!0,observer:"_interactingChanged"}}}get __rowFocusMode(){return this.__isRow(this._itemsFocusable)||this.__isRow(this._headerFocusable)||this.__isRow(this._footerFocusable)}set __rowFocusMode(a){["_itemsFocusable","_footerFocusable","_headerFocusable"].forEach(k=>{const tt=this[k];if(a){const et=tt&&tt.parentElement;this.__isCell(tt)?this[k]=et:this.__isCell(et)&&(this[k]=et.parentElement)}else if(!a&&this.__isRow(tt)){const et=tt.firstElementChild;this[k]=et._focusButton||et}})}ready(){super.ready(),!(this._ios||this._android)&&(this.addEventListener("keydown",this._onKeyDown),this.addEventListener("keyup",this._onKeyUp),this.addEventListener("focusin",this._onFocusIn),this.addEventListener("focusout",this._onFocusOut),this.$.table.addEventListener("focusin",this._onContentFocusIn.bind(this)),this.addEventListener("mousedown",()=>{this.toggleAttribute("navigating",!1),this._isMousedown=!0,this._focusedColumnOrder=void 0}),this.addEventListener("mouseup",()=>{this._isMousedown=!1}))}_focusableChanged(a,k){k&&k.setAttribute("tabindex","-1"),a&&this._updateGridSectionFocusTarget(a)}_focusedCellChanged(a,k){k&&removeValueFromAttribute(k,"part","focused-cell"),a&&addValueToAttribute(a,"part","focused-cell")}_interactingChanged(){this._updateGridSectionFocusTarget(this._headerFocusable),this._updateGridSectionFocusTarget(this._itemsFocusable),this._updateGridSectionFocusTarget(this._footerFocusable)}__updateItemsFocusable(){if(!this._itemsFocusable)return;const a=this.shadowRoot.activeElement===this._itemsFocusable;this._getVisibleRows().forEach(k=>{if(k.index===this._focusedItemIndex)if(this.__rowFocusMode)this._itemsFocusable=k;else{let tt=this._itemsFocusable.parentElement,et=this._itemsFocusable;if(tt){this.__isCell(tt)&&(et=tt,tt=tt.parentElement);const rt=[...tt.children].indexOf(et);this._itemsFocusable=this.__getFocusable(k,k.children[rt])}}}),a&&this._itemsFocusable.focus()}_onKeyDown(a){const k=a.key;let tt;switch(k){case"ArrowUp":case"ArrowDown":case"ArrowLeft":case"ArrowRight":case"PageUp":case"PageDown":case"Home":case"End":tt="Navigation";break;case"Enter":case"Escape":case"F2":tt="Interaction";break;case"Tab":tt="Tab";break;case" ":tt="Space";break}this._detectInteracting(a),this.interacting&&tt!=="Interaction"&&(tt=void 0),tt&&this[`_on${tt}KeyDown`](a,k)}_ensureScrolledToIndex(a){[...this.$.items.children].find(tt=>tt.index===a)?this.__scrollIntoViewport(a):this.scrollToIndex(a)}__isRowExpandable(a){if(this.itemHasChildrenPath){const k=a._item;return k&&this.get(this.itemHasChildrenPath,k)&&!this._isExpanded(k)}}__isRowCollapsible(a){return this._isExpanded(a._item)}__isDetailsCell(a){return a.matches('[part~="details-cell"]')}__isCell(a){return a instanceof HTMLTableCellElement}__isRow(a){return a instanceof HTMLTableRowElement}__getIndexOfChildElement(a){return Array.prototype.indexOf.call(a.parentNode.children,a)}_onNavigationKeyDown(a,k){a.preventDefault();const tt=this._lastVisibleIndex-this._firstVisibleIndex-1,et=this.__isRTL;let rt=0,nt=0;switch(k){case"ArrowRight":rt=et?-1:1;break;case"ArrowLeft":rt=et?1:-1;break;case"Home":this.__rowFocusMode||a.ctrlKey?nt=-1/0:rt=-1/0;break;case"End":this.__rowFocusMode||a.ctrlKey?nt=1/0:rt=1/0;break;case"ArrowDown":nt=1;break;case"ArrowUp":nt=-1;break;case"PageDown":nt=tt;break;case"PageUp":nt=-tt;break}const ot=a.composedPath().find(ut=>this.__isRow(ut)),st=a.composedPath().find(ut=>this.__isCell(ut));if(this.__rowFocusMode&&!ot||!this.__rowFocusMode&&!st)return;const lt=et?"ArrowLeft":"ArrowRight",ht=et?"ArrowRight":"ArrowLeft";if(k===lt){if(this.__rowFocusMode){if(this.__isRowExpandable(ot)){this.expandItem(ot._item);return}this.__rowFocusMode=!1,this._onCellNavigation(ot.firstElementChild,0,0);return}}else if(k===ht)if(this.__rowFocusMode){if(this.__isRowCollapsible(ot)){this.collapseItem(ot._item);return}}else{const ut=[...ot.children].sort((dt,ft)=>dt._order-ft._order);if(st===ut[0]||this.__isDetailsCell(st)){this.__rowFocusMode=!0,this._onRowNavigation(ot,0);return}}this.__rowFocusMode?this._onRowNavigation(ot,nt):this._onCellNavigation(st,rt,nt)}_onRowNavigation(a,k){const{dstRow:tt}=this.__navigateRows(k,a);tt&&tt.focus()}__getIndexInGroup(a,k){return a.parentNode===this.$.items?k!==void 0?k:a.index:this.__getIndexOfChildElement(a)}__navigateRows(a,k,tt){const et=this.__getIndexInGroup(k,this._focusedItemIndex),rt=k.parentNode,nt=(rt===this.$.items?this._effectiveSize:rt.children.length)-1;let ot=Math.max(0,Math.min(et+a,nt));if(rt!==this.$.items){if(ot>et)for(;ot<nt&&rt.children[ot].hidden;)ot+=1;else if(ot<et)for(;ot>0&&rt.children[ot].hidden;)ot-=1;return this.toggleAttribute("navigating",!0),{dstRow:rt.children[ot]}}let st=!1;if(tt){const lt=this.__isDetailsCell(tt);if(rt===this.$.items){const ht=k._item,ut=this._cache.getItemForIndex(ot);lt?st=a===0:st=a===1&&this._isDetailsOpened(ht)||a===-1&&ot!==et&&this._isDetailsOpened(ut),st!==lt&&(a===1&&st||a===-1&&!st)&&(ot=et)}}return this._ensureScrolledToIndex(ot),this._focusedItemIndex=ot,this.toggleAttribute("navigating",!0),{dstRow:[...rt.children].find(lt=>!lt.hidden&&lt.index===ot),dstIsRowDetails:st}}_onCellNavigation(a,k,tt){const et=a.parentNode,{dstRow:rt,dstIsRowDetails:nt}=this.__navigateRows(tt,et,a);if(!rt)return;const ot=this.__getIndexOfChildElement(a),st=this.__isDetailsCell(a),lt=et.parentNode,ht=this.__getIndexInGroup(et,this._focusedItemIndex);if(this._focusedColumnOrder===void 0&&(st?this._focusedColumnOrder=0:this._focusedColumnOrder=this._getColumns(lt,ht).filter(ut=>!ut.hidden)[ot]._order),nt)[...rt.children].find(dt=>this.__isDetailsCell(dt)).focus();else{const ut=this.__getIndexInGroup(rt,this._focusedItemIndex),dt=this._getColumns(lt,ut).filter(Mt=>!Mt.hidden),ft=dt.map(Mt=>Mt._order).sort((Mt,At)=>Mt-At),pt=ft.length-1,gt=ft.indexOf(ft.slice(0).sort((Mt,At)=>Math.abs(Mt-this._focusedColumnOrder)-Math.abs(At-this._focusedColumnOrder))[0]),yt=tt===0&&st?gt:Math.max(0,Math.min(gt+k,pt));yt!==gt&&(this._focusedColumnOrder=void 0);const xt=dt.reduce((Mt,At,St)=>(Mt[At._order]=St,Mt),{})[ft[yt]],wt=rt.children[xt];this._scrollHorizontallyToCell(wt),wt.focus()}}_onInteractionKeyDown(a,k){const tt=a.composedPath()[0],et=tt.localName==="input"&&!/^(button|checkbox|color|file|image|radio|range|reset|submit)$/iu.test(tt.type);let rt;switch(k){case"Enter":rt=this.interacting?!et:!0;break;case"Escape":rt=!1;break;case"F2":rt=!this.interacting;break}const{cell:nt}=this._getGridEventLocation(a);if(this.interacting!==rt&&nt!==null)if(rt){const ot=nt._content.querySelector("[focus-target]")||[...nt._content.querySelectorAll("*")].find(st=>this._isFocusable(st));ot&&(a.preventDefault(),ot.focus(),this._setInteracting(!0),this.toggleAttribute("navigating",!1))}else a.preventDefault(),this._focusedColumnOrder=void 0,nt.focus(),this._setInteracting(!1),this.toggleAttribute("navigating",!0);k==="Escape"&&this._hideTooltip(!0)}_predictFocusStepTarget(a,k){const tt=[this.$.table,this._headerFocusable,this._itemsFocusable,this._footerFocusable,this.$.focusexit];let et=tt.indexOf(a);for(et+=k;et>=0&&et<=tt.length-1;){let rt=tt[et];if(rt&&!this.__rowFocusMode&&(rt=tt[et].parentNode),!rt||rt.hidden)et+=k;else break}return tt[et]}_onTabKeyDown(a){const k=this._predictFocusStepTarget(a.composedPath()[0],a.shiftKey?-1:1);if(k){if(a.stopPropagation(),k===this.$.table)this.$.table.focus();else if(k===this.$.focusexit)this.$.focusexit.focus();else if(k===this._itemsFocusable){let tt=k;const et=this.__isRow(k)?k:k.parentNode;if(this._ensureScrolledToIndex(this._focusedItemIndex),et.index!==this._focusedItemIndex&&this.__isCell(k)){const rt=Array.from(et.children).indexOf(this._itemsFocusable),nt=Array.from(this.$.items.children).find(ot=>!ot.hidden&&ot.index===this._focusedItemIndex);nt&&(tt=nt.children[rt])}a.preventDefault(),tt.focus()}else a.preventDefault(),k.focus();this.toggleAttribute("navigating",!0)}}_onSpaceKeyDown(a){a.preventDefault();const k=a.composedPath()[0],tt=this.__isRow(k);(tt||!k._content||!k._content.firstElementChild)&&this.dispatchEvent(new CustomEvent(tt?"row-activate":"cell-activate",{detail:{model:this.__getRowModel(tt?k:k.parentElement)}}))}_onKeyUp(a){if(!/^( |SpaceBar)$/u.test(a.key)||this.interacting)return;a.preventDefault();const k=a.composedPath()[0];if(k._content&&k._content.firstElementChild){const tt=this.hasAttribute("navigating");k._content.firstElementChild.dispatchEvent(new MouseEvent("click",{shiftKey:a.shiftKey,bubbles:!0,composed:!0,cancelable:!0})),this.toggleAttribute("navigating",tt)}}_onFocusIn(a){this._isMousedown||this.toggleAttribute("navigating",!0);const k=a.composedPath()[0];k===this.$.table||k===this.$.focusexit?(this._predictFocusStepTarget(k,k===this.$.table?1:-1).focus(),this._setInteracting(!1)):this._detectInteracting(a)}_onFocusOut(a){this.toggleAttribute("navigating",!1),this._detectInteracting(a),this._hideTooltip(),this._focusedCell=null}_onContentFocusIn(a){const{section:k,cell:tt,row:et}=this._getGridEventLocation(a);if(!(!tt&&!this.__rowFocusMode)){if(this._detectInteracting(a),k&&(tt||et))if(this._activeRowGroup=k,this.$.header===k?this._headerFocusable=this.__getFocusable(et,tt):this.$.items===k?this._itemsFocusable=this.__getFocusable(et,tt):this.$.footer===k&&(this._footerFocusable=this.__getFocusable(et,tt)),tt){const rt=this.getEventContext(a);tt.dispatchEvent(new CustomEvent("cell-focus",{bubbles:!0,composed:!0,detail:{context:rt}})),this._focusedCell=tt._focusButton||tt,isKeyboardActive()&&a.target===tt&&this._showTooltip(a)}else this._focusedCell=null;this._detectFocusedItemIndex(a)}}__getFocusable(a,k){return this.__rowFocusMode?a:k._focusButton||k}_detectInteracting(a){const k=a.composedPath().some(tt=>tt.localName==="vaadin-grid-cell-content");this._setInteracting(k),this.__updateHorizontalScrollPosition()}_detectFocusedItemIndex(a){const{section:k,row:tt}=this._getGridEventLocation(a);k===this.$.items&&(this._focusedItemIndex=tt.index)}_updateGridSectionFocusTarget(a){if(!a)return;const k=this._getGridSectionFromFocusTarget(a),tt=this.interacting&&k===this._activeRowGroup;a.tabIndex=tt?-1:0}_preventScrollerRotatingCellFocus(a,k){a.index===this._focusedItemIndex&&this.hasAttribute("navigating")&&this._activeRowGroup===this.$.items&&(this._navigatingIsHidden=!0,this.toggleAttribute("navigating",!1)),k===this._focusedItemIndex&&this._navigatingIsHidden&&(this._navigatingIsHidden=!1,this.toggleAttribute("navigating",!0))}_getColumns(a,k){let tt=this._columnTree.length-1;return a===this.$.header?tt=k:a===this.$.footer&&(tt=this._columnTree.length-1-k),this._columnTree[tt]}__isValidFocusable(a){return this.$.table.contains(a)&&a.offsetHeight}_resetKeyboardNavigation(){if(["header","footer"].forEach(a=>{if(!this.__isValidFocusable(this[`_${a}Focusable`])){const k=[...this.$[a].children].find(et=>et.offsetHeight),tt=k?[...k.children].find(et=>!et.hidden):null;k&&tt&&(this[`_${a}Focusable`]=this.__getFocusable(k,tt))}}),!this.__isValidFocusable(this._itemsFocusable)&&this.$.items.firstElementChild){const a=this.__getFirstVisibleItem(),k=a?[...a.children].find(tt=>!tt.hidden):null;k&&a&&(delete this._focusedColumnOrder,this._itemsFocusable=this.__getFocusable(a,k))}else this.__updateItemsFocusable()}_scrollHorizontallyToCell(a){if(a.hasAttribute("frozen")||a.hasAttribute("frozen-to-end")||this.__isDetailsCell(a))return;const k=a.getBoundingClientRect(),tt=a.parentNode,et=Array.from(tt.children).indexOf(a),rt=this.$.table.getBoundingClientRect();let nt=rt.left,ot=rt.right;for(let st=et-1;st>=0;st--){const lt=tt.children[st];if(!(lt.hasAttribute("hidden")||this.__isDetailsCell(lt))&&(lt.hasAttribute("frozen")||lt.hasAttribute("frozen-to-end"))){nt=lt.getBoundingClientRect().right;break}}for(let st=et+1;st<tt.children.length;st++){const lt=tt.children[st];if(!(lt.hasAttribute("hidden")||this.__isDetailsCell(lt))&&(lt.hasAttribute("frozen")||lt.hasAttribute("frozen-to-end"))){ot=lt.getBoundingClientRect().left;break}}k.left<nt&&(this.$.table.scrollLeft+=Math.round(k.left-nt)),k.right>ot&&(this.$.table.scrollLeft+=Math.round(k.right-ot))}_getGridEventLocation(a){const k=a.composedPath(),tt=k.indexOf(this.$.table),et=tt>=1?k[tt-1]:null,rt=tt>=2?k[tt-2]:null,nt=tt>=3?k[tt-3]:null;return{section:et,row:rt,cell:nt}}_getGridSectionFromFocusTarget(a){return a===this._headerFocusable?this.$.header:a===this._itemsFocusable?this.$.items:a===this._footerFocusable?this.$.footer:null}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const RowDetailsMixin=j=>class extends j{static get properties(){return{detailsOpenedItems:{type:Array,value:()=>[]},rowDetailsRenderer:Function,_detailsCells:{type:Array}}}static get observers(){return["_detailsOpenedItemsChanged(detailsOpenedItems.*, rowDetailsRenderer)","_rowDetailsRendererChanged(rowDetailsRenderer)"]}ready(){super.ready(),this._detailsCellResizeObserver=new ResizeObserver(a=>{a.forEach(({target:k})=>{this._updateDetailsCellHeight(k.parentElement)}),this.__virtualizer.__adapter._resizeHandler()})}_rowDetailsRendererChanged(a){a&&this._columnTree&&iterateChildren(this.$.items,k=>{if(!k.querySelector("[part~=details-cell]")){this._updateRow(k,this._columnTree[this._columnTree.length-1]);const tt=this._isDetailsOpened(k._item);this._toggleDetailsCell(k,tt)}})}_detailsOpenedItemsChanged(a,k){a.path==="detailsOpenedItems.length"||!a.value||iterateChildren(this.$.items,tt=>{if(tt.hasAttribute("details-opened")){this._updateItem(tt,tt._item);return}k&&this._isDetailsOpened(tt._item)&&this._updateItem(tt,tt._item)})}_configureDetailsCell(a){a.setAttribute("part","cell details-cell"),a.toggleAttribute("frozen",!0),this._detailsCellResizeObserver.observe(a)}_toggleDetailsCell(a,k){const tt=a.querySelector('[part~="details-cell"]');tt&&(tt.hidden=!k,!tt.hidden&&this.rowDetailsRenderer&&(tt._renderer=this.rowDetailsRenderer))}_updateDetailsCellHeight(a){const k=a.querySelector('[part~="details-cell"]');k&&(k.hidden?a.style.removeProperty("padding-bottom"):a.style.setProperty("padding-bottom",`${k.offsetHeight}px`))}_updateDetailsCellHeights(){iterateChildren(this.$.items,a=>{this._updateDetailsCellHeight(a)})}_isDetailsOpened(a){return this.detailsOpenedItems&&this._getItemIndexInArray(a,this.detailsOpenedItems)!==-1}openItemDetails(a){this._isDetailsOpened(a)||(this.detailsOpenedItems=[...this.detailsOpenedItems,a])}closeItemDetails(a){this._isDetailsOpened(a)&&(this.detailsOpenedItems=this.detailsOpenedItems.filter(k=>!this._itemsEqual(k,a)))}};/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function getNormalizedScrollLeft(j,E){const{scrollLeft:a}=j;return E!=="rtl"?a:j.scrollWidth-j.clientWidth+a}function setNormalizedScrollLeft(j,E,a){E!=="rtl"?j.scrollLeft=a:j.scrollLeft=j.clientWidth-j.scrollWidth+a}/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const observer=new ResizeObserver(j=>{setTimeout(()=>{j.forEach(E=>{E.target.resizables?E.target.resizables.forEach(a=>{a._onResize(E.contentRect)}):E.target._onResize(E.contentRect)})})}),ResizeMixin=dedupingMixin(j=>class extends j{get _observeParent(){return!1}connectedCallback(){if(super.connectedCallback(),observer.observe(this),this._observeParent){const a=this.parentNode instanceof ShadowRoot?this.parentNode.host:this.parentNode;a.resizables||(a.resizables=new Set,observer.observe(a)),a.resizables.add(this),this.__parent=a}}disconnectedCallback(){super.disconnectedCallback(),observer.unobserve(this);const a=this.__parent;if(this._observeParent&&a){const k=a.resizables;k&&(k.delete(this),k.size===0&&observer.unobserve(a)),this.__parent=null}}_onResize(a){}});/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const timeouts={SCROLLING:500},ScrollMixin=j=>class extends ResizeMixin(j){static get properties(){return{_frozenCells:{type:Array,value:()=>[]},_frozenToEndCells:{type:Array,value:()=>[]},_rowWithFocusedElement:Element}}get _scrollLeft(){return this.$.table.scrollLeft}get _scrollTop(){return this.$.table.scrollTop}set _scrollTop(a){this.$.table.scrollTop=a}ready(){super.ready(),this.scrollTarget=this.$.table,this.$.items.addEventListener("focusin",a=>{const k=a.composedPath().indexOf(this.$.items);this._rowWithFocusedElement=a.composedPath()[k-1]}),this.$.items.addEventListener("focusout",()=>{this._rowWithFocusedElement=void 0}),this.$.table.addEventListener("scroll",()=>this._afterScroll())}_onResize(){this._updateOverflow(),this.__updateHorizontalScrollPosition()}scrollToIndex(a){a=Math.min(this._effectiveSize-1,Math.max(0,a)),this.__virtualizer.scrollToIndex(a),this.__scrollIntoViewport(a)}__scrollIntoViewport(a){const k=[...this.$.items.children].find(tt=>tt.index===a);if(k){const tt=k.getBoundingClientRect(),et=this.$.footer.getBoundingClientRect().top,rt=this.$.header.getBoundingClientRect().bottom;tt.bottom>et?this.$.table.scrollTop+=tt.bottom-et:tt.top<rt&&(this.$.table.scrollTop-=rt-tt.top)}}_scheduleScrolling(){this._scrollingFrame||(this._scrollingFrame=requestAnimationFrame(()=>this.$.scroller.toggleAttribute("scrolling",!0))),this._debounceScrolling=Debouncer$1.debounce(this._debounceScrolling,timeOut.after(timeouts.SCROLLING),()=>{cancelAnimationFrame(this._scrollingFrame),delete this._scrollingFrame,this.$.scroller.toggleAttribute("scrolling",!1)})}_afterScroll(){this.__updateHorizontalScrollPosition(),this.hasAttribute("reordering")||this._scheduleScrolling(),this.hasAttribute("navigating")||this._hideTooltip(!0),this._updateOverflow()}_updateOverflow(){this._debounceOverflow=Debouncer$1.debounce(this._debounceOverflow,animationFrame,()=>{this.__doUpdateOverflow()})}__doUpdateOverflow(){let a="";const k=this.$.table;k.scrollTop<k.scrollHeight-k.clientHeight&&(a+=" bottom"),k.scrollTop>0&&(a+=" top");const tt=getNormalizedScrollLeft(k,this.getAttribute("dir"));tt>0&&(a+=" start"),tt<k.scrollWidth-k.clientWidth&&(a+=" end"),this.__isRTL&&(a=a.replace(/start|end/giu,rt=>rt==="start"?"end":"start")),k.scrollLeft<k.scrollWidth-k.clientWidth&&(a+=" right"),k.scrollLeft>0&&(a+=" left");const et=a.trim();et.length>0&&this.getAttribute("overflow")!==et?this.setAttribute("overflow",et):et.length===0&&this.hasAttribute("overflow")&&this.removeAttribute("overflow")}_frozenCellsChanged(){this._debouncerCacheElements=Debouncer$1.debounce(this._debouncerCacheElements,microTask,()=>{Array.from(this.shadowRoot.querySelectorAll('[part~="cell"]')).forEach(a=>{a.style.transform=""}),this._frozenCells=Array.prototype.slice.call(this.$.table.querySelectorAll("[frozen]")),this._frozenToEndCells=Array.prototype.slice.call(this.$.table.querySelectorAll("[frozen-to-end]")),this.__updateHorizontalScrollPosition()}),this._debounceUpdateFrozenColumn()}_debounceUpdateFrozenColumn(){this.__debounceUpdateFrozenColumn=Debouncer$1.debounce(this.__debounceUpdateFrozenColumn,microTask,()=>this._updateFrozenColumn())}_updateFrozenColumn(){if(!this._columnTree)return;const a=this._columnTree[this._columnTree.length-1].slice(0);a.sort((et,rt)=>et._order-rt._order);let k,tt;for(let et=0;et<a.length;et++){const rt=a[et];rt._lastFrozen=!1,rt._firstFrozenToEnd=!1,tt===void 0&&rt.frozenToEnd&&!rt.hidden&&(tt=et),rt.frozen&&!rt.hidden&&(k=et)}k!==void 0&&(a[k]._lastFrozen=!0),tt!==void 0&&(a[tt]._firstFrozenToEnd=!0)}__updateHorizontalScrollPosition(){const a=this.$.table.scrollWidth,k=this.$.table.clientWidth,tt=Math.max(0,this.$.table.scrollLeft),et=getNormalizedScrollLeft(this.$.table,this.getAttribute("dir")),rt=`translate(${-tt}px, 0)`;this.$.header.style.transform=rt,this.$.footer.style.transform=rt,this.$.items.style.transform=rt;const nt=this.__isRTL?et+k-a:tt,ot=`translate(${nt}px, 0)`;this._frozenCells.forEach(ht=>{ht.style.transform=ot});const lt=`translate(${this.__isRTL?et:tt+k-a}px, 0)`;this._frozenToEndCells.forEach(ht=>{ht.style.transform=lt}),this.hasAttribute("navigating")&&this.__rowFocusMode&&this.$.table.style.setProperty("--_grid-horizontal-scroll-position",`${-nt}px`)}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const SelectionMixin=j=>class extends j{static get properties(){return{selectedItems:{type:Object,notify:!0,value:()=>[]},__selectedKeys:{type:Object,computed:"__computeSelectedKeys(itemIdPath, selectedItems.*)"}}}static get observers(){return["__selectedItemsChanged(itemIdPath, selectedItems.*)"]}_isSelected(a){return this.__selectedKeys.has(this.getItemId(a))}selectItem(a){this._isSelected(a)||(this.selectedItems=[...this.selectedItems,a])}deselectItem(a){this._isSelected(a)&&(this.selectedItems=this.selectedItems.filter(k=>!this._itemsEqual(k,a)))}_toggleItem(a){this._isSelected(a)?this.deselectItem(a):this.selectItem(a)}__selectedItemsChanged(){this.requestContentUpdate()}__computeSelectedKeys(a,k){const tt=k.base||[],et=new Set;return tt.forEach(rt=>{et.add(this.getItemId(rt))}),et}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */let defaultMultiSortPriority="prepend";const SortMixin=j=>class extends j{static get properties(){return{multiSort:{type:Boolean,value:!1},multiSortPriority:{type:String,value:()=>defaultMultiSortPriority},multiSortOnShiftClick:{type:Boolean,value:!1},_sorters:{type:Array,value:()=>[]},_previousSorters:{type:Array,value:()=>[]}}}static setDefaultMultiSortPriority(a){defaultMultiSortPriority=["append","prepend"].includes(a)?a:"prepend"}ready(){super.ready(),this.addEventListener("sorter-changed",this._onSorterChanged)}_onSorterChanged(a){const k=a.target;a.stopPropagation(),k._grid=this,this.__updateSorter(k,a.detail.shiftClick,a.detail.fromSorterClick),this.__applySorters()}__removeSorters(a){a.length!==0&&(this._sorters=this._sorters.filter(k=>a.indexOf(k)<0),this.multiSort&&this.__updateSortOrders(),this.__applySorters())}__updateSortOrders(){this._sorters.forEach((a,k)=>{a._order=this._sorters.length>1?k:null})}__appendSorter(a){a.direction?this._sorters.includes(a)||this._sorters.push(a):this._removeArrayItem(this._sorters,a),this.__updateSortOrders()}__prependSorter(a){this._removeArrayItem(this._sorters,a),a.direction&&this._sorters.unshift(a),this.__updateSortOrders()}__updateSorter(a,k,tt){if(!(!a.direction&&this._sorters.indexOf(a)===-1)){if(a._order=null,this.multiSort&&(!this.multiSortOnShiftClick||!tt)||this.multiSortOnShiftClick&&k)this.multiSortPriority==="append"?this.__appendSorter(a):this.__prependSorter(a);else if(a.direction||this.multiSortOnShiftClick){const et=this._sorters.filter(rt=>rt!==a);this._sorters=a.direction?[a]:[],et.forEach(rt=>{rt._order=null,rt.direction=null})}}}__applySorters(){this.dataProvider&&this.isAttached&&JSON.stringify(this._previousSorters)!==JSON.stringify(this._mapSorters())&&this.clearCache(),this._a11yUpdateSorters(),this._previousSorters=this._mapSorters()}_mapSorters(){return this._sorters.map(a=>({path:a.path,direction:a.direction}))}_removeArrayItem(a,k){const tt=a.indexOf(k);tt>-1&&a.splice(tt,1)}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const StylingMixin=j=>class extends j{static get properties(){return{cellClassNameGenerator:Function,cellPartNameGenerator:Function}}static get observers(){return["__cellClassNameGeneratorChanged(cellClassNameGenerator)","__cellPartNameGeneratorChanged(cellPartNameGenerator)"]}__cellClassNameGeneratorChanged(){this.generateCellClassNames()}__cellPartNameGeneratorChanged(){this.generateCellPartNames()}generateCellClassNames(){iterateChildren(this.$.items,a=>{!a.hidden&&!a.hasAttribute("loading")&&this._generateCellClassNames(a,this.__getRowModel(a))})}generateCellPartNames(){iterateChildren(this.$.items,a=>{!a.hidden&&!a.hasAttribute("loading")&&this._generateCellPartNames(a,this.__getRowModel(a))})}_generateCellClassNames(a,k){iterateChildren(a,tt=>{if(tt.__generatedClasses&&tt.__generatedClasses.forEach(et=>tt.classList.remove(et)),this.cellClassNameGenerator){const et=this.cellClassNameGenerator(tt._column,k);tt.__generatedClasses=et&&et.split(" ").filter(rt=>rt.length>0),tt.__generatedClasses&&tt.__generatedClasses.forEach(rt=>tt.classList.add(rt))}})}_generateCellPartNames(a,k){iterateChildren(a,tt=>{if(tt.__generatedParts&&tt.__generatedParts.forEach(et=>{updatePart(tt,null,et)}),this.cellPartNameGenerator){const et=this.cellPartNameGenerator(tt._column,k);tt.__generatedParts=et&&et.split(" ").filter(rt=>rt.length>0),tt.__generatedParts&&tt.__generatedParts.forEach(rt=>{updatePart(tt,!0,rt)})}})}};/**
 * @license
 * Copyright (c) 2016 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Grid extends ElementMixin(ThemableMixin(DataProviderMixin(ArrayDataProviderMixin(DynamicColumnsMixin(ActiveItemMixin(ScrollMixin(SelectionMixin(SortMixin(RowDetailsMixin(KeyboardNavigationMixin(A11yMixin(FilterMixin(ColumnReorderingMixin(ColumnResizingMixin(ControllerMixin(EventContextMixin(DragAndDropMixin(StylingMixin(TabindexMixin(PolymerElement)))))))))))))))))))){static get template(){return html`
      <div
        id="scroller"
        safari$="[[_safari]]"
        ios$="[[_ios]]"
        loading$="[[loading]]"
        column-reordering-allowed$="[[columnReorderingAllowed]]"
      >
        <table id="table" role="treegrid" aria-multiselectable="true" tabindex="0">
          <caption id="sizer" part="row"></caption>
          <thead id="header" role="rowgroup"></thead>
          <tbody id="items" role="rowgroup"></tbody>
          <tfoot id="footer" role="rowgroup"></tfoot>
        </table>

        <div part="reorder-ghost"></div>
      </div>

      <slot name="tooltip"></slot>

      <div id="focusexit" tabindex="0"></div>
    `}static get is(){return"vaadin-grid"}static get observers(){return["_columnTreeChanged(_columnTree, _columnTree.*)","_effectiveSizeChanged(_effectiveSize, __virtualizer, _hasData, _columnTree)"]}static get properties(){return{_safari:{type:Boolean,value:isSafari},_ios:{type:Boolean,value:isIOS},_firefox:{type:Boolean,value:isFirefox$4},_android:{type:Boolean,value:isAndroid},_touchDevice:{type:Boolean,value:isTouch},allRowsVisible:{type:Boolean,value:!1,reflectToAttribute:!0},_recalculateColumnWidthOnceLoadingFinished:{type:Boolean,value:!0},isAttached:{value:!1},__gridElement:{type:Boolean,value:!0}}}constructor(){super(),this.addEventListener("animationend",this._onAnimationEnd)}get _firstVisibleIndex(){const E=this.__getFirstVisibleItem();return E?E.index:void 0}get _lastVisibleIndex(){const E=this.__getLastVisibleItem();return E?E.index:void 0}connectedCallback(){super.connectedCallback(),this.isAttached=!0,this.recalculateColumnWidths()}disconnectedCallback(){super.disconnectedCallback(),this.isAttached=!1,this._hideTooltip(!0)}__getFirstVisibleItem(){return this._getVisibleRows().find(E=>this._isInViewport(E))}__getLastVisibleItem(){return this._getVisibleRows().reverse().find(E=>this._isInViewport(E))}_isInViewport(E){const a=this.$.table.getBoundingClientRect(),k=E.getBoundingClientRect(),tt=this.$.header.getBoundingClientRect().height,et=this.$.footer.getBoundingClientRect().height;return k.bottom>a.top+tt&&k.top<a.bottom-et}_getVisibleRows(){return Array.from(this.$.items.children).filter(E=>!E.hidden).sort((E,a)=>E.index-a.index)}ready(){super.ready(),this.__virtualizer=new Virtualizer({createElements:this._createScrollerRows.bind(this),updateElement:this._updateScrollerItem.bind(this),scrollContainer:this.$.items,scrollTarget:this.$.table,reorderElements:!0}),new ResizeObserver(()=>setTimeout(()=>this.__updateFooterPositioning())).observe(this.$.footer),processTemplates(this),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController),this._tooltipController.setManual(!0)}__getBodyCellCoordinates(E){if(this.$.items.contains(E)&&E.localName==="td")return{item:E.parentElement._item,column:E._column}}__focusBodyCell({item:E,column:a}){const k=this._getVisibleRows().find(et=>et._item===E),tt=k&&[...k.children].find(et=>et._column===a);tt&&tt.focus()}_effectiveSizeChanged(E,a,k,tt){if(a&&k&&tt){const et=this.shadowRoot.activeElement,rt=this.__getBodyCellCoordinates(et),nt=a.size||0;a.size=E,a.update(nt-1,nt-1),E<nt&&a.update(E-1,E-1),rt&&et.parentElement.hidden&&this.__focusBodyCell(rt),this._resetKeyboardNavigation()}}__hasRowsWithClientHeight(){return!!Array.from(this.$.items.children).filter(E=>E.clientHeight).length}__itemsReceived(){this._recalculateColumnWidthOnceLoadingFinished&&!this._cache.isLoading()&&this.__hasRowsWithClientHeight()&&(this._recalculateColumnWidthOnceLoadingFinished=!1,this.recalculateColumnWidths())}__getIntrinsicWidth(E){if(this.__intrinsicWidthCache.has(E))return this.__intrinsicWidthCache.get(E);const a=this.__calculateIntrinsicWidth(E);return this.__intrinsicWidthCache.set(E,a),a}__calculateIntrinsicWidth(E){const a=E.width,k=E.flexGrow;E.width="auto",E.flexGrow=0;const tt=E._allCells.filter(et=>!this.$.items.contains(et)||this._isInViewport(et.parentElement)).reduce((et,rt)=>Math.max(et,rt.offsetWidth+1),0);return E.flexGrow=k,E.width=a,tt}__getDistributedWidth(E,a){if(E==null||E===this)return 0;const k=Math.max(this.__getIntrinsicWidth(E),this.__getDistributedWidth(E.parentElement,E));if(!a)return k;const tt=E,et=k,rt=tt._visibleChildColumns.map(lt=>this.__getIntrinsicWidth(lt)).reduce((lt,ht)=>lt+ht,0),nt=Math.max(0,et-rt),st=this.__getIntrinsicWidth(a)/rt*nt;return this.__getIntrinsicWidth(a)+st}_recalculateColumnWidths(E){this.__virtualizer.flush(),[...this.$.header.children,...this.$.footer.children].forEach(a=>{a.__debounceUpdateHeaderFooterRowVisibility&&a.__debounceUpdateHeaderFooterRowVisibility.flush()}),this._debouncerHiddenChanged&&this._debouncerHiddenChanged.flush(),this.__intrinsicWidthCache=new Map,E.forEach(a=>{a.width=`${this.__getDistributedWidth(a)}px`})}recalculateColumnWidths(){if(this._columnTree)if(this._cache.isLoading())this._recalculateColumnWidthOnceLoadingFinished=!0;else{const E=this._getColumns().filter(a=>!a.hidden&&a.autoWidth);this._recalculateColumnWidths(E)}}_createScrollerRows(E){const a=[];for(let k=0;k<E;k++){const tt=document.createElement("tr");tt.setAttribute("part","row"),tt.setAttribute("role","row"),tt.setAttribute("tabindex","-1"),this._columnTree&&this._updateRow(tt,this._columnTree[this._columnTree.length-1],"body",!1,!0),a.push(tt)}return this._columnTree&&this._columnTree[this._columnTree.length-1].forEach(k=>k.isConnected&&k.notifyPath&&k.notifyPath("_cells.*",k._cells)),beforeNextRender(this,()=>{this._updateFirstAndLastColumn(),this._resetKeyboardNavigation(),this._afterScroll(),this.__itemsReceived()}),a}_createCell(E,a){const tt=`vaadin-grid-cell-content-${this._contentIndex=this._contentIndex+1||0}`,et=document.createElement("vaadin-grid-cell-content");et.setAttribute("slot",tt);const rt=document.createElement(E);rt.id=tt.replace("-content-","-"),rt.setAttribute("role",E==="td"?"gridcell":"columnheader"),!isAndroid&&!isIOS&&(rt.addEventListener("mouseenter",ot=>{this.$.scroller.hasAttribute("scrolling")||this._showTooltip(ot)}),rt.addEventListener("mouseleave",()=>{this._hideTooltip()}),rt.addEventListener("mousedown",()=>{this._hideTooltip(!0)}));const nt=document.createElement("slot");if(nt.setAttribute("name",tt),a&&a._focusButtonMode){const ot=document.createElement("div");ot.setAttribute("role","button"),ot.setAttribute("tabindex","-1"),rt.appendChild(ot),rt._focusButton=ot,rt.focus=function(){rt._focusButton.focus()},ot.appendChild(nt)}else rt.setAttribute("tabindex","-1"),rt.appendChild(nt);return rt._content=et,et.addEventListener("mousedown",()=>{if(isChrome){const ot=st=>{const lt=et.contains(this.getRootNode().activeElement),ht=st.composedPath().includes(et);!lt&&ht&&rt.focus(),document.removeEventListener("mouseup",ot,!0)};document.addEventListener("mouseup",ot,!0)}else setTimeout(()=>{et.contains(this.getRootNode().activeElement)||rt.focus()})}),rt}_updateRow(E,a,k="body",tt=!1,et=!1){const rt=document.createDocumentFragment();iterateChildren(E,nt=>{nt._vacant=!0}),E.innerHTML="",a.filter(nt=>!nt.hidden).forEach((nt,ot,st)=>{let lt;if(k==="body"){if(nt._cells||(nt._cells=[]),lt=nt._cells.find(ht=>ht._vacant),lt||(lt=this._createCell("td",nt),nt._cells.push(lt)),lt.setAttribute("part","cell body-cell"),E.appendChild(lt),ot===st.length-1&&this.rowDetailsRenderer){this._detailsCells||(this._detailsCells=[]);const ht=this._detailsCells.find(ut=>ut._vacant)||this._createCell("td");this._detailsCells.indexOf(ht)===-1&&this._detailsCells.push(ht),ht._content.parentElement||rt.appendChild(ht._content),this._configureDetailsCell(ht),E.appendChild(ht),this._a11ySetRowDetailsCell(E,ht),ht._vacant=!1}nt.notifyPath&&!et&&nt.notifyPath("_cells.*",nt._cells)}else{const ht=k==="header"?"th":"td";tt||nt.localName==="vaadin-grid-column-group"?(lt=nt[`_${k}Cell`]||this._createCell(ht),lt._column=nt,E.appendChild(lt),nt[`_${k}Cell`]=lt):(nt._emptyCells||(nt._emptyCells=[]),lt=nt._emptyCells.find(ut=>ut._vacant)||this._createCell(ht),lt._column=nt,E.appendChild(lt),nt._emptyCells.indexOf(lt)===-1&&nt._emptyCells.push(lt)),lt.setAttribute("part",`cell ${k}-cell`)}lt._content.parentElement||rt.appendChild(lt._content),lt._vacant=!1,lt._column=nt}),k!=="body"&&this.__debounceUpdateHeaderFooterRowVisibility(E),this.appendChild(rt),this._frozenCellsChanged(),this._updateFirstAndLastColumnForRow(E)}__debounceUpdateHeaderFooterRowVisibility(E){E.__debounceUpdateHeaderFooterRowVisibility=Debouncer$1.debounce(E.__debounceUpdateHeaderFooterRowVisibility,microTask,()=>this.__updateHeaderFooterRowVisibility(E))}__updateHeaderFooterRowVisibility(E){if(!E)return;const a=Array.from(E.children).filter(k=>{const tt=k._column;if(tt._emptyCells&&tt._emptyCells.indexOf(k)>-1)return!1;if(E.parentElement===this.$.header){if(tt.headerRenderer)return!0;if(tt.header===null)return!1;if(tt.path||tt.header!==void 0)return!0}else if(tt.footerRenderer)return!0;return!1});E.hidden!==!a.length&&(E.hidden=!a.length),this._resetKeyboardNavigation()}_updateScrollerItem(E,a){this._preventScrollerRotatingCellFocus(E,a),this._columnTree&&(this._updateRowOrderParts(E,a),this._a11yUpdateRowRowindex(E,a),this._getItem(a,E))}_columnTreeChanged(E){this._renderColumnTree(E),this.recalculateColumnWidths()}_updateRowOrderParts(E,a=E.index){updateRowStates(E,{first:a===0,last:a===this._effectiveSize-1,odd:a%2!==0,even:a%2===0})}_updateRowStateParts(E,{expanded:a,selected:k,detailsOpened:tt}){updateRowStates(E,{expanded:a,selected:k,"details-opened":tt})}_renderColumnTree(E){for(iterateChildren(this.$.items,a=>{this._updateRow(a,E[E.length-1],"body",!1,!0);const k=this.__getRowModel(a);this._updateRowOrderParts(a),this._updateRowStateParts(a,k),this._filterDragAndDrop(a,k)});this.$.header.children.length<E.length;){const a=document.createElement("tr");a.setAttribute("part","row"),a.setAttribute("role","row"),a.setAttribute("tabindex","-1"),this.$.header.appendChild(a);const k=document.createElement("tr");k.setAttribute("part","row"),k.setAttribute("role","row"),k.setAttribute("tabindex","-1"),this.$.footer.appendChild(k)}for(;this.$.header.children.length>E.length;)this.$.header.removeChild(this.$.header.firstElementChild),this.$.footer.removeChild(this.$.footer.firstElementChild);iterateChildren(this.$.header,(a,k,tt)=>{this._updateRow(a,E[k],"header",k===E.length-1);const et=getBodyRowCells(a);updateCellsPart(et,"first-header-row-cell",k===0),updateCellsPart(et,"last-header-row-cell",k===tt.length-1)}),iterateChildren(this.$.footer,(a,k,tt)=>{this._updateRow(a,E[E.length-1-k],"footer",k===0);const et=getBodyRowCells(a);updateCellsPart(et,"first-footer-row-cell",k===0),updateCellsPart(et,"last-footer-row-cell",k===tt.length-1)}),this._updateRow(this.$.sizer,E[E.length-1]),this._resizeHandler(),this._frozenCellsChanged(),this._updateFirstAndLastColumn(),this._resetKeyboardNavigation(),this._a11yUpdateHeaderRows(),this._a11yUpdateFooterRows(),this.__updateFooterPositioning(),this.generateCellClassNames(),this.generateCellPartNames()}__updateFooterPositioning(){this._firefox&&parseFloat(navigator.userAgent.match(/Firefox\/(\d{2,3}.\d)/u)[1])<99&&(this.$.items.style.paddingBottom=0,this.allRowsVisible||(this.$.items.style.paddingBottom=`${this.$.footer.offsetHeight}px`))}_updateItem(E,a){E._item=a;const k=this.__getRowModel(E);this._toggleDetailsCell(E,k.detailsOpened),this._a11yUpdateRowLevel(E,k.level),this._a11yUpdateRowSelected(E,k.selected),this._updateRowStateParts(E,k),this._generateCellClassNames(E,k),this._generateCellPartNames(E,k),this._filterDragAndDrop(E,k),iterateChildren(E,tt=>{if(tt._renderer){const et=tt._column||this;tt._renderer.call(et,tt._content,et,k)}}),this._updateDetailsCellHeight(E),this._a11yUpdateRowExpanded(E,k.expanded)}_resizeHandler(){this._updateDetailsCellHeights(),this.__updateFooterPositioning(),this.__updateHorizontalScrollPosition()}_onAnimationEnd(E){E.animationName.indexOf("vaadin-grid-appear")===0&&(E.stopPropagation(),this.__itemsReceived(),requestAnimationFrame(()=>{this.__scrollToPendingIndex()}))}__getRowModel(E){return{index:E.index,item:E._item,level:this._getIndexLevel(E.index),expanded:this._isExpanded(E._item),selected:this._isSelected(E._item),detailsOpened:!!this.rowDetailsRenderer&&this._isDetailsOpened(E._item)}}_showTooltip(E){const a=this._tooltipController.node;a&&a.isConnected&&(this._tooltipController.setTarget(E.target),this._tooltipController.setContext(this.getEventContext(E)),a._stateController.open({focus:E.type==="focusin",hover:E.type==="mouseenter"}))}_hideTooltip(E){const a=this._tooltipController.node;a&&a._stateController.close(E)}requestContentUpdate(){this._columnTree&&(this._columnTree.forEach(E=>{E.forEach(a=>{a._renderHeaderAndFooter&&a._renderHeaderAndFooter()})}),this.__updateVisibleRows())}__updateVisibleRows(E,a){this.__virtualizer&&this.__virtualizer.update(E,a)}}customElements.define(Grid.is,Grid);var __defProp$1=Object.defineProperty,__getOwnPropDesc$1=Object.getOwnPropertyDescriptor,__decorateClass$1=(j,E,a,k)=>{for(var tt=k>1?void 0:k?__getOwnPropDesc$1(E,a):E,et=j.length-1,rt;et>=0;et--)(rt=j[et])&&(tt=(k?rt(E,a,tt):rt(tt))||tt);return k&&tt&&__defProp$1(E,a,tt),tt};let id=0,Nav=class extends s$2{constructor(){super(...arguments),this.collapsible=!1,this.collapsed=!1}connectedCallback(){super.connectedCallback(),this.setAttribute("role","navigation")}render(){const j=this.querySelector('[slot="label"]');return j&&this.collapsible?y`
        <details ?open="${!this.collapsed}" @toggle="${this.toggleCollapsed}">${this.renderBody(j)}</details>
      `:this.renderBody(j)}renderBody(j){return j?(j.id||(j.id="app-nav-label-"+id++),this.setAttribute("aria-labelledby",j.id)):this.removeAttribute("aria-labelledby"),y`
      <summary part="label" ?hidden="${j==null}">
        <slot name="label" @slotchange="${()=>this.requestUpdate()}"></slot>
      </summary>
      <slot role="list"></slot>
    `}toggleCollapsed(j){this.collapsed=!j.target.open}};Nav.styles=i$2`
    :host {
      display: block;
      font-family: var(--lumo-font-family);
      font-size: var(--lumo-font-size-m);
      font-weight: 500;
      line-height: var(--lumo-line-height-xs);
      color: var(--lumo-body-text-color);
      -webkit-tap-highlight-color: transparent;
    }

    [hidden] {
      display: none !important;
    }

    summary {
      cursor: var(--lumo-clickable-cursor, default);
      display: flex;
      align-items: center;
      justify-content: space-between;
      border-radius: var(--lumo-border-radius-m);
    }

    summary ::slotted([slot='label']) {
      display: block;
      font-size: var(--lumo-font-size-s);
      color: var(--lumo-secondary-text-color);
      margin: var(--lumo-space-s);
      border-radius: inherit;
    }

    summary::-webkit-details-marker {
      display: none;
    }

    summary::marker {
      content: '';
    }

    summary::after {
      font-family: lumo-icons;
      color: var(--lumo-tertiary-text-color);
      font-size: var(--lumo-icon-size-m);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      width: var(--lumo-size-s);
      height: var(--lumo-size-s);
      transition: transform 140ms;
      margin: 0 var(--lumo-space-xs);
    }

    :host([collapsible]) summary::after {
      content: var(--lumo-icons-dropdown);
    }

    @media (any-hover: hover) {
      summary:hover::after {
        color: var(--lumo-body-text-color);
      }
    }

    :host([collapsed]) summary::after {
      transform: rotate(-90deg);
    }

    @supports selector(:focus-visible) {
      summary {
        outline: none;
      }

      summary:focus-visible {
        box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);
      }
    }

    slot {
      /* Needed to make role="list" work */
      display: block;
    }
  `;__decorateClass$1([e$2({type:Boolean,reflect:!0})],Nav.prototype,"collapsible",2);__decorateClass$1([e$2({type:Boolean,reflect:!0})],Nav.prototype,"collapsed",2);Nav=__decorateClass$1([e$3("vcf-nav")],Nav);var __defProp=Object.defineProperty,__getOwnPropDesc=Object.getOwnPropertyDescriptor,__decorateClass=(j,E,a,k)=>{for(var tt=k>1?void 0:k?__getOwnPropDesc(E,a):E,et=j.length-1,rt;et>=0;et--)(rt=j[et])&&(tt=(k?rt(E,a,tt):rt(tt))||tt);return k&&tt&&__defProp(E,a,tt),tt};let NavItem=class extends s$2{constructor(){super(...arguments),this.path="",this.expanded=!1,this.active=!1}connectedCallback(){super.connectedCallback(),this.setAttribute("role","listitem"),this._updateActive(),this.__boundUpdateActive=this._updateActive.bind(this),window.addEventListener("popstate",this.__boundUpdateActive)}disconnectedCallback(){super.disconnectedCallback(),window.removeEventListener("popstate",this.__boundUpdateActive)}render(){return y`
      <a href="${this.path}" part="item" aria-current="${this.active?"page":!1}">
        <slot name="prefix"></slot>
        <slot></slot>
        <slot name="suffix"></slot>
        <button
          part="toggle-button"
          @click="${this.toggleExpanded}"
          ?hidden="${!this.querySelector("[slot=children]")}"
          aria-controls="children"
          aria-expanded="${this.expanded}"
          aria-label="Toggle child items"></button>
      </a>
      <slot name="children" role="list" part="children" id="children" ?hidden="${!this.expanded}"></slot>
    `}toggleExpanded(j){j.preventDefault(),j.stopPropagation(),this.expanded=!this.expanded}_updateActive(){const j=document.baseURI!=document.location.href,E=this.path.startsWith("/");if(j&&!E){const a=document.location.pathname,k=new URL(document.baseURI).pathname,tt=a.substring(k.length),et=k!==a&&a.startsWith(k)?tt:a;this.active=et===this.path}else this.active=document.location.pathname==this.path;this.toggleAttribute("child-active",document.location.pathname.startsWith(this.path)),this.active&&(this.expanded=!0)}};NavItem.styles=i$2`
    :host {
      display: block;
    }

    [hidden] {
      display: none !important;
    }

    a {
      flex: auto;
      min-width: 0;
      display: flex;
      align-items: center;
      gap: var(--lumo-space-xs);
      text-decoration: none;
      color: inherit;
      font: inherit;
      padding: var(--lumo-space-s);
      padding-inline-start: calc(var(--lumo-space-s) + var(--_child-indent, 0px));
      transition: color 140ms;
      border-radius: var(--lumo-border-radius-m);
      transition: background-color 140ms, color 140ms;
      cursor: var(--lumo-clickable-cursor, default);
      min-height: var(--lumo-icon-size-m);
    }

    button {
      -webkit-appearance: none;
      appearance: none;
      border: 0;
      margin: calc((var(--lumo-icon-size-m) - var(--lumo-size-s)) / 2) 0;
      margin-inline-end: calc(var(--lumo-space-xs) * -1);
      padding: 0;
      background: transparent;
      font: inherit;
      color: var(--lumo-tertiary-text-color);
      flex: none;
      width: var(--lumo-size-s);
      height: var(--lumo-size-s);
      cursor: var(--lumo-clickable-cursor, default);
      transition: color 140ms;
    }

    :host(:not([path])) a {
      position: relative;
    }

    :host(:not([path])) button::after {
      content: "";
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
    }

    @media (any-hover: hover) {
      a:hover {
        color: var(--lumo-header-text-color);
      }

      button:hover {
        color: var(--lumo-body-text-color);
      }
    }

    a:active:focus {
      background-color: var(--lumo-contrast-5pct);
    }

    button::before {
      font-family: lumo-icons;
      content: var(--lumo-icons-dropdown);
      font-size: 1.5em;
      line-height: var(--lumo-size-s);
      display: inline-block;
      transform: rotate(-90deg);
      transition: transform 140ms;
    }

    :host([expanded]) button::before {
      transform: none;
    }

    @supports selector(:focus-visible) {
      a,
      button {
        outline: none;
      }

      a:focus-visible,
      button:focus-visible {
        border-radius: var(--lumo-border-radius-m);
        box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);
      }
    }

    a:active {
      color: var(--lumo-header-text-color);
    }

    slot[name='prefix'],
    slot[name='suffix'] {
      flex: none;
    }

    slot:not([name]) {
      display: block;
      flex: auto;
      min-width: 0;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
      margin: 0 var(--lumo-space-xs);
    }

    slot[name='prefix']::slotted(:is(vaadin-icon, [class*='icon'])) {
      color: var(--lumo-contrast-60pct);
      font-size: var(--lumo-icon-size-s);
      min-width: 1em;
      min-height: 1em;
    }

    :host([active]) slot[name='prefix']::slotted(:is(vaadin-icon, [class*='icon'])) {
      color: inherit;
    }

    slot[name='children'] {
      --_child-indent: calc(var(--_child-indent-2, 0px) + var(--vcf-nav-child-indent, var(--lumo-space-l)));
    }

    slot[name='children']::slotted(*) {
      --_child-indent-2: var(--_child-indent);
    }

    slot[name='children'] {
      /* Needed to make role="list" work */
      display: block;
      width: 100%;
    }

    :host([active]) a {
      color: var(--lumo-primary-text-color);
      background-color: var(--lumo-primary-color-10pct);
    }
  `;__decorateClass([e$2()],NavItem.prototype,"path",2);__decorateClass([e$2({type:Boolean,reflect:!0})],NavItem.prototype,"expanded",2);__decorateClass([e$2({type:Boolean,reflect:!0})],NavItem.prototype,"active",2);__decorateClass([i$3("button")],NavItem.prototype,"button",2);__decorateClass([i$3("#children")],NavItem.prototype,"childrenSlot",2);NavItem=__decorateClass([e$3("vcf-nav-item")],NavItem);const detailsSummary=i$2`
  :host {
    display: flex;
    align-items: center;
    width: 100%;
    outline: none;
    padding: var(--lumo-space-s) 0;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    line-height: var(--lumo-line-height-xs);
    color: var(--lumo-secondary-text-color);
    background-color: inherit;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  :host([disabled]),
  :host([disabled]) [part='toggle'] {
    color: var(--lumo-disabled-text-color);
    cursor: default;
  }

  @media (hover: hover) {
    :host(:hover:not([disabled])),
    :host(:hover:not([disabled])) [part='toggle'] {
      color: var(--lumo-contrast-80pct);
    }
  }

  [part='toggle'] {
    display: block;
    width: 1em;
    height: 1em;
    margin-left: calc(var(--lumo-space-xs) * -1);
    margin-right: var(--lumo-space-xs);
    font-size: var(--lumo-icon-size-s);
    line-height: 1;
    color: var(--lumo-contrast-60pct);
    font-family: 'lumo-icons';
    cursor: var(--lumo-clickable-cursor);
  }

  [part='toggle']::before {
    content: var(--lumo-icons-angle-right);
  }

  :host([opened]) [part='toggle'] {
    transform: rotate(90deg);
  }

  /* RTL styles */
  :host([dir='rtl']) [part='toggle'] {
    margin-left: var(--lumo-space-xs);
    margin-right: calc(var(--lumo-space-xs) * -1);
  }

  :host([dir='rtl']) [part='toggle']::before {
    content: var(--lumo-icons-angle-left);
  }

  :host([opened][dir='rtl']) [part='toggle'] {
    transform: rotate(-90deg);
  }

  /* Small */
  :host([theme~='small']) {
    padding-top: var(--lumo-space-xs);
    padding-bottom: var(--lumo-space-xs);
  }

  :host([theme~='small']) [part='toggle'] {
    margin-right: calc(var(--lumo-space-xs) / 2);
  }

  :host([theme~='small'][dir='rtl']) [part='toggle'] {
    margin-left: calc(var(--lumo-space-xs) / 2);
  }

  /* Filled */
  :host([theme~='filled']) {
    padding: var(--lumo-space-s) calc(var(--lumo-space-s) + var(--lumo-space-xs) / 2);
  }

  /* Reverse */
  :host([theme~='reverse']) {
    justify-content: space-between;
  }

  :host([theme~='reverse']) [part='toggle'] {
    order: 1;
    margin-right: 0;
  }

  :host([theme~='reverse'][dir='rtl']) [part='toggle'] {
    margin-left: 0;
  }

  /* Filled reverse */
  :host([theme~='reverse'][theme~='filled']) {
    padding-left: var(--lumo-space-m);
  }

  :host([theme~='reverse'][theme~='filled'][dir='rtl']) {
    padding-right: var(--lumo-space-m);
  }
`;registerStyles$1("vaadin-details-summary",detailsSummary,{moduleId:"lumo-details-summary"});const accordionHeading=i$2`
  :host {
    padding: 0;
  }

  [part='content'] {
    padding: var(--lumo-space-s) 0;
  }
`;registerStyles$1("vaadin-accordion-heading",[detailsSummary,accordionHeading],{moduleId:"lumo-accordion-heading"});const details=i$2`
  :host {
    margin: var(--lumo-space-xs) 0;
    outline: none;
  }

  :host([focus-ring]) ::slotted([slot='summary']) {
    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) 0 var(--lumo-space-s);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-m);
  }

  :host([theme~='filled']) {
    background-color: var(--lumo-contrast-5pct);
    border-radius: var(--lumo-border-radius-m);
  }

  :host([theme~='filled']) [part='content'] {
    padding-left: var(--lumo-space-m);
    padding-right: var(--lumo-space-m);
  }

  :host([theme~='small']) [part$='content'] {
    font-size: var(--lumo-font-size-s);
  }
`;registerStyles$1("vaadin-details",details,{moduleId:"lumo-details"});const accordionPanel=i$2`
  :host {
    margin: 0;
    border-bottom: solid 1px var(--lumo-contrast-10pct);
  }

  :host(:last-child) {
    border-bottom: none;
  }

  :host([theme~='filled']) {
    border-bottom: none;
  }

  :host([theme~='filled']:not(:last-child)) {
    margin-bottom: 2px;
  }
`;registerStyles$1("vaadin-accordion-panel",[details,accordionPanel],{moduleId:"lumo-accordion-panel"});/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AccordionHeading extends ActiveMixin(DirMixin(ThemableMixin(PolymerElement))){static get is(){return"vaadin-accordion-heading"}static get template(){return html`
      <style>
        :host {
          display: block;
          outline: none;
          -webkit-user-select: none;
          -moz-user-select: none;
          user-select: none;
        }

        :host([hidden]) {
          display: none !important;
        }

        button {
          display: flex;
          align-items: center;
          width: 100%;
          margin: 0;
          padding: 0;
          background-color: initial;
          color: inherit;
          border: initial;
          outline: none;
          font: inherit;
          text-align: inherit;
        }
      </style>
      <button id="button" part="content" disabled$="[[disabled]]" aria-expanded$="[[__updateAriaExpanded(opened)]]">
        <span part="toggle" aria-hidden="true"></span>
        <slot></slot>
      </button>
    `}static get properties(){return{opened:{type:Boolean,reflectToAttribute:!0}}}_attachDom(E){const a=this.attachShadow({mode:"open",delegatesFocus:!0});return a.appendChild(E),a}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","heading")}__updateAriaExpanded(E){return E?"true":"false"}}customElements.define(AccordionHeading.is,AccordionHeading);/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class ContentController extends SlotChildObserveController{static generateId(E){return super.generateId(E,"content")}constructor(E){super(E,"",null,{multiple:!0})}}/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const CollapsibleMixin=j=>class extends j{static get properties(){return{opened:{type:Boolean,value:!1,reflectToAttribute:!0,notify:!0},_contentElements:{type:Array}}}static get observers(){return["_openedOrContentChanged(opened, _contentElements)"]}constructor(){super(),this._contentController=new ContentController(this),this._contentController.addEventListener("slot-content-changed",a=>{const k=a.target.nodes||[];this._contentElements=k.filter(tt=>tt.parentNode===this)})}ready(){super.ready(),this.addController(this._contentController),this.addEventListener("click",a=>{a.target===this.focusElement&&(this.opened=!this.opened)})}_openedOrContentChanged(a,k){k&&k.forEach(tt=>{tt.setAttribute("aria-hidden",a?"false":"true")})}};/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class SummaryController extends SlotChildObserveController{constructor(E,a){super(E,"summary",a)}setSummary(E){this.summary=E,this.getSlotChild()||this.restoreDefaultNode(),this.node===this.defaultNode&&this.updateDefaultNode(this.node)}restoreDefaultNode(){const{summary:E}=this;E&&E.trim()!==""&&this.attachDefaultNode()}updateDefaultNode(E){E&&(E.textContent=this.summary),super.updateDefaultNode(E)}}/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AccordionPanel extends CollapsibleMixin(DelegateFocusMixin(DelegateStateMixin(ThemableMixin(ControllerMixin(PolymerElement))))){static get is(){return"vaadin-accordion-panel"}static get template(){return html`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='content'] {
          display: none;
          overflow: hidden;
        }

        :host([opened]) [part='content'] {
          display: block;
          overflow: visible;
        }
      </style>

      <slot name="summary"></slot>

      <div part="content">
        <slot></slot>
      </div>

      <slot name="tooltip"></slot>
    `}static get properties(){return{summary:{type:String,observer:"_summaryChanged"}}}static get observers(){return["__updateAriaAttributes(focusElement, _contentElements)"]}static get delegateAttrs(){return["theme"]}static get delegateProps(){return["disabled","opened"]}constructor(){super(),this._summaryController=new SummaryController(this,"vaadin-accordion-heading"),this._summaryController.addEventListener("slot-content-changed",E=>{const{node:a}=E.target;this._setFocusElement(a),this.stateTarget=a,this._tooltipController.setTarget(a)}),this._tooltipController=new TooltipController(this),this._tooltipController.setPosition("bottom-start")}ready(){super.ready(),this.addController(this._summaryController),this.addController(this._tooltipController)}_setAriaDisabled(){}_summaryChanged(E){this._summaryController.setSummary(E)}__updateAriaAttributes(E,a){if(E&&a){const k=a[0];k&&(k.setAttribute("role","region"),k.setAttribute("aria-labelledby",E.id)),k&&k.id?E.setAttribute("aria-controls",k.id):E.removeAttribute("aria-controls")}}}customElements.define(AccordionPanel.is,AccordionPanel);/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const KeyboardDirectionMixin=j=>class extends KeyboardMixin(j){get focused(){return(this._getItems()||[]).find(isElementFocused)}get _vertical(){return!0}focus(){const a=this._getItems();if(Array.isArray(a)){const k=this._getAvailableIndex(a,0,null,tt=>!isElementHidden(tt));k>=0&&a[k].focus()}}_getItems(){return Array.from(this.children)}_onKeyDown(a){if(super._onKeyDown(a),a.metaKey||a.ctrlKey)return;const{key:k}=a,tt=this._getItems()||[],et=tt.indexOf(this.focused);let rt,nt;const st=!this._vertical&&this.getAttribute("dir")==="rtl"?-1:1;this.__isPrevKey(k)?(nt=-st,rt=et-st):this.__isNextKey(k)?(nt=st,rt=et+st):k==="Home"?(nt=1,rt=0):k==="End"&&(nt=-1,rt=tt.length-1),rt=this._getAvailableIndex(tt,rt,nt,lt=>!isElementHidden(lt)),rt>=0&&(a.preventDefault(),this._focus(rt,!0))}__isPrevKey(a){return this._vertical?a==="ArrowUp":a==="ArrowLeft"}__isNextKey(a){return this._vertical?a==="ArrowDown":a==="ArrowRight"}_focus(a,k=!1){const tt=this._getItems();this._focusItem(tt[a],k)}_focusItem(a){a&&(a.focus(),a.setAttribute("focus-ring",""))}_getAvailableIndex(a,k,tt,et){const rt=a.length;let nt=k;for(let ot=0;typeof nt=="number"&&ot<rt;ot+=1,nt+=tt||1){nt<0?nt=rt-1:nt>=rt&&(nt=0);const st=a[nt];if(!st.hasAttribute("disabled")&&this.__isMatchingItem(st,et))return nt}return-1}__isMatchingItem(a,k){return typeof k=="function"?k(a):!0}};/**
 * @license
 * Copyright (c) 2019 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Accordion extends KeyboardDirectionMixin(ThemableMixin(ElementMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-accordion"}static get properties(){return{opened:{type:Number,value:0,notify:!0,reflectToAttribute:!0},items:{type:Array,readOnly:!0,notify:!0}}}static get observers(){return["_updateItems(items, opened)"]}constructor(){super(),this._boundUpdateOpened=this._updateOpened.bind(this)}get focused(){return(this._getItems()||[]).find(E=>isElementFocused(E.focusElement))}focus(){this._observer&&this._observer.flush(),super.focus()}ready(){super.ready(),this._observer=new FlattenedNodesObserver(this,E=>{this._setItems(this._filterItems(Array.from(this.children))),this._filterItems(E.addedNodes).forEach(a=>{a.addEventListener("opened-changed",this._boundUpdateOpened)})})}_getItems(){return this.items}_filterItems(E){return E.filter(a=>a instanceof AccordionPanel)}_updateItems(E,a){if(E){const k=E[a];E.forEach(tt=>{tt.opened=tt===k})}}_onKeyDown(E){this.items.some(a=>a.focusElement===E.target)&&super._onKeyDown(E)}_updateOpened(E){const a=this._filterItems(E.composedPath())[0],k=this.items.indexOf(a);if(E.detail.value){if(a.disabled||k===-1)return;this.opened=k}else this.items.some(tt=>tt.opened)||(this.opened=null)}}customElements.define(Accordion.is,Accordion);registerStyles$1("vaadin-app-layout",i$2`
    [part='navbar'],
    [part='drawer'] {
      background-color: var(--lumo-base-color);
      background-clip: padding-box;
    }

    [part='navbar'] {
      min-height: var(--lumo-size-xl);
      border-bottom: 1px solid var(--lumo-contrast-10pct);
    }

    [part='navbar'][bottom] {
      border-bottom: none;
      border-top: 1px solid var(--lumo-contrast-10pct);
    }

    [part='drawer'] {
      border-inline-end: 1px solid var(--lumo-contrast-10pct);
    }

    :host([overlay]) [part='drawer'] {
      border-inline-end: none;
      box-shadow: var(--lumo-box-shadow-s);
    }

    :host([primary-section='navbar']) [part='navbar'] {
      border: none;
      background-image: linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    }

    :host([primary-section='drawer']:not([overlay])) [part='drawer'] {
      background-image: linear-gradient(var(--lumo-shade-5pct), var(--lumo-shade-5pct));
    }

    [part='backdrop'] {
      background-color: var(--lumo-shade-20pct);
      opacity: 1;
    }

    [part] ::slotted(h2),
    [part] ::slotted(h3),
    [part] ::slotted(h4) {
      margin-top: var(--lumo-space-xs) !important;
      margin-bottom: var(--lumo-space-xs) !important;
    }
  `,{moduleId:"lumo-app-layout"});const template$a=document.createElement("template");template$a.innerHTML=`
  <style>
    /* Use units so that the values can be used in calc() */
    html {
      --safe-area-inset-top: env(safe-area-inset-top, 0px);
      --safe-area-inset-right: env(safe-area-inset-right, 0px);
      --safe-area-inset-bottom: env(safe-area-inset-bottom, 0px);
      --safe-area-inset-left: env(safe-area-inset-left, 0px);
    }
  </style>
`;document.head.appendChild(template$a.content);/**
 * @license
 * Copyright (c) 2018 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */function _detectIosNavbar(){if(isIOS){const j=window.innerHeight,a=window.innerWidth>j,k=document.documentElement.clientHeight;a&&k>j?document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom",`${k-j}px`):document.documentElement.style.setProperty("--vaadin-viewport-offset-bottom","")}}_detectIosNavbar();window.addEventListener("resize",_detectIosNavbar);/**
 * @license
 * Copyright (c) 2021 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const instances=[];class FocusTrapController{constructor(E){this.host=E,this.__trapNode=null,this.__onKeyDown=this.__onKeyDown.bind(this)}get __focusableElements(){return getFocusableElements(this.__trapNode)}get __focusedElementIndex(){const E=this.__focusableElements;return E.indexOf(E.filter(isElementFocused).pop())}hostConnected(){document.addEventListener("keydown",this.__onKeyDown)}hostDisconnected(){document.removeEventListener("keydown",this.__onKeyDown)}trapFocus(E){if(this.__trapNode=E,this.__focusableElements.length===0)throw this.__trapNode=null,new Error("The trap node should have at least one focusable descendant or be focusable itself.");instances.push(this),this.__focusedElementIndex===-1&&this.__focusableElements[0].focus()}releaseFocus(){this.__trapNode=null,instances.pop()}__onKeyDown(E){if(this.__trapNode&&this===Array.from(instances).pop()&&E.key==="Tab"){E.preventDefault();const a=E.shiftKey;this.__focusNextElement(a)}}__focusNextElement(E=!1){const a=this.__focusableElements,k=E?-1:1,tt=this.__focusedElementIndex,et=(a.length+tt+k)%a.length,rt=a[et];rt.focus(),rt.localName==="input"&&rt.select()}}/**
 * @license
 * Copyright (c) 2018 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AppLayout extends ElementMixin(ThemableMixin(ControllerMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          display: block;
          box-sizing: border-box;
          height: 100%;
          --vaadin-app-layout-transition: 200ms;
          transition: padding var(--vaadin-app-layout-transition);
          --vaadin-app-layout-touch-optimized: false;
          --vaadin-app-layout-navbar-offset-top: var(--_vaadin-app-layout-navbar-offset-size);
          --vaadin-app-layout-navbar-offset-bottom: var(--_vaadin-app-layout-navbar-offset-size-bottom);
          padding-top: var(--vaadin-app-layout-navbar-offset-top);
          padding-bottom: var(--vaadin-app-layout-navbar-offset-bottom);
          padding-left: var(--vaadin-app-layout-navbar-offset-left);
        }

        :host([dir='rtl']) {
          padding-left: 0;
          padding-right: var(--vaadin-app-layout-navbar-offset-left);
        }

        :host([hidden]),
        [hidden] {
          display: none !important;
        }

        :host([no-anim]) {
          --vaadin-app-layout-transition: none !important;
        }

        :host([drawer-opened]) {
          --vaadin-app-layout-drawer-offset-left: var(--_vaadin-app-layout-drawer-offset-size);
        }

        :host([overlay]) {
          --vaadin-app-layout-drawer-offset-left: 0;
          --vaadin-app-layout-navbar-offset-left: 0;
        }

        :host(:not([no-scroll])) [content] {
          overflow: auto;
        }

        [content] {
          height: 100%;
        }

        @media (pointer: coarse) and (max-width: 800px) and (min-height: 500px) {
          :host {
            --vaadin-app-layout-touch-optimized: true;
          }
        }

        [part='navbar'] {
          position: fixed;
          display: flex;
          align-items: center;
          top: 0;
          right: 0;
          left: 0;
          transition: left var(--vaadin-app-layout-transition);
          padding-top: var(--safe-area-inset-top);
          padding-left: var(--safe-area-inset-left);
          padding-right: var(--safe-area-inset-right);
          z-index: 1;
        }

        :host(:not([dir='rtl'])[primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
          left: var(--vaadin-app-layout-drawer-offset-left, 0);
        }

        :host([dir='rtl'][primary-section='drawer'][drawer-opened]:not([overlay])) [part='navbar'] {
          right: var(--vaadin-app-layout-drawer-offset-left, 0);
        }

        :host([primary-section='drawer']) [part='drawer'] {
          top: 0;
        }

        [part='navbar'][bottom] {
          top: auto;
          bottom: 0;
          padding-bottom: var(--safe-area-inset-bottom);
        }

        [part='drawer'] {
          overflow: auto;
          position: fixed;
          top: var(--vaadin-app-layout-navbar-offset-top, 0);
          right: auto;
          bottom: var(--vaadin-app-layout-navbar-offset-bottom, var(--vaadin-viewport-offset-bottom, 0));
          left: var(--vaadin-app-layout-navbar-offset-left, 0);
          transition: transform var(--vaadin-app-layout-transition), visibility var(--vaadin-app-layout-transition);
          transform: translateX(-100%);
          max-width: 90%;
          width: 16em;
          box-sizing: border-box;
          padding: var(--safe-area-inset-top) 0 var(--safe-area-inset-bottom) var(--safe-area-inset-left);
          outline: none;
          /* The drawer should be inaccessible by the tabbing navigation when it is closed. */
          visibility: hidden;
          display: flex;
          flex-direction: column;
        }

        :host([drawer-opened]) [part='drawer'] {
          /* The drawer should be accessible by the tabbing navigation when it is opened. */
          visibility: visible;
          transform: translateX(0%);
          touch-action: manipulation;
        }

        [part='backdrop'] {
          background-color: #000;
          opacity: 0.3;
        }

        :host(:not([drawer-opened])) [part='backdrop'] {
          opacity: 0;
        }

        :host([overlay]) [part='backdrop'] {
          position: fixed;
          top: 0;
          right: 0;
          bottom: 0;
          left: 0;
          pointer-events: none;
          transition: opacity var(--vaadin-app-layout-transition);
          -webkit-tap-highlight-color: transparent;
        }

        :host([overlay]) [part='drawer'] {
          top: 0;
          bottom: 0;
        }

        :host([overlay]) [part='drawer'],
        :host([overlay]) [part='backdrop'] {
          z-index: 2;
        }

        :host([drawer-opened][overlay]) [part='backdrop'] {
          pointer-events: auto;
          touch-action: manipulation;
        }

        :host([dir='rtl']) [part='drawer'] {
          left: auto;
          right: var(--vaadin-app-layout-navbar-offset-start, 0);
          transform: translateX(100%);
        }

        :host([dir='rtl']) [part='navbar'] {
          transition: right var(--vaadin-app-layout-transition);
        }

        :host([dir='rtl'][drawer-opened]) [part='drawer'] {
          transform: translateX(0%);
        }

        :host(:not([dir='rtl'])[drawer-opened]:not([overlay])) {
          padding-left: var(--vaadin-app-layout-drawer-offset-left);
        }

        :host([dir='rtl'][drawer-opened]:not([overlay])) {
          padding-right: var(--vaadin-app-layout-drawer-offset-left);
        }

        @media (max-width: 800px), (max-height: 600px) {
          :host {
            --vaadin-app-layout-drawer-overlay: true;
          }

          [part='drawer'] {
            width: 20em;
          }
        }

        /* If a vaadin-scroller is used in the drawer, allow it to take all remaining space and contain scrolling */
        [part='drawer'] ::slotted(vaadin-scroller) {
          flex: 1;
          overscroll-behavior: contain;
        }
      </style>
      <div part="navbar" id="navbarTop">
        <slot name="navbar"></slot>
      </div>
      <div part="backdrop" on-click="_onBackdropClick" on-touchend="_onBackdropTouchend"></div>
      <div part="drawer" id="drawer" on-keydown="__onDrawerKeyDown">
        <slot name="drawer" id="drawerSlot"></slot>
      </div>
      <div content>
        <slot></slot>
      </div>
      <div part="navbar" id="navbarBottom" bottom hidden>
        <slot name="navbar-bottom"></slot>
      </div>
      <div hidden><slot id="touchSlot" name="navbar touch-optimized"></slot></div>
    `}static get is(){return"vaadin-app-layout"}static get properties(){return{i18n:{type:Object,observer:"__i18nChanged",value:()=>({drawer:"Drawer"})},primarySection:{type:String,value:"navbar",notify:!0,reflectToAttribute:!0,observer:"__primarySectionChanged"},drawerOpened:{type:Boolean,notify:!0,value:!0,reflectToAttribute:!0,observer:"__drawerOpenedChanged"},overlay:{type:Boolean,notify:!0,readOnly:!0,value:!1,reflectToAttribute:!0},closeDrawerOn:{type:String,value:"vaadin-router-location-changed",observer:"_closeDrawerOnChanged"}}}static dispatchCloseOverlayDrawerEvent(){window.dispatchEvent(new CustomEvent("close-overlay-drawer"))}constructor(){super(),this.__boundResizeListener=this._resize.bind(this),this.__drawerToggleClickListener=this._drawerToggleClick.bind(this),this.__closeOverlayDrawerListener=this.__closeOverlayDrawer.bind(this),this.__trapFocusInDrawer=this.__trapFocusInDrawer.bind(this),this.__releaseFocusFromDrawer=this.__releaseFocusFromDrawer.bind(this),this.__focusTrapController=new FocusTrapController(this)}connectedCallback(){super.connectedCallback(),this._blockAnimationUntilAfterNextRender(),window.addEventListener("resize",this.__boundResizeListener),this.addEventListener("drawer-toggle-click",this.__drawerToggleClickListener),beforeNextRender(this,this._afterFirstRender),this._updateTouchOptimizedMode();const E=this.$.navbarTop.firstElementChild;this._navbarChildObserver=new FlattenedNodesObserver(E,()=>{this._updateTouchOptimizedMode()}),this._touchChildObserver=new FlattenedNodesObserver(this.$.touchSlot,()=>{this._updateTouchOptimizedMode()}),this._drawerChildObserver=new FlattenedNodesObserver(this.$.drawerSlot,()=>{this._updateDrawerSize()}),this._updateDrawerSize(),this._updateOverlayMode(),this._navbarSizeObserver=new ResizeObserver(()=>{this._blockAnimationUntilAfterNextRender(),this._updateOffsetSize()}),this._navbarSizeObserver.observe(this.$.navbarTop),this._navbarSizeObserver.observe(this.$.navbarBottom),window.addEventListener("close-overlay-drawer",this.__closeOverlayDrawerListener)}ready(){super.ready(),this.addController(this.__focusTrapController),this.__setAriaExpanded()}disconnectedCallback(){super.disconnectedCallback(),this._navbarChildObserver&&this._navbarChildObserver.disconnect(),this._drawerChildObserver&&this._drawerChildObserver.disconnect(),this._touchChildObserver&&this._touchChildObserver.disconnect(),window.removeEventListener("resize",this.__boundResizeListener),this.removeEventListener("drawer-toggle-click",this.__drawerToggleClickListener),window.removeEventListener("close-overlay-drawer",this.__drawerToggleClickListener)}__primarySectionChanged(E){["navbar","drawer"].includes(E)||this.set("primarySection","navbar")}__drawerOpenedChanged(E,a){this.overlay&&(E?this.__trapFocusInDrawer():a&&this.__releaseFocusFromDrawer()),this.__setAriaExpanded()}__i18nChanged(){this.__updateDrawerAriaAttributes()}_afterFirstRender(){this._blockAnimationUntilAfterNextRender(),this._updateOffsetSize()}_drawerToggleClick(E){E.stopPropagation(),this.drawerOpened=!this.drawerOpened}__closeOverlayDrawer(){this.overlay&&(this.drawerOpened=!1)}__setAriaExpanded(){const E=this.querySelector("vaadin-drawer-toggle");E&&E.setAttribute("aria-expanded",this.drawerOpened)}_updateDrawerSize(){const E=this.querySelectorAll("[slot=drawer]").length,a=this.$.drawer;E===0?a.setAttribute("hidden",""):a.removeAttribute("hidden"),this._updateOffsetSize()}_resize(){this._blockAnimationUntilAfterNextRender(),this._updateTouchOptimizedMode(),this._updateOverlayMode()}_updateOffsetSize(){const a=this.$.navbarTop.getBoundingClientRect(),tt=this.$.navbarBottom.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-navbar-offset-size",`${a.height}px`),this.style.setProperty("--_vaadin-app-layout-navbar-offset-size-bottom",`${tt.height}px`);const rt=this.$.drawer.getBoundingClientRect();this.style.setProperty("--_vaadin-app-layout-drawer-offset-size",`${rt.width}px`)}_updateOverlayMode(){const E=this._getCustomPropertyValue("--vaadin-app-layout-drawer-overlay")==="true";!this.overlay&&E&&(this._drawerStateSaved=this.drawerOpened,this.drawerOpened=!1),this._setOverlay(E),!this.overlay&&this._drawerStateSaved&&(this.drawerOpened=this._drawerStateSaved,this._drawerStateSaved=null),this.__updateDrawerAriaAttributes()}__updateDrawerAriaAttributes(){const E=this.$.drawer;this.overlay?(E.setAttribute("role","dialog"),E.setAttribute("aria-modal","true"),E.setAttribute("aria-label",this.i18n.drawer)):(E.removeAttribute("role"),E.removeAttribute("aria-modal"),E.removeAttribute("aria-label"))}__drawerTransitionComplete(){return new Promise(E=>{if(this._getCustomPropertyValue("--vaadin-app-layout-transition")==="none"){E();return}this.$.drawer.addEventListener("transitionend",E,{once:!0})})}async __trapFocusInDrawer(){await this.__drawerTransitionComplete(),this.drawerOpened&&(this.$.drawer.setAttribute("tabindex","0"),this.__focusTrapController.trapFocus(this.$.drawer))}async __releaseFocusFromDrawer(){if(await this.__drawerTransitionComplete(),this.drawerOpened)return;this.__focusTrapController.releaseFocus(),this.$.drawer.removeAttribute("tabindex");const E=this.querySelector("vaadin-drawer-toggle");E&&(E.focus(),E.setAttribute("focus-ring","focus"))}__onDrawerKeyDown(E){E.key==="Escape"&&this.overlay&&(this.drawerOpened=!1)}_closeDrawerOnChanged(E,a){a&&window.removeEventListener(a,this.__closeOverlayDrawerListener),E&&window.addEventListener(E,this.__closeOverlayDrawerListener)}_onBackdropClick(){this._close()}_onBackdropTouchend(E){E.preventDefault(),this._close()}_close(){this.drawerOpened=!1}_getCustomPropertyValue(E){return(getComputedStyle(this).getPropertyValue(E)||"").trim().toLowerCase()}_updateTouchOptimizedMode(){const E=this._getCustomPropertyValue("--vaadin-app-layout-touch-optimized")==="true",a=this.querySelectorAll('[slot*="navbar"]');a.length>0&&Array.from(a).forEach(k=>{k.getAttribute("slot").indexOf("touch-optimized")>-1&&(k.__touchOptimized=!0),E&&k.__touchOptimized?k.setAttribute("slot","navbar-bottom"):k.setAttribute("slot","navbar")}),this.$.navbarTop.querySelector("[name=navbar]").assignedNodes().length===0?this.$.navbarTop.setAttribute("hidden",""):this.$.navbarTop.removeAttribute("hidden"),E?this.$.navbarBottom.removeAttribute("hidden"):this.$.navbarBottom.setAttribute("hidden",""),this._updateOffsetSize()}_blockAnimationUntilAfterNextRender(){this.setAttribute("no-anim",""),afterNextRender(this,()=>{this.removeAttribute("no-anim")})}}customElements.define(AppLayout.is,AppLayout);const button=i$2`
  :host {
    /* Sizing */
    --lumo-button-size: var(--lumo-size-m);
    min-width: calc(var(--lumo-button-size) * 2);
    height: var(--lumo-button-size);
    padding: 0 calc(var(--lumo-button-size) / 3 + var(--lumo-border-radius-m) / 2);
    margin: var(--lumo-space-xs) 0;
    box-sizing: border-box;
    /* Style */
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 500;
    color: var(--_lumo-button-color, var(--lumo-primary-text-color));
    background-color: var(--_lumo-button-background-color, var(--lumo-contrast-5pct));
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-tap-highlight-color: transparent;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    flex-shrink: 0;
  }

  /* Set only for the internal parts so we don't affect the host vertical alignment */
  [part='label'],
  [part='prefix'],
  [part='suffix'] {
    line-height: var(--lumo-line-height-xs);
  }

  [part='label'] {
    padding: calc(var(--lumo-button-size) / 6) 0;
  }

  :host([theme~='small']) {
    font-size: var(--lumo-font-size-s);
    --lumo-button-size: var(--lumo-size-s);
  }

  :host([theme~='large']) {
    font-size: var(--lumo-font-size-l);
    --lumo-button-size: var(--lumo-size-l);
  }

  /* For interaction states */
  :host::before,
  :host::after {
    content: '';
    /* We rely on the host always being relative */
    position: absolute;
    z-index: 1;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    background-color: currentColor;
    border-radius: inherit;
    opacity: 0;
    pointer-events: none;
  }

  /* Hover */

  @media (any-hover: hover) {
    :host(:hover)::before {
      opacity: 0.02;
    }
  }

  /* Active */

  :host::after {
    transition: opacity 1.4s, transform 0.1s;
    filter: blur(8px);
  }

  :host([active])::before {
    opacity: 0.05;
    transition-duration: 0s;
  }

  :host([active])::after {
    opacity: 0.1;
    transition-duration: 0s, 0s;
    transform: scale(0);
  }

  /* Keyboard focus */

  :host([focus-ring]) {
    box-shadow: 0 0 0 2px var(--lumo-primary-color-50pct);
  }

  :host([theme~='primary'][focus-ring]) {
    box-shadow: 0 0 0 1px var(--lumo-base-color), 0 0 0 3px var(--lumo-primary-color-50pct);
  }

  /* Types (primary, tertiary, tertiary-inline */

  :host([theme~='tertiary']),
  :host([theme~='tertiary-inline']) {
    background-color: transparent !important;
    min-width: 0;
  }

  :host([theme~='tertiary']) {
    padding: 0 calc(var(--lumo-button-size) / 6);
  }

  :host([theme~='tertiary-inline'])::before {
    display: none;
  }

  :host([theme~='tertiary-inline']) {
    margin: 0;
    height: auto;
    padding: 0;
    line-height: inherit;
    font-size: inherit;
  }

  :host([theme~='tertiary-inline']) [part='label'] {
    padding: 0;
    overflow: visible;
    line-height: inherit;
  }

  :host([theme~='primary']) {
    background-color: var(--_lumo-button-primary-background-color, var(--lumo-primary-color));
    color: var(--_lumo-button-primary-color, var(--lumo-primary-contrast-color));
    font-weight: 600;
    min-width: calc(var(--lumo-button-size) * 2.5);
  }

  :host([theme~='primary'])::before {
    background-color: black;
  }

  @media (any-hover: hover) {
    :host([theme~='primary']:hover)::before {
      opacity: 0.05;
    }
  }

  :host([theme~='primary'][active])::before {
    opacity: 0.1;
  }

  :host([theme~='primary'][active])::after {
    opacity: 0.2;
  }

  /* Colors (success, error, contrast) */

  :host([theme~='success']) {
    color: var(--lumo-success-text-color);
  }

  :host([theme~='success'][theme~='primary']) {
    background-color: var(--lumo-success-color);
    color: var(--lumo-success-contrast-color);
  }

  :host([theme~='error']) {
    color: var(--lumo-error-text-color);
  }

  :host([theme~='error'][theme~='primary']) {
    background-color: var(--lumo-error-color);
    color: var(--lumo-error-contrast-color);
  }

  :host([theme~='contrast']) {
    color: var(--lumo-contrast);
  }

  :host([theme~='contrast'][theme~='primary']) {
    background-color: var(--lumo-contrast);
    color: var(--lumo-base-color);
  }

  /* Disabled state. Keep selectors after other color variants. */

  :host([disabled]) {
    pointer-events: none;
    color: var(--lumo-disabled-text-color);
  }

  :host([theme~='primary'][disabled]) {
    background-color: var(--lumo-contrast-30pct);
    color: var(--lumo-base-color);
  }

  :host([theme~='primary'][disabled]) [part] {
    opacity: 0.7;
  }

  /* Icons */

  [part] ::slotted(vaadin-icon) {
    display: inline-block;
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }

  /* Vaadin icons are based on a 16x16 grid (unlike Lumo and Material icons with 24x24), so they look too big by default */
  [part] ::slotted(vaadin-icon[icon^='vaadin:']) {
    padding: 0.25em;
    box-sizing: border-box !important;
  }

  [part='prefix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  [part='suffix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  /* Icon-only */

  :host([theme~='icon']:not([theme~='tertiary-inline'])) {
    min-width: var(--lumo-button-size);
    padding-left: calc(var(--lumo-button-size) / 4);
    padding-right: calc(var(--lumo-button-size) / 4);
  }

  :host([theme~='icon']) [part='prefix'],
  :host([theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }

  /* RTL specific styles */

  :host([dir='rtl']) [part='prefix'] {
    margin-left: 0.25em;
    margin-right: -0.25em;
  }

  :host([dir='rtl']) [part='suffix'] {
    margin-left: -0.25em;
    margin-right: 0.25em;
  }

  :host([dir='rtl'][theme~='icon']) [part='prefix'],
  :host([dir='rtl'][theme~='icon']) [part='suffix'] {
    margin-left: 0;
    margin-right: 0;
  }
`;registerStyles$1("vaadin-button",button,{moduleId:"lumo-button"});const drawerToggle=i$2`
  :host {
    width: var(--lumo-size-l);
    height: var(--lumo-size-l);
    min-width: auto;
    margin: 0 var(--lumo-space-s);
    padding: 0;
    background: transparent;
  }

  [part='icon'],
  [part='icon']::after,
  [part='icon']::before {
    position: inherit;
    height: auto;
    width: auto;
    background: transparent;
    top: auto;
  }

  [part='icon']::before {
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    content: var(--lumo-icons-menu);
  }

  :host([slot~='navbar']) {
    color: var(--lumo-secondary-text-color);
  }
`;registerStyles$1("vaadin-drawer-toggle",[button,drawerToggle],{moduleId:"lumo-drawer-toggle"});/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const buttonStyles=i$2`
  :host {
    display: inline-block;
    position: relative;
    outline: none;
    white-space: nowrap;
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none;
  }

  :host([hidden]) {
    display: none !important;
  }

  /* Aligns the button with form fields when placed on the same line.
  Note, to make it work, the form fields should have the same "::before" pseudo-element. */
  .vaadin-button-container::before {
    content: '\\2003';
    display: inline-block;
    width: 0;
    max-height: 100%;
  }

  .vaadin-button-container {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    width: 100%;
    height: 100%;
    min-height: inherit;
    text-shadow: inherit;
  }

  [part='prefix'],
  [part='suffix'] {
    flex: none;
  }

  [part='label'] {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
`,buttonTemplate=j=>j`
  <div class="vaadin-button-container">
    <span part="prefix" aria-hidden="true">
      <slot name="prefix"></slot>
    </span>
    <span part="label">
      <slot></slot>
    </span>
    <span part="suffix" aria-hidden="true">
      <slot name="suffix"></slot>
    </span>
  </div>
  <slot name="tooltip"></slot>
`;/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ButtonMixin=j=>class extends ActiveMixin(TabindexMixin(FocusMixin(j))){static get properties(){return{tabindex:{type:Number,value:0,reflectToAttribute:!0}}}get _activeKeys(){return["Enter"," "]}ready(){super.ready(),this.hasAttribute("role")||this.setAttribute("role","button")}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-button",buttonStyles,{moduleId:"vaadin-button-styles"});class Button extends ButtonMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-button"}static get template(){return buttonTemplate(html)}ready(){super.ready(),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController)}}customElements.define(Button.is,Button);/**
 * @license
 * Copyright (c) 2018 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-drawer-toggle",i$2`
    :host {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      cursor: default;
      position: relative;
      outline: none;
      height: 24px;
      width: 24px;
      padding: 4px;
    }

    [part='icon'],
    [part='icon']::after,
    [part='icon']::before {
      position: absolute;
      top: 8px;
      height: 3px;
      width: 24px;
      background-color: #000;
    }

    [part='icon']::after,
    [part='icon']::before {
      content: '';
    }

    [part='icon']::after {
      top: 6px;
    }

    [part='icon']::before {
      top: 12px;
    }
  `,{moduleId:"vaadin-drawer-toggle-styles"});class DrawerToggle extends Button{static get template(){return html`
      <slot id="slot">
        <div part="icon"></div>
      </slot>
      <div part="icon" hidden$="[[!_showFallbackIcon]]"></div>
      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-drawer-toggle"}static get properties(){return{ariaLabel:{type:String,value:"Toggle navigation panel",reflectToAttribute:!0},_showFallbackIcon:{type:Boolean,value:!1}}}constructor(){super(),this.addEventListener("click",()=>{this.dispatchEvent(new CustomEvent("drawer-toggle-click",{bubbles:!0,composed:!0}))})}ready(){super.ready(),this._observer=new FlattenedNodesObserver(this,()=>{this._toggleFallbackIcon()})}_toggleFallbackIcon(){const E=this.$.slot.assignedNodes();this._showFallbackIcon=E.length>0&&E.every(a=>isEmptyTextNode(a))}}customElements.define(DrawerToggle.is,DrawerToggle);/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const overlay=i$2`
  :host {
    top: var(--lumo-space-m);
    right: var(--lumo-space-m);
    bottom: var(--lumo-space-m);
    left: var(--lumo-space-m);
    /* Workaround for Edge issue (only on Surface), where an overflowing vaadin-list-box inside vaadin-select-overlay makes the overlay transparent */
    /* stylelint-disable-next-line */
    outline: 0px solid transparent;
  }

  [part='overlay'] {
    background-color: var(--lumo-base-color);
    background-image: linear-gradient(var(--lumo-tint-5pct), var(--lumo-tint-5pct));
    border-radius: var(--lumo-border-radius-m);
    box-shadow: 0 0 0 1px var(--lumo-shade-5pct), var(--lumo-box-shadow-m);
    color: var(--lumo-body-text-color);
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    font-weight: 400;
    line-height: var(--lumo-line-height-m);
    letter-spacing: 0;
    text-transform: none;
    -webkit-text-size-adjust: 100%;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
  }

  [part='content'] {
    padding: var(--lumo-space-xs);
  }

  [part='backdrop'] {
    background-color: var(--lumo-shade-20pct);
    animation: 0.2s lumo-overlay-backdrop-enter both;
    will-change: opacity;
  }

  @keyframes lumo-overlay-backdrop-enter {
    0% {
      opacity: 0;
    }
  }

  :host([closing]) [part='backdrop'] {
    animation: 0.2s lumo-overlay-backdrop-exit both;
  }

  @keyframes lumo-overlay-backdrop-exit {
    100% {
      opacity: 0;
    }
  }

  @keyframes lumo-overlay-dummy-animation {
    0% {
      opacity: 1;
    }

    100% {
      opacity: 1;
    }
  }
`;registerStyles$1("",overlay,{moduleId:"lumo-overlay"});registerStyles$1("vaadin-overlay",overlay,{moduleId:"lumo-vaadin-overlay"});/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Overlay extends ThemableMixin(DirMixin(ControllerMixin(PolymerElement))){static get template(){return html`
      <style>
        :host {
          z-index: 200;
          position: fixed;

          /* Despite of what the names say, <vaadin-overlay> is just a container
          for position/sizing/alignment. The actual overlay is the overlay part. */

          /* Default position constraints: the entire viewport. Note: themes can
          override this to introduce gaps between the overlay and the viewport. */
          top: 0;
          right: 0;
          bottom: var(--vaadin-overlay-viewport-bottom);
          left: 0;

          /* Use flexbox alignment for the overlay part. */
          display: flex;
          flex-direction: column; /* makes dropdowns sizing easier */
          /* Align to center by default. */
          align-items: center;
          justify-content: center;

          /* Allow centering when max-width/max-height applies. */
          margin: auto;

          /* The host is not clickable, only the overlay part is. */
          pointer-events: none;

          /* Remove tap highlight on touch devices. */
          -webkit-tap-highlight-color: transparent;

          /* CSS API for host */
          --vaadin-overlay-viewport-bottom: 0;
        }

        :host([hidden]),
        :host(:not([opened]):not([closing])) {
          display: none !important;
        }

        [part='overlay'] {
          -webkit-overflow-scrolling: touch;
          overflow: auto;
          pointer-events: auto;

          /* Prevent overflowing the host in MSIE 11 */
          max-width: 100%;
          box-sizing: border-box;

          -webkit-tap-highlight-color: initial; /* reenable tap highlight inside */
        }

        [part='backdrop'] {
          z-index: -1;
          content: '';
          background: rgba(0, 0, 0, 0.5);
          position: fixed;
          top: 0;
          left: 0;
          bottom: 0;
          right: 0;
          pointer-events: auto;
        }
      </style>

      <div id="backdrop" part="backdrop" hidden$="[[!withBackdrop]]"></div>
      <div part="overlay" id="overlay" tabindex="0">
        <div part="content" id="content">
          <slot></slot>
        </div>
      </div>
    `}static get is(){return"vaadin-overlay"}static get properties(){return{opened:{type:Boolean,notify:!0,observer:"_openedChanged",reflectToAttribute:!0},owner:Element,renderer:Function,withBackdrop:{type:Boolean,value:!1,reflectToAttribute:!0},model:Object,modeless:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_modelessChanged"},hidden:{type:Boolean,reflectToAttribute:!0,observer:"_hiddenChanged"},focusTrap:{type:Boolean,value:!1},restoreFocusOnClose:{type:Boolean,value:!1},restoreFocusNode:{type:HTMLElement},_mouseDownInside:{type:Boolean},_mouseUpInside:{type:Boolean},_oldOwner:Element,_oldModel:Object,_oldRenderer:Object,_oldOpened:Boolean}}static get observers(){return["_rendererOrDataChanged(renderer, owner, model, opened)"]}static get __attachedInstances(){return Array.from(document.body.children).filter(E=>E instanceof Overlay&&!E.hasAttribute("closing")).sort((E,a)=>E.__zIndex-a.__zIndex||0)}constructor(){super(),this._boundMouseDownListener=this._mouseDownListener.bind(this),this._boundMouseUpListener=this._mouseUpListener.bind(this),this._boundOutsideClickListener=this._outsideClickListener.bind(this),this._boundKeydownListener=this._keydownListener.bind(this),isIOS&&(this._boundIosResizeListener=()=>this._detectIosNavbar()),this.__focusTrapController=new FocusTrapController(this)}get _last(){return this===Overlay.__attachedInstances.pop()}ready(){super.ready(),this.addEventListener("click",()=>{}),this.$.backdrop.addEventListener("click",()=>{}),this.addController(this.__focusTrapController),processTemplates(this)}_detectIosNavbar(){if(!this.opened)return;const E=window.innerHeight,k=window.innerWidth>E,tt=document.documentElement.clientHeight;k&&tt>E?this.style.setProperty("--vaadin-overlay-viewport-bottom",`${tt-E}px`):this.style.setProperty("--vaadin-overlay-viewport-bottom","0")}close(E){const a=new CustomEvent("vaadin-overlay-close",{bubbles:!0,cancelable:!0,detail:{sourceEvent:E}});this.dispatchEvent(a),a.defaultPrevented||(this.opened=!1)}connectedCallback(){super.connectedCallback(),this._boundIosResizeListener&&(this._detectIosNavbar(),window.addEventListener("resize",this._boundIosResizeListener))}disconnectedCallback(){super.disconnectedCallback(),this._boundIosResizeListener&&window.removeEventListener("resize",this._boundIosResizeListener)}requestContentUpdate(){this.renderer&&this.renderer.call(this.owner,this,this.owner,this.model)}_mouseDownListener(E){this._mouseDownInside=E.composedPath().indexOf(this.$.overlay)>=0}_mouseUpListener(E){this._mouseUpInside=E.composedPath().indexOf(this.$.overlay)>=0}_shouldCloseOnOutsideClick(E){return this._last}_outsideClickListener(E){if(E.composedPath().includes(this.$.overlay)||this._mouseDownInside||this._mouseUpInside){this._mouseDownInside=!1,this._mouseUpInside=!1;return}if(!this._shouldCloseOnOutsideClick(E))return;const a=new CustomEvent("vaadin-overlay-outside-click",{bubbles:!0,cancelable:!0,detail:{sourceEvent:E}});this.dispatchEvent(a),this.opened&&!a.defaultPrevented&&this.close(E)}_keydownListener(E){if(this._last&&!(this.modeless&&!E.composedPath().includes(this.$.overlay))&&E.key==="Escape"){const a=new CustomEvent("vaadin-overlay-escape-press",{bubbles:!0,cancelable:!0,detail:{sourceEvent:E}});this.dispatchEvent(a),this.opened&&!a.defaultPrevented&&this.close(E)}}_openedChanged(E,a){E?(this.__restoreFocusNode=this._getActiveElement(),this._animatedOpening(),afterNextRender(this,()=>{this.focusTrap&&this.__focusTrapController.trapFocus(this.$.overlay);const k=new CustomEvent("vaadin-overlay-open",{bubbles:!0});this.dispatchEvent(k)}),document.addEventListener("keydown",this._boundKeydownListener),this.modeless||this._addGlobalListeners()):a&&(this.focusTrap&&this.__focusTrapController.releaseFocus(),this._animatedClosing(),document.removeEventListener("keydown",this._boundKeydownListener),this.modeless||this._removeGlobalListeners())}_hiddenChanged(E){E&&this.hasAttribute("closing")&&this._flushAnimation("closing")}_shouldAnimate(){const E=getComputedStyle(this),a=E.getPropertyValue("animation-name");return!(E.getPropertyValue("display")==="none")&&a&&a!=="none"}_enqueueAnimation(E,a){const k=`__${E}Handler`,tt=et=>{et&&et.target!==this||(a(),this.removeEventListener("animationend",tt),delete this[k])};this[k]=tt,this.addEventListener("animationend",tt)}_flushAnimation(E){const a=`__${E}Handler`;typeof this[a]=="function"&&this[a]()}_animatedOpening(){this.parentNode===document.body&&this.hasAttribute("closing")&&this._flushAnimation("closing"),this._attachOverlay(),this.modeless||this._enterModalState(),this.setAttribute("opening",""),this._shouldAnimate()?this._enqueueAnimation("opening",()=>{this._finishOpening()}):this._finishOpening()}_attachOverlay(){this._placeholder=document.createComment("vaadin-overlay-placeholder"),this.parentNode.insertBefore(this._placeholder,this),document.body.appendChild(this),this.bringToFront()}_finishOpening(){this.removeAttribute("opening")}_finishClosing(){this._detachOverlay(),this.$.overlay.style.removeProperty("pointer-events"),this.removeAttribute("closing"),this.dispatchEvent(new CustomEvent("vaadin-overlay-closed"))}_animatedClosing(){if(this.hasAttribute("opening")&&this._flushAnimation("opening"),this._placeholder){this._exitModalState();const E=this.restoreFocusNode||this.__restoreFocusNode;if(this.restoreFocusOnClose&&E){const a=this._getActiveElement();(a===document.body||this._deepContains(a))&&setTimeout(()=>E.focus()),this.__restoreFocusNode=null}this.setAttribute("closing",""),this.dispatchEvent(new CustomEvent("vaadin-overlay-closing")),this._shouldAnimate()?this._enqueueAnimation("closing",()=>{this._finishClosing()}):this._finishClosing()}}_detachOverlay(){this._placeholder.parentNode.insertBefore(this,this._placeholder),this._placeholder.parentNode.removeChild(this._placeholder)}_modelessChanged(E){E?(this._removeGlobalListeners(),this._exitModalState()):this.opened&&(this._addGlobalListeners(),this._enterModalState())}_addGlobalListeners(){document.addEventListener("mousedown",this._boundMouseDownListener),document.addEventListener("mouseup",this._boundMouseUpListener),document.documentElement.addEventListener("click",this._boundOutsideClickListener,!0)}_enterModalState(){document.body.style.pointerEvents!=="none"&&(this._previousDocumentPointerEvents=document.body.style.pointerEvents,document.body.style.pointerEvents="none"),Overlay.__attachedInstances.forEach(E=>{E!==this&&(E.shadowRoot.querySelector('[part="overlay"]').style.pointerEvents="none")})}_removeGlobalListeners(){document.removeEventListener("mousedown",this._boundMouseDownListener),document.removeEventListener("mouseup",this._boundMouseUpListener),document.documentElement.removeEventListener("click",this._boundOutsideClickListener,!0)}_exitModalState(){this._previousDocumentPointerEvents!==void 0&&(document.body.style.pointerEvents=this._previousDocumentPointerEvents,delete this._previousDocumentPointerEvents);const E=Overlay.__attachedInstances;let a;for(;(a=E.pop())&&!(a!==this&&(a.shadowRoot.querySelector('[part="overlay"]').style.removeProperty("pointer-events"),!a.modeless)););}_rendererOrDataChanged(E,a,k,tt){const et=this._oldOwner!==a||this._oldModel!==k;this._oldModel=k,this._oldOwner=a;const rt=this._oldRenderer!==E;this._oldRenderer=E;const nt=this._oldOpened!==tt;this._oldOpened=tt,rt&&(this.innerHTML="",delete this._$litPart$),tt&&E&&(rt||nt||et)&&this.requestContentUpdate()}_getActiveElement(){let E=document.activeElement||document.body;for(;E.shadowRoot&&E.shadowRoot.activeElement;)E=E.shadowRoot.activeElement;return E}_deepContains(E){if(this.contains(E))return!0;let a=E;const k=E.ownerDocument;for(;a&&a!==k&&a!==this;)a=a.parentNode||a.host;return a===this}bringToFront(){let E="";const a=Overlay.__attachedInstances.filter(k=>k!==this).pop();a&&(E=a.__zIndex+1),this.style.zIndex=E,this.__zIndex=E||parseFloat(getComputedStyle(this).zIndex)}}customElements.define(Overlay.is,Overlay);const tooltipOverlay=i$2`
  :host {
    --vaadin-tooltip-offset-top: var(--lumo-space-xs);
    --vaadin-tooltip-offset-bottom: var(--lumo-space-xs);
    --vaadin-tooltip-offset-start: var(--lumo-space-xs);
    --vaadin-tooltip-offset-end: var(--lumo-space-xs);
  }

  [part='overlay'] {
    background: var(--lumo-base-color) linear-gradient(var(--lumo-contrast-5pct), var(--lumo-contrast-5pct));
    color: var(--lumo-body-text-color);
    font-size: var(--lumo-font-size-xs);
    line-height: var(--lumo-line-height-s);
  }

  [part='content'] {
    padding: var(--lumo-space-xs) var(--lumo-space-s);
  }
`;registerStyles$1("vaadin-tooltip-overlay",[overlay,tooltipOverlay],{moduleId:"lumo-tooltip-overlay"});/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const PROP_NAMES_VERTICAL={start:"top",end:"bottom"},PROP_NAMES_HORIZONTAL={start:"left",end:"right"},targetResizeObserver=new ResizeObserver(j=>{setTimeout(()=>{j.forEach(E=>{E.target.__overlay&&E.target.__overlay._updatePosition()})})}),PositionMixin=j=>class extends j{static get properties(){return{positionTarget:{type:Object,value:null},horizontalAlign:{type:String,value:"start"},verticalAlign:{type:String,value:"top"},noHorizontalOverlap:{type:Boolean,value:!1},noVerticalOverlap:{type:Boolean,value:!1},requiredVerticalSpace:{type:Number,value:0}}}static get observers(){return["__positionSettingsChanged(horizontalAlign, verticalAlign, noHorizontalOverlap, noVerticalOverlap, requiredVerticalSpace)","__overlayOpenedChanged(opened, positionTarget)"]}constructor(){super(),this.__onScroll=this.__onScroll.bind(this),this._updatePosition=this._updatePosition.bind(this)}connectedCallback(){super.connectedCallback(),this.opened&&this.__addUpdatePositionEventListeners()}disconnectedCallback(){super.disconnectedCallback(),this.__removeUpdatePositionEventListeners()}__addUpdatePositionEventListeners(){window.addEventListener("resize",this._updatePosition),this.__positionTargetAncestorRootNodes=getAncestorRootNodes(this.positionTarget),this.__positionTargetAncestorRootNodes.forEach(a=>{a.addEventListener("scroll",this.__onScroll,!0)})}__removeUpdatePositionEventListeners(){window.removeEventListener("resize",this._updatePosition),this.__positionTargetAncestorRootNodes&&(this.__positionTargetAncestorRootNodes.forEach(a=>{a.removeEventListener("scroll",this.__onScroll,!0)}),this.__positionTargetAncestorRootNodes=null)}__overlayOpenedChanged(a,k){if(this.__removeUpdatePositionEventListeners(),k&&(k.__overlay=null,targetResizeObserver.unobserve(k),a&&(this.__addUpdatePositionEventListeners(),k.__overlay=this,targetResizeObserver.observe(k))),a){const tt=getComputedStyle(this);this.__margins||(this.__margins={},["top","bottom","left","right"].forEach(et=>{this.__margins[et]=parseInt(tt[et],10)})),this.setAttribute("dir",tt.direction),this._updatePosition(),requestAnimationFrame(()=>this._updatePosition())}}__positionSettingsChanged(){this._updatePosition()}__onScroll(a){this.contains(a.target)||this._updatePosition()}_updatePosition(){if(!this.positionTarget||!this.opened)return;const a=this.positionTarget.getBoundingClientRect(),k=this.__shouldAlignStartVertically(a);this.style.justifyContent=k?"flex-start":"flex-end";const tt=this.__isRTL,et=this.__shouldAlignStartHorizontally(a,tt),rt=!tt&&et||tt&&!et;this.style.alignItems=rt?"flex-start":"flex-end";const nt=this.getBoundingClientRect(),ot=this.__calculatePositionInOneDimension(a,nt,this.noVerticalOverlap,PROP_NAMES_VERTICAL,this,k),st=this.__calculatePositionInOneDimension(a,nt,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL,this,et);Object.assign(this.style,ot,st),this.toggleAttribute("bottom-aligned",!k),this.toggleAttribute("top-aligned",k),this.toggleAttribute("end-aligned",!rt),this.toggleAttribute("start-aligned",rt)}__shouldAlignStartHorizontally(a,k){const tt=Math.max(this.__oldContentWidth||0,this.$.overlay.offsetWidth);this.__oldContentWidth=this.$.overlay.offsetWidth;const et=Math.min(window.innerWidth,document.documentElement.clientWidth),rt=!k&&this.horizontalAlign==="start"||k&&this.horizontalAlign==="end";return this.__shouldAlignStart(a,tt,et,this.__margins,rt,this.noHorizontalOverlap,PROP_NAMES_HORIZONTAL)}__shouldAlignStartVertically(a){const k=this.requiredVerticalSpace||Math.max(this.__oldContentHeight||0,this.$.overlay.offsetHeight);this.__oldContentHeight=this.$.overlay.offsetHeight;const tt=Math.min(window.innerHeight,document.documentElement.clientHeight),et=this.verticalAlign==="top";return this.__shouldAlignStart(a,k,tt,this.__margins,et,this.noVerticalOverlap,PROP_NAMES_VERTICAL)}__shouldAlignStart(a,k,tt,et,rt,nt,ot){const st=tt-a[nt?ot.end:ot.start]-et[ot.end],lt=a[nt?ot.start:ot.end]-et[ot.start],ht=rt?st:lt,dt=ht>(rt?lt:st)||ht>k;return rt===dt}__adjustBottomProperty(a,k,tt){let et;if(a===k.end){if(k.end===PROP_NAMES_VERTICAL.end){const rt=Math.min(window.innerHeight,document.documentElement.clientHeight);if(tt>rt&&this.__oldViewportHeight){const nt=this.__oldViewportHeight-rt;et=tt-nt}this.__oldViewportHeight=rt}if(k.end===PROP_NAMES_HORIZONTAL.end){const rt=Math.min(window.innerWidth,document.documentElement.clientWidth);if(tt>rt&&this.__oldViewportWidth){const nt=this.__oldViewportWidth-rt;et=tt-nt}this.__oldViewportWidth=rt}}return et}__calculatePositionInOneDimension(a,k,tt,et,rt,nt){const ot=nt?et.start:et.end,st=nt?et.end:et.start,lt=parseFloat(rt.style[ot]||getComputedStyle(rt)[ot]),ht=this.__adjustBottomProperty(ot,et,lt),ut=k[nt?et.start:et.end]-a[tt===nt?et.end:et.start],dt=ht?`${ht}px`:`${lt+ut*(nt?-1:1)}px`;return{[ot]:dt,[st]:""}}};/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */registerStyles$1("vaadin-tooltip-overlay",i$2`
    [part='overlay'] {
      max-width: 40ch;
    }

    :host([position^='top'][top-aligned]) [part='overlay'],
    :host([position^='bottom'][top-aligned]) [part='overlay'] {
      margin-top: var(--vaadin-tooltip-offset-top, 0);
    }

    :host([position^='top'][bottom-aligned]) [part='overlay'],
    :host([position^='bottom'][bottom-aligned]) [part='overlay'] {
      margin-bottom: var(--vaadin-tooltip-offset-bottom, 0);
    }

    :host([position^='start'][start-aligned]) [part='overlay'],
    :host([position^='end'][start-aligned]) [part='overlay'] {
      margin-inline-start: var(--vaadin-tooltip-offset-start, 0);
    }

    :host([position^='start'][end-aligned]) [part='overlay'],
    :host([position^='end'][end-aligned]) [part='overlay'] {
      margin-inline-end: var(--vaadin-tooltip-offset-end, 0);
    }
  `,{moduleId:"vaadin-tooltip-overlay-styles"});let memoizedTemplate$c;class TooltipOverlay extends PositionMixin(Overlay){static get is(){return"vaadin-tooltip-overlay"}static get template(){return memoizedTemplate$c||(memoizedTemplate$c=super.template.cloneNode(!0),memoizedTemplate$c.content.querySelector('[part~="overlay"]').removeAttribute("tabindex"),memoizedTemplate$c.content.querySelector('[part~="content"]').innerHTML="<slot></slot>"),memoizedTemplate$c}static get properties(){return{position:{type:String,reflectToAttribute:!0}}}ready(){super.ready(),this.owner=this.__dataHost,this.owner._overlayElement=this}requestContentUpdate(){if(super.requestContentUpdate(),this.toggleAttribute("hidden",this.textContent.trim()===""),this.positionTarget&&this.owner){const E=getComputedStyle(this.owner);["top","bottom","start","end"].forEach(a=>{this.style.setProperty(`--vaadin-tooltip-offset-${a}`,E.getPropertyValue(`--vaadin-tooltip-offset-${a}`))})}}_updatePosition(){if(super._updatePosition(),!!this.positionTarget){if(this.position==="bottom"||this.position==="top"){const E=this.positionTarget.getBoundingClientRect(),a=this.$.overlay.getBoundingClientRect(),k=E.width/2-a.width/2;if(this.style.left){const tt=a.left+k;tt>0&&(this.style.left=`${tt}px`)}if(this.style.right){const tt=parseFloat(this.style.right)+k;tt>0&&(this.style.right=`${tt}px`)}}if(this.position==="start"||this.position==="end"){const E=this.positionTarget.getBoundingClientRect(),a=this.$.overlay.getBoundingClientRect(),k=E.height/2-a.height/2;this.style.top=`${a.top+k}px`}}}}customElements.define(TooltipOverlay.is,TooltipOverlay);/**
 * @license
 * Copyright (c) 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const OverlayClassMixin=j=>class extends j{static get properties(){return{overlayClass:{type:String},_overlayElement:{type:Object}}}static get observers(){return["__updateOverlayClassNames(overlayClass, _overlayElement)"]}__updateOverlayClassNames(a,k){if(!k||a===void 0)return;const{classList:tt}=k;if(this.__initialClasses||(this.__initialClasses=new Set(tt)),Array.isArray(this.__previousClasses)){const rt=this.__previousClasses.filter(nt=>!this.__initialClasses.has(nt));rt.length>0&&tt.remove(...rt)}const et=typeof a=="string"?a.split(" "):[];et.length>0&&tt.add(...et),this.__previousClasses=et}};/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const DEFAULT_DELAY=500;let defaultFocusDelay=DEFAULT_DELAY,defaultHoverDelay=DEFAULT_DELAY,defaultHideDelay=DEFAULT_DELAY;const closing=new Set;let warmedUp=!1,warmUpTimeout=null,cooldownTimeout=null;class TooltipStateController{constructor(E){this.host=E}get openedProp(){return this.host.manual?"opened":"_autoOpened"}get focusDelay(){const E=this.host;return E.focusDelay!=null&&E.focusDelay>0?E.focusDelay:defaultFocusDelay}get hoverDelay(){const E=this.host;return E.hoverDelay!=null&&E.hoverDelay>0?E.hoverDelay:defaultHoverDelay}get hideDelay(){const E=this.host;return E.hideDelay!=null&&E.hideDelay>0?E.hideDelay:defaultHideDelay}open(E={immediate:!1}){const{immediate:a,hover:k,focus:tt}=E,et=k&&this.hoverDelay>0,rt=tt&&this.focusDelay>0;!a&&(et||rt)&&!this.__closeTimeout?this.__warmupTooltip(rt):this.__showTooltip()}close(E){!E&&this.hideDelay>0?this.__scheduleClose():(this.__abortClose(),this._setOpened(!1)),this.__abortWarmUp(),warmedUp&&(this.__abortCooldown(),this.__scheduleCooldown())}_isOpened(){return this.host[this.openedProp]}_setOpened(E){this.host[this.openedProp]=E}__flushClosingTooltips(){closing.forEach(E=>{E._stateController.close(!0),closing.delete(E)})}__showTooltip(){this.__abortClose(),this.__flushClosingTooltips(),this._setOpened(!0),warmedUp=!0,this.__abortWarmUp(),this.__abortCooldown()}__warmupTooltip(E){this._isOpened()||(warmedUp?this.__showTooltip():this.__scheduleWarmUp(E))}__abortClose(){this.__closeTimeout&&(clearTimeout(this.__closeTimeout),this.__closeTimeout=null)}__abortCooldown(){cooldownTimeout&&(clearTimeout(cooldownTimeout),cooldownTimeout=null)}__abortWarmUp(){warmUpTimeout&&(clearTimeout(warmUpTimeout),warmUpTimeout=null)}__scheduleClose(){this._isOpened()&&(closing.add(this.host),this.__closeTimeout=setTimeout(()=>{closing.delete(this.host),this.__closeTimeout=null,this._setOpened(!1)},this.hideDelay))}__scheduleCooldown(){cooldownTimeout=setTimeout(()=>{cooldownTimeout=null,warmedUp=!1},this.hideDelay)}__scheduleWarmUp(E){const a=E?this.focusDelay:this.hoverDelay;warmUpTimeout=setTimeout(()=>{warmUpTimeout=null,warmedUp=!0,this.__showTooltip()},a)}}let Tooltip$1=class extends OverlayClassMixin(ThemePropertyMixin(ElementMixin(PolymerElement))){static get is(){return"vaadin-tooltip"}static get template(){return html`
      <style>
        :host {
          display: none;
        }
      </style>
      <vaadin-tooltip-overlay
        id="[[_uniqueId]]"
        role="tooltip"
        renderer="[[_renderer]]"
        theme$="[[_theme]]"
        opened="[[__computeOpened(manual, opened, _autoOpened, _isConnected)]]"
        position-target="[[target]]"
        position="[[__effectivePosition]]"
        no-horizontal-overlap$="[[__computeNoHorizontalOverlap(__effectivePosition)]]"
        no-vertical-overlap$="[[__computeNoVerticalOverlap(__effectivePosition)]]"
        horizontal-align="[[__computeHorizontalAlign(__effectivePosition)]]"
        vertical-align="[[__computeVerticalAlign(__effectivePosition)]]"
        on-mouseleave="__onOverlayMouseLeave"
        modeless
      ></vaadin-tooltip-overlay>
    `}static get properties(){return{context:{type:Object,value:()=>({})},focusDelay:{type:Number},for:{type:String,observer:"__forChanged"},hideDelay:{type:Number},hoverDelay:{type:Number},manual:{type:Boolean,value:!1},opened:{type:Boolean,value:!1},position:{type:String},shouldShow:{type:Object,value:()=>(E,a)=>!0},target:{type:Object,observer:"__targetChanged"},text:{type:String,observer:"__textChanged"},generator:{type:Object},_autoOpened:{type:Boolean,observer:"__autoOpenedChanged"},_position:{type:String,value:"bottom"},__effectivePosition:{type:String,computed:"__computePosition(position, _position)"},__isTargetHidden:{type:Boolean,value:!1},_isConnected:{type:Boolean}}}static get observers(){return["__generatorChanged(_overlayElement, generator, context)"]}static setDefaultFocusDelay(E){defaultFocusDelay=E!=null&&E>=0?E:DEFAULT_DELAY}static setDefaultHideDelay(E){defaultHideDelay=E!=null&&E>=0?E:DEFAULT_DELAY}static setDefaultHoverDelay(E){defaultHoverDelay=E!=null&&E>=0?E:DEFAULT_DELAY}constructor(){super(),this._uniqueId=`vaadin-tooltip-${generateUniqueId()}`,this._renderer=this.__tooltipRenderer.bind(this),this.__onFocusin=this.__onFocusin.bind(this),this.__onFocusout=this.__onFocusout.bind(this),this.__onMouseDown=this.__onMouseDown.bind(this),this.__onMouseEnter=this.__onMouseEnter.bind(this),this.__onMouseLeave=this.__onMouseLeave.bind(this),this.__onKeyDown=this.__onKeyDown.bind(this),this.__onOverlayOpen=this.__onOverlayOpen.bind(this),this.__targetVisibilityObserver=new IntersectionObserver(([E])=>{this.__onTargetVisibilityChange(E.isIntersecting)},{threshold:1}),this._stateController=new TooltipStateController(this)}connectedCallback(){super.connectedCallback(),this._isConnected=!0,document.body.addEventListener("vaadin-overlay-open",this.__onOverlayOpen)}disconnectedCallback(){super.disconnectedCallback(),this._autoOpened&&this._stateController.close(!0),this._isConnected=!1,document.body.removeEventListener("vaadin-overlay-open",this.__onOverlayOpen)}__computeHorizontalAlign(E){return["top-end","bottom-end","start-top","start","start-bottom"].includes(E)?"end":"start"}__computeNoHorizontalOverlap(E){return["start-top","start","start-bottom","end-top","end","end-bottom"].includes(E)}__computeNoVerticalOverlap(E){return["top-start","top-end","top","bottom-start","bottom","bottom-end"].includes(E)}__computeVerticalAlign(E){return["top-start","top-end","top","start-bottom","end-bottom"].includes(E)?"bottom":"top"}__computeOpened(E,a,k,tt){return tt&&(E?a:k)}__computePosition(E,a){return E||a}__tooltipRenderer(E){E.textContent=typeof this.generator=="function"?this.generator(this.context):this.text}__autoOpenedChanged(E,a){E?document.addEventListener("keydown",this.__onKeyDown,!0):a&&document.removeEventListener("keydown",this.__onKeyDown,!0)}__forChanged(E){if(E){const a=this.getRootNode().getElementById(E);a?this.target=a:console.warn(`No element with id="${E}" found to show tooltip.`)}}__targetChanged(E,a){a&&(a.removeEventListener("mouseenter",this.__onMouseEnter),a.removeEventListener("mouseleave",this.__onMouseLeave),a.removeEventListener("focusin",this.__onFocusin),a.removeEventListener("focusout",this.__onFocusout),a.removeEventListener("mousedown",this.__onMouseDown),this.__targetVisibilityObserver.unobserve(a),removeValueFromAttribute(a,"aria-describedby",this._uniqueId)),E&&(E.addEventListener("mouseenter",this.__onMouseEnter),E.addEventListener("mouseleave",this.__onMouseLeave),E.addEventListener("focusin",this.__onFocusin),E.addEventListener("focusout",this.__onFocusout),E.addEventListener("mousedown",this.__onMouseDown),requestAnimationFrame(()=>{this.__targetVisibilityObserver.observe(E)}),addValueToAttribute(E,"aria-describedby",this._uniqueId))}__onFocusin(E){this.manual||isKeyboardActive()&&(this.target.contains(E.relatedTarget)||this.__isShouldShow()&&(this.__focusInside=!0,!this.__isTargetHidden&&(!this.__hoverInside||!this._autoOpened)&&this._stateController.open({focus:!0})))}__onFocusout(E){this.manual||this.target.contains(E.relatedTarget)||(this.__focusInside=!1,this.__hoverInside||this._stateController.close(!0))}__onKeyDown(E){E.key==="Escape"&&(E.stopPropagation(),this._stateController.close(!0))}__onMouseDown(){this._stateController.close(!0)}__onMouseEnter(){this.manual||this.__isShouldShow()&&(this.__hoverInside||(this.__hoverInside=!0,!this.__isTargetHidden&&(!this.__focusInside||!this._autoOpened)&&this._stateController.open({hover:!0})))}__onMouseLeave(E){E.relatedTarget!==this._overlayElement&&this.__handleMouseLeave()}__onOverlayMouseLeave(E){E.relatedTarget!==this.target&&this.__handleMouseLeave()}__handleMouseLeave(){this.manual||(this.__hoverInside=!1,this.__focusInside||this._stateController.close())}__onOverlayOpen(){this.manual||this._overlayElement.opened&&!this._overlayElement._last&&this._stateController.close(!0)}__onTargetVisibilityChange(E){const a=this.__isTargetHidden;if(this.__isTargetHidden=!E,a&&E&&(this.__focusInside||this.__hoverInside)){this._stateController.open({immediate:!0});return}!E&&this._autoOpened&&this._stateController.close(!0)}__isShouldShow(){return!(typeof this.shouldShow=="function"&&this.shouldShow(this.target,this.context)!==!0)}__textChanged(E,a){this._overlayElement&&(E||a)&&this._overlayElement.requestContentUpdate()}__generatorChanged(E,a,k){E&&((a!==this.__oldTextGenerator||k!==this.__oldContext)&&E.requestContentUpdate(),this.__oldTextGenerator=a,this.__oldContext=k)}};customElements.define(Tooltip$1.is,Tooltip$1);/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const userColors=i$2`
  :host {
    --vaadin-user-color-0: #df0b92;
    --vaadin-user-color-1: #650acc;
    --vaadin-user-color-2: #097faa;
    --vaadin-user-color-3: #ad6200;
    --vaadin-user-color-4: #bf16f3;
    --vaadin-user-color-5: #084391;
    --vaadin-user-color-6: #078836;
  }

  [theme~='dark'] {
    --vaadin-user-color-0: #ff66c7;
    --vaadin-user-color-1: #9d8aff;
    --vaadin-user-color-2: #8aff66;
    --vaadin-user-color-3: #ffbd66;
    --vaadin-user-color-4: #dc6bff;
    --vaadin-user-color-5: #66fffa;
    --vaadin-user-color-6: #e6ff66;
  }
`,$tpl=document.createElement("template");$tpl.innerHTML=`<style>${userColors.toString().replace(":host","html")}</style>`;document.head.appendChild($tpl.content);const globalStyle=document.createElement("style");globalStyle.textContent="html { --vaadin-avatar-size: var(--lumo-size-m); }";document.head.appendChild(globalStyle);registerStyles$1("vaadin-avatar",i$2`
    :host {
      color: var(--lumo-secondary-text-color);
      background-color: var(--lumo-contrast-10pct);
      border-radius: 50%;
      outline: none;
      cursor: default;
      user-select: none;
      -webkit-tap-highlight-color: transparent;
      -webkit-font-smoothing: antialiased;
      -moz-osx-font-smoothing: grayscale;
    }

    :host([has-color-index]) {
      color: var(--lumo-base-color);
    }

    :host([focus-ring]) {
      border-color: var(--lumo-primary-color-50pct);
    }

    [part='icon'],
    [part='abbr'] {
      fill: currentColor;
    }

    [part='abbr'] {
      font-family: var(--lumo-font-family);
      font-size: 2.4375em;
      font-weight: 500;
    }

    :host([theme~='xlarge']) [part='abbr'] {
      font-size: 2.5em;
    }

    :host([theme~='large']) [part='abbr'] {
      font-size: 2.375em;
    }

    :host([theme~='small']) [part='abbr'] {
      font-size: 2.75em;
    }

    :host([theme~='xsmall']) [part='abbr'] {
      font-size: 3em;
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar"});/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const template$9=document.createElement("template");template$9.innerHTML=`
  <style>
    @font-face {
      font-family: 'vaadin-avatar-icons';
      src: url(data:application/font-woff;charset=utf-8;base64,d09GRgABAAAAAAQAAAsAAAAABnwAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABHU1VCAAABCAAAADsAAABUIIslek9TLzIAAAFEAAAAQwAAAFZAIUmEY21hcAAAAYgAAABLAAABcOspwa1nbHlmAAAB1AAAAEUAAABMYO4o1WhlYWQAAAIcAAAALgAAADYYaAmGaGhlYQAAAkwAAAAdAAAAJAZsA1VobXR4AAACbAAAAAgAAAAIA+gAAGxvY2EAAAJ0AAAABgAAAAYAJgAAbWF4cAAAAnwAAAAeAAAAIAEOACFuYW1lAAACnAAAAUIAAAKavFDYrHBvc3QAAAPgAAAAHQAAAC52hGZ4eJxjYGRgYOBiMGCwY2BycfMJYeDLSSzJY5BiYGGAAJA8MpsxJzM9kYEDxgPKsYBpDiBmg4gCACY7BUgAeJxjYGT8wjiBgZWBgamKaQ8DA0MPhGZ8wGDIyAQUZWBlZsAKAtJcUxgcXjG+YmQO+p/FEMUcxDANKMwIkgMADiUMJQB4nGNgYGBlYGBgBmIdIGZhYGAMYWBkAAE/oCgjWJyZgQsszsKgBFbDAhJ/xfj/P4wE8lnAJAMjG8Mo4AGTMlAeOKwgmIERADU0CX0AeJxjYGIAAmYJpkgGHgYRBgZGJT1GEztGIzlGET5GKEuU8YuSpZKSpQuI+LfLv21emz9jHJQPJP7dsUywsEiwBACG8g9CAAAAeJxjYGRgYADicIOnh+P5bb4ycDO/AIow3JZ4rIJMM0swRQIpDgYmEA8AKwgJOwAAeJxjYGRgYA76nwUkXzAAAbMEAyMDKmACAE2GAskAAAAAAAAAA+gAAAAAAAAAJgAAeJxjYGRgYGBiEAViBjCLgYELCBkY/oP5DAAKuwEwAAB4nI2Qu07DMBSG//SGaCWEhMSAGDx1QU0vYyemdmDrUDEhuamTpkriyHEj9RF4B56Bh2Bg5mmY+8d4Qh3qo9jf+c45thQAt/hGgGYFuHN7s1q4YvbHbdKD5w555LmLAZ499+hfPPfxhDfPA/p33hB0rmmG+PDcwg2+PLfpfzx3yL+eu7gPHj33MAxmnvtYB6+eB/SftZTbtBjJWlppRmmki2qlkkMmzZnKGbVWpkp1Iabh5Ex1qQplpFVbsTmKqk5m1sYiNjoXC11YlWValEbvVWTDnbXlfDyOvQ8jnaOGZGyRouCfky63/AyzFBE0fYUVFBIckLnKZTOXda15s+GZulxgihCTC2eXnC3cfFNV7BfY4Mi9eT3BjNYiZh6zRyMnLdxs050xNE3panuaiD7Ezk2VmGPMiP/1h+71/ATcWYAhAAB4nGNgYoAALgbsgImRiZGZgaW0OLWIgQEACl4B2QAAAA==) format('woff');
      font-weight: normal;
      font-style: normal;
    }
  </style>
`;document.head.appendChild(template$9.content);/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class Avatar extends FocusMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement)))){static get template(){return html`
      <style>
        :host {
          display: inline-block;
          flex: none;
          border-radius: 50%;
          overflow: hidden;
          height: var(--vaadin-avatar-size, 64px);
          width: var(--vaadin-avatar-size, 64px);
          border: var(--vaadin-avatar-outline-width) solid transparent;
          margin: calc(var(--vaadin-avatar-outline-width) * -1);
          background-clip: content-box;
          --vaadin-avatar-outline-width: 2px;
        }

        img {
          height: 100%;
          width: 100%;
          object-fit: cover;
        }

        [part='icon'] {
          font-size: 5.6em;
        }

        [part='abbr'] {
          font-size: 2.2em;
        }

        [part='icon'] > text {
          font-family: 'vaadin-avatar-icons';
        }

        :host([hidden]) {
          display: none !important;
        }

        svg[hidden] {
          display: none !important;
        }

        :host([has-color-index]) {
          position: relative;
          background-color: var(--vaadin-avatar-user-color);
        }

        :host([has-color-index])::before {
          position: absolute;
          content: '';
          top: 0;
          left: 0;
          bottom: 0;
          right: 0;
          border-radius: inherit;
          box-shadow: inset 0 0 0 2px var(--vaadin-avatar-user-color);
        }
      </style>
      <img hidden$="[[!__imgVisible]]" src$="[[img]]" aria-hidden="true" on-error="__onImageLoadError" />
      <svg
        part="icon"
        hidden$="[[!__iconVisible]]"
        id="avatar-icon"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">&#xea01;</text>
      </svg>
      <svg
        part="abbr"
        hidden$="[[!__abbrVisible]]"
        id="avatar-abbr"
        viewBox="-50 -50 100 100"
        preserveAspectRatio="xMidYMid meet"
        aria-hidden="true"
      >
        <text dy=".35em" text-anchor="middle">[[abbr]]</text>
      </svg>

      <slot name="tooltip"></slot>
    `}static get is(){return"vaadin-avatar"}static get properties(){return{img:{type:String,reflectToAttribute:!0,observer:"__imgChanged"},abbr:{type:String,reflectToAttribute:!0},name:{type:String,reflectToAttribute:!0},colorIndex:{type:Number,observer:"__colorIndexChanged"},i18n:{type:Object,value:()=>({anonymous:"anonymous"})},withTooltip:{type:Boolean,value:!1,observer:"__withTooltipChanged"},__imgVisible:Boolean,__iconVisible:Boolean,__abbrVisible:Boolean,__tooltipNode:Object}}static get observers(){return["__imgOrAbbrOrNameChanged(img, abbr, name)","__i18nChanged(i18n.*)","__tooltipChanged(__tooltipNode, name, abbr)"]}ready(){super.ready(),this.__updateVisibility(),this.hasAttribute("role")||this.setAttribute("role","button"),this.hasAttribute("tabindex")||this.setAttribute("tabindex","0"),this._tooltipController=new TooltipController(this),this.addController(this._tooltipController),!this.name&&!this.abbr&&this.__setTooltip()}__colorIndexChanged(E){if(E!=null){const a=`--vaadin-user-color-${E}`;Boolean(getComputedStyle(document.documentElement).getPropertyValue(a))?(this.setAttribute("has-color-index",""),this.style.setProperty("--vaadin-avatar-user-color",`var(${a})`)):(this.removeAttribute("has-color-index"),console.warn(`The CSS property --vaadin-user-color-${E} is not defined`))}else this.removeAttribute("has-color-index")}__imgChanged(){this.__imgFailedToLoad=!1}__imgOrAbbrOrNameChanged(E,a,k){this.__updateVisibility(),!(a&&a!==this.__generatedAbbr)&&(k?this.abbr=this.__generatedAbbr=k.split(" ").map(tt=>tt.charAt(0)).join(""):this.abbr=void 0)}__tooltipChanged(E,a,k){E&&(k&&k!==this.__generatedAbbr?this.__setTooltip(a?`${a} (${k})`:k):this.__setTooltip(a))}__withTooltipChanged(E,a){if(E){const k=document.createElement("vaadin-tooltip");k.setAttribute("slot","tooltip"),this.appendChild(k),this.__tooltipNode=k}else a&&(this.__tooltipNode.target=null,this.__tooltipNode.remove(),this.__tooltipNode=null)}__i18nChanged(E){E.base&&E.base.anonymous&&(this.__oldAnonymous&&this.__tooltipNode&&this.__tooltipNode.text===this.__oldAnonymous&&this.__setTooltip(),this.__oldAnonymous=E.base.anonymous)}__updateVisibility(){this.__imgVisible=!!this.img&&!this.__imgFailedToLoad,this.__abbrVisible=!this.__imgVisible&&!!this.abbr,this.__iconVisible=!this.__imgVisible&&!this.abbr}__setTooltip(E){const a=this.__tooltipNode;a&&(a.text=E||this.i18n.anonymous)}__onImageLoadError(){this.img&&(console.warn(`<vaadin-avatar> The specified image could not be loaded: ${this.img}`),this.__imgFailedToLoad=!0,this.__updateVisibility())}}customElements.define(Avatar.is,Avatar);const item=i$2`
  :host {
    display: flex;
    align-items: center;
    box-sizing: border-box;
    font-family: var(--lumo-font-family);
    font-size: var(--lumo-font-size-m);
    line-height: var(--lumo-line-height-xs);
    padding: 0.5em calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4) 0.5em
      var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
    min-height: var(--lumo-size-m);
    outline: none;
    border-radius: var(--lumo-border-radius-m);
    cursor: var(--lumo-clickable-cursor);
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    -webkit-tap-highlight-color: var(--lumo-primary-color-10pct);
  }

  /* Checkmark */
  [part='checkmark']::before {
    display: var(--_lumo-item-selected-icon-display, none);
    content: var(--lumo-icons-checkmark);
    font-family: lumo-icons;
    font-size: var(--lumo-icon-size-m);
    line-height: 1;
    font-weight: normal;
    width: 1em;
    height: 1em;
    margin: calc((1 - var(--lumo-line-height-xs)) * var(--lumo-font-size-m) / 2) 0;
    color: var(--lumo-primary-text-color);
    flex: none;
    opacity: 0;
    transition: transform 0.2s cubic-bezier(0.12, 0.32, 0.54, 2), opacity 0.1s;
  }

  :host([selected]) [part='checkmark']::before {
    opacity: 1;
  }

  :host([active]:not([selected])) [part='checkmark']::before {
    transform: scale(0.8);
    opacity: 0;
    transition-duration: 0s;
  }

  [part='content'] {
    flex: auto;
  }

  /* Disabled */
  :host([disabled]) {
    color: var(--lumo-disabled-text-color);
    cursor: default;
    pointer-events: none;
  }

  /* TODO a workaround until we have "focus-follows-mouse". After that, use the hover style for focus-ring as well */
  @media (any-hover: hover) {
    :host(:hover:not([disabled])) {
      background-color: var(--lumo-primary-color-10pct);
    }

    :host([focus-ring]:not([disabled])) {
      box-shadow: inset 0 0 0 2px var(--lumo-primary-color-50pct);
    }
  }

  /* RTL specific styles */
  :host([dir='rtl']) {
    padding-left: calc(var(--lumo-space-l) + var(--lumo-border-radius-m) / 4);
    padding-right: var(--_lumo-list-box-item-padding-left, calc(var(--lumo-border-radius-m) / 4));
  }

  /* Slotted icons */
  :host ::slotted(vaadin-icon) {
    width: var(--lumo-icon-size-m);
    height: var(--lumo-icon-size-m);
  }
`;registerStyles$1("vaadin-item",item,{moduleId:"lumo-item"});const listBox=i$2`
  :host {
    -webkit-tap-highlight-color: transparent;
    --_lumo-item-selected-icon-display: var(--_lumo-list-box-item-selected-icon-display, block);
  }

  /* Dividers */
  [part='items'] ::slotted(hr) {
    height: 1px;
    border: 0;
    padding: 0;
    margin: var(--lumo-space-s) var(--lumo-border-radius-m);
    background-color: var(--lumo-contrast-10pct);
  }
`;registerStyles$1("vaadin-list-box",listBox,{moduleId:"lumo-list-box"});/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const menuOverlayCore=i$2`
  :host([opening]),
  :host([closing]) {
    animation: 0.14s lumo-overlay-dummy-animation;
  }

  [part='overlay'] {
    will-change: opacity, transform;
  }

  :host([opening]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-enter ease-out both;
  }

  @keyframes lumo-menu-overlay-enter {
    0% {
      opacity: 0;
      transform: translateY(-4px);
    }
  }

  :host([closing]) [part='overlay'] {
    animation: 0.1s lumo-menu-overlay-exit both;
  }

  @keyframes lumo-menu-overlay-exit {
    100% {
      opacity: 0;
    }
  }
`;registerStyles$1("",menuOverlayCore,{moduleId:"lumo-menu-overlay-core"});const menuOverlayExt=i$2`
  /* Small viewport (bottom sheet) styles */
  /* Use direct media queries instead of the state attributes ([phone] and [fullscreen]) provided by the elements */
  @media (max-width: 420px), (max-height: 420px) {
    :host {
      top: 0 !important;
      right: 0 !important;
      bottom: var(--vaadin-overlay-viewport-bottom, 0) !important;
      left: 0 !important;
      align-items: stretch !important;
      justify-content: flex-end !important;
    }

    [part='overlay'] {
      max-height: 50vh;
      width: 100vw;
      border-radius: 0;
      box-shadow: var(--lumo-box-shadow-xl);
    }

    /* The content part scrolls instead of the overlay part, because of the gradient fade-out */
    [part='content'] {
      padding: 30px var(--lumo-space-m);
      max-height: inherit;
      box-sizing: border-box;
      -webkit-overflow-scrolling: touch;
      overflow: auto;
      -webkit-mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
      mask-image: linear-gradient(transparent, #000 40px, #000 calc(100% - 40px), transparent);
    }

    [part='backdrop'] {
      display: block;
    }

    /* Animations */

    :host([opening]) [part='overlay'] {
      animation: 0.2s lumo-mobile-menu-overlay-enter cubic-bezier(0.215, 0.61, 0.355, 1) both;
    }

    :host([closing]),
    :host([closing]) [part='backdrop'] {
      animation-delay: 0.14s;
    }

    :host([closing]) [part='overlay'] {
      animation: 0.14s 0.14s lumo-mobile-menu-overlay-exit cubic-bezier(0.55, 0.055, 0.675, 0.19) both;
    }
  }

  @keyframes lumo-mobile-menu-overlay-enter {
    0% {
      transform: translateY(150%);
    }
  }

  @keyframes lumo-mobile-menu-overlay-exit {
    100% {
      transform: translateY(150%);
    }
  }
`,menuOverlay=[overlay,menuOverlayCore,menuOverlayExt];registerStyles$1("",menuOverlay,{moduleId:"lumo-menu-overlay"});registerStyles$1("vaadin-avatar-group",i$2`
    :host {
      --vaadin-avatar-size: var(--lumo-size-m);
    }

    :host([theme~='xlarge']) {
      --vaadin-avatar-group-overlap: 12px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-xl);
    }

    :host([theme~='large']) {
      --vaadin-avatar-group-overlap: 10px;
      --vaadin-avatar-group-overlap-border: 3px;
      --vaadin-avatar-size: var(--lumo-size-l);
    }

    :host([theme~='small']) {
      --vaadin-avatar-group-overlap: 6px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-s);
    }

    :host([theme~='xsmall']) {
      --vaadin-avatar-group-overlap: 4px;
      --vaadin-avatar-group-overlap-border: 2px;
      --vaadin-avatar-size: var(--lumo-size-xs);
    }
  `,{moduleId:"lumo-avatar-group"});const avatarGroupOverlay=i$2`
  :host {
    --_lumo-list-box-item-selected-icon-display: none;
    --_lumo-list-box-item-padding-left: calc(var(--lumo-space-m) + var(--lumo-border-radius-m) / 4);
  }

  [part='overlay'] {
    outline: none;
  }
`;registerStyles$1("vaadin-avatar-group-overlay",[overlay,menuOverlayCore,avatarGroupOverlay],{moduleId:"lumo-avatar-group-overlay"});registerStyles$1("vaadin-avatar-group-menu",listBox,{moduleId:"lumo-avatar-group-menu"});registerStyles$1("vaadin-avatar-group-menu-item",[item,i$2`
      :host {
        padding: var(--lumo-space-xs);
        padding-inline-end: var(--lumo-space-m);
      }

      [part='content'] {
        display: flex;
        align-items: center;
      }

      [part='content'] ::slotted(vaadin-avatar) {
        width: var(--lumo-size-xs);
        height: var(--lumo-size-xs);
        margin-inline-end: var(--lumo-space-s);
      }
    `],{moduleId:"lumo-avatar-group-menu-item"});/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ListMixin=j=>class extends KeyboardDirectionMixin(j){static get properties(){return{_hasVaadinListMixin:{value:!0},disabled:{type:Boolean,value:!1,reflectToAttribute:!0},selected:{type:Number,reflectToAttribute:!0,notify:!0},orientation:{type:String,reflectToAttribute:!0,value:""},items:{type:Array,readOnly:!0,notify:!0},_searchBuf:{type:String,value:""}}}static get observers(){return["_enhanceItems(items, orientation, selected, disabled)"]}get _isRTL(){return!this._vertical&&this.getAttribute("dir")==="rtl"}get _scrollerElement(){return console.warn(`Please implement the '_scrollerElement' property in <${this.localName}>`),this}get _vertical(){return this.orientation!=="horizontal"}focus(){this._observer&&this._observer.flush();const a=this.querySelector('[tabindex="0"]')||(this.items?this.items[0]:null);this._focusItem(a)}ready(){super.ready(),this.addEventListener("click",a=>this._onClick(a)),this._observer=new FlattenedNodesObserver(this,()=>{this._setItems(this._filterItems(FlattenedNodesObserver.getFlattenedNodes(this)))})}_getItems(){return this.items}_enhanceItems(a,k,tt,et){if(!et&&a){this.setAttribute("aria-orientation",k||"vertical"),a.forEach(nt=>{k?nt.setAttribute("orientation",k):nt.removeAttribute("orientation")}),this._setFocusable(tt||0);const rt=a[tt];a.forEach(nt=>{nt.selected=nt===rt}),rt&&!rt.disabled&&this._scrollToItem(tt)}}_filterItems(a){return a.filter(k=>k._hasVaadinItemMixin)}_onClick(a){if(a.metaKey||a.shiftKey||a.ctrlKey||a.defaultPrevented)return;const k=this._filterItems(a.composedPath())[0];let tt;k&&!k.disabled&&(tt=this.items.indexOf(k))>=0&&(this.selected=tt)}_searchKey(a,k){this._searchReset=Debouncer$1.debounce(this._searchReset,timeOut.after(500),()=>{this._searchBuf=""}),this._searchBuf+=k.toLowerCase(),this.items.some(et=>this.__isMatchingKey(et))||(this._searchBuf=k.toLowerCase());const tt=this._searchBuf.length===1?a+1:a;return this._getAvailableIndex(this.items,tt,1,et=>this.__isMatchingKey(et)&&getComputedStyle(et).display!=="none")}__isMatchingKey(a){return a.textContent.replace(/[^\p{L}\p{Nd}]/gu,"").toLowerCase().startsWith(this._searchBuf)}_onKeyDown(a){if(a.metaKey||a.ctrlKey)return;const k=a.key,tt=this.items.indexOf(this.focused);if(/[a-zA-Z0-9]/u.test(k)&&k.length===1){const et=this._searchKey(tt,k);et>=0&&this._focus(et);return}super._onKeyDown(a)}_isItemHidden(a){return getComputedStyle(a).display==="none"}_setFocusable(a){a=this._getAvailableIndex(this.items,a,1);const k=this.items[a];this.items.forEach(tt=>{tt.tabIndex=tt===k?0:-1})}_focus(a){this.items.forEach((k,tt)=>{k.focused=tt===a}),this._setFocusable(a),this._scrollToItem(a),super._focus(a)}_scrollToItem(a){const k=this.items[a];if(!k)return;const tt=this._vertical?["top","bottom"]:this._isRTL?["right","left"]:["left","right"],et=this._scrollerElement.getBoundingClientRect(),rt=(this.items[a+1]||k).getBoundingClientRect(),nt=(this.items[a-1]||k).getBoundingClientRect();let ot=0;!this._isRTL&&rt[tt[1]]>=et[tt[1]]||this._isRTL&&rt[tt[1]]<=et[tt[1]]?ot=rt[tt[1]]-et[tt[1]]:(!this._isRTL&&nt[tt[0]]<=et[tt[0]]||this._isRTL&&nt[tt[0]]>=et[tt[0]])&&(ot=nt[tt[0]]-et[tt[0]]),this._scroll(ot)}_scroll(a){if(this._vertical)this._scrollerElement.scrollTop+=a;else{const k=this.getAttribute("dir")||"ltr",tt=getNormalizedScrollLeft(this._scrollerElement,k)+a;setNormalizedScrollLeft(this._scrollerElement,k,tt)}}};/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenu extends ListMixin(ThemableMixin(DirMixin(ControllerMixin(PolymerElement)))){static get is(){return"vaadin-avatar-group-menu"}static get template(){return html`
      <style>
        :host {
          display: flex;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='items'] {
          height: 100%;
          width: 100%;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }
      </style>
      <div part="items">
        <slot></slot>
      </div>
    `}static get properties(){return{orientation:{readOnly:!0}}}get _scrollerElement(){return this.shadowRoot.querySelector('[part="items"]')}ready(){super.ready(),this.setAttribute("role","menu")}}customElements.define(AvatarGroupMenu.is,AvatarGroupMenu);/**
 * @license
 * Copyright (c) 2017 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const ItemMixin=j=>class extends ActiveMixin(FocusMixin(j)){static get properties(){return{_hasVaadinItemMixin:{value:!0},selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged"},_value:String}}get _activeKeys(){return["Enter"," "]}get value(){return this._value!==void 0?this._value:this.textContent.trim()}set value(a){this._value=a}ready(){super.ready();const a=this.getAttribute("value");a!==null&&(this.value=a)}focus(){this.disabled||(super.focus(),this._setFocused(!0))}_shouldSetActive(a){return!this.disabled&&!(a.type==="keydown"&&a.defaultPrevented)}_selectedChanged(a){this.setAttribute("aria-selected",a)}_disabledChanged(a){super._disabledChanged(a),a&&(this.selected=!1,this.blur())}_onKeyDown(a){super._onKeyDown(a),this._activeKeys.includes(a.key)&&!a.defaultPrevented&&(a.preventDefault(),this.click())}};/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupMenuItem extends ItemMixin(ThemableMixin(DirMixin(PolymerElement))){static get is(){return"vaadin-avatar-group-menu-item"}static get template(){return html`
      <style>
        :host {
          display: inline-block;
        }

        :host([hidden]) {
          display: none !important;
        }
      </style>
      <span part="checkmark" aria-hidden="true"></span>
      <div part="content">
        <slot></slot>
      </div>
    `}ready(){super.ready(),this.setAttribute("role","menuitem")}}customElements.define(AvatarGroupMenuItem.is,AvatarGroupMenuItem);/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */class AvatarGroupOverlay extends PositionMixin(Overlay){static get is(){return"vaadin-avatar-group-overlay"}}customElements.define(AvatarGroupOverlay.is,AvatarGroupOverlay);/**
 * @license
 * Copyright (c) 2022 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const region=document.createElement("div");region.style.position="fixed";region.style.clip="rect(0px, 0px, 0px, 0px)";region.setAttribute("aria-live","polite");document.body.appendChild(region);let alertDebouncer;function announce(j,E={}){const a=E.mode||"polite",k=E.timeout===void 0?150:E.timeout;a==="alert"?(region.removeAttribute("aria-live"),region.removeAttribute("role"),alertDebouncer=Debouncer$1.debounce(alertDebouncer,animationFrame,()=>{region.setAttribute("role","alert")})):(alertDebouncer&&alertDebouncer.cancel(),region.removeAttribute("role"),region.setAttribute("aria-live",a)),region.textContent="",setTimeout(()=>{region.textContent=j},k)}/**
 * @license
 * Copyright (c) 2020 - 2023 Vaadin Ltd.
 * This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
 */const MINIMUM_DISPLAYED_AVATARS=2;class AvatarGroup extends ResizeMixin(OverlayClassMixin(ElementMixin(ThemableMixin(ControllerMixin(PolymerElement))))){static get template(){return html`
      <style>
        :host {
          display: block;
          width: 100%; /* prevent collapsing inside non-stretching column flex */
          --vaadin-avatar-group-overlap: 8px;
          --vaadin-avatar-group-overlap-border: 2px;
        }

        :host([hidden]) {
          display: none !important;
        }

        [part='container'] {
          display: flex;
          position: relative;
          width: 100%;
          flex-wrap: nowrap;
        }

        ::slotted(vaadin-avatar:not(:first-child)) {
          -webkit-mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
          mask-image: url('data:image/svg+xml;utf8,<svg viewBox=%220 0 300 300%22 fill=%22none%22 xmlns=%22http://www.w3.org/2000/svg%22><path fill-rule=%22evenodd%22 clip-rule=%22evenodd%22 d=%22M300 0H0V300H300V0ZM150 200C177.614 200 200 177.614 200 150C200 122.386 177.614 100 150 100C122.386 100 100 122.386 100 150C100 177.614 122.386 200 150 200Z%22 fill=%22black%22/></svg>');
          -webkit-mask-size: calc(
            300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
          );
          mask-size: calc(
            300% + var(--vaadin-avatar-group-overlap-border) * 6 - var(--vaadin-avatar-outline-width) * 6
          );
        }

        ::slotted(vaadin-avatar:not([dir='rtl']):not(:first-child)) {
          margin-left: calc(var(--vaadin-avatar-group-overlap) * -1 - var(--vaadin-avatar-outline-width));
          -webkit-mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
          mask-position: calc(50% - var(--vaadin-avatar-size) + var(--vaadin-avatar-group-overlap));
        }

        ::slotted(vaadin-avatar[dir='rtl']:not(:first-child)) {
          margin-right: calc(var(--vaadin-avatar-group-overlap) * -1);
          -webkit-mask-position: calc(
            50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
          );
          mask-position: calc(
            50% + var(--vaadin-avatar-size) - var(--vaadin-avatar-group-overlap) + var(--vaadin-avatar-outline-width)
          );
        }
      </style>
      <div id="container" part="container">
        <slot></slot>
        <slot name="overflow"></slot>
      </div>
      <vaadin-avatar-group-overlay
        id="overlay"
        opened="{{_opened}}"
        position-target="[[_overflow]]"
        no-vertical-overlap
        on-vaadin-overlay-close="_onVaadinOverlayClose"
      ></vaadin-avatar-group-overlay>
    `}static get is(){return"vaadin-avatar-group"}static get properties(){return{items:{type:Array},maxItemsVisible:{type:Number},i18n:{type:Object,value:()=>({anonymous:"anonymous",activeUsers:{one:"Currently one active user",many:"Currently {count} active users"},joined:"{user} joined",left:"{user} left"})},_avatars:{type:Array,value:()=>[]},__maxReached:{type:Boolean,computed:"__computeMaxReached(items.length, maxItemsVisible)"},__items:{type:Array},__itemsInView:{type:Number,value:null},_overflow:{type:Object},_overflowItems:{type:Array,observer:"__overflowItemsChanged",computed:"__computeOverflowItems(items.*, __itemsInView, maxItemsVisible)"},_overflowTooltip:{type:Object},_opened:{type:Boolean,observer:"__openedChanged"}}}static get observers(){return["__itemsChanged(items.splices, items.*)","__i18nItemsChanged(i18n.*, items.length)","__updateAvatarsTheme(_overflow, _avatars, _theme)","__updateAvatars(items.*, __itemsInView, maxItemsVisible, _overflow, i18n)","__updateOverflowAbbr(_overflow, items.length, __itemsInView, maxItemsVisible)","__updateOverflowHidden(_overflow, items.length, __itemsInView, __maxReached)","__updateOverflowTooltip(_overflowTooltip, items.length, __itemsInView, maxItemsVisible)"]}ready(){super.ready(),this._overflowController=new SlotController(this,"overflow","vaadin-avatar",{initializer:a=>{a.setAttribute("aria-haspopup","menu"),a.setAttribute("aria-expanded","false"),a.addEventListener("click",tt=>this._onOverflowClick(tt)),a.addEventListener("keydown",tt=>this._onOverflowKeyDown(tt));const k=document.createElement("vaadin-tooltip");k.setAttribute("slot","tooltip"),a.appendChild(k),this._overflow=a,this._overflowTooltip=k}}),this.addController(this._overflowController);const E=this.$.overlay;E.renderer=this.__overlayRenderer.bind(this),this._overlayElement=E,afterNextRender(this,()=>{this.__setItemsInView()})}disconnectedCallback(){super.disconnectedCallback(),this._opened=!1}__getMessage(E,a){return a.replace("{user}",E.name||E.abbr||this.i18n.anonymous)}__overlayRenderer(E){let a=E.firstElementChild;a||(a=document.createElement("vaadin-avatar-group-menu"),a.addEventListener("keydown",k=>this._onListKeyDown(k)),E.appendChild(a)),a.textContent="",this._overflowItems&&this._overflowItems.forEach(k=>{a.appendChild(this.__createItemElement(k))})}__createItemElement(E){const a=document.createElement("vaadin-avatar-group-menu-item"),k=document.createElement("vaadin-avatar");if(a.appendChild(k),k.setAttribute("aria-hidden","true"),k.setAttribute("tabindex","-1"),k.i18n=this.i18n,this._theme&&k.setAttribute("theme",this._theme),k.name=E.name,k.abbr=E.abbr,k.img=E.img,k.colorIndex=E.colorIndex,E.name){const tt=document.createTextNode(E.name);a.appendChild(tt)}return a}_onOverflowClick(E){E.stopPropagation(),this._opened?this.$.overlay.close():E.defaultPrevented||(this._opened=!0)}_onOverflowKeyDown(E){this._opened||/^(Enter|SpaceBar|\s)$/u.test(E.key)&&(E.preventDefault(),this._opened=!0)}_onListKeyDown(E){(E.key==="Escape"||E.key==="Tab")&&(this._opened=!1)}_onResize(){this.__setItemsInView()}_onVaadinOverlayClose(E){E.detail.sourceEvent&&E.detail.sourceEvent.composedPath().includes(this)&&E.preventDefault()}__renderAvatars(E){Z$1(y`
        ${E.map(a=>y`
              <vaadin-avatar
                .name="${a.name}"
                .abbr="${a.abbr}"
                .img="${a.img}"
                .colorIndex="${a.colorIndex}"
                .i18n="${this.i18n}"
                with-tooltip
              ></vaadin-avatar>
            `)}
      `,this,{renderBefore:this._overflow})}__updateAvatars(E,a,k,tt){if(!tt)return;const et=E.base||[],rt=this.__getLimit(et.length,a,k);this.__renderAvatars(rt?et.slice(0,rt):et),this._avatars=[...this.querySelectorAll("vaadin-avatar")]}__computeOverflowItems(E,a,k){const tt=E.base||[],et=this.__getLimit(tt.length,a,k);return et?tt.slice(et):[]}__computeMaxReached(E,a){return a!=null&&E>this.__getMax(a)}__updateOverflowAbbr(E,a,k,tt){E&&(E.abbr=`+${a-this.__getLimit(a,k,tt)}`)}__updateOverflowHidden(E,a,k,tt){E&&E.toggleAttribute("hidden",!tt&&!(k&&k<a))}__updateAvatarsTheme(E,a,k){E&&[E,...a].forEach(tt=>{k?tt.setAttribute("theme",k):tt.removeAttribute("theme")})}__updateOverflowTooltip(E,a,k,tt){if(!E)return;const et=this.__getLimit(a,k,tt);if(et==null)return;const rt=[];for(let nt=et;nt<a;nt++){const ot=this.items[nt];ot&&rt.push(ot.name||ot.abbr||"anonymous")}E.text=rt.join(`
`)}__getLimit(E,a,k){let tt=null;const et=this.__getMax(k);return k!=null&&et<E?tt=et-1:a&&a<E&&(tt=a),Math.min(tt,this.__calculateAvatarsFitWidth())}__getMax(E){return Math.max(E,MINIMUM_DISPLAYED_AVATARS)}__itemsChanged(E,a){const k=a.base;this.__setItemsInView(),E&&Array.isArray(E.indexSplices)?E.indexSplices.forEach(tt=>{this.__announceItemsChange(k,tt)}):Array.isArray(k)&&Array.isArray(this.__oldItems)&&calculateSplices(k,this.__oldItems).forEach(et=>{this.__announceItemsChange(k,et)}),this.__oldItems=k}__announceItemsChange(E,a){const{addedCount:k,index:tt,removed:et}=a;let rt=[],nt=[];k&&(rt=E.slice(tt,tt+k).map(st=>this.__getMessage(st,this.i18n.joined||"{user} joined"))),et&&(nt=et.map(st=>this.__getMessage(st,this.i18n.left||"{user} left")));const ot=nt.concat(rt);ot.length>0&&announce(ot.join(", "))}__i18nItemsChanged(E,a){const{base:k}=E;if(k&&k.activeUsers){const tt=a===1?"one":"many";k.activeUsers[tt]&&this.setAttribute("aria-label",k.activeUsers[tt].replace("{count}",a||0)),this._avatars.forEach(et=>{et.i18n=k})}}__openedChanged(E,a){E?(this._menuElement||(this._menuElement=this.$.overlay.querySelector("vaadin-avatar-group-menu")),this._openedWithFocusRing=this._overflow.hasAttribute("focus-ring"),this._menuElement.focus()):a&&(this._overflow.focus(),this._openedWithFocusRing&&this._overflow.setAttribute("focus-ring","")),this._overflow.setAttribute("aria-expanded",E===!0)}__overflowItemsChanged(E,a){(E||a)&&this.$.overlay.requestContentUpdate()}__setItemsInView(){const E=this._avatars,a=this.items;if(!a||!E||E.length<3)return;let k=this.__calculateAvatarsFitWidth();k===a.length-1&&(k=a.length),k>=a.length&&this._opened&&(this.$.overlay.close(),this.$.overlay._flushAnimation("closing")),this.__itemsInView=k}__calculateAvatarsFitWidth(){if(!this.shadowRoot||this._avatars.length<MINIMUM_DISPLAYED_AVATARS)return MINIMUM_DISPLAYED_AVATARS;const E=this._avatars,a=E[0].clientWidth,{marginLeft:k,marginRight:tt}=getComputedStyle(E[1]),et=this.__isRTL?parseInt(tt,0)-parseInt(k,0):parseInt(k,0)-parseInt(tt,0);return Math.floor((this.$.container.offsetWidth-a)/(a+et))}}customElements.define(AvatarGroup.is,AvatarGroup);/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const CLASSES={SMALL:"small",MEDIUM:"medium",LARGE:"large"};class BoardRow extends ResizeMixin(ElementMixin(PolymerElement)){static get template(){return html`
      <style>
        :host {
          display: flex;
          flex-flow: row wrap;
          align-items: stretch;
          --small-size: var(--vaadin-board-width-small, 600px);
          --medium-size: var(--vaadin-board-width-medium, 960px);
        }

        :host ::slotted(*) {
          box-sizing: border-box;
          flex-grow: 1;
          overflow: hidden;
        }
      </style>
      <slot id="insertionPoint"></slot>
    `}static get is(){return"vaadin-board-row"}constructor(){super(),this._oldWidth=0,this._oldBreakpoints={smallSize:600,mediumSize:960},this._oldFlexBasis=[]}ready(){super.ready(),this.$.insertionPoint.addEventListener("slotchange",()=>this.redraw())}connectedCallback(){super.connectedCallback(),this._onResize()}_addStyleNames(E,a){E<a.smallSize?(this.classList.add(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):E<a.mediumSize?(this.classList.remove(CLASSES.SMALL),this.classList.add(CLASSES.MEDIUM),this.classList.remove(CLASSES.LARGE)):(this.classList.remove(CLASSES.SMALL),this.classList.remove(CLASSES.MEDIUM),this.classList.add(CLASSES.LARGE))}_calculateFlexBasis(E,a,k,tt){a<tt.smallSize?k=1:a<tt.mediumSize&&k===4&&(k=2);let et=E/k*100;return et=et>100?100:et,`${et}%`}_reportError(){console.warn("The column configuration is not valid; column count should add up to 3 or 4.",`check: \r
${this.outerHTML}`)}_parseBoardCols(E){const a=E.map(et=>et.getAttribute("board-cols")?parseInt(et.getAttribute("board-cols")):1);let k=4,tt=[];return E.forEach((et,rt)=>{k-=a[rt]}),k<0?(this._reportError(),a.forEach((et,rt)=>{tt[rt]=1})):tt=a.slice(0),tt}_removeExtraNodesFromDOM(E,a){let k=!1,tt=4;const et=[];return a.forEach((rt,nt)=>{tt-=E[nt],tt<0?(k||(k=!0,this._reportError()),this.removeChild(rt)):et[nt]=rt}),et}redraw(){this._recalculateFlexBasis(!0)}_onResize(){this._recalculateFlexBasis(!1)}_recalculateFlexBasis(E){const a=this.getBoundingClientRect().width,k=this._measureBreakpointsInPx();if(E||a!==this._oldWidth||k.smallSize!==this._oldBreakpoints.smallSize||k.mediumSize!==this._oldBreakpoints.mediumSize){const et=this.$.insertionPoint.assignedNodes({flatten:!0}).filter(ot=>ot.nodeType===Node.ELEMENT_NODE);this._addStyleNames(a,k);const rt=this._parseBoardCols(et),nt=rt.reduce((ot,st)=>ot+st,0);this._removeExtraNodesFromDOM(rt,et).forEach((ot,st)=>{const lt=this._calculateFlexBasis(rt[st],a,nt,k);(E||!this._oldFlexBasis[st]||this._oldFlexBasis[st]!==lt)&&(this._oldFlexBasis[st]=lt,ot.style.flexBasis=lt)}),this._oldWidth=a,this._oldBreakpoints=k}}_measureBreakpointsInPx(){const E={},a="background-position",k=getComputedStyle(this).getPropertyValue("--small-size"),tt=getComputedStyle(this).getPropertyValue("--medium-size");return this.style.setProperty(a,k),E.smallSize=parseFloat(getComputedStyle(this).getPropertyValue(a)),this.style.setProperty(a,tt),E.mediumSize=parseFloat(getComputedStyle(this).getPropertyValue(a)),this.style.removeProperty(a),E}}customElements.define(BoardRow.is,BoardRow);/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */class Board extends ElementMixin(PolymerElement){static get template(){return html`
      <style>
        :host {
          display: block;
        }
      </style>
      <slot></slot>
    `}static get is(){return"vaadin-board"}static get cvdlName(){return"vaadin-board"}redraw(){[...this.querySelectorAll("*")].filter(E=>E instanceof BoardRow).forEach(E=>E.redraw())}}customElements.define(Board.is,Board);/**
 * @license
 * Copyright (c) 2000 - 2023 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 *
 * See https://vaadin.com/commercial-license-and-service-terms for the full
 * license.
 */const chartBaseTheme=i$2`
  :host {
    font-family: -apple-system, BlinkMacSystemFont, 'Roboto', 'Segoe UI', Helvetica, Arial, sans-serif,
      'Apple Color Emoji', 'Segoe UI Emoji', 'Segoe UI Symbol';
    font-size: 12px;
    line-height: normal;
  }

  .highcharts-container {
    position: relative;
    overflow: hidden;
    width: 100%;
    height: 100%;
    text-align: left;
    z-index: 0;
    /* #1072 */
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
  }

  :where([styled-mode]) .highcharts-root {
    display: block;
  }

  :where([styled-mode]) .highcharts-root text {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-strong {
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-emphasized {
    font-style: italic;
  }

  :where([styled-mode]) .highcharts-anchor {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-background {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-plot-border,
  :where([styled-mode]) .highcharts-plot-background {
    fill: none;
  }

  :where([styled-mode]) .highcharts-label-box {
    fill: none;
  }

  :where([styled-mode]) .highcharts-button-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-tracker-line {
    stroke-linejoin: round;
    stroke: rgba(192, 192, 192, 0.0001);
    stroke-width: 22;
    fill: none;
  }

  :where([styled-mode]) .highcharts-tracker-area {
    fill: rgba(192, 192, 192, 0.0001);
    stroke-width: 0;
  }

  /* Titles */
  :where([styled-mode]) .highcharts-title {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
    font-size: 1.5em;
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-subtitle {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Axes */
  :where([styled-mode]) .highcharts-axis-line {
    fill: none;
    stroke: var(--vaadin-charts-axis-line, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-axis-title {
    fill: var(--vaadin-charts-axis-title, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-axis-labels {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    cursor: default;
    font-size: 0.9em;
  }

  :where([styled-mode]) .highcharts-grid-line {
    fill: none;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-xaxis-grid .highcharts-grid-line {
    stroke-width: var(--vaadin-charts-xaxis-line-width, 0px);
  }

  :where([styled-mode]) .highcharts-tick {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-yaxis .highcharts-tick {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-minor-grid-line {
    stroke: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-crosshair-thin {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-crosshair-category {
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
    stroke-opacity: 0.25;
  }

  /* Credits */
  :where([styled-mode]) .highcharts-credits {
    cursor: pointer;
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
    font-size: 0.7em;
    transition: fill 250ms, font-size 250ms;
  }

  :where([styled-mode]) .highcharts-credits:hover {
    fill: black;
    font-size: 1em;
  }

  /* Tooltip */
  :where([styled-mode]) .highcharts-tooltip {
    cursor: default;
    pointer-events: none;
    white-space: nowrap;
    transition: stroke 150ms;
  }

  :where([styled-mode]) .highcharts-tooltip {
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.05)) !important;
  }

  :where([styled-mode]) .highcharts-tooltip text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-tooltip .highcharts-header {
    font-size: 0.85em;
    color: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-tooltip-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-tooltip-border, inherit);
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-box .highcharts-label-box {
    fill: var(--vaadin-charts-tooltip-background, #fff);
    fill-opacity: var(--vaadin-charts-tooltip-background-opacity, 1);
  }

  :where([styled-mode]) .highcharts-tooltip-header {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) div.highcharts-tooltip {
    filter: none;
  }

  :where([styled-mode]) .highcharts-selection-marker {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    fill-opacity: 0.25;
  }

  :where([styled-mode]) .highcharts-graph {
    fill: none;
    stroke-width: 2px;
    stroke-linecap: round;
    stroke-linejoin: round;
  }

  :where([styled-mode]) .highcharts-state-hover .highcharts-graph {
    stroke-width: 3;
  }

  :where([styled-mode]) .highcharts-point-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-series-inactive {
    opacity: 0.2;
    transition: opacity 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-hover path {
    transition: stroke-width 50ms;
    /* quick in */
  }

  :where([styled-mode]) .highcharts-state-normal path {
    transition: stroke-width 250ms;
    /* slow out */
  }

  /* Legend hover affects points and series */
  :where([styled-mode]) g.highcharts-series,
  :where([styled-mode]) .highcharts-point,
  :where([styled-mode]) .highcharts-markers,
  :where([styled-mode]) .highcharts-data-labels {
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-legend-series-active g.highcharts-series:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-point-active .highcharts-point:not(.highcharts-point-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-markers:not(.highcharts-series-hover),
  :where([styled-mode]) .highcharts-legend-series-active .highcharts-data-labels:not(.highcharts-series-hover) {
    opacity: 0.2;
  }

  /* Series options */
  /* Default colors */
  /* vaadin-charts custom properties */
  /* Use of :where() function to avoid setting classes with high specificity */
  :where([styled-mode]) .highcharts-color-0 {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    stroke: var(--vaadin-charts-color-0, #5ac2f7);
  }

  :where([styled-mode]) .highcharts-color-1 {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-color-2 {
    fill: var(--vaadin-charts-color-2, #ff7d94);
    stroke: var(--vaadin-charts-color-2, #ff7d94);
  }

  :where([styled-mode]) .highcharts-color-3 {
    fill: var(--vaadin-charts-color-3, #c5164e);
    stroke: var(--vaadin-charts-color-3, #c5164e);
  }

  :where([styled-mode]) .highcharts-color-4 {
    fill: var(--vaadin-charts-color-4, #15c15d);
    stroke: var(--vaadin-charts-color-4, #15c15d);
  }

  :where([styled-mode]) .highcharts-color-5 {
    fill: var(--vaadin-charts-color-5, #0e8151);
    stroke: var(--vaadin-charts-color-5, #0e8151);
  }

  :where([styled-mode]) .highcharts-color-6 {
    fill: var(--vaadin-charts-color-6, #c18ed2);
    stroke: var(--vaadin-charts-color-6, #c18ed2);
  }

  :where([styled-mode]) .highcharts-color-7 {
    fill: var(--vaadin-charts-color-7, #9233b3);
    stroke: var(--vaadin-charts-color-7, #9233b3);
  }

  :where([styled-mode]) .highcharts-color-8 {
    fill: var(--vaadin-charts-color-8, #fda253);
    stroke: var(--vaadin-charts-color-8, #fda253);
  }

  :where([styled-mode]) .highcharts-color-9 {
    fill: var(--vaadin-charts-color-9, #e24932);
    stroke: var(--vaadin-charts-color-9, #e24932);
  }

  /* end of vaadin-charts custom properties */

  :where([styled-mode]) .highcharts-area {
    fill-opacity: 0.5;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-markers {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode])
    .highcharts-a11y-markers-hidden
    .highcharts-point:not(.highcharts-point-hover):not(.highcharts-a11y-marker-visible),
  :where([styled-mode]) .highcharts-a11y-marker-hidden {
    opacity: 0;
  }

  :where([styled-mode]) .highcharts-point {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-dense-data .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label {
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-data-label-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-data-label text,
  :where([styled-mode]) text.highcharts-data-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-data-label-connector {
    fill: none;
  }

  :where([styled-mode]) .highcharts-data-label-hidden {
    pointer-events: none;
  }

  :where([styled-mode]) .highcharts-halo {
    fill-opacity: 0.25;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-series:not(.highcharts-pie-series) .highcharts-point-select,
  :where([styled-mode]) .highcharts-markers .highcharts-point-select {
    fill: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-column-series rect.highcharts-point {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point {
    transition: fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-column-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-pie-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-funnel-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point {
    stroke-linejoin: round;
    stroke: var(--vaadin-charts-background, #fff);
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-hover {
    fill-opacity: 0.75;
    transition: fill-opacity 50ms;
  }

  :where([styled-mode]) .highcharts-pyramid-series .highcharts-point-select {
    fill: inherit;
    stroke: inherit;
  }

  :where([styled-mode]) .highcharts-solidgauge-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point {
    stroke-width: 2px;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-point-hover {
    stroke-width: 0px;
    stroke: var(--vaadin-charts-background, #fff);
    fill-opacity: 0.75;
    transition: stroke 25ms, fill 25ms, fill-opacity 25ms;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-above-level {
    display: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node {
    fill: none;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive {
    fill-opacity: 0.15;
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-treemap-series .highcharts-internal-node-interactive:hover {
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-vector-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-windbarb-series .highcharts-point {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-lollipop-stem {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-focus-border {
    fill: none;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-legend-item-hidden .highcharts-focus-border {
    fill: none !important;
  }

  /* Legend */
  :where([styled-mode]) .highcharts-legend-box {
    fill: none;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-weight: normal;
    font-size: 1em;
    cursor: pointer;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-legend-item > .highcharts-point {
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-legend-item:hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-legend-item-hidden * {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    stroke: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26)) !important;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-legend-nav-active {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-legend-nav-inactive {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  :where([styled-mode]) circle.highcharts-legend-nav-active,
  :where([styled-mode]) circle.highcharts-legend-nav-inactive {
    /* tracker */
    fill: rgba(192, 192, 192, 0.0001);
  }

  :where([styled-mode]) .highcharts-legend-title-box {
    fill: none;
    stroke-width: 0;
  }

  /* Bubble legend */
  :where([styled-mode]) .highcharts-bubble-legend-symbol {
    stroke-width: 2;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-bubble-legend-connectors {
    stroke-width: 1;
  }

  :where([styled-mode]) .highcharts-bubble-legend-labels {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Loading */
  :where([styled-mode]) .highcharts-loading {
    position: absolute;
    background-color: var(--vaadin-charts-background, #fff);
    opacity: 0.5;
    text-align: center;
    z-index: 10;
    transition: opacity 250ms;
  }

  :where([styled-mode]) .highcharts-loading-hidden {
    height: 0 !important;
    opacity: 0;
    overflow: hidden;
    transition: opacity 250ms, height 250ms step-end;
  }

  :where([styled-mode]) .highcharts-loading-inner {
    font-weight: normal;
    position: relative;
    top: 45%;
  }

  /* Plot bands and polar pane backgrounds */
  :where([styled-mode]) .highcharts-plot-band,
  :where([styled-mode]) .highcharts-pane {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-plot-line {
    fill: none;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-plot-line-label {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  /* Highcharts More and modules */
  :where([styled-mode]) .highcharts-boxplot-box {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-boxplot-median {
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-bubble-series .highcharts-point {
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-errorbar-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-data-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-gauge-series .highcharts-dial {
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-polygon-series .highcharts-graph {
    fill: inherit;
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-waterfall-series .highcharts-graph {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-dasharray: 1, 3;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-link {
    transition: fill 250ms, fill-opacity 250ms;
    fill-opacity: 0.5;
  }

  :where([styled-mode]) .highcharts-sankey-series .highcharts-point-hover.highcharts-link {
    transition: fill 50ms, fill-opacity 50ms;
    fill-opacity: 1;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point {
    fill-opacity: 0.75;
    stroke: var(--vaadin-charts-background, #fff);
    transition: stroke 250ms, fill-opacity 250ms;
  }

  :where([styled-mode]) .highcharts-venn-series .highcharts-point-hover {
    fill-opacity: 1;
    stroke: var(--vaadin-charts-background, #fff);
  }

  /* Highstock */
  :where([styled-mode]) .highcharts-navigator-mask-outside {
    fill-opacity: 0;
  }

  :where([styled-mode]) .highcharts-navigator-mask-inside {
    fill: var(--vaadin-charts-color-0, #5ac2f7);
    /* navigator.maskFill option */
    fill-opacity: 0.2;
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-outline {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: none;
  }

  :where([styled-mode]) .highcharts-navigator-handle {
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    cursor: ew-resize;
  }

  :where([styled-mode]) .highcharts-navigator-series {
    fill: var(--vaadin-charts-color-1, #1676f3);
    stroke: var(--vaadin-charts-color-1, #1676f3);
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-graph {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-navigator-series .highcharts-area {
    fill-opacity: 0.05;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-axis-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-navigator-xaxis .highcharts-grid-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-navigator-xaxis.highcharts-axis-labels {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-navigator-yaxis .highcharts-grid-line {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-scrollbar-thumb {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-scrollbar-button {
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-scrollbar-arrow {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) .highcharts-scrollbar-rifles {
    stroke: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-scrollbar-track {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
  }

  :where([styled-mode]) .highcharts-button {
    fill: var(--vaadin-charts-button-background, hsla(214, 61%, 25%, 0.05));
    cursor: default;
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-button text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: 600;
  }

  :where([styled-mode]) .highcharts-button-hover {
    transition: fill 0ms;
    fill: var(--vaadin-charts-button-hover-background, hsla(214, 90%, 52%, 0.1));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-button-hover text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed {
    fill: var(--vaadin-charts-button-active-background, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-button-pressed text {
    fill: var(--vaadin-charts-button-active-label, #fff);
  }

  :where([styled-mode]) .highcharts-button-disabled text {
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons > text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-selector-buttons .highcharts-button {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-range-label rect {
    fill: none;
  }

  :where([styled-mode]) .highcharts-range-label text {
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  :where([styled-mode]) .highcharts-range-input rect {
    fill: var(--vaadin-charts-contrast-10pct, hsla(214, 57%, 24%, 0.1));
    rx: 2;
    ry: 2;
  }

  :where([styled-mode]) .highcharts-range-input:hover rect {
    fill: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-range-input text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
  }

  :where([styled-mode]) input.highcharts-range-selector {
    position: absolute;
    border: 0;
    width: 1px;
    /* Chrome needs a pixel to see it */
    height: 1px;
    padding: 0;
    text-align: center;
    left: -9em;
    /* #4798 */
  }

  :where([styled-mode]) .highcharts-crosshair-label text {
    fill: var(--vaadin-charts-background, #fff);
    font-size: 1.1em;
  }

  :where([styled-mode]) .highcharts-crosshair-label .highcharts-label-box {
    fill: inherit;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-up {
    fill: var(--vaadin-charts-color-positive, #15c15d);
  }

  :where([styled-mode]) .highcharts-candlestick-series .highcharts-point-down {
    fill: var(--vaadin-charts-color-negative, #e24932);
  }

  :where([styled-mode]) .highcharts-ohlc-series .highcharts-point-hover {
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point .highcharts-label-box {
    stroke: var(--vaadin-charts-grid-line, hsla(214, 53%, 23%, 0.16));
    fill: var(--vaadin-charts-background, #fff);
    transition: fill 250ms;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover .highcharts-label-box {
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
    fill: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point text {
    fill: var(--vaadin-charts-data-label, hsla(214, 40%, 16%, 0.94));
    font-size: 0.9em;
    font-weight: normal;
  }

  :where([styled-mode]) .highcharts-flags-series .highcharts-point-hover text {
    fill: var(--vaadin-charts-title-label, hsl(214, 35%, 15%));
  }

  /* Highmaps */
  :where([styled-mode]) .highcharts-map-series .highcharts-point {
    transition: fill 500ms, fill-opacity 500ms, stroke-width 250ms;
    stroke: var(--vaadin-charts-contrast-20pct, hsla(214, 53%, 23%, 0.16));
  }

  :where([styled-mode]) .highcharts-map-series .highcharts-point-hover {
    transition: fill 0ms, fill-opacity 0ms;
    fill-opacity: 0.5;
    stroke-width: 2px;
  }

  :where([styled-mode]) .highcharts-mapline-series .highcharts-point {
    fill: none;
  }

  :where([styled-mode]) .highcharts-heatmap-series .highcharts-point {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-map-navigation {
    font-size: 1.3em;
    font-weight: normal;
    text-align: center;
  }

  :where([styled-mode]) .highcharts-coloraxis {
    stroke-width: 0;
  }

  :where([styled-mode]) .highcharts-coloraxis-grid .highcharts-grid-line {
    stroke: var(--vaadin-charts-background, #fff);
  }

  :where([styled-mode]) .highcharts-coloraxis-marker {
    fill: var(--vaadin-charts-axis-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 0px;
  }

  :where([styled-mode]) .highcharts-null-point {
    fill: var(--vaadin-charts-contrast-5pct, hsla(214, 61%, 25%, 0.05));
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* 3d charts */
  :where([styled-mode]) .highcharts-3d-frame {
    fill: transparent;
  }

  /* Exporting module */
  :where([styled-mode]) .highcharts-contextbutton {
    fill: #fff;
    /* needed to capture hover */
    stroke: none;
    stroke-linecap: round;
  }

  :where([styled-mode]) .highcharts-contextbutton:hover {
    fill: #e6e6e6;
    stroke: #e6e6e6;
  }

  :where([styled-mode]) .highcharts-button-symbol {
    stroke: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
    stroke-width: 3px;
  }

  :where([styled-mode]) .highcharts-menu {
    border: 1px solid #999;
    background: #fff;
    padding: 5px 0;
    box-shadow: 3px 3px 10px #888;
  }

  :where([styled-mode]) .highcharts-menu-item {
    padding: 0.5em 1em;
    background: none;
    color: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    cursor: pointer;
    transition: background 250ms, color 250ms;
  }

  :where([styled-mode]) .highcharts-menu-item:hover {
    background: #335cad;
    color: #fff;
  }

  /* Drilldown module */
  :where([styled-mode]) .highcharts-drilldown-point {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-drilldown-data-label text,
  :where([styled-mode]) text.highcharts-drilldown-data-label,
  :where([styled-mode]) .highcharts-drilldown-axis-label {
    cursor: pointer;
    fill: var(--vaadin-charts-button-label, hsl(214, 90%, 52%));
    font-weight: normal;
    text-decoration: underline;
  }

  /* No-data module */
  :where([styled-mode]) .highcharts-no-data text {
    font-weight: normal;
    font-size: 1rem;
    fill: var(--vaadin-charts-secondary-label, hsla(214, 42%, 18%, 0.72));
  }

  /* Drag-panes module */
  :where([styled-mode]) .highcharts-axis-resizer {
    cursor: ns-resize;
    stroke: black;
    stroke-width: 2px;
  }

  /* Bullet type series */
  :where([styled-mode]) .highcharts-bullet-target {
    stroke-width: 0;
  }

  /* Lineargauge type series */
  :where([styled-mode]) .highcharts-lineargauge-target {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  :where([styled-mode]) .highcharts-lineargauge-target-line {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast-60pct, hsla(214, 43%, 19%, 0.61));
  }

  /* Annotations module */
  :where([styled-mode]) .highcharts-annotation-label-box {
    stroke-width: 1px;
    stroke: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill: var(--vaadin-charts-contrast, hsl(214, 35%, 15%));
    fill-opacity: 0.75;
  }

  :where([styled-mode]) .highcharts-annotation-label text {
    fill: var(--vaadin-charts-disabled-label, hsla(214, 50%, 22%, 0.26));
  }

  /* Gantt */
  :where([styled-mode]) .highcharts-treegrid-node-collapsed,
  :where([styled-mode]) .highcharts-treegrid-node-expanded {
    cursor: pointer;
  }

  :where([styled-mode]) .highcharts-point-connecting-path {
    fill: none;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-tick {
    stroke-width: 1px;
  }

  :where([styled-mode]) .highcharts-grid-axis .highcharts-axis-line {
    stroke-width: 1px;
  }

  /* RTL styles */
  :host([dir='rtl']) :where([styled-mode]) .highcharts-container {
    text-align: right;
  }

  :host([dir='rtl']) :where([styled-mode]) input.highcharts-range-selector {
    left: auto;
    right: -9em;
  }

  :host([dir='rtl']) :where([styled-mode]) .highcharts-menu {
    box-shadow: -3px 3px 10px #888;
  }

  /* https://github.com/highcharts/highcharts/issues/16282 */
  /* without this the resize callback always calls __reflow */
  ul[aria-hidden='false'] {
    margin: 0px;
  }
`;registerStyles$1("vaadin-chart",chartBaseTheme,{moduleId:"vaadin-chart-base-theme"});const chartColors=i$2`
  :host {
    --vaadin-charts-color-0: #5ac2f7;
    --vaadin-charts-color-1: #1676f3;
    --vaadin-charts-color-2: #ff7d94;
    --vaadin-charts-color-3: #c5164e;
    --vaadin-charts-color-4: #15c15d;
    --vaadin-charts-color-5: #0e8151;
    --vaadin-charts-color-6: #c18ed2;
    --vaadin-charts-color-7: #9233b3;
    --vaadin-charts-color-8: #fda253;
    --vaadin-charts-color-9: #e24932;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-4, #15c15d);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9, #e24932);
  }

  :host([theme~='gradient']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #13bbf0;
    --vaadin-charts-color-2: #1ee;
    --vaadin-charts-color-3: #0cd9bf;
    --vaadin-charts-color-4: #06be81;
    --vaadin-charts-color-5: #00a344;
    --vaadin-charts-color-6: #41c639;
    --vaadin-charts-color-7: #8aed2c;
    --vaadin-charts-color-8: #c0e632;
    --vaadin-charts-color-9: #f6db3a;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-6);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-1);
  }

  :host([theme~='monotone']) {
    --vaadin-charts-color-0: #1676f3;
    --vaadin-charts-color-1: #4795f5;
    --vaadin-charts-color-2: #71b0f7;
    --vaadin-charts-color-3: #a0cef9;
    --vaadin-charts-color-4: #bce0fa;
    --vaadin-charts-color-5: #a8d8ed;
    --vaadin-charts-color-6: #7fc3dd;
    --vaadin-charts-color-7: #54adcc;
    --vaadin-charts-color-8: #2b99bc;
    --vaadin-charts-color-9: #0284ac;
    --vaadin-charts-color-positive: var(--vaadin-charts-color-3);
    --vaadin-charts-color-negative: var(--vaadin-charts-color-9);
  }

  :host([theme~='classic']) {
    --vaadin-charts-color-0: #7cb5ec;
    --vaadin-charts-color-1: #434348;
    --vaadin-charts-color-2: #90ed7d;
    --vaadin-charts-color-3: #f7a35c;
    --vaadin-charts-color-4: #8085e9;
    --vaadin-charts-color-5: #f15c80;
    --vaadin-charts-color-6: #e4d354;
    --vaadin-charts-color-7: #2b908f;
    --vaadin-charts-color-8: #f45b5b;
    --vaadin-charts-color-9: #91e8e1;
  }
`,chartTheme=i$2`
  :host {
    --vaadin-charts-background: var(--lumo-base-color);
    --vaadin-charts-title-label: var(--lumo-header-text-color);
    --vaadin-charts-axis-title: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-label: var(--lumo-secondary-text-color);
    --vaadin-charts-data-label: var(--lumo-body-text-color);
    --vaadin-charts-secondary-label: var(--lumo-secondary-text-color);
    --vaadin-charts-axis-line: var(--lumo-contrast-5pct);
    --vaadin-charts-grid-line: var(--lumo-contrast-20pct);
    --vaadin-charts-disabled-label: var(--lumo-disabled-text-color);
    --vaadin-charts-contrast: var(--lumo-contrast);
    --vaadin-charts-contrast-5pct: var(--lumo-contrast-5pct);
    --vaadin-charts-contrast-10pct: var(--lumo-contrast-10pct);
    --vaadin-charts-contrast-20pct: var(--lumo-contrast-20pct);
    --vaadin-charts-contrast-60pct: var(--lumo-contrast-60pct);
    --vaadin-charts-tooltip-background: var(--lumo-base-color);
    --vaadin-charts-tooltip-border-color: inherit;
    --vaadin-charts-button-label: var(--lumo-primary-text-color);
    --vaadin-charts-button-background: var(--lumo-contrast-5pct);
    --vaadin-charts-button-hover-background: var(--lumo-primary-color-10pct);
    --vaadin-charts-button-active-label: var(--lumo-primary-contrast-color);
    --vaadin-charts-button-active-background: var(--lumo-primary-color);
    --vaadin-charts-xaxis-line-width: 0;
    --vaadin-charts-tooltip-background-opacity: 1;
    font-family: var(--lumo-font-family);
  }
`;registerStyles$1("vaadin-chart",[chartColors,chartTheme],{moduleId:"lumo-chart"});var w=typeof win<"u"?win:typeof window<"u"?window:{},Globals;(function(j){j.SVG_NS="http://www.w3.org/2000/svg",j.product="Highcharts",j.version="9.2.2",j.win=w,j.doc=j.win.document,j.svg=j.doc&&j.doc.createElementNS&&!!j.doc.createElementNS(j.SVG_NS,"svg").createSVGRect,j.userAgent=j.win.navigator&&j.win.navigator.userAgent||"",j.isChrome=j.userAgent.indexOf("Chrome")!==-1,j.isFirefox=j.userAgent.indexOf("Firefox")!==-1,j.isMS=/(edge|msie|trident)/i.test(j.userAgent)&&!j.win.opera,j.isSafari=!j.isChrome&&j.userAgent.indexOf("Safari")!==-1,j.isTouchDevice=/(Mobile|Android|Windows Phone)/.test(j.userAgent),j.isWebKit=j.userAgent.indexOf("AppleWebKit")!==-1,j.deg2rad=Math.PI*2/360,j.hasBidiBug=j.isFirefox&&parseInt(j.userAgent.split("Firefox/")[1],10)<4,j.hasTouch=!!j.win.TouchEvent,j.marginNames=["plotTop","marginRight","marginBottom","plotLeft"],j.noop=function(){},j.supportsPassiveEvents=function(){var E=!1;if(!j.isMS){var a=Object.defineProperty({},"passive",{get:function(){E=!0}});j.win.addEventListener&&j.win.removeEventListener&&(j.win.addEventListener("testPassive",j.noop,a),j.win.removeEventListener("testPassive",j.noop,a))}return E}(),j.charts=[],j.dateFormats={},j.seriesTypes={},j.symbolSizes={},j.chartCount=0})(Globals||(Globals={}));const H=Globals;var charts$5=H.charts,doc$m=H.doc,win$g=H.win;function error$a(j,E,a,k){var tt=E?"Highcharts error":"Highcharts warning";j===32&&(j=tt+": Deprecated member");var et=isNumber$R(j),rt=et?tt+" #"+j+": www.highcharts.com/errors/"+j+"/":j.toString(),nt=function(){if(E)throw new Error(rt);win$g.console&&error$a.messages.indexOf(rt)===-1&&console.warn(rt)};if(typeof k<"u"){var ot="";et&&(rt+="?"),objectEach$B(k,function(st,lt){ot+=`
 - `+lt+": "+st,et&&(rt+=encodeURI(lt)+"="+encodeURI(st))}),rt+=ot}fireEvent$B(H,"displayError",{chart:a,code:j,message:rt,params:k},nt),error$a.messages.push(rt)}(function(j){j.messages=[]})(error$a||(error$a={}));function merge$1p(){var j,E=arguments,a={},k=function(et,rt){return typeof et!="object"&&(et={}),objectEach$B(rt,function(nt,ot){ot==="__proto__"||ot==="constructor"||(isObject$f(nt,!0)&&!isClass(nt)&&!isDOMElement(nt)?et[ot]=k(et[ot]||{},nt):et[ot]=rt[ot])}),et};E[0]===!0&&(a=E[1],E=Array.prototype.slice.call(E,2));var tt=E.length;for(j=0;j<tt;j++)a=k(a,E[j]);return a}function clamp$k(j,E,a){return j>E?j<a?j:a:E}function cleanRecursively$2(j,E){var a={};return objectEach$B(j,function(k,tt){var et;isObject$f(j[tt],!0)&&!j.nodeType&&E[tt]?(et=cleanRecursively$2(j[tt],E[tt]),Object.keys(et).length&&(a[tt]=et)):(isObject$f(j[tt])||j[tt]!==E[tt])&&(a[tt]=j[tt])}),a}function pInt$a(j,E){return parseInt(j,E||10)}function isString$c(j){return typeof j=="string"}function isArray$n(j){var E=Object.prototype.toString.call(j);return E==="[object Array]"||E==="[object Array Iterator]"}function isObject$f(j,E){return!!j&&typeof j=="object"&&(!E||!isArray$n(j))}function isDOMElement(j){return isObject$f(j)&&typeof j.nodeType=="number"}function isClass(j){var E=j&&j.constructor;return!!(isObject$f(j,!0)&&!isDOMElement(j)&&E&&E.name&&E.name!=="Object")}function isNumber$R(j){return typeof j=="number"&&!isNaN(j)&&j<1/0&&j>-1/0}function erase$9(j,E){for(var a=j.length;a--;)if(j[a]===E){j.splice(a,1);break}}function defined$W(j){return typeof j<"u"&&j!==null}function attr$8(j,E,a){var k;return isString$c(E)?defined$W(a)?j.setAttribute(E,a):j&&j.getAttribute&&(k=j.getAttribute(E),!k&&E==="class"&&(k=j.getAttribute(E+"Name"))):objectEach$B(E,function(tt,et){j.setAttribute(et,tt)}),k}function splat$j(j){return isArray$n(j)?j:[j]}function syncTimeout$9(j,E,a){return E>0?setTimeout(j,E,a):(j.call(0,a),-1)}function internalClearTimeout(j){defined$W(j)&&clearTimeout(j)}function extend$1u(j,E){var a;j||(j={});for(a in E)j[a]=E[a];return j}function pick$1B(){for(var j=arguments,E=j.length,a=0;a<E;a++){var k=j[a];if(typeof k<"u"&&k!==null)return k}}function css$d(j,E){H.isMS&&!H.svg&&E&&typeof E.opacity<"u"&&(E.filter="alpha(opacity="+E.opacity*100+")"),extend$1u(j.style,E)}function createElement$b(j,E,a,k,tt){var et=doc$m.createElement(j);return E&&extend$1u(et,E),tt&&css$d(et,{padding:"0",border:"none",margin:"0"}),a&&css$d(et,a),k&&k.appendChild(et),et}function extendClass$2(j,E){var a=function(){};return a.prototype=new j,extend$1u(a.prototype,E),a}function pad$2(j,E,a){return new Array((E||2)+1-String(j).replace("-","").length).join(a||"0")+j}function relativeLength$a(j,E,a){return/%$/.test(j)?E*parseFloat(j)/100+(a||0):parseFloat(j)}function wrap$d(j,E,a){var k=j[E];j[E]=function(){var tt=Array.prototype.slice.call(arguments),et=arguments,rt=this;rt.proceed=function(){k.apply(rt,arguments.length?arguments:et)},tt.unshift(k);var nt=a.apply(this,tt);return rt.proceed=null,nt}}function getMagnitude$3(j){return Math.pow(10,Math.floor(Math.log(j)/Math.LN10))}function normalizeTickInterval$3(j,E,a,k,tt){var et,rt=j;a=pick$1B(a,1);var nt=j/a;for(E||(E=tt?[1,1.2,1.5,2,2.5,3,4,5,6,8,10]:[1,2,2.5,5,10],k===!1&&(a===1?E=E.filter(function(ot){return ot%1===0}):a<=.1&&(E=[1/a]))),et=0;et<E.length&&(rt=E[et],!(tt&&rt*a>=j||!tt&&nt<=(E[et]+(E[et+1]||E[et]))/2));et++);return rt=correctFloat$d(rt*a,-Math.round(Math.log(.001)/Math.LN10)),rt}function stableSort$7(j,E){var a=j.length,k,tt;for(tt=0;tt<a;tt++)j[tt].safeI=tt;for(j.sort(function(et,rt){return k=E(et,rt),k===0?et.safeI-rt.safeI:k}),tt=0;tt<a;tt++)delete j[tt].safeI}function arrayMin$9(j){for(var E=j.length,a=j[0];E--;)j[E]<a&&(a=j[E]);return a}function arrayMax$a(j){for(var E=j.length,a=j[0];E--;)j[E]>a&&(a=j[E]);return a}function destroyObjectProperties$a(j,E){objectEach$B(j,function(a,k){a&&a!==E&&a.destroy&&a.destroy(),delete j[k]})}function discardElement$7(j){garbageBin||(garbageBin=createElement$b("div")),j&&garbageBin.appendChild(j),garbageBin.innerHTML=""}var garbageBin;function correctFloat$d(j,E){return parseFloat(j.toPrecision(E||14))}var timeUnits$3={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:24*36e5,week:7*24*36e5,month:28*24*36e5,year:364*24*36e5};Math.easeInOutSine=function(j){return-.5*(Math.cos(Math.PI*j)-1)};function getNestedProperty$3(j,E){for(var a=j.split(".");a.length&&defined$W(E);){var k=a.shift();if(typeof k>"u"||k==="__proto__")return;var tt=E[k];if(!defined$W(tt)||typeof tt=="function"||typeof tt.nodeType=="number"||tt===win$g)return;E=tt}return E}function getStyle$2(j,E,a){var k=H.getStyle||getStyle$2,tt;if(E==="width"){var et=Math.min(j.offsetWidth,j.scrollWidth),rt=j.getBoundingClientRect&&j.getBoundingClientRect().width;return rt<et&&rt>=et-1&&(et=Math.floor(rt)),Math.max(0,et-(k(j,"padding-left",!0)||0)-(k(j,"padding-right",!0)||0))}if(E==="height")return Math.max(0,Math.min(j.offsetHeight,j.scrollHeight)-(k(j,"padding-top",!0)||0)-(k(j,"padding-bottom",!0)||0));win$g.getComputedStyle||error$a(27,!0);var nt=win$g.getComputedStyle(j,void 0);return nt&&(tt=nt.getPropertyValue(E),pick$1B(a,E!=="opacity")&&(tt=pInt$a(tt))),tt}function inArray(j,E,a){return error$a(32,!1,void 0,{"Highcharts.inArray":"use Array.indexOf"}),E.indexOf(j,a)}var find$j=Array.prototype.find?function(j,E){return j.find(E)}:function(j,E){var a,k=j.length;for(a=0;a<k;a++)if(E(j[a],a))return j[a]};function keys(j){return error$a(32,!1,void 0,{"Highcharts.keys":"use Object.keys"}),Object.keys(j)}function offset$1(j){var E=doc$m.documentElement,a=j.parentElement||j.parentNode?j.getBoundingClientRect():{top:0,left:0,width:0,height:0};return{top:a.top+(win$g.pageYOffset||E.scrollTop)-(E.clientTop||0),left:a.left+(win$g.pageXOffset||E.scrollLeft)-(E.clientLeft||0),width:a.width,height:a.height}}function objectEach$B(j,E,a){for(var k in j)Object.hasOwnProperty.call(j,k)&&E.call(a||j[k],j[k],k,j)}objectEach$B({map:"map",each:"forEach",grep:"filter",reduce:"reduce",some:"some"},function(j,E){H[E]=function(a){var k;return error$a(32,!1,void 0,(k={},k["Highcharts."+E]="use Array."+j,k)),Array.prototype[j].apply(a,[].slice.call(arguments,1))}});function addEvent$12(j,E,a,k){k===void 0&&(k={});var tt=typeof j=="function"&&j.prototype||j;Object.hasOwnProperty.call(tt,"hcEvents")||(tt.hcEvents={});var et=tt.hcEvents;H.Point&&j instanceof H.Point&&j.series&&j.series.chart&&(j.series.chart.runTrackerClick=!0);var rt=j.addEventListener||H.addEventListenerPolyfill;rt&&rt.call(j,E,a,H.supportsPassiveEvents?{passive:k.passive===void 0?E.indexOf("touch")!==-1:k.passive,capture:!1}:!1),et[E]||(et[E]=[]);var nt={fn:a,order:typeof k.order=="number"?k.order:1/0};return et[E].push(nt),et[E].sort(function(ot,st){return ot.order-st.order}),function(){removeEvent$c(j,E,a)}}function removeEvent$c(j,E,a){function k(ot,st){var lt=j.removeEventListener||H.removeEventListenerPolyfill;lt&&lt.call(j,ot,st,!1)}function tt(ot){var st,lt;j.nodeName&&(E?(st={},st[E]=!0):st=ot,objectEach$B(st,function(ht,ut){if(ot[ut])for(lt=ot[ut].length;lt--;)k(ut,ot[ut][lt].fn)}))}var et=typeof j=="function"&&j.prototype||j;if(Object.hasOwnProperty.call(et,"hcEvents")){var rt=et.hcEvents;if(E){var nt=rt[E]||[];a?(rt[E]=nt.filter(function(ot){return a!==ot.fn}),k(E,a)):(tt(rt),rt[E]=[])}else tt(rt),delete et.hcEvents}}function fireEvent$B(j,E,a,k){var tt;if(a=a||{},doc$m.createEvent&&(j.dispatchEvent||j.fireEvent&&j!==H))tt=doc$m.createEvent("Events"),tt.initEvent(E,!0,!0),a=extend$1u(tt,a),j.dispatchEvent?j.dispatchEvent(a):j.fireEvent(E,a);else if(j.hcEvents){a.target||extend$1u(a,{preventDefault:function(){a.defaultPrevented=!0},target:j,type:E});for(var et=[],rt=j,nt=!1;rt.hcEvents;)Object.hasOwnProperty.call(rt,"hcEvents")&&rt.hcEvents[E]&&(et.length&&(nt=!0),et.unshift.apply(et,rt.hcEvents[E])),rt=Object.getPrototypeOf(rt);nt&&et.sort(function(ot,st){return ot.order-st.order}),et.forEach(function(ot){ot.fn.call(j,a)===!1&&a.preventDefault()})}k&&!a.defaultPrevented&&k.call(j,a)}var serialMode,uniqueKey$8=function(){var j=Math.random().toString(36).substring(2,9)+"-",E=0;return function(){return"highcharts-"+(serialMode?"":j)+E++}}();function useSerialIds(j){return serialMode=pick$1B(j,serialMode)}function isFunction$5(j){return typeof j=="function"}win$g.jQuery&&(win$g.jQuery.fn.highcharts=function(){var j=[].slice.call(arguments);if(this[0])return j[0]?(new H[isString$c(j[0])?j.shift():"Chart"](this[0],j[0],j[1]),this):charts$5[attr$8(this[0],"data-highcharts-chart")]});var Utilities={addEvent:addEvent$12,arrayMax:arrayMax$a,arrayMin:arrayMin$9,attr:attr$8,clamp:clamp$k,cleanRecursively:cleanRecursively$2,clearTimeout:internalClearTimeout,correctFloat:correctFloat$d,createElement:createElement$b,css:css$d,defined:defined$W,destroyObjectProperties:destroyObjectProperties$a,discardElement:discardElement$7,erase:erase$9,error:error$a,extend:extend$1u,extendClass:extendClass$2,find:find$j,fireEvent:fireEvent$B,getMagnitude:getMagnitude$3,getNestedProperty:getNestedProperty$3,getStyle:getStyle$2,inArray,isArray:isArray$n,isClass,isDOMElement,isFunction:isFunction$5,isNumber:isNumber$R,isObject:isObject$f,isString:isString$c,keys,merge:merge$1p,normalizeTickInterval:normalizeTickInterval$3,objectEach:objectEach$B,offset:offset$1,pad:pad$2,pick:pick$1B,pInt:pInt$a,relativeLength:relativeLength$a,removeEvent:removeEvent$c,splat:splat$j,stableSort:stableSort$7,syncTimeout:syncTimeout$9,timeUnits:timeUnits$3,uniqueKey:uniqueKey$8,useSerialIds,wrap:wrap$d},palette={colors:["#7cb5ec","#434348","#90ed7d","#f7a35c","#8085e9","#f15c80","#e4d354","#2b908f","#f45b5b","#91e8e1"],backgroundColor:"#ffffff",neutralColor100:"#000000",neutralColor80:"#333333",neutralColor60:"#666666",neutralColor40:"#999999",neutralColor20:"#cccccc",neutralColor10:"#e6e6e6",neutralColor5:"#f2f2f2",neutralColor3:"#f7f7f7",highlightColor100:"#003399",highlightColor80:"#335cad",highlightColor60:"#6685c2",highlightColor20:"#ccd6eb",highlightColor10:"#e6ebf5",positiveColor:"#06b535",negativeColor:"#f21313"},ChartDefaults={panning:{enabled:!1,type:"x"},styledMode:!1,borderRadius:0,colorCount:10,defaultSeriesType:"line",ignoreHiddenSeries:!0,spacing:[10,10,15,10],resetZoomButton:{theme:{zIndex:6},position:{align:"right",x:-10,y:10}},zoomBySingleTouch:!1,width:null,height:null,borderColor:palette.highlightColor80,backgroundColor:palette.backgroundColor,plotBorderColor:palette.neutralColor20},isNumber$Q=Utilities.isNumber,merge$1o=Utilities.merge,pInt$9=Utilities.pInt,Color=function(){function j(E){this.rgba=[NaN,NaN,NaN,NaN],this.input=E;var a=H.Color;if(a&&a!==j)return new a(E);if(!(this instanceof j))return new j(E);this.init(E)}return j.parse=function(E){return E?new j(E):j.None},j.prototype.init=function(E){var a,k,tt,et;if(typeof E=="object"&&typeof E.stops<"u")this.stops=E.stops.map(function(ot){return new j(ot[1])});else if(typeof E=="string"){if(this.input=E=j.names[E.toLowerCase()]||E,E.charAt(0)==="#"){var rt=E.length,nt=parseInt(E.substr(1),16);rt===7?k=[(nt&16711680)>>16,(nt&65280)>>8,nt&255,1]:rt===4&&(k=[(nt&3840)>>4|(nt&3840)>>8,(nt&240)>>4|nt&240,(nt&15)<<4|nt&15,1])}if(!k)for(tt=j.parsers.length;tt--&&!k;)et=j.parsers[tt],a=et.regex.exec(E),a&&(k=et.parse(a))}k&&(this.rgba=k)},j.prototype.get=function(E){var a=this.input,k=this.rgba;if(typeof a=="object"&&typeof this.stops<"u"){var tt=merge$1o(a);return tt.stops=[].slice.call(tt.stops),this.stops.forEach(function(et,rt){tt.stops[rt]=[tt.stops[rt][0],et.get(E)]}),tt}return k&&isNumber$Q(k[0])?E==="rgb"||!E&&k[3]===1?"rgb("+k[0]+","+k[1]+","+k[2]+")":E==="a"?""+k[3]:"rgba("+k.join(",")+")":a},j.prototype.brighten=function(E){var a=this.rgba;if(this.stops)this.stops.forEach(function(tt){tt.brighten(E)});else if(isNumber$Q(E)&&E!==0)for(var k=0;k<3;k++)a[k]+=pInt$9(E*255),a[k]<0&&(a[k]=0),a[k]>255&&(a[k]=255);return this},j.prototype.setOpacity=function(E){return this.rgba[3]=E,this},j.prototype.tweenTo=function(E,a){var k=this.rgba,tt=E.rgba;if(!isNumber$Q(k[0])||!isNumber$Q(tt[0]))return E.input||"none";var et=tt[3]!==1||k[3]!==1;return(et?"rgba(":"rgb(")+Math.round(tt[0]+(k[0]-tt[0])*(1-a))+","+Math.round(tt[1]+(k[1]-tt[1])*(1-a))+","+Math.round(tt[2]+(k[2]-tt[2])*(1-a))+(et?","+(tt[3]+(k[3]-tt[3])*(1-a)):"")+")"},j.names={white:"#ffffff",black:"#000000"},j.parsers=[{regex:/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]?(?:\.[0-9]+)?)\s*\)/,parse:function(E){return[pInt$9(E[1]),pInt$9(E[2]),pInt$9(E[3]),parseFloat(E[4],10)]}},{regex:/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/,parse:function(E){return[pInt$9(E[1]),pInt$9(E[2]),pInt$9(E[3]),1]}}],j.None=new j(""),j}(),win$f=H.win,defined$V=Utilities.defined,error$9=Utilities.error,extend$1t=Utilities.extend,isObject$e=Utilities.isObject,merge$1n=Utilities.merge,objectEach$A=Utilities.objectEach,pad$1=Utilities.pad,pick$1A=Utilities.pick,splat$i=Utilities.splat,timeUnits$2=Utilities.timeUnits,hasNewSafariBug=H.isSafari&&win$f.Intl&&win$f.Intl.DateTimeFormat.prototype.formatRange,hasOldSafariBug=H.isSafari&&win$f.Intl&&!win$f.Intl.DateTimeFormat.prototype.formatRange,Time=function(){function j(E){this.options={},this.useUTC=!1,this.variableTimezone=!1,this.Date=win$f.Date,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.update(E)}return j.prototype.get=function(E,a){if(this.variableTimezone||this.timezoneOffset){var k=a.getTime(),tt=k-this.getTimezoneOffset(a);a.setTime(tt);var et=a["getUTC"+E]();return a.setTime(k),et}return this.useUTC?a["getUTC"+E]():a["get"+E]()},j.prototype.set=function(E,a,k){if(this.variableTimezone||this.timezoneOffset){if(E==="Milliseconds"||E==="Seconds"||E==="Minutes"&&this.getTimezoneOffset(a)%36e5===0)return a["setUTC"+E](k);var tt=this.getTimezoneOffset(a),et=a.getTime()-tt;a.setTime(et),a["setUTC"+E](k);var rt=this.getTimezoneOffset(a);return et=a.getTime()+rt,a.setTime(et)}return this.useUTC||hasNewSafariBug&&E==="FullYear"?a["setUTC"+E](k):a["set"+E](k)},j.prototype.update=function(E){var a=pick$1A(E&&E.useUTC,!0);this.options=E=merge$1n(!0,this.options||{},E),this.Date=E.Date||win$f.Date||Date,this.useUTC=a,this.timezoneOffset=a&&E.timezoneOffset,this.getTimezoneOffset=this.timezoneOffsetFunction(),this.variableTimezone=a&&!!(E.getTimezoneOffset||E.timezone)},j.prototype.makeTime=function(E,a,k,tt,et,rt){var nt,ot,st;return this.useUTC?(nt=this.Date.UTC.apply(0,arguments),ot=this.getTimezoneOffset(nt),nt+=ot,st=this.getTimezoneOffset(nt),ot!==st?nt+=st-ot:ot-36e5===this.getTimezoneOffset(nt-36e5)&&!hasOldSafariBug&&(nt-=36e5)):nt=new this.Date(E,a,pick$1A(k,1),pick$1A(tt,0),pick$1A(et,0),pick$1A(rt,0)).getTime(),nt},j.prototype.timezoneOffsetFunction=function(){var E=this,a=this.options,k=a.moment||win$f.moment;if(!this.useUTC)return function(tt){return new Date(tt.toString()).getTimezoneOffset()*6e4};if(a.timezone)if(!k)error$9(25);else return function(tt){return-k.tz(tt,a.timezone).utcOffset()*6e4};return this.useUTC&&a.getTimezoneOffset?function(tt){return a.getTimezoneOffset(tt.valueOf())*6e4}:function(){return(E.timezoneOffset||0)*6e4}},j.prototype.dateFormat=function(E,a,k){if(!defined$V(a)||isNaN(a))return H.defaultOptions.lang&&H.defaultOptions.lang.invalidDate||"";E=pick$1A(E,"%Y-%m-%d %H:%M:%S");var tt=this,et=new this.Date(a),rt=this.get("Hours",et),nt=this.get("Day",et),ot=this.get("Date",et),st=this.get("Month",et),lt=this.get("FullYear",et),ht=H.defaultOptions.lang,ut=ht&&ht.weekdays,dt=ht&&ht.shortWeekdays,ft=extend$1t({a:dt?dt[nt]:ut[nt].substr(0,3),A:ut[nt],d:pad$1(ot),e:pad$1(ot,2," "),w:nt,b:ht.shortMonths[st],B:ht.months[st],m:pad$1(st+1),o:st+1,y:lt.toString().substr(2,2),Y:lt,H:pad$1(rt),k:rt,I:pad$1(rt%12||12),l:rt%12||12,M:pad$1(this.get("Minutes",et)),p:rt<12?"AM":"PM",P:rt<12?"am":"pm",S:pad$1(et.getSeconds()),L:pad$1(Math.floor(a%1e3),3)},H.dateFormats);return objectEach$A(ft,function(pt,gt){for(;E.indexOf("%"+gt)!==-1;)E=E.replace("%"+gt,typeof pt=="function"?pt.call(tt,a):pt)}),k?E.substr(0,1).toUpperCase()+E.substr(1):E},j.prototype.resolveDTLFormat=function(E){return isObject$e(E,!0)?E:(E=splat$i(E),{main:E[0],from:E[1],to:E[2]})},j.prototype.getTimeTicks=function(E,a,k,tt){var et=this,rt=et.Date,nt=[],ot={},st=new rt(a),lt=E.unitRange,ht=E.count||1,ut,dt,ft,pt;if(tt=pick$1A(tt,1),defined$V(a)){et.set("Milliseconds",st,lt>=timeUnits$2.second?0:ht*Math.floor(et.get("Milliseconds",st)/ht)),lt>=timeUnits$2.second&&et.set("Seconds",st,lt>=timeUnits$2.minute?0:ht*Math.floor(et.get("Seconds",st)/ht)),lt>=timeUnits$2.minute&&et.set("Minutes",st,lt>=timeUnits$2.hour?0:ht*Math.floor(et.get("Minutes",st)/ht)),lt>=timeUnits$2.hour&&et.set("Hours",st,lt>=timeUnits$2.day?0:ht*Math.floor(et.get("Hours",st)/ht)),lt>=timeUnits$2.day&&et.set("Date",st,lt>=timeUnits$2.month?1:Math.max(1,ht*Math.floor(et.get("Date",st)/ht))),lt>=timeUnits$2.month&&(et.set("Month",st,lt>=timeUnits$2.year?0:ht*Math.floor(et.get("Month",st)/ht)),dt=et.get("FullYear",st)),lt>=timeUnits$2.year&&(dt-=dt%ht,et.set("FullYear",st,dt)),lt===timeUnits$2.week&&(pt=et.get("Day",st),et.set("Date",st,et.get("Date",st)-pt+tt+(pt<tt?-7:0))),dt=et.get("FullYear",st);var gt=et.get("Month",st),yt=et.get("Date",st),mt=et.get("Hours",st);a=st.getTime(),(et.variableTimezone||!et.useUTC)&&defined$V(k)&&(ft=k-a>4*timeUnits$2.month||et.getTimezoneOffset(a)!==et.getTimezoneOffset(k));var xt=st.getTime();for(ut=1;xt<k;)nt.push(xt),lt===timeUnits$2.year?xt=et.makeTime(dt+ut*ht,0):lt===timeUnits$2.month?xt=et.makeTime(dt,gt+ut*ht):ft&&(lt===timeUnits$2.day||lt===timeUnits$2.week)?xt=et.makeTime(dt,gt,yt+ut*ht*(lt===timeUnits$2.day?1:7)):ft&&lt===timeUnits$2.hour&&ht>1?xt=et.makeTime(dt,gt,yt,mt+ut*ht):xt+=lt*ht,ut++;nt.push(xt),lt<=timeUnits$2.hour&&nt.length<1e4&&nt.forEach(function(wt){wt%18e5===0&&et.dateFormat("%H%M%S%L",wt)==="000000000"&&(ot[wt]="day")})}return nt.info=extend$1t(E,{higherRanks:ot,totalRange:lt*ht}),nt},j.prototype.getDateFormat=function(E,a,k,tt){var et=this.dateFormat("%m-%d %H:%M:%S.%L",a),rt="01-01 00:00:00.000",nt={millisecond:15,second:12,minute:9,hour:6,day:3},ot,st,lt="millisecond";for(st in timeUnits$2){if(E===timeUnits$2.week&&+this.dateFormat("%w",a)===k&&et.substr(6)===rt.substr(6)){st="week";break}if(timeUnits$2[st]>E){st=lt;break}if(nt[st]&&et.substr(nt[st])!==rt.substr(nt[st]))break;st!=="week"&&(lt=st)}return st&&(ot=this.resolveDTLFormat(tt[st]).main),ot},j}(),color$g=Color.parse,isTouchDevice$4=H.isTouchDevice,svg$5=H.svg,merge$1m=Utilities.merge,defaultOptions$g={colors:palette.colors,symbols:["circle","diamond","square","triangle","triangle-down"],lang:{loading:"Loading...",months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],decimalPoint:".",numericSymbols:["k","M","G","T","P","E"],resetZoom:"Reset zoom",resetZoomTitle:"Reset zoom level 1:1",thousandsSep:" "},global:{},time:{Date:void 0,getTimezoneOffset:void 0,timezone:void 0,timezoneOffset:0,useUTC:!0},chart:ChartDefaults,title:{text:"Chart title",align:"center",margin:15,widthAdjust:-44},subtitle:{text:"",align:"center",widthAdjust:-44},caption:{margin:15,text:"",align:"left",verticalAlign:"bottom"},plotOptions:{},labels:{style:{position:"absolute",color:palette.neutralColor80}},legend:{enabled:!0,align:"center",alignColumns:!0,className:"highcharts-no-tooltip",layout:"horizontal",labelFormatter:function(){return this.name},borderColor:palette.neutralColor40,borderRadius:0,navigation:{activeColor:palette.highlightColor100,inactiveColor:palette.neutralColor20},itemStyle:{color:palette.neutralColor80,cursor:"pointer",fontSize:"12px",fontWeight:"bold",textOverflow:"ellipsis"},itemHoverStyle:{color:palette.neutralColor100},itemHiddenStyle:{color:palette.neutralColor20},shadow:!1,itemCheckboxStyle:{position:"absolute",width:"13px",height:"13px"},squareSymbol:!0,symbolPadding:5,verticalAlign:"bottom",x:0,y:0,title:{style:{fontWeight:"bold"}}},loading:{labelStyle:{fontWeight:"bold",position:"relative",top:"45%"},style:{position:"absolute",backgroundColor:palette.backgroundColor,opacity:.5,textAlign:"center"}},tooltip:{enabled:!0,animation:svg$5,borderRadius:3,dateTimeLabelFormats:{millisecond:"%A, %b %e, %H:%M:%S.%L",second:"%A, %b %e, %H:%M:%S",minute:"%A, %b %e, %H:%M",hour:"%A, %b %e, %H:%M",day:"%A, %b %e, %Y",week:"Week from %A, %b %e, %Y",month:"%B %Y",year:"%Y"},footerFormat:"",headerShape:"callout",hideDelay:500,padding:8,shape:"callout",shared:!1,snap:isTouchDevice$4?25:10,headerFormat:'<span style="font-size: 10px">{point.key}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.y}</b><br/>',backgroundColor:color$g(palette.neutralColor3).setOpacity(.85).get(),borderWidth:1,shadow:!0,stickOnContact:!1,style:{color:palette.neutralColor80,cursor:"default",fontSize:"12px",whiteSpace:"nowrap"},useHTML:!1},credits:{enabled:!0,href:"https://www.highcharts.com?credits",position:{align:"right",x:-10,verticalAlign:"bottom",y:-5},style:{cursor:"pointer",color:palette.neutralColor40,fontSize:"9px"},text:"Highcharts.com"}};defaultOptions$g.chart.styledMode=!1;var defaultTime$2=new Time(merge$1m(defaultOptions$g.global,defaultOptions$g.time));function getOptions$3(){return defaultOptions$g}function setOptions$2(j){return merge$1m(!0,defaultOptions$g,j),(j.time||j.global)&&(H.time?H.time.update(merge$1m(defaultOptions$g.global,defaultOptions$g.time,j.global,j.time)):H.time=defaultTime$2),defaultOptions$g}var DefaultOptions={defaultOptions:defaultOptions$g,defaultTime:defaultTime$2,getOptions:getOptions$3,setOptions:setOptions$2},color$f=Color.parse,win$e=H.win,isNumber$P=Utilities.isNumber,objectEach$z=Utilities.objectEach,Fx=function(){function j(E,a,k){this.pos=NaN,this.options=a,this.elem=E,this.prop=k}return j.prototype.dSetter=function(){var E=this.paths,a=E&&E[0],k=E&&E[1],tt=this.now||0,et=[];if(tt===1||!a||!k)et=this.toD||[];else if(a.length===k.length&&tt<1)for(var rt=0;rt<k.length;rt++){for(var nt=a[rt],ot=k[rt],st=[],lt=0;lt<ot.length;lt++){var ht=nt[lt],ut=ot[lt];isNumber$P(ht)&&isNumber$P(ut)&&!(ot[0]==="A"&&(lt===4||lt===5))?st[lt]=ht+tt*(ut-ht):st[lt]=ut}et.push(st)}else et=k;this.elem.attr("d",et,void 0,!0)},j.prototype.update=function(){var E=this.elem,a=this.prop,k=this.now,tt=this.options.step;this[a+"Setter"]?this[a+"Setter"]():E.attr?E.element&&E.attr(a,k,null,!0):E.style[a]=k+this.unit,tt&&tt.call(E,k,this)},j.prototype.run=function(E,a,k){var tt=this,et=tt.options,rt=function(st){return rt.stopped?!1:tt.step(st)},nt=win$e.requestAnimationFrame||function(st){setTimeout(st,13)},ot=function(){for(var st=0;st<j.timers.length;st++)j.timers[st]()||j.timers.splice(st--,1);j.timers.length&&nt(ot)};E===a&&!this.elem["forceAnimate:"+this.prop]?(delete et.curAnim[this.prop],et.complete&&Object.keys(et.curAnim).length===0&&et.complete.call(this.elem)):(this.startTime=+new Date,this.start=E,this.end=a,this.unit=k,this.now=this.start,this.pos=0,rt.elem=this.elem,rt.prop=this.prop,rt()&&j.timers.push(rt)===1&&nt(ot))},j.prototype.step=function(E){var a=+new Date,k=this.options,tt=this.elem,et=k.complete,rt=k.duration,nt=k.curAnim,ot,st;return tt.attr&&!tt.element?ot=!1:E||a>=rt+this.startTime?(this.now=this.end,this.pos=1,this.update(),nt[this.prop]=!0,st=!0,objectEach$z(nt,function(lt){lt!==!0&&(st=!1)}),st&&et&&et.call(tt),ot=!1):(this.pos=k.easing((a-this.startTime)/rt),this.now=this.start+(this.end-this.start)*this.pos,this.update(),ot=!0),ot},j.prototype.initPath=function(E,a,k){var tt=E.startX,et=E.endX,rt=k.slice(),nt=E.isArea,ot=nt?2:1,st,lt,ht,ut,dt=a&&a.slice();if(!dt)return[rt,rt];function ft(gt,yt){for(;gt.length<lt;){var mt=gt[0],xt=yt[lt-gt.length];if(xt&&mt[0]==="M"&&(xt[0]==="C"?gt[0]=["C",mt[1],mt[2],mt[1],mt[2],mt[1],mt[2]]:gt[0]=["L",mt[1],mt[2]]),gt.unshift(mt),nt){var wt=gt.pop();gt.push(gt[gt.length-1],wt)}}}function pt(gt,yt){for(;gt.length<lt;){var mt=gt[Math.floor(gt.length/ot)-1].slice();if(mt[0]==="C"&&(mt[1]=mt[5],mt[2]=mt[6]),!nt)gt.push(mt);else{var xt=gt[Math.floor(gt.length/ot)].slice();gt.splice(gt.length/2,0,mt,xt)}}}if(tt&&et&&et.length){for(ht=0;ht<tt.length;ht++)if(tt[ht]===et[0]){st=ht;break}else if(tt[0]===et[et.length-tt.length+ht]){st=ht,ut=!0;break}else if(tt[tt.length-1]===et[et.length-tt.length+ht]){st=tt.length-ht;break}typeof st>"u"&&(dt=[])}return dt.length&&isNumber$P(st)&&(lt=rt.length+st*ot,ut?(ft(dt,rt),pt(rt)):(ft(rt,dt),pt(dt))),[dt,rt]},j.prototype.fillSetter=function(){j.prototype.strokeSetter.apply(this,arguments)},j.prototype.strokeSetter=function(){this.elem.attr(this.prop,color$f(this.start).tweenTo(color$f(this.end),this.pos),null,!0)},j.timers=[],j}(),defined$U=Utilities.defined,getStyle$1=Utilities.getStyle,isArray$m=Utilities.isArray,isNumber$O=Utilities.isNumber,isObject$d=Utilities.isObject,merge$1l=Utilities.merge,objectEach$y=Utilities.objectEach,pick$1z=Utilities.pick;function setAnimation$5(j,E){E.renderer.globalAnimation=pick$1z(j,E.options.chart.animation,!0)}function animObject$c(j){return isObject$d(j)?merge$1l({duration:500,defer:0},j):{duration:j?500:0,defer:0}}function getDeferredAnimation$3(j,E,a){var k=animObject$c(E),tt=a?[a]:j.series,et=0,rt=0;tt.forEach(function(ot){var st=animObject$c(ot.options.animation);et=E&&defined$U(E.defer)?k.defer:Math.max(et,st.duration+st.defer),rt=Math.min(k.duration,st.duration)}),j.renderer.forExport&&(et=0);var nt={defer:Math.max(0,et-rt),duration:Math.min(et,rt)};return nt}function animate$2(j,E,a){var k,tt="",et,rt,nt;isObject$d(a)||(nt=arguments,a={duration:nt[2],easing:nt[3],complete:nt[4]}),isNumber$O(a.duration)||(a.duration=400),a.easing=typeof a.easing=="function"?a.easing:Math[a.easing]||Math.easeInOutSine,a.curAnim=merge$1l(E),objectEach$y(E,function(ot,st){stop$2(j,st),rt=new Fx(j,a,st),et=void 0,st==="d"&&isArray$m(E.d)?(rt.paths=rt.initPath(j,j.pathArray,E.d),rt.toD=E.d,k=0,et=1):j.attr?k=j.attr(st):(k=parseFloat(getStyle$1(j,st))||0,st!=="opacity"&&(tt="px")),et||(et=ot),typeof et=="string"&&et.match("px")&&(et=et.replace(/px/g,"")),rt.run(k,et,tt)})}function stop$2(j,E){for(var a=Fx.timers.length;a--;)Fx.timers[a].elem===j&&(!E||E===Fx.timers[a].prop)&&(Fx.timers[a].stopped=!0)}var animationExports={animate:animate$2,animObject:animObject$c,getDeferredAnimation:getDeferredAnimation$3,setAnimation:setAnimation$5,stop:stop$2},SVG_NS$3=H.SVG_NS,attr$7=Utilities.attr,createElement$a=Utilities.createElement,discardElement$6=Utilities.discardElement,error$8=Utilities.error,isString$b=Utilities.isString,objectEach$x=Utilities.objectEach,splat$h=Utilities.splat,hasValidDOMParser=function(){try{return Boolean(new DOMParser().parseFromString("","text/html"))}catch{return!1}}(),AST=function(){function j(E){this.nodes=typeof E=="string"?this.parseMarkup(E):E}return j.filterUserAttributes=function(E){return objectEach$x(E,function(a,k){var tt=!0;j.allowedAttributes.indexOf(k)===-1&&(tt=!1),["background","dynsrc","href","lowsrc","src"].indexOf(k)!==-1&&(tt=isString$b(a)&&j.allowedReferences.some(function(et){return a.indexOf(et)===0})),tt||(error$8("Highcharts warning: Invalid attribute '"+k+"' in config"),delete E[k])}),E},j.setElementHTML=function(E,a){if(E.innerHTML="",a){var k=new j(a);k.addToDOM(E)}},j.prototype.addToDOM=function(E){function a(k,tt){var et;return splat$h(k).forEach(function(rt){var nt=rt.tagName,ot=rt.textContent?H.doc.createTextNode(rt.textContent):void 0,st;if(nt)if(nt==="#text")st=ot;else if(j.allowedTags.indexOf(nt)!==-1){var lt=nt==="svg"?SVG_NS$3:tt.namespaceURI||SVG_NS$3,ht=H.doc.createElementNS(lt,nt),ut=rt.attributes||{};objectEach$x(rt,function(dt,ft){ft!=="tagName"&&ft!=="attributes"&&ft!=="children"&&ft!=="textContent"&&(ut[ft]=dt)}),attr$7(ht,j.filterUserAttributes(ut)),ot&&ht.appendChild(ot),a(rt.children||[],ht),st=ht}else error$8("Highcharts warning: Invalid tagName '"+nt+"' in config");st&&tt.appendChild(st),et=st}),et}return a(this.nodes,E)},j.prototype.parseMarkup=function(E){var a=[];E=E.trim();var k,tt;hasValidDOMParser?k=new DOMParser().parseFromString(E,"text/html"):(tt=createElement$a("div"),tt.innerHTML=E,k={body:tt});var et=function(rt,nt){var ot=rt.nodeName.toLowerCase(),st={tagName:ot};ot==="#text"&&(st.textContent=rt.textContent||"");var lt=rt.attributes;if(lt){var ht={};[].forEach.call(lt,function(dt){ht[dt.name]=dt.value}),st.attributes=ht}if(rt.childNodes.length){var ut=[];[].forEach.call(rt.childNodes,function(dt){et(dt,ut)}),ut.length&&(st.children=ut)}nt.push(st)};return[].forEach.call(k.body.childNodes,function(rt){return et(rt,a)}),tt&&discardElement$6(tt),a},j.allowedAttributes=["aria-controls","aria-describedby","aria-expanded","aria-haspopup","aria-hidden","aria-label","aria-labelledby","aria-live","aria-pressed","aria-readonly","aria-roledescription","aria-selected","class","clip-path","color","colspan","cx","cy","d","dx","dy","disabled","fill","height","href","id","in","markerHeight","markerWidth","offset","opacity","orient","padding","paddingLeft","paddingRight","patternUnits","r","refX","refY","role","scope","slope","src","startOffset","stdDeviation","stroke","stroke-linecap","stroke-width","style","tableValues","result","rowspan","summary","target","tabindex","text-align","textAnchor","textLength","type","valign","width","x","x1","x2","y","y1","y2","zIndex"],j.allowedReferences=["https://","http://","mailto:","/","../","./","#"],j.allowedTags=["a","b","br","button","caption","circle","clipPath","code","dd","defs","div","dl","dt","em","feComponentTransfer","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feOffset","feMerge","feMergeNode","filter","h1","h2","h3","h4","h5","h6","hr","i","img","li","linearGradient","marker","ol","p","path","pattern","pre","rect","small","span","stop","strong","style","sub","sup","svg","table","text","thead","tbody","tspan","td","th","tr","u","ul","#text"],j}(),defaultOptions$f=DefaultOptions.defaultOptions,defaultTime$1=DefaultOptions.defaultTime,getNestedProperty$2=Utilities.getNestedProperty,isNumber$N=Utilities.isNumber,pick$1y=Utilities.pick,pInt$8=Utilities.pInt;function dateFormat(j,E,a){return defaultTime$1.dateFormat(j,E,a)}function format$e(j,E,a){for(var k="{",tt=!1,et,rt,nt,ot,st=/f$/,lt=/\.([0-9])/,ht=defaultOptions$f.lang,ut=a&&a.time||defaultTime$1,dt=a&&a.numberFormatter||numberFormat$2,ft=[];j&&(ot=j.indexOf(k),ot!==-1);){if(et=j.slice(0,ot),tt){if(rt=et.split(":"),nt=getNestedProperty$2(rt.shift()||"",E),rt.length&&typeof nt=="number")if(et=rt.join(":"),st.test(et)){var pt=parseInt((et.match(lt)||["","-1"])[1],10);nt!==null&&(nt=dt(nt,pt,ht.decimalPoint,et.indexOf(",")>-1?ht.thousandsSep:""))}else nt=ut.dateFormat(et,nt);ft.push(nt)}else ft.push(et);j=j.slice(ot+1),tt=!tt,k=tt?"}":"{"}return ft.push(j),ft.join("")}function numberFormat$2(j,E,a,k){j=+j||0,E=+E;var tt,et,rt=defaultOptions$f.lang,nt=(j.toString().split(".")[1]||"").split("e")[0].length,ot=j.toString().split("e"),st=E;E===-1?E=Math.min(nt,20):isNumber$N(E)?E&&ot[1]&&ot[1]<0&&(et=E+ +ot[1],et>=0?(ot[0]=(+ot[0]).toExponential(et).split("e")[0],E=et):(ot[0]=ot[0].split(".")[0]||0,E<20?j=(ot[0]*Math.pow(10,ot[1])).toFixed(E):j=0,ot[1]=0)):E=2;var lt=(Math.abs(ot[1]?ot[0]:j)+Math.pow(10,-Math.max(E,nt)-1)).toFixed(E),ht=String(pInt$8(lt)),ut=ht.length>3?ht.length%3:0;return a=pick$1y(a,rt.decimalPoint),k=pick$1y(k,rt.thousandsSep),tt=j<0?"-":"",tt+=ut?ht.substr(0,ut)+k:"",+ot[1]<0&&!st?tt="0":tt+=ht.substr(ut).replace(/(\d{3})(?=\d)/g,"$1"+k),E&&(tt+=a+lt.slice(-E)),ot[1]&&+tt!=0&&(tt+="e"+ot[1]),tt}var FormatUtilities={dateFormat,format:format$e,numberFormat:numberFormat$2},clamp$j=Utilities.clamp,pick$1x=Utilities.pick,stableSort$6=Utilities.stableSort,RendererUtilities;(function(j){function E(a,k,tt){var et=a,rt=et.reducedLen||k,nt=function(pt,gt){return(gt.rank||0)-(pt.rank||0)},ot=function(pt,gt){return pt.target-gt.target},st,lt=!0,ht=[],ut,dt,ft=0;for(st=a.length;st--;)ft+=a[st].size;if(ft>rt){for(stableSort$6(a,nt),st=0,ft=0;ft<=rt;)ft+=a[st].size,st++;ht=a.splice(st-1,a.length)}for(stableSort$6(a,ot),a=a.map(function(pt){return{size:pt.size,targets:[pt.target],align:pick$1x(pt.align,.5)}});lt;){for(st=a.length;st--;)ut=a[st],dt=(Math.min.apply(0,ut.targets)+Math.max.apply(0,ut.targets))/2,ut.pos=clamp$j(dt-ut.size*ut.align,0,k-ut.size);for(st=a.length,lt=!1;st--;)st>0&&a[st-1].pos+a[st-1].size>a[st].pos&&(a[st-1].size+=a[st].size,a[st-1].targets=a[st-1].targets.concat(a[st].targets),a[st-1].align=.5,a[st-1].pos+a[st-1].size>k&&(a[st-1].pos=k-a[st-1].size),a.splice(st,1),lt=!0)}return et.push.apply(et,ht),st=0,a.some(function(pt){var gt=0;return(pt.targets||[]).some(function(){return et[st].pos=pt.pos+gt,typeof tt<"u"&&Math.abs(et[st].pos-et[st].target)>tt?(et.slice(0,st+1).forEach(function(yt){return delete yt.pos}),et.reducedLen=(et.reducedLen||k)-k*.1,et.reducedLen>k*.1&&E(et,k,tt),!0):(gt+=et[st].size,st++,!1)})}),stableSort$6(et,ot),et}j.distribute=E})(RendererUtilities||(RendererUtilities={}));const R=RendererUtilities;var animate$1=animationExports.animate,animObject$b=animationExports.animObject,stop$1=animationExports.stop,deg2rad$8=H.deg2rad,doc$l=H.doc,noop$l=H.noop,svg$4=H.svg,SVG_NS$2=H.SVG_NS,win$d=H.win,addEvent$11=Utilities.addEvent,attr$6=Utilities.attr,createElement$9=Utilities.createElement,css$c=Utilities.css,defined$T=Utilities.defined,erase$8=Utilities.erase,extend$1s=Utilities.extend,fireEvent$A=Utilities.fireEvent,isArray$l=Utilities.isArray,isFunction$4=Utilities.isFunction,isNumber$M=Utilities.isNumber,isString$a=Utilities.isString,merge$1k=Utilities.merge,objectEach$w=Utilities.objectEach,pick$1w=Utilities.pick,pInt$7=Utilities.pInt,syncTimeout$8=Utilities.syncTimeout,uniqueKey$7=Utilities.uniqueKey,SVGElement=function(){function j(){this.element=void 0,this.onEvents={},this.opacity=1,this.renderer=void 0,this.SVG_NS=SVG_NS$2,this.symbolCustomAttribs=["x","y","width","height","r","start","end","innerR","anchorX","anchorY","rounded"]}return j.prototype._defaultGetter=function(E){var a=pick$1w(this[E+"Value"],this[E],this.element?this.element.getAttribute(E):null,0);return/^[\-0-9\.]+$/.test(a)&&(a=parseFloat(a)),a},j.prototype._defaultSetter=function(E,a,k){k.setAttribute(a,E)},j.prototype.add=function(E){var a=this.renderer,k=this.element,tt;return E&&(this.parentGroup=E),this.parentInverted=E&&E.inverted,typeof this.textStr<"u"&&this.element.nodeName==="text"&&a.buildText(this),this.added=!0,(!E||E.handleZ||this.zIndex)&&(tt=this.zIndexSetter()),tt||(E?E.element:a.box).appendChild(k),this.onAdd&&this.onAdd(),this},j.prototype.addClass=function(E,a){var k=a?"":this.attr("class")||"";return E=(E||"").split(/ /g).reduce(function(tt,et){return k.indexOf(et)===-1&&tt.push(et),tt},k?[k]:[]).join(" "),E!==k&&this.attr("class",E),this},j.prototype.afterSetters=function(){this.doTransform&&(this.updateTransform(),this.doTransform=!1)},j.prototype.align=function(E,a,k){var tt={},et=this.renderer,rt=et.alignedObjects,nt,ot,st,lt,ht;E?(this.alignOptions=E,this.alignByTranslate=a,(!k||isString$a(k))&&(this.alignTo=st=k||"renderer",erase$8(rt,this),rt.push(this),k=void 0)):(E=this.alignOptions,a=this.alignByTranslate,st=this.alignTo),k=pick$1w(k,et[st],st==="scrollablePlotBox"?et.plotBox:void 0,et);var ut=E.align,dt=E.verticalAlign;return nt=(k.x||0)+(E.x||0),ot=(k.y||0)+(E.y||0),ut==="right"?lt=1:ut==="center"&&(lt=2),lt&&(nt+=(k.width-(E.width||0))/lt),tt[a?"translateX":"x"]=Math.round(nt),dt==="bottom"?ht=1:dt==="middle"&&(ht=2),ht&&(ot+=(k.height-(E.height||0))/ht),tt[a?"translateY":"y"]=Math.round(ot),this[this.placed?"animate":"attr"](tt),this.placed=!0,this.alignAttr=tt,this},j.prototype.alignSetter=function(E){var a={left:"start",center:"middle",right:"end"};a[E]&&(this.alignValue=E,this.element.setAttribute("text-anchor",a[E]))},j.prototype.animate=function(E,a,k){var tt=this,et=animObject$b(pick$1w(a,this.renderer.globalAnimation,!0)),rt=et.defer;return pick$1w(doc$l.hidden,doc$l.msHidden,doc$l.webkitHidden,!1)&&(et.duration=0),et.duration!==0?(k&&(et.complete=k),syncTimeout$8(function(){tt.element&&animate$1(tt,E,et)},rt)):(this.attr(E,void 0,k),objectEach$w(E,function(nt,ot){et.step&&et.step.call(this,nt,{prop:ot,pos:1,elem:this})},this)),this},j.prototype.applyTextOutline=function(E){var a=this.element,k=E.indexOf("contrast")!==-1;k&&(E=E.replace(/contrast/g,this.renderer.getContrast(a.style.fill)));var tt=E.split(" "),et=tt[tt.length-1],rt=tt[0];if(rt&&rt!=="none"&&H.svg){this.fakeTS=!0,this.ySetter=this.xSetter,rt=rt.replace(/(^[\d\.]+)(.*?)$/g,function(st,lt,ht){return 2*Number(lt)+ht}),this.removeTextOutline();var nt=doc$l.createElementNS(SVG_NS$2,"tspan");attr$6(nt,{class:"highcharts-text-outline",fill:et,stroke:et,"stroke-width":rt,"stroke-linejoin":"round"}),[].forEach.call(a.childNodes,function(st){var lt=st.cloneNode(!0);lt.removeAttribute&&["fill","stroke","stroke-width","stroke"].forEach(function(ht){return lt.removeAttribute(ht)}),nt.appendChild(lt)});var ot=doc$l.createElementNS(SVG_NS$2,"tspan");ot.textContent="​",["x","y"].forEach(function(st){var lt=a.getAttribute(st);lt&&ot.setAttribute(st,lt)}),nt.appendChild(ot),a.insertBefore(nt,a.firstChild)}},j.prototype.attr=function(E,a,k,tt){var et=this.element,rt=this.symbolCustomAttribs,nt,ot,st=this,lt,ht;return typeof E=="string"&&typeof a<"u"&&(nt=E,E={},E[nt]=a),typeof E=="string"?st=(this[E+"Getter"]||this._defaultGetter).call(this,E,et):(objectEach$w(E,function(dt,ft){lt=!1,tt||stop$1(this,ft),this.symbolName&&rt.indexOf(ft)!==-1&&(ot||(this.symbolAttr(E),ot=!0),lt=!0),this.rotation&&(ft==="x"||ft==="y")&&(this.doTransform=!0),lt||(ht=this[ft+"Setter"]||this._defaultSetter,ht.call(this,dt,ft,et),!this.styledMode&&this.shadows&&/^(width|height|visibility|x|y|d|transform|cx|cy|r)$/.test(ft)&&this.updateShadows(ft,dt,ht))},this),this.afterSetters()),k&&k.call(this),st},j.prototype.clip=function(E){return this.attr("clip-path",E?"url("+this.renderer.url+"#"+E.id+")":"none")},j.prototype.crisp=function(E,a){var k=this;a=a||E.strokeWidth||0;var tt=Math.round(a)%2/2;return E.x=Math.floor(E.x||k.x||0)+tt,E.y=Math.floor(E.y||k.y||0)+tt,E.width=Math.floor((E.width||k.width||0)-2*tt),E.height=Math.floor((E.height||k.height||0)-2*tt),defined$T(E.strokeWidth)&&(E.strokeWidth=a),E},j.prototype.complexColor=function(E,a,k){var tt=this.renderer,et,rt,nt,ot,st,lt,ht,ut,dt,ft,pt=[],gt;fireEvent$A(this.renderer,"complexColor",{args:arguments},function(){if(E.radialGradient?rt="radialGradient":E.linearGradient&&(rt="linearGradient"),rt){if(nt=E[rt],st=tt.gradients,lt=E.stops,dt=k.radialReference,isArray$l(nt)&&(E[rt]=nt={x1:nt[0],y1:nt[1],x2:nt[2],y2:nt[3],gradientUnits:"userSpaceOnUse"}),rt==="radialGradient"&&dt&&!defined$T(nt.gradientUnits)&&(ot=nt,nt=merge$1k(nt,tt.getRadialAttr(dt,ot),{gradientUnits:"userSpaceOnUse"})),objectEach$w(nt,function(mt,xt){xt!=="id"&&pt.push(xt,mt)}),objectEach$w(lt,function(mt){pt.push(mt)}),pt=pt.join(","),st[pt])ft=st[pt].attr("id");else{nt.id=ft=uniqueKey$7();var yt=st[pt]=tt.createElement(rt).attr(nt).add(tt.defs);yt.radAttr=ot,yt.stops=[],lt.forEach(function(mt){mt[1].indexOf("rgba")===0?(et=Color.parse(mt[1]),ht=et.get("rgb"),ut=et.get("a")):(ht=mt[1],ut=1);var xt=tt.createElement("stop").attr({offset:mt[0],"stop-color":ht,"stop-opacity":ut}).add(yt);yt.stops.push(xt)})}gt="url("+tt.url+"#"+ft+")",k.setAttribute(a,gt),k.gradient=pt,E.toString=function(){return gt}}})},j.prototype.css=function(E){var a=this.styles,k={},tt=this.element,et=["textOutline","textOverflow","width"],rt,nt="",ot,st=!a;return E&&E.color&&(E.fill=E.color),a&&objectEach$w(E,function(lt,ht){a&&a[ht]!==lt&&(k[ht]=lt,st=!0)}),st&&(a&&(E=extend$1s(a,k)),E&&(E.width===null||E.width==="auto"?delete this.textWidth:tt.nodeName.toLowerCase()==="text"&&E.width&&(rt=this.textWidth=pInt$7(E.width))),this.styles=E,rt&&!svg$4&&this.renderer.forExport&&delete E.width,tt.namespaceURI===this.SVG_NS?(ot=function(lt,ht){return"-"+ht.toLowerCase()},objectEach$w(E,function(lt,ht){et.indexOf(ht)===-1&&(nt+=ht.replace(/([A-Z])/g,ot)+":"+lt+";")}),nt&&attr$6(tt,"style",nt)):css$c(tt,E),this.added&&(this.element.nodeName==="text"&&this.renderer.buildText(this),E&&E.textOutline&&this.applyTextOutline(E.textOutline))),this},j.prototype.dashstyleSetter=function(E){var a,k=this["stroke-width"];if(k==="inherit"&&(k=1),E=E&&E.toLowerCase(),E){var tt=E.replace("shortdashdotdot","3,1,1,1,1,1,").replace("shortdashdot","3,1,1,1").replace("shortdot","1,1,").replace("shortdash","3,1,").replace("longdash","8,3,").replace(/dot/g,"1,3,").replace("dash","4,3,").replace(/,$/,"").split(",");for(a=tt.length;a--;)tt[a]=""+pInt$7(tt[a])*pick$1w(k,NaN);E=tt.join(",").replace(/NaN/g,"none"),this.element.setAttribute("stroke-dasharray",E)}},j.prototype.destroy=function(){var E=this,a=E.element||{},k=E.renderer,tt=a.ownerSVGElement,et=k.isSVG&&a.nodeName==="SPAN"&&E.parentGroup||void 0,rt,nt;if(a.onclick=a.onmouseout=a.onmouseover=a.onmousemove=a.point=null,stop$1(E),E.clipPath&&tt){var ot=E.clipPath;[].forEach.call(tt.querySelectorAll("[clip-path],[CLIP-PATH]"),function(st){st.getAttribute("clip-path").indexOf(ot.element.id)>-1&&st.removeAttribute("clip-path")}),E.clipPath=ot.destroy()}if(E.stops){for(nt=0;nt<E.stops.length;nt++)E.stops[nt].destroy();E.stops.length=0,E.stops=void 0}for(E.safeRemoveChild(a),k.styledMode||E.destroyShadows();et&&et.div&&et.div.childNodes.length===0;)rt=et.parentGroup,E.safeRemoveChild(et.div),delete et.div,et=rt;E.alignTo&&erase$8(k.alignedObjects,E),objectEach$w(E,function(st,lt){E[lt]&&E[lt].parentGroup===E&&E[lt].destroy&&E[lt].destroy(),delete E[lt]})},j.prototype.destroyShadows=function(){(this.shadows||[]).forEach(function(E){this.safeRemoveChild(E)},this),this.shadows=void 0},j.prototype.destroyTextPath=function(E,a){var k=E.getElementsByTagName("text")[0],tt;if(k){if(k.removeAttribute("dx"),k.removeAttribute("dy"),a.element.setAttribute("id",""),this.textPathWrapper&&k.getElementsByTagName("textPath").length){for(tt=this.textPathWrapper.element.childNodes;tt.length;)k.appendChild(tt[0]);k.removeChild(this.textPathWrapper.element)}}else(E.getAttribute("dx")||E.getAttribute("dy"))&&(E.removeAttribute("dx"),E.removeAttribute("dy"));this.textPathWrapper&&(this.textPathWrapper=this.textPathWrapper.destroy())},j.prototype.dSetter=function(E,a,k){isArray$l(E)&&(typeof E[0]=="string"&&(E=this.renderer.pathToSegments(E)),this.pathArray=E,E=E.reduce(function(tt,et,rt){return!et||!et.join?(et||"").toString():(rt?tt+" ":"")+et.join(" ")},"")),/(NaN| {2}|^$)/.test(E)&&(E="M 0 0"),this[a]!==E&&(k.setAttribute(a,E),this[a]=E)},j.prototype.fadeOut=function(E){var a=this;a.animate({opacity:0},{duration:pick$1w(E,150),complete:function(){a.attr({y:-9999}).hide()}})},j.prototype.fillSetter=function(E,a,k){typeof E=="string"?k.setAttribute(a,E):E&&this.complexColor(E,a,k)},j.prototype.getBBox=function(E,a){var k=this,tt=k.renderer,et=k.element,rt=k.styles,nt=k.textStr,ot=tt.cache,st=tt.cacheKeys,lt=et.namespaceURI===k.SVG_NS,ht=pick$1w(a,k.rotation,0),ut=tt.styledMode?et&&j.prototype.getStyle.call(et,"font-size"):rt&&rt.fontSize,dt,ft,pt,gt,yt;if(defined$T(nt)&&(yt=nt.toString(),yt.indexOf("<")===-1&&(yt=yt.replace(/[0-9]/g,"0")),yt+=["",ht,ut,k.textWidth,rt&&rt.textOverflow,rt&&rt.fontWeight].join(",")),yt&&!E&&(dt=ot[yt]),!dt){if(lt||tt.forExport){try{gt=this.fakeTS&&function(xt){var wt=et.querySelector(".highcharts-text-outline");wt&&css$c(wt,{display:xt})},isFunction$4(gt)&&gt("none"),dt=et.getBBox?extend$1s({},et.getBBox()):{width:et.offsetWidth,height:et.offsetHeight},isFunction$4(gt)&&gt("")}catch{}(!dt||dt.width<0)&&(dt={width:0,height:0})}else dt=k.htmlGetBBox();if(tt.isSVG&&(ft=dt.width,pt=dt.height,lt&&(dt.height=pt={"11px,17":14,"13px,20":16}[rt&&rt.fontSize+","+Math.round(pt)]||pt),ht)){var mt=ht*deg2rad$8;dt.width=Math.abs(pt*Math.sin(mt))+Math.abs(ft*Math.cos(mt)),dt.height=Math.abs(pt*Math.cos(mt))+Math.abs(ft*Math.sin(mt))}if(yt&&(nt===""||dt.height>0)){for(;st.length>250;)delete ot[st.shift()];ot[yt]||st.push(yt),ot[yt]=dt}}return dt},j.prototype.getStyle=function(E){return win$d.getComputedStyle(this.element||this,"").getPropertyValue(E)},j.prototype.hasClass=function(E){return(""+this.attr("class")).split(" ").indexOf(E)!==-1},j.prototype.hide=function(E){return E?this.attr({y:-9999}):this.attr({visibility:"hidden"}),this},j.prototype.htmlGetBBox=function(){return{height:0,width:0,x:0,y:0}},j.prototype.init=function(E,a){this.element=a==="span"?createElement$9(a):doc$l.createElementNS(this.SVG_NS,a),this.renderer=E,fireEvent$A(this,"afterInit")},j.prototype.invert=function(E){return this.inverted=E,this.updateTransform(),this},j.prototype.on=function(E,a){var k=this.onEvents;return k[E]&&k[E](),k[E]=addEvent$11(this.element,E,a),this},j.prototype.opacitySetter=function(E,a,k){var tt=Number(Number(E).toFixed(3));this.opacity=tt,k.setAttribute(a,tt)},j.prototype.removeClass=function(E){return this.attr("class",(""+this.attr("class")).replace(isString$a(E)?new RegExp("(^| )"+E+"( |$)"):E," ").replace(/ +/g," ").trim())},j.prototype.removeTextOutline=function(){var E=this.element.querySelector("tspan.highcharts-text-outline");E&&this.safeRemoveChild(E)},j.prototype.safeRemoveChild=function(E){var a=E.parentNode;a&&a.removeChild(E)},j.prototype.setRadialReference=function(E){var a=this.element.gradient&&this.renderer.gradients[this.element.gradient];return this.element.radialReference=E,a&&a.radAttr&&a.animate(this.renderer.getRadialAttr(E,a.radAttr)),this},j.prototype.setTextPath=function(E,a){var k=this.element,tt=this.text?this.text.element:k,et={textAnchor:"text-anchor"},rt=!1,nt,ot,st=this.textPathWrapper,lt=!st;a=merge$1k(!0,{enabled:!0,attributes:{dy:-5,startOffset:"50%",textAnchor:"middle"}},a);var ht=AST.filterUserAttributes(a.attributes);if(E&&a&&a.enabled){if(st&&st.element.parentNode===null?(lt=!0,st=st.destroy()):st&&this.removeTextOutline.call(st.parentGroup),this.options&&this.options.padding&&(ht.dx=-this.options.padding),st||(this.textPathWrapper=st=this.renderer.createElement("textPath"),rt=!0),nt=st.element,ot=E.element.getAttribute("id"),ot||E.element.setAttribute("id",ot=uniqueKey$7()),lt){tt.setAttribute("y",0),isNumber$M(ht.dx)&&tt.setAttribute("x",-ht.dx);for(var ut=[].slice.call(tt.childNodes),dt=0;dt<ut.length;dt++){var ft=ut[dt];(ft.nodeType===Node.TEXT_NODE||ft.nodeName==="tspan")&&nt.appendChild(ft)}}rt&&st&&st.add({element:tt}),nt.setAttributeNS("http://www.w3.org/1999/xlink","href",this.renderer.url+"#"+ot),defined$T(ht.dy)&&(nt.parentNode.setAttribute("dy",ht.dy),delete ht.dy),defined$T(ht.dx)&&(nt.parentNode.setAttribute("dx",ht.dx),delete ht.dx),objectEach$w(ht,function(pt,gt){nt.setAttribute(et[gt]||gt,pt)}),k.removeAttribute("transform"),this.removeTextOutline.call(st),this.text&&!this.renderer.styledMode&&this.attr({fill:"none","stroke-width":0}),this.updateTransform=noop$l,this.applyTextOutline=noop$l}else st&&(delete this.updateTransform,delete this.applyTextOutline,this.destroyTextPath(k,E),this.updateTransform(),this.options&&this.options.rotation&&this.applyTextOutline(this.options.style.textOutline));return this},j.prototype.shadow=function(E,a,k){var tt=[],et=this.element,rt=this.oldShadowOptions,nt={color:palette.neutralColor100,offsetX:this.parentInverted?-1:1,offsetY:this.parentInverted?-1:1,opacity:.15,width:3},ot,st,lt,ht,ut=!1,dt,ft;if(E===!0?ft=nt:typeof E=="object"&&(ft=extend$1s(nt,E)),ft&&(ft&&rt&&objectEach$w(ft,function(pt,gt){pt!==rt[gt]&&(ut=!0)}),ut&&this.destroyShadows(),this.oldShadowOptions=ft),!ft)this.destroyShadows();else if(!this.shadows){for(ht=ft.opacity/ft.width,dt=this.parentInverted?"translate("+ft.offsetY+", "+ft.offsetX+")":"translate("+ft.offsetX+", "+ft.offsetY+")",ot=1;ot<=ft.width;ot++)st=et.cloneNode(!1),lt=ft.width*2+1-2*ot,attr$6(st,{stroke:E.color||palette.neutralColor100,"stroke-opacity":ht*ot,"stroke-width":lt,transform:dt,fill:"none"}),st.setAttribute("class",(st.getAttribute("class")||"")+" highcharts-shadow"),k&&(attr$6(st,"height",Math.max(attr$6(st,"height")-lt,0)),st.cutHeight=lt),a?a.element.appendChild(st):et.parentNode&&et.parentNode.insertBefore(st,et),tt.push(st);this.shadows=tt}return this},j.prototype.show=function(E){return this.attr({visibility:E?"inherit":"visible"})},j.prototype.strokeSetter=function(E,a,k){this[a]=E,this.stroke&&this["stroke-width"]?(j.prototype.fillSetter.call(this,this.stroke,"stroke",k),k.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0):a==="stroke-width"&&E===0&&this.hasStroke?(k.removeAttribute("stroke"),this.hasStroke=!1):this.renderer.styledMode&&this["stroke-width"]&&(k.setAttribute("stroke-width",this["stroke-width"]),this.hasStroke=!0)},j.prototype.strokeWidth=function(){if(!this.renderer.styledMode)return this["stroke-width"]||0;var E=this.getStyle("stroke-width"),a=0,k;return E.indexOf("px")===E.length-2?a=pInt$7(E):E!==""&&(k=doc$l.createElementNS(SVG_NS$2,"rect"),attr$6(k,{width:E,"stroke-width":0}),this.element.parentNode.appendChild(k),a=k.getBBox().width,k.parentNode.removeChild(k)),a},j.prototype.symbolAttr=function(E){var a=this;["x","y","r","start","end","width","height","innerR","anchorX","anchorY","clockwise"].forEach(function(k){a[k]=pick$1w(E[k],a[k])}),a.attr({d:a.renderer.symbols[a.symbolName](a.x,a.y,a.width,a.height,a)})},j.prototype.textSetter=function(E){E!==this.textStr&&(delete this.textPxLength,this.textStr=E,this.added&&this.renderer.buildText(this))},j.prototype.titleSetter=function(E){var a=this.element,k=a.getElementsByTagName("title")[0]||doc$l.createElementNS(this.SVG_NS,"title");a.insertBefore?a.insertBefore(k,a.firstChild):a.appendChild(k),k.textContent=String(pick$1w(E,"")).replace(/<[^>]*>/g,"").replace(/&lt;/g,"<").replace(/&gt;/g,">")},j.prototype.toFront=function(){var E=this.element;return E.parentNode.appendChild(E),this},j.prototype.translate=function(E,a){return this.attr({translateX:E,translateY:a})},j.prototype.updateShadows=function(E,a,k){var tt=this.shadows;if(tt)for(var et=tt.length;et--;)k.call(tt[et],E==="height"?Math.max(a-(tt[et].cutHeight||0),0):E==="d"?this.d:a,E,tt[et])},j.prototype.updateTransform=function(){var E=this,a=E.scaleX,k=E.scaleY,tt=E.inverted,et=E.rotation,rt=E.matrix,nt=E.element,ot=E.translateX||0,st=E.translateY||0;tt&&(ot+=E.width,st+=E.height);var lt=["translate("+ot+","+st+")"];defined$T(rt)&&lt.push("matrix("+rt.join(",")+")"),tt?lt.push("rotate(90) scale(-1,1)"):et&&lt.push("rotate("+et+" "+pick$1w(this.rotationOriginX,nt.getAttribute("x"),0)+" "+pick$1w(this.rotationOriginY,nt.getAttribute("y")||0)+")"),(defined$T(a)||defined$T(k))&&lt.push("scale("+pick$1w(a,1)+" "+pick$1w(k,1)+")"),lt.length&&nt.setAttribute("transform",lt.join(" "))},j.prototype.visibilitySetter=function(E,a,k){E==="inherit"?k.removeAttribute(a):this[a]!==E&&k.setAttribute(a,E),this[a]=E},j.prototype.xGetter=function(E){return this.element.nodeName==="circle"&&(E==="x"?E="cx":E==="y"&&(E="cy")),this._defaultGetter(E)},j.prototype.zIndexSetter=function(E,a){var k=this.renderer,tt=this.parentGroup,et=tt||k,rt=et.element||k.box,nt=this.element,ot=rt===k.box,st,lt,ht,ut=!1,dt,ft=this.added,pt;if(defined$T(E)?(nt.setAttribute("data-z-index",E),E=+E,this[a]===E&&(ft=!1)):defined$T(this[a])&&nt.removeAttribute("data-z-index"),this[a]=E,ft){for(E=this.zIndex,E&&tt&&(tt.handleZ=!0),st=rt.childNodes,pt=st.length-1;pt>=0&&!ut;pt--)lt=st[pt],ht=lt.getAttribute("data-z-index"),dt=!defined$T(ht),lt!==nt&&(E<0&&dt&&!ot&&!pt?(rt.insertBefore(nt,st[pt]),ut=!0):(pInt$7(ht)<=E||dt&&(!defined$T(E)||E>=0))&&(rt.insertBefore(nt,st[pt+1]||null),ut=!0));ut||(rt.insertBefore(nt,st[ot?3:0]||null),ut=!0)}return ut},j}();SVGElement.prototype["stroke-widthSetter"]=SVGElement.prototype.strokeSetter;SVGElement.prototype.yGetter=SVGElement.prototype.xGetter;SVGElement.prototype.matrixSetter=SVGElement.prototype.rotationOriginXSetter=SVGElement.prototype.rotationOriginYSetter=SVGElement.prototype.rotationSetter=SVGElement.prototype.scaleXSetter=SVGElement.prototype.scaleYSetter=SVGElement.prototype.translateXSetter=SVGElement.prototype.translateYSetter=SVGElement.prototype.verticalAlignSetter=function(j,E){this[E]=j,this.doTransform=!0};var RendererRegistry;(function(j){j.rendererTypes={};var E;function a(tt){return tt===void 0&&(tt=E),j.rendererTypes[tt]||j.rendererTypes[E]}j.getRendererType=a;function k(tt,et,rt){j.rendererTypes[tt]=et,(!E||rt)&&(E=tt,H.Renderer=et)}j.registerRendererType=k})(RendererRegistry||(RendererRegistry={}));const RendererRegistry$1=RendererRegistry;var __extends$2d=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),defined$S=Utilities.defined,extend$1r=Utilities.extend,isNumber$L=Utilities.isNumber,merge$1j=Utilities.merge,pick$1v=Utilities.pick,removeEvent$b=Utilities.removeEvent,SVGLabel=function(j){__extends$2d(E,j);function E(a,k,tt,et,rt,nt,ot,st,lt,ht){var ut=j.call(this)||this;ut.paddingLeftSetter=ut.paddingSetter,ut.paddingRightSetter=ut.paddingSetter,ut.init(a,"g"),ut.textStr=k,ut.x=tt,ut.y=et,ut.anchorX=nt,ut.anchorY=ot,ut.baseline=lt,ut.className=ht,ut.addClass(ht==="button"?"highcharts-no-tooltip":"highcharts-label"),ht&&ut.addClass("highcharts-"+ht),ut.text=a.text(void 0,0,0,st).attr({zIndex:1});var dt;return typeof rt=="string"&&(dt=/^url\((.*?)\)$/.test(rt),(dt||ut.renderer.symbols[rt])&&(ut.symbolKey=rt)),ut.bBox=E.emptyBBox,ut.padding=3,ut.baselineOffset=0,ut.needsBox=a.styledMode||dt,ut.deferredAttr={},ut.alignFactor=0,ut}return E.prototype.alignSetter=function(a){var k={left:0,center:.5,right:1}[a];k!==this.alignFactor&&(this.alignFactor=k,this.bBox&&isNumber$L(this.xSetting)&&this.attr({x:this.xSetting}))},E.prototype.anchorXSetter=function(a,k){this.anchorX=a,this.boxAttr(k,Math.round(a)-this.getCrispAdjust()-this.xSetting)},E.prototype.anchorYSetter=function(a,k){this.anchorY=a,this.boxAttr(k,a-this.ySetting)},E.prototype.boxAttr=function(a,k){this.box?this.box.attr(a,k):this.deferredAttr[a]=k},E.prototype.css=function(a){if(a){var k={};a=merge$1j(a),E.textProps.forEach(function(rt){typeof a[rt]<"u"&&(k[rt]=a[rt],delete a[rt])}),this.text.css(k);var tt="width"in k,et="fontSize"in k||"fontWeight"in k;et?this.updateTextPadding():tt&&this.updateBoxSize()}return SVGElement.prototype.css.call(this,a)},E.prototype.destroy=function(){removeEvent$b(this.element,"mouseenter"),removeEvent$b(this.element,"mouseleave"),this.text&&this.text.destroy(),this.box&&(this.box=this.box.destroy()),SVGElement.prototype.destroy.call(this)},E.prototype.fillSetter=function(a,k){a&&(this.needsBox=!0),this.fill=a,this.boxAttr(k,a)},E.prototype.getBBox=function(){this.textStr&&this.bBox.width===0&&this.bBox.height===0&&this.updateBoxSize();var a=this.padding,k=pick$1v(this.paddingLeft,a);return{width:this.width,height:this.height,x:this.bBox.x-k,y:this.bBox.y-a}},E.prototype.getCrispAdjust=function(){return this.renderer.styledMode&&this.box?this.box.strokeWidth()%2/2:(this["stroke-width"]?parseInt(this["stroke-width"],10):0)%2/2},E.prototype.heightSetter=function(a){this.heightSetting=a},E.prototype.onAdd=function(){var a=this.textStr;this.text.add(this),this.attr({text:defined$S(a)?a:"",x:this.x,y:this.y}),this.box&&defined$S(this.anchorX)&&this.attr({anchorX:this.anchorX,anchorY:this.anchorY})},E.prototype.paddingSetter=function(a,k){isNumber$L(a)?a!==this[k]&&(this[k]=a,this.updateTextPadding()):this[k]=void 0},E.prototype.rSetter=function(a,k){this.boxAttr(k,a)},E.prototype.shadow=function(a){return a&&!this.renderer.styledMode&&(this.updateBoxSize(),this.box&&this.box.shadow(a)),this},E.prototype.strokeSetter=function(a,k){this.stroke=a,this.boxAttr(k,a)},E.prototype["stroke-widthSetter"]=function(a,k){a&&(this.needsBox=!0),this["stroke-width"]=a,this.boxAttr(k,a)},E.prototype["text-alignSetter"]=function(a){this.textAlign=a},E.prototype.textSetter=function(a){typeof a<"u"&&this.text.attr({text:a}),this.updateTextPadding()},E.prototype.updateBoxSize=function(){var a=this.text.element.style,k={},tt=this.padding,et=this.bBox=(!isNumber$L(this.widthSetting)||!isNumber$L(this.heightSetting)||this.textAlign)&&defined$S(this.text.textStr)?this.text.getBBox():E.emptyBBox,rt;this.width=this.getPaddedWidth(),this.height=(this.heightSetting||et.height||0)+2*tt;var nt=this.renderer.fontMetrics(a&&a.fontSize,this.text);if(this.baselineOffset=tt+Math.min((this.text.firstLineMetrics||nt).b,et.height||1/0),this.heightSetting&&(this.baselineOffset+=(this.heightSetting-nt.h)/2),this.needsBox){if(!this.box){var ot=this.box=this.symbolKey?this.renderer.symbol(this.symbolKey):this.renderer.rect();ot.addClass((this.className==="button"?"":"highcharts-label-box")+(this.className?" highcharts-"+this.className+"-box":"")),ot.add(this)}rt=this.getCrispAdjust(),k.x=rt,k.y=(this.baseline?-this.baselineOffset:0)+rt,k.width=Math.round(this.width),k.height=Math.round(this.height),this.box.attr(extend$1r(k,this.deferredAttr)),this.deferredAttr={}}},E.prototype.updateTextPadding=function(){var a=this.text;this.updateBoxSize();var k=this.baseline?0:this.baselineOffset,tt=pick$1v(this.paddingLeft,this.padding);defined$S(this.widthSetting)&&this.bBox&&(this.textAlign==="center"||this.textAlign==="right")&&(tt+={center:.5,right:1}[this.textAlign]*(this.widthSetting-this.bBox.width)),(tt!==a.x||k!==a.y)&&(a.attr("x",tt),a.hasBoxWidthChanged&&(this.bBox=a.getBBox(!0)),typeof k<"u"&&a.attr("y",k)),a.x=tt,a.y=k},E.prototype.widthSetter=function(a){this.widthSetting=isNumber$L(a)?a:void 0},E.prototype.getPaddedWidth=function(){var a=this.padding,k=pick$1v(this.paddingLeft,a),tt=pick$1v(this.paddingRight,a);return(this.widthSetting||this.bBox.width||0)+k+tt},E.prototype.xSetter=function(a){this.x=a,this.alignFactor&&(a-=this.alignFactor*this.getPaddedWidth(),this["forceAnimate:x"]=!0),this.xSetting=Math.round(a),this.attr("translateX",this.xSetting)},E.prototype.ySetter=function(a){this.ySetting=this.y=Math.round(a),this.attr("translateY",this.ySetting)},E.emptyBBox={width:0,height:0,x:0,y:0},E.textProps=["color","direction","fontFamily","fontSize","fontStyle","fontWeight","lineHeight","textAlign","textDecoration","textOutline","textOverflow","width"],E}(SVGElement),defined$R=Utilities.defined,isNumber$K=Utilities.isNumber,pick$1u=Utilities.pick;function arc$1(j,E,a,k,tt){var et=[];if(tt){var rt=tt.start||0,nt=pick$1u(tt.r,a),ot=pick$1u(tt.r,k||a),st=.001,lt=Math.abs((tt.end||0)-rt-2*Math.PI)<st,ht=(tt.end||0)-st,ut=tt.innerR,dt=pick$1u(tt.open,lt),ft=Math.cos(rt),pt=Math.sin(rt),gt=Math.cos(ht),yt=Math.sin(ht),mt=pick$1u(tt.longArc,ht-rt-Math.PI<st?0:1);et.push(["M",j+nt*ft,E+ot*pt],["A",nt,ot,0,mt,pick$1u(tt.clockwise,1),j+nt*gt,E+ot*yt]),defined$R(ut)&&et.push(dt?["M",j+ut*gt,E+ut*yt]:["L",j+ut*gt,E+ut*yt],["A",ut,ut,0,mt,defined$R(tt.clockwise)?1-tt.clockwise:0,j+ut*ft,E+ut*pt]),dt||et.push(["Z"])}return et}function callout(j,E,a,k,tt){var et=6,rt=6,nt=Math.min(tt&&tt.r||0,a,k),ot=nt+rt,st=tt&&tt.anchorX,lt=tt&&tt.anchorY||0,ht=roundedRect(j,E,a,k,{r:nt});return isNumber$K(st)&&(j+st>=a?lt>E+ot&&lt<E+k-ot?ht.splice(3,1,["L",j+a,lt-rt],["L",j+a+et,lt],["L",j+a,lt+rt],["L",j+a,E+k-nt]):ht.splice(3,1,["L",j+a,k/2],["L",st,lt],["L",j+a,k/2],["L",j+a,E+k-nt]):j+st<=0?lt>E+ot&&lt<E+k-ot?ht.splice(7,1,["L",j,lt+rt],["L",j-et,lt],["L",j,lt-rt],["L",j,E+nt]):ht.splice(7,1,["L",j,k/2],["L",st,lt],["L",j,k/2],["L",j,E+nt]):lt&&lt>k&&st>j+ot&&st<j+a-ot?ht.splice(5,1,["L",st+rt,E+k],["L",st,E+k+et],["L",st-rt,E+k],["L",j+nt,E+k]):lt&&lt<0&&st>j+ot&&st<j+a-ot&&ht.splice(1,1,["L",st-rt,E],["L",st,E-et],["L",st+rt,E],["L",a-nt,E])),ht}function circle(j,E,a,k){return arc$1(j+a/2,E+k/2,a/2,k/2,{start:Math.PI*.5,end:Math.PI*2.5,open:!1})}function diamond(j,E,a,k){return[["M",j+a/2,E],["L",j+a,E+k/2],["L",j+a/2,E+k],["L",j,E+k/2],["Z"]]}function rect(j,E,a,k,tt){return tt&&tt.r?roundedRect(j,E,a,k,tt):[["M",j,E],["L",j+a,E],["L",j+a,E+k],["L",j,E+k],["Z"]]}function roundedRect(j,E,a,k,tt){var et=tt&&tt.r||0;return[["M",j+et,E],["L",j+a-et,E],["C",j+a,E,j+a,E,j+a,E+et],["L",j+a,E+k-et],["C",j+a,E+k,j+a,E+k,j+a-et,E+k],["L",j+et,E+k],["C",j,E+k,j,E+k,j,E+k-et],["L",j,E+et],["C",j,E,j,E,j+et,E]]}function triangle(j,E,a,k){return[["M",j+a/2,E],["L",j+a,E+k],["L",j,E+k],["Z"]]}function triangleDown(j,E,a,k){return[["M",j,E],["L",j+a,E],["L",j+a/2,E+k],["Z"]]}var Symbols={arc:arc$1,callout,circle,diamond,rect,roundedRect,square:rect,triangle,"triangle-down":triangleDown},doc$k=H.doc,SVG_NS$1=H.SVG_NS,attr$5=Utilities.attr,isString$9=Utilities.isString,objectEach$v=Utilities.objectEach,pick$1t=Utilities.pick,TextBuilder$1=function(){function j(E){var a=E.styles;this.renderer=E.renderer,this.svgElement=E,this.width=E.textWidth,this.textLineHeight=a&&a.lineHeight,this.textOutline=a&&a.textOutline,this.ellipsis=Boolean(a&&a.textOverflow==="ellipsis"),this.noWrap=Boolean(a&&a.whiteSpace==="nowrap"),this.fontSize=a&&a.fontSize}return j.prototype.buildSVG=function(){var E=this.svgElement,a=E.element,k=E.renderer,tt=pick$1t(E.textStr,"").toString(),et=tt.indexOf("<")!==-1,rt=a.childNodes,nt=this.width&&!E.added&&k.box,ot=/<br.*?>/g,st=[tt,this.ellipsis,this.noWrap,this.textLineHeight,this.textOutline,this.fontSize,this.width].join(",");if(st!==E.textCache){E.textCache=st,delete E.actualWidth;for(var lt=rt.length;lt--;)a.removeChild(rt[lt]);if(!et&&!this.ellipsis&&!this.width&&(tt.indexOf(" ")===-1||this.noWrap&&!ot.test(tt)))a.appendChild(doc$k.createTextNode(this.unescapeEntities(tt)));else if(tt!==""){nt&&nt.appendChild(a);var ht=new AST(tt);this.modifyTree(ht.nodes),ht.addToDOM(E.element),this.modifyDOM(),this.ellipsis&&(a.textContent||"").indexOf("…")!==-1&&E.attr("title",this.unescapeEntities(E.textStr||"",["&lt;","&gt;"])),nt&&nt.removeChild(a)}isString$9(this.textOutline)&&E.applyTextOutline&&E.applyTextOutline(this.textOutline)}},j.prototype.modifyDOM=function(){var E=this,a=this.svgElement,k=attr$5(a.element,"x");a.firstLineMetrics=void 0;for(var tt;(tt=a.element.firstChild)&&/^[\s\u200B]*$/.test(tt.textContent||" ");)a.element.removeChild(tt);[].forEach.call(a.element.querySelectorAll("tspan.highcharts-br"),function(ot,st){ot.nextSibling&&ot.previousSibling&&(st===0&&ot.previousSibling.nodeType===1&&(a.firstLineMetrics=a.renderer.fontMetrics(void 0,ot.previousSibling)),attr$5(ot,{dy:E.getLineHeight(ot.nextSibling),x:k}))});var et=this.width||0;if(et){var rt=function(ot,st){var lt=ot.textContent||"",ht=lt.replace(/([^\^])-/g,"$1- ").split(" "),ut=!E.noWrap&&(ht.length>1||a.element.childNodes.length>1),dt=E.getLineHeight(st),ft=0,pt=a.actualWidth;if(E.ellipsis)lt&&E.truncate(ot,lt,void 0,0,Math.max(0,et-parseInt(E.fontSize||12,10)),function(mt,xt){return mt.substring(0,xt)+"…"});else if(ut){for(var gt=[],yt=[];st.firstChild&&st.firstChild!==ot;)yt.push(st.firstChild),st.removeChild(st.firstChild);for(;ht.length;)ht.length&&!E.noWrap&&ft>0&&(gt.push(ot.textContent||""),ot.textContent=ht.join(" ").replace(/- /g,"-")),E.truncate(ot,void 0,ht,ft===0&&pt||0,et,function(mt,xt){return ht.slice(0,xt).join(" ").replace(/- /g,"-")}),pt=a.actualWidth,ft++;yt.forEach(function(mt){st.insertBefore(mt,ot)}),gt.forEach(function(mt){st.insertBefore(doc$k.createTextNode(mt),ot);var xt=doc$k.createElementNS(SVG_NS$1,"tspan");xt.textContent="​",attr$5(xt,{dy:dt,x:k}),st.insertBefore(xt,ot)})}},nt=function(ot){var st=[].slice.call(ot.childNodes);st.forEach(function(lt){lt.nodeType===Node.TEXT_NODE?rt(lt,ot):(lt.className.baseVal.indexOf("highcharts-br")!==-1&&(a.actualWidth=0),nt(lt))})};nt(a.element)}},j.prototype.getLineHeight=function(E){var a,k=E.nodeType===Node.TEXT_NODE?E.parentElement:E;return this.renderer.styledMode||(a=k&&/(px|em)$/.test(k.style.fontSize)?k.style.fontSize:this.fontSize||this.renderer.style.fontSize||12),this.textLineHeight?parseInt(this.textLineHeight.toString(),10):this.renderer.fontMetrics(a,k||this.svgElement.element).h},j.prototype.modifyTree=function(E){var a=this,k=function(tt,et){var rt=tt.tagName,nt=a.renderer.styledMode,ot=tt.attributes||{};if(rt==="b"||rt==="strong"?nt?ot.class="highcharts-strong":ot.style="font-weight:bold;"+(ot.style||""):(rt==="i"||rt==="em")&&(nt?ot.class="highcharts-emphasized":ot.style="font-style:italic;"+(ot.style||"")),isString$9(ot.style)&&(ot.style=ot.style.replace(/(;| |^)color([ :])/,"$1fill$2")),rt==="br"){ot.class="highcharts-br",tt.textContent="​";var st=E[et+1];st&&st.textContent&&(st.textContent=st.textContent.replace(/^ +/gm,""))}rt!=="#text"&&rt!=="a"&&(tt.tagName="tspan"),tt.attributes=ot,tt.children&&tt.children.filter(function(lt){return lt.tagName!=="#text"}).forEach(k)};E.forEach(k)},j.prototype.truncate=function(E,a,k,tt,et,rt){var nt=this.svgElement,ot=nt.renderer,st=nt.rotation,lt=[],ht=k?1:0,ut=(a||k||"").length,dt=ut,ft,pt,gt=function(yt,mt){var xt=mt||yt,wt=E.parentNode;if(wt&&typeof lt[xt]>"u")if(wt.getSubStringLength)try{lt[xt]=tt+wt.getSubStringLength(0,k?xt+1:xt)}catch{}else ot.getSpanWidth&&(E.textContent=rt(a||k,yt),lt[xt]=tt+ot.getSpanWidth(nt,E));return lt[xt]};if(nt.rotation=0,pt=gt(E.textContent.length),tt+pt>et){for(;ht<=ut;)dt=Math.ceil((ht+ut)/2),k&&(ft=rt(k,dt)),pt=gt(dt,ft&&ft.length-1),ht===ut?ht=ut+1:pt>et?ut=dt-1:ht=dt;ut===0?E.textContent="":a&&ut===a.length-1||(E.textContent=ft||rt(a||k,dt))}k&&k.splice(0,dt),nt.actualWidth=pt,nt.rotation=st},j.prototype.unescapeEntities=function(E,a){return objectEach$v(this.renderer.escapes,function(k,tt){(!a||a.indexOf(k)===-1)&&(E=E.toString().replace(new RegExp(k,"g"),tt))}),E},j}(),charts$4=H.charts,deg2rad$7=H.deg2rad,doc$j=H.doc,isFirefox$3=H.isFirefox,isMS$2=H.isMS,isWebKit$1=H.isWebKit,noop$k=H.noop,SVG_NS=H.SVG_NS,symbolSizes=H.symbolSizes,win$c=H.win,addEvent$10=Utilities.addEvent,attr$4=Utilities.attr,createElement$8=Utilities.createElement,css$b=Utilities.css,defined$Q=Utilities.defined,destroyObjectProperties$9=Utilities.destroyObjectProperties,extend$1q=Utilities.extend,isArray$k=Utilities.isArray,isNumber$J=Utilities.isNumber,isObject$c=Utilities.isObject,isString$8=Utilities.isString,merge$1i=Utilities.merge,pick$1s=Utilities.pick,pInt$6=Utilities.pInt,uniqueKey$6=Utilities.uniqueKey,hasInternalReferenceBug,SVGRenderer=function(){function j(E,a,k,tt,et,rt,nt){this.alignedObjects=void 0,this.box=void 0,this.boxWrapper=void 0,this.cache=void 0,this.cacheKeys=void 0,this.chartIndex=void 0,this.defs=void 0,this.globalAnimation=void 0,this.gradients=void 0,this.height=void 0,this.imgCount=void 0,this.isSVG=void 0,this.style=void 0,this.url=void 0,this.width=void 0,this.init(E,a,k,tt,et,rt,nt)}return j.prototype.init=function(E,a,k,tt,et,rt,nt){var ot=this,st=ot.createElement("svg").attr({version:"1.1",class:"highcharts-root"}),lt=st.element;nt||st.css(this.getStyle(tt)),E.appendChild(lt),attr$4(E,"dir","ltr"),E.innerHTML.indexOf("xmlns")===-1&&attr$4(lt,"xmlns",this.SVG_NS),ot.isSVG=!0,this.box=lt,this.boxWrapper=st,ot.alignedObjects=[],this.url=this.getReferenceURL();var ht=this.createElement("desc").add();ht.element.appendChild(doc$j.createTextNode("Created with Highcharts 9.2.2")),ot.defs=this.createElement("defs").add(),ot.allowHTML=rt,ot.forExport=et,ot.styledMode=nt,ot.gradients={},ot.cache={},ot.cacheKeys=[],ot.imgCount=0,ot.setSize(a,k,!1);var ut,dt;isFirefox$3&&E.getBoundingClientRect&&(ut=function(){css$b(E,{left:0,top:0}),dt=E.getBoundingClientRect(),css$b(E,{left:Math.ceil(dt.left)-dt.left+"px",top:Math.ceil(dt.top)-dt.top+"px"})},ut(),ot.unSubPixelFix=addEvent$10(win$c,"resize",ut))},j.prototype.definition=function(E){var a=new AST([E]);return a.addToDOM(this.defs.element)},j.prototype.getReferenceURL=function(){if((isFirefox$3||isWebKit$1)&&doc$j.getElementsByTagName("base").length){if(!defined$Q(hasInternalReferenceBug)){var E=uniqueKey$6(),a=new AST([{tagName:"svg",attributes:{width:8,height:8},children:[{tagName:"defs",children:[{tagName:"clipPath",attributes:{id:E},children:[{tagName:"rect",attributes:{width:4,height:4}}]}]},{tagName:"rect",attributes:{id:"hitme",width:8,height:8,"clip-path":"url(#"+E+")",fill:"rgba(0,0,0,0.001)"}}]}]),k=a.addToDOM(doc$j.body);css$b(k,{position:"fixed",top:0,left:0,zIndex:9e5});var tt=doc$j.elementFromPoint(6,6);hasInternalReferenceBug=(tt&&tt.id)==="hitme",doc$j.body.removeChild(k)}if(hasInternalReferenceBug)return win$c.location.href.split("#")[0].replace(/<[^>]*>/g,"").replace(/([\('\)])/g,"\\$1").replace(/ /g,"%20")}return""},j.prototype.getStyle=function(E){return this.style=extend$1q({fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',fontSize:"12px"},E),this.style},j.prototype.setStyle=function(E){this.boxWrapper.css(this.getStyle(E))},j.prototype.isHidden=function(){return!this.boxWrapper.getBBox().width},j.prototype.destroy=function(){var E=this,a=E.defs;return E.box=null,E.boxWrapper=E.boxWrapper.destroy(),destroyObjectProperties$9(E.gradients||{}),E.gradients=null,a&&(E.defs=a.destroy()),E.unSubPixelFix&&E.unSubPixelFix(),E.alignedObjects=null,null},j.prototype.createElement=function(E){var a=new this.Element;return a.init(this,E),a},j.prototype.getRadialAttr=function(E,a){return{cx:E[0]-E[2]/2+(a.cx||0)*E[2],cy:E[1]-E[2]/2+(a.cy||0)*E[2],r:(a.r||0)*E[2]}},j.prototype.buildText=function(E){new TextBuilder$1(E).buildSVG()},j.prototype.getContrast=function(E){return E=Color.parse(E).rgba,E[0]*=1,E[1]*=1.2,E[2]*=.5,E[0]+E[1]+E[2]>1.8*255?"#000000":"#FFFFFF"},j.prototype.button=function(E,a,k,tt,et,rt,nt,ot,st,lt){var ht=this.label(E,a,k,st,void 0,void 0,lt,void 0,"button"),ut=this.styledMode,dt=0,ft=et?merge$1i(et):{},pt=ft&&ft.style||{};ft=AST.filterUserAttributes(ft),ht.attr(merge$1i({padding:8,r:2},ft));var gt,yt,mt,xt;return ut||(ft=merge$1i({fill:palette.neutralColor3,stroke:palette.neutralColor20,"stroke-width":1,style:{color:palette.neutralColor80,cursor:"pointer",fontWeight:"normal"}},{style:pt},ft),gt=ft.style,delete ft.style,rt=merge$1i(ft,{fill:palette.neutralColor10},AST.filterUserAttributes(rt||{})),yt=rt.style,delete rt.style,nt=merge$1i(ft,{fill:palette.highlightColor10,style:{color:palette.neutralColor100,fontWeight:"bold"}},AST.filterUserAttributes(nt||{})),mt=nt.style,delete nt.style,ot=merge$1i(ft,{style:{color:palette.neutralColor20}},AST.filterUserAttributes(ot||{})),xt=ot.style,delete ot.style),addEvent$10(ht.element,isMS$2?"mouseover":"mouseenter",function(){dt!==3&&ht.setState(1)}),addEvent$10(ht.element,isMS$2?"mouseout":"mouseleave",function(){dt!==3&&ht.setState(dt)}),ht.setState=function(wt){wt!==1&&(ht.state=dt=wt),ht.removeClass(/highcharts-button-(normal|hover|pressed|disabled)/).addClass("highcharts-button-"+["normal","hover","pressed","disabled"][wt||0]),ut||ht.attr([ft,rt,nt,ot][wt||0]).css([gt,yt,mt,xt][wt||0])},ut||ht.attr(ft).css(extend$1q({cursor:"default"},gt)),ht.on("touchstart",function(wt){return wt.stopPropagation()}).on("click",function(wt){dt!==3&&tt.call(ht,wt)})},j.prototype.crispLine=function(E,a,k){k===void 0&&(k="round");var tt=E[0],et=E[1];return defined$Q(tt[1])&&tt[1]===et[1]&&(tt[1]=et[1]=Math[k](tt[1])-a%2/2),defined$Q(tt[2])&&tt[2]===et[2]&&(tt[2]=et[2]=Math[k](tt[2])+a%2/2),E},j.prototype.path=function(E){var a=this.styledMode?{}:{fill:"none"};return isArray$k(E)?a.d=E:isObject$c(E)&&extend$1q(a,E),this.createElement("path").attr(a)},j.prototype.circle=function(E,a,k){var tt=isObject$c(E)?E:typeof E>"u"?{}:{x:E,y:a,r:k},et=this.createElement("circle");return et.xSetter=et.ySetter=function(rt,nt,ot){ot.setAttribute("c"+nt,rt)},et.attr(tt)},j.prototype.arc=function(E,a,k,tt,et,rt){var nt;isObject$c(E)?(nt=E,a=nt.y,k=nt.r,tt=nt.innerR,et=nt.start,rt=nt.end,E=nt.x):nt={innerR:tt,start:et,end:rt};var ot=this.symbol("arc",E,a,k,k,nt);return ot.r=k,ot},j.prototype.rect=function(E,a,k,tt,et,rt){et=isObject$c(E)?E.r:et;var nt=this.createElement("rect"),ot=isObject$c(E)?E:typeof E>"u"?{}:{x:E,y:a,width:Math.max(k,0),height:Math.max(tt,0)};return this.styledMode||(typeof rt<"u"&&(ot["stroke-width"]=rt,ot=nt.crisp(ot)),ot.fill="none"),et&&(ot.r=et),nt.rSetter=function(st,lt,ht){nt.r=st,attr$4(ht,{rx:st,ry:st})},nt.rGetter=function(){return nt.r||0},nt.attr(ot)},j.prototype.setSize=function(E,a,k){var tt=this;tt.width=E,tt.height=a,tt.boxWrapper.animate({width:E,height:a},{step:function(){this.attr({viewBox:"0 0 "+this.attr("width")+" "+this.attr("height")})},duration:pick$1s(k,!0)?void 0:0}),tt.alignElements()},j.prototype.g=function(E){var a=this.createElement("g");return E?a.attr({class:"highcharts-"+E}):a},j.prototype.image=function(E,a,k,tt,et,rt){var nt={preserveAspectRatio:"none"},ot=function(ut,dt){ut.setAttributeNS?ut.setAttributeNS("http://www.w3.org/1999/xlink","href",dt):ut.setAttribute("hc-svg-href",dt)};arguments.length>1&&extend$1q(nt,{x:a,y:k,width:tt,height:et});var st=this.createElement("image").attr(nt),lt=function(ut){ot(st.element,E),rt.call(st,ut)};if(rt){ot(st.element,"data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==");var ht=new win$c.Image;addEvent$10(ht,"load",lt),ht.src=E,ht.complete&&lt({})}else ot(st.element,E);return st},j.prototype.symbol=function(E,a,k,tt,et,rt){var nt=this,ot=/^url\((.*?)\)$/,st=ot.test(E),lt=!st&&(this.symbols[E]?E:"circle"),ht=lt&&this.symbols[lt],ut,dt,ft,pt;if(ht)typeof a=="number"&&(dt=ht.call(this.symbols,Math.round(a||0),Math.round(k||0),tt||0,et||0,rt)),ut=this.path(dt),nt.styledMode||ut.attr("fill","none"),extend$1q(ut,{symbolName:lt||void 0,x:a,y:k,width:tt,height:et}),rt&&extend$1q(ut,rt);else if(st){ft=E.match(ot)[1];var gt=ut=this.image(ft);gt.imgwidth=pick$1s(symbolSizes[ft]&&symbolSizes[ft].width,rt&&rt.width),gt.imgheight=pick$1s(symbolSizes[ft]&&symbolSizes[ft].height,rt&&rt.height),pt=function(yt){return yt.attr({width:yt.width,height:yt.height})},["width","height"].forEach(function(yt){gt[yt+"Setter"]=function(mt,xt){var wt=this["img"+xt];if(this[xt]=mt,defined$Q(wt)&&(rt&&rt.backgroundSize==="within"&&this.width&&this.height&&(wt=Math.round(wt*Math.min(this.width/this.imgwidth,this.height/this.imgheight))),this.element&&this.element.setAttribute(xt,wt),!this.alignByTranslate)){var Mt=((this[xt]||0)-wt)/2,At=xt==="width"?{translateX:Mt}:{translateY:Mt};this.attr(At)}}}),defined$Q(a)&&gt.attr({x:a,y:k}),gt.isImg=!0,defined$Q(gt.imgwidth)&&defined$Q(gt.imgheight)?pt(gt):(gt.attr({width:0,height:0}),createElement$8("img",{onload:function(){var yt=charts$4[nt.chartIndex];this.width===0&&(css$b(this,{position:"absolute",top:"-999em"}),doc$j.body.appendChild(this)),symbolSizes[ft]={width:this.width,height:this.height},gt.imgwidth=this.width,gt.imgheight=this.height,gt.element&&pt(gt),this.parentNode&&this.parentNode.removeChild(this),nt.imgCount--,!nt.imgCount&&yt&&!yt.hasLoaded&&yt.onload()},src:ft}),this.imgCount++)}return ut},j.prototype.clipRect=function(E,a,k,tt){var et=uniqueKey$6()+"-",rt=this.createElement("clipPath").attr({id:et}).add(this.defs),nt=this.rect(E,a,k,tt,0).add(rt);return nt.id=et,nt.clipPath=rt,nt.count=0,nt},j.prototype.text=function(E,a,k,tt){var et=this,rt={};if(tt&&(et.allowHTML||!et.forExport))return et.html(E,a,k);rt.x=Math.round(a||0),k&&(rt.y=Math.round(k)),defined$Q(E)&&(rt.text=E);var nt=et.createElement("text").attr(rt);return(!tt||et.forExport&&!et.allowHTML)&&(nt.xSetter=function(ot,st,lt){for(var ht=lt.getElementsByTagName("tspan"),ut=lt.getAttribute(st),dt=0,ft=void 0;dt<ht.length;dt++)ft=ht[dt],ft.getAttribute(st)===ut&&ft.setAttribute(st,ot);lt.setAttribute(st,ot)}),nt},j.prototype.fontMetrics=function(E,a){(this.styledMode||!/px/.test(E))&&win$c.getComputedStyle?E=a&&SVGElement.prototype.getStyle.call(a,"font-size"):E=E||a&&a.style&&a.style.fontSize||this.style&&this.style.fontSize,/px/.test(E)?E=pInt$6(E):E=12;var k=E<24?E+3:Math.round(E*1.2),tt=Math.round(k*.8);return{h:k,b:tt,f:E}},j.prototype.rotCorr=function(E,a,k){var tt=E;return a&&k&&(tt=Math.max(tt*Math.cos(a*deg2rad$7),4)),{x:-E/3*Math.sin(a*deg2rad$7),y:tt}},j.prototype.pathToSegments=function(E){for(var a=[],k=[],tt={A:8,C:7,H:2,L:3,M:3,Q:5,S:5,T:3,V:2},et=0;et<E.length;et++)isString$8(k[0])&&isNumber$J(E[et])&&k.length===tt[k[0].toUpperCase()]&&E.splice(et,0,k[0].replace("M","L").replace("m","l")),typeof E[et]=="string"&&(k.length&&a.push(k.slice(0)),k.length=0),k.push(E[et]);return a.push(k.slice(0)),a},j.prototype.label=function(E,a,k,tt,et,rt,nt,ot,st){return new SVGLabel(this,E,a,k,tt,et,rt,nt,ot,st)},j.prototype.alignElements=function(){this.alignedObjects.forEach(function(E){return E.align()})},j}();extend$1q(SVGRenderer.prototype,{Element:SVGElement,SVG_NS,escapes:{"&":"&amp;","<":"&lt;",">":"&gt;","'":"&#39;",'"':"&quot;"},symbols:Symbols,draw:noop$k});RendererRegistry$1.registerRendererType("svg",SVGRenderer,!0);var __extends$2c=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),isFirefox$2=H.isFirefox,isMS$1=H.isMS,isWebKit=H.isWebKit,win$b=H.win,css$a=Utilities.css,defined$P=Utilities.defined,extend$1p=Utilities.extend,pick$1r=Utilities.pick,pInt$5=Utilities.pInt,HTMLElement$1=function(j){__extends$2c(E,j);function E(){return j!==null&&j.apply(this,arguments)||this}return E.compose=function(a){if(E.composedClasses.indexOf(a)===-1){E.composedClasses.push(a);var k=E.prototype,tt=a.prototype;tt.getSpanCorrection=k.getSpanCorrection,tt.htmlCss=k.htmlCss,tt.htmlGetBBox=k.htmlGetBBox,tt.htmlUpdateTransform=k.htmlUpdateTransform,tt.setSpanRotation=k.setSpanRotation}return a},E.prototype.getSpanCorrection=function(a,k,tt){this.xCorr=-a*tt,this.yCorr=-k},E.prototype.htmlCss=function(a){var k=this,tt=k.element,et=tt.tagName==="SPAN"&&a&&"width"in a,rt=pick$1r(et&&a.width,void 0),nt;return et&&(delete a.width,k.textWidth=rt,nt=!0),a&&a.textOverflow==="ellipsis"&&(a.whiteSpace="nowrap",a.overflow="hidden"),k.styles=extend$1p(k.styles,a),css$a(k.element,a),nt&&k.htmlUpdateTransform(),k},E.prototype.htmlGetBBox=function(){var a=this,k=a.element;return{x:k.offsetLeft,y:k.offsetTop,width:k.offsetWidth,height:k.offsetHeight}},E.prototype.htmlUpdateTransform=function(){if(!this.added){this.alignOnAdd=!0;return}var a=this,k=a.renderer,tt=a.element,et=a.translateX||0,rt=a.translateY||0,nt=a.x||0,ot=a.y||0,st=a.textAlign||"left",lt={left:0,center:.5,right:1}[st],ht=a.styles,ut=ht&&ht.whiteSpace;function dt(){return css$a(tt,{width:"",whiteSpace:ut||"nowrap"}),tt.offsetWidth}if(css$a(tt,{marginLeft:et,marginTop:rt}),!k.styledMode&&a.shadows&&a.shadows.forEach(function(mt){css$a(mt,{marginLeft:et+1,marginTop:rt+1})}),a.inverted&&[].forEach.call(tt.childNodes,function(mt){k.invertChild(mt,tt)}),tt.tagName==="SPAN"){var ft=a.rotation,pt=a.textWidth&&pInt$5(a.textWidth),gt=[ft,st,tt.innerHTML,a.textWidth,a.textAlign].join(","),yt=void 0;pt!==a.oldTextWidth&&(pt>a.oldTextWidth||(a.textPxLength||dt())>pt)&&(/[ \-]/.test(tt.textContent||tt.innerText)||tt.style.textOverflow==="ellipsis")?(css$a(tt,{width:pt+"px",display:"block",whiteSpace:ut||"normal"}),a.oldTextWidth=pt,a.hasBoxWidthChanged=!0):a.hasBoxWidthChanged=!1,gt!==a.cTT&&(yt=k.fontMetrics(tt.style.fontSize,tt).b,defined$P(ft)&&(ft!==(a.oldRotation||0)||st!==a.oldAlign)&&a.setSpanRotation(ft,lt,yt),a.getSpanCorrection(!defined$P(ft)&&a.textPxLength||tt.offsetWidth,yt,lt,ft,st)),css$a(tt,{left:nt+(a.xCorr||0)+"px",top:ot+(a.yCorr||0)+"px"}),a.cTT=gt,a.oldRotation=ft,a.oldAlign=st}},E.prototype.setSpanRotation=function(a,k,tt){var et=function(){return isMS$1&&!/Edge/.test(win$b.navigator.userAgent)?"-ms-transform":isWebKit?"-webkit-transform":isFirefox$2?"MozTransform":win$b.opera?"-o-transform":void 0},rt={},nt=et();nt&&(rt[nt]=rt.transform="rotate("+a+"deg)",rt[nt+(isFirefox$2?"Origin":"-origin")]=rt.transformOrigin=k*100+"% "+tt+"px",css$a(this.element,rt))},E.composedClasses=[],E}(SVGElement),__extends$2b=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),attr$3=Utilities.attr,createElement$7=Utilities.createElement,extend$1o=Utilities.extend,pick$1q=Utilities.pick,HTMLRenderer=function(j){__extends$2b(E,j);function E(){return j!==null&&j.apply(this,arguments)||this}return E.compose=function(a){if(E.composedClasses.indexOf(a)===-1){E.composedClasses.push(a);var k=E.prototype,tt=a.prototype;tt.html=k.html}return a},E.prototype.html=function(a,k,tt){var et=this.createElement("span"),rt=et.element,nt=et.renderer,ot=nt.isSVG,st=function(lt,ht){["opacity","visibility"].forEach(function(ut){lt[ut+"Setter"]=function(dt,ft,pt){var gt=lt.div?lt.div.style:ht;SVGElement.prototype[ut+"Setter"].call(this,dt,ft,pt),gt&&(gt[ft]=dt)}}),lt.addedSetters=!0};return et.textSetter=function(lt){lt!==this.textStr&&(delete this.bBox,delete this.oldTextWidth,AST.setElementHTML(this.element,pick$1q(lt,"")),this.textStr=lt,et.doTransform=!0)},ot&&st(et,et.element.style),et.xSetter=et.ySetter=et.alignSetter=et.rotationSetter=function(lt,ht){ht==="align"?et.alignValue=et.textAlign=lt:et[ht]=lt,et.doTransform=!0},et.afterSetters=function(){this.doTransform&&(this.htmlUpdateTransform(),this.doTransform=!1)},et.attr({text:a,x:Math.round(k),y:Math.round(tt)}).css({position:"absolute"}),nt.styledMode||et.css({fontFamily:this.style.fontFamily,fontSize:this.style.fontSize}),rt.style.whiteSpace="nowrap",et.css=et.htmlCss,ot&&(et.add=function(lt){var ht=nt.box.parentNode,ut=[],dt,ft;if(this.parentGroup=lt,lt){if(dt=lt.div,!dt){for(ft=lt;ft;)ut.push(ft),ft=ft.parentGroup;ut.reverse().forEach(function(pt){var gt=attr$3(pt.element,"class");function yt(wt,Mt){pt[Mt]=wt,Mt==="translateX"?xt.left=wt+"px":xt.top=wt+"px",pt.doTransform=!0}var mt=pt.styles||{};dt=pt.div=pt.div||createElement$7("div",gt?{className:gt}:void 0,{position:"absolute",left:(pt.translateX||0)+"px",top:(pt.translateY||0)+"px",display:pt.display,opacity:pt.opacity,cursor:mt.cursor,pointerEvents:mt.pointerEvents,visibility:pt.visibility},dt||ht);var xt=dt.style;extend$1o(pt,{classSetter:function(wt){return function(Mt){this.element.setAttribute("class",Mt),wt.className=Mt}}(dt),on:function(){return ut[0].div&&et.on.apply({element:ut[0].div,onEvents:pt.onEvents},arguments),pt},translateXSetter:yt,translateYSetter:yt}),pt.addedSetters||st(pt)})}}else dt=ht;return dt.appendChild(rt),et.added=!0,et.alignOnAdd&&et.htmlUpdateTransform(),et}),et},E.composedClasses=[],E}(SVGRenderer),AxisDefaults;(function(j){j.defaultXAxisOptions={alignTicks:!0,allowDecimals:void 0,panningEnabled:!0,zIndex:2,zoomEnabled:!0,dateTimeLabelFormats:{millisecond:{main:"%H:%M:%S.%L",range:!1},second:{main:"%H:%M:%S",range:!1},minute:{main:"%H:%M",range:!1},hour:{main:"%H:%M",range:!1},day:{main:"%e. %b"},week:{main:"%e. %b"},month:{main:"%b '%y"},year:{main:"%Y"}},endOnTick:!1,gridLineDashStyle:"Solid",gridZIndex:1,labels:{autoRotation:void 0,autoRotationLimit:80,distance:void 0,enabled:!0,indentation:10,overflow:"justify",padding:5,reserveSpace:void 0,rotation:void 0,staggerLines:0,step:0,useHTML:!1,x:0,zIndex:7,style:{color:palette.neutralColor60,cursor:"default",fontSize:"11px"}},maxPadding:.01,minorGridLineDashStyle:"Solid",minorTickLength:2,minorTickPosition:"outside",minPadding:.01,offset:void 0,opposite:!1,reversed:void 0,reversedStacks:!1,showEmpty:!0,showFirstLabel:!0,showLastLabel:!0,startOfWeek:1,startOnTick:!1,tickLength:10,tickPixelInterval:100,tickmarkPlacement:"between",tickPosition:"outside",title:{align:"middle",rotation:0,useHTML:!1,x:0,y:0,style:{color:palette.neutralColor60}},type:"linear",uniqueNames:!0,visible:!0,minorGridLineColor:palette.neutralColor5,minorGridLineWidth:1,minorTickColor:palette.neutralColor40,lineColor:palette.highlightColor20,lineWidth:1,gridLineColor:palette.neutralColor10,gridLineWidth:void 0,tickColor:palette.highlightColor20},j.defaultYAxisOptions={reversedStacks:!0,endOnTick:!0,maxPadding:.05,minPadding:.05,tickPixelInterval:72,showLastLabel:!0,labels:{x:-8},startOnTick:!0,title:{rotation:270,text:"Values"},stackLabels:{animation:{},allowOverlap:!1,enabled:!1,crop:!0,overflow:"justify",formatter:function(){var E=this.axis.chart.numberFormatter;return E(this.total,-1)},style:{color:palette.neutralColor100,fontSize:"11px",fontWeight:"bold",textOutline:"1px contrast"}},gridLineWidth:1,lineWidth:0},j.defaultLeftAxisOptions={labels:{x:-15},title:{rotation:270}},j.defaultRightAxisOptions={labels:{x:15},title:{rotation:90}},j.defaultBottomAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}},j.defaultTopAxisOptions={labels:{autoRotation:[-45],x:0},margin:15,title:{rotation:0}}})(AxisDefaults||(AxisDefaults={}));const AxisDefaults$1=AxisDefaults;var addEvent$$=Utilities.addEvent,isFunction$3=Utilities.isFunction,objectEach$u=Utilities.objectEach,removeEvent$a=Utilities.removeEvent,registerEventOptions$3=function(j,E){j.eventOptions=j.eventOptions||{},objectEach$u(E.events,function(a,k){j.eventOptions[k]!==a&&(j.eventOptions[k]&&(removeEvent$a(j,k,j.eventOptions[k]),delete j.eventOptions[k]),isFunction$3(a)&&(j.eventOptions[k]=a,addEvent$$(j,k,a)))})},exports$6={registerEventOptions:registerEventOptions$3},deg2rad$6=H.deg2rad,clamp$i=Utilities.clamp,correctFloat$c=Utilities.correctFloat,defined$O=Utilities.defined,destroyObjectProperties$8=Utilities.destroyObjectProperties,extend$1n=Utilities.extend,fireEvent$z=Utilities.fireEvent,isNumber$I=Utilities.isNumber,merge$1h=Utilities.merge,objectEach$t=Utilities.objectEach,pick$1p=Utilities.pick,Tick=function(){function j(E,a,k,tt,et){this.isNew=!0,this.isNewLabel=!0,this.axis=E,this.pos=a,this.type=k||"",this.parameters=et||{},this.tickmarkOffset=this.parameters.tickmarkOffset,this.options=this.parameters.options,fireEvent$z(this,"init"),!k&&!tt&&this.addLabel()}return j.prototype.addLabel=function(){var E=this,a=E.axis,k=a.options,tt=a.chart,et=a.categories,rt=a.logarithmic,nt=a.names,ot=E.pos,st=pick$1p(E.options&&E.options.labels,k.labels),lt=a.tickPositions,ht=ot===lt[0],ut=ot===lt[lt.length-1],dt=(!st.step||st.step===1)&&a.tickInterval===1,ft=lt.info,pt=E.label,gt,yt,mt,xt=this.parameters.category||(et?pick$1p(et[ot],nt[ot],ot):ot);rt&&isNumber$I(xt)&&(xt=correctFloat$c(rt.lin2log(xt))),a.dateTime&&(ft?(yt=tt.time.resolveDTLFormat(k.dateTimeLabelFormats[!k.grid&&ft.higherRanks[ot]||ft.unitName]),gt=yt.main):isNumber$I(xt)&&(gt=a.dateTime.getXDateFormat(xt,k.dateTimeLabelFormats||{}))),E.isFirst=ht,E.isLast=ut;var wt={axis:a,chart:tt,dateTimeLabelFormat:gt,isFirst:ht,isLast:ut,pos:ot,tick:E,tickPositionInfo:ft,value:xt};fireEvent$z(this,"labelFormat",wt);var Mt=function($t){return st.formatter?st.formatter.call($t,$t):st.format?($t.text=a.defaultLabelFormatter.call($t),FormatUtilities.format(st.format,$t,tt)):a.defaultLabelFormatter.call($t,$t)},At=Mt.call(wt,wt),St=yt&&yt.list;St?E.shortenLabel=function(){for(mt=0;mt<St.length;mt++)if(extend$1n(wt,{dateTimeLabelFormat:St[mt]}),pt.attr({text:Mt.call(wt,wt)}),pt.getBBox().width<a.getSlotWidth(E)-2*st.padding)return;pt.attr({text:""})}:E.shortenLabel=void 0,dt&&a._addedPlotLB&&E.moveLabel(At,st),!defined$O(pt)&&!E.movedLabel?(E.label=pt=E.createLabel({x:0,y:0},At,st),E.rotation=0):pt&&pt.textStr!==At&&!dt&&(pt.textWidth&&!st.style.width&&!pt.styles.width&&pt.css({width:null}),pt.attr({text:At}),pt.textPxLength=pt.getBBox().width)},j.prototype.createLabel=function(E,a,k){var tt=this.axis,et=tt.chart,rt=defined$O(a)&&k.enabled?et.renderer.text(a,E.x,E.y,k.useHTML).add(tt.labelGroup):null;return rt&&(et.styledMode||rt.css(merge$1h(k.style)),rt.textPxLength=rt.getBBox().width),rt},j.prototype.destroy=function(){destroyObjectProperties$8(this,this.axis)},j.prototype.getPosition=function(E,a,k,tt){var et=this.axis,rt=et.chart,nt=tt&&rt.oldChartHeight||rt.chartHeight,ot={x:E?correctFloat$c(et.translate(a+k,null,null,tt)+et.transB):et.left+et.offset+(et.opposite?(tt&&rt.oldChartWidth||rt.chartWidth)-et.right-et.left:0),y:E?nt-et.bottom+et.offset-(et.opposite?et.height:0):correctFloat$c(nt-et.translate(a+k,null,null,tt)-et.transB)};return ot.y=clamp$i(ot.y,-1e5,1e5),fireEvent$z(this,"afterGetPosition",{pos:ot}),ot},j.prototype.getLabelPosition=function(E,a,k,tt,et,rt,nt,ot){var st=this.axis,lt=st.transA,ht=st.isLinked&&st.linkedParent?st.linkedParent.reversed:st.reversed,ut=st.staggerLines,dt=st.tickRotCorr||{x:0,y:0},ft=!tt&&!st.reserveSpaceDefault?-st.labelOffset*(st.labelAlign==="center"?.5:1):0,pt={},gt=et.y,yt;return defined$O(gt)||(st.side===0?gt=k.rotation?-8:-k.getBBox().height:st.side===2?gt=dt.y+8:gt=Math.cos(k.rotation*deg2rad$6)*(dt.y-k.getBBox(!1,0).height/2)),E=E+et.x+ft+dt.x-(rt&&tt?rt*lt*(ht?-1:1):0),a=a+gt-(rt&&!tt?rt*lt*(ht?1:-1):0),ut&&(yt=nt/(ot||1)%ut,st.opposite&&(yt=ut-yt-1),a+=yt*(st.labelOffset/ut)),pt.x=E,pt.y=Math.round(a),fireEvent$z(this,"afterGetLabelPosition",{pos:pt,tickmarkOffset:rt,index:nt}),pt},j.prototype.getLabelSize=function(){return this.label?this.label.getBBox()[this.axis.horiz?"height":"width"]:0},j.prototype.getMarkPath=function(E,a,k,tt,et,rt){return rt.crispLine([["M",E,a],["L",E+(et?0:-k),a+(et?k:0)]],tt)},j.prototype.handleOverflow=function(E){var a=this,k=this.axis,tt=k.options.labels,et=E.x,rt=k.chart.chartWidth,nt=k.chart.spacing,ot=pick$1p(k.labelLeft,Math.min(k.pos,nt[3])),st=pick$1p(k.labelRight,Math.max(k.isRadial?0:k.pos+k.len,rt-nt[1])),lt=this.label,ht=this.rotation,ut={left:0,center:.5,right:1}[k.labelAlign||lt.attr("align")],dt=lt.getBBox().width,ft=k.getSlotWidth(a),pt=ut,gt={},yt=ft,mt=1,xt,wt,Mt;!ht&&tt.overflow==="justify"?(xt=et-ut*dt,wt=et+(1-ut)*dt,xt<ot?yt=E.x+yt*(1-ut)-ot:wt>st&&(yt=st-E.x+yt*ut,mt=-1),yt=Math.min(ft,yt),yt<ft&&k.labelAlign==="center"&&(E.x+=mt*(ft-yt-pt*(ft-Math.min(dt,yt)))),(dt>yt||k.autoRotation&&(lt.styles||{}).width)&&(Mt=yt)):ht<0&&et-ut*dt<ot?Mt=Math.round(et/Math.cos(ht*deg2rad$6)-ot):ht>0&&et+ut*dt>st&&(Mt=Math.round((rt-et)/Math.cos(ht*deg2rad$6))),Mt&&(a.shortenLabel?a.shortenLabel():(gt.width=Math.floor(Mt)+"px",(tt.style||{}).textOverflow||(gt.textOverflow="ellipsis"),lt.css(gt)))},j.prototype.moveLabel=function(E,a){var k=this,tt=k.label,et=k.axis,rt=et.reversed,nt=!1,ot,st,lt;tt&&tt.textStr===E?(k.movedLabel=tt,nt=!0,delete k.label):objectEach$t(et.ticks,function(ht){!nt&&!ht.isNew&&ht!==k&&ht.label&&ht.label.textStr===E&&(k.movedLabel=ht.label,nt=!0,ht.labelPos=k.movedLabel.xy,delete ht.label)}),!nt&&(k.labelPos||tt)&&(ot=k.labelPos||tt.xy,st=et.horiz?rt?0:et.width+et.left:ot.x,lt=et.horiz?ot.y:rt?et.width+et.left:0,k.movedLabel=k.createLabel({x:st,y:lt},E,a),k.movedLabel&&k.movedLabel.attr({opacity:0}))},j.prototype.render=function(E,a,k){var tt=this,et=tt.axis,rt=et.horiz,nt=tt.pos,ot=pick$1p(tt.tickmarkOffset,et.tickmarkOffset),st=tt.getPosition(rt,nt,ot,a),lt=st.x,ht=st.y,ut=rt&&lt===et.pos+et.len||!rt&&ht===et.pos?-1:1,dt=pick$1p(k,tt.label&&tt.label.newOpacity,1);k=pick$1p(k,1),this.isActive=!0,this.renderGridLine(a,k,ut),this.renderMark(st,k,ut),this.renderLabel(st,a,dt,E),tt.isNew=!1,fireEvent$z(this,"afterRender")},j.prototype.renderGridLine=function(E,a,k){var tt=this,et=tt.axis,rt=et.options,nt={},ot=tt.pos,st=tt.type,lt=pick$1p(tt.tickmarkOffset,et.tickmarkOffset),ht=et.chart.renderer,ut=tt.gridLine,dt,ft=rt.gridLineWidth,pt=rt.gridLineColor,gt=rt.gridLineDashStyle;tt.type==="minor"&&(ft=rt.minorGridLineWidth,pt=rt.minorGridLineColor,gt=rt.minorGridLineDashStyle),ut||(et.chart.styledMode||(nt.stroke=pt,nt["stroke-width"]=ft||0,nt.dashstyle=gt),st||(nt.zIndex=1),E&&(a=0),tt.gridLine=ut=ht.path().attr(nt).addClass("highcharts-"+(st?st+"-":"")+"grid-line").add(et.gridGroup)),ut&&(dt=et.getPlotLinePath({value:ot+lt,lineWidth:ut.strokeWidth()*k,force:"pass",old:E}),dt&&ut[E||tt.isNew?"attr":"animate"]({d:dt,opacity:a}))},j.prototype.renderMark=function(E,a,k){var tt=this,et=tt.axis,rt=et.options,nt=et.chart.renderer,ot=tt.type,st=et.tickSize(ot?ot+"Tick":"tick"),lt=E.x,ht=E.y,ut=pick$1p(rt[ot!=="minor"?"tickWidth":"minorTickWidth"],!ot&&et.isXAxis?1:0),dt=rt[ot!=="minor"?"tickColor":"minorTickColor"],ft=tt.mark,pt=!ft;st&&(et.opposite&&(st[0]=-st[0]),ft||(tt.mark=ft=nt.path().addClass("highcharts-"+(ot?ot+"-":"")+"tick").add(et.axisGroup),et.chart.styledMode||ft.attr({stroke:dt,"stroke-width":ut})),ft[pt?"attr":"animate"]({d:tt.getMarkPath(lt,ht,st[0],ft.strokeWidth()*k,et.horiz,nt),opacity:a}))},j.prototype.renderLabel=function(E,a,k,tt){var et=this,rt=et.axis,nt=rt.horiz,ot=rt.options,st=et.label,lt=ot.labels,ht=lt.step,ut=pick$1p(et.tickmarkOffset,rt.tickmarkOffset),dt=E.x,ft=E.y,pt=!0;st&&isNumber$I(dt)&&(st.xy=E=et.getLabelPosition(dt,ft,st,nt,lt,ut,tt,ht),et.isFirst&&!et.isLast&&!ot.showFirstLabel||et.isLast&&!et.isFirst&&!ot.showLastLabel?pt=!1:nt&&!lt.step&&!lt.rotation&&!a&&k!==0&&et.handleOverflow(E),ht&&tt%ht&&(pt=!1),pt&&isNumber$I(E.y)?(E.opacity=k,st[et.isNewLabel?"attr":"animate"](E),et.isNewLabel=!1):(st.attr("y",-9999),et.isNewLabel=!0))},j.prototype.replaceMovedLabel=function(){var E=this,a=E.label,k=E.axis,tt=k.reversed,et,rt;a&&!E.isNew&&(et=k.horiz?tt?k.left:k.width+k.left:a.xy.x,rt=k.horiz?a.xy.y:tt?k.width+k.top:k.top,a.animate({x:et,y:rt,opacity:0},void 0,a.destroy),delete E.label),k.isDirty=!0,E.label=E.movedLabel,delete E.movedLabel},j}(),animObject$a=animationExports.animObject,defaultOptions$e=DefaultOptions.defaultOptions,registerEventOptions$2=exports$6.registerEventOptions,deg2rad$5=H.deg2rad,arrayMax$9=Utilities.arrayMax,arrayMin$8=Utilities.arrayMin,clamp$h=Utilities.clamp,correctFloat$b=Utilities.correctFloat,defined$N=Utilities.defined,destroyObjectProperties$7=Utilities.destroyObjectProperties,erase$7=Utilities.erase,error$7=Utilities.error,extend$1m=Utilities.extend,fireEvent$y=Utilities.fireEvent,getMagnitude$2=Utilities.getMagnitude,isArray$j=Utilities.isArray,isNumber$H=Utilities.isNumber,isString$7=Utilities.isString,merge$1g=Utilities.merge,normalizeTickInterval$2=Utilities.normalizeTickInterval,objectEach$s=Utilities.objectEach,pick$1o=Utilities.pick,relativeLength$9=Utilities.relativeLength,removeEvent$9=Utilities.removeEvent,splat$g=Utilities.splat,syncTimeout$7=Utilities.syncTimeout,Axis=function(){function j(E,a){this.alternateBands=void 0,this.bottom=void 0,this.categories=void 0,this.chart=void 0,this.closestPointRange=void 0,this.coll=void 0,this.eventOptions=void 0,this.hasNames=void 0,this.hasVisibleSeries=void 0,this.height=void 0,this.isLinked=void 0,this.labelEdge=void 0,this.labelFormatter=void 0,this.left=void 0,this.len=void 0,this.max=void 0,this.maxLabelLength=void 0,this.min=void 0,this.minorTickInterval=void 0,this.minorTicks=void 0,this.minPixelPadding=void 0,this.names=void 0,this.offset=void 0,this.options=void 0,this.overlap=void 0,this.paddedTicks=void 0,this.plotLinesAndBands=void 0,this.plotLinesAndBandsGroups=void 0,this.pointRange=void 0,this.pointRangePadding=void 0,this.pos=void 0,this.positiveValuesOnly=void 0,this.right=void 0,this.series=void 0,this.side=void 0,this.tickAmount=void 0,this.tickInterval=void 0,this.tickmarkOffset=void 0,this.tickPositions=void 0,this.tickRotCorr=void 0,this.ticks=void 0,this.top=void 0,this.transA=void 0,this.transB=void 0,this.translationSlope=void 0,this.userOptions=void 0,this.visible=void 0,this.width=void 0,this.zoomEnabled=void 0,this.init(E,a)}return j.prototype.init=function(E,a){var k=a.isX,tt=this;tt.chart=E,tt.horiz=E.inverted&&!tt.isZAxis?!k:k,tt.isXAxis=k,tt.coll=tt.coll||(k?"xAxis":"yAxis"),fireEvent$y(this,"init",{userOptions:a}),tt.opposite=pick$1o(a.opposite,tt.opposite),tt.side=pick$1o(a.side,tt.side,tt.horiz?tt.opposite?0:2:tt.opposite?1:3),tt.setOptions(a);var et=this.options,rt=et.labels,nt=et.type;tt.userOptions=a,tt.minPixelPadding=0,tt.reversed=pick$1o(et.reversed,tt.reversed),tt.visible=et.visible,tt.zoomEnabled=et.zoomEnabled,tt.hasNames=nt==="category"||et.categories===!0,tt.categories=et.categories||tt.hasNames,tt.names||(tt.names=[],tt.names.keys={}),tt.plotLinesAndBandsGroups={},tt.positiveValuesOnly=!!tt.logarithmic,tt.isLinked=defined$N(et.linkedTo),tt.ticks={},tt.labelEdge=[],tt.minorTicks={},tt.plotLinesAndBands=[],tt.alternateBands={},tt.len=0,tt.minRange=tt.userMinRange=et.minRange||et.maxZoom,tt.range=et.range,tt.offset=et.offset||0,tt.max=null,tt.min=null;var ot=pick$1o(et.crosshair,splat$g(E.options.tooltip.crosshairs)[k?0:1]);tt.crosshair=ot===!0?{}:ot,E.axes.indexOf(tt)===-1&&(k?E.axes.splice(E.xAxis.length,0,tt):E.axes.push(tt),E[tt.coll].push(tt)),tt.series=tt.series||[],E.inverted&&!tt.isZAxis&&k&&typeof tt.reversed>"u"&&(tt.reversed=!0),tt.labelRotation=isNumber$H(rt.rotation)?rt.rotation:void 0,registerEventOptions$2(tt,et),fireEvent$y(this,"afterInit")},j.prototype.setOptions=function(E){this.options=merge$1g(AxisDefaults$1.defaultXAxisOptions,this.coll==="yAxis"&&AxisDefaults$1.defaultYAxisOptions,[AxisDefaults$1.defaultTopAxisOptions,AxisDefaults$1.defaultRightAxisOptions,AxisDefaults$1.defaultBottomAxisOptions,AxisDefaults$1.defaultLeftAxisOptions][this.side],merge$1g(defaultOptions$e[this.coll],E)),fireEvent$y(this,"afterSetOptions",{userOptions:E})},j.prototype.defaultLabelFormatter=function(E){var a=this.axis,k=this.chart,tt=k.numberFormatter,et=isNumber$H(this.value)?this.value:NaN,rt=a.chart.time,nt=a.categories,ot=this.dateTimeLabelFormat,st=defaultOptions$e.lang,lt=st.numericSymbols,ht=st.numericSymbolMagnitude||1e3,ut=a.logarithmic?Math.abs(et):a.tickInterval,dt=lt&&lt.length,ft,pt;if(nt)pt=""+this.value;else if(ot)pt=rt.dateFormat(ot,et);else if(dt&&ut>=1e3)for(;dt--&&typeof pt>"u";)ft=Math.pow(ht,dt+1),ut>=ft&&et*10%ft===0&&lt[dt]!==null&&et!==0&&(pt=tt(et/ft,-1)+lt[dt]);return typeof pt>"u"&&(Math.abs(et)>=1e4?pt=tt(et,-1):pt=tt(et,-1,void 0,"")),pt},j.prototype.getSeriesExtremes=function(){var E=this,a=E.chart,k;fireEvent$y(this,"getSeriesExtremes",null,function(){E.hasVisibleSeries=!1,E.dataMin=E.dataMax=E.threshold=null,E.softThreshold=!E.isXAxis,E.stacking&&E.stacking.buildStacks(),E.series.forEach(function(tt){if(tt.visible||!a.options.chart.ignoreHiddenSeries){var et=tt.options,rt=void 0,nt=et.threshold,ot=void 0,st=void 0;if(E.hasVisibleSeries=!0,E.positiveValuesOnly&&nt<=0&&(nt=null),E.isXAxis)rt=tt.xData,rt.length&&(rt=E.logarithmic?rt.filter(E.validatePositiveValue):rt,k=tt.getXExtremes(rt),ot=k.min,st=k.max,!isNumber$H(ot)&&!(ot instanceof Date)&&(rt=rt.filter(isNumber$H),k=tt.getXExtremes(rt),ot=k.min,st=k.max),rt.length&&(E.dataMin=Math.min(pick$1o(E.dataMin,ot),ot),E.dataMax=Math.max(pick$1o(E.dataMax,st),st)));else{var lt=tt.applyExtremes();isNumber$H(lt.dataMin)&&(ot=lt.dataMin,E.dataMin=Math.min(pick$1o(E.dataMin,ot),ot)),isNumber$H(lt.dataMax)&&(st=lt.dataMax,E.dataMax=Math.max(pick$1o(E.dataMax,st),st)),defined$N(nt)&&(E.threshold=nt),(!et.softThreshold||E.positiveValuesOnly)&&(E.softThreshold=!1)}}})}),fireEvent$y(this,"afterGetSeriesExtremes")},j.prototype.translate=function(E,a,k,tt,et,rt){var nt=this.linkedParent||this,ot=tt&&nt.old?nt.old.min:nt.min,st=nt.minPixelPadding,lt=(nt.isOrdinal||nt.brokenAxis&&nt.brokenAxis.hasBreaks||nt.logarithmic&&et)&&nt.lin2val,ht=1,ut=0,dt=tt&&nt.old?nt.old.transA:nt.transA,ft=0;return dt||(dt=nt.transA),k&&(ht*=-1,ut=nt.len),nt.reversed&&(ht*=-1,ut-=ht*(nt.sector||nt.len)),a?(E=E*ht+ut,E-=st,ft=E/dt+ot,lt&&(ft=nt.lin2val(ft))):(lt&&(E=nt.val2lin(E)),ft=isNumber$H(ot)?ht*(E-ot)*dt+ut+ht*st+(isNumber$H(rt)?dt*rt:0):void 0),ft},j.prototype.toPixels=function(E,a){return this.translate(E,!1,!this.horiz,null,!0)+(a?0:this.pos)},j.prototype.toValue=function(E,a){return this.translate(E-(a?0:this.pos),!0,!this.horiz,null,!0)},j.prototype.getPlotLinePath=function(E){var a=this,k=a.chart,tt=a.left,et=a.top,rt=E.old,nt=E.value,ot=E.lineWidth,st=rt&&k.oldChartHeight||k.chartHeight,lt=rt&&k.oldChartWidth||k.chartWidth,ht=a.transB,ut=E.translatedValue,dt=E.force,ft,pt,gt,yt,mt;function xt(Mt,At,St){return(dt!=="pass"&&Mt<At||Mt>St)&&(dt?Mt=clamp$h(Mt,At,St):mt=!0),Mt}var wt={value:nt,lineWidth:ot,old:rt,force:dt,acrossPanes:E.acrossPanes,translatedValue:ut};return fireEvent$y(this,"getPlotLinePath",wt,function(Mt){ut=pick$1o(ut,a.translate(nt,null,null,rt)),ut=clamp$h(ut,-1e5,1e5),ft=gt=Math.round(ut+ht),pt=yt=Math.round(st-ut-ht),isNumber$H(ut)?a.horiz?(pt=et,yt=st-a.bottom,ft=gt=xt(ft,tt,tt+a.width)):(ft=tt,gt=lt-a.right,pt=yt=xt(pt,et,et+a.height)):(mt=!0,dt=!1),Mt.path=mt&&!dt?null:k.renderer.crispLine([["M",ft,pt],["L",gt,yt]],ot||1)}),wt.path},j.prototype.getLinearTickPositions=function(E,a,k){var tt=correctFloat$b(Math.floor(a/E)*E),et=correctFloat$b(Math.ceil(k/E)*E),rt=[],nt,ot,st;if(correctFloat$b(tt+E)===tt&&(st=20),this.single)return[a];for(nt=tt;nt<=et&&(rt.push(nt),nt=correctFloat$b(nt+E,st),nt!==ot);)ot=nt;return rt},j.prototype.getMinorTickInterval=function(){var E=this.options;return E.minorTicks===!0?pick$1o(E.minorTickInterval,"auto"):E.minorTicks===!1?null:E.minorTickInterval},j.prototype.getMinorTickPositions=function(){var E=this,a=E.options,k=E.tickPositions,tt=E.minorTickInterval,et=E.pointRangePadding||0,rt=E.min-et,nt=E.max+et,ot=nt-rt,st=[],lt;if(ot&&ot/tt<E.len/3){var ht=E.logarithmic;if(ht)this.paddedTicks.forEach(function(ut,dt,ft){dt&&st.push.apply(st,ht.getLogTickPositions(tt,ft[dt-1],ft[dt],!0))});else if(E.dateTime&&this.getMinorTickInterval()==="auto")st=st.concat(E.getTimeTicks(E.dateTime.normalizeTimeTickInterval(tt),rt,nt,a.startOfWeek));else for(lt=rt+(k[0]-rt)%tt;lt<=nt&&lt!==st[0];lt+=tt)st.push(lt)}return st.length!==0&&E.trimTicks(st),st},j.prototype.adjustForMinRange=function(){var E=this,a=E.options,k=E.logarithmic,tt=E.min,et=E.max,rt,nt,ot=0,st,lt,ht,ut,dt,ft,pt;E.isXAxis&&typeof E.minRange>"u"&&!k&&(defined$N(a.min)||defined$N(a.max)?E.minRange=null:(E.series.forEach(function(gt){if(ht=gt.xData,ut=gt.xIncrement?1:ht.length-1,ht.length>1)for(st=ut;st>0;st--)lt=ht[st]-ht[st-1],(!ot||lt<ot)&&(ot=lt)}),E.minRange=Math.min(ot*5,E.dataMax-E.dataMin))),et-tt<E.minRange&&(nt=E.dataMax-E.dataMin>=E.minRange,pt=E.minRange,rt=(pt-et+tt)/2,dt=[tt-rt,pick$1o(a.min,tt-rt)],nt&&(dt[2]=E.logarithmic?E.logarithmic.log2lin(E.dataMin):E.dataMin),tt=arrayMax$9(dt),ft=[tt+pt,pick$1o(a.max,tt+pt)],nt&&(ft[2]=k?k.log2lin(E.dataMax):E.dataMax),et=arrayMin$8(ft),et-tt<pt&&(dt[0]=et-pt,dt[1]=pick$1o(a.min,et-pt),tt=arrayMax$9(dt))),E.min=tt,E.max=et},j.prototype.getClosest=function(){var E;return this.categories?E=1:this.series.forEach(function(a){var k=a.closestPointRange,tt=a.visible||!a.chart.options.chart.ignoreHiddenSeries;!a.noSharedTooltip&&defined$N(k)&&tt&&(E=defined$N(E)?Math.min(E,k):k)}),E},j.prototype.nameToX=function(E){var a=isArray$j(this.categories),k=a?this.categories:this.names,tt=E.options.x,et;return E.series.requireSorting=!1,defined$N(tt)||(tt=this.options.uniqueNames?a?k.indexOf(E.name):pick$1o(k.keys[E.name],-1):E.series.autoIncrement()),tt===-1?a||(et=k.length):et=tt,typeof et<"u"&&(this.names[et]=E.name,this.names.keys[E.name]=et),et},j.prototype.updateNames=function(){var E=this,a=this.names,k=a.length;k>0&&(Object.keys(a.keys).forEach(function(tt){delete a.keys[tt]}),a.length=0,this.minRange=this.userMinRange,(this.series||[]).forEach(function(tt){tt.xIncrement=null,(!tt.points||tt.isDirtyData)&&(E.max=Math.max(E.max,tt.xData.length-1),tt.processData(),tt.generatePoints()),tt.data.forEach(function(et,rt){var nt;et&&et.options&&typeof et.name<"u"&&(nt=E.nameToX(et),typeof nt<"u"&&nt!==et.x&&(et.x=nt,tt.xData[rt]=nt))})}))},j.prototype.setAxisTranslation=function(){var E=this,a=E.max-E.min,k=E.linkedParent,tt=!!E.categories,et=E.isXAxis,rt=E.axisPointRange||0,nt,ot=0,st=0,lt,ht=E.transA;(et||tt||rt)&&(nt=E.getClosest(),k?(ot=k.minPointOffset,st=k.pointRangePadding):E.series.forEach(function(ut){var dt=tt?1:et?pick$1o(ut.options.pointRange,nt,0):E.axisPointRange||0,ft=ut.options.pointPlacement;if(rt=Math.max(rt,dt),!E.single||tt){var pt=ut.is("xrange")?!et:et;ot=Math.max(ot,pt&&isString$7(ft)?0:dt/2),st=Math.max(st,pt&&ft==="on"?0:dt)}}),lt=E.ordinal&&E.ordinal.slope&&nt?E.ordinal.slope/nt:1,E.minPointOffset=ot=ot*lt,E.pointRangePadding=st=st*lt,E.pointRange=Math.min(rt,E.single&&tt?1:a),et&&(E.closestPointRange=nt)),E.translationSlope=E.transA=ht=E.staticScale||E.len/(a+st||1),E.transB=E.horiz?E.left:E.bottom,E.minPixelPadding=ht*ot,fireEvent$y(this,"afterSetAxisTranslation")},j.prototype.minFromRange=function(){var E=this;return E.max-E.range},j.prototype.setTickInterval=function(E){var a=this,k=a.chart,tt=a.logarithmic,et=a.options,rt=a.isXAxis,nt=a.isLinked,ot=et.tickPixelInterval,st=a.categories,lt=a.softThreshold,ht=et.maxPadding,ut=et.minPadding,dt,ft,pt=et.tickInterval,gt=isNumber$H(a.threshold)?a.threshold:null,yt,mt,xt,wt;!a.dateTime&&!st&&!nt&&this.getTickAmount(),xt=pick$1o(a.userMin,et.min),wt=pick$1o(a.userMax,et.max),nt?(a.linkedParent=k[a.coll][et.linkedTo],ft=a.linkedParent.getExtremes(),a.min=pick$1o(ft.min,ft.dataMin),a.max=pick$1o(ft.max,ft.dataMax),et.type!==a.linkedParent.options.type&&error$7(11,1,k)):(lt&&defined$N(gt)&&(a.dataMin>=gt?(yt=gt,ut=0):a.dataMax<=gt&&(mt=gt,ht=0)),a.min=pick$1o(xt,yt,a.dataMin),a.max=pick$1o(wt,mt,a.dataMax)),tt&&(a.positiveValuesOnly&&!E&&Math.min(a.min,pick$1o(a.dataMin,a.min))<=0&&error$7(10,1,k),a.min=correctFloat$b(tt.log2lin(a.min),16),a.max=correctFloat$b(tt.log2lin(a.max),16)),a.range&&defined$N(a.max)&&(a.userMin=a.min=xt=Math.max(a.dataMin,a.minFromRange()),a.userMax=wt=a.max,a.range=null),fireEvent$y(a,"foundExtremes"),a.beforePadding&&a.beforePadding(),a.adjustForMinRange(),!st&&!a.axisPointRange&&!(a.stacking&&a.stacking.usePercentage)&&!nt&&defined$N(a.min)&&defined$N(a.max)&&(dt=a.max-a.min,dt&&(!defined$N(xt)&&ut&&(a.min-=dt*ut),!defined$N(wt)&&ht&&(a.max+=dt*ht))),isNumber$H(a.userMin)||(isNumber$H(et.softMin)&&et.softMin<a.min&&(a.min=xt=et.softMin),isNumber$H(et.floor)&&(a.min=Math.max(a.min,et.floor))),isNumber$H(a.userMax)||(isNumber$H(et.softMax)&&et.softMax>a.max&&(a.max=wt=et.softMax),isNumber$H(et.ceiling)&&(a.max=Math.min(a.max,et.ceiling))),lt&&defined$N(a.dataMin)&&(gt=gt||0,!defined$N(xt)&&a.min<gt&&a.dataMin>=gt?a.min=a.options.minRange?Math.min(gt,a.max-a.minRange):gt:!defined$N(wt)&&a.max>gt&&a.dataMax<=gt&&(a.max=a.options.minRange?Math.max(gt,a.min+a.minRange):gt)),isNumber$H(a.min)&&isNumber$H(a.max)&&!this.chart.polar&&a.min>a.max&&(defined$N(a.options.min)?a.max=a.min:defined$N(a.options.max)&&(a.min=a.max)),a.min===a.max||typeof a.min>"u"||typeof a.max>"u"?a.tickInterval=1:nt&&a.linkedParent&&!pt&&ot===a.linkedParent.options.tickPixelInterval?a.tickInterval=pt=a.linkedParent.tickInterval:a.tickInterval=pick$1o(pt,this.tickAmount?(a.max-a.min)/Math.max(this.tickAmount-1,1):void 0,st?1:(a.max-a.min)*ot/Math.max(a.len,ot)),rt&&!E&&(a.series.forEach(function(At){At.forceCrop=At.forceCropping&&At.forceCropping(),At.processData(a.min!==(a.old&&a.old.min)||a.max!==(a.old&&a.old.max))}),fireEvent$y(this,"postProcessData")),a.setAxisTranslation(),fireEvent$y(this,"initialAxisTranslation"),a.pointRange&&!pt&&(a.tickInterval=Math.max(a.pointRange,a.tickInterval));var Mt=pick$1o(et.minTickInterval,a.dateTime&&!a.series.some(function(At){return At.noSharedTooltip})?a.closestPointRange:0);!pt&&a.tickInterval<Mt&&(a.tickInterval=Mt),!a.dateTime&&!a.logarithmic&&!pt&&(a.tickInterval=normalizeTickInterval$2(a.tickInterval,void 0,getMagnitude$2(a.tickInterval),pick$1o(et.allowDecimals,a.tickInterval<.5||this.tickAmount!==void 0),!!this.tickAmount)),this.tickAmount||(a.tickInterval=a.unsquish()),this.setTickPositions()},j.prototype.setTickPositions=function(){var E=this,a=this.options,k=a.tickPositions,tt=this.getMinorTickInterval(),et=this.hasVerticalPanning(),rt=this.coll==="colorAxis",nt=(rt||!et)&&a.startOnTick,ot=(rt||!et)&&a.endOnTick,st,lt=a.tickPositioner;this.tickmarkOffset=this.categories&&a.tickmarkPlacement==="between"&&this.tickInterval===1?.5:0,this.minorTickInterval=tt==="auto"&&this.tickInterval?this.tickInterval/5:tt,this.single=this.min===this.max&&defined$N(this.min)&&!this.tickAmount&&(parseInt(this.min,10)===this.min||a.allowDecimals!==!1),this.tickPositions=st=k&&k.slice(),st||((!E.ordinal||!E.ordinal.positions)&&(this.max-this.min)/this.tickInterval>Math.max(2*this.len,200)?(st=[this.min,this.max],error$7(19,!1,this.chart)):E.dateTime?st=E.getTimeTicks(E.dateTime.normalizeTimeTickInterval(this.tickInterval,a.units),this.min,this.max,a.startOfWeek,E.ordinal&&E.ordinal.positions,this.closestPointRange,!0):E.logarithmic?st=E.logarithmic.getLogTickPositions(this.tickInterval,this.min,this.max):st=this.getLinearTickPositions(this.tickInterval,this.min,this.max),st.length>this.len&&(st=[st[0],st.pop()],st[0]===st[1]&&(st.length=1)),this.tickPositions=st,lt&&(lt=lt.apply(E,[this.min,this.max]),lt&&(this.tickPositions=st=lt))),this.paddedTicks=st.slice(0),this.trimTicks(st,nt,ot),this.isLinked||(this.single&&st.length<2&&!this.categories&&!this.series.some(function(ht){return ht.is("heatmap")&&ht.options.pointPlacement==="between"})&&(this.min-=.5,this.max+=.5),!k&&!lt&&this.adjustTickAmount()),fireEvent$y(this,"afterSetTickPositions")},j.prototype.trimTicks=function(E,a,k){var tt=E[0],et=E[E.length-1],rt=!this.isOrdinal&&this.minPointOffset||0;if(fireEvent$y(this,"trimTicks"),!this.isLinked){if(a&&tt!==-1/0)this.min=tt;else for(;this.min-rt>E[0];)E.shift();if(k)this.max=et;else for(;this.max+rt<E[E.length-1];)E.pop();E.length===0&&defined$N(tt)&&!this.options.tickPositions&&E.push((et+tt)/2)}},j.prototype.alignToOthers=function(){var E=this,a={},k=E.options,tt;return this.chart.options.chart.alignTicks!==!1&&k.alignTicks&&k.startOnTick!==!1&&k.endOnTick!==!1&&!E.logarithmic&&this.chart[this.coll].forEach(function(et){var rt=et.options,nt=et.horiz,ot=[nt?rt.left:rt.top,rt.width,rt.height,rt.pane].join(",");et.series.length&&(a[ot]?tt=!0:a[ot]=1)}),tt},j.prototype.getTickAmount=function(){var E=this,a=this.options,k=a.tickPixelInterval,tt=a.tickAmount;!defined$N(a.tickInterval)&&!tt&&this.len<k&&!this.isRadial&&!E.logarithmic&&a.startOnTick&&a.endOnTick&&(tt=2),!tt&&this.alignToOthers()&&(tt=Math.ceil(this.len/k)+1),tt<4&&(this.finalTickAmt=tt,tt=5),this.tickAmount=tt},j.prototype.adjustTickAmount=function(){var E=this,a=E.options,k=E.tickInterval,tt=E.tickPositions,et=E.tickAmount,rt=E.finalTickAmt,nt=tt&&tt.length,ot=pick$1o(E.threshold,E.softThreshold?0:null),st,lt;if(E.hasData()&&isNumber$H(E.min)&&isNumber$H(E.max)){if(nt<et){for(;tt.length<et;)tt.length%2||E.min===ot?tt.push(correctFloat$b(tt[tt.length-1]+k)):tt.unshift(correctFloat$b(tt[0]-k));E.transA*=(nt-1)/(et-1),E.min=a.startOnTick?tt[0]:Math.min(E.min,tt[0]),E.max=a.endOnTick?tt[tt.length-1]:Math.max(E.max,tt[tt.length-1])}else nt>et&&(E.tickInterval*=2,E.setTickPositions());if(defined$N(rt)){for(lt=st=tt.length;lt--;)(rt===3&&lt%2===1||rt<=2&&lt>0&&lt<st-1)&&tt.splice(lt,1);E.finalTickAmt=void 0}}},j.prototype.setScale=function(){var E=this,a=!1,k=!1;E.series.forEach(function(et){a=a||et.isDirtyData||et.isDirty,k=k||et.xAxis&&et.xAxis.isDirty||!1}),E.setAxisSize();var tt=E.len!==(E.old&&E.old.len);tt||a||k||E.isLinked||E.forceRedraw||E.userMin!==(E.old&&E.old.userMin)||E.userMax!==(E.old&&E.old.userMax)||E.alignToOthers()?(E.stacking&&E.stacking.resetStacks(),E.forceRedraw=!1,E.getSeriesExtremes(),E.setTickInterval(),E.isDirty||(E.isDirty=tt||E.min!==(E.old&&E.old.min)||E.max!==(E.old&&E.old.max))):E.stacking&&E.stacking.cleanStacks(),a&&E.panningState&&(E.panningState.isDirty=!0),fireEvent$y(this,"afterSetScale")},j.prototype.setExtremes=function(E,a,k,tt,et){var rt=this,nt=rt.chart;k=pick$1o(k,!0),rt.series.forEach(function(ot){delete ot.kdTree}),et=extend$1m(et,{min:E,max:a}),fireEvent$y(rt,"setExtremes",et,function(){rt.userMin=E,rt.userMax=a,rt.eventArgs=et,k&&nt.redraw(tt)})},j.prototype.zoom=function(E,a){var k=this,tt=this.dataMin,et=this.dataMax,rt=this.options,nt=Math.min(tt,pick$1o(rt.min,tt)),ot=Math.max(et,pick$1o(rt.max,et)),st={newMin:E,newMax:a};return fireEvent$y(this,"zoom",st,function(lt){var ht=lt.newMin,ut=lt.newMax;(ht!==k.min||ut!==k.max)&&(k.allowZoomOutside||(defined$N(tt)&&(ht<nt&&(ht=nt),ht>ot&&(ht=ot)),defined$N(et)&&(ut<nt&&(ut=nt),ut>ot&&(ut=ot))),k.displayBtn=typeof ht<"u"||typeof ut<"u",k.setExtremes(ht,ut,!1,void 0,{trigger:"zoom"})),lt.zoomed=!0}),st.zoomed},j.prototype.setAxisSize=function(){var E=this.chart,a=this.options,k=a.offsets||[0,0,0,0],tt=this.horiz,et=this.width=Math.round(relativeLength$9(pick$1o(a.width,E.plotWidth-k[3]+k[1]),E.plotWidth)),rt=this.height=Math.round(relativeLength$9(pick$1o(a.height,E.plotHeight-k[0]+k[2]),E.plotHeight)),nt=this.top=Math.round(relativeLength$9(pick$1o(a.top,E.plotTop+k[0]),E.plotHeight,E.plotTop)),ot=this.left=Math.round(relativeLength$9(pick$1o(a.left,E.plotLeft+k[3]),E.plotWidth,E.plotLeft));this.bottom=E.chartHeight-rt-nt,this.right=E.chartWidth-et-ot,this.len=Math.max(tt?et:rt,0),this.pos=tt?ot:nt},j.prototype.getExtremes=function(){var E=this,a=E.logarithmic;return{min:a?correctFloat$b(a.lin2log(E.min)):E.min,max:a?correctFloat$b(a.lin2log(E.max)):E.max,dataMin:E.dataMin,dataMax:E.dataMax,userMin:E.userMin,userMax:E.userMax}},j.prototype.getThreshold=function(E){var a=this,k=a.logarithmic,tt=k?k.lin2log(a.min):a.min,et=k?k.lin2log(a.max):a.max;return E===null||E===-1/0?E=tt:E===1/0?E=et:tt>E?E=tt:et<E&&(E=et),a.translate(E,0,1,0,1)},j.prototype.autoLabelAlign=function(E){var a=(pick$1o(E,0)-this.side*90+720)%360,k={align:"center"};return fireEvent$y(this,"autoLabelAlign",k,function(tt){a>15&&a<165?tt.align="right":a>195&&a<345&&(tt.align="left")}),k.align},j.prototype.tickSize=function(E){var a=this.options,k=pick$1o(a[E==="tick"?"tickWidth":"minorTickWidth"],E==="tick"&&this.isXAxis&&!this.categories?1:0),tt=a[E==="tick"?"tickLength":"minorTickLength"],et;k&&tt&&(a[E+"Position"]==="inside"&&(tt=-tt),et=[tt,k]);var rt={tickSize:et};return fireEvent$y(this,"afterTickSize",rt),rt.tickSize},j.prototype.labelMetrics=function(){var E=this.tickPositions&&this.tickPositions[0]||0;return this.chart.renderer.fontMetrics(this.options.labels.style.fontSize,this.ticks[E]&&this.ticks[E].label)},j.prototype.unsquish=function(){var E=this.options.labels,a=this.horiz,k=this.tickInterval,tt=this.len/(((this.categories?1:0)+this.max-this.min)/k),et=E.rotation,rt=this.labelMetrics(),nt=Math.max(this.max-this.min,0),ot=function(ft){var pt=ft/(tt||1);return pt=pt>1?Math.ceil(pt):1,pt*k>nt&&ft!==1/0&&tt!==1/0&&nt&&(pt=Math.ceil(nt/k)),correctFloat$b(pt*k)},st=k,lt,ht,ut=Number.MAX_VALUE,dt;return a?(!E.staggerLines&&!E.step&&(isNumber$H(et)?dt=[et]:tt<E.autoRotationLimit&&(dt=E.autoRotation)),dt&&dt.forEach(function(ft){var pt;(ft===et||ft&&ft>=-90&&ft<=90)&&(ht=ot(Math.abs(rt.h/Math.sin(deg2rad$5*ft))),pt=ht+Math.abs(ft/360),pt<ut&&(ut=pt,lt=ft,st=ht))})):E.step||(st=ot(rt.h)),this.autoRotation=dt,this.labelRotation=pick$1o(lt,isNumber$H(et)?et:0),st},j.prototype.getSlotWidth=function(E){var a=this.chart,k=this.horiz,tt=this.options.labels,et=Math.max(this.tickPositions.length-(this.categories?0:1),1),rt=a.margin[3];if(E&&isNumber$H(E.slotWidth))return E.slotWidth;if(k&&tt.step<2)return tt.rotation?0:(this.staggerLines||1)*this.len/et;if(!k){var nt=tt.style.width;if(nt!==void 0)return parseInt(String(nt),10);if(rt)return rt-a.spacing[3]}return a.chartWidth*.33},j.prototype.renderUnsquish=function(){var E=this.chart,a=E.renderer,k=this.tickPositions,tt=this.ticks,et=this.options.labels,rt=et.style,nt=this.horiz,ot=this.getSlotWidth(),st=Math.max(1,Math.round(ot-2*et.padding)),lt={},ht=this.labelMetrics(),ut=rt.textOverflow,dt,ft,pt=0,gt,yt,mt;if(isString$7(et.rotation)||(lt.rotation=et.rotation||0),k.forEach(function(xt){var wt=tt[xt];wt.movedLabel&&wt.replaceMovedLabel(),wt&&wt.label&&wt.label.textPxLength>pt&&(pt=wt.label.textPxLength)}),this.maxLabelLength=pt,this.autoRotation)pt>st&&pt>ht.h?lt.rotation=this.labelRotation:this.labelRotation=0;else if(ot&&(dt=st,!ut))for(ft="clip",yt=k.length;!nt&&yt--;)mt=k[yt],gt=tt[mt].label,gt&&(gt.styles&&gt.styles.textOverflow==="ellipsis"?gt.css({textOverflow:"clip"}):gt.textPxLength>ot&&gt.css({width:ot+"px"}),gt.getBBox().height>this.len/k.length-(ht.h-ht.f)&&(gt.specificTextOverflow="ellipsis"));lt.rotation&&(dt=pt>E.chartHeight*.5?E.chartHeight*.33:pt,ut||(ft="ellipsis")),this.labelAlign=et.align||this.autoLabelAlign(this.labelRotation),this.labelAlign&&(lt.align=this.labelAlign),k.forEach(function(xt){var wt=tt[xt],Mt=wt&&wt.label,At=rt.width,St={};Mt&&(Mt.attr(lt),wt.shortenLabel?wt.shortenLabel():dt&&!At&&rt.whiteSpace!=="nowrap"&&(dt<Mt.textPxLength||Mt.element.tagName==="SPAN")?(St.width=dt+"px",ut||(St.textOverflow=Mt.specificTextOverflow||ft),Mt.css(St)):Mt.styles&&Mt.styles.width&&!St.width&&!At&&Mt.css({width:null}),delete Mt.specificTextOverflow,wt.rotation=lt.rotation)},this),this.tickRotCorr=a.rotCorr(ht.b,this.labelRotation||0,this.side!==0)},j.prototype.hasData=function(){return this.series.some(function(E){return E.hasData()})||this.options.showEmpty&&defined$N(this.min)&&defined$N(this.max)},j.prototype.addTitle=function(E){var a=this,k=a.chart.renderer,tt=a.horiz,et=a.opposite,rt=a.options,nt=rt.title,ot=a.chart.styledMode,st;a.axisTitle||(st=nt.textAlign,st||(st=(tt?{low:"left",middle:"center",high:"right"}:{low:et?"right":"left",middle:"center",high:et?"left":"right"})[nt.align]),a.axisTitle=k.text(nt.text||"",0,0,nt.useHTML).attr({zIndex:7,rotation:nt.rotation,align:st}).addClass("highcharts-axis-title"),ot||a.axisTitle.css(merge$1g(nt.style)),a.axisTitle.add(a.axisGroup),a.axisTitle.isNew=!0),!ot&&!nt.style.width&&!a.isRadial&&a.axisTitle.css({width:a.len+"px"}),a.axisTitle[E?"show":"hide"](E)},j.prototype.generateTick=function(E){var a=this,k=a.ticks;k[E]?k[E].addLabel():k[E]=new Tick(a,E)},j.prototype.getOffset=function(){var E=this,a=this,k=a.chart,tt=k.renderer,et=a.options,rt=a.tickPositions,nt=a.ticks,ot=a.horiz,st=a.side,lt=k.inverted&&!a.isZAxis?[1,0,3,2][st]:st,ht=a.hasData(),ut=et.title,dt=et.labels,ft=k.axisOffset,pt=k.clipOffset,gt=[-1,1,1,-1][st],yt=et.className,mt=a.axisParent,xt,wt=0,Mt,At=0,St=0,$t,Tt;if(a.showAxis=xt=ht||et.showEmpty,a.staggerLines=a.horiz&&dt.staggerLines||void 0,!a.axisGroup){var Pt=function(Nt,Ht,jt){return tt.g(Nt).attr({zIndex:jt}).addClass("highcharts-"+E.coll.toLowerCase()+Ht+" "+(E.isRadial?"highcharts-radial-axis"+Ht+" ":"")+(yt||"")).add(mt)};a.gridGroup=Pt("grid","-grid",et.gridZIndex),a.axisGroup=Pt("axis","",et.zIndex),a.labelGroup=Pt("axis-labels","-labels",dt.zIndex)}ht||a.isLinked?(rt.forEach(function(Nt){a.generateTick(Nt)}),a.renderUnsquish(),a.reserveSpaceDefault=st===0||st===2||{1:"left",3:"right"}[st]===a.labelAlign,pick$1o(dt.reserveSpace,a.labelAlign==="center"?!0:null,a.reserveSpaceDefault)&&rt.forEach(function(Nt){St=Math.max(nt[Nt].getLabelSize(),St)}),a.staggerLines&&(St*=a.staggerLines),a.labelOffset=St*(a.opposite?-1:1)):objectEach$s(nt,function(Nt,Ht){Nt.destroy(),delete nt[Ht]}),ut&&ut.text&&ut.enabled!==!1&&(a.addTitle(xt),xt&&ut.reserveSpace!==!1&&(a.titleOffset=wt=a.axisTitle.getBBox()[ot?"height":"width"],Mt=ut.offset,At=defined$N(Mt)?0:pick$1o(ut.margin,ot?5:10))),a.renderLine(),a.offset=gt*pick$1o(et.offset,ft[st]?ft[st]+(et.margin||0):0),a.tickRotCorr=a.tickRotCorr||{x:0,y:0},st===0?Tt=-a.labelMetrics().h:st===2?Tt=a.tickRotCorr.y:Tt=0,$t=Math.abs(St)+At,St&&($t-=Tt,$t+=gt*(ot?pick$1o(dt.y,a.tickRotCorr.y+gt*8):dt.x)),a.axisTitleMargin=pick$1o(Mt,$t),a.getMaxLabelDimensions&&(a.maxLabelDimensions=a.getMaxLabelDimensions(nt,rt));var It=this.tickSize("tick");ft[st]=Math.max(ft[st],(a.axisTitleMargin||0)+wt+gt*a.offset,$t,rt&&rt.length&&It?It[0]+gt*a.offset:0);var Lt=et.offset?0:Math.floor(a.axisLine.strokeWidth()/2)*2;pt[lt]=Math.max(pt[lt],Lt),fireEvent$y(this,"afterGetOffset")},j.prototype.getLinePath=function(E){var a=this.chart,k=this.opposite,tt=this.offset,et=this.horiz,rt=this.left+(k?this.width:0)+tt,nt=a.chartHeight-this.bottom-(k?this.height:0)+tt;return k&&(E*=-1),a.renderer.crispLine([["M",et?this.left:rt,et?nt:this.top],["L",et?a.chartWidth-this.right:rt,et?nt:a.chartHeight-this.bottom]],E)},j.prototype.renderLine=function(){this.axisLine||(this.axisLine=this.chart.renderer.path().addClass("highcharts-axis-line").add(this.axisGroup),this.chart.styledMode||this.axisLine.attr({stroke:this.options.lineColor,"stroke-width":this.options.lineWidth,zIndex:7}))},j.prototype.getTitlePosition=function(){var E=this.horiz,a=this.left,k=this.top,tt=this.len,et=this.options.title,rt=E?a:k,nt=this.opposite,ot=this.offset,st=et.x,lt=et.y,ht=this.axisTitle,ut=this.chart.renderer.fontMetrics(et.style.fontSize,ht),dt=Math.max(ht.getBBox(null,0).height-ut.h-1,0),ft={low:rt+(E?0:tt),middle:rt+tt/2,high:rt+(E?tt:0)}[et.align],pt=(E?k+this.height:a)+(E?1:-1)*(nt?-1:1)*this.axisTitleMargin+[-dt,dt,ut.f,-dt][this.side],gt={x:E?ft+st:pt+(nt?this.width:0)+ot+st,y:E?pt+lt-(nt?this.height:0)+ot:ft+lt};return fireEvent$y(this,"afterGetTitlePosition",{titlePosition:gt}),gt},j.prototype.renderMinorTick=function(E,a){var k=this,tt=k.minorTicks;tt[E]||(tt[E]=new Tick(k,E,"minor")),a&&tt[E].isNew&&tt[E].render(null,!0),tt[E].render(null,!1,1)},j.prototype.renderTick=function(E,a,k){var tt=this,et=tt.isLinked,rt=tt.ticks;(!et||E>=tt.min&&E<=tt.max||tt.grid&&tt.grid.isColumn)&&(rt[E]||(rt[E]=new Tick(tt,E)),k&&rt[E].isNew&&rt[E].render(a,!0,-1),rt[E].render(a))},j.prototype.render=function(){var E=this,a=E.chart,k=E.logarithmic,tt=a.renderer,et=E.options,rt=E.isLinked,nt=E.tickPositions,ot=E.axisTitle,st=E.ticks,lt=E.minorTicks,ht=E.alternateBands,ut=et.stackLabels,dt=et.alternateGridColor,ft=E.tickmarkOffset,pt=E.axisLine,gt=E.showAxis,yt=animObject$a(tt.globalAnimation),mt,xt;if(E.labelEdge.length=0,E.overlap=!1,[st,lt,ht].forEach(function(At){objectEach$s(At,function(St){St.isActive=!1})}),E.hasData()||rt){var wt=E.chart.hasRendered&&E.old&&isNumber$H(E.old.min);E.minorTickInterval&&!E.categories&&E.getMinorTickPositions().forEach(function(At){E.renderMinorTick(At,wt)}),nt.length&&(nt.forEach(function(At,St){E.renderTick(At,St,wt)}),ft&&(E.min===0||E.single)&&(st[-1]||(st[-1]=new Tick(E,-1,null,!0)),st[-1].render(-1))),dt&&nt.forEach(function(At,St){xt=typeof nt[St+1]<"u"?nt[St+1]+ft:E.max-ft,St%2===0&&At<E.max&&xt<=E.max+(a.polar?-ft:ft)&&(ht[At]||(ht[At]=new H.PlotLineOrBand(E)),mt=At+ft,ht[At].options={from:k?k.lin2log(mt):mt,to:k?k.lin2log(xt):xt,color:dt,className:"highcharts-alternate-grid"},ht[At].render(),ht[At].isActive=!0)}),E._addedPlotLB||(E._addedPlotLB=!0,(et.plotLines||[]).concat(et.plotBands||[]).forEach(function(At){E.addPlotBandOrLine(At)}))}if([st,lt,ht].forEach(function(At){var St=[],$t=yt.duration,Tt=function(){for(var Pt=St.length;Pt--;)At[St[Pt]]&&!At[St[Pt]].isActive&&(At[St[Pt]].destroy(),delete At[St[Pt]])};objectEach$s(At,function(Pt,It){Pt.isActive||(Pt.render(It,!1,0),Pt.isActive=!1,St.push(It))}),syncTimeout$7(Tt,At===ht||!a.hasRendered||!$t?0:$t)}),pt&&(pt[pt.isPlaced?"animate":"attr"]({d:this.getLinePath(pt.strokeWidth())}),pt.isPlaced=!0,pt[gt?"show":"hide"](gt)),ot&&gt){var Mt=E.getTitlePosition();isNumber$H(Mt.y)?(ot[ot.isNew?"attr":"animate"](Mt),ot.isNew=!1):(ot.attr("y",-9999),ot.isNew=!0)}ut&&ut.enabled&&E.stacking&&E.stacking.renderStackTotals(),E.old={len:E.len,max:E.max,min:E.min,transA:E.transA,userMax:E.userMax,userMin:E.userMin},E.isDirty=!1,fireEvent$y(this,"afterRender")},j.prototype.redraw=function(){this.visible&&(this.render(),this.plotLinesAndBands.forEach(function(E){E.render()})),this.series.forEach(function(E){E.isDirty=!0})},j.prototype.getKeepProps=function(){return this.keepProps||j.keepProps},j.prototype.destroy=function(E){var a=this,k=a.plotLinesAndBands,tt=this.eventOptions;if(fireEvent$y(this,"destroy",{keepEvents:E}),E||removeEvent$9(a),[a.ticks,a.minorTicks,a.alternateBands].forEach(function(nt){destroyObjectProperties$7(nt)}),k)for(var et=k.length;et--;)k[et].destroy();["axisLine","axisTitle","axisGroup","gridGroup","labelGroup","cross","scrollbar"].forEach(function(nt){a[nt]&&(a[nt]=a[nt].destroy())});for(var rt in a.plotLinesAndBandsGroups)a.plotLinesAndBandsGroups[rt]=a.plotLinesAndBandsGroups[rt].destroy();objectEach$s(a,function(nt,ot){a.getKeepProps().indexOf(ot)===-1&&delete a[ot]}),this.eventOptions=tt},j.prototype.drawCrosshair=function(E,a){var k=this.crosshair,tt=pick$1o(k&&k.snap,!0),et=this.chart,rt,nt,ot,st=this.cross,lt;if(fireEvent$y(this,"drawCrosshair",{e:E,point:a}),E||(E=this.cross&&this.cross.e),!k||(defined$N(a)||!tt)===!1)this.hideCrosshair();else{if(tt?defined$N(a)&&(nt=pick$1o(this.coll!=="colorAxis"?a.crosshairPos:null,this.isXAxis?a.plotX:this.len-a.plotY)):nt=E&&(this.horiz?E.chartX-this.pos:this.len-E.chartY+this.pos),defined$N(nt)&&(lt={value:a&&(this.isXAxis?a.x:pick$1o(a.stackY,a.y)),translatedValue:nt},et.polar&&extend$1m(lt,{isCrosshair:!0,chartX:E&&E.chartX,chartY:E&&E.chartY,point:a}),rt=this.getPlotLinePath(lt)||null),!defined$N(rt)){this.hideCrosshair();return}ot=this.categories&&!this.isRadial,st||(this.cross=st=et.renderer.path().addClass("highcharts-crosshair highcharts-crosshair-"+(ot?"category ":"thin ")+(k.className||"")).attr({zIndex:pick$1o(k.zIndex,2)}).add(),et.styledMode||(st.attr({stroke:k.color||(ot?Color.parse(palette.highlightColor20).setOpacity(.25).get():palette.neutralColor20),"stroke-width":pick$1o(k.width,1)}).css({"pointer-events":"none"}),k.dashStyle&&st.attr({dashstyle:k.dashStyle}))),st.show().attr({d:rt}),ot&&!k.width&&st.attr({"stroke-width":this.transA}),this.cross.e=E}fireEvent$y(this,"afterDrawCrosshair",{e:E,point:a})},j.prototype.hideCrosshair=function(){this.cross&&this.cross.hide(),fireEvent$y(this,"afterHideCrosshair")},j.prototype.hasVerticalPanning=function(){var E=this.chart.options.chart.panning;return Boolean(E&&E.enabled&&/y/.test(E.type))},j.prototype.validatePositiveValue=function(E){return isNumber$H(E)&&E>0},j.prototype.update=function(E,a){var k=this.chart;E=merge$1g(this.userOptions,E),this.destroy(!0),this.init(k,E),k.isDirtyBox=!0,pick$1o(a,!0)&&k.redraw()},j.prototype.remove=function(E){for(var a=this.chart,k=this.coll,tt=this.series,et=tt.length;et--;)tt[et]&&tt[et].remove(!1);erase$7(a.axes,this),erase$7(a[k],this),a[k].forEach(function(rt,nt){rt.options.index=rt.userOptions.index=nt}),this.destroy(),a.isDirtyBox=!0,pick$1o(E,!0)&&a.redraw()},j.prototype.setTitle=function(E,a){this.update({title:E},a)},j.prototype.setCategories=function(E,a){this.update({categories:E},a)},j.defaultOptions=AxisDefaults$1.defaultXAxisOptions,j.keepProps=["extKey","hcEvents","names","series","userMax","userMin"],j}(),addEvent$_=Utilities.addEvent,getMagnitude$1=Utilities.getMagnitude,normalizeTickInterval$1=Utilities.normalizeTickInterval,timeUnits$1=Utilities.timeUnits,DateTimeAxis;(function(j){var E=[];function a(rt){if(E.indexOf(rt)===-1){E.push(rt),rt.keepProps.push("dateTime");var nt=rt.prototype;nt.getTimeTicks=k,addEvent$_(rt,"init",tt)}return rt}j.compose=a;function k(){return this.chart.time.getTimeTicks.apply(this.chart.time,arguments)}function tt(rt){var nt=this,ot=rt.userOptions;if(ot.type!=="datetime"){nt.dateTime=void 0;return}nt.dateTime||(nt.dateTime=new et(nt))}var et=function(){function rt(nt){this.axis=nt}return rt.prototype.normalizeTimeTickInterval=function(nt,ot){var st=ot||[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2]],["week",[1,2]],["month",[1,2,3,4,6]],["year",null]],lt=st[st.length-1],ht=timeUnits$1[lt[0]],ut=lt[1],dt;for(dt=0;dt<st.length;dt++)if(lt=st[dt],ht=timeUnits$1[lt[0]],ut=lt[1],st[dt+1]){var ft=(ht*ut[ut.length-1]+timeUnits$1[st[dt+1][0]])/2;if(nt<=ft)break}ht===timeUnits$1.year&&nt<5*ht&&(ut=[1,2,5]);var pt=normalizeTickInterval$1(nt/ht,ut,lt[0]==="year"?Math.max(getMagnitude$1(nt/ht),1):1);return{unitRange:ht,count:pt,unitName:lt[0]}},rt.prototype.getXDateFormat=function(nt,ot){var st=this.axis;return st.closestPointRange?st.chart.time.getDateFormat(st.closestPointRange,nt,st.options.startOfWeek,ot)||ot.year:ot.day},rt}();j.Additions=et})(DateTimeAxis||(DateTimeAxis={}));const DateTimeAxis$1=DateTimeAxis;var addEvent$Z=Utilities.addEvent,getMagnitude=Utilities.getMagnitude,normalizeTickInterval=Utilities.normalizeTickInterval,pick$1n=Utilities.pick,LogarithmicAxis;(function(j){var E=[];function a(rt){return E.indexOf(rt)===-1&&(E.push(rt),rt.keepProps.push("logarithmic"),addEvent$Z(rt,"init",k),addEvent$Z(rt,"afterInit",tt)),rt}j.compose=a;function k(rt){var nt=this,ot=rt.userOptions,st=nt.logarithmic;ot.type!=="logarithmic"?nt.logarithmic=void 0:st||(st=nt.logarithmic=new et(nt))}function tt(){var rt=this,nt=rt.logarithmic;nt&&(rt.lin2val=function(ot){return nt.lin2log(ot)},rt.val2lin=function(ot){return nt.log2lin(ot)})}var et=function(){function rt(nt){this.axis=nt}return rt.prototype.getLogTickPositions=function(nt,ot,st,lt){var ht=this,ut=ht.axis,dt=ut.len,ft=ut.options,pt=[];if(lt||(ht.minorAutoInterval=void 0),nt>=.5)nt=Math.round(nt),pt=ut.getLinearTickPositions(nt,ot,st);else if(nt>=.08){var gt=Math.floor(ot),yt=void 0,mt=void 0,xt=void 0,wt=void 0,Mt=void 0,At=void 0,St=void 0;for(nt>.3?yt=[1,2,4]:nt>.15?yt=[1,2,4,6,8]:yt=[1,2,3,4,5,6,7,8,9],mt=gt;mt<st+1&&!St;mt++)for(wt=yt.length,xt=0;xt<wt&&!St;xt++)Mt=ht.log2lin(ht.lin2log(mt)*yt[xt]),Mt>ot&&(!lt||At<=st)&&typeof At<"u"&&pt.push(At),At>st&&(St=!0),At=Mt}else{var $t=ht.lin2log(ot),Tt=ht.lin2log(st),Pt=lt?ut.getMinorTickInterval():ft.tickInterval,It=Pt==="auto"?null:Pt,Lt=ft.tickPixelInterval/(lt?5:1),Nt=lt?dt/ut.tickPositions.length:dt;nt=pick$1n(It,ht.minorAutoInterval,(Tt-$t)*Lt/(Nt||1)),nt=normalizeTickInterval(nt,void 0,getMagnitude(nt)),pt=ut.getLinearTickPositions(nt,$t,Tt).map(ht.log2lin),lt||(ht.minorAutoInterval=nt/5)}return lt||(ut.tickInterval=nt),pt},rt.prototype.lin2log=function(nt){return Math.pow(10,nt)},rt.prototype.log2lin=function(nt){return Math.log(nt)/Math.LN10},rt}();j.Additions=et})(LogarithmicAxis||(LogarithmicAxis={}));const LogarithmicAxis$1=LogarithmicAxis;var erase$6=Utilities.erase,extend$1l=Utilities.extend,isNumber$G=Utilities.isNumber,PlotLineOrBandAxis;(function(j){var E=[],a;function k(et,rt){return a||(a=et),E.indexOf(rt)===-1&&(E.push(rt),extend$1l(rt.prototype,tt.prototype)),rt}j.compose=k;var tt=function(){function et(){}return et.prototype.getPlotBandPath=function(rt,nt,ot){ot===void 0&&(ot=this.options);var st=this.getPlotLinePath({value:nt,force:!0,acrossPanes:ot.acrossPanes}),lt=[],ht=this.horiz,ut=!isNumber$G(this.min)||!isNumber$G(this.max)||rt<this.min&&nt<this.min||rt>this.max&&nt>this.max,dt=this.getPlotLinePath({value:rt,force:!0,acrossPanes:ot.acrossPanes}),ft,pt=1,gt;if(dt&&st)for(ut&&(gt=dt.toString()===st.toString(),pt=0),ft=0;ft<dt.length;ft+=2){var yt=dt[ft],mt=dt[ft+1],xt=st[ft],wt=st[ft+1];(yt[0]==="M"||yt[0]==="L")&&(mt[0]==="M"||mt[0]==="L")&&(xt[0]==="M"||xt[0]==="L")&&(wt[0]==="M"||wt[0]==="L")&&(ht&&xt[1]===yt[1]?(xt[1]+=pt,wt[1]+=pt):!ht&&xt[2]===yt[2]&&(xt[2]+=pt,wt[2]+=pt),lt.push(["M",yt[1],yt[2]],["L",mt[1],mt[2]],["L",wt[1],wt[2]],["L",xt[1],xt[2]],["Z"])),lt.isFlat=gt}else dt=null;return lt},et.prototype.addPlotBand=function(rt){return this.addPlotBandOrLine(rt,"plotBands")},et.prototype.addPlotLine=function(rt){return this.addPlotBandOrLine(rt,"plotLines")},et.prototype.addPlotBandOrLine=function(rt,nt){var ot=this,st=this.userOptions,lt=new a(this,rt);if(this.visible&&(lt=lt.render()),lt){if(this._addedPlotLB||(this._addedPlotLB=!0,(st.plotLines||[]).concat(st.plotBands||[]).forEach(function(ut){ot.addPlotBandOrLine(ut)})),nt){var ht=st[nt]||[];ht.push(rt),st[nt]=ht}this.plotLinesAndBands.push(lt)}return lt},et.prototype.removePlotBandOrLine=function(rt){var nt=this.plotLinesAndBands,ot=this.options,st=this.userOptions;if(nt){for(var lt=nt.length;lt--;)nt[lt].id===rt&&nt[lt].destroy();[ot.plotLines||[],st.plotLines||[],ot.plotBands||[],st.plotBands||[]].forEach(function(ht){for(lt=ht.length;lt--;)(ht[lt]||{}).id===rt&&erase$6(ht,ht[lt])})}},et.prototype.removePlotBand=function(rt){this.removePlotBandOrLine(rt)},et.prototype.removePlotLine=function(rt){this.removePlotBandOrLine(rt)},et}()})(PlotLineOrBandAxis||(PlotLineOrBandAxis={}));const PlotLineOrBandAxis$1=PlotLineOrBandAxis;var arrayMax$8=Utilities.arrayMax,arrayMin$7=Utilities.arrayMin,defined$M=Utilities.defined,destroyObjectProperties$6=Utilities.destroyObjectProperties,erase$5=Utilities.erase,fireEvent$x=Utilities.fireEvent,merge$1f=Utilities.merge,objectEach$r=Utilities.objectEach,pick$1m=Utilities.pick,PlotLineOrBand=function(){function j(E,a){this.axis=E,a&&(this.options=a,this.id=a.id)}return j.compose=function(E){return PlotLineOrBandAxis$1.compose(j,E)},j.prototype.render=function(){fireEvent$x(this,"render");var E=this,a=E.axis,k=a.horiz,tt=a.logarithmic,et=E.options,rt=et.color,nt=pick$1m(et.zIndex,0),ot=et.events,st={},lt=a.chart.renderer,ht=et.label,ut=E.label,dt=et.to,ft=et.from,pt=et.value,gt=E.svgElem,yt=[],mt,xt=defined$M(ft)&&defined$M(dt),wt=defined$M(pt),Mt=!gt,At={class:"highcharts-plot-"+(xt?"band ":"line ")+(et.className||"")},St=xt?"bands":"lines";if(tt&&(ft=tt.log2lin(ft),dt=tt.log2lin(dt),pt=tt.log2lin(pt)),a.chart.styledMode||(wt?(At.stroke=rt||palette.neutralColor40,At["stroke-width"]=pick$1m(et.width,1),et.dashStyle&&(At.dashstyle=et.dashStyle)):xt&&(At.fill=rt||palette.highlightColor10,et.borderWidth&&(At.stroke=et.borderColor,At["stroke-width"]=et.borderWidth))),st.zIndex=nt,St+="-"+nt,mt=a.plotLinesAndBandsGroups[St],mt||(a.plotLinesAndBandsGroups[St]=mt=lt.g("plot-"+St).attr(st).add()),Mt&&(E.svgElem=gt=lt.path().attr(At).add(mt)),wt)yt=a.getPlotLinePath({value:pt,lineWidth:gt.strokeWidth(),acrossPanes:et.acrossPanes});else if(xt)yt=a.getPlotBandPath(ft,dt,et);else return;return!E.eventsAdded&&ot&&(objectEach$r(ot,function($t,Tt){gt.on(Tt,function(Pt){ot[Tt].apply(E,[Pt])})}),E.eventsAdded=!0),(Mt||!gt.d)&&yt&&yt.length?gt.attr({d:yt}):gt&&(yt?(gt.show(!0),gt.animate({d:yt})):gt.d&&(gt.hide(),ut&&(E.label=ut=ut.destroy()))),ht&&(defined$M(ht.text)||defined$M(ht.formatter))&&yt&&yt.length&&a.width>0&&a.height>0&&!yt.isFlat?(ht=merge$1f({align:k&&xt&&"center",x:k?!xt&&4:10,verticalAlign:!k&&xt&&"middle",y:k?xt?16:10:xt?6:-4,rotation:k&&!xt&&90},ht),this.renderLabel(ht,yt,xt,nt)):ut&&ut.hide(),E},j.prototype.renderLabel=function(E,a,k,tt){var et=this,rt=et.axis,nt=rt.chart.renderer,ot=et.label;ot||(et.label=ot=nt.text(this.getLabelText(E),0,0,E.useHTML).attr({align:E.textAlign||E.align,rotation:E.rotation,class:"highcharts-plot-"+(k?"band":"line")+"-label "+(E.className||""),zIndex:tt}).add(),rt.chart.styledMode||ot.css(merge$1f({textOverflow:"ellipsis"},E.style)));var st=a.xBounds||[a[0][1],a[1][1],k?a[2][1]:a[0][1]],lt=a.yBounds||[a[0][2],a[1][2],k?a[2][2]:a[0][2]],ht=arrayMin$7(st),ut=arrayMin$7(lt);ot.align(E,!1,{x:ht,y:ut,width:arrayMax$8(st)-ht,height:arrayMax$8(lt)-ut}),(!ot.alignValue||ot.alignValue==="left")&&ot.css({width:(ot.rotation===90?rt.height-(ot.alignAttr.y-rt.top):rt.width-(ot.alignAttr.x-rt.left))+"px"}),ot.show(!0)},j.prototype.getLabelText=function(E){return defined$M(E.formatter)?E.formatter.call(this):E.text},j.prototype.destroy=function(){erase$5(this.axis.plotLinesAndBands,this),delete this.axis,destroyObjectProperties$6(this)},j}(),format$d=FormatUtilities.format,doc$i=H.doc,distribute$3=R.distribute,addEvent$Y=Utilities.addEvent,clamp$g=Utilities.clamp,css$9=Utilities.css,defined$L=Utilities.defined,discardElement$5=Utilities.discardElement,extend$1k=Utilities.extend,fireEvent$w=Utilities.fireEvent,isArray$i=Utilities.isArray,isNumber$F=Utilities.isNumber,isString$6=Utilities.isString,merge$1e=Utilities.merge,pick$1l=Utilities.pick,splat$f=Utilities.splat,syncTimeout$6=Utilities.syncTimeout,Tooltip=function(){function j(E,a){this.container=void 0,this.crosshairs=[],this.distance=0,this.isHidden=!0,this.isSticky=!1,this.now={},this.options={},this.outside=!1,this.chart=E,this.init(E,a)}return j.prototype.applyFilter=function(){var E=this.chart;E.renderer.definition({tagName:"filter",attributes:{id:"drop-shadow-"+E.index,opacity:.5},children:[{tagName:"feGaussianBlur",attributes:{in:"SourceAlpha",stdDeviation:1}},{tagName:"feOffset",attributes:{dx:1,dy:1}},{tagName:"feComponentTransfer",children:[{tagName:"feFuncA",attributes:{type:"linear",slope:.3}}]},{tagName:"feMerge",children:[{tagName:"feMergeNode"},{tagName:"feMergeNode",attributes:{in:"SourceGraphic"}}]}]})},j.prototype.bodyFormatter=function(E){return E.map(function(a){var k=a.series.tooltipOptions;return(k[(a.point.formatPrefix||"point")+"Formatter"]||a.point.tooltipFormatter).call(a.point,k[(a.point.formatPrefix||"point")+"Format"]||"")})},j.prototype.cleanSplit=function(E){this.chart.series.forEach(function(a){var k=a&&a.tt;k&&(!k.isActive||E?a.tt=k.destroy():k.isActive=!1)})},j.prototype.defaultFormatter=function(E){var a=this.points||splat$f(this),k;return k=[E.tooltipFooterHeaderFormatter(a[0])],k=k.concat(E.bodyFormatter(a)),k.push(E.tooltipFooterHeaderFormatter(a[0],!0)),k},j.prototype.destroy=function(){this.label&&(this.label=this.label.destroy()),this.split&&this.tt&&(this.cleanSplit(this.chart,!0),this.tt=this.tt.destroy()),this.renderer&&(this.renderer=this.renderer.destroy(),discardElement$5(this.container)),Utilities.clearTimeout(this.hideTimer),Utilities.clearTimeout(this.tooltipTimeout)},j.prototype.getAnchor=function(E,a){var k=this.chart,tt=k.pointer,et=k.inverted,rt=k.plotTop,nt=k.plotLeft,ot,st,lt,ht=0,ut=0;return E=splat$f(E),this.followPointer&&a?(typeof a.chartX>"u"&&(a=tt.normalize(a)),ot=[a.chartX-nt,a.chartY-rt]):E[0].tooltipPos?ot=E[0].tooltipPos:(E.forEach(function(dt){st=dt.series.yAxis,lt=dt.series.xAxis,ht+=dt.plotX||0,ut+=dt.plotLow?(dt.plotLow+(dt.plotHigh||0))/2:dt.plotY||0,lt&&st&&(et?(ht+=rt+k.plotHeight-lt.len-lt.pos,ut+=nt+k.plotWidth-st.len-st.pos):(ht+=lt.pos-nt,ut+=st.pos-rt))}),ht/=E.length,ut/=E.length,ot=[et?k.plotWidth-ut:ht,et?k.plotHeight-ht:ut],this.shared&&E.length>1&&a&&(et?ot[0]=a.chartX-nt:ot[1]=a.chartY-rt)),ot.map(Math.round)},j.prototype.getLabel=function(){var E=this,a=this.chart.styledMode,k=this.options,tt="tooltip"+(defined$L(k.className)?" "+k.className:""),et=k.style.pointerEvents||(!this.followPointer&&k.stickOnContact?"auto":"none"),rt=function(){E.inContact=!0},nt=function(pt){var gt=E.chart.hoverSeries;E.inContact=E.shouldStickOnContact()&&E.chart.pointer.inClass(pt.relatedTarget,"highcharts-tooltip"),!E.inContact&&gt&&gt.onMouseOut&&gt.onMouseOut()},ot,st=this.chart.renderer;if(!this.label){if(this.outside){var lt=this.chart.options.chart.style,ht=RendererRegistry$1.getRendererType();this.container=ot=H.doc.createElement("div"),ot.className="highcharts-tooltip-container",css$9(ot,{position:"absolute",top:"1px",pointerEvents:et,zIndex:Math.max(this.options.style.zIndex||0,(lt&&lt.zIndex||0)+3)}),addEvent$Y(ot,"mouseenter",rt),addEvent$Y(ot,"mouseleave",nt),H.doc.body.appendChild(ot),this.renderer=st=new ht(ot,0,0,lt,void 0,void 0,st.styledMode)}if(this.split?this.label=st.g(tt):(this.label=st.label("",0,0,k.shape,void 0,void 0,k.useHTML,void 0,tt).attr({padding:k.padding,r:k.borderRadius}),a||this.label.attr({fill:k.backgroundColor,"stroke-width":k.borderWidth}).css(k.style).css({pointerEvents:et}).shadow(k.shadow)),a&&k.shadow&&(this.applyFilter(),this.label.attr({filter:"url(#drop-shadow-"+this.chart.index+")"})),E.outside&&!E.split){var ut=this.label,dt=ut.xSetter,ft=ut.ySetter;ut.xSetter=function(pt){dt.call(ut,E.distance),ot.style.left=pt+"px"},ut.ySetter=function(pt){ft.call(ut,E.distance),ot.style.top=pt+"px"}}this.label.on("mouseenter",rt).on("mouseleave",nt).attr({zIndex:8}).add()}return this.label},j.prototype.getPosition=function(E,a,k){var tt=this.chart,et=this.distance,rt={},nt=tt.inverted&&k.h||0,ot=this.outside,st=ot?doc$i.documentElement.clientWidth-2*et:tt.chartWidth,lt=ot?Math.max(doc$i.body.scrollHeight,doc$i.documentElement.scrollHeight,doc$i.body.offsetHeight,doc$i.documentElement.offsetHeight,doc$i.documentElement.clientHeight):tt.chartHeight,ht=tt.pointer.getChartPosition(),ut=function(St){return St*ht.scaleX},dt=function(St){return St*ht.scaleY},ft=function(St){var $t=St==="x";return[St,$t?st:lt,$t?E:a].concat(ot?[$t?ut(E):dt(a),$t?ht.left-et+ut(k.plotX+tt.plotLeft):ht.top-et+dt(k.plotY+tt.plotTop),0,$t?st:lt]:[$t?E:a,$t?k.plotX+tt.plotLeft:k.plotY+tt.plotTop,$t?tt.plotLeft:tt.plotTop,$t?tt.plotLeft+tt.plotWidth:tt.plotTop+tt.plotHeight])},pt=ft("y"),gt=ft("x"),yt,mt=!this.followPointer&&pick$1l(k.ttBelow,!tt.inverted==!!k.negative),xt=function(St,$t,Tt,Pt,It,Lt,Nt){var Ht=ot?St==="y"?dt(et):ut(et):et,jt=(Tt-Pt)/2,Dt=Pt<It-et,Ft=It+et+Pt<$t,kt=It-Ht-Tt+jt,Bt=It+Ht-jt;if(mt&&Ft)rt[St]=Bt;else if(!mt&&Dt)rt[St]=kt;else if(Dt)rt[St]=Math.min(Nt-Pt,kt-nt<0?kt:kt-nt);else if(Ft)rt[St]=Math.max(Lt,Bt+nt+Tt>$t?Bt:Bt+nt);else return!1},wt=function(St,$t,Tt,Pt,It){var Lt;return It<et||It>$t-et?Lt=!1:It<Tt/2?rt[St]=1:It>$t-Pt/2?rt[St]=$t-Pt-2:rt[St]=It-Tt/2,Lt},Mt=function(St){var $t=pt;pt=gt,gt=$t,yt=St},At=function(){xt.apply(0,pt)!==!1?wt.apply(0,gt)===!1&&!yt&&(Mt(!0),At()):yt?rt.x=rt.y=0:(Mt(!0),At())};return(tt.inverted||this.len>1)&&Mt(),At(),rt},j.prototype.hide=function(E){var a=this;Utilities.clearTimeout(this.hideTimer),E=pick$1l(E,this.options.hideDelay),this.isHidden||(this.hideTimer=syncTimeout$6(function(){a.getLabel().fadeOut(E&&void 0),a.isHidden=!0},E))},j.prototype.init=function(E,a){this.chart=E,this.options=a,this.crosshairs=[],this.now={x:0,y:0},this.isHidden=!0,this.split=a.split&&!E.inverted&&!E.polar,this.shared=a.shared||this.split,this.outside=pick$1l(a.outside,Boolean(E.scrollablePixelsX||E.scrollablePixelsY))},j.prototype.shouldStickOnContact=function(){return!!(!this.followPointer&&this.options.stickOnContact)},j.prototype.isStickyOnContact=function(){return!!(this.shouldStickOnContact()&&this.inContact)},j.prototype.move=function(E,a,k,tt){var et=this,rt=et.now,nt=et.options.animation!==!1&&!et.isHidden&&(Math.abs(E-rt.x)>1||Math.abs(a-rt.y)>1),ot=et.followPointer||et.len>1;extend$1k(rt,{x:nt?(2*rt.x+E)/3:E,y:nt?(rt.y+a)/2:a,anchorX:ot?void 0:nt?(2*rt.anchorX+k)/3:k,anchorY:ot?void 0:nt?(rt.anchorY+tt)/2:tt}),et.getLabel().attr(rt),et.drawTracker(),nt&&(Utilities.clearTimeout(this.tooltipTimeout),this.tooltipTimeout=setTimeout(function(){et&&et.move(E,a,k,tt)},32))},j.prototype.refresh=function(E,a){var k=this,tt=this.chart,et=k.options,rt=splat$f(E),nt=rt[0],ot=[],st=et.formatter||k.defaultFormatter,lt=k.shared,ht=tt.styledMode,ut={};if(et.enabled){Utilities.clearTimeout(this.hideTimer),k.followPointer=!k.split&&nt.series.tooltipOptions.followPointer;var dt=k.getAnchor(E,a),ft=dt[0],pt=dt[1];lt&&!(!isArray$i(E)&&E.series&&E.series.noSharedTooltip)?(tt.pointer.applyInactiveState(rt),rt.forEach(function(Mt){Mt.setState("hover"),ot.push(Mt.getLabelConfig())}),ut={x:nt.category,y:nt.y},ut.points=ot):ut=nt.getLabelConfig(),this.len=ot.length;var gt=st.call(ut,k),yt=nt.series;if(this.distance=pick$1l(yt.tooltipOptions.distance,16),gt===!1)this.hide();else{if(k.split)this.renderSplit(gt,rt);else{var mt=ft,xt=pt;if(a&&tt.pointer.isDirectTouch&&(mt=a.chartX-tt.plotLeft,xt=a.chartY-tt.plotTop),tt.polar||yt.options.clip===!1||yt.shouldShowTooltip(mt,xt)){var wt=k.getLabel();(!et.style.width||ht)&&wt.css({width:this.chart.spacingBox.width+"px"}),wt.attr({text:gt&&gt.join?gt.join(""):gt}),wt.removeClass(/highcharts-color-[\d]+/g).addClass("highcharts-color-"+pick$1l(nt.colorIndex,yt.colorIndex)),ht||wt.attr({stroke:et.borderColor||nt.color||yt.color||palette.neutralColor60}),k.updatePosition({plotX:ft,plotY:pt,negative:nt.negative,ttBelow:nt.ttBelow,h:dt[2]||0})}else{k.hide();return}}k.isHidden&&k.label&&k.label.attr({opacity:1}).show(),k.isHidden=!1}fireEvent$w(this,"refresh")}},j.prototype.renderSplit=function(E,a){var k=this,tt=k.chart,et=k.chart,rt=et.chartWidth,nt=et.chartHeight,ot=et.plotHeight,st=et.plotLeft,lt=et.plotTop,ht=et.pointer,ut=et.scrollablePixelsY,dt=ut===void 0?0:ut,ft=et.scrollablePixelsX,pt=et.scrollingContainer,gt=pt===void 0?{scrollLeft:0,scrollTop:0}:pt,yt=gt.scrollLeft,mt=gt.scrollTop,xt=et.styledMode,wt=k.distance,Mt=k.options,At=k.options.positioner,St=k.outside&&typeof ft!="number"?doc$i.documentElement.getBoundingClientRect():{left:yt,right:yt+rt,top:mt,bottom:mt+nt},$t=k.getLabel(),Tt=this.renderer||tt.renderer,Pt=Boolean(tt.xAxis[0]&&tt.xAxis[0].opposite),It=ht.getChartPosition(),Lt=It.left,Nt=It.top,Ht=lt+mt,jt=0,Dt=ot-dt;function Ft(ce){var be=ce.isHeader,Te=ce.plotX,Oe=Te===void 0?0:Te,ke=ce.plotY,oe=ke===void 0?0:ke,ae=ce.series,ve,we;if(be)ve=st+Oe,we=lt+ot/2;else{var Ce=ae.xAxis,Xe=ae.yAxis;ve=Ce.pos+clamp$g(Oe,-wt,Ce.len+wt),ae.shouldShowTooltip(0,Xe.pos-lt+oe,{ignoreX:!0})&&(we=Xe.pos+oe)}return ve=clamp$g(ve,St.left-wt,St.right+wt),{anchorX:ve,anchorY:we}}function kt(ce,be,Te,Oe,ke){ke===void 0&&(ke=!0);var oe,ae;return Te?(oe=Pt?0:Dt,ae=clamp$g(ce-Oe/2,St.left,St.right-Oe-(k.outside?Lt:0))):(oe=be-Ht,ae=ke?ce-Oe-wt:ce+wt,ae=clamp$g(ae,ke?ae:St.left,St.right)),{x:ae,y:oe}}function Bt(ce,be,Te){var Oe=ce,ke=be.isHeader,oe=be.series,ae="highcharts-color-"+pick$1l(be.colorIndex,oe.colorIndex,"none");if(!Oe){var ve={padding:Mt.padding,r:Mt.borderRadius};xt||(ve.fill=Mt.backgroundColor,ve["stroke-width"]=Mt.borderWidth),Oe=Tt.label("",0,0,Mt[ke?"headerShape":"shape"],void 0,void 0,Mt.useHTML).addClass((ke?"highcharts-tooltip-header ":"")+"highcharts-tooltip-box "+ae).attr(ve).add($t)}return Oe.isActive=!0,Oe.attr({text:Te}),xt||Oe.css(Mt.style).shadow(Mt.shadow).attr({stroke:Mt.borderColor||be.color||oe.color||palette.neutralColor80}),Oe}isString$6(E)&&(E=[!1,E]);var Gt=E.slice(0,a.length+1).reduce(function(ce,be,Te){if(be!==!1&&be!==""){var Oe=a[Te-1]||{isHeader:!0,plotX:a[0].plotX,plotY:ot,series:{}},ke=Oe.isHeader,oe=ke?k:Oe.series,ae=oe.tt=Bt(oe.tt,Oe,be.toString()),ve=ae.getBBox(),we=ve.width+ae.strokeWidth();ke&&(jt=ve.height,Dt+=jt,Pt&&(Ht-=jt));var Ce=Ft(Oe),Xe=Ce.anchorX,li=Ce.anchorY;if(typeof li=="number"){var ri=ve.height+1,Xi=At?At.call(k,we,ri,Oe):kt(Xe,li,ke,we);ce.push({align:At?0:void 0,anchorX:Xe,anchorY:li,boxWidth:we,point:Oe,rank:pick$1l(Xi.rank,ke?1:0),size:ri,target:Xi.y,tt:ae,x:Xi.x})}else ae.isActive=!1}return ce},[]);!At&&Gt.some(function(ce){var be=k.outside,Te=(be?Lt:0)+ce.anchorX;return Te<St.left&&Te+ce.boxWidth<St.right?!0:Te<Lt-St.left+ce.boxWidth&&St.right-Te>Te})&&(Gt=Gt.map(function(ce){var be=kt(ce.anchorX,ce.anchorY,ce.point.isHeader,ce.boxWidth,!1),Te=be.x,Oe=be.y;return extend$1k(ce,{target:Oe,x:Te})})),k.cleanSplit(),distribute$3(Gt,Dt);var Yt={left:Lt,right:Lt};Gt.forEach(function(ce){var be=ce.x,Te=ce.boxWidth,Oe=ce.isHeader;Oe||(k.outside&&Lt+be<Yt.left&&(Yt.left=Lt+be),!Oe&&k.outside&&Yt.left+Te>Yt.right&&(Yt.right=Lt+be))}),Gt.forEach(function(ce){var be=ce.x,Te=ce.anchorX,Oe=ce.anchorY,ke=ce.pos,oe=ce.point.isHeader,ae={visibility:typeof ke>"u"?"hidden":"inherit",x:be,y:ke+Ht,anchorX:Te,anchorY:Oe};if(k.outside&&be<Te){var ve=Lt-Yt.left;ve>0&&(oe||(ae.x=be+ve,ae.anchorX=Te+ve),oe&&(ae.x=(Yt.right-Yt.left)/2,ae.anchorX=Te+ve))}ce.tt.attr(ae)});var Vt=k.container,qt=k.outside,Xt=k.renderer;if(qt&&Vt&&Xt){var Kt=$t.getBBox(),Jt=Kt.width,de=Kt.height,te=Kt.x,se=Kt.y;Xt.setSize(Jt+te,de+se,!1),Vt.style.left=Yt.left+"px",Vt.style.top=Nt+"px"}},j.prototype.drawTracker=function(){var E=this;if(E.followPointer||!E.options.stickOnContact){E.tracker&&E.tracker.destroy();return}var a=E.chart,k=E.label,tt=E.shared?a.hoverPoints:a.hoverPoint;if(!(!k||!tt)){var et={x:0,y:0,width:0,height:0},rt=this.getAnchor(tt),nt=k.getBBox();rt[0]+=a.plotLeft-k.translateX,rt[1]+=a.plotTop-k.translateY,et.x=Math.min(0,rt[0]),et.y=Math.min(0,rt[1]),et.width=rt[0]<0?Math.max(Math.abs(rt[0]),nt.width-rt[0]):Math.max(Math.abs(rt[0]),nt.width),et.height=rt[1]<0?Math.max(Math.abs(rt[1]),nt.height-Math.abs(rt[1])):Math.max(Math.abs(rt[1]),nt.height),E.tracker?E.tracker.attr(et):(E.tracker=k.renderer.rect(et).addClass("highcharts-tracker").add(k),a.styledMode||E.tracker.attr({fill:"rgba(0,0,0,0)"}))}},j.prototype.styledModeFormat=function(E){return E.replace('style="font-size: 10px"','class="highcharts-header"').replace(/style="color:{(point|series)\.color}"/g,'class="highcharts-color-{$1.colorIndex}"')},j.prototype.tooltipFooterHeaderFormatter=function(E,a){var k=E.series,tt=k.tooltipOptions,et=k.xAxis,rt=et&&et.dateTime,nt={isFooter:a,labelConfig:E},ot=tt.xDateFormat,st=tt[a?"footerFormat":"headerFormat"];return fireEvent$w(this,"headerFormatter",nt,function(lt){rt&&!ot&&isNumber$F(E.key)&&(ot=rt.getXDateFormat(E.key,tt.dateTimeLabelFormats)),rt&&ot&&(E.point&&E.point.tooltipDateKeys||["key"]).forEach(function(ht){st=st.replace("{point."+ht+"}","{point."+ht+":"+ot+"}")}),k.chart.styledMode&&(st=this.styledModeFormat(st)),lt.text=format$d(st,{point:E,series:k},this.chart)}),nt.text},j.prototype.update=function(E){this.destroy(),merge$1e(!0,this.chart.options.tooltip.userOptions,E),this.init(this.chart,merge$1e(!0,this.options,E))},j.prototype.updatePosition=function(E){var a=this.chart,k=this.options,tt=a.pointer,et=this.getLabel(),rt=tt.getChartPosition(),nt=(k.positioner||this.getPosition).call(this,et.width,et.height,E),ot=E.plotX+a.plotLeft,st=E.plotY+a.plotTop,lt;this.outside&&(lt=k.borderWidth+2*this.distance,this.renderer.setSize(et.width+lt,et.height+lt,!1),(rt.scaleX!==1||rt.scaleY!==1)&&(css$9(this.container,{transform:"scale("+rt.scaleX+", "+rt.scaleY+")"}),ot*=rt.scaleX,st*=rt.scaleY),ot+=rt.left-nt.x,st+=rt.top-nt.y),this.move(Math.round(nt.x),Math.round(nt.y||0),ot,st)},j}(),animObject$9=animationExports.animObject,defaultOptions$d=DefaultOptions.defaultOptions,format$c=FormatUtilities.format,addEvent$X=Utilities.addEvent,defined$K=Utilities.defined,erase$4=Utilities.erase,extend$1j=Utilities.extend,fireEvent$v=Utilities.fireEvent,getNestedProperty$1=Utilities.getNestedProperty,isArray$h=Utilities.isArray,isFunction$2=Utilities.isFunction,isNumber$E=Utilities.isNumber,isObject$b=Utilities.isObject,merge$1d=Utilities.merge,objectEach$q=Utilities.objectEach,pick$1k=Utilities.pick,syncTimeout$5=Utilities.syncTimeout,removeEvent$8=Utilities.removeEvent,uniqueKey$5=Utilities.uniqueKey,Point$5=function(){function j(){this.category=void 0,this.colorIndex=void 0,this.formatPrefix="point",this.id=void 0,this.isNull=!1,this.name=void 0,this.options=void 0,this.percentage=void 0,this.selected=!1,this.series=void 0,this.total=void 0,this.visible=!0,this.x=void 0}return j.prototype.animateBeforeDestroy=function(){var E=this,a={x:E.startXPos,opacity:0},k=E.getGraphicalProps();k.singular.forEach(function(tt){var et=tt==="dataLabel";E[tt]=E[tt].animate(et?{x:E[tt].startXPos,y:E[tt].startYPos,opacity:0}:a)}),k.plural.forEach(function(tt){E[tt].forEach(function(et){et.element&&et.animate(extend$1j({x:E.startXPos},et.startYPos?{x:et.startXPos,y:et.startYPos}:{}))})})},j.prototype.applyOptions=function(E,a){var k=this,tt=k.series,et=tt.options.pointValKey||tt.pointValKey;return E=j.prototype.optionsToObject.call(this,E),extend$1j(k,E),k.options=k.options?extend$1j(k.options,E):E,E.group&&delete k.group,E.dataLabels&&delete k.dataLabels,et&&(k.y=j.prototype.getNestedProperty.call(k,et)),k.isNull=pick$1k(k.isValid&&!k.isValid(),k.x===null||!isNumber$E(k.y)),k.formatPrefix=k.isNull?"null":"point",k.selected&&(k.state="select"),"name"in k&&typeof a>"u"&&tt.xAxis&&tt.xAxis.hasNames&&(k.x=tt.xAxis.nameToX(k)),typeof k.x>"u"&&tt?typeof a>"u"?k.x=tt.autoIncrement():k.x=a:isNumber$E(E.x)&&tt.options.relativeXValue&&(k.x=tt.autoIncrement(E.x)),k},j.prototype.destroy=function(){var E=this,a=E.series,k=a.chart,tt=a.options.dataSorting,et=k.hoverPoints,rt=E.series.chart.renderer.globalAnimation,nt=animObject$9(rt),ot;function st(){(E.graphic||E.dataLabel||E.dataLabels)&&(removeEvent$8(E),E.destroyElements());for(ot in E)E[ot]=null}E.legendItem&&k.legend.destroyItem(E),et&&(E.setState(),erase$4(et,E),et.length||(k.hoverPoints=null)),E===k.hoverPoint&&E.onMouseOut(),!tt||!tt.enabled?st():(this.animateBeforeDestroy(),syncTimeout$5(st,nt.duration)),k.pointCount--},j.prototype.destroyElements=function(E){var a=this,k=a.getGraphicalProps(E);k.singular.forEach(function(tt){a[tt]=a[tt].destroy()}),k.plural.forEach(function(tt){a[tt].forEach(function(et){et.element&&et.destroy()}),delete a[tt]})},j.prototype.firePointEvent=function(E,a,k){var tt=this,et=this.series,rt=et.options;(rt.point.events[E]||tt.options&&tt.options.events&&tt.options.events[E])&&tt.importEvents(),E==="click"&&rt.allowPointSelect&&(k=function(nt){tt.select&&tt.select(null,nt.ctrlKey||nt.metaKey||nt.shiftKey)}),fireEvent$v(tt,E,a,k)},j.prototype.getClassName=function(){var E=this;return"highcharts-point"+(E.selected?" highcharts-point-select":"")+(E.negative?" highcharts-negative":"")+(E.isNull?" highcharts-null-point":"")+(typeof E.colorIndex<"u"?" highcharts-color-"+E.colorIndex:"")+(E.options.className?" "+E.options.className:"")+(E.zone&&E.zone.className?" "+E.zone.className.replace("highcharts-negative",""):"")},j.prototype.getGraphicalProps=function(E){var a=this,k=[],tt={singular:[],plural:[]},et,rt;for(E=E||{graphic:1,dataLabel:1},E.graphic&&k.push("graphic","upperGraphic","shadowGroup"),E.dataLabel&&k.push("dataLabel","dataLabelUpper","connector"),rt=k.length;rt--;)et=k[rt],a[et]&&tt.singular.push(et);return["dataLabel","connector"].forEach(function(nt){var ot=nt+"s";E[nt]&&a[ot]&&tt.plural.push(ot)}),tt},j.prototype.getLabelConfig=function(){return{x:this.category,y:this.y,color:this.color,colorIndex:this.colorIndex,key:this.name||this.category,series:this.series,point:this,percentage:this.percentage,total:this.total||this.stackTotal}},j.prototype.getNestedProperty=function(E){if(E)return E.indexOf("custom.")===0?getNestedProperty$1(E,this.options):this[E]},j.prototype.getZone=function(){var E=this.series,a=E.zones,k=E.zoneAxis||"y",tt,et=0;for(tt=a[et];this[k]>=tt.value;)tt=a[++et];return this.nonZonedColor||(this.nonZonedColor=this.color),tt&&tt.color&&!this.options.color?this.color=tt.color:this.color=this.nonZonedColor,tt},j.prototype.hasNewShapeType=function(){var E=this,a=E.graphic&&(E.graphic.symbolName||E.graphic.element.nodeName);return a!==this.shapeType},j.prototype.init=function(E,a,k){return this.series=E,this.applyOptions(a,k),this.id=defined$K(this.id)?this.id:uniqueKey$5(),this.resolveColor(),E.chart.pointCount++,fireEvent$v(this,"afterInit"),this},j.prototype.optionsToObject=function(E){var a=this.series,k=a.options.keys,tt=k||a.pointArrayMap||["y"],et=tt.length,rt={},nt,ot=0,st=0;if(isNumber$E(E)||E===null)rt[tt[0]]=E;else if(isArray$h(E))for(!k&&E.length>et&&(nt=typeof E[0],nt==="string"?rt.name=E[0]:nt==="number"&&(rt.x=E[0]),ot++);st<et;)(!k||typeof E[ot]<"u")&&(tt[st].indexOf(".")>0?j.prototype.setNestedProperty(rt,E[ot],tt[st]):rt[tt[st]]=E[ot]),ot++,st++;else typeof E=="object"&&(rt=E,E.dataLabels&&(a._hasPointLabels=!0),E.marker&&(a._hasPointMarkers=!0));return rt},j.prototype.resolveColor=function(){var E=this.series,a=E.chart.options.chart,k=E.chart.styledMode,tt,et,rt=a.colorCount,nt;delete this.nonZonedColor,E.options.colorByPoint?(k||(et=E.options.colors||E.chart.options.colors,tt=et[E.colorCounter],rt=et.length),nt=E.colorCounter,E.colorCounter++,E.colorCounter===rt&&(E.colorCounter=0)):(k||(tt=E.color),nt=E.colorIndex),this.colorIndex=pick$1k(this.options.colorIndex,nt),this.color=pick$1k(this.options.color,tt)},j.prototype.setNestedProperty=function(E,a,k){var tt=k.split(".");return tt.reduce(function(et,rt,nt,ot){var st=ot.length-1===nt;return et[rt]=st?a:isObject$b(et[rt],!0)?et[rt]:{},et[rt]},E),E},j.prototype.tooltipFormatter=function(E){var a=this.series,k=a.tooltipOptions,tt=pick$1k(k.valueDecimals,""),et=k.valuePrefix||"",rt=k.valueSuffix||"";return a.chart.styledMode&&(E=a.chart.tooltip.styledModeFormat(E)),(a.pointArrayMap||["y"]).forEach(function(nt){nt="{point."+nt,(et||rt)&&(E=E.replace(RegExp(nt+"}","g"),et+nt+"}"+rt)),E=E.replace(RegExp(nt+"}","g"),nt+":,."+tt+"f}")}),format$c(E,{point:this,series:this.series},a.chart)},j.prototype.update=function(E,a,k,tt){var et=this,rt=et.series,nt=et.graphic,ot=rt.chart,st=rt.options,lt;a=pick$1k(a,!0);function ht(){et.applyOptions(E);var ut=nt&&et.hasDummyGraphic,dt=et.y===null?!ut:ut;nt&&dt&&(et.graphic=nt.destroy(),delete et.hasDummyGraphic),isObject$b(E,!0)&&(nt&&nt.element&&E&&E.marker&&typeof E.marker.symbol<"u"&&(et.graphic=nt.destroy()),E&&E.dataLabels&&et.dataLabel&&(et.dataLabel=et.dataLabel.destroy()),et.connector&&(et.connector=et.connector.destroy())),lt=et.index,rt.updateParallelArrays(et,lt),st.data[lt]=isObject$b(st.data[lt],!0)||isObject$b(E,!0)?et.options:pick$1k(E,st.data[lt]),rt.isDirty=rt.isDirtyData=!0,!rt.fixedBox&&rt.hasCartesianSeries&&(ot.isDirtyBox=!0),st.legendType==="point"&&(ot.isDirtyLegend=!0),a&&ot.redraw(k)}tt===!1?ht():et.firePointEvent("update",{options:E},ht)},j.prototype.remove=function(E,a){this.series.removePoint(this.series.data.indexOf(this),E,a)},j.prototype.select=function(E,a){var k=this,tt=k.series,et=tt.chart;E=pick$1k(E,!k.selected),this.selectedStaging=E,k.firePointEvent(E?"select":"unselect",{accumulate:a},function(){k.selected=k.options.selected=E,tt.options.data[tt.data.indexOf(k)]=k.options,k.setState(E&&"select"),a||et.getSelectedPoints().forEach(function(rt){var nt=rt.series;rt.selected&&rt!==k&&(rt.selected=rt.options.selected=!1,nt.options.data[nt.data.indexOf(rt)]=rt.options,rt.setState(et.hoverPoints&&nt.options.inactiveOtherPoints?"inactive":""),rt.firePointEvent("unselect"))})}),delete this.selectedStaging},j.prototype.onMouseOver=function(E){var a=this,k=a.series,tt=k.chart,et=tt.pointer;E=E?et.normalize(E):et.getChartCoordinatesFromPoint(a,tt.inverted),et.runPointActions(E,a)},j.prototype.onMouseOut=function(){var E=this,a=E.series.chart;E.firePointEvent("mouseOut"),E.series.options.inactiveOtherPoints||(a.hoverPoints||[]).forEach(function(k){k.setState()}),a.hoverPoints=a.hoverPoint=null},j.prototype.importEvents=function(){if(!this.hasImportedEvents){var E=this,a=merge$1d(E.series.options.point,E.options),k=a.events;E.events=k,objectEach$q(k,function(tt,et){isFunction$2(tt)&&addEvent$X(E,et,tt)}),this.hasImportedEvents=!0}},j.prototype.setState=function(E,a){var k=this,tt=k.series,et=k.state,rt=tt.options.states[E||"normal"]||{},nt=defaultOptions$d.plotOptions[tt.type].marker&&tt.options.marker,ot=nt&&nt.enabled===!1,st=nt&&nt.states&&nt.states[E||"normal"]||{},lt=st.enabled===!1,ht=k.marker||{},ut=tt.chart,dt=nt&&tt.markerAttribs,ft=tt.halo,pt,gt,yt,mt=tt.stateMarkerGraphic,xt;if(E=E||"",!(E===k.state&&!a||k.selected&&E!=="select"||rt.enabled===!1||E&&(lt||ot&&st.enabled===!1)||E&&ht.states&&ht.states[E]&&ht.states[E].enabled===!1)){k.state=E,dt&&(pt=tt.markerAttribs(k,E)),k.graphic&&!k.hasDummyGraphic?(et&&k.graphic.removeClass("highcharts-point-"+et),E&&k.graphic.addClass("highcharts-point-"+E),ut.styledMode||(gt=tt.pointAttribs(k,E),yt=pick$1k(ut.options.chart.animation,rt.animation),tt.options.inactiveOtherPoints&&isNumber$E(gt.opacity)&&((k.dataLabels||[]).forEach(function(St){St&&St.animate({opacity:gt.opacity},yt)}),k.connector&&k.connector.animate({opacity:gt.opacity},yt)),k.graphic.animate(gt,yt)),pt&&k.graphic.animate(pt,pick$1k(ut.options.chart.animation,st.animation,nt.animation)),mt&&mt.hide()):(E&&st&&(xt=ht.symbol||tt.symbol,mt&&mt.currentSymbol!==xt&&(mt=mt.destroy()),pt&&(mt?mt[a?"animate":"attr"]({x:pt.x,y:pt.y}):xt&&(tt.stateMarkerGraphic=mt=ut.renderer.symbol(xt,pt.x,pt.y,pt.width,pt.height).add(tt.markerGroup),mt.currentSymbol=xt)),!ut.styledMode&&mt&&mt.attr(tt.pointAttribs(k,E))),mt&&(mt[E&&k.isInside?"show":"hide"](),mt.element.point=k,mt.addClass(k.getClassName(),!0)));var wt=rt.halo,Mt=k.graphic||mt,At=Mt&&Mt.visibility||"inherit";wt&&wt.size&&Mt&&At!=="hidden"&&!k.isCluster?(ft||(tt.halo=ft=ut.renderer.path().add(Mt.parentGroup)),ft.show()[a?"animate":"attr"]({d:k.haloPath(wt.size)}),ft.attr({class:"highcharts-halo highcharts-color-"+pick$1k(k.colorIndex,tt.colorIndex)+(k.className?" "+k.className:""),visibility:At,zIndex:-1}),ft.point=k,ut.styledMode||ft.attr(extend$1j({fill:k.color||tt.color,"fill-opacity":wt.opacity},AST.filterUserAttributes(wt.attributes||{})))):ft&&ft.point&&ft.point.haloPath&&ft.animate({d:ft.point.haloPath(0)},null,ft.hide),fireEvent$v(k,"afterSetState",{state:E})}},j.prototype.haloPath=function(E){var a=this.series,k=a.chart;return k.renderer.symbols.circle(Math.floor(this.plotX)-E,this.plotY-E,E*2,E*2)},j}(),color$e=Color.parse,charts$3=H.charts,noop$j=H.noop,addEvent$W=Utilities.addEvent,attr$2=Utilities.attr,css$8=Utilities.css,defined$J=Utilities.defined,extend$1i=Utilities.extend,find$i=Utilities.find,fireEvent$u=Utilities.fireEvent,isNumber$D=Utilities.isNumber,isObject$a=Utilities.isObject,objectEach$p=Utilities.objectEach,offset=Utilities.offset,pick$1j=Utilities.pick,splat$e=Utilities.splat,Pointer=function(){function j(E,a){this.lastValidTouch={},this.pinchDown=[],this.runChartClick=!1,this.eventsToUnbind=[],this.chart=E,this.hasDragged=!1,this.options=a,this.init(E,a)}return j.prototype.applyInactiveState=function(E){var a=[],k;(E||[]).forEach(function(tt){k=tt.series,a.push(k),k.linkedParent&&a.push(k.linkedParent),k.linkedSeries&&(a=a.concat(k.linkedSeries)),k.navigatorSeries&&a.push(k.navigatorSeries)}),this.chart.series.forEach(function(tt){a.indexOf(tt)===-1?tt.setState("inactive",!0):tt.options.inactiveOtherPoints&&tt.setAllPointsToState("inactive")})},j.prototype.destroy=function(){var E=this;this.eventsToUnbind.forEach(function(a){return a()}),this.eventsToUnbind=[],H.chartCount||(j.unbindDocumentMouseUp&&(j.unbindDocumentMouseUp=j.unbindDocumentMouseUp()),j.unbindDocumentTouchEnd&&(j.unbindDocumentTouchEnd=j.unbindDocumentTouchEnd())),clearInterval(E.tooltipTimeout),objectEach$p(E,function(a,k){E[k]=void 0})},j.prototype.drag=function(E){var a=this.chart,k=a.options.chart,tt=this.zoomHor,et=this.zoomVert,rt=a.plotLeft,nt=a.plotTop,ot=a.plotWidth,st=a.plotHeight,lt=this.mouseDownX||0,ht=this.mouseDownY||0,ut=isObject$a(k.panning)?k.panning&&k.panning.enabled:k.panning,dt=k.panKey&&E[k.panKey+"Key"],ft=E.chartX,pt=E.chartY,gt,yt,mt=this.selectionMarker;mt&&mt.touch||(ft<rt?ft=rt:ft>rt+ot&&(ft=rt+ot),pt<nt?pt=nt:pt>nt+st&&(pt=nt+st),this.hasDragged=Math.sqrt(Math.pow(lt-ft,2)+Math.pow(ht-pt,2)),this.hasDragged>10&&(gt=a.isInsidePlot(lt-rt,ht-nt,{visiblePlotOnly:!0}),a.hasCartesianSeries&&(this.zoomX||this.zoomY)&&gt&&!dt&&(mt||(this.selectionMarker=mt=a.renderer.rect(rt,nt,tt?1:ot,et?1:st,0).attr({class:"highcharts-selection-marker",zIndex:7}).add(),a.styledMode||mt.attr({fill:k.selectionMarkerFill||color$e(palette.highlightColor80).setOpacity(.25).get()}))),mt&&tt&&(yt=ft-lt,mt.attr({width:Math.abs(yt),x:(yt>0?0:yt)+lt})),mt&&et&&(yt=pt-ht,mt.attr({height:Math.abs(yt),y:(yt>0?0:yt)+ht})),gt&&!mt&&ut&&a.pan(E,k.panning)))},j.prototype.dragStart=function(E){var a=this.chart;a.mouseIsDown=E.type,a.cancelClick=!1,a.mouseDownX=this.mouseDownX=E.chartX,a.mouseDownY=this.mouseDownY=E.chartY},j.prototype.drop=function(E){var a=this,k=this.chart,tt=this.hasPinched;if(this.selectionMarker){var et={originalEvent:E,xAxis:[],yAxis:[]},rt=this.selectionMarker,nt=rt.attr?rt.attr("x"):rt.x,ot=rt.attr?rt.attr("y"):rt.y,st=rt.attr?rt.attr("width"):rt.width,lt=rt.attr?rt.attr("height"):rt.height,ht;(this.hasDragged||tt)&&(k.axes.forEach(function(ut){if(ut.zoomEnabled&&defined$J(ut.min)&&(tt||a[{xAxis:"zoomX",yAxis:"zoomY"}[ut.coll]])&&isNumber$D(nt)&&isNumber$D(ot)){var dt=ut.horiz,ft=E.type==="touchend"?ut.minPixelPadding:0,pt=ut.toValue((dt?nt:ot)+ft),gt=ut.toValue((dt?nt+st:ot+lt)-ft);et[ut.coll].push({axis:ut,min:Math.min(pt,gt),max:Math.max(pt,gt)}),ht=!0}}),ht&&fireEvent$u(k,"selection",et,function(ut){k.zoom(extend$1i(ut,tt?{animation:!1}:null))})),isNumber$D(k.index)&&(this.selectionMarker=this.selectionMarker.destroy()),tt&&this.scaleGroups()}k&&isNumber$D(k.index)&&(css$8(k.container,{cursor:k._cursor}),k.cancelClick=this.hasDragged>10,k.mouseIsDown=this.hasDragged=this.hasPinched=!1,this.pinchDown=[])},j.prototype.findNearestKDPoint=function(E,a,k){var tt=this.chart,et=tt.hoverPoint,rt=tt.tooltip;if(et&&rt&&rt.isStickyOnContact())return et;var nt;function ot(st,lt){var ht=st.distX-lt.distX,ut=st.dist-lt.dist,dt=(lt.series.group&&lt.series.group.zIndex)-(st.series.group&&st.series.group.zIndex),ft;return ht!==0&&a?ft=ht:ut!==0?ft=ut:dt!==0?ft=dt:ft=st.series.index>lt.series.index?-1:1,ft}return E.forEach(function(st){var lt=st.noSharedTooltip&&a,ht=!lt&&st.options.findNearestPointBy.indexOf("y")<0,ut=st.searchPoint(k,ht);isObject$a(ut,!0)&&ut.series&&(!isObject$a(nt,!0)||ot(nt,ut)>0)&&(nt=ut)}),nt},j.prototype.getChartCoordinatesFromPoint=function(E,a){var k=E.series,tt=k.xAxis,et=k.yAxis,rt=E.shapeArgs;if(tt&&et){var nt=pick$1j(E.clientX,E.plotX),ot=E.plotY||0;return E.isNode&&rt&&isNumber$D(rt.x)&&isNumber$D(rt.y)&&(nt=rt.x,ot=rt.y),a?{chartX:et.len+et.pos-ot,chartY:tt.len+tt.pos-nt}:{chartX:nt+tt.pos,chartY:ot+et.pos}}if(rt&&rt.x&&rt.y)return{chartX:rt.x,chartY:rt.y}},j.prototype.getChartPosition=function(){if(this.chartPosition)return this.chartPosition;var E=this.chart.container,a=offset(E);this.chartPosition={left:a.left,top:a.top,scaleX:1,scaleY:1};var k=E.offsetWidth,tt=E.offsetHeight;return k>2&&tt>2&&(this.chartPosition.scaleX=a.width/k,this.chartPosition.scaleY=a.height/tt),this.chartPosition},j.prototype.getCoordinates=function(E){var a={xAxis:[],yAxis:[]};return this.chart.axes.forEach(function(k){a[k.isXAxis?"xAxis":"yAxis"].push({axis:k,value:k.toValue(E[k.horiz?"chartX":"chartY"])})}),a},j.prototype.getHoverData=function(E,a,k,tt,et,rt){var nt=[],ot=!!(tt&&E),st=function(pt){return pt.visible&&!(!et&&pt.directTouch)&&pick$1j(pt.options.enableMouseTracking,!0)},lt=a,ht,ut={chartX:rt?rt.chartX:void 0,chartY:rt?rt.chartY:void 0,shared:et};fireEvent$u(this,"beforeGetHoverData",ut);var dt=lt&&!lt.stickyTracking;ht=dt?[lt]:k.filter(function(pt){return ut.filter?ut.filter(pt):st(pt)&&pt.stickyTracking});var ft=ot||!rt?E:this.findNearestKDPoint(ht,et,rt);return lt=ft&&ft.series,ft&&(et&&!lt.noSharedTooltip?(ht=k.filter(function(pt){return ut.filter?ut.filter(pt):st(pt)&&!pt.noSharedTooltip}),ht.forEach(function(pt){var gt=find$i(pt.points,function(yt){return yt.x===ft.x&&!yt.isNull});isObject$a(gt)&&(pt.chart.isBoosting&&(gt=pt.getPoint(gt)),nt.push(gt))})):nt.push(ft)),ut={hoverPoint:ft},fireEvent$u(this,"afterGetHoverData",ut),{hoverPoint:ut.hoverPoint,hoverSeries:lt,hoverPoints:nt}},j.prototype.getPointFromEvent=function(E){for(var a=E.target,k;a&&!k;)k=a.point,a=a.parentNode;return k},j.prototype.onTrackerMouseOut=function(E){var a=this.chart,k=E.relatedTarget||E.toElement,tt=a.hoverSeries;this.isDirectTouch=!1,tt&&k&&!tt.stickyTracking&&!this.inClass(k,"highcharts-tooltip")&&(!this.inClass(k,"highcharts-series-"+tt.index)||!this.inClass(k,"highcharts-tracker"))&&tt.onMouseOut()},j.prototype.inClass=function(E,a){for(var k;E;){if(k=attr$2(E,"class"),k){if(k.indexOf(a)!==-1)return!0;if(k.indexOf("highcharts-container")!==-1)return!1}E=E.parentNode}},j.prototype.init=function(E,a){this.options=a,this.chart=E,this.runChartClick=Boolean(a.chart.events&&a.chart.events.click),this.pinchDown=[],this.lastValidTouch={},Tooltip&&(E.tooltip=new Tooltip(E,a.tooltip),this.followTouchMove=pick$1j(a.tooltip.followTouchMove,!0)),this.setDOMEvents()},j.prototype.normalize=function(E,a){var k=E.touches,tt=k?k.length?k.item(0):pick$1j(k.changedTouches,E.changedTouches)[0]:E;a||(a=this.getChartPosition());var et=tt.pageX-a.left,rt=tt.pageY-a.top;return et/=a.scaleX,rt/=a.scaleY,extend$1i(E,{chartX:Math.round(et),chartY:Math.round(rt)})},j.prototype.onContainerClick=function(E){var a=this.chart,k=a.hoverPoint,tt=this.normalize(E),et=a.plotLeft,rt=a.plotTop;a.cancelClick||(k&&this.inClass(tt.target,"highcharts-tracker")?(fireEvent$u(k.series,"click",extend$1i(tt,{point:k})),a.hoverPoint&&k.firePointEvent("click",tt)):(extend$1i(tt,this.getCoordinates(tt)),a.isInsidePlot(tt.chartX-et,tt.chartY-rt,{visiblePlotOnly:!0})&&fireEvent$u(a,"click",tt)))},j.prototype.onContainerMouseDown=function(E){var a=((E.buttons||E.button)&1)===1;E=this.normalize(E),H.isFirefox&&E.button!==0&&this.onContainerMouseMove(E),(typeof E.button>"u"||a)&&(this.zoomOption(E),a&&E.preventDefault&&E.preventDefault(),this.dragStart(E))},j.prototype.onContainerMouseLeave=function(E){var a=charts$3[pick$1j(j.hoverChartIndex,-1)],k=this.chart.tooltip;k&&k.shouldStickOnContact()&&this.inClass(E.relatedTarget,"highcharts-tooltip-container")||(E=this.normalize(E),a&&(E.relatedTarget||E.toElement)&&(a.pointer.reset(),a.pointer.chartPosition=void 0),k&&!k.isHidden&&this.reset())},j.prototype.onContainerMouseEnter=function(E){delete this.chartPosition},j.prototype.onContainerMouseMove=function(E){var a=this.chart,k=this.normalize(E);this.setHoverChartIndex(),k.preventDefault||(k.returnValue=!1),(a.mouseIsDown==="mousedown"||this.touchSelect(k))&&this.drag(k),!a.openMenu&&(this.inClass(k.target,"highcharts-tracker")||a.isInsidePlot(k.chartX-a.plotLeft,k.chartY-a.plotTop,{visiblePlotOnly:!0}))&&(this.inClass(k.target,"highcharts-no-tooltip")?this.reset(!1,0):this.runPointActions(k))},j.prototype.onDocumentTouchEnd=function(E){var a=charts$3[pick$1j(j.hoverChartIndex,-1)];a&&a.pointer.drop(E)},j.prototype.onContainerTouchMove=function(E){this.touchSelect(E)?this.onContainerMouseMove(E):this.touch(E)},j.prototype.onContainerTouchStart=function(E){this.touchSelect(E)?this.onContainerMouseDown(E):(this.zoomOption(E),this.touch(E,!0))},j.prototype.onDocumentMouseMove=function(E){var a=this.chart,k=this.chartPosition,tt=this.normalize(E,k),et=a.tooltip;k&&(!et||!et.isStickyOnContact())&&!a.isInsidePlot(tt.chartX-a.plotLeft,tt.chartY-a.plotTop,{visiblePlotOnly:!0})&&!this.inClass(tt.target,"highcharts-tracker")&&this.reset()},j.prototype.onDocumentMouseUp=function(E){var a=charts$3[pick$1j(j.hoverChartIndex,-1)];a&&a.pointer.drop(E)},j.prototype.pinch=function(E){var a=this,k=a.chart,tt=a.pinchDown,et=E.touches||[],rt=et.length,nt=a.lastValidTouch,ot=a.hasZoom,st={},lt=rt===1&&(a.inClass(E.target,"highcharts-tracker")&&k.runTrackerClick||a.runChartClick),ht={},ut=a.selectionMarker;rt>1?a.initiated=!0:rt===1&&this.followTouchMove&&(a.initiated=!1),ot&&a.initiated&&!lt&&E.cancelable!==!1&&E.preventDefault(),[].map.call(et,function(dt){return a.normalize(dt)}),E.type==="touchstart"?([].forEach.call(et,function(dt,ft){tt[ft]={chartX:dt.chartX,chartY:dt.chartY}}),nt.x=[tt[0].chartX,tt[1]&&tt[1].chartX],nt.y=[tt[0].chartY,tt[1]&&tt[1].chartY],k.axes.forEach(function(dt){if(dt.zoomEnabled){var ft=k.bounds[dt.horiz?"h":"v"],pt=dt.minPixelPadding,gt=dt.toPixels(Math.min(pick$1j(dt.options.min,dt.dataMin),dt.dataMin)),yt=dt.toPixels(Math.max(pick$1j(dt.options.max,dt.dataMax),dt.dataMax)),mt=Math.min(gt,yt),xt=Math.max(gt,yt);ft.min=Math.min(dt.pos,mt-pt),ft.max=Math.max(dt.pos+dt.len,xt+pt)}}),a.res=!0):a.followTouchMove&&rt===1?this.runPointActions(a.normalize(E)):tt.length&&(ut||(a.selectionMarker=ut=extend$1i({destroy:noop$j,touch:!0},k.plotBox)),a.pinchTranslate(tt,et,st,ut,ht,nt),a.hasPinched=ot,a.scaleGroups(st,ht),a.res&&(a.res=!1,this.reset(!1,0)))},j.prototype.pinchTranslate=function(E,a,k,tt,et,rt){this.zoomHor&&this.pinchTranslateDirection(!0,E,a,k,tt,et,rt),this.zoomVert&&this.pinchTranslateDirection(!1,E,a,k,tt,et,rt)},j.prototype.pinchTranslateDirection=function(E,a,k,tt,et,rt,nt,ot){var st=this.chart,lt=E?"x":"y",ht=E?"X":"Y",ut="chart"+ht,dt=E?"width":"height",ft=st["plot"+(E?"Left":"Top")],pt=st.inverted,gt=st.bounds[E?"h":"v"],yt=a.length===1,mt=a[0][ut],xt=!yt&&a[1][ut],wt=function(){typeof Pt=="number"&&Math.abs(mt-xt)>20&&($t=ot||Math.abs(Tt-Pt)/Math.abs(mt-xt)),St=(ft-Tt)/$t+mt,Mt=st["plot"+(E?"Width":"Height")]/$t},Mt,At,St,$t=ot||1,Tt=k[0][ut],Pt=!yt&&k[1][ut],It;wt(),At=St,At<gt.min?(At=gt.min,It=!0):At+Mt>gt.max&&(At=gt.max-Mt,It=!0),It?(Tt-=.8*(Tt-nt[lt][0]),typeof Pt=="number"&&(Pt-=.8*(Pt-nt[lt][1])),wt()):nt[lt]=[Tt,Pt],pt||(rt[lt]=St-ft,rt[dt]=Mt);var Lt=pt?E?"scaleY":"scaleX":"scale"+ht,Nt=pt?1/$t:$t;et[dt]=Mt,et[lt]=At,tt[Lt]=$t,tt["translate"+ht]=Nt*ft+(Tt-Nt*mt)},j.prototype.reset=function(E,a){var k=this,tt=k.chart,et=tt.hoverSeries,rt=tt.hoverPoint,nt=tt.hoverPoints,ot=tt.tooltip,st=ot&&ot.shared?nt:rt;E&&st&&splat$e(st).forEach(function(lt){lt.series.isCartesian&&typeof lt.plotX>"u"&&(E=!1)}),E?ot&&st&&splat$e(st).length&&(ot.refresh(st),ot.shared&&nt?nt.forEach(function(lt){lt.setState(lt.state,!0),lt.series.isCartesian&&(lt.series.xAxis.crosshair&&lt.series.xAxis.drawCrosshair(null,lt),lt.series.yAxis.crosshair&&lt.series.yAxis.drawCrosshair(null,lt))}):rt&&(rt.setState(rt.state,!0),tt.axes.forEach(function(lt){lt.crosshair&&rt.series[lt.coll]===lt&&lt.drawCrosshair(null,rt)}))):(rt&&rt.onMouseOut(),nt&&nt.forEach(function(lt){lt.setState()}),et&&et.onMouseOut(),ot&&ot.hide(a),k.unDocMouseMove&&(k.unDocMouseMove=k.unDocMouseMove()),tt.axes.forEach(function(lt){lt.hideCrosshair()}),k.hoverX=tt.hoverPoints=tt.hoverPoint=null)},j.prototype.runPointActions=function(E,a){var k=this,tt=k.chart,et=tt.series,rt=tt.tooltip&&tt.tooltip.options.enabled?tt.tooltip:void 0,nt=rt?rt.shared:!1,ot=a||tt.hoverPoint,st=ot&&ot.series||tt.hoverSeries,lt=(!E||E.type!=="touchmove")&&(!!a||st&&st.directTouch&&k.isDirectTouch),ht=this.getHoverData(ot,st,et,lt,nt,E);ot=ht.hoverPoint,st=ht.hoverSeries;var ut=ht.hoverPoints,dt=st&&st.tooltipOptions.followPointer&&!st.tooltipOptions.split,ft=nt&&st&&!st.noSharedTooltip;if(ot&&(ot!==tt.hoverPoint||rt&&rt.isHidden)){if((tt.hoverPoints||[]).forEach(function(gt){ut.indexOf(gt)===-1&&gt.setState()}),tt.hoverSeries!==st&&st.onMouseOver(),k.applyInactiveState(ut),(ut||[]).forEach(function(gt){gt.setState("hover")}),tt.hoverPoint&&tt.hoverPoint.firePointEvent("mouseOut"),!ot.series)return;tt.hoverPoints=ut,tt.hoverPoint=ot,ot.firePointEvent("mouseOver"),rt&&rt.refresh(ft?ut:ot,E)}else if(dt&&rt&&!rt.isHidden){var pt=rt.getAnchor([{}],E);tt.isInsidePlot(pt[0],pt[1],{visiblePlotOnly:!0})&&rt.updatePosition({plotX:pt[0],plotY:pt[1]})}k.unDocMouseMove||(k.unDocMouseMove=addEvent$W(tt.container.ownerDocument,"mousemove",function(gt){var yt=charts$3[j.hoverChartIndex];yt&&yt.pointer.onDocumentMouseMove(gt)}),k.eventsToUnbind.push(k.unDocMouseMove)),tt.axes.forEach(function(yt){var mt=pick$1j((yt.crosshair||{}).snap,!0),xt;mt&&(xt=tt.hoverPoint,(!xt||xt.series[yt.coll]!==yt)&&(xt=find$i(ut,function(wt){return wt.series[yt.coll]===yt}))),xt||!mt?yt.drawCrosshair(E,xt):yt.hideCrosshair()})},j.prototype.scaleGroups=function(E,a){var k=this.chart;k.series.forEach(function(tt){var et=E||tt.getPlotBox();tt.xAxis&&tt.xAxis.zoomEnabled&&tt.group&&(tt.group.attr(et),tt.markerGroup&&(tt.markerGroup.attr(et),tt.markerGroup.clip(a?k.clipRect:null)),tt.dataLabelsGroup&&tt.dataLabelsGroup.attr(et))}),k.clipRect.attr(a||k.clipBox)},j.prototype.setDOMEvents=function(){var E=this,a=this.chart.container,k=a.ownerDocument;a.onmousedown=this.onContainerMouseDown.bind(this),a.onmousemove=this.onContainerMouseMove.bind(this),a.onclick=this.onContainerClick.bind(this),this.eventsToUnbind.push(addEvent$W(a,"mouseenter",this.onContainerMouseEnter.bind(this))),this.eventsToUnbind.push(addEvent$W(a,"mouseleave",this.onContainerMouseLeave.bind(this))),j.unbindDocumentMouseUp||(j.unbindDocumentMouseUp=addEvent$W(k,"mouseup",this.onDocumentMouseUp.bind(this)));for(var tt=this.chart.renderTo.parentElement;tt&&tt.tagName!=="BODY";)this.eventsToUnbind.push(addEvent$W(tt,"scroll",function(){delete E.chartPosition})),tt=tt.parentElement;H.hasTouch&&(this.eventsToUnbind.push(addEvent$W(a,"touchstart",this.onContainerTouchStart.bind(this),{passive:!1})),this.eventsToUnbind.push(addEvent$W(a,"touchmove",this.onContainerTouchMove.bind(this),{passive:!1})),j.unbindDocumentTouchEnd||(j.unbindDocumentTouchEnd=addEvent$W(k,"touchend",this.onDocumentTouchEnd.bind(this),{passive:!1})))},j.prototype.setHoverChartIndex=function(){var E=this.chart,a=H.charts[pick$1j(j.hoverChartIndex,-1)];a&&a!==E&&a.pointer.onContainerMouseLeave({relatedTarget:!0}),(!a||!a.mouseIsDown)&&(j.hoverChartIndex=E.index)},j.prototype.touch=function(E,a){var k=this.chart,tt,et,rt;this.setHoverChartIndex(),E.touches.length===1?(E=this.normalize(E),rt=k.isInsidePlot(E.chartX-k.plotLeft,E.chartY-k.plotTop,{visiblePlotOnly:!0}),rt&&!k.openMenu?(a&&this.runPointActions(E),E.type==="touchmove"&&(et=this.pinchDown,tt=et[0]?Math.sqrt(Math.pow(et[0].chartX-E.chartX,2)+Math.pow(et[0].chartY-E.chartY,2))>=4:!1),pick$1j(tt,!0)&&this.pinch(E)):a&&this.reset()):E.touches.length===2&&this.pinch(E)},j.prototype.touchSelect=function(E){return Boolean(this.chart.options.chart.zoomBySingleTouch&&E.touches&&E.touches.length===1)},j.prototype.zoomOption=function(E){var a=this.chart,k=a.options.chart,tt=a.inverted,et=k.zoomType||"",rt,nt;/touch/.test(E.type)&&(et=pick$1j(k.pinchType,et)),this.zoomX=rt=/x/.test(et),this.zoomY=nt=/y/.test(et),this.zoomHor=rt&&!tt||nt&&tt,this.zoomVert=nt&&!tt||rt&&tt,this.hasZoom=rt||nt},j}(),__extends$2a=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),charts$2=H.charts,doc$h=H.doc,noop$i=H.noop,win$a=H.win,addEvent$V=Utilities.addEvent,css$7=Utilities.css,objectEach$o=Utilities.objectEach,removeEvent$7=Utilities.removeEvent,touches={},hasPointerEvent=!!win$a.PointerEvent;function getWebkitTouches(){var j=[];return j.item=function(E){return this[E]},objectEach$o(touches,function(E){j.push({pageX:E.pageX,pageY:E.pageY,target:E.target})}),j}function translateMSPointer(j,E,a,k){var tt=charts$2[Pointer.hoverChartIndex||NaN];if((j.pointerType==="touch"||j.pointerType===j.MSPOINTER_TYPE_TOUCH)&&tt){var et=tt.pointer;k(j),et[E]({type:a,target:j.currentTarget,preventDefault:noop$i,touches:getWebkitTouches()})}}var MSPointer=function(j){__extends$2a(E,j);function E(){return j!==null&&j.apply(this,arguments)||this}return E.isRequired=function(){return!!(!H.hasTouch&&(win$a.PointerEvent||win$a.MSPointerEvent))},E.prototype.batchMSEvents=function(a){a(this.chart.container,hasPointerEvent?"pointerdown":"MSPointerDown",this.onContainerPointerDown),a(this.chart.container,hasPointerEvent?"pointermove":"MSPointerMove",this.onContainerPointerMove),a(doc$h,hasPointerEvent?"pointerup":"MSPointerUp",this.onDocumentPointerUp)},E.prototype.destroy=function(){this.batchMSEvents(removeEvent$7),j.prototype.destroy.call(this)},E.prototype.init=function(a,k){j.prototype.init.call(this,a,k),this.hasZoom&&css$7(a.container,{"-ms-touch-action":"none","touch-action":"none"})},E.prototype.onContainerPointerDown=function(a){translateMSPointer(a,"onContainerTouchStart","touchstart",function(k){touches[k.pointerId]={pageX:k.pageX,pageY:k.pageY,target:k.currentTarget}})},E.prototype.onContainerPointerMove=function(a){translateMSPointer(a,"onContainerTouchMove","touchmove",function(k){touches[k.pointerId]={pageX:k.pageX,pageY:k.pageY},touches[k.pointerId].target||(touches[k.pointerId].target=k.currentTarget)})},E.prototype.onDocumentPointerUp=function(a){translateMSPointer(a,"onDocumentTouchEnd","touchend",function(k){delete touches[k.pointerId]})},E.prototype.setDOMEvents=function(){j.prototype.setDOMEvents.call(this),(this.hasZoom||this.followTouchMove)&&this.batchMSEvents(addEvent$V)},E}(Pointer),animObject$8=animationExports.animObject,setAnimation$4=animationExports.setAnimation,format$b=FormatUtilities.format,isFirefox$1=H.isFirefox,marginNames$1=H.marginNames,win$9=H.win,distribute$2=R.distribute,addEvent$U=Utilities.addEvent,createElement$6=Utilities.createElement,css$6=Utilities.css,defined$I=Utilities.defined,discardElement$4=Utilities.discardElement,find$h=Utilities.find,fireEvent$t=Utilities.fireEvent,isNumber$C=Utilities.isNumber,merge$1c=Utilities.merge,pick$1i=Utilities.pick,relativeLength$8=Utilities.relativeLength,stableSort$5=Utilities.stableSort,syncTimeout$4=Utilities.syncTimeout,wrap$c=Utilities.wrap,Legend=function(){function j(E,a){this.allItems=[],this.box=void 0,this.contentGroup=void 0,this.display=!1,this.group=void 0,this.initialItemY=0,this.itemHeight=0,this.itemMarginBottom=0,this.itemMarginTop=0,this.itemX=0,this.itemY=0,this.lastItemY=0,this.lastLineHeight=0,this.legendHeight=0,this.legendWidth=0,this.maxItemWidth=0,this.maxLegendWidth=0,this.offsetWidth=0,this.options={},this.padding=0,this.pages=[],this.proximate=!1,this.scrollGroup=void 0,this.symbolHeight=0,this.symbolWidth=0,this.titleHeight=0,this.totalItemWidth=0,this.widthOption=0,this.chart=E,this.init(E,a)}return j.prototype.init=function(E,a){this.chart=E,this.setOptions(a),a.enabled&&(this.render(),addEvent$U(this.chart,"endResize",function(){this.legend.positionCheckboxes()}),this.proximate?this.unchartrender=addEvent$U(this.chart,"render",function(){this.legend.proximatePositions(),this.legend.positionItems()}):this.unchartrender&&this.unchartrender())},j.prototype.setOptions=function(E){var a=pick$1i(E.padding,8);this.options=E,this.chart.styledMode||(this.itemStyle=E.itemStyle,this.itemHiddenStyle=merge$1c(this.itemStyle,E.itemHiddenStyle)),this.itemMarginTop=E.itemMarginTop||0,this.itemMarginBottom=E.itemMarginBottom||0,this.padding=a,this.initialItemY=a-5,this.symbolWidth=pick$1i(E.symbolWidth,16),this.pages=[],this.proximate=E.layout==="proximate"&&!this.chart.inverted,this.baseline=void 0},j.prototype.update=function(E,a){var k=this.chart;this.setOptions(merge$1c(!0,this.options,E)),this.destroy(),k.isDirtyLegend=k.isDirtyBox=!0,pick$1i(a,!0)&&k.redraw(),fireEvent$t(this,"afterUpdate")},j.prototype.colorizeItem=function(E,a){if(E.legendGroup[a?"removeClass":"addClass"]("highcharts-legend-item-hidden"),!this.chart.styledMode){var k=this,tt=k.options,et=E.legendItem,rt=E.legendLine,nt=E.legendSymbol,ot=k.itemHiddenStyle.color,st=a?tt.itemStyle.color:ot,lt=a&&E.color||ot,ht=E.options&&E.options.marker,ut={fill:lt};et&&et.css({fill:st,color:st}),rt&&rt.attr({stroke:lt}),nt&&(ht&&nt.isMarker&&(ut=E.pointAttribs(),a||(ut.stroke=ut.fill=ot)),nt.attr(ut))}fireEvent$t(this,"afterColorizeItem",{item:E,visible:a})},j.prototype.positionItems=function(){this.allItems.forEach(this.positionItem,this),this.chart.isResizing||this.positionCheckboxes()},j.prototype.positionItem=function(E){var a=this,k=this,tt=k.options,et=tt.symbolPadding,rt=!tt.rtl,nt=E._legendItemPos,ot=nt[0],st=nt[1],lt=E.checkbox,ht=E.legendGroup;if(ht&&ht.element){var ut={translateX:rt?ot:k.legendWidth-ot-2*et-4,translateY:st},dt=function(){fireEvent$t(a,"afterPositionItem",{item:E})};defined$I(ht.translateY)?ht.animate(ut,void 0,dt):(ht.attr(ut),dt())}lt&&(lt.x=ot,lt.y=st)},j.prototype.destroyItem=function(E){var a=E.checkbox;["legendItem","legendLine","legendSymbol","legendGroup"].forEach(function(k){E[k]&&(E[k]=E[k].destroy())}),a&&discardElement$4(E.checkbox)},j.prototype.destroy=function(){function E(a){this[a]&&(this[a]=this[a].destroy())}this.getAllItems().forEach(function(a){["legendItem","legendGroup"].forEach(E,a)}),["clipRect","up","down","pager","nav","box","title","group"].forEach(E,this),this.display=null},j.prototype.positionCheckboxes=function(){var E=this.group&&this.group.alignAttr,a=this.clipHeight||this.legendHeight,k=this.titleHeight,tt;E&&(tt=E.translateY,this.allItems.forEach(function(et){var rt=et.checkbox,nt;rt&&(nt=tt+k+rt.y+(this.scrollOffset||0)+3,css$6(rt,{left:E.translateX+et.checkboxOffset+rt.x-20+"px",top:nt+"px",display:this.proximate||nt>tt-6&&nt<tt+a-6?"":"none"}))},this))},j.prototype.renderTitle=function(){var E=this.options,a=this.padding,k=E.title,tt,et=0;k.text&&(this.title||(this.title=this.chart.renderer.label(k.text,a-3,a-4,null,null,null,E.useHTML,null,"legend-title").attr({zIndex:1}),this.chart.styledMode||this.title.css(k.style),this.title.add(this.group)),k.width||this.title.css({width:this.maxLegendWidth+"px"}),tt=this.title.getBBox(),et=tt.height,this.offsetWidth=tt.width,this.contentGroup.attr({translateY:et})),this.titleHeight=et},j.prototype.setText=function(E){var a=this.options;E.legendItem.attr({text:a.labelFormat?format$b(a.labelFormat,E,this.chart):a.labelFormatter.call(E)})},j.prototype.renderItem=function(E){var a=this,k=a.chart,tt=k.renderer,et=a.options,rt=et.layout==="horizontal",nt=a.symbolWidth,ot=et.symbolPadding||0,st=a.itemStyle,lt=a.itemHiddenStyle,ht=rt?pick$1i(et.itemDistance,20):0,ut=!et.rtl,dt=!E.series,ft=!dt&&E.series.drawLegendSymbol?E.series:E,pt=ft.options,gt=a.createCheckboxForItem&&pt&&pt.showCheckbox,yt=et.useHTML,mt=E.options.className,xt=E.legendItem,wt=nt+ot+ht+(gt?20:0);xt||(E.legendGroup=tt.g("legend-item").addClass("highcharts-"+ft.type+"-series highcharts-color-"+E.colorIndex+(mt?" "+mt:"")+(dt?" highcharts-series-"+E.index:"")).attr({zIndex:1}).add(a.scrollGroup),E.legendItem=xt=tt.text("",ut?nt+ot:-ot,a.baseline||0,yt),k.styledMode||xt.css(merge$1c(E.visible?st:lt)),xt.attr({align:ut?"left":"right",zIndex:2}).add(E.legendGroup),a.baseline||(a.fontMetrics=tt.fontMetrics(k.styledMode?12:st.fontSize,xt),a.baseline=a.fontMetrics.f+3+a.itemMarginTop,xt.attr("y",a.baseline),a.symbolHeight=et.symbolHeight||a.fontMetrics.f,et.squareSymbol&&(a.symbolWidth=pick$1i(et.symbolWidth,Math.max(a.symbolHeight,16)),wt=a.symbolWidth+ot+ht+(gt?20:0),ut&&xt.attr("x",a.symbolWidth+ot))),ft.drawLegendSymbol(a,E),a.setItemEvents&&a.setItemEvents(E,xt,yt)),gt&&!E.checkbox&&a.createCheckboxForItem&&a.createCheckboxForItem(E),a.colorizeItem(E,E.visible),(k.styledMode||!st.width)&&xt.css({width:(et.itemWidth||a.widthOption||k.spacingBox.width)-wt+"px"}),a.setText(E);var Mt=xt.getBBox();E.itemWidth=E.checkboxOffset=et.itemWidth||E.legendItemWidth||Mt.width+wt,a.maxItemWidth=Math.max(a.maxItemWidth,E.itemWidth),a.totalItemWidth+=E.itemWidth,a.itemHeight=E.itemHeight=Math.round(E.legendItemHeight||Mt.height||a.symbolHeight)},j.prototype.layoutItem=function(E){var a=this.options,k=this.padding,tt=a.layout==="horizontal",et=E.itemHeight,rt=this.itemMarginBottom,nt=this.itemMarginTop,ot=tt?pick$1i(a.itemDistance,20):0,st=this.maxLegendWidth,lt=a.alignColumns&&this.totalItemWidth>st?this.maxItemWidth:E.itemWidth;tt&&this.itemX-k+lt>st&&(this.itemX=k,this.lastLineHeight&&(this.itemY+=nt+this.lastLineHeight+rt),this.lastLineHeight=0),this.lastItemY=nt+this.itemY+rt,this.lastLineHeight=Math.max(et,this.lastLineHeight),E._legendItemPos=[this.itemX,this.itemY],tt?this.itemX+=lt:(this.itemY+=nt+et+rt,this.lastLineHeight=et),this.offsetWidth=this.widthOption||Math.max((tt?this.itemX-k-(E.checkbox?0:ot):lt)+k,this.offsetWidth)},j.prototype.getAllItems=function(){var E=[];return this.chart.series.forEach(function(a){var k=a&&a.options;a&&pick$1i(k.showInLegend,defined$I(k.linkedTo)?!1:void 0,!0)&&(E=E.concat(a.legendItems||(k.legendType==="point"?a.data:a)))}),fireEvent$t(this,"afterGetAllItems",{allItems:E}),E},j.prototype.getAlignment=function(){var E=this.options;return this.proximate?E.align.charAt(0)+"tv":E.floating?"":E.align.charAt(0)+E.verticalAlign.charAt(0)+E.layout.charAt(0)},j.prototype.adjustMargins=function(E,a){var k=this.chart,tt=this.options,et=this.getAlignment();et&&[/(lth|ct|rth)/,/(rtv|rm|rbv)/,/(rbh|cb|lbh)/,/(lbv|lm|ltv)/].forEach(function(rt,nt){rt.test(et)&&!defined$I(E[nt])&&(k[marginNames$1[nt]]=Math.max(k[marginNames$1[nt]],k.legend[(nt+1)%2?"legendHeight":"legendWidth"]+[1,-1,-1,1][nt]*tt[nt%2?"x":"y"]+pick$1i(tt.margin,12)+a[nt]+(k.titleOffset[nt]||0)))})},j.prototype.proximatePositions=function(){var E=this.chart,a=[],k=this.options.align==="left";this.allItems.forEach(function(tt){var et,rt,nt=k,ot,st;tt.yAxis&&(tt.xAxis.options.reversed&&(nt=!nt),tt.points&&(et=find$h(nt?tt.points:tt.points.slice(0).reverse(),function(lt){return isNumber$C(lt.plotY)})),rt=this.itemMarginTop+tt.legendItem.getBBox().height+this.itemMarginBottom,st=tt.yAxis.top-E.plotTop,tt.visible?(ot=et?et.plotY:tt.yAxis.height,ot+=st-.3*rt):ot=st+tt.yAxis.height,a.push({target:ot,size:rt,item:tt}))},this),distribute$2(a,E.plotHeight).forEach(function(tt){tt.item._legendItemPos&&(tt.item._legendItemPos[1]=E.plotTop-E.spacing[0]+tt.pos)})},j.prototype.render=function(){var E=this,a=E.chart,k=a.renderer,tt=E.options,et=E.padding,rt=E.getAllItems(),nt,ot,st,lt=E.group,ht,ut=E.box;E.itemX=et,E.itemY=E.initialItemY,E.offsetWidth=0,E.lastItemY=0,E.widthOption=relativeLength$8(tt.width,a.spacingBox.width-et),ht=a.spacingBox.width-2*et-tt.x,["rm","lm"].indexOf(E.getAlignment().substring(0,2))>-1&&(ht/=2),E.maxLegendWidth=E.widthOption||ht,lt||(E.group=lt=k.g("legend").addClass(tt.className||"").attr({zIndex:7}).add(),E.contentGroup=k.g().attr({zIndex:1}).add(lt),E.scrollGroup=k.g().add(E.contentGroup)),E.renderTitle(),stableSort$5(rt,function(dt,ft){return(dt.options&&dt.options.legendIndex||0)-(ft.options&&ft.options.legendIndex||0)}),tt.reversed&&rt.reverse(),E.allItems=rt,E.display=nt=!!rt.length,E.lastLineHeight=0,E.maxItemWidth=0,E.totalItemWidth=0,E.itemHeight=0,rt.forEach(E.renderItem,E),rt.forEach(E.layoutItem,E),ot=(E.widthOption||E.offsetWidth)+et,st=E.lastItemY+E.lastLineHeight+E.titleHeight,st=E.handleOverflow(st),st+=et,ut||(E.box=ut=k.rect().addClass("highcharts-legend-box").attr({r:tt.borderRadius}).add(lt),ut.isNew=!0),a.styledMode||ut.attr({stroke:tt.borderColor,"stroke-width":tt.borderWidth||0,fill:tt.backgroundColor||"none"}).shadow(tt.shadow),ot>0&&st>0&&(ut[ut.isNew?"attr":"animate"](ut.crisp.call({},{x:0,y:0,width:ot,height:st},ut.strokeWidth())),ut.isNew=!1),ut[nt?"show":"hide"](),a.styledMode&&lt.getStyle("display")==="none"&&(ot=st=0),E.legendWidth=ot,E.legendHeight=st,nt&&E.align(),this.proximate||this.positionItems(),fireEvent$t(this,"afterRender")},j.prototype.align=function(E){E===void 0&&(E=this.chart.spacingBox);var a=this.chart,k=this.options,tt=E.y;/(lth|ct|rth)/.test(this.getAlignment())&&a.titleOffset[0]>0?tt+=a.titleOffset[0]:/(lbh|cb|rbh)/.test(this.getAlignment())&&a.titleOffset[2]>0&&(tt-=a.titleOffset[2]),tt!==E.y&&(E=merge$1c(E,{y:tt})),this.group.align(merge$1c(k,{width:this.legendWidth,height:this.legendHeight,verticalAlign:this.proximate?"top":k.verticalAlign}),!0,E)},j.prototype.handleOverflow=function(E){var a=this,k=this.chart,tt=k.renderer,et=this.options,rt=et.y,nt=et.verticalAlign==="top",ot=this.padding,st=et.maxHeight,lt=et.navigation,ht=pick$1i(lt.animation,!0),ut=lt.arrowSize||12,dt=this.pages,ft=this.allItems,pt=function(At){typeof At=="number"?Mt.attr({height:At}):Mt&&(a.clipRect=Mt.destroy(),a.contentGroup.clip()),a.contentGroup.div&&(a.contentGroup.div.style.clip=At?"rect("+ot+"px,9999px,"+(ot+At)+"px,0)":"auto")},gt=function(At){return a[At]=tt.circle(0,0,ut*1.3).translate(ut/2,ut/2).add(wt),k.styledMode||a[At].attr("fill","rgba(0,0,0,0.0001)"),a[At]},yt,mt,xt=k.spacingBox.height+(nt?-rt:rt)-ot,wt=this.nav,Mt=this.clipRect;return et.layout==="horizontal"&&et.verticalAlign!=="middle"&&!et.floating&&(xt/=2),st&&(xt=Math.min(xt,st)),dt.length=0,E&&xt>0&&E>xt&&lt.enabled!==!1?(this.clipHeight=yt=Math.max(xt-20-this.titleHeight-ot,0),this.currentPage=pick$1i(this.currentPage,1),this.fullHeight=E,ft.forEach(function(At,St){var $t=At._legendItemPos[1],Tt=Math.round(At.legendItem.getBBox().height),Pt=dt.length;(!Pt||$t-dt[Pt-1]>yt&&(mt||$t)!==dt[Pt-1])&&(dt.push(mt||$t),Pt++),At.pageIx=Pt-1,mt&&(ft[St-1].pageIx=Pt-1),St===ft.length-1&&$t+Tt-dt[Pt-1]>yt&&$t!==mt&&(dt.push($t),At.pageIx=Pt),$t!==mt&&(mt=$t)}),Mt||(Mt=a.clipRect=tt.clipRect(0,ot,9999,0),a.contentGroup.clip(Mt)),pt(yt),wt||(this.nav=wt=tt.g().attr({zIndex:1}).add(this.group),this.up=tt.symbol("triangle",0,0,ut,ut).add(wt),gt("upTracker").on("click",function(){a.scroll(-1,ht)}),this.pager=tt.text("",15,10).addClass("highcharts-legend-navigation"),k.styledMode||this.pager.css(lt.style),this.pager.add(wt),this.down=tt.symbol("triangle-down",0,0,ut,ut).add(wt),gt("downTracker").on("click",function(){a.scroll(1,ht)})),a.scroll(0),E=xt):wt&&(pt(),this.nav=wt.destroy(),this.scrollGroup.attr({translateY:1}),this.clipHeight=0),E},j.prototype.scroll=function(E,a){var k=this,tt=this.chart,et=this.pages,rt=et.length,nt=this.clipHeight,ot=this.options.navigation,st=this.pager,lt=this.padding,ht=this.currentPage+E;if(ht>rt&&(ht=rt),ht>0){typeof a<"u"&&setAnimation$4(a,tt),this.nav.attr({translateX:lt,translateY:nt+this.padding+7+this.titleHeight,visibility:"visible"}),[this.up,this.upTracker].forEach(function(dt){dt.attr({class:ht===1?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})}),st.attr({text:ht+"/"+rt}),[this.down,this.downTracker].forEach(function(dt){dt.attr({x:18+this.pager.getBBox().width,class:ht===rt?"highcharts-legend-nav-inactive":"highcharts-legend-nav-active"})},this),tt.styledMode||(this.up.attr({fill:ht===1?ot.inactiveColor:ot.activeColor}),this.upTracker.css({cursor:ht===1?"default":"pointer"}),this.down.attr({fill:ht===rt?ot.inactiveColor:ot.activeColor}),this.downTracker.css({cursor:ht===rt?"default":"pointer"})),this.scrollOffset=-et[ht-1]+this.initialItemY,this.scrollGroup.animate({translateY:this.scrollOffset}),this.currentPage=ht,this.positionCheckboxes();var ut=animObject$8(pick$1i(a,tt.renderer.globalAnimation,!0));syncTimeout$4(function(){fireEvent$t(k,"afterScroll",{currentPage:ht})},ut.duration)}},j.prototype.setItemEvents=function(E,a,k){var tt=this,et=tt.chart.renderer.boxWrapper,rt=E instanceof Point$5,nt="highcharts-legend-"+(rt?"point":"series")+"-active",ot=tt.chart.styledMode,st=k?[a,E.legendSymbol]:[E.legendGroup],lt=function(ht){tt.allItems.forEach(function(ut){E!==ut&&[ut].concat(ut.linkedSeries||[]).forEach(function(dt){dt.setState(ht,!rt)})})};st.forEach(function(ht){ht&&ht.on("mouseover",function(){E.visible&&lt("inactive"),E.setState("hover"),E.visible&&et.addClass(nt),ot||a.css(tt.options.itemHoverStyle)}).on("mouseout",function(){tt.chart.styledMode||a.css(merge$1c(E.visible?tt.itemStyle:tt.itemHiddenStyle)),lt(""),et.removeClass(nt),E.setState()}).on("click",function(ut){var dt="legendItemClick",ft=function(){E.setVisible&&E.setVisible(),lt(E.visible?"inactive":"")};et.removeClass(nt),ut={browserEvent:ut},E.firePointEvent?E.firePointEvent(dt,ut,ft):fireEvent$t(E,dt,ut,ft)})})},j.prototype.createCheckboxForItem=function(E){var a=this;E.checkbox=createElement$6("input",{type:"checkbox",className:"highcharts-legend-checkbox",checked:E.selected,defaultChecked:E.selected},a.options.itemCheckboxStyle,a.chart.container),addEvent$U(E.checkbox,"click",function(k){var tt=k.target;fireEvent$t(E.series||E,"checkboxClick",{checked:tt.checked,item:E},function(){E.select()})})},j}();(/Trident\/7\.0/.test(win$9.navigator&&win$9.navigator.userAgent)||isFirefox$1)&&wrap$c(Legend.prototype,"positionItem",function(j,E){var a=this,k=function(){E._legendItemPos&&j.call(a,E)};k(),a.bubbleLegend||setTimeout(k)});var defaultOptions$c=DefaultOptions.defaultOptions,error$6=Utilities.error,extendClass$1=Utilities.extendClass,merge$1b=Utilities.merge,SeriesRegistry;(function(j){j.seriesTypes=H.seriesTypes;function E(tt,et){et===void 0&&(et={});var rt=tt.options.chart,nt=et.type||rt.type||rt.defaultSeriesType||"",ot=j.seriesTypes[nt];j||error$6(17,!0,tt,{missingModuleFor:nt});var st=new ot;return typeof st.init=="function"&&st.init(tt,et),st}j.getSeries=E;function a(tt,et){var rt=defaultOptions$c.plotOptions||{},nt=et.defaultOptions;et.prototype.pointClass||(et.prototype.pointClass=Point$5),et.prototype.type=tt,nt&&(rt[tt]=nt),j.seriesTypes[tt]=et}j.registerSeriesType=a;function k(tt,et,rt,nt,ot){var st=defaultOptions$c.plotOptions||{};return et=et||"",st[tt]=merge$1b(st[et],rt),a(tt,extendClass$1(j.seriesTypes[et]||function(){},nt)),j.seriesTypes[tt].prototype.type=tt,ot&&(j.seriesTypes[tt].prototype.pointClass=extendClass$1(Point$5,ot)),j.seriesTypes[tt]}j.seriesType=k})(SeriesRegistry||(SeriesRegistry={}));const SeriesRegistry$1=SeriesRegistry;var animate=animationExports.animate,animObject$7=animationExports.animObject,setAnimation$3=animationExports.setAnimation,numberFormat$1=FormatUtilities.numberFormat,registerEventOptions$1=exports$6.registerEventOptions,charts$1=H.charts,doc$g=H.doc,marginNames=H.marginNames,svg$3=H.svg,win$8=H.win,defaultOptions$b=DefaultOptions.defaultOptions,defaultTime=DefaultOptions.defaultTime,seriesTypes$7=SeriesRegistry$1.seriesTypes,addEvent$T=Utilities.addEvent,attr$1=Utilities.attr,cleanRecursively$1=Utilities.cleanRecursively,createElement$5=Utilities.createElement,css$5=Utilities.css,defined$H=Utilities.defined,discardElement$3=Utilities.discardElement,erase$3=Utilities.erase,error$5=Utilities.error,extend$1h=Utilities.extend,find$g=Utilities.find,fireEvent$s=Utilities.fireEvent,getStyle=Utilities.getStyle,isArray$g=Utilities.isArray,isNumber$B=Utilities.isNumber,isObject$9=Utilities.isObject,isString$5=Utilities.isString,merge$1a=Utilities.merge,objectEach$n=Utilities.objectEach,pick$1h=Utilities.pick,pInt$4=Utilities.pInt,relativeLength$7=Utilities.relativeLength,removeEvent$6=Utilities.removeEvent,splat$d=Utilities.splat,syncTimeout$3=Utilities.syncTimeout,uniqueKey$4=Utilities.uniqueKey,Chart$1=function(){function j(E,a,k){this.axes=void 0,this.axisOffset=void 0,this.bounds=void 0,this.chartHeight=void 0,this.chartWidth=void 0,this.clipBox=void 0,this.colorCounter=void 0,this.container=void 0,this.eventOptions=void 0,this.index=void 0,this.isResizing=void 0,this.labelCollectors=void 0,this.legend=void 0,this.margin=void 0,this.numberFormatter=void 0,this.options=void 0,this.plotBox=void 0,this.plotHeight=void 0,this.plotLeft=void 0,this.plotTop=void 0,this.plotWidth=void 0,this.pointCount=void 0,this.pointer=void 0,this.renderer=void 0,this.renderTo=void 0,this.series=void 0,this.sharedClips={},this.spacing=void 0,this.spacingBox=void 0,this.symbolCounter=void 0,this.time=void 0,this.titleOffset=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.getArgs(E,a,k)}return j.chart=function(E,a,k){return new j(E,a,k)},j.prototype.getArgs=function(E,a,k){isString$5(E)||E.nodeName?(this.renderTo=E,this.init(a,k)):this.init(E,a)},j.prototype.init=function(E,a){var k=E.plotOptions||{};fireEvent$s(this,"init",{args:arguments},function(){var tt=merge$1a(defaultOptions$b,E),et=tt.chart;objectEach$n(tt.plotOptions,function(nt,ot){isObject$9(nt)&&(nt.tooltip=k[ot]&&merge$1a(k[ot].tooltip)||void 0)}),tt.tooltip.userOptions=E.chart&&E.chart.forExport&&E.tooltip.userOptions||E.tooltip,this.userOptions=E,this.margin=[],this.spacing=[],this.bounds={h:{},v:{}},this.labelCollectors=[],this.callback=a,this.isResizing=0,this.options=tt,this.axes=[],this.series=[],this.time=E.time&&Object.keys(E.time).length?new Time(E.time):H.time,this.numberFormatter=et.numberFormatter||numberFormat$1,this.styledMode=et.styledMode,this.hasCartesianSeries=et.showAxes;var rt=this;rt.index=charts$1.length,charts$1.push(rt),H.chartCount++,registerEventOptions$1(this,et),rt.xAxis=[],rt.yAxis=[],rt.pointCount=rt.colorCounter=rt.symbolCounter=0,fireEvent$s(rt,"afterInit"),rt.firstRender()})},j.prototype.initSeries=function(E){var a=this,k=a.options.chart,tt=E.type||k.type||k.defaultSeriesType,et=seriesTypes$7[tt];et||error$5(17,!0,a,{missingModuleFor:tt});var rt=new et;return typeof rt.init=="function"&&rt.init(a,E),rt},j.prototype.setSeriesData=function(){this.getSeriesOrderByLinks().forEach(function(E){!E.points&&!E.data&&E.enabledDataSorting&&E.setData(E.options.data,!1)})},j.prototype.getSeriesOrderByLinks=function(){return this.series.concat().sort(function(E,a){return E.linkedSeries.length||a.linkedSeries.length?a.linkedSeries.length-E.linkedSeries.length:0})},j.prototype.orderSeries=function(E){for(var a=this.series,k=E||0,tt=a.length;k<tt;++k)a[k]&&(a[k].index=k,a[k].name=a[k].getName())},j.prototype.isInsidePlot=function(E,a,k){var tt;k===void 0&&(k={});var et=this,rt=et.inverted,nt=et.plotBox,ot=et.plotLeft,st=et.plotTop,lt=et.scrollablePlotBox,ht=0,ut=0;k.visiblePlotOnly&&this.scrollingContainer&&(tt=this.scrollingContainer,ht=tt.scrollLeft,ut=tt.scrollTop);var dt=k.series,ft=k.visiblePlotOnly&&lt||nt,pt=k.inverted?a:E,gt=k.inverted?E:a,yt={x:pt,y:gt,isInsidePlot:!0};if(!k.ignoreX){var mt=dt&&(rt?dt.yAxis:dt.xAxis)||{pos:ot,len:1/0},xt=k.paneCoordinates?mt.pos+pt:ot+pt;xt>=Math.max(ht+ot,mt.pos)&&xt<=Math.min(ht+ot+ft.width,mt.pos+mt.len)||(yt.isInsidePlot=!1)}if(!k.ignoreY&&yt.isInsidePlot){var wt=dt&&(rt?dt.xAxis:dt.yAxis)||{pos:st,len:1/0},Mt=k.paneCoordinates?wt.pos+gt:st+gt;Mt>=Math.max(ut+st,wt.pos)&&Mt<=Math.min(ut+st+ft.height,wt.pos+wt.len)||(yt.isInsidePlot=!1)}return fireEvent$s(this,"afterIsInsidePlot",yt),yt.isInsidePlot},j.prototype.redraw=function(E){fireEvent$s(this,"beforeRedraw");var a=this,k=a.hasCartesianSeries?a.axes:a.colorAxis||[],tt=a.series,et=a.pointer,rt=a.legend,nt=a.userOptions.legend,ot=a.renderer,st=ot.isHidden(),lt=[],ht,ut,dt,ft=a.isDirtyBox,pt=a.isDirtyLegend,gt;for(a.setResponsive&&a.setResponsive(!1),setAnimation$3(a.hasRendered?E:!1,a),st&&a.temporaryDisplay(),a.layOutTitles(),dt=tt.length;dt--;)if(gt=tt[dt],(gt.options.stacking||gt.options.centerInCategory)&&(ut=!0,gt.isDirty)){ht=!0;break}if(ht)for(dt=tt.length;dt--;)gt=tt[dt],gt.options.stacking&&(gt.isDirty=!0);tt.forEach(function(yt){yt.isDirty&&(yt.options.legendType==="point"?(typeof yt.updateTotals=="function"&&yt.updateTotals(),pt=!0):nt&&(nt.labelFormatter||nt.labelFormat)&&(pt=!0)),yt.isDirtyData&&fireEvent$s(yt,"updatedData")}),pt&&rt&&rt.options.enabled&&(rt.render(),a.isDirtyLegend=!1),ut&&a.getStacks(),k.forEach(function(yt){yt.updateNames(),yt.setScale()}),a.getMargins(),k.forEach(function(yt){yt.isDirty&&(ft=!0)}),k.forEach(function(yt){var mt=yt.min+","+yt.max;yt.extKey!==mt&&(yt.extKey=mt,lt.push(function(){fireEvent$s(yt,"afterSetExtremes",extend$1h(yt.eventArgs,yt.getExtremes())),delete yt.eventArgs})),(ft||ut)&&yt.redraw()}),ft&&a.drawChartBox(),fireEvent$s(a,"predraw"),tt.forEach(function(yt){(ft||yt.isDirty)&&yt.visible&&yt.redraw(),yt.isDirtyData=!1}),et&&et.reset(!0),ot.draw(),fireEvent$s(a,"redraw"),fireEvent$s(a,"render"),st&&a.temporaryDisplay(!0),lt.forEach(function(yt){yt.call()})},j.prototype.get=function(E){var a=this.series;function k(rt){return rt.id===E||rt.options&&rt.options.id===E}for(var tt=find$g(this.axes,k)||find$g(this.series,k),et=0;!tt&&et<a.length;et++)tt=find$g(a[et].points||[],k);return tt},j.prototype.getAxes=function(){var E=this,a=this.options,k=a.xAxis=splat$d(a.xAxis||{}),tt=a.yAxis=splat$d(a.yAxis||{});fireEvent$s(this,"getAxes"),k.forEach(function(rt,nt){rt.index=nt,rt.isX=!0}),tt.forEach(function(rt,nt){rt.index=nt});var et=k.concat(tt);et.forEach(function(rt){new Axis(E,rt)}),fireEvent$s(this,"afterGetAxes")},j.prototype.getSelectedPoints=function(){return this.series.reduce(function(E,a){return a.getPointsCollection().forEach(function(k){pick$1h(k.selectedStaging,k.selected)&&E.push(k)}),E},[])},j.prototype.getSelectedSeries=function(){return this.series.filter(function(E){return E.selected})},j.prototype.setTitle=function(E,a,k){this.applyDescription("title",E),this.applyDescription("subtitle",a),this.applyDescription("caption",void 0),this.layOutTitles(k)},j.prototype.applyDescription=function(E,a){var k=this,tt=E==="title"?{color:palette.neutralColor80,fontSize:this.options.isStock?"16px":"18px"}:{color:palette.neutralColor60},et=this.options[E]=merge$1a(!this.styledMode&&{style:tt},this.options[E],a),rt=this[E];rt&&a&&(this[E]=rt=rt.destroy()),et&&!rt&&(rt=this.renderer.text(et.text,0,0,et.useHTML).attr({align:et.align,class:"highcharts-"+E,zIndex:et.zIndex||4}).add(),rt.update=function(nt){var ot={title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"}[E];k[ot](nt)},this.styledMode||rt.css(et.style),this[E]=rt)},j.prototype.layOutTitles=function(E){var a=[0,0,0],k=this.renderer,tt=this.spacingBox;["title","subtitle","caption"].forEach(function(rt){var nt=this[rt],ot=this.options[rt],st=ot.verticalAlign||"top",lt=rt==="title"?st==="top"?-3:0:st==="top"?a[0]+2:0,ht,ut;nt&&(this.styledMode||(ht=ot.style&&ot.style.fontSize),ht=k.fontMetrics(ht,nt).b,nt.css({width:(ot.width||tt.width+(ot.widthAdjust||0))+"px"}),ut=Math.round(nt.getBBox(ot.useHTML).height),nt.align(extend$1h({y:st==="bottom"?ht:lt+ht,height:ut},ot),!1,"spacingBox"),ot.floating||(st==="top"?a[0]=Math.ceil(a[0]+ut):st==="bottom"&&(a[2]=Math.ceil(a[2]+ut))))},this),a[0]&&(this.options.title.verticalAlign||"top")==="top"&&(a[0]+=this.options.title.margin),a[2]&&this.options.caption.verticalAlign==="bottom"&&(a[2]+=this.options.caption.margin);var et=!this.titleOffset||this.titleOffset.join(",")!==a.join(",");this.titleOffset=a,fireEvent$s(this,"afterLayOutTitles"),!this.isDirtyBox&&et&&(this.isDirtyBox=this.isDirtyLegend=et,this.hasRendered&&pick$1h(E,!0)&&this.isDirtyBox&&this.redraw())},j.prototype.getChartSize=function(){var E=this,a=E.options.chart,k=a.width,tt=a.height,et=E.renderTo;defined$H(k)||(E.containerWidth=getStyle(et,"width")),defined$H(tt)||(E.containerHeight=getStyle(et,"height")),E.chartWidth=Math.max(0,k||E.containerWidth||600),E.chartHeight=Math.max(0,relativeLength$7(tt,E.chartWidth)||(E.containerHeight>1?E.containerHeight:400))},j.prototype.temporaryDisplay=function(E){var a=this.renderTo,k;if(E)for(;a&&a.style;)a.hcOrigStyle&&(css$5(a,a.hcOrigStyle),delete a.hcOrigStyle),a.hcOrigDetached&&(doc$g.body.removeChild(a),a.hcOrigDetached=!1),a=a.parentNode;else for(;a&&a.style&&(!doc$g.body.contains(a)&&!a.parentNode&&(a.hcOrigDetached=!0,doc$g.body.appendChild(a)),(getStyle(a,"display",!1)==="none"||a.hcOricDetached)&&(a.hcOrigStyle={display:a.style.display,height:a.style.height,overflow:a.style.overflow},k={display:"block",overflow:"hidden"},a!==this.renderTo&&(k.height=0),css$5(a,k),a.offsetWidth||a.style.setProperty("display","block","important")),a=a.parentNode,a!==doc$g.body););},j.prototype.setClassName=function(E){this.container.className="highcharts-container "+(E||"")},j.prototype.getContainer=function(){var E=this,a=E.options,k=a.chart,tt="data-highcharts-chart",et=uniqueKey$4(),rt,nt=E.renderTo;nt||(E.renderTo=nt=k.renderTo),isString$5(nt)&&(E.renderTo=nt=doc$g.getElementById(nt)),nt||error$5(13,!0,E);var ot=pInt$4(attr$1(nt,tt));isNumber$B(ot)&&charts$1[ot]&&charts$1[ot].hasRendered&&charts$1[ot].destroy(),attr$1(nt,tt,E.index),nt.innerHTML="",!k.skipClone&&!nt.offsetWidth&&E.temporaryDisplay(),E.getChartSize();var st=E.chartWidth,lt=E.chartHeight;css$5(nt,{overflow:"hidden"}),E.styledMode||(rt=extend$1h({position:"relative",overflow:"hidden",width:st+"px",height:lt+"px",textAlign:"left",lineHeight:"normal",zIndex:0,"-webkit-tap-highlight-color":"rgba(0,0,0,0)",userSelect:"none","touch-action":"manipulation",outline:"none"},k.style||{}));var ht=createElement$5("div",{id:et},rt,nt);E.container=ht,E._cursor=ht.style.cursor;var ut=k.renderer||!svg$3?RendererRegistry$1.getRendererType(k.renderer):SVGRenderer;if(E.renderer=new ut(ht,st,lt,void 0,k.forExport,a.exporting&&a.exporting.allowHTML,E.styledMode),setAnimation$3(void 0,E),E.setClassName(k.className),!E.styledMode)E.renderer.setStyle(k.style);else for(var dt in a.defs)this.renderer.definition(a.defs[dt]);E.renderer.chartIndex=E.index,fireEvent$s(this,"afterGetContainer")},j.prototype.getMargins=function(E){var a=this,k=a.spacing,tt=a.margin,et=a.titleOffset;this.resetMargins(),et[0]&&!defined$H(tt[0])&&(this.plotTop=Math.max(this.plotTop,et[0]+k[0])),et[2]&&!defined$H(tt[2])&&(this.marginBottom=Math.max(this.marginBottom,et[2]+k[2])),this.legend&&this.legend.display&&this.legend.adjustMargins(tt,k),fireEvent$s(this,"getMargins"),E||this.getAxisMargins()},j.prototype.getAxisMargins=function(){var E=this,a=E.axisOffset=[0,0,0,0],k=E.colorAxis,tt=E.margin,et=function(rt){rt.forEach(function(nt){nt.visible&&nt.getOffset()})};E.hasCartesianSeries?et(E.axes):k&&k.length&&et(k),marginNames.forEach(function(rt,nt){defined$H(tt[nt])||(E[rt]+=a[nt])}),E.setChartSize()},j.prototype.reflow=function(E){var a=this,k=a.options.chart,tt=a.renderTo,et=defined$H(k.width)&&defined$H(k.height),rt=k.width||getStyle(tt,"width"),nt=k.height||getStyle(tt,"height"),ot=E?E.target:win$8;delete a.pointer.chartPosition,!et&&!a.isPrinting&&rt&&nt&&(ot===win$8||ot===doc$g)&&((rt!==a.containerWidth||nt!==a.containerHeight)&&(Utilities.clearTimeout(a.reflowTimeout),a.reflowTimeout=syncTimeout$3(function(){a.container&&a.setSize(void 0,void 0,!1)},E?100:0)),a.containerWidth=rt,a.containerHeight=nt)},j.prototype.setReflow=function(E){var a=this;E!==!1&&!this.unbindReflow?(this.unbindReflow=addEvent$T(win$8,"resize",function(k){a.options&&a.reflow(k)}),addEvent$T(this,"destroy",this.unbindReflow)):E===!1&&this.unbindReflow&&(this.unbindReflow=this.unbindReflow())},j.prototype.setSize=function(E,a,k){var tt=this,et=tt.renderer;tt.isResizing+=1,setAnimation$3(k,tt);var rt=et.globalAnimation;tt.oldChartHeight=tt.chartHeight,tt.oldChartWidth=tt.chartWidth,typeof E<"u"&&(tt.options.chart.width=E),typeof a<"u"&&(tt.options.chart.height=a),tt.getChartSize(),tt.styledMode||(rt?animate:css$5)(tt.container,{width:tt.chartWidth+"px",height:tt.chartHeight+"px"},rt),tt.setChartSize(!0),et.setSize(tt.chartWidth,tt.chartHeight,rt),tt.axes.forEach(function(nt){nt.isDirty=!0,nt.setScale()}),tt.isDirtyLegend=!0,tt.isDirtyBox=!0,tt.layOutTitles(),tt.getMargins(),tt.redraw(rt),tt.oldChartHeight=null,fireEvent$s(tt,"resize"),syncTimeout$3(function(){tt&&fireEvent$s(tt,"endResize",null,function(){tt.isResizing-=1})},animObject$7(rt).duration)},j.prototype.setChartSize=function(E){var a=this,k=a.inverted,tt=a.renderer,et=a.chartWidth,rt=a.chartHeight,nt=a.options.chart,ot=a.spacing,st=a.clipOffset,lt,ht,ut,dt;a.plotLeft=lt=Math.round(a.plotLeft),a.plotTop=ht=Math.round(a.plotTop),a.plotWidth=ut=Math.max(0,Math.round(et-lt-a.marginRight)),a.plotHeight=dt=Math.max(0,Math.round(rt-ht-a.marginBottom)),a.plotSizeX=k?dt:ut,a.plotSizeY=k?ut:dt,a.plotBorderWidth=nt.plotBorderWidth||0,a.spacingBox=tt.spacingBox={x:ot[3],y:ot[0],width:et-ot[3]-ot[1],height:rt-ot[0]-ot[2]},a.plotBox=tt.plotBox={x:lt,y:ht,width:ut,height:dt};var ft=2*Math.floor(a.plotBorderWidth/2),pt=Math.ceil(Math.max(ft,st[3])/2),gt=Math.ceil(Math.max(ft,st[0])/2);a.clipBox={x:pt,y:gt,width:Math.floor(a.plotSizeX-Math.max(ft,st[1])/2-pt),height:Math.max(0,Math.floor(a.plotSizeY-Math.max(ft,st[2])/2-gt))},E||(a.axes.forEach(function(yt){yt.setAxisSize(),yt.setAxisTranslation()}),tt.alignElements()),fireEvent$s(a,"afterSetChartSize",{skipAxes:E})},j.prototype.resetMargins=function(){fireEvent$s(this,"resetMargins");var E=this,a=E.options.chart;["margin","spacing"].forEach(function(tt){var et=a[tt],rt=isObject$9(et)?et:[et,et,et,et];["Top","Right","Bottom","Left"].forEach(function(nt,ot){E[tt][ot]=pick$1h(a[tt+nt],rt[ot])})}),marginNames.forEach(function(k,tt){E[k]=pick$1h(E.margin[tt],E.spacing[tt])}),E.axisOffset=[0,0,0,0],E.clipOffset=[0,0,0,0]},j.prototype.drawChartBox=function(){var E=this,a=E.options.chart,k=E.renderer,tt=E.chartWidth,et=E.chartHeight,rt=E.styledMode,nt=E.plotBGImage,ot=a.backgroundColor,st=a.plotBackgroundColor,lt=a.plotBackgroundImage,ht=E.plotLeft,ut=E.plotTop,dt=E.plotWidth,ft=E.plotHeight,pt=E.plotBox,gt=E.clipRect,yt=E.clipBox,mt=E.chartBackground,xt=E.plotBackground,wt=E.plotBorder,Mt,At,St,$t="animate";mt||(E.chartBackground=mt=k.rect().addClass("highcharts-background").add(),$t="attr"),rt?Mt=At=mt.strokeWidth():(Mt=a.borderWidth||0,At=Mt+(a.shadow?8:0),St={fill:ot||"none"},(Mt||mt["stroke-width"])&&(St.stroke=a.borderColor,St["stroke-width"]=Mt),mt.attr(St).shadow(a.shadow)),mt[$t]({x:At/2,y:At/2,width:tt-At-Mt%2,height:et-At-Mt%2,r:a.borderRadius}),$t="animate",xt||($t="attr",E.plotBackground=xt=k.rect().addClass("highcharts-plot-background").add()),xt[$t](pt),rt||(xt.attr({fill:st||"none"}).shadow(a.plotShadow),lt&&(nt?(lt!==nt.attr("href")&&nt.attr("href",lt),nt.animate(pt)):E.plotBGImage=k.image(lt,ht,ut,dt,ft).add())),gt?gt.animate({width:yt.width,height:yt.height}):E.clipRect=k.clipRect(yt),$t="animate",wt||($t="attr",E.plotBorder=wt=k.rect().addClass("highcharts-plot-border").attr({zIndex:1}).add()),rt||wt.attr({stroke:a.plotBorderColor,"stroke-width":a.plotBorderWidth||0,fill:"none"}),wt[$t](wt.crisp({x:ht,y:ut,width:dt,height:ft},-wt.strokeWidth())),E.isDirtyBox=!1,fireEvent$s(this,"afterDrawChartBox")},j.prototype.propFromSeries=function(){var E=this,a=E.options.chart,k=E.options.series,tt,et,rt;["inverted","angular","polar"].forEach(function(nt){for(et=seriesTypes$7[a.type||a.defaultSeriesType],rt=a[nt]||et&&et.prototype[nt],tt=k&&k.length;!rt&&tt--;)et=seriesTypes$7[k[tt].type],et&&et.prototype[nt]&&(rt=!0);E[nt]=rt})},j.prototype.linkSeries=function(){var E=this,a=E.series;a.forEach(function(k){k.linkedSeries.length=0}),a.forEach(function(k){var tt=k.options.linkedTo;isString$5(tt)&&(tt===":previous"?tt=E.series[k.index-1]:tt=E.get(tt),tt&&tt.linkedParent!==k&&(tt.linkedSeries.push(k),k.linkedParent=tt,tt.enabledDataSorting&&k.setDataSortingOptions(),k.visible=pick$1h(k.options.visible,tt.options.visible,k.visible)))}),fireEvent$s(this,"afterLinkSeries")},j.prototype.renderSeries=function(){this.series.forEach(function(E){E.translate(),E.render()})},j.prototype.renderLabels=function(){var E=this,a=E.options.labels;a.items&&a.items.forEach(function(k){var tt=extend$1h(a.style,k.style),et=pInt$4(tt.left)+E.plotLeft,rt=pInt$4(tt.top)+E.plotTop+12;delete tt.left,delete tt.top,E.renderer.text(k.html,et,rt).attr({zIndex:2}).css(tt).add()})},j.prototype.render=function(){var E=this,a=E.axes,k=E.colorAxis,tt=E.renderer,et=E.options,rt=function(ut){ut.forEach(function(dt){dt.visible&&dt.render()})},nt=0;E.setTitle(),E.legend=new Legend(E,et.legend),E.getStacks&&E.getStacks(),E.getMargins(!0),E.setChartSize();var ot=E.plotWidth;a.some(function(ut){if(ut.horiz&&ut.visible&&ut.options.labels.enabled&&ut.series.length)return nt=21,!0}),E.plotHeight=Math.max(E.plotHeight-nt,0);var st=E.plotHeight;a.forEach(function(ut){ut.setScale()}),E.getAxisMargins();var lt=ot/E.plotWidth>1.1,ht=st/E.plotHeight>1.05;(lt||ht)&&(a.forEach(function(ut){(ut.horiz&&lt||!ut.horiz&&ht)&&ut.setTickInterval(!0)}),E.getMargins()),E.drawChartBox(),E.hasCartesianSeries?rt(a):k&&k.length&&rt(k),E.seriesGroup||(E.seriesGroup=tt.g("series-group").attr({zIndex:3}).add()),E.renderSeries(),E.renderLabels(),E.addCredits(),E.setResponsive&&E.setResponsive(),E.hasRendered=!0},j.prototype.addCredits=function(E){var a=this,k=merge$1a(!0,this.options.credits,E);k.enabled&&!this.credits&&(this.credits=this.renderer.text(k.text+(this.mapCredits||""),0,0).addClass("highcharts-credits").on("click",function(){k.href&&(win$8.location.href=k.href)}).attr({align:k.position.align,zIndex:8}),a.styledMode||this.credits.css(k.style),this.credits.add().align(k.position),this.credits.update=function(tt){a.credits=a.credits.destroy(),a.addCredits(tt)})},j.prototype.destroy=function(){var E=this,a=E.axes,k=E.series,tt=E.container,et=tt&&tt.parentNode,rt;for(fireEvent$s(E,"destroy"),E.renderer.forExport?erase$3(charts$1,E):charts$1[E.index]=void 0,H.chartCount--,E.renderTo.removeAttribute("data-highcharts-chart"),removeEvent$6(E),rt=a.length;rt--;)a[rt]=a[rt].destroy();for(this.scroller&&this.scroller.destroy&&this.scroller.destroy(),rt=k.length;rt--;)k[rt]=k[rt].destroy();["title","subtitle","chartBackground","plotBackground","plotBGImage","plotBorder","seriesGroup","clipRect","credits","pointer","rangeSelector","legend","resetZoomButton","tooltip","renderer"].forEach(function(nt){var ot=E[nt];ot&&ot.destroy&&(E[nt]=ot.destroy())}),tt&&(tt.innerHTML="",removeEvent$6(tt),et&&discardElement$3(tt)),objectEach$n(E,function(nt,ot){delete E[ot]})},j.prototype.firstRender=function(){var E=this,a=E.options;E.isReadyToRender&&!E.isReadyToRender()||(E.getContainer(),E.resetMargins(),E.setChartSize(),E.propFromSeries(),E.getAxes(),(isArray$g(a.series)?a.series:[]).forEach(function(k){E.initSeries(k)}),E.linkSeries(),E.setSeriesData(),fireEvent$s(E,"beforeRender"),Pointer&&(MSPointer.isRequired()?E.pointer=new MSPointer(E,a):E.pointer=new Pointer(E,a)),E.render(),E.pointer.getChartPosition(),!E.renderer.imgCount&&!E.hasLoaded&&E.onload(),E.temporaryDisplay(!0))},j.prototype.onload=function(){this.callbacks.concat([this.callback]).forEach(function(E){E&&typeof this.index<"u"&&E.apply(this,[this])},this),fireEvent$s(this,"load"),fireEvent$s(this,"render"),defined$H(this.index)&&this.setReflow(this.options.chart.reflow),this.hasLoaded=!0},j.prototype.addSeries=function(E,a,k){var tt=this,et;return E&&(a=pick$1h(a,!0),fireEvent$s(tt,"addSeries",{options:E},function(){et=tt.initSeries(E),tt.isDirtyLegend=!0,tt.linkSeries(),et.enabledDataSorting&&et.setData(E.data,!1),fireEvent$s(tt,"afterAddSeries",{series:et}),a&&tt.redraw(k)})),et},j.prototype.addAxis=function(E,a,k,tt){return this.createAxis(a?"xAxis":"yAxis",{axis:E,redraw:k,animation:tt})},j.prototype.addColorAxis=function(E,a,k){return this.createAxis("colorAxis",{axis:E,redraw:a,animation:k})},j.prototype.createAxis=function(E,a){var k=new Axis(this,merge$1a(a.axis,{index:this[E].length,isX:E==="xAxis"}));return pick$1h(a.redraw,!0)&&this.redraw(a.animation),k},j.prototype.showLoading=function(E){var a=this,k=a.options,tt=k.loading,et=function(){rt&&css$5(rt,{left:a.plotLeft+"px",top:a.plotTop+"px",width:a.plotWidth+"px",height:a.plotHeight+"px"})},rt=a.loadingDiv,nt=a.loadingSpan;rt||(a.loadingDiv=rt=createElement$5("div",{className:"highcharts-loading highcharts-loading-hidden"},null,a.container)),nt||(a.loadingSpan=nt=createElement$5("span",{className:"highcharts-loading-inner"},null,rt),addEvent$T(a,"redraw",et)),rt.className="highcharts-loading",AST.setElementHTML(nt,pick$1h(E,k.lang.loading,"")),a.styledMode||(css$5(rt,extend$1h(tt.style,{zIndex:10})),css$5(nt,tt.labelStyle),a.loadingShown||(css$5(rt,{opacity:0,display:""}),animate(rt,{opacity:tt.style.opacity||.5},{duration:tt.showDuration||0}))),a.loadingShown=!0,et()},j.prototype.hideLoading=function(){var E=this.options,a=this.loadingDiv;a&&(a.className="highcharts-loading highcharts-loading-hidden",this.styledMode||animate(a,{opacity:0},{duration:E.loading.hideDuration||100,complete:function(){css$5(a,{display:"none"})}})),this.loadingShown=!1},j.prototype.update=function(E,a,k,tt){var et=this,rt={credits:"addCredits",title:"setTitle",subtitle:"setSubtitle",caption:"setCaption"},nt=E.isResponsiveOptions,ot=[],st,lt,ht;fireEvent$s(et,"update",{options:E}),nt||et.setResponsive(!1,!0),E=cleanRecursively$1(E,et.options),et.userOptions=merge$1a(et.userOptions,E);var ut=E.chart;ut&&(merge$1a(!0,et.options.chart,ut),"className"in ut&&et.setClassName(ut.className),"reflow"in ut&&et.setReflow(ut.reflow),("inverted"in ut||"polar"in ut||"type"in ut)&&(et.propFromSeries(),st=!0),"alignTicks"in ut&&(st=!0),"events"in ut&&registerEventOptions$1(this,ut),objectEach$n(ut,function(pt,gt){et.propsRequireUpdateSeries.indexOf("chart."+gt)!==-1&&(lt=!0),et.propsRequireDirtyBox.indexOf(gt)!==-1&&(et.isDirtyBox=!0),et.propsRequireReflow.indexOf(gt)!==-1&&(nt?et.isDirtyBox=!0:ht=!0)}),!et.styledMode&&ut.style&&et.renderer.setStyle(et.options.chart.style||{})),!et.styledMode&&E.colors&&(this.options.colors=E.colors),E.time&&(this.time===defaultTime&&(this.time=new Time(E.time)),merge$1a(!0,et.options.time,E.time)),objectEach$n(E,function(pt,gt){et[gt]&&typeof et[gt].update=="function"?et[gt].update(pt,!1):typeof et[rt[gt]]=="function"?et[rt[gt]](pt):gt!=="colors"&&et.collectionsWithUpdate.indexOf(gt)===-1&&merge$1a(!0,et.options[gt],E[gt]),gt!=="chart"&&et.propsRequireUpdateSeries.indexOf(gt)!==-1&&(lt=!0)}),this.collectionsWithUpdate.forEach(function(pt){var gt;E[pt]&&(gt=[],et[pt].forEach(function(yt,mt){yt.options.isInternal||gt.push(pick$1h(yt.options.index,mt))}),splat$d(E[pt]).forEach(function(yt,mt){var xt=defined$H(yt.id),wt;xt&&(wt=et.get(yt.id)),!wt&&et[pt]&&(wt=et[pt][gt?gt[mt]:mt],wt&&xt&&defined$H(wt.options.id)&&(wt=void 0)),wt&&wt.coll===pt&&(wt.update(yt,!1),k&&(wt.touched=!0)),!wt&&k&&et.collectionsWithInit[pt]&&(et.collectionsWithInit[pt][0].apply(et,[yt].concat(et.collectionsWithInit[pt][1]||[]).concat([!1])).touched=!0)}),k&&et[pt].forEach(function(yt){!yt.touched&&!yt.options.isInternal?ot.push(yt):delete yt.touched}))}),ot.forEach(function(pt){pt.chart&&pt.remove&&pt.remove(!1)}),st&&et.axes.forEach(function(pt){pt.update({},!1)}),lt&&et.getSeriesOrderByLinks().forEach(function(pt){pt.chart&&pt.update({},!1)},this);var dt=ut&&ut.width,ft=ut&&(isString$5(ut.height)?relativeLength$7(ut.height,dt||et.chartWidth):ut.height);ht||isNumber$B(dt)&&dt!==et.chartWidth||isNumber$B(ft)&&ft!==et.chartHeight?et.setSize(dt,ft,tt):pick$1h(a,!0)&&et.redraw(tt),fireEvent$s(et,"afterUpdate",{options:E,redraw:a,animation:tt})},j.prototype.setSubtitle=function(E,a){this.applyDescription("subtitle",E),this.layOutTitles(a)},j.prototype.setCaption=function(E,a){this.applyDescription("caption",E),this.layOutTitles(a)},j.prototype.showResetZoom=function(){var E=this,a=defaultOptions$b.lang,k=E.options.chart.resetZoomButton,tt=k.theme,et=tt.states,rt=k.relativeTo==="chart"||k.relativeTo==="spacingBox"?null:"scrollablePlotBox";function nt(){E.zoomOut()}fireEvent$s(this,"beforeShowResetZoom",null,function(){E.resetZoomButton=E.renderer.button(a.resetZoom,null,null,nt,tt,et&&et.hover).attr({align:k.position.align,title:a.resetZoomTitle}).addClass("highcharts-reset-zoom").add().align(k.position,!1,rt)}),fireEvent$s(this,"afterShowResetZoom")},j.prototype.zoomOut=function(){fireEvent$s(this,"selection",{resetSelection:!0},this.zoom)},j.prototype.zoom=function(E){var a=this,k=a.pointer,tt=a.inverted?k.mouseDownX:k.mouseDownY,et=!1,rt;!E||E.resetSelection?(a.axes.forEach(function(ot){rt=ot.zoom()}),k.initiated=!1):E.xAxis.concat(E.yAxis).forEach(function(ot){var st=ot.axis,lt=a.inverted?st.left:st.top,ht=a.inverted?lt+st.width:lt+st.height,ut=st.isXAxis,dt=!1;(!ut&&tt>=lt&&tt<=ht||ut||!defined$H(tt))&&(dt=!0),k[ut?"zoomX":"zoomY"]&&dt&&(rt=st.zoom(ot.min,ot.max),st.displayBtn&&(et=!0))});var nt=a.resetZoomButton;et&&!nt?a.showResetZoom():!et&&isObject$9(nt)&&(a.resetZoomButton=nt.destroy()),rt&&a.redraw(pick$1h(a.options.chart.animation,E&&E.animation,a.pointCount<100))},j.prototype.pan=function(E,a){var k=this,tt=k.hoverPoints,et=typeof a=="object"?a:{enabled:a,type:"x"},rt=k.options.chart,nt=k.options.mapNavigation&&k.options.mapNavigation.enabled;rt&&rt.panning&&(rt.panning=et);var ot=et.type,st;fireEvent$s(this,"pan",{originalEvent:E},function(){tt&&tt.forEach(function(ut){ut.setState()});var lt=k.xAxis;ot==="xy"?lt=lt.concat(k.yAxis):ot==="y"&&(lt=k.yAxis);var ht={};lt.forEach(function(ut){if(!(!ut.options.panningEnabled||ut.options.isInternal)){var dt=ut.horiz,ft=E[dt?"chartX":"chartY"],pt=dt?"mouseDownX":"mouseDownY",gt=k[pt],yt=ut.minPointOffset||0,mt=ut.reversed&&!k.inverted||!ut.reversed&&k.inverted?-1:1,xt=ut.getExtremes(),wt=ut.toValue(gt-ft,!0)+yt*mt,Mt=ut.toValue(gt+ut.len-ft,!0)-(yt*mt||ut.isXAxis&&ut.pointRangePadding||0),At=Mt<wt,St=ut.hasVerticalPanning(),$t=At?Mt:wt,Tt=At?wt:Mt,Pt=ut.panningState,It;St&&!ut.isXAxis&&(!Pt||Pt.isDirty)&&ut.series.forEach(function(Ht){var jt=Ht.getProcessedData(!0),Dt=Ht.getExtremes(jt.yData,!0);Pt||(Pt={startMin:Number.MAX_VALUE,startMax:-Number.MAX_VALUE}),isNumber$B(Dt.dataMin)&&isNumber$B(Dt.dataMax)&&(Pt.startMin=Math.min(pick$1h(Ht.options.threshold,1/0),Dt.dataMin,Pt.startMin),Pt.startMax=Math.max(pick$1h(Ht.options.threshold,-1/0),Dt.dataMax,Pt.startMax))});var Lt=Math.min(pick$1h(Pt&&Pt.startMin,xt.dataMin),yt?xt.min:ut.toValue(ut.toPixels(xt.min)-ut.minPixelPadding)),Nt=Math.max(pick$1h(Pt&&Pt.startMax,xt.dataMax),yt?xt.max:ut.toValue(ut.toPixels(xt.max)+ut.minPixelPadding));ut.panningState=Pt,ut.isOrdinal||(It=Lt-$t,It>0&&(Tt+=It,$t=Lt),It=Tt-Nt,It>0&&(Tt=Nt,$t-=It),ut.series.length&&$t!==xt.min&&Tt!==xt.max&&$t>=Lt&&Tt<=Nt&&(ut.setExtremes($t,Tt,!1,!1,{trigger:"pan"}),!k.resetZoomButton&&!nt&&$t!==Lt&&Tt!==Nt&&ot.match("y")&&(k.showResetZoom(),ut.displayBtn=!1),st=!0),ht[pt]=ft)}}),objectEach$n(ht,function(ut,dt){k[dt]=ut}),st&&k.redraw(!1),css$5(k.container,{cursor:"move"})})},j}();extend$1h(Chart$1.prototype,{callbacks:[],collectionsWithInit:{xAxis:[Chart$1.prototype.addAxis,[!0]],yAxis:[Chart$1.prototype.addAxis,[!1]],series:[Chart$1.prototype.addSeries]},collectionsWithUpdate:["xAxis","yAxis","series"],propsRequireDirtyBox:["backgroundColor","borderColor","borderWidth","borderRadius","plotBackgroundColor","plotBackgroundImage","plotBorderColor","plotBorderWidth","plotShadow","shadow"],propsRequireReflow:["margin","marginTop","marginRight","marginBottom","marginLeft","spacing","spacingTop","spacingRight","spacingBottom","spacingLeft"],propsRequireUpdateSeries:["chart.inverted","chart.polar","chart.ignoreHiddenSeries","chart.type","colors","plotOptions","time","tooltip"]});var merge$19=Utilities.merge,pick$1g=Utilities.pick,LegendSymbol;(function(j){function E(k){var tt=this.options,et=k.symbolWidth,rt=k.symbolHeight,nt=rt/2,ot=this.chart.renderer,st=this.legendGroup,lt=k.baseline-Math.round(k.fontMetrics.b*.3),ht={},ut,dt=tt.marker;if(this.chart.styledMode||(ht={"stroke-width":tt.lineWidth||0},tt.dashStyle&&(ht.dashstyle=tt.dashStyle)),this.legendLine=ot.path([["M",0,lt],["L",et,lt]]).addClass("highcharts-graph").attr(ht).add(st),dt&&dt.enabled!==!1&&et){var ft=Math.min(pick$1g(dt.radius,nt),nt);this.symbol.indexOf("url")===0&&(dt=merge$19(dt,{width:rt,height:rt}),ft=0),this.legendSymbol=ut=ot.symbol(this.symbol,et/2-ft,lt-ft,2*ft,2*ft,dt).addClass("highcharts-point").add(st),ut.isMarker=!0}}j.drawLineMarker=E;function a(k,tt){var et=k.options,rt=k.symbolHeight,nt=et.squareSymbol,ot=nt?rt:k.symbolWidth;tt.legendSymbol=this.chart.renderer.rect(nt?(k.symbolWidth-rt)/2:0,k.baseline-rt+1,ot,rt,pick$1g(k.options.symbolRadius,rt/2)).addClass("highcharts-point").attr({zIndex:3}).add(tt.legendGroup)}j.drawRectangle=a})(LegendSymbol||(LegendSymbol={}));const LegendSymbol$1=LegendSymbol;var seriesDefaults={lineWidth:2,allowPointSelect:!1,crisp:!0,showCheckbox:!1,animation:{duration:1e3},events:{},marker:{enabledThreshold:2,lineColor:palette.backgroundColor,lineWidth:0,radius:4,states:{normal:{animation:!0},hover:{animation:{duration:50},enabled:!0,radiusPlus:2,lineWidthPlus:1},select:{fillColor:palette.neutralColor20,lineColor:palette.neutralColor100,lineWidth:2}}},point:{events:{}},dataLabels:{animation:{},align:"center",defer:!0,formatter:function(){var j=this.series.chart.numberFormatter;return typeof this.y!="number"?"":j(this.y,-1)},padding:5,style:{fontSize:"11px",fontWeight:"bold",color:"contrast",textOutline:"1px contrast"},verticalAlign:"bottom",x:0,y:0},cropThreshold:300,opacity:1,pointRange:0,softThreshold:!0,states:{normal:{animation:!0},hover:{animation:{duration:50},lineWidthPlus:1,marker:{},halo:{size:10,opacity:.25}},select:{animation:{duration:0}},inactive:{animation:{duration:50},opacity:.2}},stickyTracking:!0,turboThreshold:1e3,findNearestPointBy:"x"},animObject$6=animationExports.animObject,setAnimation$2=animationExports.setAnimation,defaultOptions$a=DefaultOptions.defaultOptions,registerEventOptions=exports$6.registerEventOptions,hasTouch$2=H.hasTouch,svg$2=H.svg,win$7=H.win,seriesTypes$6=SeriesRegistry$1.seriesTypes,addEvent$S=Utilities.addEvent,arrayMax$7=Utilities.arrayMax,arrayMin$6=Utilities.arrayMin,clamp$f=Utilities.clamp,cleanRecursively=Utilities.cleanRecursively,correctFloat$a=Utilities.correctFloat,defined$G=Utilities.defined,erase$2=Utilities.erase,error$4=Utilities.error,extend$1g=Utilities.extend,find$f=Utilities.find,fireEvent$r=Utilities.fireEvent,getNestedProperty=Utilities.getNestedProperty,isArray$f=Utilities.isArray,isNumber$A=Utilities.isNumber,isString$4=Utilities.isString,merge$18=Utilities.merge,objectEach$m=Utilities.objectEach,pick$1f=Utilities.pick,removeEvent$5=Utilities.removeEvent,splat$c=Utilities.splat,syncTimeout$2=Utilities.syncTimeout,Series$e=function(){function j(){this._i=void 0,this.chart=void 0,this.data=void 0,this.eventOptions=void 0,this.eventsToUnbind=void 0,this.index=void 0,this.linkedSeries=void 0,this.options=void 0,this.points=void 0,this.processedXData=void 0,this.processedYData=void 0,this.tooltipOptions=void 0,this.userOptions=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zones=void 0}return j.prototype.init=function(E,a){fireEvent$r(this,"init",{options:a});var k=this,tt=E.series;this.eventsToUnbind=[],k.chart=E,k.options=k.setOptions(a);var et=k.options;k.linkedSeries=[],k.bindAxes(),extend$1g(k,{name:et.name,state:"",visible:et.visible!==!1,selected:et.selected===!0}),registerEventOptions(this,et);var rt=et.events;(rt&&rt.click||et.point&&et.point.events&&et.point.events.click||et.allowPointSelect)&&(E.runTrackerClick=!0),k.getColor(),k.getSymbol(),k.parallelArrays.forEach(function(ot){k[ot+"Data"]||(k[ot+"Data"]=[])}),k.isCartesian&&(E.hasCartesianSeries=!0);var nt;tt.length&&(nt=tt[tt.length-1]),k._i=pick$1f(nt&&nt._i,-1)+1,k.opacity=k.options.opacity,E.orderSeries(this.insert(tt)),et.dataSorting&&et.dataSorting.enabled?k.setDataSortingOptions():!k.points&&!k.data&&k.setData(et.data,!1),fireEvent$r(this,"afterInit")},j.prototype.is=function(E){return seriesTypes$6[E]&&this instanceof seriesTypes$6[E]},j.prototype.insert=function(E){var a=this.options.index,k;if(isNumber$A(a)){for(k=E.length;k--;)if(a>=pick$1f(E[k].options.index,E[k]._i)){E.splice(k+1,0,this);break}k===-1&&E.unshift(this),k=k+1}else E.push(this);return pick$1f(k,E.length-1)},j.prototype.bindAxes=function(){var E=this,a=E.options,k=E.chart,tt;fireEvent$r(this,"bindAxes",null,function(){(E.axisTypes||[]).forEach(function(et){var rt=0;k[et].forEach(function(nt){tt=nt.options,(a[et]===rt&&!tt.isInternal||typeof a[et]<"u"&&a[et]===tt.id||typeof a[et]>"u"&&tt.index===0)&&(E.insert(nt.series),E[et]=nt,nt.isDirty=!0),tt.isInternal||rt++}),!E[et]&&E.optionalAxis!==et&&error$4(18,!0,k)})}),fireEvent$r(this,"afterBindAxes")},j.prototype.updateParallelArrays=function(E,a){var k=E.series,tt=arguments,et=isNumber$A(a)?function(rt){var nt=rt==="y"&&k.toYData?k.toYData(E):E[rt];k[rt+"Data"][a]=nt}:function(rt){Array.prototype[a].apply(k[rt+"Data"],Array.prototype.slice.call(tt,2))};k.parallelArrays.forEach(et)},j.prototype.hasData=function(){return this.visible&&typeof this.dataMax<"u"&&typeof this.dataMin<"u"||this.visible&&this.yData&&this.yData.length>0},j.prototype.autoIncrement=function(E){var a=this.options,k=a.pointIntervalUnit,tt=a.relativeXValue,et=this.chart.time,rt=this.xIncrement,nt,ot;return rt=pick$1f(rt,a.pointStart,0),this.pointInterval=ot=pick$1f(this.pointInterval,a.pointInterval,1),tt&&isNumber$A(E)&&(ot*=E),k&&(nt=new et.Date(rt),k==="day"?et.set("Date",nt,et.get("Date",nt)+ot):k==="month"?et.set("Month",nt,et.get("Month",nt)+ot):k==="year"&&et.set("FullYear",nt,et.get("FullYear",nt)+ot),ot=nt.getTime()-rt),tt&&isNumber$A(E)?rt+ot:(this.xIncrement=rt+ot,rt)},j.prototype.setDataSortingOptions=function(){var E=this.options;extend$1g(this,{requireSorting:!1,sorted:!1,enabledDataSorting:!0,allowDG:!1}),defined$G(E.pointRange)||(E.pointRange=1)},j.prototype.setOptions=function(E){var a=this.chart,k=a.options,tt=k.plotOptions,et=a.userOptions||{},rt=merge$18(E),nt=a.styledMode,ot={plotOptions:tt,userOptions:rt},st;fireEvent$r(this,"setOptions",ot);var lt=ot.plotOptions[this.type],ht=et.plotOptions||{};this.userOptions=ot.userOptions;var ut=merge$18(lt,tt.series,et.plotOptions&&et.plotOptions[this.type],rt);this.tooltipOptions=merge$18(defaultOptions$a.tooltip,defaultOptions$a.plotOptions.series&&defaultOptions$a.plotOptions.series.tooltip,defaultOptions$a.plotOptions[this.type].tooltip,k.tooltip.userOptions,tt.series&&tt.series.tooltip,tt[this.type].tooltip,rt.tooltip),this.stickyTracking=pick$1f(rt.stickyTracking,ht[this.type]&&ht[this.type].stickyTracking,ht.series&&ht.series.stickyTracking,this.tooltipOptions.shared&&!this.noSharedTooltip?!0:ut.stickyTracking),lt.marker===null&&delete ut.marker,this.zoneAxis=ut.zoneAxis;var dt=this.zones=(ut.zones||[]).slice();return(ut.negativeColor||ut.negativeFillColor)&&!ut.zones&&(st={value:ut[this.zoneAxis+"Threshold"]||ut.threshold||0,className:"highcharts-negative"},nt||(st.color=ut.negativeColor,st.fillColor=ut.negativeFillColor),dt.push(st)),dt.length&&defined$G(dt[dt.length-1].value)&&dt.push(nt?{}:{color:this.color,fillColor:this.fillColor}),fireEvent$r(this,"afterSetOptions",{options:ut}),ut},j.prototype.getName=function(){return pick$1f(this.options.name,"Series "+(this.index+1))},j.prototype.getCyclic=function(E,a,k){var tt=this.chart,et=this.userOptions,rt=E+"Index",nt=E+"Counter",ot=k?k.length:pick$1f(tt.options.chart[E+"Count"],tt[E+"Count"]),st,lt;a||(lt=pick$1f(et[rt],et["_"+rt]),defined$G(lt)?st=lt:(tt.series.length||(tt[nt]=0),et["_"+rt]=st=tt[nt]%ot,tt[nt]+=1),k&&(a=k[st])),typeof st<"u"&&(this[rt]=st),this[E]=a},j.prototype.getColor=function(){this.chart.styledMode?this.getCyclic("color"):this.options.colorByPoint?this.color=palette.neutralColor20:this.getCyclic("color",this.options.color||defaultOptions$a.plotOptions[this.type].color,this.chart.options.colors)},j.prototype.getPointsCollection=function(){return(this.hasGroupedData?this.points:this.data)||[]},j.prototype.getSymbol=function(){var E=this.options.marker;this.getCyclic("symbol",E.symbol,this.chart.options.symbols)},j.prototype.findPointIndex=function(E,a){var k=E.id,tt=E.x,et=this.points,rt=this.options.dataSorting,nt,ot,st;if(k){var lt=this.chart.get(k);lt instanceof Point$5&&(nt=lt)}else if(this.linkedParent||this.enabledDataSorting||this.options.relativeXValue){var ht=function(ut){return!ut.touched&&ut.index===E.index};if(rt&&rt.matchByName?ht=function(ut){return!ut.touched&&ut.name===E.name}:this.options.relativeXValue&&(ht=function(ut){return!ut.touched&&ut.options.x===E.x}),nt=find$f(et,ht),!nt)return}return nt&&(st=nt&&nt.index,typeof st<"u"&&(ot=!0)),typeof st>"u"&&isNumber$A(tt)&&(st=this.xData.indexOf(tt,a)),st!==-1&&typeof st<"u"&&this.cropped&&(st=st>=this.cropStart?st-this.cropStart:st),!ot&&isNumber$A(st)&&et[st]&&et[st].touched&&(st=void 0),st},j.prototype.updateData=function(E,a){var k=this.options,tt=k.dataSorting,et=this.points,rt=[],nt=this.requireSorting,ot=E.length===et.length,st,lt,ht,ut,dt=!0;if(this.xIncrement=null,E.forEach(function(ft,pt){var gt=defined$G(ft)&&this.pointClass.prototype.optionsToObject.call({series:this},ft)||{},yt,mt=gt.x,xt=gt.id;xt||isNumber$A(mt)?(yt=this.findPointIndex(gt,ut),yt===-1||typeof yt>"u"?rt.push(ft):et[yt]&&ft!==k.data[yt]?(et[yt].update(ft,!1,null,!1),et[yt].touched=!0,nt&&(ut=yt+1)):et[yt]&&(et[yt].touched=!0),(!ot||pt!==yt||tt&&tt.enabled||this.hasDerivedData)&&(st=!0)):rt.push(ft)},this),st)for(lt=et.length;lt--;)ht=et[lt],ht&&!ht.touched&&ht.remove&&ht.remove(!1,a);else ot&&(!tt||!tt.enabled)?(E.forEach(function(ft,pt){ft!==et[pt].y&&et[pt].update&&et[pt].update(ft,!1,null,!1)}),rt.length=0):dt=!1;return et.forEach(function(ft){ft&&(ft.touched=!1)}),dt?(rt.forEach(function(ft){this.addPoint(ft,!1,null,null,!1)},this),this.xIncrement===null&&this.xData&&this.xData.length&&(this.xIncrement=arrayMax$7(this.xData),this.autoIncrement()),!0):!1},j.prototype.setData=function(E,a,k,tt){var et=this,rt=et.points,nt=rt&&rt.length||0,ot=et.options,st=et.chart,lt=ot.dataSorting,ht=et.xAxis,ut=ot.turboThreshold,dt=this.xData,ft=this.yData,pt=et.pointArrayMap,gt=pt&&pt.length,yt=ot.keys,mt,xt,wt,Mt=0,At=1,St=null;E=E||[];var $t=E.length;if(a=pick$1f(a,!0),lt&&lt.enabled&&(E=this.sortData(E)),tt!==!1&&$t&&nt&&!et.cropped&&!et.hasGroupedData&&et.visible&&!et.isSeriesBoosting&&(wt=this.updateData(E,k)),!wt){if(et.xIncrement=null,et.colorCounter=0,this.parallelArrays.forEach(function(Tt){et[Tt+"Data"].length=0}),ut&&$t>ut)if(St=et.getFirstValidPoint(E),isNumber$A(St))for(mt=0;mt<$t;mt++)dt[mt]=this.autoIncrement(),ft[mt]=E[mt];else if(isArray$f(St))if(gt)for(mt=0;mt<$t;mt++)xt=E[mt],dt[mt]=xt[0],ft[mt]=xt.slice(1,gt+1);else for(yt&&(Mt=yt.indexOf("x"),At=yt.indexOf("y"),Mt=Mt>=0?Mt:0,At=At>=0?At:1),mt=0;mt<$t;mt++)xt=E[mt],dt[mt]=xt[Mt],ft[mt]=xt[At];else error$4(12,!1,st);else for(mt=0;mt<$t;mt++)typeof E[mt]<"u"&&(xt={series:et},et.pointClass.prototype.applyOptions.apply(xt,[E[mt]]),et.updateParallelArrays(xt,mt));for(ft&&isString$4(ft[0])&&error$4(14,!0,st),et.data=[],et.options.data=et.userOptions.data=E,mt=nt;mt--;)rt[mt]&&rt[mt].destroy&&rt[mt].destroy();ht&&(ht.minRange=ht.userMinRange),et.isDirty=st.isDirtyBox=!0,et.isDirtyData=!!rt,k=!1}ot.legendType==="point"&&(this.processData(),this.generatePoints()),a&&st.redraw(k)},j.prototype.sortData=function(E){var a=this,k=a.options,tt=k.dataSorting,et=tt.sortKey||"y",rt=function(ot,st){return defined$G(st)&&ot.pointClass.prototype.optionsToObject.call({series:ot},st)||{}};E.forEach(function(ot,st){E[st]=rt(a,ot),E[st].index=st},this);var nt=E.concat().sort(function(ot,st){var lt=getNestedProperty(et,ot),ht=getNestedProperty(et,st);return ht<lt?-1:ht>lt?1:0});return nt.forEach(function(ot,st){ot.x=st},this),a.linkedSeries&&a.linkedSeries.forEach(function(ot){var st=ot.options,lt=st.data;(!st.dataSorting||!st.dataSorting.enabled)&&lt&&(lt.forEach(function(ht,ut){lt[ut]=rt(ot,ht),E[ut]&&(lt[ut].x=E[ut].x,lt[ut].index=ut)}),ot.setData(lt,!1))}),E},j.prototype.getProcessedData=function(E){var a=this,k=a.xAxis,tt=a.options,et=tt.cropThreshold,rt=E||a.getExtremesFromAll||tt.getExtremesFromAll,nt=a.isCartesian,ot=k&&k.val2lin,st=!!(k&&k.logarithmic),lt,ht,ut=0,dt,ft,pt,gt,yt,mt,xt=a.xData,wt=a.yData,Mt=a.requireSorting,At=!1,St=xt.length;for(k&&(gt=k.getExtremes(),yt=gt.min,mt=gt.max,At=k.categories&&!k.names.length),nt&&a.sorted&&!rt&&(!et||St>et||a.forceCrop)&&(xt[St-1]<yt||xt[0]>mt?(xt=[],wt=[]):a.yData&&(xt[0]<yt||xt[St-1]>mt)&&(lt=this.cropData(a.xData,a.yData,yt,mt),xt=lt.xData,wt=lt.yData,ut=lt.start,ht=!0)),pt=xt.length||1;--pt;)dt=st?ot(xt[pt])-ot(xt[pt-1]):xt[pt]-xt[pt-1],dt>0&&(typeof ft>"u"||dt<ft)?ft=dt:dt<0&&Mt&&!At&&(error$4(15,!1,a.chart),Mt=!1);return{xData:xt,yData:wt,cropped:ht,cropStart:ut,closestPointRange:ft}},j.prototype.processData=function(E){var a=this,k=a.xAxis;if(a.isCartesian&&!a.isDirty&&!k.isDirty&&!a.yAxis.isDirty&&!E)return!1;var tt=a.getProcessedData();a.cropped=tt.cropped,a.cropStart=tt.cropStart,a.processedXData=tt.xData,a.processedYData=tt.yData,a.closestPointRange=a.basePointRange=tt.closestPointRange},j.prototype.cropData=function(E,a,k,tt,et){var rt=E.length,nt,ot,st=0,lt=rt;for(et=pick$1f(et,this.cropShoulder),nt=0;nt<rt;nt++)if(E[nt]>=k){st=Math.max(0,nt-et);break}for(ot=nt;ot<rt;ot++)if(E[ot]>tt){lt=ot+et;break}return{xData:E.slice(st,lt),yData:a.slice(st,lt),start:st,end:lt}},j.prototype.generatePoints=function(){var E=this,a=E.options,k=a.data,tt=E.processedXData,et=E.processedYData,rt=E.pointClass,nt=tt.length,ot=E.cropStart||0,st=E.hasGroupedData,lt=a.keys,ht=[],ut=a.dataGrouping&&a.dataGrouping.groupAll?ot:0,dt,ft,pt,gt,yt=E.data;if(!yt&&!st){var mt=[];mt.length=k.length,yt=E.data=mt}for(lt&&st&&(E.options.keys=!1),gt=0;gt<nt;gt++)ft=ot+gt,st?(pt=new rt().init(E,[tt[gt]].concat(splat$c(et[gt]))),pt.dataGroup=E.groupMap[ut+gt],pt.dataGroup.options&&(pt.options=pt.dataGroup.options,extend$1g(pt,pt.dataGroup.options),delete pt.dataLabels)):(pt=yt[ft],!pt&&typeof k[ft]<"u"&&(yt[ft]=pt=new rt().init(E,k[ft],tt[gt]))),pt&&(pt.index=st?ut+gt:ft,ht[gt]=pt);if(E.options.keys=lt,yt&&(nt!==(dt=yt.length)||st))for(gt=0;gt<dt;gt++)gt===ot&&!st&&(gt+=nt),yt[gt]&&(yt[gt].destroyElements(),yt[gt].plotX=void 0);E.data=yt,E.points=ht,fireEvent$r(this,"afterGeneratePoints")},j.prototype.getXExtremes=function(E){return{min:arrayMin$6(E),max:arrayMax$7(E)}},j.prototype.getExtremes=function(E,a){var k=this.xAxis,tt=this.yAxis,et=this.processedXData||this.xData,rt=[],nt=this.requireSorting?this.cropShoulder:0,ot=tt?tt.positiveValuesOnly:!1,st,lt,ht,ut,dt,ft,pt,gt=0,yt=0,mt=0;E=E||this.stackedYData||this.processedYData||[];var xt=E.length;for(k&&(st=k.getExtremes(),gt=st.min,yt=st.max),ft=0;ft<xt;ft++)if(ut=et[ft],dt=E[ft],lt=(isNumber$A(dt)||isArray$f(dt))&&(dt.length||dt>0||!ot),ht=a||this.getExtremesFromAll||this.options.getExtremesFromAll||this.cropped||!k||(et[ft+nt]||ut)>=gt&&(et[ft-nt]||ut)<=yt,lt&&ht)if(pt=dt.length,pt)for(;pt--;)isNumber$A(dt[pt])&&(rt[mt++]=dt[pt]);else rt[mt++]=dt;var wt={dataMin:arrayMin$6(rt),dataMax:arrayMax$7(rt)};return fireEvent$r(this,"afterGetExtremes",{dataExtremes:wt}),wt},j.prototype.applyExtremes=function(){var E=this.getExtremes();return this.dataMin=E.dataMin,this.dataMax=E.dataMax,E},j.prototype.getFirstValidPoint=function(E){for(var a=E.length,k=0,tt=null;tt===null&&k<a;)tt=E[k],k++;return tt},j.prototype.translate=function(){this.processedXData||this.processData(),this.generatePoints();var E=this,a=E.options,k=a.stacking,tt=E.xAxis,et=tt.categories,rt=E.enabledDataSorting,nt=E.yAxis,ot=E.points,st=ot.length,lt=!!E.modifyValue,ht=E.pointPlacementToXValue(),ut=Boolean(ht),dt=a.threshold,ft=a.startFromThreshold?dt:0,pt=this.zoneAxis||"y",gt,yt,mt,xt,wt=Number.MAX_VALUE;function Mt(Ht){return clamp$f(Ht,-1e5,1e5)}for(gt=0;gt<st;gt++){var At=ot[gt],St=At.x,$t=void 0,Tt=void 0,Pt=At.y,It=At.low,Lt=k&&nt.stacking&&nt.stacking.stacks[(E.negStacks&&Pt<(ft?0:dt)?"-":"")+E.stackKey];if((nt.positiveValuesOnly&&!nt.validatePositiveValue(Pt)||tt.positiveValuesOnly&&!tt.validatePositiveValue(St))&&(At.isNull=!0),At.plotX=yt=correctFloat$a(Mt(tt.translate(St,0,0,0,1,ht,this.type==="flags"))),k&&E.visible&&Lt&&Lt[St]&&(xt=E.getStackIndicator(xt,St,E.index),At.isNull||($t=Lt[St],Tt=$t.points[xt.key])),isArray$f(Tt)&&(It=Tt[0],Pt=Tt[1],It===ft&&xt.key===Lt[St].base&&(It=pick$1f(isNumber$A(dt)&&dt,nt.min)),nt.positiveValuesOnly&&It<=0&&(It=null),At.total=At.stackTotal=$t.total,At.percentage=$t.total&&At.y/$t.total*100,At.stackY=Pt,E.irregularWidths||$t.setOffset(E.pointXOffset||0,E.barW||0)),At.yBottom=defined$G(It)?Mt(nt.translate(It,0,1,0,1)):null,lt&&(Pt=E.modifyValue(Pt,At)),At.plotY=void 0,isNumber$A(Pt)){var Nt=nt.translate(Pt,!1,!0,!1,!0);typeof Nt<"u"&&(At.plotY=Mt(Nt))}At.isInside=this.isPointInside(At),At.clientX=ut?correctFloat$a(tt.translate(St,0,0,0,1,ht)):yt,At.negative=At[pt]<(a[pt+"Threshold"]||dt||0),At.category=et&&typeof et[At.x]<"u"?et[At.x]:At.x,!At.isNull&&At.visible!==!1&&(typeof mt<"u"&&(wt=Math.min(wt,Math.abs(yt-mt))),mt=yt),At.zone=this.zones.length&&At.getZone(),!At.graphic&&E.group&&rt&&(At.isNew=!0)}E.closestPointRangePx=wt,fireEvent$r(this,"afterTranslate")},j.prototype.getValidPoints=function(E,a,k){var tt=this.chart;return(E||this.points||[]).filter(function(et){return a&&!tt.isInsidePlot(et.plotX,et.plotY,{inverted:tt.inverted})?!1:et.visible!==!1&&(k||!et.isNull)})},j.prototype.getClipBox=function(E,a){var k=this,tt=k.options,et=k.chart,rt=et.inverted,nt=k.xAxis,ot=nt&&k.yAxis,st=et.options.chart.scrollablePlotArea||{},lt;return E&&tt.clip===!1&&ot?lt=rt?{y:-et.chartWidth+ot.len+ot.pos,height:et.chartWidth,width:et.chartHeight,x:-et.chartHeight+nt.len+nt.pos}:{y:-ot.pos,height:et.chartHeight,width:et.chartWidth,x:-nt.pos}:(lt=k.clipBox||et.clipBox,a&&(lt.width=et.plotSizeX,lt.x=(et.scrollablePixelsX||0)*(st.scrollPositionX||0))),a?{width:lt.width,x:lt.x}:lt},j.prototype.getSharedClipKey=function(E){if(this.sharedClipKey)return this.sharedClipKey;var a=[E&&E.duration,E&&E.easing,E&&E.defer,this.getClipBox(E).height,this.options.xAxis,this.options.yAxis].join(",");return(this.options.clip!==!1||E)&&(this.sharedClipKey=a),a},j.prototype.setClip=function(E){var a=this.chart,k=this.options,tt=a.renderer,et=a.inverted,rt=this.clipBox,nt=this.getClipBox(E),ot=this.getSharedClipKey(E),st=a.sharedClips[ot],lt=a.sharedClips[ot+"m"];E&&(nt.width=0,et&&(nt.x=a.plotHeight+(k.clip!==!1?0:a.plotTop))),st?a.hasLoaded||st.attr(nt):(E&&(a.sharedClips[ot+"m"]=lt=tt.clipRect(et?(a.plotSizeX||0)+99:-99,et?-a.plotLeft:-a.plotTop,99,et?a.chartWidth:a.chartHeight)),a.sharedClips[ot]=st=tt.clipRect(nt),st.count={length:0}),E&&(st.count[this.index]||(st.count[this.index]=!0,st.count.length+=1)),(k.clip!==!1||E)&&(this.group.clip(E||rt?st:a.clipRect),this.markerGroup.clip(lt)),E||(st.count[this.index]&&(delete st.count[this.index],st.count.length-=1),st.count.length===0&&(rt||(a.sharedClips[ot]=st.destroy()),lt&&(a.sharedClips[ot+"m"]=lt.destroy())))},j.prototype.animate=function(E){var a=this,k=a.chart,tt=animObject$6(a.options.animation),et=this.sharedClipKey;if(E)a.setClip(tt);else if(et){var rt=k.sharedClips[et],nt=k.sharedClips[et+"m"],ot=a.getClipBox(tt,!0);rt&&rt.animate(ot,tt),nt&&nt.animate({width:ot.width+99,x:ot.x-(k.inverted?0:99)},tt)}},j.prototype.afterAnimate=function(){this.setClip(),fireEvent$r(this,"afterAnimate"),this.finishedAnimating=!0},j.prototype.drawPoints=function(){var E=this,a=E.points,k=E.chart,tt=E.options,et=tt.marker,rt=E[E.specialGroup]||E.markerGroup,nt=E.xAxis,ot=pick$1f(et.enabled,!nt||nt.isRadial?!0:null,E.closestPointRangePx>=et.enabledThreshold*et.radius),st,lt,ht,ut,dt,ft,pt;if(et.enabled!==!1||E._hasPointMarkers)for(st=0;st<a.length;st++){lt=a[st],ht=lt.graphic,ut=ht?"animate":"attr",dt=lt.marker||{},ft=!!lt.marker;var gt=(ot&&typeof dt.enabled>"u"||dt.enabled)&&!lt.isNull&&lt.visible!==!1;if(gt){var yt=pick$1f(dt.symbol,E.symbol,"rect");pt=E.markerAttribs(lt,lt.selected&&"select"),E.enabledDataSorting&&(lt.startXPos=nt.reversed?-(pt.width||0):nt.width);var mt=lt.isInside!==!1;ht?ht[mt?"show":"hide"](mt).animate(pt):mt&&((pt.width||0)>0||lt.hasImage)&&(lt.graphic=ht=k.renderer.symbol(yt,pt.x,pt.y,pt.width,pt.height,ft?dt:et).add(rt),E.enabledDataSorting&&k.hasRendered&&(ht.attr({x:lt.startXPos}),ut="animate")),ht&&ut==="animate"&&ht[mt?"show":"hide"](mt).animate(pt),ht&&!k.styledMode&&ht[ut](E.pointAttribs(lt,lt.selected&&"select")),ht&&ht.addClass(lt.getClassName(),!0)}else ht&&(lt.graphic=ht.destroy())}},j.prototype.markerAttribs=function(E,a){var k=this.options,tt=k.marker,et=E.marker||{},rt=et.symbol||tt.symbol,nt,ot,st=pick$1f(et.radius,tt.radius);a&&(nt=tt.states[a],ot=et.states&&et.states[a],st=pick$1f(ot&&ot.radius,nt&&nt.radius,st+(nt&&nt.radiusPlus||0))),E.hasImage=rt&&rt.indexOf("url")===0,E.hasImage&&(st=0);var lt={x:k.crisp?Math.floor(E.plotX-st):E.plotX-st,y:E.plotY-st};return st&&(lt.width=lt.height=2*st),lt},j.prototype.pointAttribs=function(E,a){var k=this.options.marker,tt=E&&E.options,et=tt&&tt.marker||{},rt=tt&&tt.color,nt=E&&E.color,ot=E&&E.zone&&E.zone.color,st,lt,ht=this.color,ut,dt,ft=pick$1f(et.lineWidth,k.lineWidth),pt=1;return ht=rt||ot||nt||ht,ut=et.fillColor||k.fillColor||ht,dt=et.lineColor||k.lineColor||ht,a=a||"normal",a&&(st=k.states[a],lt=et.states&&et.states[a]||{},ft=pick$1f(lt.lineWidth,st.lineWidth,ft+pick$1f(lt.lineWidthPlus,st.lineWidthPlus,0)),ut=lt.fillColor||st.fillColor||ut,dt=lt.lineColor||st.lineColor||dt,pt=pick$1f(lt.opacity,st.opacity,pt)),{stroke:dt,"stroke-width":ft,fill:ut,opacity:pt}},j.prototype.destroy=function(E){var a=this,k=a.chart,tt=/AppleWebKit\/533/.test(win$7.navigator.userAgent),et=a.data||[],rt,nt,ot,st;for(fireEvent$r(a,"destroy"),this.removeEvents(E),(a.axisTypes||[]).forEach(function(lt){st=a[lt],st&&st.series&&(erase$2(st.series,a),st.isDirty=st.forceRedraw=!0)}),a.legendItem&&a.chart.legend.destroyItem(a),nt=et.length;nt--;)ot=et[nt],ot&&ot.destroy&&ot.destroy();a.clips&&a.clips.forEach(function(lt){return lt.destroy()}),Utilities.clearTimeout(a.animationTimeout),objectEach$m(a,function(lt,ht){lt instanceof SVGElement&&!lt.survive&&(rt=tt&&ht==="group"?"hide":"destroy",lt[rt]())}),k.hoverSeries===a&&(k.hoverSeries=void 0),erase$2(k.series,a),k.orderSeries(),objectEach$m(a,function(lt,ht){(!E||ht!=="hcEvents")&&delete a[ht]})},j.prototype.applyZones=function(){var E=this,a=this.chart,k=a.renderer,tt=this.zones,et=this.clips||[],rt=this.graph,nt=this.area,ot=Math.max(a.chartWidth,a.chartHeight),st=this[(this.zoneAxis||"y")+"Axis"],lt=a.inverted,ht,ut,dt,ft,pt,gt,yt,mt,xt,wt,Mt,At=!1;tt.length&&(rt||nt)&&st&&typeof st.min<"u"?(pt=st.reversed,gt=st.horiz,rt&&!this.showLine&&rt.hide(),nt&&nt.hide(),ft=st.getExtremes(),tt.forEach(function(St,$t){ht=pt?gt?a.plotWidth:0:gt?0:st.toPixels(ft.min)||0,ht=clamp$f(pick$1f(ut,ht),0,ot),ut=clamp$f(Math.round(st.toPixels(pick$1f(St.value,ft.max),!0)||0),0,ot),At&&(ht=ut=st.toPixels(ft.max)),yt=Math.abs(ht-ut),mt=Math.min(ht,ut),xt=Math.max(ht,ut),st.isXAxis?(dt={x:lt?xt:mt,y:0,width:yt,height:ot},gt||(dt.x=a.plotHeight-dt.x)):(dt={x:0,y:lt?xt:mt,width:ot,height:yt},gt&&(dt.y=a.plotWidth-dt.y)),lt&&k.isVML&&(st.isXAxis?dt={x:0,y:pt?mt:xt,height:dt.width,width:a.chartWidth}:dt={x:dt.y-a.plotLeft-a.spacingBox.x,y:0,width:dt.height,height:a.chartHeight}),et[$t]?et[$t].animate(dt):et[$t]=k.clipRect(dt),wt=E["zone-area-"+$t],Mt=E["zone-graph-"+$t],rt&&Mt&&Mt.clip(et[$t]),nt&&wt&&wt.clip(et[$t]),At=St.value>ft.max,E.resetZones&&ut===0&&(ut=void 0)}),this.clips=et):E.visible&&(rt&&rt.show(!0),nt&&nt.show(!0))},j.prototype.invertGroups=function(E){var a=this,k=a.chart;function tt(){["group","markerGroup"].forEach(function(et){a[et]&&(k.renderer.isVML&&a[et].attr({width:a.yAxis.len,height:a.xAxis.len}),a[et].width=a.yAxis.len,a[et].height=a.xAxis.len,a[et].invert(a.isRadialSeries?!1:E))})}a.xAxis&&(a.eventsToUnbind.push(addEvent$S(k,"resize",tt)),tt(),a.invertGroups=tt)},j.prototype.plotGroup=function(E,a,k,tt,et){var rt=this[E],nt=!rt,ot={visibility:k,zIndex:tt||.1};return typeof this.opacity<"u"&&!this.chart.styledMode&&this.state!=="inactive"&&(ot.opacity=this.opacity),nt&&(this[E]=rt=this.chart.renderer.g().add(et)),rt.addClass("highcharts-"+a+" highcharts-series-"+this.index+" highcharts-"+this.type+"-series "+(defined$G(this.colorIndex)?"highcharts-color-"+this.colorIndex+" ":"")+(this.options.className||"")+(rt.hasClass("highcharts-tracker")?" highcharts-tracker":""),!0),rt.attr(ot)[nt?"attr":"animate"](this.getPlotBox()),rt},j.prototype.getPlotBox=function(){var E=this.chart,a=this.xAxis,k=this.yAxis;return E.inverted&&(a=k,k=this.xAxis),{translateX:a?a.left:E.plotLeft,translateY:k?k.top:E.plotTop,scaleX:1,scaleY:1}},j.prototype.removeEvents=function(E){var a=this;E||removeEvent$5(a),a.eventsToUnbind.length&&(a.eventsToUnbind.forEach(function(k){k()}),a.eventsToUnbind.length=0)},j.prototype.render=function(){var E=this,a=E.chart,k=E.options,tt=animObject$6(k.animation),et=E.visible?"inherit":"hidden",rt=k.zIndex,nt=E.hasRendered,ot=a.seriesGroup,st=a.inverted,lt=!E.finishedAnimating&&a.renderer.isSVG&&tt.duration;fireEvent$r(this,"render");var ht=E.plotGroup("group","series",et,rt,ot);E.markerGroup=E.plotGroup("markerGroup","markers",et,rt,ot),lt&&E.animate&&E.animate(!0),ht.inverted=pick$1f(E.invertible,E.isCartesian)?st:!1,E.drawGraph&&(E.drawGraph(),E.applyZones()),E.visible&&E.drawPoints(),E.drawDataLabels&&E.drawDataLabels(),E.redrawPoints&&E.redrawPoints(),E.drawTracker&&E.options.enableMouseTracking!==!1&&E.drawTracker(),E.invertGroups(st),k.clip!==!1&&!E.sharedClipKey&&!nt&&ht.clip(a.clipRect),lt&&E.animate&&E.animate(),nt||(lt&&tt.defer&&(lt+=tt.defer),E.animationTimeout=syncTimeout$2(function(){E.afterAnimate()},lt||0)),E.isDirty=!1,E.hasRendered=!0,fireEvent$r(E,"afterRender")},j.prototype.redraw=function(){var E=this,a=E.chart,k=E.isDirty||E.isDirtyData,tt=E.group,et=E.xAxis,rt=E.yAxis;tt&&(a.inverted&&tt.attr({width:a.plotWidth,height:a.plotHeight}),tt.animate({translateX:pick$1f(et&&et.left,a.plotLeft),translateY:pick$1f(rt&&rt.top,a.plotTop)})),E.translate(),E.render(),k&&delete this.kdTree},j.prototype.searchPoint=function(E,a){var k=this,tt=k.xAxis,et=k.yAxis,rt=k.chart.inverted;return this.searchKDTree({clientX:rt?tt.len-E.chartY+tt.pos:E.chartX-tt.pos,plotY:rt?et.len-E.chartX+et.pos:E.chartY-et.pos},a,E)},j.prototype.buildKDTree=function(E){this.buildingKdTree=!0;var a=this,k=a.options.findNearestPointBy.indexOf("y")>-1?2:1;function tt(rt,nt,ot){var st=rt&&rt.length,lt,ht;if(st)return lt=a.kdAxisArray[nt%ot],rt.sort(function(ut,dt){return ut[lt]-dt[lt]}),ht=Math.floor(st/2),{point:rt[ht],left:tt(rt.slice(0,ht),nt+1,ot),right:tt(rt.slice(ht+1),nt+1,ot)}}function et(){a.kdTree=tt(a.getValidPoints(null,!a.directTouch),k,k),a.buildingKdTree=!1}delete a.kdTree,syncTimeout$2(et,a.options.kdNow||E&&E.type==="touchstart"?0:1)},j.prototype.searchKDTree=function(E,a,k){var tt=this,et=this.kdAxisArray[0],rt=this.kdAxisArray[1],nt=a?"distX":"dist",ot=tt.options.findNearestPointBy.indexOf("y")>-1?2:1;function st(ht,ut){var dt=defined$G(ht[et])&&defined$G(ut[et])?Math.pow(ht[et]-ut[et],2):null,ft=defined$G(ht[rt])&&defined$G(ut[rt])?Math.pow(ht[rt]-ut[rt],2):null,pt=(dt||0)+(ft||0);ut.dist=defined$G(pt)?Math.sqrt(pt):Number.MAX_VALUE,ut.distX=defined$G(dt)?Math.sqrt(dt):Number.MAX_VALUE}function lt(ht,ut,dt,ft){var pt=ut.point,gt=tt.kdAxisArray[dt%ft],yt,mt,xt=pt;st(ht,pt);var wt=ht[gt]-pt[gt],Mt=wt<0?"left":"right",At=wt<0?"right":"left";return ut[Mt]&&(yt=lt(ht,ut[Mt],dt+1,ft),xt=yt[nt]<xt[nt]?yt:pt),ut[At]&&Math.sqrt(wt*wt)<xt[nt]&&(mt=lt(ht,ut[At],dt+1,ft),xt=mt[nt]<xt[nt]?mt:xt),xt}if(!this.kdTree&&!this.buildingKdTree&&this.buildKDTree(k),this.kdTree)return lt(E,this.kdTree,ot,ot)},j.prototype.pointPlacementToXValue=function(){var E=this,a=E.options,k=a.pointPlacement,tt=a.pointRange,et=E.xAxis,rt=k;return rt==="between"&&(rt=et.reversed?-.5:.5),isNumber$A(rt)?rt*(tt||et.pointRange):0},j.prototype.isPointInside=function(E){var a=typeof E.plotY<"u"&&typeof E.plotX<"u"&&E.plotY>=0&&E.plotY<=this.yAxis.len&&E.plotX>=0&&E.plotX<=this.xAxis.len;return a},j.prototype.drawTracker=function(){var E=this,a=E.options,k=a.trackByArea,tt=[].concat(k?E.areaPath:E.graphPath),et=E.chart,rt=et.pointer,nt=et.renderer,ot=et.options.tooltip.snap,st=E.tracker,lt=function(ut){et.hoverSeries!==E&&E.onMouseOver()},ht="rgba(192,192,192,"+(svg$2?1e-4:.002)+")";st?st.attr({d:tt}):E.graph&&(E.tracker=nt.path(tt).attr({visibility:E.visible?"visible":"hidden",zIndex:2}).addClass(k?"highcharts-tracker-area":"highcharts-tracker-line").add(E.group),et.styledMode||E.tracker.attr({"stroke-linecap":"round","stroke-linejoin":"round",stroke:ht,fill:k?ht:"none","stroke-width":E.graph.strokeWidth()+(k?0:2*ot)}),[E.tracker,E.markerGroup,E.dataLabelsGroup].forEach(function(ut){ut&&(ut.addClass("highcharts-tracker").on("mouseover",lt).on("mouseout",function(dt){rt.onTrackerMouseOut(dt)}),a.cursor&&!et.styledMode&&ut.css({cursor:a.cursor}),hasTouch$2&&ut.on("touchstart",lt))})),fireEvent$r(this,"afterDrawTracker")},j.prototype.addPoint=function(E,a,k,tt,et){var rt=this,nt=rt.options,ot=rt.data,st=rt.chart,lt=rt.xAxis,ht=lt&&lt.hasNames&&lt.names,ut=nt.data,dt=rt.xData,ft,pt;a=pick$1f(a,!0);var gt={series:rt};rt.pointClass.prototype.applyOptions.apply(gt,[E]);var yt=gt.x;if(pt=dt.length,rt.requireSorting&&yt<dt[pt-1])for(ft=!0;pt&&dt[pt-1]>yt;)pt--;rt.updateParallelArrays(gt,"splice",pt,0,0),rt.updateParallelArrays(gt,pt),ht&&gt.name&&(ht[yt]=gt.name),ut.splice(pt,0,E),ft&&(rt.data.splice(pt,0,null),rt.processData()),nt.legendType==="point"&&rt.generatePoints(),k&&(ot[0]&&ot[0].remove?ot[0].remove(!1):(ot.shift(),rt.updateParallelArrays(gt,"shift"),ut.shift())),et!==!1&&fireEvent$r(rt,"addPoint",{point:gt}),rt.isDirty=!0,rt.isDirtyData=!0,a&&st.redraw(tt)},j.prototype.removePoint=function(E,a,k){var tt=this,et=tt.data,rt=et[E],nt=tt.points,ot=tt.chart,st=function(){nt&&nt.length===et.length&&nt.splice(E,1),et.splice(E,1),tt.options.data.splice(E,1),tt.updateParallelArrays(rt||{series:tt},"splice",E,1),rt&&rt.destroy(),tt.isDirty=!0,tt.isDirtyData=!0,a&&ot.redraw()};setAnimation$2(k,ot),a=pick$1f(a,!0),rt?rt.firePointEvent("remove",null,st):st()},j.prototype.remove=function(E,a,k,tt){var et=this,rt=et.chart;function nt(){et.destroy(tt),rt.isDirtyLegend=rt.isDirtyBox=!0,rt.linkSeries(),pick$1f(E,!0)&&rt.redraw(a)}k!==!1?fireEvent$r(et,"remove",null,nt):nt()},j.prototype.update=function(E,a){E=cleanRecursively(E,this.userOptions),fireEvent$r(this,"update",{options:E});var k=this,tt=k.chart,et=k.userOptions,rt=k.initialType||k.type,nt=tt.options.plotOptions,ot=seriesTypes$6[rt].prototype,st=["group","markerGroup","dataLabelsGroup","transformGroup"],lt=k.finishedAnimating&&{animation:!1},ht={},ut,dt,ft=["eventOptions","navigatorSeries","baseSeries"],pt=E.type||et.type||tt.options.chart.type,gt=!(this.hasDerivedData||pt&&pt!==this.type||typeof E.pointStart<"u"||typeof E.pointInterval<"u"||typeof E.relativeXValue<"u"||k.hasOptionChanged("dataGrouping")||k.hasOptionChanged("pointStart")||k.hasOptionChanged("pointInterval")||k.hasOptionChanged("pointIntervalUnit")||k.hasOptionChanged("keys"));pt=pt||rt,gt&&(ft.push("data","isDirtyData","points","processedXData","processedYData","xIncrement","cropped","_hasPointMarkers","_hasPointLabels","clips","nodes","layout","mapMap","mapData","minY","maxY","minX","maxX"),E.visible!==!1&&ft.push("area","graph"),k.parallelArrays.forEach(function(Mt){ft.push(Mt+"Data")}),E.data&&(E.dataSorting&&extend$1g(k.options.dataSorting,E.dataSorting),this.setData(E.data,!1))),E=merge$18(et,lt,{index:typeof et.index>"u"?k.index:et.index,pointStart:pick$1f(nt&&nt.series&&nt.series.pointStart,et.pointStart,k.xData[0])},!gt&&{data:k.options.data},E),gt&&E.data&&(E.data=k.options.data),ft=st.concat(ft),ft.forEach(function(Mt){ft[Mt]=k[Mt],delete k[Mt]});var yt=!1;if(seriesTypes$6[pt]){if(yt=pt!==k.type,k.remove(!1,!1,!1,!0),yt)if(Object.setPrototypeOf)Object.setPrototypeOf(k,seriesTypes$6[pt].prototype);else{var mt=Object.hasOwnProperty.call(k,"hcEvents")&&k.hcEvents;for(dt in ot)k[dt]=void 0;extend$1g(k,seriesTypes$6[pt].prototype),mt?k.hcEvents=mt:delete k.hcEvents}}else error$4(17,!0,tt,{missingModuleFor:pt});if(ft.forEach(function(Mt){k[Mt]=ft[Mt]}),k.init(tt,E),gt&&this.points){if(ut=k.options,ut.visible===!1)ht.graphic=1,ht.dataLabel=1;else if(!k._hasPointLabels){var xt=ut.marker,wt=ut.dataLabels;xt&&(xt.enabled===!1||(et.marker&&et.marker.symbol)!==xt.symbol)&&(ht.graphic=1),wt&&wt.enabled===!1&&(ht.dataLabel=1)}this.points.forEach(function(Mt){Mt&&Mt.series&&(Mt.resolveColor(),Object.keys(ht).length&&Mt.destroyElements(ht),ut.showInLegend===!1&&Mt.legendItem&&tt.legend.destroyItem(Mt))},this)}k.initialType=rt,tt.linkSeries(),yt&&k.linkedSeries.length&&(k.isDirtyData=!0),fireEvent$r(this,"afterUpdate"),pick$1f(a,!0)&&tt.redraw(gt?void 0:!1)},j.prototype.setName=function(E){this.name=this.options.name=this.userOptions.name=E,this.chart.isDirtyLegend=!0},j.prototype.hasOptionChanged=function(E){var a=this.chart,k=this.options[E],tt=a.options.plotOptions,et=this.userOptions[E];return et?k!==et:k!==pick$1f(tt&&tt[this.type]&&tt[this.type][E],tt&&tt.series&&tt.series[E],k)},j.prototype.onMouseOver=function(){var E=this,a=E.chart,k=a.hoverSeries,tt=a.pointer;tt.setHoverChartIndex(),k&&k!==E&&k.onMouseOut(),E.options.events.mouseOver&&fireEvent$r(E,"mouseOver"),E.setState("hover"),a.hoverSeries=E},j.prototype.onMouseOut=function(){var E=this,a=E.options,k=E.chart,tt=k.tooltip,et=k.hoverPoint;k.hoverSeries=null,et&&et.onMouseOut(),E&&a.events.mouseOut&&fireEvent$r(E,"mouseOut"),tt&&!E.stickyTracking&&(!tt.shared||E.noSharedTooltip)&&tt.hide(),k.series.forEach(function(rt){rt.setState("",!0)})},j.prototype.setState=function(E,a){var k=this,tt=k.options,et=k.graph,rt=tt.inactiveOtherPoints,nt=tt.states,ot=pick$1f(nt[E||"normal"]&&nt[E||"normal"].animation,k.chart.options.chart.animation),st,lt=tt.lineWidth,ht=0,ut=tt.opacity;if(E=E||"",k.state!==E&&([k.group,k.markerGroup,k.dataLabelsGroup].forEach(function(dt){dt&&(k.state&&dt.removeClass("highcharts-series-"+k.state),E&&dt.addClass("highcharts-series-"+E))}),k.state=E,!k.chart.styledMode)){if(nt[E]&&nt[E].enabled===!1)return;if(E&&(lt=nt[E].lineWidth||lt+(nt[E].lineWidthPlus||0),ut=pick$1f(nt[E].opacity,ut)),et&&!et.dashstyle)for(st={"stroke-width":lt},et.animate(st,ot);k["zone-graph-"+ht];)k["zone-graph-"+ht].animate(st,ot),ht=ht+1;rt||[k.group,k.markerGroup,k.dataLabelsGroup,k.labelBySeries].forEach(function(dt){dt&&dt.animate({opacity:ut},ot)})}a&&rt&&k.points&&k.setAllPointsToState(E||void 0)},j.prototype.setAllPointsToState=function(E){this.points.forEach(function(a){a.setState&&a.setState(E)})},j.prototype.setVisible=function(E,a){var k=this,tt=k.chart,et=k.legendItem,rt=tt.options.chart.ignoreHiddenSeries,nt=k.visible;k.visible=E=k.options.visible=k.userOptions.visible=typeof E>"u"?!nt:E;var ot=E?"show":"hide";["group","dataLabelsGroup","markerGroup","tracker","tt"].forEach(function(st){k[st]&&k[st][ot]()}),(tt.hoverSeries===k||(tt.hoverPoint&&tt.hoverPoint.series)===k)&&k.onMouseOut(),et&&tt.legend.colorizeItem(k,E),k.isDirty=!0,k.options.stacking&&tt.series.forEach(function(st){st.options.stacking&&st.visible&&(st.isDirty=!0)}),k.linkedSeries.forEach(function(st){st.setVisible(E,!1)}),rt&&(tt.isDirtyBox=!0),fireEvent$r(k,ot),a!==!1&&tt.redraw()},j.prototype.show=function(){this.setVisible(!0)},j.prototype.hide=function(){this.setVisible(!1)},j.prototype.select=function(E){var a=this;a.selected=E=this.options.selected=typeof E>"u"?!a.selected:E,a.checkbox&&(a.checkbox.checked=E),fireEvent$r(a,E?"select":"unselect")},j.prototype.shouldShowTooltip=function(E,a,k){return k===void 0&&(k={}),k.series=this,k.visiblePlotOnly=!0,this.chart.isInsidePlot(E,a,k)},j.defaultOptions=seriesDefaults,j}();extend$1g(Series$e.prototype,{axisTypes:["xAxis","yAxis"],coll:"series",colorCounter:0,cropShoulder:1,directTouch:!1,drawLegendSymbol:LegendSymbol$1.drawLineMarker,isCartesian:!0,kdAxisArray:["clientX","plotY"],parallelArrays:["x","y"],pointClass:Point$5,requireSorting:!0,sorted:!0});SeriesRegistry$1.series=Series$e;var stop=animationExports.stop,addEvent$R=Utilities.addEvent,createElement$4=Utilities.createElement,merge$17=Utilities.merge,pick$1e=Utilities.pick;addEvent$R(Chart$1,"afterSetChartSize",function(j){var E=this.options.chart.scrollablePlotArea,a=E&&E.minWidth,k=E&&E.minHeight,tt,et,rt;this.renderer.forExport||(a?(this.scrollablePixelsX=tt=Math.max(0,a-this.chartWidth),tt&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.width=this.plotWidth+=tt,this.inverted?this.clipBox.height+=tt:this.clipBox.width+=tt,rt={1:{name:"right",value:tt}})):k&&(this.scrollablePixelsY=et=Math.max(0,k-this.chartHeight),et&&(this.scrollablePlotBox=this.renderer.scrollablePlotBox=merge$17(this.plotBox),this.plotBox.height=this.plotHeight+=et,this.inverted?this.clipBox.width+=et:this.clipBox.height+=et,rt={2:{name:"bottom",value:et}})),rt&&!j.skipAxes&&this.axes.forEach(function(nt){rt[nt.side]?nt.getPlotLinePath=function(){var ot=rt[nt.side].name,st=rt[nt.side].value,lt=this[ot],ht;return this[ot]=lt-st,ht=Axis.prototype.getPlotLinePath.apply(this,arguments),this[ot]=lt,ht}:(nt.setAxisSize(),nt.setAxisTranslation())}))});addEvent$R(Chart$1,"render",function(){this.scrollablePixelsX||this.scrollablePixelsY?(this.setUpScrolling&&this.setUpScrolling(),this.applyFixed()):this.fixedDiv&&this.applyFixed()});Chart$1.prototype.setUpScrolling=function(){var j=this,E={WebkitOverflowScrolling:"touch",overflowX:"hidden",overflowY:"hidden"};this.scrollablePixelsX&&(E.overflowX="auto"),this.scrollablePixelsY&&(E.overflowY="auto"),this.scrollingParent=createElement$4("div",{className:"highcharts-scrolling-parent"},{position:"relative"},this.renderTo),this.scrollingContainer=createElement$4("div",{className:"highcharts-scrolling"},E,this.scrollingParent),addEvent$R(this.scrollingContainer,"scroll",function(){j.pointer&&delete j.pointer.chartPosition}),this.innerContainer=createElement$4("div",{className:"highcharts-inner-container"},null,this.scrollingContainer),this.innerContainer.appendChild(this.container),this.setUpScrolling=null};Chart$1.prototype.moveFixedElements=function(){var j=this.container,E=this.fixedRenderer,a=[".highcharts-contextbutton",".highcharts-credits",".highcharts-legend",".highcharts-legend-checkbox",".highcharts-navigator-series",".highcharts-navigator-xaxis",".highcharts-navigator-yaxis",".highcharts-navigator",".highcharts-reset-zoom",".highcharts-drillup-button",".highcharts-scrollbar",".highcharts-subtitle",".highcharts-title"],k;this.scrollablePixelsX&&!this.inverted?k=".highcharts-yaxis":this.scrollablePixelsX&&this.inverted||this.scrollablePixelsY&&!this.inverted?k=".highcharts-xaxis":this.scrollablePixelsY&&this.inverted&&(k=".highcharts-yaxis"),k&&a.push(k+":not(.highcharts-radial-axis)",k+"-labels:not(.highcharts-radial-axis-labels)"),a.forEach(function(tt){[].forEach.call(j.querySelectorAll(tt),function(et){(et.namespaceURI===E.SVG_NS?E.box:E.box.parentNode).appendChild(et),et.style.pointerEvents="auto"})})};Chart$1.prototype.applyFixed=function(){var j=!this.fixedDiv,E=this.options.chart,a=E.scrollablePlotArea,k=RendererRegistry$1.getRendererType(),tt,et,rt;j?(this.fixedDiv=createElement$4("div",{className:"highcharts-fixed"},{position:"absolute",overflow:"hidden",pointerEvents:"none",zIndex:(E.style&&E.style.zIndex||0)+2,top:0},null,!0),this.scrollingContainer&&this.scrollingContainer.parentNode.insertBefore(this.fixedDiv,this.scrollingContainer),this.renderTo.style.overflow="visible",this.fixedRenderer=tt=new k(this.fixedDiv,this.chartWidth,this.chartHeight,this.options.chart.style),this.scrollableMask=tt.path().attr({fill:this.options.chart.backgroundColor||"#fff","fill-opacity":pick$1e(a.opacity,.85),zIndex:-1}).addClass("highcharts-scrollable-mask").add(),addEvent$R(this,"afterShowResetZoom",this.moveFixedElements),addEvent$R(this,"afterDrilldown",this.moveFixedElements),addEvent$R(this,"afterLayOutTitles",this.moveFixedElements)):this.fixedRenderer.setSize(this.chartWidth,this.chartHeight),(this.scrollableDirty||j)&&(this.scrollableDirty=!1,this.moveFixedElements()),et=this.chartWidth+(this.scrollablePixelsX||0),rt=this.chartHeight+(this.scrollablePixelsY||0),stop(this.container),this.container.style.width=et+"px",this.container.style.height=rt+"px",this.renderer.boxWrapper.attr({width:et,height:rt,viewBox:[0,0,et,rt].join(" ")}),this.chartBackground.attr({width:et,height:rt}),this.scrollingContainer.style.height=this.chartHeight+"px",j&&(a.scrollPositionX&&(this.scrollingContainer.scrollLeft=this.scrollablePixelsX*a.scrollPositionX),a.scrollPositionY&&(this.scrollingContainer.scrollTop=this.scrollablePixelsY*a.scrollPositionY));var nt=this.axisOffset,ot=this.plotTop-nt[0]-1,st=this.plotLeft-nt[3]-1,lt=this.plotTop+this.plotHeight+nt[2]+1,ht=this.plotLeft+this.plotWidth+nt[1]+1,ut=this.plotLeft+this.plotWidth-(this.scrollablePixelsX||0),dt=this.plotTop+this.plotHeight-(this.scrollablePixelsY||0),ft;this.scrollablePixelsX?ft=[["M",0,ot],["L",this.plotLeft-1,ot],["L",this.plotLeft-1,lt],["L",0,lt],["Z"],["M",ut,ot],["L",this.chartWidth,ot],["L",this.chartWidth,lt],["L",ut,lt],["Z"]]:this.scrollablePixelsY?ft=[["M",st,0],["L",st,this.plotTop-1],["L",ht,this.plotTop-1],["L",ht,0],["Z"],["M",st,dt],["L",st,this.chartHeight],["L",ht,this.chartHeight],["L",ht,dt],["Z"]]:ft=[["M",0,0]],this.redrawTrigger!=="adjustHeight"&&this.scrollableMask.attr({d:ft})};addEvent$R(Axis,"afterInit",function(){this.chart.scrollableDirty=!0});addEvent$R(Series$e,"show",function(){this.chart.scrollableDirty=!0});var getDeferredAnimation$2=animationExports.getDeferredAnimation,addEvent$Q=Utilities.addEvent,destroyObjectProperties$5=Utilities.destroyObjectProperties,fireEvent$q=Utilities.fireEvent,isNumber$z=Utilities.isNumber,objectEach$l=Utilities.objectEach,StackingAxis;(function(j){var E=[];function a(rt){return E.indexOf(rt)===-1&&(E.push(rt),addEvent$Q(rt,"init",tt),addEvent$Q(rt,"destroy",k)),rt}j.compose=a;function k(){var rt=this.stacking;if(rt){var nt=rt.stacks;objectEach$l(nt,function(ot,st){destroyObjectProperties$5(ot),nt[st]=null}),rt&&rt.stackTotalGroup&&rt.stackTotalGroup.destroy()}}function tt(){var rt=this;rt.stacking||(rt.stacking=new et(rt))}var et=function(){function rt(nt){this.oldStacks={},this.stacks={},this.stacksTouched=0,this.axis=nt}return rt.prototype.buildStacks=function(){var nt=this,ot=nt.axis,st=ot.series,lt=ot.options.reversedStacks,ht=st.length,ut,dt;if(!ot.isXAxis){for(nt.usePercentage=!1,dt=ht;dt--;)ut=st[lt?dt:ht-dt-1],ut.setStackedPoints(),ut.setGroupedPoints();for(dt=0;dt<ht;dt++)st[dt].modifyStacks();fireEvent$q(ot,"afterBuildStacks")}},rt.prototype.cleanStacks=function(){var nt=this,ot=nt.axis,st;ot.isXAxis||(nt.oldStacks&&(st=nt.stacks=nt.oldStacks),objectEach$l(st,function(lt){objectEach$l(lt,function(ht){ht.cumulative=ht.total})}))},rt.prototype.resetStacks=function(){var nt=this,ot=nt.axis,st=nt.stacks;ot.isXAxis||objectEach$l(st,function(lt){objectEach$l(lt,function(ht,ut){isNumber$z(ht.touched)&&ht.touched<nt.stacksTouched?(ht.destroy(),delete lt[ut]):(ht.total=null,ht.cumulative=null)})})},rt.prototype.renderStackTotals=function(){var nt=this,ot=nt.axis,st=ot.chart,lt=st.renderer,ht=nt.stacks,ut=ot.options.stackLabels&&ot.options.stackLabels.animation,dt=getDeferredAnimation$2(st,ut||!1),ft=nt.stackTotalGroup=nt.stackTotalGroup||lt.g("stack-labels").attr({visibility:"visible",zIndex:6,opacity:0}).add();ft.translate(st.plotLeft,st.plotTop),objectEach$l(ht,function(pt){objectEach$l(pt,function(gt){gt.render(ft)})}),ft.animate({opacity:1},dt)},rt}();j.Additions=et})(StackingAxis||(StackingAxis={}));const StackingAxis$1=StackingAxis;var format$a=FormatUtilities.format,correctFloat$9=Utilities.correctFloat,defined$F=Utilities.defined,destroyObjectProperties$4=Utilities.destroyObjectProperties,isArray$e=Utilities.isArray,isNumber$y=Utilities.isNumber,objectEach$k=Utilities.objectEach,pick$1d=Utilities.pick,StackItem=function(){function j(E,a,k,tt,et){var rt=E.chart.inverted;this.axis=E,this.isNegative=k,this.options=a=a||{},this.x=tt,this.total=null,this.points={},this.hasValidPoints=!1,this.stack=et,this.leftCliff=0,this.rightCliff=0,this.alignOptions={align:a.align||(rt?k?"left":"right":"center"),verticalAlign:a.verticalAlign||(rt?"middle":k?"bottom":"top"),y:a.y,x:a.x},this.textAlign=a.textAlign||(rt?k?"right":"left":"center")}return j.prototype.destroy=function(){destroyObjectProperties$4(this,this.axis)},j.prototype.render=function(E){var a=this.axis.chart,k=this.options,tt=k.format,et={},rt=tt?format$a(tt,this,a):k.formatter.call(this);this.label?this.label.attr({text:rt,visibility:"hidden"}):(this.label=a.renderer.label(rt,null,null,k.shape,null,null,k.useHTML,!1,"stack-labels"),et={r:k.borderRadius||0,text:rt,rotation:k.rotation,padding:pick$1d(k.padding,5),visibility:"hidden"},a.styledMode||(et.fill=k.backgroundColor,et.stroke=k.borderColor,et["stroke-width"]=k.borderWidth,this.label.css(k.style)),this.label.attr(et),this.label.added||this.label.add(E)),this.label.labelrank=a.plotSizeY},j.prototype.setOffset=function(E,a,k,tt,et){var rt=this,nt=rt.axis,ot=nt.chart,st=nt.translate(nt.stacking.usePercentage?100:tt||rt.total,0,0,0,1),lt=nt.translate(k||0),ht=defined$F(st)&&Math.abs(st-lt),ut=pick$1d(et,ot.xAxis[0].translate(rt.x))+E,dt=defined$F(st)&&rt.getStackBox(ot,rt,ut,st,a,ht,nt),ft=rt.label,pt=rt.isNegative,gt=pick$1d(rt.options.overflow,"justify")==="justify",yt=rt.textAlign,mt;if(ft&&dt){var xt=ft.getBBox(),wt=ft.padding,Mt=void 0,At=void 0;yt==="left"?Mt=ot.inverted?-wt:wt:yt==="right"?Mt=xt.width:ot.inverted&&yt==="center"?Mt=xt.width/2:Mt=ot.inverted?pt?xt.width+wt:-wt:xt.width/2,At=ot.inverted?xt.height/2:pt?-wt:xt.height,rt.alignOptions.x=pick$1d(rt.options.x,0),rt.alignOptions.y=pick$1d(rt.options.y,0),dt.x-=Mt,dt.y-=At,ft.align(rt.alignOptions,null,dt),ot.isInsidePlot(ft.alignAttr.x+Mt-rt.alignOptions.x,ft.alignAttr.y+At-rt.alignOptions.y)?ft.show():(ft.alignAttr.y=-9999,gt=!1),gt&&Series$e.prototype.justifyDataLabel.call(this.axis,ft,rt.alignOptions,ft.alignAttr,xt,dt),ft.attr({x:ft.alignAttr.x,y:ft.alignAttr.y}),pick$1d(!gt&&rt.options.crop,!0)&&(mt=isNumber$y(ft.x)&&isNumber$y(ft.y)&&ot.isInsidePlot(ft.x-wt+ft.width,ft.y)&&ot.isInsidePlot(ft.x+wt,ft.y),mt||ft.hide())}},j.prototype.getStackBox=function(E,a,k,tt,et,rt,nt){var ot=a.axis.reversed,st=E.inverted,lt=nt.height+nt.pos-(st?E.plotLeft:E.plotTop),ht=a.isNegative&&!ot||!a.isNegative&&ot;return{x:st?ht?tt-nt.right:tt-rt+nt.pos-E.plotLeft:k+E.xAxis[0].transB-E.plotLeft,y:st?nt.height-k-et:ht?lt-tt-rt:lt-tt,width:st?rt:et,height:st?et:rt}},j}();Chart$1.prototype.getStacks=function(){var j=this,E=j.inverted;j.yAxis.forEach(function(a){a.stacking&&a.stacking.stacks&&a.hasVisibleSeries&&(a.stacking.oldStacks=a.stacking.stacks)}),j.series.forEach(function(a){var k=a.xAxis&&a.xAxis.options||{};a.options.stacking&&(a.visible===!0||j.options.chart.ignoreHiddenSeries===!1)&&(a.stackKey=[a.type,pick$1d(a.options.stack,""),E?k.top:k.left,E?k.height:k.width].join(","))})};StackingAxis$1.compose(Axis);Series$e.prototype.setGroupedPoints=function(){var j=this.yAxis.stacking;this.options.centerInCategory&&(this.is("column")||this.is("columnrange"))&&!this.options.stacking&&this.chart.series.length>1?Series$e.prototype.setStackedPoints.call(this,"group"):j&&objectEach$k(j.stacks,function(E,a){a.slice(-5)==="group"&&(objectEach$k(E,function(k){return k.destroy()}),delete j.stacks[a])})};Series$e.prototype.setStackedPoints=function(j){var E=j||this.options.stacking;if(!(!E||this.visible!==!0&&this.chart.options.chart.ignoreHiddenSeries!==!1)){var a=this,k=a.processedXData,tt=a.processedYData,et=[],rt=tt.length,nt=a.options,ot=nt.threshold,st=pick$1d(nt.startFromThreshold&&ot,0),lt=nt.stack,ht=j?a.type+","+E:a.stackKey,ut="-"+ht,dt=a.negStacks,ft=a.yAxis,pt=ft.stacking.stacks,gt=ft.stacking.oldStacks,yt,mt,xt,wt,Mt,At,St,$t,Tt;for(ft.stacking.stacksTouched+=1,St=0;St<rt;St++)$t=k[St],Tt=tt[St],yt=a.getStackIndicator(yt,$t,a.index),At=yt.key,mt=dt&&Tt<(st?0:ot),Mt=mt?ut:ht,pt[Mt]||(pt[Mt]={}),pt[Mt][$t]||(gt[Mt]&&gt[Mt][$t]?(pt[Mt][$t]=gt[Mt][$t],pt[Mt][$t].total=null):pt[Mt][$t]=new StackItem(ft,ft.options.stackLabels,mt,$t,lt)),xt=pt[Mt][$t],Tt!==null?(xt.points[At]=xt.points[a.index]=[pick$1d(xt.cumulative,st)],defined$F(xt.cumulative)||(xt.base=At),xt.touched=ft.stacking.stacksTouched,yt.index>0&&a.singleStacks===!1&&(xt.points[At][0]=xt.points[a.index+","+$t+",0"][0])):xt.points[At]=xt.points[a.index]=null,E==="percent"?(wt=mt?ht:ut,dt&&pt[wt]&&pt[wt][$t]?(wt=pt[wt][$t],xt.total=wt.total=Math.max(wt.total,xt.total)+Math.abs(Tt)||0):xt.total=correctFloat$9(xt.total+(Math.abs(Tt)||0))):E==="group"?(isArray$e(Tt)&&(Tt=Tt[0]),Tt!==null&&(xt.total=(xt.total||0)+1)):xt.total=correctFloat$9(xt.total+(Tt||0)),E==="group"?xt.cumulative=(xt.total||1)-1:xt.cumulative=pick$1d(xt.cumulative,st)+(Tt||0),Tt!==null&&(xt.points[At].push(xt.cumulative),et[St]=xt.cumulative,xt.hasValidPoints=!0);E==="percent"&&(ft.stacking.usePercentage=!0),E!=="group"&&(this.stackedYData=et),ft.stacking.oldStacks={}}};Series$e.prototype.modifyStacks=function(){var j=this,E=j.yAxis,a=j.stackKey,k=E.stacking.stacks,tt=j.processedXData,et,rt=j.options.stacking;j[rt+"Stacker"]&&[a,"-"+a].forEach(function(nt){for(var ot=tt.length,st,lt,ht;ot--;)st=tt[ot],et=j.getStackIndicator(et,st,j.index,nt),lt=k[nt]&&k[nt][st],ht=lt&&lt.points[et.key],ht&&j[rt+"Stacker"](ht,lt,ot)})};Series$e.prototype.percentStacker=function(j,E,a){var k=E.total?100/E.total:0;j[0]=correctFloat$9(j[0]*k),j[1]=correctFloat$9(j[1]*k),this.stackedYData[a]=j[1]};Series$e.prototype.getStackIndicator=function(j,E,a,k){return!defined$F(j)||j.x!==E||k&&j.key!==k?j={x:E,index:0,key:k}:j.index++,j.key=[a,E,j.index].join(","),j};H.StackItem=StackItem;const StackItem$1=H.StackItem;var __extends$29=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),defined$E=Utilities.defined,merge$16=Utilities.merge,LineSeries$5=function(j){__extends$29(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.drawGraph=function(){var a=this,k=this.options,tt=(this.gappedPath||this.getGraphPath).call(this),et=this.chart.styledMode,rt=[["graph","highcharts-graph"]];et||rt[0].push(k.lineColor||this.color||palette.neutralColor20,k.dashStyle),rt=a.getZonesGraphs(rt),rt.forEach(function(nt,ot){var st=nt[0],lt,ht=a[st],ut=ht?"animate":"attr";ht?(ht.endX=a.preventGraphAnimation?null:tt.xMap,ht.animate({d:tt})):tt.length&&(a[st]=ht=a.chart.renderer.path(tt).addClass(nt[1]).attr({zIndex:1}).add(a.group)),ht&&!et&&(lt={stroke:nt[2],"stroke-width":k.lineWidth,fill:a.fillGraph&&a.color||"none"},nt[3]?lt.dashstyle=nt[3]:k.linecap!=="square"&&(lt["stroke-linecap"]=lt["stroke-linejoin"]="round"),ht[ut](lt).shadow(ot<2&&k.shadow)),ht&&(ht.startX=tt.xMap,ht.isArea=tt.isArea)})},E.prototype.getGraphPath=function(a,k,tt){var et=this,rt=et.options,nt=[],ot=[],st,lt=rt.step;a=a||et.points;var ht=a.reversed;return ht&&a.reverse(),lt={right:1,center:2}[lt]||lt&&3,lt&&ht&&(lt=4-lt),a=this.getValidPoints(a,!1,!(rt.connectNulls&&!k&&!tt)),a.forEach(function(ut,dt){var ft=ut.plotX,pt=ut.plotY,gt=a[dt-1],yt;(ut.leftCliff||gt&&gt.rightCliff)&&!tt&&(st=!0),ut.isNull&&!defined$E(k)&&dt>0?st=!rt.connectNulls:ut.isNull&&!k?st=!0:(dt===0||st?yt=[["M",ut.plotX,ut.plotY]]:et.getPointSpline?yt=[et.getPointSpline(a,ut,dt)]:lt?(lt===1?yt=[["L",gt.plotX,pt]]:lt===2?yt=[["L",(gt.plotX+ft)/2,gt.plotY],["L",(gt.plotX+ft)/2,pt]]:yt=[["L",ft,gt.plotY]],yt.push(["L",ft,pt])):yt=[["L",ft,pt]],ot.push(ut.x),lt&&(ot.push(ut.x),lt===2&&ot.push(ut.x)),nt.push.apply(nt,yt),st=!1)}),nt.xMap=ot,et.graphPath=nt,nt},E.prototype.getZonesGraphs=function(a){return this.zones.forEach(function(k,tt){var et=["zone-graph-"+tt,"highcharts-graph highcharts-zone-graph-"+tt+" "+(k.className||"")];this.chart.styledMode||et.push(k.color||this.color,k.dashStyle||this.options.dashStyle),a.push(et)},this),a},E.defaultOptions=merge$16(Series$e.defaultOptions,{}),E}(Series$e);SeriesRegistry$1.registerSeriesType("line",LineSeries$5);var __extends$28=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),color$d=Color.parse,LineSeries$4=SeriesRegistry$1.seriesTypes.line,extend$1f=Utilities.extend,merge$15=Utilities.merge,objectEach$j=Utilities.objectEach,pick$1c=Utilities.pick,AreaSeries$1=function(j){__extends$28(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.drawGraph=function(){this.areaPath=[],j.prototype.drawGraph.apply(this);var a=this,k=this.areaPath,tt=this.options,et=this.zones,rt=[["area","highcharts-area",this.color,tt.fillColor]];et.forEach(function(nt,ot){rt.push(["zone-area-"+ot,"highcharts-area highcharts-zone-area-"+ot+" "+nt.className,nt.color||a.color,nt.fillColor||tt.fillColor])}),rt.forEach(function(nt){var ot=nt[0],st=a[ot],lt=st?"animate":"attr",ht={};st?(st.endX=a.preventGraphAnimation?null:k.xMap,st.animate({d:k})):(ht.zIndex=0,st=a[ot]=a.chart.renderer.path(k).addClass(nt[1]).add(a.group),st.isArea=!0),a.chart.styledMode||(ht.fill=pick$1c(nt[3],color$d(nt[2]).setOpacity(pick$1c(tt.fillOpacity,.75)).get())),st[lt](ht),st.startX=k.xMap,st.shiftUnit=tt.step?2:1})},E.prototype.getGraphPath=function(a){var k=LineSeries$4.prototype.getGraphPath,tt,et=this.options,rt=et.stacking,nt=this.yAxis,ot,st,lt=[],ht=[],ut=this.index,dt,ft,pt,gt=nt.stacking.stacks[this.stackKey],yt=et.threshold,mt=Math.round(nt.getThreshold(et.threshold)),xt,wt,Mt=pick$1c(et.connectNulls,rt==="percent"),At=function($t,Tt,Pt){var It=a[$t],Lt=rt&&gt[It.x].points[ut],Nt=It[Pt+"Null"]||0,Ht=It[Pt+"Cliff"]||0,jt,Dt,Ft=!0;Ht||Nt?(jt=(Nt?Lt[0]:Lt[1])+Ht,Dt=Lt[0]+Ht,Ft=!!Nt):!rt&&a[Tt]&&a[Tt].isNull&&(jt=Dt=yt),typeof jt<"u"&&(ht.push({plotX:pt,plotY:jt===null?mt:nt.getThreshold(jt),isNull:Ft,isCliff:!0}),lt.push({plotX:pt,plotY:Dt===null?mt:nt.getThreshold(Dt),doCurve:!1}))};for(a=a||this.points,rt&&(a=this.getStackPoints(a)),dt=0;dt<a.length;dt++)rt||(a[dt].leftCliff=a[dt].rightCliff=a[dt].leftNull=a[dt].rightNull=void 0),xt=a[dt].isNull,pt=pick$1c(a[dt].rectPlotX,a[dt].plotX),wt=rt?pick$1c(a[dt].yBottom,mt):mt,(!xt||Mt)&&(Mt||At(dt,dt-1,"left"),xt&&!rt&&Mt||(ht.push(a[dt]),lt.push({x:dt,plotX:pt,plotY:wt})),Mt||At(dt,dt+1,"right"));ot=k.call(this,ht,!0,!0),lt.reversed=!0,st=k.call(this,lt,!0,!0);var St=st[0];return St&&St[0]==="M"&&(st[0]=["L",St[1],St[2]]),ft=ot.concat(st),ft.length&&ft.push(["Z"]),tt=k.call(this,ht,!1,Mt),ft.xMap=ot.xMap,this.areaPath=ft,tt},E.prototype.getStackPoints=function(a){var k=this,tt=[],et=[],rt=this.xAxis,nt=this.yAxis,ot=nt.stacking.stacks[this.stackKey],st={},lt=nt.series,ht=lt.length,ut=nt.options.reversedStacks?1:-1,dt=lt.indexOf(k);if(a=a||this.points,this.options.stacking){for(var ft=0;ft<a.length;ft++)a[ft].leftNull=a[ft].rightNull=void 0,st[a[ft].x]=a[ft];objectEach$j(ot,function(gt,yt){gt.total!==null&&et.push(yt)}),et.sort(function(gt,yt){return gt-yt});var pt=lt.map(function(gt){return gt.visible});et.forEach(function(gt,yt){var mt=0,xt,wt;if(st[gt]&&!st[gt].isNull)tt.push(st[gt]),[-1,1].forEach(function(St){var $t=St===1?"rightNull":"leftNull",Tt=St===1?"rightCliff":"leftCliff",Pt=0,It=ot[et[yt+St]];if(It)for(var Lt=dt;Lt>=0&&Lt<ht;){var Nt=lt[Lt].index;xt=It.points[Nt],xt||(Nt===k.index?st[gt][$t]=!0:pt[Lt]&&(wt=ot[gt].points[Nt],wt&&(Pt-=wt[1]-wt[0]))),Lt+=ut}st[gt][Tt]=Pt});else{for(var Mt=dt;Mt>=0&&Mt<ht;){var At=lt[Mt].index;if(xt=ot[gt].points[At],xt){mt=xt[1];break}Mt+=ut}mt=pick$1c(mt,0),mt=nt.translate(mt,0,1,0,1),tt.push({isNull:!0,plotX:rt.translate(gt,0,0,0,1),x:gt,plotY:mt,yBottom:mt})}})}return tt},E.defaultOptions=merge$15(LineSeries$4.defaultOptions,{threshold:0}),E}(LineSeries$4);extend$1f(AreaSeries$1.prototype,{singleStacks:!1,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("area",AreaSeries$1);var __extends$27=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),LineSeries$3=SeriesRegistry$1.seriesTypes.line,merge$14=Utilities.merge,pick$1b=Utilities.pick,SplineSeries$1=function(j){__extends$27(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.getPointSpline=function(a,k,tt){var et=1.5,rt=et+1,nt=k.plotX||0,ot=k.plotY||0,st=a[tt-1],lt=a[tt+1],ht,ut,dt,ft,pt;function gt(At){return At&&!At.isNull&&At.doCurve!==!1&&!k.isCliff}if(gt(st)&&gt(lt)){var yt=st.plotX||0,mt=st.plotY||0,xt=lt.plotX||0,wt=lt.plotY||0,Mt=0;ht=(et*nt+yt)/rt,ut=(et*ot+mt)/rt,dt=(et*nt+xt)/rt,ft=(et*ot+wt)/rt,dt!==ht&&(Mt=(ft-ut)*(dt-nt)/(dt-ht)+ot-ft),ut+=Mt,ft+=Mt,ut>mt&&ut>ot?(ut=Math.max(mt,ot),ft=2*ot-ut):ut<mt&&ut<ot&&(ut=Math.min(mt,ot),ft=2*ot-ut),ft>wt&&ft>ot?(ft=Math.max(wt,ot),ut=2*ot-ft):ft<wt&&ft<ot&&(ft=Math.min(wt,ot),ut=2*ot-ft),k.rightContX=dt,k.rightContY=ft}return pt=["C",pick$1b(st.rightContX,st.plotX,0),pick$1b(st.rightContY,st.plotY,0),pick$1b(ht,nt,0),pick$1b(ut,ot,0),nt,ot],st.rightContX=st.rightContY=void 0,pt},E.defaultOptions=merge$14(LineSeries$3.defaultOptions),E}(LineSeries$3);SeriesRegistry$1.registerSeriesType("spline",SplineSeries$1);var __extends$26=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),areaProto$1=AreaSeries$1.prototype,extend$1e=Utilities.extend,merge$13=Utilities.merge,AreaSplineSeries=function(j){__extends$26(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.points=void 0,a.options=void 0,a}return E.defaultOptions=merge$13(SplineSeries$1.defaultOptions,AreaSeries$1.defaultOptions),E}(SplineSeries$1);extend$1e(AreaSplineSeries.prototype,{getGraphPath:areaProto$1.getGraphPath,getStackPoints:areaProto$1.getStackPoints,drawGraph:areaProto$1.drawGraph,drawLegendSymbol:LegendSymbol$1.drawRectangle});SeriesRegistry$1.registerSeriesType("areaspline",AreaSplineSeries);var __extends$25=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),animObject$5=animationExports.animObject,color$c=Color.parse,hasTouch$1=H.hasTouch,noop$h=H.noop,clamp$e=Utilities.clamp,css$4=Utilities.css,defined$D=Utilities.defined,extend$1d=Utilities.extend,fireEvent$p=Utilities.fireEvent,isArray$d=Utilities.isArray,isNumber$x=Utilities.isNumber,merge$12=Utilities.merge,pick$1a=Utilities.pick,objectEach$i=Utilities.objectEach,ColumnSeries$h=function(j){__extends$25(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.borderWidth=void 0,a.data=void 0,a.group=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.animate=function(a){var k=this,tt=this.yAxis,et=k.options,rt=this.chart.inverted,nt={},ot=rt?"translateX":"translateY",st,lt;a?(nt.scaleY=.001,lt=clamp$e(tt.toPixels(et.threshold),tt.pos,tt.pos+tt.len),rt?nt.translateX=lt-tt.len:nt.translateY=lt,k.clipBox&&k.setClip(),k.group.attr(nt)):(st=Number(k.group.attr(ot)),k.group.animate({scaleY:1},extend$1d(animObject$5(k.options.animation),{step:function(ht,ut){k.group&&(nt[ot]=st+ut.pos*(tt.pos-st),k.group.attr(nt))}})))},E.prototype.init=function(a,k){j.prototype.init.apply(this,arguments);var tt=this;a=tt.chart,a.hasRendered&&a.series.forEach(function(et){et.type===tt.type&&(et.isDirty=!0)})},E.prototype.getColumnMetrics=function(){var a=this,k=a.options,tt=a.xAxis,et=a.yAxis,rt=tt.options.reversedStacks,nt=tt.reversed&&!rt||!tt.reversed&&rt,ot={},st,lt=0;k.grouping===!1?lt=1:a.chart.series.forEach(function(xt){var wt=xt.yAxis,Mt=xt.options,At;xt.type===a.type&&(xt.visible||!a.chart.options.chart.ignoreHiddenSeries)&&et.len===wt.len&&et.pos===wt.pos&&(Mt.stacking&&Mt.stacking!=="group"?(st=xt.stackKey,typeof ot[st]>"u"&&(ot[st]=lt++),At=ot[st]):Mt.grouping!==!1&&(At=lt++),xt.columnIndex=At)});var ht=Math.min(Math.abs(tt.transA)*(tt.ordinal&&tt.ordinal.slope||k.pointRange||tt.closestPointRange||tt.tickInterval||1),tt.len),ut=ht*k.groupPadding,dt=ht-2*ut,ft=dt/(lt||1),pt=Math.min(k.maxPointWidth||tt.len,pick$1a(k.pointWidth,ft*(1-2*k.pointPadding))),gt=(ft-pt)/2,yt=(a.columnIndex||0)+(nt?1:0),mt=gt+(ut+yt*ft-ht/2)*(nt?-1:1);return a.columnMetrics={width:pt,offset:mt,paddedWidth:ft,columnCount:lt},a.columnMetrics},E.prototype.crispCol=function(a,k,tt,et){var rt=this.chart,nt=this.borderWidth,ot=-(nt%2?.5:0),st,lt=nt%2?.5:1;rt.inverted&&rt.renderer.isVML&&(lt+=1),this.options.crisp&&(st=Math.round(a+tt)+ot,a=Math.round(a)+ot,tt=st-a);var ht=Math.round(k+et)+lt,ut=Math.abs(k)<=.5&&ht>.5;return k=Math.round(k)+lt,et=ht-k,ut&&et&&(k-=1,et+=1),{x:a,y:k,width:tt,height:et}},E.prototype.adjustForMissingColumns=function(a,k,tt,et){var rt=this,nt=this.options.stacking;if(!tt.isNull&&et.columnCount>1){var ot=0,st=0;objectEach$i(this.yAxis.stacking&&this.yAxis.stacking.stacks,function(ht){if(typeof tt.x=="number"){var ut=ht[tt.x.toString()];if(ut){var dt=ut.points[rt.index],ft=ut.total;nt?(dt&&(ot=st),ut.hasValidPoints&&st++):isArray$d(dt)&&(ot=dt[1],st=ft||0)}}});var lt=(st-1)*et.paddedWidth+k;a=(tt.plotX||0)+lt/2-k-ot*et.paddedWidth}return a},E.prototype.translate=function(){var a=this,k=a.chart,tt=a.options,et=a.dense=a.closestPointRange*a.xAxis.transA<2,rt=a.borderWidth=pick$1a(tt.borderWidth,et?0:1),nt=a.xAxis,ot=a.yAxis,st=tt.threshold,lt=a.translatedThreshold=ot.getThreshold(st),ht=pick$1a(tt.minPointLength,5),ut=a.getColumnMetrics(),dt=ut.width,ft=a.pointXOffset=ut.offset,pt=a.dataMin,gt=a.dataMax,yt=a.barW=Math.max(dt,1+2*rt);k.inverted&&(lt-=.5),tt.pointPadding&&(yt=Math.ceil(yt)),Series$e.prototype.translate.apply(a),a.points.forEach(function(mt){var xt=pick$1a(mt.yBottom,lt),wt=999+Math.abs(xt),Mt=mt.plotX||0,At=clamp$e(mt.plotY,-wt,ot.len+wt),St,$t=Math.min(At,xt),Tt=Math.max(At,xt)-$t,Pt=dt,It=Mt+ft,Lt=yt;ht&&Math.abs(Tt)<ht&&(Tt=ht,St=!ot.reversed&&!mt.negative||ot.reversed&&mt.negative,isNumber$x(st)&&isNumber$x(gt)&&mt.y===st&&gt<=st&&(ot.min||0)<st&&(pt!==gt||(ot.max||0)<=st)&&(St=!St),$t=Math.abs($t-lt)>ht?xt-ht:lt-(St?ht:0)),defined$D(mt.options.pointWidth)&&(Pt=Lt=Math.ceil(mt.options.pointWidth),It-=Math.round((Pt-dt)/2)),tt.centerInCategory&&(It=a.adjustForMissingColumns(It,Pt,mt,ut)),mt.barX=It,mt.pointWidth=Pt,mt.tooltipPos=k.inverted?[clamp$e(ot.len+ot.pos-k.plotLeft-At,ot.pos-k.plotLeft,ot.len+ot.pos-k.plotLeft),nt.len+nt.pos-k.plotTop-It-Lt/2,Tt]:[nt.left-k.plotLeft+It+Lt/2,clamp$e(At+ot.pos-k.plotTop,ot.pos-k.plotTop,ot.len+ot.pos-k.plotTop),Tt],mt.shapeType=a.pointClass.prototype.shapeType||"rect",mt.shapeArgs=a.crispCol.apply(a,mt.isNull?[It,lt,Lt,0]:[It,$t,Lt,Tt])})},E.prototype.drawGraph=function(){this.group[this.dense?"addClass":"removeClass"]("highcharts-dense-data")},E.prototype.pointAttribs=function(a,k){var tt=this.options,et=this.pointAttrToOptions||{},rt=et.stroke||"borderColor",nt=et["stroke-width"]||"borderWidth",ot,st,lt,ht=a&&a.color||this.color,ut=a&&a[rt]||tt[rt]||ht,dt=a&&a.options.dashStyle||tt.dashStyle,ft=a&&a[nt]||tt[nt]||this[nt]||0,pt=pick$1a(a&&a.opacity,tt.opacity,1);a&&this.zones.length&&(st=a.getZone(),ht=a.options.color||st&&(st.color||a.nonZonedColor)||this.color,st&&(ut=st.borderColor||ut,dt=st.dashStyle||dt,ft=st.borderWidth||ft)),k&&a&&(ot=merge$12(tt.states[k],a.options.states&&a.options.states[k]||{}),lt=ot.brightness,ht=ot.color||typeof lt<"u"&&color$c(ht).brighten(ot.brightness).get()||ht,ut=ot[rt]||ut,ft=ot[nt]||ft,dt=ot.dashStyle||dt,pt=pick$1a(ot.opacity,pt));var gt={fill:ht,stroke:ut,"stroke-width":ft,opacity:pt};return dt&&(gt.dashstyle=dt),gt},E.prototype.drawPoints=function(){var a=this,k=this.chart,tt=a.options,et=k.renderer,rt=tt.animationLimit||250,nt;a.points.forEach(function(ot){var st=ot.plotY,lt=ot.graphic,ht=!!lt,ut=lt&&k.pointCount<rt?"animate":"attr";isNumber$x(st)&&ot.y!==null?(nt=ot.shapeArgs,lt&&ot.hasNewShapeType()&&(lt=lt.destroy()),a.enabledDataSorting&&(ot.startXPos=a.xAxis.reversed?-(nt&&nt.width||0):a.xAxis.width),lt||(ot.graphic=lt=et[ot.shapeType](nt).add(ot.group||a.group),lt&&a.enabledDataSorting&&k.hasRendered&&k.pointCount<rt&&(lt.attr({x:ot.startXPos}),ht=!0,ut="animate")),lt&&ht&&lt[ut](merge$12(nt)),tt.borderRadius&&lt[ut]({r:tt.borderRadius}),k.styledMode||lt[ut](a.pointAttribs(ot,ot.selected&&"select")).shadow(ot.allowShadow!==!1&&tt.shadow,null,tt.stacking&&!tt.borderRadius),lt&&(lt.addClass(ot.getClassName(),!0),lt.attr({visibility:ot.visible?"inherit":"hidden"}))):lt&&(ot.graphic=lt.destroy())})},E.prototype.drawTracker=function(){var a=this,k=a.chart,tt=k.pointer,et=function(nt){var ot=tt.getPointFromEvent(nt);typeof ot<"u"&&(tt.isDirectTouch=!0,ot.onMouseOver(nt))},rt;a.points.forEach(function(nt){rt=isArray$d(nt.dataLabels)?nt.dataLabels:nt.dataLabel?[nt.dataLabel]:[],nt.graphic&&(nt.graphic.element.point=nt),rt.forEach(function(ot){ot.div?ot.div.point=nt:ot.element.point=nt})}),a._hasTracking||(a.trackerGroups.forEach(function(nt){a[nt]&&(a[nt].addClass("highcharts-tracker").on("mouseover",et).on("mouseout",function(ot){tt.onTrackerMouseOut(ot)}),hasTouch$1&&a[nt].on("touchstart",et),!k.styledMode&&a.options.cursor&&a[nt].css(css$4).css({cursor:a.options.cursor}))}),a._hasTracking=!0),fireEvent$p(this,"afterDrawTracker")},E.prototype.remove=function(){var a=this,k=a.chart;k.hasRendered&&k.series.forEach(function(tt){tt.type===a.type&&(tt.isDirty=!0)}),Series$e.prototype.remove.apply(a,arguments)},E.defaultOptions=merge$12(Series$e.defaultOptions,{borderRadius:0,centerInCategory:!1,groupPadding:.2,marker:null,pointPadding:.1,minPointLength:0,cropThreshold:50,pointRange:null,states:{hover:{halo:!1,brightness:.1},select:{color:palette.neutralColor20,borderColor:palette.neutralColor100}},dataLabels:{align:void 0,verticalAlign:void 0,y:void 0},startFromThreshold:!0,stickyTracking:!1,tooltip:{distance:6},threshold:0,borderColor:palette.backgroundColor}),E}(Series$e);extend$1d(ColumnSeries$h.prototype,{cropShoulder:0,directTouch:!0,drawLegendSymbol:LegendSymbol$1.drawRectangle,getSymbol:noop$h,negStacks:!0,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("column",ColumnSeries$h);var getDeferredAnimation$1=animationExports.getDeferredAnimation,format$9=FormatUtilities.format,defined$C=Utilities.defined,extend$1c=Utilities.extend,fireEvent$o=Utilities.fireEvent,isArray$c=Utilities.isArray,merge$11=Utilities.merge,objectEach$h=Utilities.objectEach,pick$19=Utilities.pick,splat$b=Utilities.splat,DataLabel;(function(j){var E=[];function a(st,lt,ht,ut,dt){var ft=this,pt=this.chart,gt=this.isCartesian&&pt.inverted,yt=this.enabledDataSorting,mt=pick$19(st.dlBox&&st.dlBox.centerX,st.plotX,-9999),xt=pick$19(st.plotY,-9999),wt=lt.getBBox(),Mt=ht.rotation,At=ht.align,St=pt.isInsidePlot(mt,Math.round(xt),{inverted:gt,paneCoordinates:!0,series:ft}),$t=function(Dt){yt&&ft.xAxis&&!Ht&&ft.setDataLabelStartPos(st,lt,dt,St,Dt)},Tt,Pt,It,Lt,Nt,Ht=pick$19(ht.overflow,yt?"none":"justify")==="justify",jt=this.visible&&st.visible!==!1&&(st.series.forceDL||yt&&!Ht||St||pick$19(ht.inside,!!this.options.stacking)&&ut&&pt.isInsidePlot(mt,gt?ut.x+1:ut.y+ut.height-1,{inverted:gt,paneCoordinates:!0,series:ft}));jt&&(Tt=pt.renderer.fontMetrics(pt.styledMode?void 0:ht.style.fontSize,lt).b,ut=extend$1c({x:gt?this.yAxis.len-xt:mt,y:Math.round(gt?this.xAxis.len-mt:xt),width:0,height:0},ut),extend$1c(ht,{width:wt.width,height:wt.height}),Mt?(Ht=!1,Lt=pt.renderer.rotCorr(Tt,Mt),Nt={x:ut.x+(ht.x||0)+ut.width/2+Lt.x,y:ut.y+(ht.y||0)+{top:0,middle:.5,bottom:1}[ht.verticalAlign]*ut.height},$t(Nt),lt[dt?"attr":"animate"](Nt).attr({align:At}),Pt=(Mt+720)%360,It=Pt>180&&Pt<360,At==="left"?Nt.y-=It?wt.height:0:At==="center"?(Nt.x-=wt.width/2,Nt.y-=wt.height/2):At==="right"&&(Nt.x-=wt.width,Nt.y-=It?0:wt.height),lt.placed=!0,lt.alignAttr=Nt):($t(ut),lt.align(ht,void 0,ut),Nt=lt.alignAttr),Ht&&ut.height>=0?this.justifyDataLabel(lt,ht,Nt,wt,ut,dt):pick$19(ht.crop,!0)&&(jt=pt.isInsidePlot(Nt.x,Nt.y,{paneCoordinates:!0,series:ft})&&pt.isInsidePlot(Nt.x+wt.width,Nt.y+wt.height,{paneCoordinates:!0,series:ft})),ht.shape&&!Mt&&lt[dt?"attr":"animate"]({anchorX:gt?pt.plotWidth-st.plotY:st.plotX,anchorY:gt?pt.plotHeight-st.plotX:st.plotY})),dt&&yt&&(lt.placed=!1),!jt&&(!yt||Ht)&&(lt.hide(!0),lt.placed=!1)}function k(st,lt){var ht=lt.filter;if(ht){var ut=ht.operator,dt=st[ht.property],ft=ht.value;return ut===">"&&dt>ft||ut==="<"&&dt<ft||ut===">="&&dt>=ft||ut==="<="&&dt<=ft||ut==="=="&&dt==ft||ut==="==="&&dt===ft}return!0}function tt(st){if(E.indexOf(st)===-1){var lt=st.prototype;E.push(st),lt.alignDataLabel=a,lt.drawDataLabels=et,lt.justifyDataLabel=rt,lt.setDataLabelStartPos=ot}}j.compose=tt;function et(){var st=this,lt=st.chart,ht=st.options,ut=st.points,dt=st.hasRendered||0,ft=lt.renderer,pt=ht.dataLabels,gt,yt,mt=pt.animation,xt=pt.defer?getDeferredAnimation$1(lt,mt,st):{defer:0,duration:0};if(pt=nt(nt(lt.options.plotOptions&&lt.options.plotOptions.series&&lt.options.plotOptions.series.dataLabels,lt.options.plotOptions&&lt.options.plotOptions[st.type]&&lt.options.plotOptions[st.type].dataLabels),pt),fireEvent$o(this,"drawDataLabels"),isArray$c(pt)||pt.enabled||st._hasPointLabels){if(yt=st.plotGroup("dataLabelsGroup","data-labels",dt?"inherit":"hidden",pt.zIndex||6),yt.attr({opacity:+dt}),!dt){var wt=st.dataLabelsGroup;wt&&(st.visible&&yt.show(!0),wt[ht.animation?"animate":"attr"]({opacity:1},xt))}ut.forEach(function(Mt){gt=splat$b(nt(pt,Mt.dlOptions||Mt.options&&Mt.options.dataLabels)),gt.forEach(function(At,St){var $t=At.enabled&&(!Mt.isNull||Mt.dataLabelOnNull)&&k(Mt,At),Tt=Mt.connectors?Mt.connectors[St]:Mt.connector,Pt,It,Lt,Nt,Ht,jt,Dt=Mt.dataLabels?Mt.dataLabels[St]:Mt.dataLabel,Ft=pick$19(At.distance,Mt.labelDistance),kt=!Dt;$t&&(Pt=Mt.getLabelConfig(),It=pick$19(At[Mt.formatPrefix+"Format"],At.format),Lt=defined$C(It)?format$9(It,Pt,lt):(At[Mt.formatPrefix+"Formatter"]||At.formatter).call(Pt,At),Nt=At.style,Ht=At.rotation,lt.styledMode||(Nt.color=pick$19(At.color,Nt.color,st.color,palette.neutralColor100),Nt.color==="contrast"?(Mt.contrastColor=ft.getContrast(Mt.color||st.color),Nt.color=!defined$C(Ft)&&At.inside||Ft<0||ht.stacking?Mt.contrastColor:palette.neutralColor100):delete Mt.contrastColor,ht.cursor&&(Nt.cursor=ht.cursor)),jt={r:At.borderRadius||0,rotation:Ht,padding:At.padding,zIndex:1},lt.styledMode||(jt.fill=At.backgroundColor,jt.stroke=At.borderColor,jt["stroke-width"]=At.borderWidth),objectEach$h(jt,function(Bt,Gt){typeof Bt>"u"&&delete jt[Gt]})),Dt&&(!$t||!defined$C(Lt))?(Mt.dataLabel=Mt.dataLabel&&Mt.dataLabel.destroy(),Mt.dataLabels&&(Mt.dataLabels.length===1?delete Mt.dataLabels:delete Mt.dataLabels[St]),St||delete Mt.dataLabel,Tt&&(Mt.connector=Mt.connector.destroy(),Mt.connectors&&(Mt.connectors.length===1?delete Mt.connectors:delete Mt.connectors[St]))):$t&&defined$C(Lt)&&(Dt?jt.text=Lt:(Mt.dataLabels=Mt.dataLabels||[],Dt=Mt.dataLabels[St]=Ht?ft.text(Lt,0,-9999,At.useHTML).addClass("highcharts-data-label"):ft.label(Lt,0,-9999,At.shape,null,null,At.useHTML,null,"data-label"),St||(Mt.dataLabel=Dt),Dt.addClass(" highcharts-data-label-color-"+Mt.colorIndex+" "+(At.className||"")+(At.useHTML?" highcharts-tracker":""))),Dt.options=At,Dt.attr(jt),lt.styledMode||Dt.css(Nt).shadow(At.shadow),Dt.added||Dt.add(yt),At.textPath&&!At.useHTML&&(Dt.setTextPath(Mt.getDataLabelPath&&Mt.getDataLabelPath(Dt)||Mt.graphic,At.textPath),Mt.dataLabelPath&&!At.textPath.enabled&&(Mt.dataLabelPath=Mt.dataLabelPath.destroy())),st.alignDataLabel(Mt,Dt,At,null,kt))})})}fireEvent$o(this,"afterDrawDataLabels")}function rt(st,lt,ht,ut,dt,ft){var pt=this.chart,gt=lt.align,yt=lt.verticalAlign,mt=st.box?0:st.padding||0,xt=lt.x,wt=xt===void 0?0:xt,Mt=lt.y,At=Mt===void 0?0:Mt,St,$t;return St=(ht.x||0)+mt,St<0&&(gt==="right"&&wt>=0?(lt.align="left",lt.inside=!0):wt-=St,$t=!0),St=(ht.x||0)+ut.width-mt,St>pt.plotWidth&&(gt==="left"&&wt<=0?(lt.align="right",lt.inside=!0):wt+=pt.plotWidth-St,$t=!0),St=ht.y+mt,St<0&&(yt==="bottom"&&At>=0?(lt.verticalAlign="top",lt.inside=!0):At-=St,$t=!0),St=(ht.y||0)+ut.height-mt,St>pt.plotHeight&&(yt==="top"&&At<=0?(lt.verticalAlign="bottom",lt.inside=!0):At+=pt.plotHeight-St,$t=!0),$t&&(lt.x=wt,lt.y=At,st.placed=!ft,st.align(lt,void 0,dt)),$t}function nt(st,lt){var ht=[],ut;if(isArray$c(st)&&!isArray$c(lt))ht=st.map(function(dt){return merge$11(dt,lt)});else if(isArray$c(lt)&&!isArray$c(st))ht=lt.map(function(dt){return merge$11(st,dt)});else if(!isArray$c(st)&&!isArray$c(lt))ht=merge$11(st,lt);else for(ut=Math.max(st.length,lt.length);ut--;)ht[ut]=merge$11(st[ut],lt[ut]);return ht}function ot(st,lt,ht,ut,dt){var ft=this.chart,pt=ft.inverted,gt=this.xAxis,yt=gt.reversed,mt=pt?lt.height/2:lt.width/2,xt=st.pointWidth,wt=xt?xt/2:0;lt.startXPos=pt?dt.x:yt?-mt-wt:gt.width-mt+wt,lt.startYPos=pt?yt?this.yAxis.height-mt+wt:-mt-wt:dt.y,ut?lt.visibility==="hidden"&&(lt.show(),lt.attr({opacity:0}).animate({opacity:1})):lt.attr({opacity:1}).animate({opacity:0},void 0,lt.hide),ft.hasRendered&&(ht&&lt.attr({x:lt.startXPos,y:lt.startYPos}),lt.placed=!0)}})(DataLabel||(DataLabel={}));const DataLabel$1=DataLabel;var Series$d=SeriesRegistry$1.series,merge$10=Utilities.merge,pick$18=Utilities.pick,ColumnDataLabel$1;(function(j){var E=[];function a(tt,et,rt,nt,ot){var st=this.chart.inverted,lt=tt.series,ht=tt.dlBox||tt.shapeArgs,ut=pick$18(tt.below,tt.plotY>pick$18(this.translatedThreshold,lt.yAxis.len)),dt=pick$18(rt.inside,!!this.options.stacking),ft;ht&&(nt=merge$10(ht),nt.y<0&&(nt.height+=nt.y,nt.y=0),ft=nt.y+nt.height-lt.yAxis.len,ft>0&&ft<nt.height&&(nt.height-=ft),st&&(nt={x:lt.yAxis.len-nt.y-nt.height,y:lt.xAxis.len-nt.x-nt.width,width:nt.height,height:nt.width}),dt||(st?(nt.x+=ut?0:nt.width,nt.width=0):(nt.y+=ut?nt.height:0,nt.height=0))),rt.align=pick$18(rt.align,!st||dt?"center":ut?"right":"left"),rt.verticalAlign=pick$18(rt.verticalAlign,st||dt?"middle":ut?"top":"bottom"),Series$d.prototype.alignDataLabel.call(this,tt,et,rt,nt,ot),rt.inside&&tt.contrastColor&&et.css({color:tt.contrastColor})}function k(tt){DataLabel$1.compose(Series$d),E.indexOf(tt)===-1&&(E.push(tt),tt.prototype.alignDataLabel=a)}j.compose=k})(ColumnDataLabel$1||(ColumnDataLabel$1={}));const ColumnDataLabel$2=ColumnDataLabel$1;var __extends$24=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),extend$1b=Utilities.extend,merge$$=Utilities.merge,BarSeries=function(j){__extends$24(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.defaultOptions=merge$$(ColumnSeries$h.defaultOptions,{}),E}(ColumnSeries$h);extend$1b(BarSeries.prototype,{inverted:!0});SeriesRegistry$1.registerSeriesType("bar",BarSeries);var __extends$23=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),addEvent$P=Utilities.addEvent,extend$1a=Utilities.extend,merge$_=Utilities.merge,ScatterSeries$4=function(j){__extends$23(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.applyJitter=function(){var a=this,k=this.options.jitter,tt=this.points.length;function et(rt){var nt=Math.sin(rt)*1e4;return nt-Math.floor(nt)}k&&this.points.forEach(function(rt,nt){["x","y"].forEach(function(ot,st){var lt,ht="plot"+ot.toUpperCase(),ut,dt,ft;k[ot]&&!rt.isNull&&(lt=a[ot+"Axis"],ft=k[ot]*lt.transA,lt&&!lt.isLog&&(ut=Math.max(0,rt[ht]-ft),dt=Math.min(lt.len,rt[ht]+ft),rt[ht]=ut+(dt-ut)*et(nt+st*tt),ot==="x"&&(rt.clientX=rt.plotX)))})})},E.prototype.drawGraph=function(){this.options.lineWidth?j.prototype.drawGraph.call(this):this.graph&&(this.graph=this.graph.destroy())},E.defaultOptions=merge$_(LineSeries$5.defaultOptions,{lineWidth:0,findNearestPointBy:"xy",jitter:{x:0,y:0},marker:{enabled:!0},tooltip:{headerFormat:'<span style="color:{point.color}">●</span> <span style="font-size: 10px"> {series.name}</span><br/>',pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>"}}),E}(LineSeries$5);extend$1a(ScatterSeries$4.prototype,{drawTracker:ColumnSeries$h.prototype.drawTracker,sorted:!1,requireSorting:!1,noSharedTooltip:!0,trackerGroups:["group","markerGroup","dataLabelsGroup"],takeOrdinalPosition:!1});addEvent$P(ScatterSeries$4,"afterTranslate",function(){this.applyJitter()});SeriesRegistry$1.registerSeriesType("scatter",ScatterSeries$4);var isNumber$w=Utilities.isNumber,pick$17=Utilities.pick,relativeLength$6=Utilities.relativeLength,deg2rad$4=H.deg2rad,centeredSeriesMixin=H.CenteredSeriesMixin={getCenter:function(){var j=this.options,E=this.chart,a=2*(j.slicedOffset||0),k,tt=E.plotWidth-2*a,et=E.plotHeight-2*a,rt=j.center,nt=Math.min(tt,et),ot=j.size,st=j.innerSize||0,lt,ht,ut;for(typeof ot=="string"&&(ot=parseFloat(ot)),typeof st=="string"&&(st=parseFloat(st)),lt=[pick$17(rt[0],"50%"),pick$17(rt[1],"50%"),pick$17(ot&&ot<0?void 0:j.size,"100%"),pick$17(st&&st<0?void 0:j.innerSize||0,"0%")],E.angular&&!(this instanceof Series$e)&&(lt[3]=0),ht=0;ht<4;++ht)ut=lt[ht],k=ht<2||ht===2&&/%$/.test(ut),lt[ht]=relativeLength$6(ut,[tt,et,nt,lt[2]][ht])+(k?a:0);return lt[3]>lt[2]&&(lt[3]=lt[2]),lt},getStartAndEndRadians:function(j,E){var a=isNumber$w(j)?j:0,k=isNumber$w(E)&&E>a&&E-a<360?E:a+360,tt=-90;return{start:deg2rad$4*(a+tt),end:deg2rad$4*(k+tt)}}},__extends$22=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),setAnimation$1=animationExports.setAnimation,addEvent$O=Utilities.addEvent,defined$B=Utilities.defined,extend$19=Utilities.extend,isNumber$v=Utilities.isNumber,pick$16=Utilities.pick,relativeLength$5=Utilities.relativeLength,PiePoint$3=function(j){__extends$22(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.labelDistance=void 0,a.options=void 0,a.series=void 0,a}return E.prototype.getConnectorPath=function(){var a=this.labelPosition,k=this.series.options.dataLabels,tt=this.connectorShapes,et=k.connectorShape;return tt[et]&&(et=tt[et]),et.call(this,{x:a.final.x,y:a.final.y,alignment:a.alignment},a.connectorPosition,k)},E.prototype.getTranslate=function(){return this.sliced?this.slicedTranslation:{translateX:0,translateY:0}},E.prototype.haloPath=function(a){var k=this.shapeArgs;return this.sliced||!this.visible?[]:this.series.chart.renderer.symbols.arc(k.x,k.y,k.r+a,k.r+a,{innerR:k.r-1,start:k.start,end:k.end})},E.prototype.init=function(){var a=this;j.prototype.init.apply(this,arguments),this.name=pick$16(this.name,"Slice");var k=function(tt){a.slice(tt.type==="select")};return addEvent$O(this,"select",k),addEvent$O(this,"unselect",k),this},E.prototype.isValid=function(){return isNumber$v(this.y)&&this.y>=0},E.prototype.setVisible=function(a,k){var tt=this,et=this.series,rt=et.chart,nt=et.options.ignoreHiddenPoint;k=pick$16(k,nt),a!==this.visible&&(this.visible=this.options.visible=a=typeof a>"u"?!this.visible:a,et.options.data[et.data.indexOf(this)]=this.options,["graphic","dataLabel","connector","shadowGroup"].forEach(function(ot){tt[ot]&&tt[ot][a?"show":"hide"](a)}),this.legendItem&&rt.legend.colorizeItem(this,a),!a&&this.state==="hover"&&this.setState(""),nt&&(et.isDirty=!0),k&&rt.redraw())},E.prototype.slice=function(a,k,tt){var et=this.series,rt=et.chart;setAnimation$1(tt,rt),k=pick$16(k,!0),this.sliced=this.options.sliced=a=defined$B(a)?a:!this.sliced,et.options.data[et.data.indexOf(this)]=this.options,this.graphic&&this.graphic.animate(this.getTranslate()),this.shadowGroup&&this.shadowGroup.animate(this.getTranslate())},E}(Point$5);extend$19(PiePoint$3.prototype,{connectorShapes:{fixedOffset:function(j,E,a){var k=E.breakAt,tt=E.touchingSliceAt,et=a.softConnector?["C",j.x+(j.alignment==="left"?-5:5),j.y,2*k.x-tt.x,2*k.y-tt.y,k.x,k.y]:["L",k.x,k.y];return[["M",j.x,j.y],et,["L",tt.x,tt.y]]},straight:function(j,E){var a=E.touchingSliceAt;return[["M",j.x,j.y],["L",a.x,a.y]]},crookedLine:function(j,E,a){var k=E.touchingSliceAt,tt=this.series,et=tt.center[0],rt=tt.chart.plotWidth,nt=tt.chart.plotLeft,ot=j.alignment,st=this.shapeArgs.r,lt=relativeLength$5(a.crookDistance,1),ht=ot==="left"?et+st+(rt+nt-et-st)*(1-lt):nt+(et-st)*lt,ut=["L",ht,j.y],dt=!0;(ot==="left"?ht>j.x||ht<k.x:ht<j.x||ht>k.x)&&(dt=!1);var ft=[["M",j.x,j.y]];return dt&&ft.push(ut),ft.push(["L",k.x,k.y]),ft}}});var __extends$21=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),getStartAndEndRadians=centeredSeriesMixin.getStartAndEndRadians,noop$g=H.noop,clamp$d=Utilities.clamp,extend$18=Utilities.extend,fireEvent$n=Utilities.fireEvent,merge$Z=Utilities.merge,pick$15=Utilities.pick,relativeLength$4=Utilities.relativeLength,PieSeries$3=function(j){__extends$21(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.center=void 0,a.data=void 0,a.maxLabelDistance=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.animate=function(a){var k=this,tt=k.points,et=k.startAngleRad;a||tt.forEach(function(rt){var nt=rt.graphic,ot=rt.shapeArgs;nt&&ot&&(nt.attr({r:pick$15(rt.startR,k.center&&k.center[3]/2),start:et,end:et}),nt.animate({r:ot.r,start:ot.start,end:ot.end},k.options.animation))})},E.prototype.drawEmpty=function(){var a=this.startAngleRad,k=this.endAngleRad,tt=this.options,et,rt;this.total===0&&this.center?(et=this.center[0],rt=this.center[1],this.graph||(this.graph=this.chart.renderer.arc(et,rt,this.center[1]/2,0,a,k).addClass("highcharts-empty-series").add(this.group)),this.graph.attr({d:Symbols.arc(et,rt,this.center[2]/2,0,{start:a,end:k,innerR:this.center[3]/2})}),this.chart.styledMode||this.graph.attr({"stroke-width":tt.borderWidth,fill:tt.fillColor||"none",stroke:tt.color||palette.neutralColor20})):this.graph&&(this.graph=this.graph.destroy())},E.prototype.drawPoints=function(){var a=this.chart.renderer;this.points.forEach(function(k){k.graphic&&k.hasNewShapeType()&&(k.graphic=k.graphic.destroy()),k.graphic||(k.graphic=a[k.shapeType](k.shapeArgs).add(k.series.group),k.delayedRendering=!0)})},E.prototype.generatePoints=function(){j.prototype.generatePoints.call(this),this.updateTotals()},E.prototype.getX=function(a,k,tt){var et=this.center,rt=this.radii?this.radii[tt.index]||0:et[2]/2,nt=Math.asin(clamp$d((a-et[1])/(rt+tt.labelDistance),-1,1)),ot=et[0]+(k?-1:1)*(Math.cos(nt)*(rt+tt.labelDistance))+(tt.labelDistance>0?(k?-1:1)*this.options.dataLabels.padding:0);return ot},E.prototype.hasData=function(){return!!this.processedXData.length},E.prototype.redrawPoints=function(){var a=this,k=a.chart,tt=k.renderer,et=a.options.shadow,rt,nt,ot,st;this.drawEmpty(),et&&!a.shadowGroup&&!k.styledMode&&(a.shadowGroup=tt.g("shadow").attr({zIndex:-1}).add(a.group)),a.points.forEach(function(lt){var ht={};if(nt=lt.graphic,!lt.isNull&&nt){var ut=void 0;st=lt.shapeArgs,rt=lt.getTranslate(),k.styledMode||(ut=lt.shadowGroup,et&&!ut&&(ut=lt.shadowGroup=tt.g("shadow").add(a.shadowGroup)),ut&&ut.attr(rt),ot=a.pointAttribs(lt,lt.selected&&"select")),lt.delayedRendering?(nt.setRadialReference(a.center).attr(st).attr(rt),k.styledMode||nt.attr(ot).attr({"stroke-linejoin":"round"}).shadow(et,ut),lt.delayedRendering=!1):(nt.setRadialReference(a.center),k.styledMode||merge$Z(!0,ht,ot),merge$Z(!0,ht,st,rt),nt.animate(ht)),nt.attr({visibility:lt.visible?"inherit":"hidden"}),nt.addClass(lt.getClassName(),!0)}else nt&&(lt.graphic=nt.destroy())})},E.prototype.sortByAngle=function(a,k){a.sort(function(tt,et){return typeof tt.angle<"u"&&(et.angle-tt.angle)*k})},E.prototype.translate=function(a){this.generatePoints();var k=this,tt=1e3,et=k.options,rt=et.slicedOffset,nt=rt+(et.borderWidth||0),ot=getStartAndEndRadians(et.startAngle,et.endAngle),st=k.startAngleRad=ot.start,lt=k.endAngleRad=ot.end,ht=lt-st,ut=k.points,dt=et.dataLabels.distance,ft=et.ignoreHiddenPoint,pt=ut.length,gt,yt,mt,xt,wt,Mt,At,St,$t=0;for(a||(k.center=a=k.getCenter()),At=0;At<pt;At++){St=ut[At],yt=st+$t*ht,St.isValid()&&(!ft||St.visible)&&($t+=St.percentage/100),mt=st+$t*ht;var Tt={x:a[0],y:a[1],r:a[2]/2,innerR:a[3]/2,start:Math.round(yt*tt)/tt,end:Math.round(mt*tt)/tt};St.shapeType="arc",St.shapeArgs=Tt,St.labelDistance=pick$15(St.options.dataLabels&&St.options.dataLabels.distance,dt),St.labelDistance=relativeLength$4(St.labelDistance,Tt.r),k.maxLabelDistance=Math.max(k.maxLabelDistance||0,St.labelDistance),xt=(mt+yt)/2,xt>1.5*Math.PI?xt-=2*Math.PI:xt<-Math.PI/2&&(xt+=2*Math.PI),St.slicedTranslation={translateX:Math.round(Math.cos(xt)*rt),translateY:Math.round(Math.sin(xt)*rt)},wt=Math.cos(xt)*a[2]/2,Mt=Math.sin(xt)*a[2]/2,St.tooltipPos=[a[0]+wt*.7,a[1]+Mt*.7],St.half=xt<-Math.PI/2||xt>Math.PI/2?1:0,St.angle=xt,gt=Math.min(nt,St.labelDistance/5),St.labelPosition={natural:{x:a[0]+wt+Math.cos(xt)*St.labelDistance,y:a[1]+Mt+Math.sin(xt)*St.labelDistance},final:{},alignment:St.labelDistance<0?"center":St.half?"right":"left",connectorPosition:{breakAt:{x:a[0]+wt+Math.cos(xt)*gt,y:a[1]+Mt+Math.sin(xt)*gt},touchingSliceAt:{x:a[0]+wt,y:a[1]+Mt}}}}fireEvent$n(k,"afterTranslate")},E.prototype.updateTotals=function(){var a=this.points,k=a.length,tt=this.options.ignoreHiddenPoint,et,rt,nt=0;for(et=0;et<k;et++)rt=a[et],rt.isValid()&&(!tt||rt.visible)&&(nt+=rt.y);for(this.total=nt,et=0;et<k;et++)rt=a[et],rt.percentage=nt>0&&(rt.visible||!tt)?rt.y/nt*100:0,rt.total=nt},E.defaultOptions=merge$Z(Series$e.defaultOptions,{center:[null,null],clip:!1,colorByPoint:!0,dataLabels:{allowOverlap:!0,connectorPadding:5,connectorShape:"fixedOffset",crookDistance:"70%",distance:30,enabled:!0,formatter:function(){return this.point.isNull?void 0:this.point.name},softConnector:!0,x:0},fillColor:void 0,ignoreHiddenPoint:!0,inactiveOtherPoints:!0,legendType:"point",marker:null,size:null,showInLegend:!1,slicedOffset:10,stickyTracking:!1,tooltip:{followPointer:!0},borderColor:palette.backgroundColor,borderWidth:1,lineWidth:void 0,states:{hover:{brightness:.1}}}),E}(Series$e);extend$18(PieSeries$3.prototype,{axisTypes:[],directTouch:!0,drawGraph:void 0,drawLegendSymbol:LegendSymbol$1.drawRectangle,drawTracker:ColumnSeries$h.prototype.drawTracker,getCenter:centeredSeriesMixin.getCenter,getSymbol:noop$g,isCartesian:!1,noSharedTooltip:!0,pointAttribs:ColumnSeries$h.prototype.pointAttribs,pointClass:PiePoint$3,requireSorting:!1,searchPoint:noop$g,trackerGroups:["group","dataLabelsGroup"]});SeriesRegistry$1.registerSeriesType("pie",PieSeries$3);var noop$f=H.noop,distribute$1=R.distribute,Series$c=SeriesRegistry$1.series,arrayMax$6=Utilities.arrayMax,clamp$c=Utilities.clamp,defined$A=Utilities.defined,merge$Y=Utilities.merge,pick$14=Utilities.pick,relativeLength$3=Utilities.relativeLength,ColumnDataLabel;(function(j){var E=[],a={radialDistributionY:function(nt){return nt.top+nt.distributeBox.pos},radialDistributionX:function(nt,ot,st,lt){return nt.getX(st<ot.top+2||st>ot.bottom-2?lt:st,ot.half,ot)},justify:function(nt,ot,st){return st[0]+(nt.half?-1:1)*(ot+nt.labelDistance)},alignToPlotEdges:function(nt,ot,st,lt){var ht=nt.getBBox().width;return ot?ht+lt:st-ht-lt},alignToConnectors:function(nt,ot,st,lt){var ht=0,ut;return nt.forEach(function(dt){ut=dt.dataLabel.getBBox().width,ut>ht&&(ht=ut)}),ot?ht+lt:st-ht-lt}};function k(nt){if(DataLabel$1.compose(Series$c),E.indexOf(nt)===-1){E.push(nt);var ot=nt.prototype;ot.dataLabelPositioners=a,ot.alignDataLabel=noop$f,ot.drawDataLabels=tt,ot.placeDataLabels=et,ot.verifyDataLabelOverflow=rt}}j.compose=k;function tt(){var nt=this,ot=nt.data,st=nt.chart,lt=nt.options.dataLabels||{},ht=lt.connectorPadding,ut=st.plotWidth,dt=st.plotHeight,ft=st.plotLeft,pt=Math.round(st.chartWidth/3),gt=nt.center,yt=gt[2]/2,mt=gt[1],xt=[[],[]],wt=[0,0,0,0],Mt=nt.dataLabelPositioners,At,St,$t,Tt,Pt,It,Lt,Nt,Ht,jt,Dt,Ft;!nt.visible||!lt.enabled&&!nt._hasPointLabels||(ot.forEach(function(kt){kt.dataLabel&&kt.visible&&kt.dataLabel.shortened&&(kt.dataLabel.attr({width:"auto"}).css({width:"auto",textOverflow:"clip"}),kt.dataLabel.shortened=!1)}),Series$c.prototype.drawDataLabels.apply(nt),ot.forEach(function(kt){kt.dataLabel&&(kt.visible?(xt[kt.half].push(kt),kt.dataLabel._pos=null,!defined$A(lt.style.width)&&!defined$A(kt.options.dataLabels&&kt.options.dataLabels.style&&kt.options.dataLabels.style.width)&&kt.dataLabel.getBBox().width>pt&&(kt.dataLabel.css({width:Math.round(pt*.7)+"px"}),kt.dataLabel.shortened=!0)):(kt.dataLabel=kt.dataLabel.destroy(),kt.dataLabels&&kt.dataLabels.length===1&&delete kt.dataLabels))}),xt.forEach(function(kt,Bt){var Gt=kt.length,Yt=[],Vt,qt,Xt,Kt,Jt,de;if(Gt)for(nt.sortByAngle(kt,Bt-.5),nt.maxLabelDistance>0&&(Vt=Math.max(0,mt-yt-nt.maxLabelDistance),qt=Math.min(mt+yt+nt.maxLabelDistance,st.plotHeight),kt.forEach(function(te){te.labelDistance>0&&te.dataLabel&&(te.top=Math.max(0,mt-yt-te.labelDistance),te.bottom=Math.min(mt+yt+te.labelDistance,st.plotHeight),Jt=te.dataLabel.getBBox().height||21,te.distributeBox={target:te.labelPosition.natural.y-te.top+Jt/2,size:Jt,rank:te.y},Yt.push(te.distributeBox))}),de=qt+Jt-Vt,distribute$1(Yt,de,de/5)),Dt=0;Dt<Gt;Dt++){if(At=kt[Dt],It=At.labelPosition,Tt=At.dataLabel,jt=At.visible===!1?"hidden":"inherit",Xt=It.natural.y,Ht=Xt,Yt&&defined$A(At.distributeBox)&&(typeof At.distributeBox.pos>"u"?jt="hidden":(Lt=At.distributeBox.size,Ht=Mt.radialDistributionY(At))),delete At.positionIndex,lt.justify)Nt=Mt.justify(At,yt,gt);else switch(lt.alignTo){case"connectors":Nt=Mt.alignToConnectors(kt,Bt,ut,ft);break;case"plotEdges":Nt=Mt.alignToPlotEdges(Tt,Bt,ut,ft);break;default:Nt=Mt.radialDistributionX(nt,At,Ht,Xt)}Tt._attr={visibility:jt,align:It.alignment},Ft=At.options.dataLabels||{},Tt._pos={x:Nt+pick$14(Ft.x,lt.x)+({left:ht,right:-ht}[It.alignment]||0),y:Ht+pick$14(Ft.y,lt.y)-10},It.final.x=Nt,It.final.y=Ht,pick$14(lt.crop,!0)&&(Pt=Tt.getBBox().width,Kt=null,Nt-Pt<ht&&Bt===1?(Kt=Math.round(Pt-Nt+ht),wt[3]=Math.max(Kt,wt[3])):Nt+Pt>ut-ht&&Bt===0&&(Kt=Math.round(Nt+Pt-ut+ht),wt[1]=Math.max(Kt,wt[1])),Ht-Lt/2<0?wt[0]=Math.max(Math.round(-Ht+Lt/2),wt[0]):Ht+Lt/2>dt&&(wt[2]=Math.max(Math.round(Ht+Lt/2-dt),wt[2])),Tt.sideOverflow=Kt)}}),(arrayMax$6(wt)===0||this.verifyDataLabelOverflow(wt))&&(this.placeDataLabels(),this.points.forEach(function(kt){if(Ft=merge$Y(lt,kt.options.dataLabels),St=pick$14(Ft.connectorWidth,1),St){var Bt=void 0;$t=kt.connector,Tt=kt.dataLabel,Tt&&Tt._pos&&kt.visible&&kt.labelDistance>0?(jt=Tt._attr.visibility,Bt=!$t,Bt&&(kt.connector=$t=st.renderer.path().addClass("highcharts-data-label-connector  highcharts-color-"+kt.colorIndex+(kt.className?" "+kt.className:"")).add(nt.dataLabelsGroup),st.styledMode||$t.attr({"stroke-width":St,stroke:Ft.connectorColor||kt.color||palette.neutralColor60})),$t[Bt?"attr":"animate"]({d:kt.getConnectorPath()}),$t.attr("visibility",jt)):$t&&(kt.connector=$t.destroy())}})))}function et(){this.points.forEach(function(nt){var ot=nt.dataLabel,st;ot&&nt.visible&&(st=ot._pos,st?(ot.sideOverflow&&(ot._attr.width=Math.max(ot.getBBox().width-ot.sideOverflow,0),ot.css({width:ot._attr.width+"px",textOverflow:(this.options.dataLabels.style||{}).textOverflow||"ellipsis"}),ot.shortened=!0),ot.attr(ot._attr),ot[ot.moved?"animate":"attr"](st),ot.moved=!0):ot&&ot.attr({y:-9999})),delete nt.distributeBox},this)}function rt(nt){var ot=this.center,st=this.options,lt=st.center,ht=st.minSize||80,ut=ht,dt=st.size!==null;return dt||(lt[0]!==null?ut=Math.max(ot[2]-Math.max(nt[1],nt[3]),ht):(ut=Math.max(ot[2]-nt[1]-nt[3],ht),ot[0]+=(nt[3]-nt[1])/2),lt[1]!==null?ut=clamp$c(ut,ht,ot[2]-Math.max(nt[0],nt[2])):(ut=clamp$c(ut,ht,ot[2]-nt[0]-nt[2]),ot[1]+=(nt[0]-nt[2])/2),ut<ot[2]?(ot[2]=ut,ot[3]=Math.min(relativeLength$3(st.innerSize||0,ut),ut),this.translate(ot),this.drawDataLabels&&this.drawDataLabels()):dt=!0),dt}})(ColumnDataLabel||(ColumnDataLabel={}));const PieDataLabel=ColumnDataLabel;var addEvent$N=Utilities.addEvent,fireEvent$m=Utilities.fireEvent,isArray$b=Utilities.isArray,isNumber$u=Utilities.isNumber,objectEach$g=Utilities.objectEach,pick$13=Utilities.pick;addEvent$N(Chart$1,"render",function(){var E=this,a=[];(this.labelCollectors||[]).forEach(function(k){a=a.concat(k())}),(this.yAxis||[]).forEach(function(k){k.stacking&&k.options.stackLabels&&!k.options.stackLabels.allowOverlap&&objectEach$g(k.stacking.stacks,function(tt){objectEach$g(tt,function(et){et.label&&et.label.visibility!=="hidden"&&a.push(et.label)})})}),(this.series||[]).forEach(function(k){var tt=k.options.dataLabels;if(k.visible&&!(tt.enabled===!1&&!k._hasPointLabels)){var et=function(rt){return rt.forEach(function(nt){if(nt.visible){var ot=isArray$b(nt.dataLabels)?nt.dataLabels:nt.dataLabel?[nt.dataLabel]:[];ot.forEach(function(st){var lt=st.options;st.labelrank=pick$13(lt.labelrank,nt.labelrank,nt.shapeArgs&&nt.shapeArgs.height),lt.allowOverlap?(st.oldOpacity=st.opacity,st.newOpacity=1,hideOrShow(st,E)):a.push(st)})}})};et(k.nodes||[]),et(k.points)}}),this.hideOverlappingLabels(a)});Chart$1.prototype.hideOverlappingLabels=function(j){var E=this,a=j.length,k=E.renderer,tt,et,rt,nt,ot,st,lt,ht=!1,ut=function(ft,pt){return!(pt.x>=ft.x+ft.width||pt.x+pt.width<=ft.x||pt.y>=ft.y+ft.height||pt.y+pt.height<=ft.y)},dt=function(ft){var pt,gt,yt,mt=ft.box?0:ft.padding||0,xt=0,wt=0,Mt,At;if(ft&&(!ft.alignAttr||ft.placed))return pt=ft.alignAttr||{x:ft.attr("x"),y:ft.attr("y")},gt=ft.parentGroup,ft.width||(yt=ft.getBBox(),ft.width=yt.width,ft.height=yt.height,xt=k.fontMetrics(null,ft.element).h),Mt=ft.width-2*mt,At={left:"0",center:"0.5",right:"1"}[ft.alignValue],At?wt=+At*Mt:isNumber$u(ft.x)&&Math.round(ft.x)!==ft.translateX&&(wt=ft.x-ft.translateX),{x:pt.x+(gt.translateX||0)+mt-(wt||0),y:pt.y+(gt.translateY||0)+mt-xt,width:ft.width-2*mt,height:ft.height-2*mt}};for(et=0;et<a;et++)tt=j[et],tt&&(tt.oldOpacity=tt.opacity,tt.newOpacity=1,tt.absoluteBox=dt(tt));for(j.sort(function(ft,pt){return(pt.labelrank||0)-(ft.labelrank||0)}),et=0;et<a;et++)for(nt=j[et],st=nt&&nt.absoluteBox,rt=et+1;rt<a;++rt)ot=j[rt],lt=ot&&ot.absoluteBox,st&&lt&&nt!==ot&&nt.newOpacity!==0&&ot.newOpacity!==0&&ut(st,lt)&&((nt.labelrank<ot.labelrank?nt:ot).newOpacity=0);j.forEach(function(ft){hideOrShow(ft,E)&&(ht=!0)}),ht&&fireEvent$m(E,"afterHideAllOverlappingLabels")};function hideOrShow(j,E){var a,k,tt=!1;return j&&(k=j.newOpacity,j.oldOpacity!==k&&(j.alignAttr&&j.placed?(j[k?"removeClass":"addClass"]("highcharts-data-label-hidden"),a=function(){E.styledMode||j.css({pointerEvents:k?"auto":"none"})},tt=!0,j.alignAttr.opacity=k,j[j.isOld?"animate":"attr"](j.alignAttr,null,a),fireEvent$m(E,"afterHideOverlappingLabel")):j.attr({opacity:k})),j.isOld=!0),tt}var extend$17=Utilities.extend,find$e=Utilities.find,isArray$a=Utilities.isArray,isObject$8=Utilities.isObject,merge$X=Utilities.merge,objectEach$f=Utilities.objectEach,pick$12=Utilities.pick,splat$a=Utilities.splat,uniqueKey$3=Utilities.uniqueKey,Responsive;(function(j){var E=[];function a(tt){return E.indexOf(tt)===-1&&(E.push(tt),extend$17(tt.prototype,k.prototype)),tt}j.compose=a;var k=function(){function tt(){}return tt.prototype.currentOptions=function(et){var rt=this,nt={};function ot(st,lt,ht,ut){var dt;objectEach$f(st,function(ft,pt){if(!ut&&rt.collectionsWithUpdate.indexOf(pt)>-1&&lt[pt])for(ft=splat$a(ft),ht[pt]=[],dt=0;dt<Math.max(ft.length,lt[pt].length);dt++)lt[pt][dt]&&(ft[dt]===void 0?ht[pt][dt]=lt[pt][dt]:(ht[pt][dt]={},ot(ft[dt],lt[pt][dt],ht[pt][dt],ut+1)));else isObject$8(ft)?(ht[pt]=isArray$a(ft)?[]:{},ot(ft,lt[pt]||{},ht[pt],ut+1)):typeof lt[pt]>"u"?ht[pt]=null:ht[pt]=lt[pt]})}return ot(et,this.options,nt,0),nt},tt.prototype.matchResponsiveRule=function(et,rt){var nt=et.condition,ot=nt.callback||function(){return this.chartWidth<=pick$12(nt.maxWidth,Number.MAX_VALUE)&&this.chartHeight<=pick$12(nt.maxHeight,Number.MAX_VALUE)&&this.chartWidth>=pick$12(nt.minWidth,0)&&this.chartHeight>=pick$12(nt.minHeight,0)};ot.call(this)&&rt.push(et._id)},tt.prototype.setResponsive=function(et,rt){var nt=this,ot=this.options.responsive,st=this.currentResponsive,lt=[],ht;!rt&&ot&&ot.rules&&ot.rules.forEach(function(ft){typeof ft._id>"u"&&(ft._id=uniqueKey$3()),nt.matchResponsiveRule(ft,lt)},this);var ut=merge$X.apply(void 0,lt.map(function(ft){return find$e((ot||{}).rules||[],function(pt){return pt._id===ft})}).map(function(ft){return ft&&ft.chartOptions}));ut.isResponsiveOptions=!0,lt=lt.toString()||void 0;var dt=st&&st.ruleIds;lt!==dt&&(st&&this.update(st.undoOptions,et,!0),lt?(ht=this.currentOptions(ut),ht.isResponsiveOptions=!0,this.currentResponsive={ruleIds:lt,mergedOptions:ut,undoOptions:ht},this.update(ut,et,!0)):this.currentResponsive=void 0)},tt}()})(Responsive||(Responsive={}));const Responsive$1=Responsive;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$7=H;G$7.animate=animationExports.animate;G$7.animObject=animationExports.animObject;G$7.getDeferredAnimation=animationExports.getDeferredAnimation;G$7.setAnimation=animationExports.setAnimation;G$7.stop=animationExports.stop;G$7.timers=Fx.timers;G$7.AST=AST;G$7.Axis=Axis;G$7.Chart=Chart$1;G$7.chart=Chart$1.chart;G$7.Fx=Fx;G$7.Legend=Legend;G$7.PlotLineOrBand=PlotLineOrBand;G$7.Point=Point$5;G$7.Pointer=MSPointer.isRequired()?MSPointer:Pointer;G$7.Series=Series$e;G$7.SVGElement=SVGElement;G$7.SVGRenderer=SVGRenderer;G$7.Tick=Tick;G$7.Time=Time;G$7.Tooltip=Tooltip;G$7.Color=Color;G$7.color=Color.parse;HTMLRenderer.compose(SVGRenderer);HTMLElement$1.compose(SVGElement);G$7.defaultOptions=DefaultOptions.defaultOptions;G$7.getOptions=DefaultOptions.getOptions;G$7.time=DefaultOptions.defaultTime;G$7.setOptions=DefaultOptions.setOptions;G$7.dateFormat=FormatUtilities.dateFormat;G$7.format=FormatUtilities.format;G$7.numberFormat=FormatUtilities.numberFormat;G$7.addEvent=Utilities.addEvent;G$7.arrayMax=Utilities.arrayMax;G$7.arrayMin=Utilities.arrayMin;G$7.attr=Utilities.attr;G$7.clearTimeout=Utilities.clearTimeout;G$7.correctFloat=Utilities.correctFloat;G$7.createElement=Utilities.createElement;G$7.css=Utilities.css;G$7.defined=Utilities.defined;G$7.destroyObjectProperties=Utilities.destroyObjectProperties;G$7.discardElement=Utilities.discardElement;G$7.distribute=R.distribute;G$7.erase=Utilities.erase;G$7.error=Utilities.error;G$7.extend=Utilities.extend;G$7.extendClass=Utilities.extendClass;G$7.find=Utilities.find;G$7.fireEvent=Utilities.fireEvent;G$7.getMagnitude=Utilities.getMagnitude;G$7.getStyle=Utilities.getStyle;G$7.inArray=Utilities.inArray;G$7.isArray=Utilities.isArray;G$7.isClass=Utilities.isClass;G$7.isDOMElement=Utilities.isDOMElement;G$7.isFunction=Utilities.isFunction;G$7.isNumber=Utilities.isNumber;G$7.isObject=Utilities.isObject;G$7.isString=Utilities.isString;G$7.keys=Utilities.keys;G$7.merge=Utilities.merge;G$7.normalizeTickInterval=Utilities.normalizeTickInterval;G$7.objectEach=Utilities.objectEach;G$7.offset=Utilities.offset;G$7.pad=Utilities.pad;G$7.pick=Utilities.pick;G$7.pInt=Utilities.pInt;G$7.relativeLength=Utilities.relativeLength;G$7.removeEvent=Utilities.removeEvent;G$7.seriesType=SeriesRegistry$1.seriesType;G$7.splat=Utilities.splat;G$7.stableSort=Utilities.stableSort;G$7.syncTimeout=Utilities.syncTimeout;G$7.timeUnits=Utilities.timeUnits;G$7.uniqueKey=Utilities.uniqueKey;G$7.useSerialIds=Utilities.useSerialIds;G$7.wrap=Utilities.wrap;ColumnDataLabel$2.compose(ColumnSeries$h);DataLabel$1.compose(Series$e);DateTimeAxis$1.compose(Axis);LogarithmicAxis$1.compose(Axis);PieDataLabel.compose(PieSeries$3);PlotLineOrBand.compose(Axis);Responsive$1.compose(Chart$1);var addEvent$M=Utilities.addEvent,correctFloat$8=Utilities.correctFloat,css$3=Utilities.css,defined$z=Utilities.defined,error$3=Utilities.error,pick$11=Utilities.pick,timeUnits=Utilities.timeUnits,composedClasses=[],OrdinalAxis;(function(j){function E(ft,pt,gt){if(composedClasses.indexOf(ft)===-1){composedClasses.push(ft);var yt=ft.prototype;yt.getTimeTicks=a,yt.index2val=k,yt.lin2val=tt,yt.val2lin=ut,yt.ordinal2lin=yt.val2lin,addEvent$M(ft,"afterInit",rt),addEvent$M(ft,"foundExtremes",nt),addEvent$M(ft,"afterSetScale",ot),addEvent$M(ft,"initialAxisTranslation",st)}return composedClasses.indexOf(gt)===-1&&(composedClasses.push(gt),addEvent$M(gt,"pan",lt)),composedClasses.indexOf(pt)===-1&&(composedClasses.push(pt),addEvent$M(pt,"updatedData",ht)),ft}j.compose=E;function a(ft,pt,gt,yt,mt,xt,wt){mt===void 0&&(mt=[]),xt===void 0&&(xt=0);var Mt={},At=this.options.tickPixelInterval,St=this.chart.time,$t=[],Tt,Pt,It,Lt,Nt,Ht=0,jt=[],Dt=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!mt||mt.length<3||typeof pt>"u")return St.getTimeTicks.apply(St,arguments);var Ft=mt.length;for(Tt=0;Tt<Ft;Tt++){if(Nt=Tt&&mt[Tt-1]>gt,mt[Tt]<pt&&(Ht=Tt),Tt===Ft-1||mt[Tt+1]-mt[Tt]>xt*5||Nt){if(mt[Tt]>Dt){for(Pt=St.getTimeTicks(ft,mt[Ht],mt[Tt],yt);Pt.length&&Pt[0]<=Dt;)Pt.shift();Pt.length&&(Dt=Pt[Pt.length-1]),$t.push(jt.length),jt=jt.concat(Pt)}Ht=Tt+1}if(Nt)break}if(Pt){if(Lt=Pt.info,wt&&Lt.unitRange<=timeUnits.hour){for(Tt=jt.length-1,Ht=1;Ht<Tt;Ht++)St.dateFormat("%d",jt[Ht])!==St.dateFormat("%d",jt[Ht-1])&&(Mt[jt[Ht]]="day",It=!0);It&&(Mt[jt[0]]="day"),Lt.higherRanks=Mt}Lt.segmentStarts=$t,jt.info=Lt}else error$3(12,!1,this.chart);if(wt&&defined$z(At)){for(var kt=jt.length,Bt=[],Gt=[],Yt=void 0,Vt=void 0,qt=void 0,Xt=void 0,Kt=void 0,Jt=kt;Jt--;)Vt=this.translate(jt[Jt]),qt&&(Gt[Jt]=qt-Vt),Bt[Jt]=qt=Vt;for(Gt.sort(),Xt=Gt[Math.floor(Gt.length/2)],Xt<At*.6&&(Xt=null),Jt=jt[kt-1]>gt?kt-1:kt,qt=void 0;Jt--;)Vt=Bt[Jt],Kt=Math.abs(qt-Vt),qt&&Kt<At*.8&&(Xt===null||Kt<Xt*.8)?(Mt[jt[Jt]]&&!Mt[jt[Jt+1]]?(Yt=Jt+1,qt=Vt):Yt=Jt,jt.splice(Yt,1)):qt=Vt}return jt}function k(ft){var pt=this,gt=pt.ordinal,yt=gt.positions;if(!yt)return ft;var mt=yt.length-1,xt;return ft<0?ft=yt[0]:ft>mt?ft=yt[mt]:(mt=Math.floor(ft),xt=ft-mt),typeof xt<"u"&&typeof yt[mt]<"u"?yt[mt]+(xt?xt*(yt[mt+1]-yt[mt]):0):ft}function tt(ft){var pt=this,gt=pt.ordinal,yt=pt.old?pt.old.min:pt.min,mt=pt.old?pt.old.transA:pt.transA,xt=gt.positions;if(!xt)return ft;var wt=(ft-yt)*mt+pt.minPixelPadding,Mt=wt>0&&wt<pt.left+pt.len;if(Mt||(gt.extendedOrdinalPositions||(gt.extendedOrdinalPositions=gt.getExtendedPositions()),xt=gt.extendedOrdinalPositions),xt&&xt.length){var At=gt.getIndexOfPoint(wt,xt),St=correctFloat$8(At%1);if(At>=0&&At<xt.length){var $t=xt[Math.floor(At)],Tt=xt[Math.ceil(At)],Pt=Tt-$t;return xt[Math.floor(At)]+St*Pt}var It=xt.length,Lt=xt[0],Nt=xt[It-1],Ht=(Nt-Lt)/(It-1);return At<0?Lt+Ht*At:Nt+Ht*(At-It)}return ft}function et(ft,pt){var gt=j.Additions.findIndexOf(ft,pt,!0);if(ft[gt]===pt)return gt;var yt=(pt-ft[gt])/(ft[gt+1]-ft[gt]);return gt+yt}function rt(){var ft=this;ft.ordinal||(ft.ordinal=new j.Additions(ft))}function nt(){var ft=this;ft.isXAxis&&defined$z(ft.options.overscroll)&&ft.max===ft.dataMax&&(!ft.chart.mouseIsDown||ft.isInternal)&&(!ft.eventArgs||ft.eventArgs&&ft.eventArgs.trigger!=="navigator")&&(ft.max+=ft.options.overscroll,!ft.isInternal&&defined$z(ft.userMin)&&(ft.min+=ft.options.overscroll))}function ot(){var ft=this;ft.horiz&&!ft.isDirty&&(ft.isDirty=ft.isOrdinal&&ft.chart.navigator&&!ft.chart.navigator.adaptToUpdatedData)}function st(){var ft=this;ft.ordinal&&(ft.ordinal.beforeSetTickPositions(),ft.tickInterval=ft.ordinal.postProcessTickInterval(ft.tickInterval))}function lt(ft){var pt=this,gt=pt.xAxis[0],yt=gt.options.overscroll,mt=ft.originalEvent.chartX,xt=pt.options.chart.panning,wt=!1;if(xt&&xt.type!=="y"&&gt.options.ordinal&&gt.series.length){var Mt=pt.mouseDownX,At=gt.getExtremes(),St=At.dataMax,$t=At.min,Tt=At.max,Pt=pt.hoverPoints,It=gt.closestPointRange||gt.ordinal&&gt.ordinal.overscrollPointsRange,Lt=gt.translationSlope*(gt.ordinal.slope||It),Nt=(Mt-mt)/Lt,Ht={ordinal:{positions:gt.ordinal.getExtendedPositions()}},jt=gt.index2val,Dt=gt.val2lin,Ft=void 0,kt=void 0,Bt=void 0,Gt=void 0;Ht.ordinal.positions?Math.abs(Nt)>1&&(Pt&&Pt.forEach(function(Yt){Yt.setState()}),Nt<0?(Bt=Ht,Gt=gt.ordinal.positions?gt:Ht):(Bt=gt.ordinal.positions?gt:Ht,Gt=Ht),kt=Gt.ordinal.positions,St>kt[kt.length-1]&&kt.push(St),pt.fixedRange=Tt-$t,Ft=gt.navigatorAxis.toFixedRange(null,null,jt.apply(Bt,[Dt.apply(Bt,[$t,!0])+Nt]),jt.apply(Gt,[Dt.apply(Gt,[Tt,!0])+Nt])),Ft.min>=Math.min(At.dataMin,$t)&&Ft.max<=Math.max(St,Tt)+yt&&gt.setExtremes(Ft.min,Ft.max,!0,!1,{trigger:"pan"}),pt.mouseDownX=mt,css$3(pt.container,{cursor:"move"})):wt=!0}else wt=!0;wt||xt&&/y/.test(xt.type)?yt&&(gt.max=gt.dataMax+yt):ft.preventDefault()}function ht(){var ft=this.xAxis;ft&&ft.options.ordinal&&(delete ft.ordinal.index,delete ft.ordinal.extendedOrdinalPositions)}function ut(ft,pt){var gt=this,yt=gt.ordinal,mt=yt.positions,xt=yt.slope,wt=yt.extendedOrdinalPositions;if(!mt)return ft;var Mt=mt.length,At;if(mt[0]<=ft&&mt[Mt-1]>=ft)At=et(mt,ft);else{if(wt||(wt=yt.getExtendedPositions&&yt.getExtendedPositions(),yt.extendedOrdinalPositions=wt),!(wt&&wt.length))return ft;var St=wt.length;xt||(xt=(wt[St-1]-wt[0])/St);var $t=et(wt,mt[0]);if(ft>=wt[0]&&ft<=wt[St-1])At=et(wt,ft)-$t;else if(ft<wt[0]){var Tt=wt[0]-ft,Pt=Tt/xt;At=-$t-Pt}else{var Tt=ft-wt[St-1],Pt=Tt/xt;At=Pt+St-$t}}return pt?At:xt*(At||0)+yt.offset}var dt=function(){function ft(pt){this.index={},this.axis=pt}return ft.prototype.beforeSetTickPositions=function(){var pt=this.axis,gt=pt.ordinal,yt=pt.getExtremes(),mt=yt.min,xt=yt.max,wt=pt.isXAxis&&!!pt.options.breaks,Mt=pt.options.ordinal,At=pt.chart.options.chart.ignoreHiddenSeries,St,$t,Tt,Pt,It,Lt,Nt,Ht,jt=[],Dt=Number.MAX_VALUE,Ft=!1;if(Mt||wt){if(pt.series.forEach(function(kt,Bt){if($t=[],(!At||kt.visible!==!1)&&(kt.takeOrdinalPosition!==!1||wt)&&(jt=jt.concat(kt.processedXData),St=jt.length,jt.sort(function(Gt,Yt){return Gt-Yt}),Dt=Math.min(Dt,pick$11(kt.closestPointRange,Dt)),St)){for(Bt=0;Bt<St-1;)jt[Bt]!==jt[Bt+1]&&$t.push(jt[Bt+1]),Bt++;$t[0]!==jt[0]&&$t.unshift(jt[0]),jt=$t}kt.isSeriesBoosting&&(Ht=!0)}),Ht&&(jt.length=0),St=jt.length,St>2){for(Tt=jt[1]-jt[0],Nt=St-1;Nt--&&!Ft;)jt[Nt+1]-jt[Nt]!==Tt&&(Ft=!0);!pt.options.keepOrdinalPadding&&(jt[0]-mt>Tt||xt-jt[jt.length-1]>Tt)&&(Ft=!0)}else pt.options.overscroll&&(St===2?Dt=jt[1]-jt[0]:St===1?(Dt=pt.options.overscroll,jt=[jt[0],jt[0]+Dt]):Dt=gt.overscrollPointsRange);Ft||pt.forceOrdinal?(pt.options.overscroll&&(gt.overscrollPointsRange=Dt,jt=jt.concat(gt.getOverscrollPositions())),gt.positions=jt,Pt=pt.ordinal2lin(Math.max(mt,jt[0]),!0),It=Math.max(pt.ordinal2lin(Math.min(xt,jt[jt.length-1]),!0),1),gt.slope=Lt=(xt-mt)/(It-Pt),gt.offset=mt-Pt*Lt):(gt.overscrollPointsRange=pick$11(pt.closestPointRange,gt.overscrollPointsRange),gt.positions=pt.ordinal.slope=gt.offset=void 0)}pt.isOrdinal=Mt&&Ft,gt.groupIntervalFactor=null},ft.findIndexOf=function(pt,gt,yt){for(var mt=0,xt=pt.length-1,wt;mt<xt;)wt=Math.ceil((mt+xt)/2),pt[wt]<=gt?mt=wt:xt=wt-1;return pt[mt]===gt||yt?mt:-1},ft.prototype.getExtendedPositions=function(){var pt=this,gt=pt.axis,yt=gt.constructor.prototype,mt=gt.chart,xt=gt.series[0].currentDataGrouping,wt=xt?xt.count+xt.unitName:"raw",Mt=gt.options.overscroll,At=gt.getExtremes(),St,$t=void 0,Tt=pt.index;return Tt||(Tt=pt.index={}),Tt[wt]||(St={series:[],chart:mt,forceOrdinal:!1,getExtremes:function(){return{min:At.dataMin,max:At.dataMax+Mt}},getGroupPixelWidth:yt.getGroupPixelWidth,getTimeTicks:yt.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:yt.ordinal2lin,getIndexOfPoint:yt.getIndexOfPoint,val2lin:yt.val2lin},St.ordinal.axis=St,gt.series.forEach(function(Pt){$t={xAxis:St,xData:Pt.xData.slice(),chart:mt,destroyGroupedData:H.noop,getProcessedData:Series$e.prototype.getProcessedData,applyGrouping:Series$e.prototype.applyGrouping},$t.xData=$t.xData.concat(pt.getOverscrollPositions()),$t.options={dataGrouping:xt?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[xt.unitName,[xt.count]]]}:{enabled:!1}},St.series.push($t),Pt.processData.apply($t)}),gt.applyGrouping.call(St),$t.closestPointRange!==$t.basePointRange&&$t.currentDataGrouping&&(St.forceOrdinal=!0),gt.ordinal.beforeSetTickPositions.apply({axis:St}),Tt[wt]=St.ordinal.positions),Tt[wt]},ft.prototype.getGroupIntervalFactor=function(pt,gt,yt){var mt=this;mt.axis;var xt=yt.processedXData,wt=xt.length,Mt=[],At,St,$t=mt.groupIntervalFactor;if(!$t){for(St=0;St<wt-1;St++)Mt[St]=xt[St+1]-xt[St];Mt.sort(function(Tt,Pt){return Tt-Pt}),At=Mt[Math.floor(wt/2)],pt=Math.max(pt,xt[0]),gt=Math.min(gt,xt[wt-1]),mt.groupIntervalFactor=$t=wt*At/(gt-pt)}return $t},ft.prototype.getIndexOfPoint=function(pt,gt){var yt=this,mt=yt.axis,xt=yt.positions?yt.positions[0]:0,wt=mt.series[0].points&&mt.series[0].points[0]&&mt.series[0].points[0].plotX||mt.minPixelPadding;mt.series.length>1&&mt.series.forEach(function(St){defined$z(St.points[0])&&defined$z(St.points[0].plotX)&&St.points[0].plotX<wt&&(wt=St.points[0].plotX)});var Mt=mt.translationSlope*(yt.slope||mt.closestPointRange||yt.overscrollPointsRange),At=(pt-wt)/Mt;return ft.findIndexOf(gt,xt)+At},ft.prototype.getOverscrollPositions=function(){var pt=this,gt=pt.axis,yt=gt.options.overscroll,mt=pt.overscrollPointsRange,xt=[],wt=gt.dataMax;if(defined$z(mt))for(;wt<=gt.dataMax+yt;)wt+=mt,xt.push(wt);return xt},ft.prototype.postProcessTickInterval=function(pt){var gt=this,yt=gt.axis,mt=gt.slope,xt;return mt?yt.options.breaks?xt=yt.closestPointRange||pt:xt=pt/(mt/yt.closestPointRange):xt=pt,xt},ft}();j.Additions=dt})(OrdinalAxis||(OrdinalAxis={}));const OrdinalAxis$1=OrdinalAxis;var addEvent$L=Utilities.addEvent,find$d=Utilities.find,fireEvent$l=Utilities.fireEvent,isArray$9=Utilities.isArray,isNumber$t=Utilities.isNumber,pick$10=Utilities.pick,BrokenAxis;(function(j){var E=[];function a(ut,dt){if(E.indexOf(ut)===-1&&(E.push(ut),ut.keepProps.push("brokenAxis"),addEvent$L(ut,"init",rt),addEvent$L(ut,"afterInit",k),addEvent$L(ut,"afterSetTickPositions",et),addEvent$L(ut,"afterSetOptions",tt)),E.indexOf(dt)===-1){E.push(dt);var ft=dt.prototype;ft.drawBreaks=st,ft.gappedPath=lt,addEvent$L(dt,"afterGeneratePoints",nt),addEvent$L(dt,"afterRender",ot)}return ut}j.compose=a;function k(){typeof this.brokenAxis<"u"&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function tt(){var ut=this;ut.brokenAxis&&ut.brokenAxis.hasBreaks&&(ut.options.ordinal=!1)}function et(){var ut=this,dt=ut.brokenAxis;if(dt&&dt.hasBreaks){for(var ft=ut.tickPositions,pt=ut.tickPositions.info,gt=[],yt=0;yt<ft.length;yt++)dt.isInAnyBreak(ft[yt])||gt.push(ft[yt]);ut.tickPositions=gt,ut.tickPositions.info=pt}}function rt(){var ut=this;ut.brokenAxis||(ut.brokenAxis=new ht(ut))}function nt(){var ut=this,dt=ut.isDirty,ft=ut.options.connectNulls,pt=ut.points,gt=ut.xAxis,yt=ut.yAxis;if(dt)for(var mt=pt.length;mt--;){var xt=pt[mt],wt=xt.y===null&&ft===!1,Mt=!wt&&(gt&&gt.brokenAxis&&gt.brokenAxis.isInAnyBreak(xt.x,!0)||yt&&yt.brokenAxis&&yt.brokenAxis.isInAnyBreak(xt.y,!0));xt.visible=Mt?!1:xt.options.visible!==!1}}function ot(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,pick$10(this.pointArrayMap,["y"]))}function st(ut,dt){var ft=this,pt=ft.points,gt,yt,mt,xt;if(ut&&ut.brokenAxis&&ut.brokenAxis.hasBreaks){var wt=ut.brokenAxis;dt.forEach(function(Mt){gt=wt&&wt.breakArray||[],yt=ut.isXAxis?ut.min:pick$10(ft.options.threshold,ut.min),pt.forEach(function(At){xt=pick$10(At["stack"+Mt.toUpperCase()],At[Mt]),gt.forEach(function(St){isNumber$t(yt)&&isNumber$t(xt)&&(mt=!1,yt<St.from&&xt>St.to||yt>St.from&&xt<St.from?mt="pointBreak":(yt<St.from&&xt>St.from&&xt<St.to||yt>St.from&&xt>St.to&&xt<St.from)&&(mt="pointInBreak"),mt&&fireEvent$l(ut,mt,{point:At,brk:St}))})})})}}function lt(){var ut=this.currentDataGrouping,dt=ut&&ut.gapSize,ft=this.points.slice(),pt=this.yAxis,gt=this.options.gapSize,yt=ft.length-1,mt;if(gt&&yt>0){this.options.gapUnit!=="value"&&(gt*=this.basePointRange),dt&&dt>gt&&dt>=this.basePointRange&&(gt=dt);for(var xt=void 0,wt=void 0;yt--;)if(wt&&wt.visible!==!1||(wt=ft[yt+1]),xt=ft[yt],!(wt.visible===!1||xt.visible===!1)){if(wt.x-xt.x>gt){var Mt=(xt.x+wt.x)/2;ft.splice(yt+1,0,{isNull:!0,x:Mt}),pt.stacking&&this.options.stacking&&(mt=pt.stacking.stacks[this.stackKey][Mt]=new StackItem$1(pt,pt.options.stackLabels,!1,Mt,this.stack),mt.total=0)}wt=xt}}return this.getGraphPath(ft)}var ht=function(){function ut(dt){this.hasBreaks=!1,this.axis=dt}return ut.isInBreak=function(dt,ft){var pt=dt.repeat||1/0,gt=dt.from,yt=dt.to-dt.from,mt=ft>=gt?(ft-gt)%pt:pt-(gt-ft)%pt,xt;return dt.inclusive?xt=mt<=yt:xt=mt<yt&&mt!==0,xt},ut.lin2Val=function(dt){var ft=this,pt=ft.brokenAxis,gt=pt&&pt.breakArray;if(!gt||!isNumber$t(dt))return dt;var yt=dt,mt,xt;for(xt=0;xt<gt.length&&(mt=gt[xt],!(mt.from>=yt));xt++)(mt.to<yt||ut.isInBreak(mt,yt))&&(yt+=mt.len);return yt},ut.val2Lin=function(dt){var ft=this,pt=ft.brokenAxis,gt=pt&&pt.breakArray;if(!gt||!isNumber$t(dt))return dt;var yt=dt,mt,xt;for(xt=0;xt<gt.length;xt++)if(mt=gt[xt],mt.to<=dt)yt-=mt.len;else{if(mt.from>=dt)break;if(ut.isInBreak(mt,dt)){yt-=dt-mt.from;break}}return yt},ut.prototype.findBreakAt=function(dt,ft){return find$d(ft,function(pt){return pt.from<dt&&dt<pt.to})},ut.prototype.isInAnyBreak=function(dt,ft){var pt=this,gt=pt.axis,yt=gt.options.breaks||[],mt=yt.length,xt,wt,Mt;if(mt&&isNumber$t(dt)){for(;mt--;)ut.isInBreak(yt[mt],dt)&&(xt=!0,wt||(wt=pick$10(yt[mt].showPoints,!gt.isXAxis)));xt&&ft?Mt=xt&&!wt:Mt=xt}return Mt},ut.prototype.setBreaks=function(dt,ft){var pt=this,gt=pt.axis,yt=isArray$9(dt)&&!!dt.length;gt.isDirty=pt.hasBreaks!==yt,pt.hasBreaks=yt,gt.options.breaks=gt.userOptions.breaks=dt,gt.forceRedraw=!0,gt.series.forEach(function(mt){mt.isDirty=!0}),!yt&&gt.val2lin===ut.val2Lin&&(delete gt.val2lin,delete gt.lin2val),yt&&(gt.userOptions.ordinal=!1,gt.lin2val=ut.lin2Val,gt.val2lin=ut.val2Lin,gt.setExtremes=function(mt,xt,wt,Mt,At){if(pt.hasBreaks){for(var St=this.options.breaks||[],$t=void 0;$t=pt.findBreakAt(mt,St);)mt=$t.to;for(;$t=pt.findBreakAt(xt,St);)xt=$t.from;xt<mt&&(xt=mt)}gt.constructor.prototype.setExtremes.call(this,mt,xt,wt,Mt,At)},gt.setAxisTranslation=function(){if(gt.constructor.prototype.setAxisTranslation.call(this),pt.unitLength=void 0,pt.hasBreaks){var mt=gt.options.breaks||[],xt=[],wt=[],Mt=pick$10(gt.pointRangePadding,0),At=0,St,$t,Tt=gt.userMin||gt.min,Pt=gt.userMax||gt.max,It,Lt;mt.forEach(function(Nt){$t=Nt.repeat||1/0,isNumber$t(Tt)&&isNumber$t(Pt)&&(ut.isInBreak(Nt,Tt)&&(Tt+=Nt.to%$t-Tt%$t),ut.isInBreak(Nt,Pt)&&(Pt-=Pt%$t-Nt.from%$t))}),mt.forEach(function(Nt){if(It=Nt.from,$t=Nt.repeat||1/0,isNumber$t(Tt)&&isNumber$t(Pt)){for(;It-$t>Tt;)It-=$t;for(;It<Tt;)It+=$t;for(Lt=It;Lt<Pt;Lt+=$t)xt.push({value:Lt,move:"in"}),xt.push({value:Lt+Nt.to-Nt.from,move:"out",size:Nt.breakSize})}}),xt.sort(function(Nt,Ht){return Nt.value===Ht.value?(Nt.move==="in"?0:1)-(Ht.move==="in"?0:1):Nt.value-Ht.value}),St=0,It=Tt,xt.forEach(function(Nt){St+=Nt.move==="in"?1:-1,St===1&&Nt.move==="in"&&(It=Nt.value),St===0&&isNumber$t(It)&&(wt.push({from:It,to:Nt.value,len:Nt.value-It-(Nt.size||0)}),At+=Nt.value-It-(Nt.size||0))}),pt.breakArray=wt,isNumber$t(Tt)&&isNumber$t(Pt)&&isNumber$t(gt.min)&&(pt.unitLength=Pt-Tt-At+Mt,fireEvent$l(gt,"afterBreaks"),gt.staticScale?gt.transA=gt.staticScale:pt.unitLength&&(gt.transA*=(Pt-gt.min+Mt)/pt.unitLength),Mt&&(gt.minPixelPadding=gt.transA*(gt.minPointOffset||0)),gt.min=Tt,gt.max=Pt)}}),pick$10(ft,!0)&&gt.chart.redraw()},ut}();j.Additions=ht})(BrokenAxis||(BrokenAxis={}));const BrokenAxis$1=BrokenAxis;/**
 * @license Highcharts JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/broken-axis
 * @requires highcharts
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$6=H;BrokenAxis$1.compose(G$6.Axis,G$6.Series);var format$8=FormatUtilities.format,seriesProto$3=Series$e.prototype,addEvent$K=Utilities.addEvent,arrayMax$5=Utilities.arrayMax,arrayMin$5=Utilities.arrayMin,correctFloat$7=Utilities.correctFloat,defined$y=Utilities.defined,error$2=Utilities.error,extend$16=Utilities.extend,isNumber$s=Utilities.isNumber,merge$W=Utilities.merge,pick$$=Utilities.pick,approximations=H.approximations={sum:function(j){var E=j.length,a;if(!E&&j.hasNulls)a=null;else if(E)for(a=0;E--;)a+=j[E];return a},average:function(j){var E=j.length,a=approximations.sum(j);return isNumber$s(a)&&E&&(a=correctFloat$7(a/E)),a},averages:function(){var j=[];return[].forEach.call(arguments,function(E){j.push(approximations.average(E))}),typeof j[0]>"u"?void 0:j},open:function(j){return j.length?j[0]:j.hasNulls?null:void 0},high:function(j){return j.length?arrayMax$5(j):j.hasNulls?null:void 0},low:function(j){return j.length?arrayMin$5(j):j.hasNulls?null:void 0},close:function(j){return j.length?j[j.length-1]:j.hasNulls?null:void 0},ohlc:function(j,E,a,k){if(j=approximations.open(j),E=approximations.high(E),a=approximations.low(a),k=approximations.close(k),isNumber$s(j)||isNumber$s(E)||isNumber$s(a)||isNumber$s(k))return[j,E,a,k]},range:function(j,E){if(j=approximations.low(j),E=approximations.high(E),isNumber$s(j)||isNumber$s(E))return[j,E];if(j===null&&E===null)return null}},applyGrouping=function(){var j=this,E=j.chart,a=j.options,k=a.dataGrouping,tt=j.allowDG!==!1&&k&&pick$$(k.enabled,E.options.isStock),et=j.visible||!E.options.chart.ignoreHiddenSeries,rt,nt,ot=this.currentDataGrouping,st,lt,ht=!1;if(tt&&!j.requireSorting&&(j.requireSorting=ht=!0),nt=skipDataGrouping(j)||!tt,ht&&(j.requireSorting=!1),!nt){j.destroyGroupedData();var ut=void 0,dt=k.groupAll?j.xData:j.processedXData,ft=k.groupAll?j.yData:j.processedYData,pt=E.plotSizeX,gt=j.xAxis,yt=gt.options.ordinal,mt=j.groupPixelWidth;if(mt&&dt&&dt.length){rt=!0,j.isDirty=!0,j.points=null;var xt=gt.getExtremes(),wt=xt.min,Mt=xt.max,At=yt&&gt.ordinal&&gt.ordinal.getGroupIntervalFactor(wt,Mt,j)||1,St=mt*(Mt-wt)/pt*At,$t=gt.getTimeTicks(DateTimeAxis$1.Additions.prototype.normalizeTimeTickInterval(St,k.units||defaultDataGroupingUnits),Math.min(wt,dt[0]),Math.max(Mt,dt[dt.length-1]),gt.options.startOfWeek,dt,j.closestPointRange),Tt=seriesProto$3.groupData.apply(j,[dt,ft,$t,k.approximation]),Pt=Tt.groupedXData,It=Tt.groupedYData,Lt=0;for(k&&k.smoothed&&Pt.length&&(k.firstAnchor="firstPoint",k.anchor="middle",k.lastAnchor="lastPoint",error$2(32,!1,E,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),anchorPoints(j,Pt,Mt),ut=1;ut<$t.length;ut++)(!$t.info.segmentStarts||$t.info.segmentStarts.indexOf(ut)===-1)&&(Lt=Math.max($t[ut]-$t[ut-1],Lt));st=$t.info,st.gapSize=Lt,j.closestPointRange=$t.info.totalRange,j.groupMap=Tt.groupMap,et&&adjustExtremes(gt,Pt),k.groupAll&&(j.allGroupedData=It,lt=j.cropData(Pt,It,gt.min,gt.max,1),Pt=lt.xData,It=lt.yData,j.cropStart=lt.start),j.processedXData=Pt,j.processedYData=It}else j.groupMap=null;j.hasGroupedData=rt,j.currentDataGrouping=st,j.preventGraphAnimation=(ot&&ot.totalRange)!==(st&&st.totalRange)}},skipDataGrouping=function(j){if(j.isCartesian&&!j.isDirty&&!j.xAxis.isDirty&&!j.yAxis.isDirty)return!1},groupData=function(j,E,a,k){var tt=this,et=tt.data,rt=tt.options&&tt.options.data,nt=[],ot=[],st=[],lt=j.length,ht,ut,dt,ft=!!E,pt=[],gt,yt=tt.pointArrayMap,mt=yt&&yt.length,xt=["x"].concat(yt||["y"]),wt=this.options.dataGrouping&&this.options.dataGrouping.groupAll,Mt=0,At=0,St,$t,Tt;function Pt(Ht){return typeof Ht=="function"?Ht:approximations[Ht]?approximations[Ht]:approximations[tt.getDGApproximation&&tt.getDGApproximation()||"average"]}for(gt=Pt(k),mt?yt.forEach(function(){pt.push([])}):pt.push([]),St=mt||1,$t=0;$t<=lt&&!(j[$t]>=a[0]);$t++);for($t;$t<=lt;$t++){for(;typeof a[Mt+1]<"u"&&j[$t]>=a[Mt+1]||$t===lt;){for(ht=a[Mt],tt.dataGroupInfo={start:wt?At:tt.cropStart+At,length:pt[0].length},dt=gt.apply(tt,pt),tt.pointClass&&!defined$y(tt.dataGroupInfo.options)&&(tt.dataGroupInfo.options=merge$W(tt.pointClass.prototype.optionsToObject.call({series:tt},tt.options.data[tt.cropStart+At])),xt.forEach(function(Ht){delete tt.dataGroupInfo.options[Ht]})),typeof dt<"u"&&(nt.push(ht),ot.push(dt),st.push(tt.dataGroupInfo)),At=$t,Tt=0;Tt<St;Tt++)pt[Tt].length=0,pt[Tt].hasNulls=!1;if(Mt+=1,$t===lt)break}if($t===lt)break;if(yt){var It=tt.options.dataGrouping&&tt.options.dataGrouping.groupAll?$t:tt.cropStart+$t,Lt=et&&et[It]||tt.pointClass.prototype.applyOptions.apply({series:tt},[rt[It]]),Nt=void 0;for(Tt=0;Tt<mt;Tt++)Nt=Lt[yt[Tt]],isNumber$s(Nt)?pt[Tt].push(Nt):Nt===null&&(pt[Tt].hasNulls=!0)}else ut=ft?E[$t]:null,isNumber$s(ut)?pt[0].push(ut):ut===null&&(pt[0].hasNulls=!0)}return{groupedXData:nt,groupedYData:ot,groupMap:st}},anchorPoints=function(j,E,a){var k=j.options,tt=k.dataGrouping,et=j.currentDataGrouping&&j.currentDataGrouping.gapSize,rt;if(tt&&j.xData&&et&&j.groupMap){var nt=E.length-1,ot=tt.anchor,st=pick$$(tt.firstAnchor,ot),lt=pick$$(tt.lastAnchor,ot);if(ot&&ot!=="start"){var ht=et*{middle:.5,end:1}[ot];for(rt=E.length-1;rt--&&rt>0;)E[rt]+=ht}if(st&&st!=="start"&&j.xData[0]>=E[0]){var ut=j.groupMap[0].start,dt=j.groupMap[0].length,ft=void 0;isNumber$s(ut)&&isNumber$s(dt)&&(ft=ut+(dt-1)),E[0]={middle:E[0]+.5*et,end:E[0]+et,firstPoint:j.xData[0],lastPoint:ft&&j.xData[ft]}[st]}if(lt&&lt!=="start"&&et&&E[nt]>=a-et){var pt=j.groupMap[j.groupMap.length-1].start;E[nt]={middle:E[nt]+.5*et,end:E[nt]+et,firstPoint:pt&&j.xData[pt],lastPoint:j.xData[j.xData.length-1]}[lt]}}},adjustExtremes=function(j,E){defined$y(E[0])&&isNumber$s(j.min)&&isNumber$s(j.dataMin)&&E[0]<j.min&&((!defined$y(j.options.min)&&j.min<=j.dataMin||j.min===j.dataMin)&&(j.min=Math.min(E[0],j.min)),j.dataMin=Math.min(E[0],j.dataMin)),defined$y(E[E.length-1])&&isNumber$s(j.max)&&isNumber$s(j.dataMax)&&E[E.length-1]>j.max&&((!defined$y(j.options.max)&&isNumber$s(j.dataMax)&&j.max>=j.dataMax||j.max===j.dataMax)&&(j.max=Math.max(E[E.length-1],j.max)),j.dataMax=Math.max(E[E.length-1],j.dataMax))},dataGrouping={approximations,groupData};seriesProto$3.processData;var baseGeneratePoints=seriesProto$3.generatePoints,commonOptions={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},specificOptions={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},defaultDataGroupingUnits=H.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];seriesProto$3.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};seriesProto$3.groupData=groupData;seriesProto$3.applyGrouping=applyGrouping;seriesProto$3.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(j,E){j&&(this.groupedData[E]=j.destroy?j.destroy():null)},this),this.groupedData.length=0)};seriesProto$3.generatePoints=function(){baseGeneratePoints.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null};Axis.prototype.applyGrouping=function(){var j=this,E=j.series;E.forEach(function(a){a.groupPixelWidth=void 0,a.groupPixelWidth=j.getGroupPixelWidth&&j.getGroupPixelWidth(),a.groupPixelWidth&&(a.hasProcessed=!0),a.applyGrouping()})};Axis.prototype.getGroupPixelWidth=function(){var j=this.series,E=j.length,a,k=0,tt=!1,et,rt;for(a=E;a--;)rt=j[a].options.dataGrouping,rt&&(k=Math.max(k,pick$$(rt.groupPixelWidth,commonOptions.groupPixelWidth)));for(a=E;a--;)rt=j[a].options.dataGrouping,rt&&(et=(j[a].processedXData||j[a].data).length,(j[a].groupPixelWidth||et>this.chart.plotSizeX/k||et&&rt.forced)&&(tt=!0));return tt?k:0};Axis.prototype.setDataGrouping=function(j,E){var a=this,k;if(E=pick$$(E,!0),j||(j={forced:!1,units:null}),this instanceof Axis)for(k=this.series.length;k--;)this.series[k].update({dataGrouping:j},!1);else this.chart.options.series.forEach(function(tt){tt.dataGrouping=j},!1);a.ordinal&&(a.ordinal.slope=void 0),E&&this.chart.redraw()};addEvent$K(Axis,"postProcessData",Axis.prototype.applyGrouping);addEvent$K(Point$5,"update",function(){if(this.dataGroup)return error$2(24,!1,this.series.chart),!1});addEvent$K(Tooltip,"headerFormatter",function(j){var E=this.chart,a=E.time,k=j.labelConfig,tt=k.series,et=tt.options,rt=tt.tooltipOptions,nt=et.dataGrouping,ot=rt.xDateFormat,st,lt=tt.xAxis,ht,ut,dt,ft,pt=rt[j.isFooter?"footerFormat":"headerFormat"];lt&&lt.options.type==="datetime"&&nt&&isNumber$s(k.key)&&(ht=tt.currentDataGrouping,ut=nt.dateTimeLabelFormats||commonOptions.dateTimeLabelFormats,ht?(dt=ut[ht.unitName],ht.count===1?ot=dt[0]:(ot=dt[1],st=dt[2])):!ot&&ut&&lt.dateTime&&(ot=lt.dateTime.getXDateFormat(k.x,rt.dateTimeLabelFormats)),ft=a.dateFormat(ot,k.key),st&&(ft+=a.dateFormat(st,k.key+ht.totalRange-1)),tt.chart.styledMode&&(pt=this.styledModeFormat(pt)),j.text=format$8(pt,{point:extend$16(k.point,{key:ft}),series:tt},E),j.preventDefault())});addEvent$K(Series$e,"destroy",seriesProto$3.destroyGroupedData);addEvent$K(Series$e,"afterSetOptions",function(j){var E=j.options,a=this.type,k=this.chart.options.plotOptions,tt=DefaultOptions.defaultOptions.plotOptions[a].dataGrouping,et=this.useCommonDataGrouping&&commonOptions;if(specificOptions[a]||et){tt||(tt=merge$W(commonOptions,specificOptions[a]));var rt=this.chart.rangeSelector;E.dataGrouping=merge$W(et,tt,k.series&&k.series.dataGrouping,k[a].dataGrouping,this.userOptions.dataGrouping,!E.isInternal&&rt&&isNumber$s(rt.selected)&&rt.buttonOptions[rt.selected].dataGrouping)}});addEvent$K(Axis,"afterSetScale",function(){this.series.forEach(function(j){j.hasProcessed=!1})});H.dataGrouping=dataGrouping;var __extends$20=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),ColumnSeries$g=SeriesRegistry$1.seriesTypes.column,OHLCPoint=function(j){__extends$20(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.close=void 0,a.high=void 0,a.low=void 0,a.open=void 0,a.options=void 0,a.plotClose=void 0,a.plotOpen=void 0,a.series=void 0,a}return E.prototype.getClassName=function(){return j.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},E.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},E.prototype.resolveColor=function(){j.prototype.resolveColor.call(this),this.resolveUpColor()},E.prototype.getZone=function(){var a=j.prototype.getZone.call(this);return this.resolveUpColor(),a},E.prototype.applyOptions=function(){return j.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},E}(ColumnSeries$g.prototype.pointClass),__extends$1$=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),ColumnSeries$f=SeriesRegistry$1.seriesTypes.column,extend$15=Utilities.extend,merge$V=Utilities.merge,OHLCSeries$1=function(j){__extends$1$(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a.yData=void 0,a}return E.prototype.drawPoints=function(){var a=this,k=a.points,tt=a.chart,et=function(rt,nt,ot){var st=rt[0],lt=rt[1];typeof st[2]=="number"&&(st[2]=Math.max(ot+nt,st[2])),typeof lt[2]=="number"&&(lt[2]=Math.min(ot-nt,lt[2]))};k.forEach(function(rt){var nt,ot,st,lt,ht,ut=rt.graphic,dt,ft=!ut,pt;typeof rt.plotY<"u"&&(ut||(rt.graphic=ut=tt.renderer.path().add(a.group)),tt.styledMode||ut.attr(a.pointAttribs(rt,rt.selected&&"select")),pt=ut.strokeWidth(),st=pt%2/2,dt=Math.round(rt.plotX)-st,lt=Math.round(rt.shapeArgs.width/2),ht=[["M",dt,Math.round(rt.yBottom)],["L",dt,Math.round(rt.plotHigh)]],rt.open!==null&&(nt=Math.round(rt.plotOpen)+st,ht.push(["M",dt,nt],["L",dt-lt,nt]),et(ht,pt/2,nt)),rt.close!==null&&(ot=Math.round(rt.plotClose)+st,ht.push(["M",dt,ot],["L",dt+lt,ot]),et(ht,pt/2,ot)),ut[ft?"attr":"animate"]({d:ht}).addClass(rt.getClassName(),!0))})},E.prototype.init=function(){j.prototype.init.apply(this,arguments),this.options.stacking=void 0},E.prototype.pointAttribs=function(a,k){var tt=j.prototype.pointAttribs.call(this,a,k),et=this.options;return delete tt.fill,!a.options.color&&et.upColor&&a.open<a.close&&(tt.stroke=et.upColor),tt},E.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]},E.prototype.translate=function(){var a=this,k=a.yAxis,tt=!!a.modifyValue,et=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];j.prototype.translate.apply(a),a.points.forEach(function(rt){[rt.open,rt.high,rt.low,rt.close,rt.low].forEach(function(nt,ot){nt!==null&&(tt&&(nt=a.modifyValue(nt)),rt[et[ot]]=k.toPixels(nt,!0))}),rt.tooltipPos[1]=rt.plotHigh+k.pos-a.chart.plotTop})},E.defaultOptions=merge$V(ColumnSeries$f.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}),E}(ColumnSeries$f);extend$15(OHLCSeries$1.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});OHLCSeries$1.prototype.pointClass=OHLCPoint;SeriesRegistry$1.registerSeriesType("ohlc",OHLCSeries$1);var __extends$1_=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),defaultOptions$9=DefaultOptions.defaultOptions,_a$d=SeriesRegistry$1.seriesTypes,ColumnSeries$e=_a$d.column,OHLCSeries=_a$d.ohlc,merge$U=Utilities.merge,CandlestickSeries=function(j){__extends$1_(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.pointAttribs=function(a,k){var tt=ColumnSeries$e.prototype.pointAttribs.call(this,a,k),et=this.options,rt=a.open<a.close,nt=et.lineColor||this.color,ot=a.color||this.color,st;return tt["stroke-width"]=et.lineWidth,tt.fill=a.options.color||rt&&et.upColor||ot,tt.stroke=a.options.lineColor||rt&&et.upLineColor||nt,k&&(st=et.states[k],tt.fill=st.color||tt.fill,tt.stroke=st.lineColor||tt.stroke,tt["stroke-width"]=st.lineWidth||tt["stroke-width"]),tt},E.prototype.drawPoints=function(){var a=this,k=a.points,tt=a.chart,et=a.yAxis.reversed;k.forEach(function(rt){var nt=rt.graphic,ot,st,lt,ht,ut,dt,ft,pt,gt,yt,mt=!nt;typeof rt.plotY<"u"&&(nt||(rt.graphic=nt=tt.renderer.path().add(a.group)),a.chart.styledMode||nt.attr(a.pointAttribs(rt,rt.selected&&"select")).shadow(a.options.shadow),ft=nt.strokeWidth()%2/2,pt=Math.round(rt.plotX)-ft,ot=rt.plotOpen,st=rt.plotClose,lt=Math.min(ot,st),ht=Math.max(ot,st),yt=Math.round(rt.shapeArgs.width/2),ut=et?ht!==rt.yBottom:Math.round(lt)!==Math.round(rt.plotHigh),dt=et?Math.round(lt)!==Math.round(rt.plotHigh):ht!==rt.yBottom,lt=Math.round(lt)+ft,ht=Math.round(ht)+ft,gt=[],gt.push(["M",pt-yt,ht],["L",pt-yt,lt],["L",pt+yt,lt],["L",pt+yt,ht],["Z"],["M",pt,lt],["L",pt,ut?Math.round(et?rt.yBottom:rt.plotHigh):lt],["M",pt,ht],["L",pt,dt?Math.round(et?rt.plotHigh:rt.yBottom):ht]),nt[mt?"attr":"animate"]({d:gt}).addClass(rt.getClassName(),!0))})},E.defaultOptions=merge$U(OHLCSeries.defaultOptions,defaultOptions$9.plotOptions,{states:{hover:{lineWidth:2}},tooltip:defaultOptions$9.plotOptions.ohlc.tooltip,threshold:null,lineColor:palette.neutralColor100,lineWidth:1,upColor:palette.backgroundColor,stickyTracking:!0}),E}(OHLCSeries);SeriesRegistry$1.registerSeriesType("candlestick",CandlestickSeries);var __extends$1Z=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),ColumnSeries$d=SeriesRegistry$1.seriesTypes.column,isNumber$r=Utilities.isNumber,FlagsPoint=function(j){__extends$1Z(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.options=void 0,a.series=void 0,a}return E.prototype.isValid=function(){return isNumber$r(this.y)||typeof this.y>"u"},E.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey},E}(ColumnSeries$d.prototype.pointClass),columnProto$5=ColumnSeries$h.prototype,seriesProto$2=Series$e.prototype,defined$x=Utilities.defined,stableSort$4=Utilities.stableSort,onSeriesMixin={getPlotBox:function(){return seriesProto$2.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){columnProto$5.translate.apply(this);var j=this,E=j.options,a=j.chart,k=j.points,tt=k.length-1,et,rt,nt=E.onSeries,ot=nt&&a.get(nt),st=E.onKey||"y",lt=ot&&ot.options.step,ht=ot&&ot.points,ut=ht&&ht.length,dt=a.inverted,ft=j.xAxis,pt=j.yAxis,gt=0,yt,mt,xt,wt,Mt;if(ot&&ot.visible&&ut)for(gt=(ot.pointXOffset||0)+(ot.barW||0)/2,wt=ot.currentDataGrouping,mt=ht[ut-1].x+(wt?wt.totalRange:0),stableSort$4(k,function(At,St){return At.x-St.x}),st="plot"+st[0].toUpperCase()+st.substr(1);ut--&&k[tt]&&(yt=ht[ut],et=k[tt],et.y=yt.y,!(yt.x<=et.x&&typeof yt[st]<"u"&&(et.x<=mt&&(et.plotY=yt[st],yt.x<et.x&&!lt&&(xt=ht[ut+1],xt&&typeof xt[st]<"u"&&(Mt=(et.x-yt.x)/(xt.x-yt.x),et.plotY+=Mt*(xt[st]-yt[st]),et.y+=Mt*(xt.y-yt.y)))),tt--,ut++,tt<0))););k.forEach(function(At,St){var $t;At.plotX+=gt,(typeof At.plotY>"u"||dt)&&(At.plotX>=0&&At.plotX<=ft.len?dt?(At.plotY=ft.translate(At.x,0,1,0,1),At.plotX=defined$x(At.y)?pt.translate(At.y,0,0,0,1):0):At.plotY=(ft.opposite?0:j.yAxis.len)+ft.offset:At.shapeArgs={}),rt=k[St-1],rt&&rt.plotX===At.plotX&&(typeof rt.stackIndex>"u"&&(rt.stackIndex=0),$t=rt.stackIndex+1),At.stackIndex=$t}),this.onSeries=ot}},symbols$3=SVGRenderer.prototype.symbols;symbols$3.flag=function(j,E,a,k,tt){var et=tt&&tt.anchorX||j,rt=tt&&tt.anchorY||E,nt=symbols$3.circle(et-1,rt-1,2,2);return nt.push(["M",et,rt],["L",j,E+k],["L",j,E],["L",j+a,E],["L",j+a,E+k],["L",j,E+k],["Z"]),nt};function createPinSymbol(j){symbols$3[j+"pin"]=function(E,a,k,tt,et){var rt=et&&et.anchorX,nt=et&&et.anchorY,ot;if(j==="circle"&&tt>k&&(E-=Math.round((tt-k)/2),k=tt),ot=symbols$3[j](E,a,k,tt),rt&&nt){var st=rt;if(j==="circle")st=E+k/2;else{var lt=ot[0],ht=ot[1];lt[0]==="M"&&ht[0]==="L"&&(st=(lt[1]+ht[1])/2)}var ut=a>nt?a:a+tt;ot.push(["M",st,ut],["L",rt,nt]),ot=ot.concat(symbols$3.circle(rt-1,nt-1,2,2))}return ot}}createPinSymbol("circle");createPinSymbol("square");var Renderer=RendererRegistry$1.getRendererType();Renderer!==SVGRenderer&&(Renderer.prototype.symbols.circlepin=symbols$3.circlepin,Renderer.prototype.symbols.flag=symbols$3.flag,Renderer.prototype.symbols.squarepin=symbols$3.squarepin);var __extends$1Y=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),noop$e=H.noop,distribute=R.distribute,Series$b=SeriesRegistry$1.series,ColumnSeries$c=SeriesRegistry$1.seriesTypes.column,addEvent$J=Utilities.addEvent,defined$w=Utilities.defined,extend$14=Utilities.extend,merge$T=Utilities.merge,objectEach$e=Utilities.objectEach,wrap$b=Utilities.wrap,FlagsSeries=function(j){__extends$1Y(E,j);function E(){var a=j!==null&&j.apply(this,arguments)||this;return a.data=void 0,a.options=void 0,a.points=void 0,a}return E.prototype.animate=function(a){a&&this.setClip()},E.prototype.drawPoints=function(){var a=this,k=a.points,tt=a.chart,et=tt.renderer,rt,nt,ot=tt.inverted,st=a.options,lt=st.y,ht,ut,dt,ft,pt,gt,yt,mt,xt=a.yAxis,wt={},Mt=[],At;for(ut=k.length;ut--;)dt=k[ut],mt=(ot?dt.plotY:dt.plotX)>a.xAxis.len,rt=dt.plotX,pt=dt.stackIndex,ht=dt.options.shape||st.shape,nt=dt.plotY,typeof nt<"u"&&(nt=dt.plotY+lt-(typeof pt<"u"&&pt*st.stackDistance)),dt.anchorX=pt?void 0:dt.plotX,gt=pt?void 0:dt.plotY,At=ht!=="flag",ft=dt.graphic,typeof nt<"u"&&rt>=0&&!mt?(ft&&dt.hasNewShapeType()&&(ft=ft.destroy()),ft||(ft=dt.graphic=et.label("",null,null,ht,null,null,st.useHTML).addClass("highcharts-point").add(a.markerGroup),dt.graphic.div&&(dt.graphic.div.point=dt),ft.isNew=!0),ft.attr({align:At?"center":"left",width:st.width,height:st.height,"text-align":st.textAlign}),tt.styledMode||ft.attr(a.pointAttribs(dt)).css(merge$T(st.style,dt.style)).shadow(st.shadow),rt>0&&(rt-=ft.strokeWidth()%2),yt={y:nt,anchorY:gt},st.allowOverlapX&&(yt.x=rt,yt.anchorX=dt.anchorX),ft.attr({text:dt.options.title||st.title||"A"})[ft.isNew?"attr":"animate"](yt),st.allowOverlapX||(wt[dt.plotX]?wt[dt.plotX].size=Math.max(wt[dt.plotX].size,ft.width):wt[dt.plotX]={align:At?.5:0,size:ft.width,target:rt,anchorX:rt}),dt.tooltipPos=[rt,nt+xt.pos-tt.plotTop]):ft&&(dt.graphic=ft.destroy());st.allowOverlapX||(objectEach$e(wt,function(St){St.plotX=St.anchorX,Mt.push(St)}),distribute(Mt,ot?xt.len:this.xAxis.len,100),k.forEach(function(St){var $t=St.graphic&&wt[St.plotX];$t&&(St.graphic[St.graphic.isNew?"attr":"animate"]({x:$t.pos+$t.align*$t.size,anchorX:St.anchorX}),defined$w($t.pos)?St.graphic.isNew=!1:(St.graphic.attr({x:-9999,anchorX:-9999}),St.graphic.isNew=!0))})),st.useHTML&&wrap$b(a.markerGroup,"on",function(St){return SVGElement.prototype.on.apply(St.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},E.prototype.drawTracker=function(){var a=this,k=a.points;j.prototype.drawTracker.call(this),k.forEach(function(tt){var et=tt.graphic;et&&(tt.unbindMouseOver&&tt.unbindMouseOver(),tt.unbindMouseOver=addEvent$J(et.element,"mouseover",function(){tt.stackIndex>0&&!tt.raised&&(tt._y=et.y,et.attr({y:tt._y-8}),tt.raised=!0),k.forEach(function(rt){rt!==tt&&rt.raised&&rt.graphic&&(rt.graphic.attr({y:rt._y}),rt.raised=!1)})}))})},E.prototype.pointAttribs=function(a,k){var tt=this.options,et=a&&a.color||this.color,rt=tt.lineColor,nt=a&&a.lineWidth,ot=a&&a.fillColor||tt.fillColor;return k&&(ot=tt.states[k].fillColor,rt=tt.states[k].lineColor,nt=tt.states[k].lineWidth),{fill:ot||et,stroke:rt||et,"stroke-width":nt||tt.lineWidth||0}},E.prototype.setClip=function(){Series$b.prototype.setClip.apply(this,arguments),this.options.clip!==!1&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},E.defaultOptions=merge$T(ColumnSeries$c.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:palette.backgroundColor,lineWidth:1,states:{hover:{lineColor:palette.neutralColor100,fillColor:palette.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}}),E}(ColumnSeries$c);extend$14(FlagsSeries.prototype,{allowDG:!1,buildKDTree:noop$e,forceCrop:!0,getPlotBox:onSeriesMixin.getPlotBox,init:Series$b.prototype.init,invertGroups:noop$e,invertible:!1,noSharedTooltip:!0,pointClass:FlagsPoint,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:onSeriesMixin.translate});SeriesRegistry$1.registerSeriesType("flags",FlagsSeries);var addEvent$I=Utilities.addEvent,defined$v=Utilities.defined,pick$_=Utilities.pick,ScrollbarAxis=function(){function j(){}return j.compose=function(E,a){if(j.composed.indexOf(E)===-1)j.composed.push(E);else return E;var k=function(tt){var et=pick$_(tt.options&&tt.options.min,tt.min),rt=pick$_(tt.options&&tt.options.max,tt.max);return{axisMin:et,axisMax:rt,scrollMin:defined$v(tt.dataMin)?Math.min(et,tt.min,tt.dataMin,pick$_(tt.threshold,1/0)):et,scrollMax:defined$v(tt.dataMax)?Math.max(rt,tt.max,tt.dataMax,pick$_(tt.threshold,-1/0)):rt}};return addEvent$I(E,"afterInit",function(){var tt=this;tt.options&&tt.options.scrollbar&&tt.options.scrollbar.enabled&&(tt.options.scrollbar.vertical=!tt.horiz,tt.options.startOnTick=tt.options.endOnTick=!1,tt.scrollbar=new a(tt.chart.renderer,tt.options.scrollbar,tt.chart),addEvent$I(tt.scrollbar,"changed",function(et){var rt=k(tt),nt=rt.axisMin,ot=rt.axisMax,st=rt.scrollMin,lt=rt.scrollMax,ht=lt-st,ut,dt;!defined$v(nt)||!defined$v(ot)||(tt.horiz&&!tt.reversed||!tt.horiz&&tt.reversed?(ut=st+ht*this.to,dt=st+ht*this.from):(ut=st+ht*(1-this.from),dt=st+ht*(1-this.to)),this.shouldUpdateExtremes(et.DOMType)?tt.setExtremes(dt,ut,!0,et.DOMType!=="mousemove"&&et.DOMType!=="touchmove",et):this.setRange(this.from,this.to))}))}),addEvent$I(E,"afterRender",function(){var tt=this,et=k(tt),rt=et.scrollMin,nt=et.scrollMax,ot=tt.scrollbar,st=tt.axisTitleMargin+(tt.titleOffset||0),lt=tt.chart.scrollbarsOffsets,ht=tt.options.margin||0,ut,dt,ft;ot&&(tt.horiz?(tt.opposite||(lt[1]+=st),ot.position(tt.left,tt.top+tt.height+2+lt[1]-(tt.opposite?ht:0),tt.width,tt.height),tt.opposite||(lt[1]+=ht),ut=1):(tt.opposite&&(lt[0]+=st),ot.position(tt.left+tt.width+2+lt[0]-(tt.opposite?0:ht),tt.top,tt.width,tt.height),tt.opposite&&(lt[0]+=ht),ut=0),lt[ut]+=ot.size+ot.options.margin,isNaN(rt)||isNaN(nt)||!defined$v(tt.min)||!defined$v(tt.max)||tt.min===tt.max?ot.setRange(0,1):(dt=(tt.min-rt)/(nt-rt),ft=(tt.max-rt)/(nt-rt),tt.horiz&&!tt.reversed||!tt.horiz&&tt.reversed?ot.setRange(dt,ft):ot.setRange(1-ft,1-dt)))}),addEvent$I(E,"afterGetOffset",function(){var tt=this,et=tt.horiz?2:1,rt=tt.scrollbar;rt&&(tt.chart.scrollbarsOffsets=[0,0],tt.chart.axisOffset[et]+=rt.size+rt.options.margin)}),E},j.composed=[],j}(),isTouchDevice$3=H.isTouchDevice,ScrollbarDefaults={height:isTouchDevice$3?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:palette.neutralColor20,barBorderWidth:1,barBorderColor:palette.neutralColor20,buttonArrowColor:palette.neutralColor80,buttonBackgroundColor:palette.neutralColor10,buttonBorderColor:palette.neutralColor20,buttonBorderWidth:1,rifleColor:palette.neutralColor80,trackBackgroundColor:palette.neutralColor5,trackBorderColor:palette.neutralColor5,trackBorderWidth:1},defaultOptions$8=DefaultOptions.defaultOptions,addEvent$H=Utilities.addEvent,correctFloat$6=Utilities.correctFloat,defined$u=Utilities.defined,destroyObjectProperties$3=Utilities.destroyObjectProperties,fireEvent$k=Utilities.fireEvent,merge$S=Utilities.merge,pick$Z=Utilities.pick,removeEvent$4=Utilities.removeEvent,Scrollbar=function(){function j(E,a,k){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(E,a,k)}return j.compose=function(E){ScrollbarAxis.compose(E,j)},j.swapXY=function(E,a){return a&&E.forEach(function(k){for(var tt=k.length,et,rt=0;rt<tt;rt+=2)et=k[rt+1],typeof et=="number"&&(k[rt+1]=k[rt+2],k[rt+2]=et)}),E},j.prototype.addEvents=function(){var E=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,k=this.scrollbarGroup.element,tt=this.track.element,et=this.mouseDownHandler.bind(this),rt=this.mouseMoveHandler.bind(this),nt=this.mouseUpHandler.bind(this),ot=[[a[E[0]].element,"click",this.buttonToMinClick.bind(this)],[a[E[1]].element,"click",this.buttonToMaxClick.bind(this)],[tt,"click",this.trackClick.bind(this)],[k,"mousedown",et],[k.ownerDocument,"mousemove",rt],[k.ownerDocument,"mouseup",nt]];H.hasTouch&&ot.push([k,"touchstart",et],[k.ownerDocument,"touchmove",rt],[k.ownerDocument,"touchend",nt]),ot.forEach(function(st){addEvent$H.apply(null,st)}),this._events=ot},j.prototype.buttonToMaxClick=function(E){var a=this,k=(a.to-a.from)*pick$Z(a.options.step,.2);a.updatePosition(a.from+k,a.to+k),fireEvent$k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:E})},j.prototype.buttonToMinClick=function(E){var a=this,k=correctFloat$6(a.to-a.from)*pick$Z(a.options.step,.2);a.updatePosition(correctFloat$6(a.from-k),correctFloat$6(a.to-k)),fireEvent$k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:E})},j.prototype.cursorToScrollbarPosition=function(E){var a=this,k=a.options,tt=k.minWidth>a.calculatedWidth?k.minWidth:0;return{chartX:(E.chartX-a.x-a.xOffset)/(a.barWidth-tt),chartY:(E.chartY-a.y-a.yOffset)/(a.barWidth-tt)}},j.prototype.destroy=function(){var E=this,a=E.chart.scroller;E.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(k){E[k]&&E[k].destroy&&(E[k]=E[k].destroy())}),a&&E===a.scrollbar&&(a.scrollbar=null,destroyObjectProperties$3(a.scrollbarButtons))},j.prototype.drawScrollbarButton=function(E){var a=this,k=a.renderer,tt=a.scrollbarButtons,et=a.options,rt=a.size,nt=k.g().add(a.group),ot;tt.push(nt),ot=k.rect().addClass("highcharts-scrollbar-button").add(nt),a.chart.styledMode||ot.attr({stroke:et.buttonBorderColor,"stroke-width":et.buttonBorderWidth,fill:et.buttonBackgroundColor}),ot.attr(ot.crisp({x:-.5,y:-.5,width:rt+1,height:rt+1,r:et.buttonBorderRadius},ot.strokeWidth())),ot=k.path(j.swapXY([["M",rt/2+(E?-1:1),rt/2-3],["L",rt/2+(E?-1:1),rt/2+3],["L",rt/2+(E?2:-2),rt/2]],et.vertical)).addClass("highcharts-scrollbar-arrow").add(tt[E]),a.chart.styledMode||ot.attr({fill:et.buttonArrowColor})},j.prototype.init=function(E,a,k){var tt=this;tt.scrollbarButtons=[],tt.renderer=E,tt.userOptions=a,tt.options=merge$S(ScrollbarDefaults,defaultOptions$8.scrollbar,a),tt.chart=k,tt.size=pick$Z(tt.options.size,tt.options.height),a.enabled&&(tt.render(),tt.addEvents())},j.prototype.mouseDownHandler=function(E){var a=this,k=a.chart.pointer.normalize(E),tt=a.cursorToScrollbarPosition(k);a.chartX=tt.chartX,a.chartY=tt.chartY,a.initPositions=[a.from,a.to],a.grabbedCenter=!0},j.prototype.mouseMoveHandler=function(E){var a=this,k=a.chart.pointer.normalize(E),tt=a.options,et=tt.vertical?"chartY":"chartX",rt=a.initPositions||[],nt,ot,st;a.grabbedCenter&&(!E.touches||E.touches[0][et]!==0)&&(ot=a.cursorToScrollbarPosition(k)[et],nt=a[et],st=ot-nt,a.hasDragged=!0,a.updatePosition(rt[0]+st,rt[1]+st),a.hasDragged&&fireEvent$k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:E.type,DOMEvent:E}))},j.prototype.mouseUpHandler=function(E){var a=this;a.hasDragged&&fireEvent$k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:E.type,DOMEvent:E}),a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null},j.prototype.position=function(E,a,k,tt){var et=this,rt=et.options,nt=rt.vertical,ot=et.rendered?"animate":"attr",st=tt,lt=0;et.x=E,et.y=a+this.trackBorderWidth,et.width=k,et.height=tt,et.xOffset=st,et.yOffset=lt,nt?(et.width=et.yOffset=k=lt=et.size,et.xOffset=st=0,et.barWidth=tt-k*2,et.x=E=E+et.options.margin):(et.height=et.xOffset=tt=st=et.size,et.barWidth=k-tt*2,et.y=et.y+et.options.margin),et.group[ot]({translateX:E,translateY:et.y}),et.track[ot]({width:k,height:tt}),et.scrollbarButtons[1][ot]({translateX:nt?0:k-st,translateY:nt?tt-lt:0})},j.prototype.removeEvents=function(){this._events.forEach(function(E){removeEvent$4.apply(null,E)}),this._events.length=0},j.prototype.render=function(){var E=this,a=E.renderer,k=E.options,tt=E.size,et=E.chart.styledMode,rt=a.g("scrollbar").attr({zIndex:k.zIndex,translateY:-99999}).add();E.group=rt,E.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:k.trackBorderRadius||0,height:tt,width:tt}).add(rt),et||E.track.attr({fill:k.trackBackgroundColor,stroke:k.trackBorderColor,"stroke-width":k.trackBorderWidth}),E.trackBorderWidth=E.track.strokeWidth(),E.track.attr({y:-this.trackBorderWidth%2/2}),E.scrollbarGroup=a.g().add(rt),E.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:tt,width:tt,r:k.barBorderRadius||0}).add(E.scrollbarGroup),E.scrollbarRifles=a.path(j.swapXY([["M",-3,tt/4],["L",-3,2*tt/3],["M",0,tt/4],["L",0,2*tt/3],["M",3,tt/4],["L",3,2*tt/3]],k.vertical)).addClass("highcharts-scrollbar-rifles").add(E.scrollbarGroup),et||(E.scrollbar.attr({fill:k.barBackgroundColor,stroke:k.barBorderColor,"stroke-width":k.barBorderWidth}),E.scrollbarRifles.attr({stroke:k.rifleColor,"stroke-width":1})),E.scrollbarStrokeWidth=E.scrollbar.strokeWidth(),E.scrollbarGroup.translate(-E.scrollbarStrokeWidth%2/2,-E.scrollbarStrokeWidth%2/2),E.drawScrollbarButton(0),E.drawScrollbarButton(1)},j.prototype.setRange=function(E,a){var k=this,tt=k.options,et=tt.vertical,rt=tt.minWidth,nt=k.barWidth,ot=this.rendered&&!this.hasDragged&&!(this.chart.navigator&&this.chart.navigator.hasDragged)?"animate":"attr";if(defined$u(nt)){var st=nt*Math.min(a,1),lt,ht;E=Math.max(E,0),lt=Math.ceil(nt*E),k.calculatedWidth=ht=correctFloat$6(st-lt),ht<rt&&(lt=(nt-rt+ht)*E,ht=rt);var ut=Math.floor(lt+k.xOffset+k.yOffset),dt=ht/2-.5;k.from=E,k.to=a,et?(k.scrollbarGroup[ot]({translateY:ut}),k.scrollbar[ot]({height:ht}),k.scrollbarRifles[ot]({translateY:dt}),k.scrollbarTop=ut,k.scrollbarLeft=0):(k.scrollbarGroup[ot]({translateX:ut}),k.scrollbar[ot]({width:ht}),k.scrollbarRifles[ot]({translateX:dt}),k.scrollbarLeft=ut,k.scrollbarTop=0),ht<=12?k.scrollbarRifles.hide():k.scrollbarRifles.show(!0),tt.showFull===!1&&(E<=0&&a>=1?k.group.hide():k.group.show()),k.rendered=!0}},j.prototype.shouldUpdateExtremes=function(E){return pick$Z(this.options.liveRedraw,H.svg&&!H.isTouchDevice&&!this.chart.isBoosting)||E==="mouseup"||E==="touchend"||!defined$u(E)},j.prototype.trackClick=function(E){var a=this,k=a.chart.pointer.normalize(E),tt=a.to-a.from,et=a.y+a.scrollbarTop,rt=a.x+a.scrollbarLeft;a.options.vertical&&k.chartY>et||!a.options.vertical&&k.chartX>rt?a.updatePosition(a.from+tt,a.to+tt):a.updatePosition(a.from-tt,a.to-tt),fireEvent$k(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:E})},j.prototype.update=function(E){this.destroy(),this.init(this.chart.renderer,merge$S(!0,this.options,E),this.chart)},j.prototype.updatePosition=function(E,a){a>1&&(E=correctFloat$6(1-correctFloat$6(a-E)),a=1),E<0&&(a=correctFloat$6(a-E),E=0),this.from=E,this.to=a},j.defaultOptions=ScrollbarDefaults,j}();defaultOptions$8.scrollbar=merge$S(!0,Scrollbar.defaultOptions,defaultOptions$8.scrollbar);var isTouchDevice$2=H.isTouchDevice,addEvent$G=Utilities.addEvent,correctFloat$5=Utilities.correctFloat,defined$t=Utilities.defined,isNumber$q=Utilities.isNumber,pick$Y=Utilities.pick,NavigatorAxisAdditions=function(){function j(E){this.axis=E}return j.prototype.destroy=function(){this.axis=void 0},j.prototype.toFixedRange=function(E,a,k,tt){var et=this,rt=et.axis,nt=rt.chart,ot=nt&&nt.fixedRange,st=(rt.pointRange||0)/2,lt=pick$Y(k,rt.translate(E,!0,!rt.horiz)),ht=pick$Y(tt,rt.translate(a,!0,!rt.horiz)),ut=ot&&(ht-lt)/ot;return defined$t(k)||(lt=correctFloat$5(lt+st)),defined$t(tt)||(ht=correctFloat$5(ht-st)),ut>.7&&ut<1.3&&(tt?lt=ht-ot:ht=lt+ot),(!isNumber$q(lt)||!isNumber$q(ht))&&(lt=ht=void 0),{min:lt,max:ht}},j}(),NavigatorAxis=function(){function j(){}return j.compose=function(E){E.keepProps.push("navigatorAxis"),addEvent$G(E,"init",function(){var a=this;a.navigatorAxis||(a.navigatorAxis=new NavigatorAxisAdditions(a))}),addEvent$G(E,"zoom",function(a){var k=this,tt=k.chart,et=tt.options,rt=et.navigator,nt=k.navigatorAxis,ot=et.chart.pinchType,st=et.rangeSelector,lt=et.chart.zoomType,ht;k.isXAxis&&(rt&&rt.enabled||st&&st.enabled)&&(lt==="y"?a.zoomed=!1:(!isTouchDevice$2&&lt==="xy"||isTouchDevice$2&&ot==="xy")&&k.options.range&&(ht=nt.previousZoom,defined$t(a.newMin)?nt.previousZoom=[k.min,k.max]:ht&&(a.newMin=ht[0],a.newMax=ht[1],nt.previousZoom=void 0))),typeof a.zoomed<"u"&&a.preventDefault()})},j.AdditionsClass=NavigatorAxisAdditions,j}(),color$b=Color.parse,hasTouch=H.hasTouch,isTouchDevice$1=H.isTouchDevice,defaultOptions$7=DefaultOptions.defaultOptions,seriesTypes$5=SeriesRegistry$1.seriesTypes,addEvent$F=Utilities.addEvent,clamp$b=Utilities.clamp,correctFloat$4=Utilities.correctFloat,defined$s=Utilities.defined,destroyObjectProperties$2=Utilities.destroyObjectProperties,erase$1=Utilities.erase,extend$13=Utilities.extend,find$c=Utilities.find,isArray$8=Utilities.isArray,isNumber$p=Utilities.isNumber,merge$R=Utilities.merge,pick$X=Utilities.pick,removeEvent$3=Utilities.removeEvent,splat$9=Utilities.splat,defaultSeriesType,numExt=function(j){for(var E=[],a=1;a<arguments.length;a++)E[a-1]=arguments[a];var k=[].filter.call(E,isNumber$p);if(k.length)return Math[j].apply(0,k)};defaultSeriesType=typeof seriesTypes$5.areaspline>"u"?"line":"areaspline";extend$13(defaultOptions$7,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:palette.neutralColor5,borderColor:palette.neutralColor40},maskFill:color$b(palette.highlightColor60).setOpacity(.3).get(),outlineColor:palette.neutralColor20,outlineWidth:1,series:{type:defaultSeriesType,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:palette.neutralColor10,gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:palette.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});RendererRegistry$1.getRendererType().prototype.symbols["navigator-handle"]=function(j,E,a,k,tt){var et=(tt&&tt.width||0)/2,rt=Math.round(et/3)+.5,nt=tt&&tt.height||0;return[["M",-et-1,.5],["L",et,.5],["L",et,nt+.5],["L",-et-1,nt+.5],["L",-et-1,.5],["M",-rt,4],["L",-rt,nt-3],["M",rt-1,4],["L",rt-1,nt-3]]};var Navigator=function(){function j(E){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.outlineHeight=void 0,this.range=void 0,this.rendered=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(E)}return j.prototype.drawHandle=function(E,a,k,tt){var et=this,rt=et.navigatorOptions.handles.height;et.handles[a][tt](k?{translateX:Math.round(et.left+et.height/2),translateY:Math.round(et.top+parseInt(E,10)+.5-rt)}:{translateX:Math.round(et.left+parseInt(E,10)),translateY:Math.round(et.top+et.height/2-rt/2-1)})},j.prototype.drawOutline=function(E,a,k,tt){var et=this,rt=et.navigatorOptions.maskInside,nt=et.outline.strokeWidth(),ot=nt/2,st=nt%2/2,lt=et.outlineHeight,ht=et.scrollbarHeight||0,ut=et.size,dt=et.left-ht,ft=et.top,pt,gt;k?(dt-=ot,pt=ft+a+st,a=ft+E+st,gt=[["M",dt+lt,ft-ht-st],["L",dt+lt,pt],["L",dt,pt],["L",dt,a],["L",dt+lt,a],["L",dt+lt,ft+ut+ht]],rt&&gt.push(["M",dt+lt,pt-ot],["L",dt+lt,a+ot])):(E+=dt+ht-st,a+=dt+ht-st,ft+=ot,gt=[["M",dt,ft],["L",E,ft],["L",E,ft+lt],["L",a,ft+lt],["L",a,ft],["L",dt+ut+ht*2,ft]],rt&&gt.push(["M",E-ot,ft],["L",a+ot,ft])),et.outline[tt]({d:gt})},j.prototype.drawMasks=function(E,a,k,tt){var et=this,rt=et.left,nt=et.top,ot=et.height,st,lt,ht,ut;k?(ht=[rt,rt,rt],ut=[nt,nt+E,nt+a],lt=[ot,ot,ot],st=[E,a-E,et.size-a]):(ht=[rt,rt+E,rt+a],ut=[nt,nt,nt],lt=[E,a-E,et.size-a],st=[ot,ot,ot]),et.shades.forEach(function(dt,ft){dt[tt]({x:ht[ft],y:ut[ft],width:lt[ft],height:st[ft]})})},j.prototype.renderElements=function(){var E=this,a=E.navigatorOptions,k=a.maskInside,tt=E.chart,et=tt.inverted,rt=tt.renderer,nt,ot={cursor:et?"ns-resize":"ew-resize"};E.navigatorGroup=nt=rt.g("navigator").attr({zIndex:8,visibility:"hidden"}).add(),[!k,k,!k].forEach(function(st,lt){E.shades[lt]=rt.rect().addClass("highcharts-navigator-mask"+(lt===1?"-inside":"-outside")).add(nt),tt.styledMode||E.shades[lt].attr({fill:st?a.maskFill:"rgba(0,0,0,0)"}).css(lt===1&&ot)}),E.outline=rt.path().addClass("highcharts-navigator-outline").add(nt),tt.styledMode||E.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor}),a.handles.enabled&&[0,1].forEach(function(st){if(a.handles.inverted=tt.inverted,E.handles[st]=rt.symbol(a.handles.symbols[st],-a.handles.width/2-1,0,a.handles.width,a.handles.height,a.handles),E.handles[st].attr({zIndex:7-st}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][st]).add(nt),!tt.styledMode){var lt=a.handles;E.handles[st].attr({fill:lt.backgroundColor,stroke:lt.borderColor,"stroke-width":lt.lineWidth}).css(ot)}})},j.prototype.update=function(E){(this.series||[]).forEach(function(k){k.baseSeries&&delete k.baseSeries.navigatorSeries}),this.destroy();var a=this.chart.options;merge$R(!0,a.navigator,this.options,E),this.init(this.chart)},j.prototype.render=function(E,a,k,tt){var et=this,rt=et.chart,nt,ot,st,lt=et.scrollbarHeight,ht,ut=et.xAxis,dt=ut.pointRange||0,ft=ut.navigatorAxis.fake?rt.xAxis[0]:ut,pt=et.navigatorEnabled,gt,yt,mt=et.rendered,xt=rt.inverted,wt,Mt,At,St,$t=rt.xAxis[0].minRange,Tt=rt.xAxis[0].options.maxRange;if(!(this.hasDragged&&!defined$s(k))){if(E=correctFloat$4(E-dt/2),a=correctFloat$4(a+dt/2),!isNumber$p(E)||!isNumber$p(a))if(mt)k=0,tt=pick$X(ut.width,ft.width);else return;et.left=pick$X(ut.left,rt.plotLeft+lt+(xt?rt.plotWidth:0)),et.size=yt=ht=pick$X(ut.len,(xt?rt.plotHeight:rt.plotWidth)-2*lt),xt?nt=lt:nt=ht+2*lt,k=pick$X(k,ut.toPixels(E,!0)),tt=pick$X(tt,ut.toPixels(a,!0)),(!isNumber$p(k)||Math.abs(k)===1/0)&&(k=0,tt=nt),Mt=ut.toValue(k,!0),At=ut.toValue(tt,!0),St=Math.abs(correctFloat$4(At-Mt)),St<$t?this.grabbedLeft?k=ut.toPixels(At-$t-dt,!0):this.grabbedRight&&(tt=ut.toPixels(Mt+$t+dt,!0)):defined$s(Tt)&&correctFloat$4(St-dt)>Tt&&(this.grabbedLeft?k=ut.toPixels(At-Tt-dt,!0):this.grabbedRight&&(tt=ut.toPixels(Mt+Tt+dt,!0))),et.zoomedMax=clamp$b(Math.max(k,tt),0,yt),et.zoomedMin=clamp$b(et.fixedWidth?et.zoomedMax-et.fixedWidth:Math.min(k,tt),0,yt),et.range=et.zoomedMax-et.zoomedMin,yt=Math.round(et.zoomedMax),gt=Math.round(et.zoomedMin),pt&&(et.navigatorGroup.attr({visibility:"visible"}),wt=mt&&!et.hasDragged?"animate":"attr",et.drawMasks(gt,yt,xt,wt),et.drawOutline(gt,yt,xt,wt),et.navigatorOptions.handles.enabled&&(et.drawHandle(gt,0,xt,wt),et.drawHandle(yt,1,xt,wt))),et.scrollbar&&(xt?(st=et.top-lt,ot=et.left-lt+(pt||!ft.opposite?0:(ft.titleOffset||0)+ft.axisTitleMargin),lt=ht+2*lt):(st=et.top+(pt?et.height:-lt),ot=et.left-lt),et.scrollbar.position(ot,st,nt,lt),et.scrollbar.setRange(et.zoomedMin/(ht||1),et.zoomedMax/(ht||1))),et.rendered=!0}},j.prototype.addMouseEvents=function(){var E=this,a=E.chart,k=a.container,tt=[],et,rt;E.mouseMoveHandler=et=function(nt){E.onMouseMove(nt)},E.mouseUpHandler=rt=function(nt){E.onMouseUp(nt)},tt=E.getPartsEvents("mousedown"),tt.push(addEvent$F(a.renderTo,"mousemove",et),addEvent$F(k.ownerDocument,"mouseup",rt)),hasTouch&&(tt.push(addEvent$F(a.renderTo,"touchmove",et),addEvent$F(k.ownerDocument,"touchend",rt)),tt.concat(E.getPartsEvents("touchstart"))),E.eventsToUnbind=tt,E.series&&E.series[0]&&tt.push(addEvent$F(E.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))},j.prototype.getPartsEvents=function(E){var a=this,k=[];return["shades","handles"].forEach(function(tt){a[tt].forEach(function(et,rt){k.push(addEvent$F(et.element,E,function(nt){a[tt+"Mousedown"](nt,rt)}))})}),k},j.prototype.shadesMousedown=function(E,a){E=this.chart.pointer.normalize(E);var k=this,tt=k.chart,et=k.xAxis,rt=k.zoomedMin,nt=k.left,ot=k.size,st=k.range,lt=E.chartX,ht,ut,dt,ft;tt.inverted&&(lt=E.chartY,nt=k.top),a===1?(k.grabbedCenter=lt,k.fixedWidth=st,k.dragOffset=lt-rt):(ft=lt-nt-st/2,a===0?ft=Math.max(0,ft):a===2&&ft+st>=ot&&(ft=ot-st,k.reversedExtremes?(ft-=st,ut=k.getUnionExtremes().dataMin):ht=k.getUnionExtremes().dataMax),ft!==rt&&(k.fixedWidth=st,dt=et.navigatorAxis.toFixedRange(ft,ft+st,ut,ht),defined$s(dt.min)&&tt.xAxis[0].setExtremes(Math.min(dt.min,dt.max),Math.max(dt.min,dt.max),!0,null,{trigger:"navigator"})))},j.prototype.handlesMousedown=function(E,a){E=this.chart.pointer.normalize(E);var k=this,tt=k.chart,et=tt.xAxis[0],rt=k.reversedExtremes;a===0?(k.grabbedLeft=!0,k.otherHandlePos=k.zoomedMax,k.fixedExtreme=rt?et.min:et.max):(k.grabbedRight=!0,k.otherHandlePos=k.zoomedMin,k.fixedExtreme=rt?et.max:et.min),tt.fixedRange=null},j.prototype.onMouseMove=function(E){var a=this,k=a.chart,tt=a.left,et=a.navigatorSize,rt=a.range,nt=a.dragOffset,ot=k.inverted,st;(!E.touches||E.touches[0].pageX!==0)&&(E=k.pointer.normalize(E),st=E.chartX,ot&&(tt=a.top,st=E.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,st-tt,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,st-tt)):a.grabbedCenter&&(a.hasDragged=!0,st<nt?st=nt:st>et+nt-rt&&(st=et+nt-rt),a.render(0,0,st-nt,st-nt+rt)),a.hasDragged&&a.scrollbar&&pick$X(a.scrollbar.options.liveRedraw,H.svg&&!isTouchDevice$1&&!this.chart.isBoosting)&&(E.DOMType=E.type,setTimeout(function(){a.onMouseUp(E)},0)))},j.prototype.onMouseUp=function(E){var a=this,k=a.chart,tt=a.xAxis,et=a.scrollbar,rt=E.DOMEvent||E,nt=k.inverted,ot=a.rendered&&!a.hasDragged?"animate":"attr",st,lt,ht,ut,dt,ft;(a.hasDragged&&(!et||!et.hasDragged)||E.trigger==="scrollbar")&&(ht=a.getUnionExtremes(),a.zoomedMin===a.otherHandlePos?ut=a.fixedExtreme:a.zoomedMax===a.otherHandlePos&&(dt=a.fixedExtreme),a.zoomedMax===a.size&&(dt=a.reversedExtremes?ht.dataMin:ht.dataMax),a.zoomedMin===0&&(ut=a.reversedExtremes?ht.dataMax:ht.dataMin),ft=tt.navigatorAxis.toFixedRange(a.zoomedMin,a.zoomedMax,ut,dt),defined$s(ft.min)&&k.xAxis[0].setExtremes(Math.min(ft.min,ft.max),Math.max(ft.min,ft.max),!0,a.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:rt})),E.DOMType!=="mousemove"&&E.DOMType!=="touchmove"&&(a.grabbedLeft=a.grabbedRight=a.grabbedCenter=a.fixedWidth=a.fixedExtreme=a.otherHandlePos=a.hasDragged=a.dragOffset=null),a.navigatorEnabled&&isNumber$p(a.zoomedMin)&&isNumber$p(a.zoomedMax)&&(lt=Math.round(a.zoomedMin),st=Math.round(a.zoomedMax),a.shades&&a.drawMasks(lt,st,nt,ot),a.outline&&a.drawOutline(lt,st,nt,ot),a.navigatorOptions.handles.enabled&&Object.keys(a.handles).length===a.handles.length&&(a.drawHandle(lt,0,nt,ot),a.drawHandle(st,1,nt,ot)))},j.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(E){E()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},j.prototype.removeBaseSeriesEvents=function(){var E=this.baseSeries||[];this.navigatorEnabled&&E[0]&&(this.navigatorOptions.adaptToUpdatedData!==!1&&E.forEach(function(a){removeEvent$3(a,"updatedData",this.updatedDataHandler)},this),E[0].xAxis&&removeEvent$3(E[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},j.prototype.init=function(E){var a=E.options,k=a.navigator,tt=k.enabled,et=a.scrollbar,rt=et.enabled,nt=tt?k.height:0,ot=rt?et.height:0;this.handles=[],this.shades=[],this.chart=E,this.setBaseSeries(),this.height=nt,this.scrollbarHeight=ot,this.scrollbarEnabled=rt,this.navigatorEnabled=tt,this.navigatorOptions=k,this.scrollbarOptions=et,this.outlineHeight=nt+ot,this.opposite=pick$X(k.opposite,Boolean(!tt&&E.inverted));var st=this,lt=st.baseSeries,ht=E.xAxis.length,ut=E.yAxis.length,dt=lt&&lt[0]&&lt[0].xAxis||E.xAxis[0]||{options:{}};E.isDirtyBox=!0,st.navigatorEnabled?(st.xAxis=new Axis(E,merge$R({breaks:dt.options.breaks,ordinal:dt.options.ordinal},k.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:ht,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},E.inverted?{offsets:[ot,0,-ot,0],width:nt}:{offsets:[0,-ot,0,ot],height:nt})),st.yAxis=new Axis(E,merge$R(k.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:ut,isInternal:!0,reversed:pick$X(k.yAxis&&k.yAxis.reversed,E.yAxis[0]&&E.yAxis[0].reversed,!1),zoomEnabled:!1},E.inverted?{width:nt}:{height:nt})),lt||k.series.data?st.updateNavigatorSeries(!1):E.series.length===0&&(st.unbindRedraw=addEvent$F(E,"beforeRedraw",function(){E.series.length>0&&!st.series&&(st.setBaseSeries(),st.unbindRedraw())})),st.reversedExtremes=E.inverted&&!st.xAxis.reversed||!E.inverted&&st.xAxis.reversed,st.renderElements(),st.addMouseEvents()):(st.xAxis={chart:E,navigatorAxis:{fake:!0},translate:function(ft,pt){var gt=E.xAxis[0],yt=gt.getExtremes(),mt=gt.len-2*ot,xt=numExt("min",gt.options.min,yt.dataMin),wt=numExt("max",gt.options.max,yt.dataMax)-xt;return pt?ft*wt/mt+xt:mt*(ft-xt)/wt},toPixels:function(ft){return this.translate(ft)},toValue:function(ft){return this.translate(ft,!0)}},st.xAxis.navigatorAxis.axis=st.xAxis,st.xAxis.navigatorAxis.toFixedRange=NavigatorAxis.AdditionsClass.prototype.toFixedRange.bind(st.xAxis.navigatorAxis)),E.options.scrollbar.enabled&&(E.scrollbar=st.scrollbar=new Scrollbar(E.renderer,merge$R(E.options.scrollbar,{margin:st.navigatorEnabled?0:10,vertical:E.inverted}),E),addEvent$F(st.scrollbar,"changed",function(ft){var pt=st.size,gt=pt*this.to,yt=pt*this.from;st.hasDragged=st.scrollbar.hasDragged,st.render(0,0,yt,gt),this.shouldUpdateExtremes(ft.DOMType)&&setTimeout(function(){st.onMouseUp(ft)})})),st.addBaseSeriesEvents(),st.addChartEvents()},j.prototype.getUnionExtremes=function(E){var a=this.chart.xAxis[0],k=this.xAxis,tt=k.options,et=a.options,rt;return(!E||a.dataMin!==null)&&(rt={dataMin:pick$X(tt&&tt.min,numExt("min",et.min,a.dataMin,k.dataMin,k.min)),dataMax:pick$X(tt&&tt.max,numExt("max",et.max,a.dataMax,k.dataMax,k.max))}),rt},j.prototype.setBaseSeries=function(E,a){var k=this.chart,tt=this.baseSeries=[];E=E||k.options&&k.options.navigator.baseSeries||(k.series.length?find$c(k.series,function(et){return!et.options.isInternal}).index:0),(k.series||[]).forEach(function(et,rt){!et.options.isInternal&&(et.options.showInNavigator||(rt===E||et.options.id===E)&&et.options.showInNavigator!==!1)&&tt.push(et)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)},j.prototype.updateNavigatorSeries=function(E,a){var k=this,tt=k.chart,et=k.baseSeries,rt,nt,ot=k.navigatorOptions.series,st,lt={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},ht=k.series=(k.series||[]).filter(function(ut){var dt=ut.baseSeries;return et.indexOf(dt)<0?(dt&&(removeEvent$3(dt,"updatedData",k.updatedDataHandler),delete dt.navigatorSeries),ut.chart&&ut.destroy(),!1):!0});et&&et.length&&et.forEach(function(dt){var ft=dt.navigatorSeries,pt=extend$13({color:dt.color,visible:dt.visible},isArray$8(ot)?defaultOptions$7.navigator.series:ot);if(!(ft&&k.navigatorOptions.adaptToUpdatedData===!1)){lt.name="Navigator "+et.length,rt=dt.options||{},st=rt.navigatorOptions||{},pt.dataLabels=splat$9(pt.dataLabels),nt=merge$R(rt,lt,pt,st),nt.pointRange=pick$X(pt.pointRange,st.pointRange,defaultOptions$7.plotOptions[nt.type||"line"].pointRange);var gt=st.data||pt.data;k.hasNavigatorData=k.hasNavigatorData||!!gt,nt.data=gt||rt.data&&rt.data.slice(0),ft&&ft.options?ft.update(nt,a):(dt.navigatorSeries=tt.initSeries(nt),dt.navigatorSeries.baseSeries=dt,ht.push(dt.navigatorSeries))}}),(ot.data&&!(et&&et.length)||isArray$8(ot))&&(k.hasNavigatorData=!1,ot=splat$9(ot),ot.forEach(function(ut,dt){lt.name="Navigator "+(ht.length+1),nt=merge$R(defaultOptions$7.navigator.series,{color:tt.series[dt]&&!tt.series[dt].options.isInternal&&tt.series[dt].color||tt.options.colors[dt]||tt.options.colors[0]},lt,ut),nt.data=ut.data,nt.data&&(k.hasNavigatorData=!0,ht.push(tt.initSeries(nt)))})),E&&this.addBaseSeriesEvents()},j.prototype.addBaseSeriesEvents=function(){var E=this,a=E.baseSeries||[];a[0]&&a[0].xAxis&&a[0].eventsToUnbind.push(addEvent$F(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),a.forEach(function(k){k.eventsToUnbind.push(addEvent$F(k,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),k.eventsToUnbind.push(addEvent$F(k,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),this.navigatorOptions.adaptToUpdatedData!==!1&&k.xAxis&&k.eventsToUnbind.push(addEvent$F(k,"updatedData",this.updatedDataHandler)),k.eventsToUnbind.push(addEvent$F(k,"remove",function(){this.navigatorSeries&&(erase$1(E.series,this.navigatorSeries),defined$s(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)},j.prototype.getBaseSeriesMin=function(E){return this.baseSeries.reduce(function(a,k){return Math.min(a,k.xData?k.xData[0]:a)},E)},j.prototype.modifyNavigatorAxisExtremes=function(){var E=this.xAxis,a;typeof E.getExtremes<"u"&&(a=this.getUnionExtremes(!0),a&&(a.dataMin!==E.min||a.dataMax!==E.max)&&(E.min=a.dataMin,E.max=a.dataMax))},j.prototype.modifyBaseAxisExtremes=function(){var E=this,a=E.chart.navigator,k=E.getExtremes(),tt=k.min,et=k.max,rt=k.dataMin,nt=k.dataMax,ot=et-tt,st=a.stickToMin,lt=a.stickToMax,ht=pick$X(E.options.overscroll,0),ut,dt,ft=a.series&&a.series[0],pt=!!E.setExtremes,gt=E.eventArgs&&E.eventArgs.trigger==="rangeSelectorButton";gt||(st&&(dt=rt,ut=dt+ot),lt&&(ut=nt+ht,st||(dt=Math.max(rt,ut-ot,a.getBaseSeriesMin(ft&&ft.xData?ft.xData[0]:-Number.MAX_VALUE)))),pt&&(st||lt)&&isNumber$p(dt)&&(E.min=E.userMin=dt,E.max=E.userMax=ut)),a.stickToMin=a.stickToMax=null},j.prototype.updatedDataHandler=function(){var E=this.chart.navigator,a=this,k=this.navigatorSeries;E.stickToMax=E.reversedExtremes?Math.round(E.zoomedMin)===0:Math.round(E.zoomedMax)>=Math.round(E.size),E.stickToMin=E.shouldStickToMin(a,E),k&&!E.hasNavigatorData&&(k.options.pointStart=a.xData[0],k.setData(a.options.data,!1,null,!1))},j.prototype.shouldStickToMin=function(E,a){var k=a.getBaseSeriesMin(E.xData[0]),tt=E.xAxis,et=tt.max,rt=tt.min,nt=tt.options.range,ot=!0;return isNumber$p(et)&&isNumber$p(rt)?nt&&et-k>0?ot=et-k<nt&&!this.chart.fixedRange:ot=rt<=k:ot=!1,ot},j.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(addEvent$F(this.chart,"redraw",function(){var E=this.navigator,a=E&&(E.baseSeries&&E.baseSeries[0]&&E.baseSeries[0].xAxis||this.xAxis[0]);a&&E.render(a.min,a.max)}),addEvent$F(this.chart,"getMargins",function(){var E=this,a=E.navigator,k=a.opposite?"plotTop":"marginBottom";E.inverted&&(k=a.opposite?"marginRight":"plotLeft"),E[k]=(E[k]||0)+(a.navigatorEnabled||!E.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))},j.prototype.destroy=function(){this.removeEvents(),this.xAxis&&(erase$1(this.chart.xAxis,this.xAxis),erase$1(this.chart.axes,this.xAxis)),this.yAxis&&(erase$1(this.chart.yAxis,this.yAxis),erase$1(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(E){E.destroy&&E.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(E){this[E]&&this[E].destroy&&this[E].destroy(),this[E]=null},this),[this.handles].forEach(function(E){destroyObjectProperties$2(E)},this)},j}();H.Navigator||(H.Navigator=Navigator,NavigatorAxis.compose(Axis),addEvent$F(Chart$1,"beforeShowResetZoom",function(){var j=this.options,E=j.navigator,a=j.rangeSelector;if((E&&E.enabled||a&&a.enabled)&&(!isTouchDevice$1&&j.chart.zoomType==="x"||isTouchDevice$1&&j.chart.pinchType==="x"))return!1}),addEvent$F(Chart$1,"beforeRender",function(){var j=this.options;(j.navigator.enabled||j.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this))}),addEvent$F(Chart$1,"afterSetChartSize",function(){var j=this.legend,E=this.navigator,a,k,tt,et;E&&(k=j&&j.options,tt=E.xAxis,et=E.yAxis,a=E.scrollbarHeight,this.inverted?(E.left=E.opposite?this.chartWidth-a-E.height:this.spacing[3]+a,E.top=this.plotTop+a):(E.left=pick$X(tt.left,this.plotLeft+a),E.top=E.navigatorOptions.top||this.chartHeight-E.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(k&&k.verticalAlign==="bottom"&&k.layout!=="proximate"&&k.enabled&&!k.floating?j.legendHeight+pick$X(k.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),tt&&et&&(this.inverted?tt.options.left=et.options.left=E.left:tt.options.top=et.options.top=E.top,tt.setAxisSize(),et.setAxisSize()))}),addEvent$F(Chart$1,"update",function(j){var E=j.options.navigator||{},a=j.options.scrollbar||{};!this.navigator&&!this.scroller&&(E.enabled||a.enabled)&&(merge$R(!0,this.options.navigator,E),merge$R(!0,this.options.scrollbar,a),delete j.options.navigator,delete j.options.scrollbar)}),addEvent$F(Chart$1,"afterUpdate",function(j){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new Navigator(this),pick$X(j.redraw,!0)&&this.redraw(j.animation))}),addEvent$F(Chart$1,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),addEvent$F(Series$e,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),Chart$1.prototype.callbacks.push(function(j){var E,a=j.navigator;a&&j.xAxis[0]&&(E=j.xAxis[0].getExtremes(),a.render(E.min,E.max))}));H.Navigator=Navigator;H.Navigator;var defaultOptions$6=DefaultOptions.defaultOptions,addEvent$E=Utilities.addEvent,createElement$3=Utilities.createElement,css$2=Utilities.css,defined$r=Utilities.defined,destroyObjectProperties$1=Utilities.destroyObjectProperties,discardElement$2=Utilities.discardElement,extend$12=Utilities.extend,find$b=Utilities.find,fireEvent$j=Utilities.fireEvent,isNumber$o=Utilities.isNumber,merge$Q=Utilities.merge,objectEach$d=Utilities.objectEach,pad=Utilities.pad,pick$W=Utilities.pick,pInt$3=Utilities.pInt,splat$8=Utilities.splat;extend$12(defaultOptions$6,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:palette.highlightColor80,cursor:"pointer"},labelStyle:{color:palette.neutralColor60}}});extend$12(defaultOptions$6.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"});var RangeSelector=function(){function j(E){this.buttons=void 0,this.buttonOptions=j.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=E,this.init(E)}return j.prototype.clickButton=function(E,a){var k=this,tt=k.chart,et=k.buttonOptions[E],rt=tt.xAxis[0],nt=tt.scroller&&tt.scroller.getUnionExtremes()||rt||{},ot=nt.dataMin,st=nt.dataMax,lt,ht=rt&&Math.round(Math.min(rt.max,pick$W(st,rt.max))),ut=et.type,dt,ft=et._range,pt,gt,yt,mt,xt,wt=et.dataGrouping;if(!(ot===null||st===null)){if(tt.fixedRange=ft,k.setSelected(E),wt&&(this.forcedDataGrouping=!0,Axis.prototype.setDataGrouping.call(rt||{chart:this.chart},wt,!1),this.frozenStates=et.preserveDataGrouping),ut==="month"||ut==="year")rt?(mt={range:et,max:ht,chart:tt,dataMin:ot,dataMax:st},lt=rt.minFromRange.call(mt),isNumber$o(mt.newMax)&&(ht=mt.newMax)):ft=et;else if(ft)lt=Math.max(ht-ft,ot),ht=Math.min(lt+ft,st);else if(ut==="ytd")if(rt)typeof st>"u"&&(ot=Number.MAX_VALUE,st=Number.MIN_VALUE,tt.series.forEach(function(Mt){var At=Mt.xData;ot=Math.min(At[0],ot),st=Math.max(At[At.length-1],st)}),a=!1),xt=k.getYTDExtremes(st,ot,tt.time.useUTC),lt=pt=xt.min,ht=xt.max;else{k.deferredYTDClick=E;return}else ut==="all"&&rt&&(tt.navigator&&tt.navigator.baseSeries[0]&&(tt.navigator.baseSeries[0].xAxis.options.range=void 0),lt=ot,ht=st);defined$r(lt)&&(lt+=et._offsetMin),defined$r(ht)&&(ht+=et._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=E+1),rt?rt.setExtremes(lt,ht,pick$W(a,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:et}):(dt=splat$8(tt.options.xAxis)[0],yt=dt.range,dt.range=ft,gt=dt.min,dt.min=pt,addEvent$E(tt,"load",function(){dt.range=yt,dt.min=gt})),fireEvent$j(this,"afterBtnClick")}},j.prototype.setSelected=function(E){this.selected=this.options.selected=E},j.prototype.init=function(E){var a=this,k=E.options.rangeSelector,tt=k.buttons||a.defaultButtons.slice(),et=k.selected,rt=function(){var nt=a.minInput,ot=a.maxInput;nt&&nt.blur&&fireEvent$j(nt,"blur"),ot&&ot.blur&&fireEvent$j(ot,"blur")};a.chart=E,a.options=k,a.buttons=[],a.buttonOptions=tt,this.eventsToUnbind=[],this.eventsToUnbind.push(addEvent$E(E.container,"mousedown",rt)),this.eventsToUnbind.push(addEvent$E(E,"resize",rt)),tt.forEach(a.computeButtonRange),typeof et<"u"&&tt[et]&&this.clickButton(et,!1),this.eventsToUnbind.push(addEvent$E(E,"load",function(){E.xAxis&&E.xAxis[0]&&addEvent$E(E.xAxis[0],"setExtremes",function(nt){this.max-this.min!==E.fixedRange&&nt.trigger!=="rangeSelectorButton"&&nt.trigger!=="updatedData"&&a.forcedDataGrouping&&!a.frozenStates&&this.setDataGrouping(!1,!1)})}))},j.prototype.updateButtonStates=function(){var E=this,a=this.chart,k=this.dropdown,tt=a.xAxis[0],et=Math.round(tt.max-tt.min),rt=!tt.hasVisibleSeries,nt=24*36e5,ot=a.scroller&&a.scroller.getUnionExtremes()||tt,st=ot.dataMin,lt=ot.dataMax,ht=E.getYTDExtremes(lt,st,a.time.useUTC),ut=ht.min,dt=ht.max,ft=E.selected,pt=isNumber$o(ft),gt=E.options.allButtonsEnabled,yt=E.buttons;E.buttonOptions.forEach(function(mt,xt){var wt=mt._range,Mt=mt.type,At=mt.count||1,St=yt[xt],$t=0,Tt,Pt,It=mt._offsetMax-mt._offsetMin,Lt=xt===ft,Nt=wt>lt-st,Ht=wt<tt.minRange,jt=!1,Dt=!1,Ft=wt===et;(Mt==="month"||Mt==="year")&&et+36e5>={month:28,year:365}[Mt]*nt*At-It&&et-36e5<={month:31,year:366}[Mt]*nt*At+It?Ft=!0:Mt==="ytd"?(Ft=dt-ut+It===et,jt=!Lt):Mt==="all"&&(Ft=tt.max-tt.min>=lt-st,Dt=!Lt&&pt&&Ft),Tt=!gt&&(Nt||Ht||Dt||rt),Pt=Lt&&Ft||Ft&&!pt&&!jt||Lt&&E.frozenStates,Tt?$t=3:Pt&&(pt=!0,$t=2),St.state!==$t&&(St.setState($t),k&&(k.options[xt+1].disabled=Tt,$t===2&&(k.selectedIndex=xt+1)),$t===0&&ft===xt&&E.setSelected())})},j.prototype.computeButtonRange=function(E){var a=E.type,k=E.count||1,tt={millisecond:1,second:1e3,minute:60*1e3,hour:3600*1e3,day:24*3600*1e3,week:7*24*3600*1e3};tt[a]?E._range=tt[a]*k:(a==="month"||a==="year")&&(E._range={month:30,year:365}[a]*24*36e5*k),E._offsetMin=pick$W(E.offsetMin,0),E._offsetMax=pick$W(E.offsetMax,0),E._range+=E._offsetMax-E._offsetMin},j.prototype.getInputValue=function(E){var a=E==="min"?this.minInput:this.maxInput,k=this.chart.options.rangeSelector,tt=this.chart.time;return a?(a.type==="text"&&k.inputDateParser||this.defaultInputDateParser)(a.value,tt.useUTC,tt):0},j.prototype.setInputValue=function(E,a){var k=this.options,tt=this.chart.time,et=E==="min"?this.minInput:this.maxInput,rt=E==="min"?this.minDateBox:this.maxDateBox;if(et){var nt=et.getAttribute("data-hc-time"),ot=defined$r(nt)?Number(nt):void 0;if(defined$r(a)){var st=ot;defined$r(st)&&et.setAttribute("data-hc-time-previous",st),et.setAttribute("data-hc-time",a),ot=a}et.value=tt.dateFormat(this.inputTypeFormats[et.type]||k.inputEditDateFormat,ot),rt&&rt.attr({text:tt.dateFormat(k.inputDateFormat,ot)})}},j.prototype.setInputExtremes=function(E,a,k){var tt=E==="min"?this.minInput:this.maxInput;if(tt){var et=this.inputTypeFormats[tt.type],rt=this.chart.time;if(et){var nt=rt.dateFormat(et,a);tt.min!==nt&&(tt.min=nt);var ot=rt.dateFormat(et,k);tt.max!==ot&&(tt.max=ot)}}},j.prototype.showInput=function(E){var a=E==="min"?this.minDateBox:this.maxDateBox,k=E==="min"?this.minInput:this.maxInput;if(k&&a&&this.inputGroup){var tt=k.type==="text",et=this.inputGroup,rt=et.translateX,nt=et.translateY,ot=this.options.inputBoxWidth;css$2(k,{width:tt?a.width+(ot?-2:20)+"px":"auto",height:tt?a.height-2+"px":"auto",border:"2px solid silver"}),tt&&ot?css$2(k,{left:rt+a.x+"px",top:nt+"px"}):css$2(k,{left:Math.min(Math.round(a.x+rt-(k.offsetWidth-a.width)/2),this.chart.chartWidth-k.offsetWidth)+"px",top:nt-(k.offsetHeight-a.height)/2+"px"})}},j.prototype.hideInput=function(E){var a=E==="min"?this.minInput:this.maxInput;a&&css$2(a,{top:"-9999em",border:0,width:"1px",height:"1px"})},j.prototype.defaultInputDateParser=function(E,a,k){var tt=function(st){return st.length>6&&(st.lastIndexOf("-")===st.length-6||st.lastIndexOf("+")===st.length-6)},et=E.split("/").join("-").split(" ").join("T");if(et.indexOf("T")===-1&&(et+="T00:00"),a)et+="Z";else if(H.isSafari&&!tt(et)){var rt=new Date(et).getTimezoneOffset()/60;et+=rt<=0?"+"+pad(-rt)+":00":"-"+pad(rt)+":00"}var nt=Date.parse(et);if(!isNumber$o(nt)){var ot=E.split("-");nt=Date.UTC(pInt$3(ot[0]),pInt$3(ot[1])-1,pInt$3(ot[2]))}return k&&a&&isNumber$o(nt)&&(nt+=k.getTimezoneOffset(nt)),nt},j.prototype.drawInput=function(E){var a=this,k=a.chart,tt=a.div,et=a.inputGroup,rt=this,nt=k.renderer.style||{},ot=k.renderer,st=k.options.rangeSelector,lt=defaultOptions$6.lang,ht=E==="min";function ut(){var mt=rt.getInputValue(E),xt=k.xAxis[0],wt=k.scroller&&k.scroller.xAxis?k.scroller.xAxis:xt,Mt=wt.dataMin,At=wt.dataMax,St=rt.maxInput,$t=rt.minInput;mt!==Number(gt.getAttribute("data-hc-time-previous"))&&isNumber$o(mt)&&(gt.setAttribute("data-hc-time-previous",mt),ht&&St&&isNumber$o(Mt)?mt>Number(St.getAttribute("data-hc-time"))?mt=void 0:mt<Mt&&(mt=Mt):$t&&isNumber$o(At)&&(mt<Number($t.getAttribute("data-hc-time"))?mt=void 0:mt>At&&(mt=At)),typeof mt<"u"&&xt.setExtremes(ht?mt:xt.min,ht?xt.max:mt,void 0,void 0,{trigger:"rangeSelectorInput"}))}var dt=lt[ht?"rangeSelectorFrom":"rangeSelectorTo"]||"",ft=ot.label(dt,0).addClass("highcharts-range-label").attr({padding:dt?2:0,height:dt?st.inputBoxHeight:0}).add(et),pt=ot.label("",0).addClass("highcharts-range-input").attr({padding:2,width:st.inputBoxWidth,height:st.inputBoxHeight,"text-align":"center"}).on("click",function(){rt.showInput(E),rt[E+"Input"].focus()});k.styledMode||pt.attr({stroke:st.inputBoxBorderColor,"stroke-width":1}),pt.add(et);var gt=createElement$3("input",{name:E,className:"highcharts-range-selector"},void 0,tt);gt.setAttribute("type",preferredInputType(st.inputDateFormat||"%b %e, %Y")),k.styledMode||(ft.css(merge$Q(nt,st.labelStyle)),pt.css(merge$Q({color:palette.neutralColor80},nt,st.inputStyle)),css$2(gt,extend$12({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:nt.fontSize,fontFamily:nt.fontFamily,top:"-9999em"},st.inputStyle))),gt.onfocus=function(){rt.showInput(E)},gt.onblur=function(){gt===H.doc.activeElement&&ut(),rt.hideInput(E),rt.setInputValue(E),gt.blur()};var yt=!1;return gt.onchange=function(){yt||(ut(),rt.hideInput(E),gt.blur())},gt.onkeypress=function(mt){mt.keyCode===13&&ut()},gt.onkeydown=function(mt){yt=!0,(mt.keyCode===38||mt.keyCode===40)&&ut()},gt.onkeyup=function(){yt=!1},{dateBox:pt,input:gt,label:ft}},j.prototype.getPosition=function(){var E=this.chart,a=E.options.rangeSelector,k=a.verticalAlign==="top"?E.plotTop-E.axisOffset[0]:0;return{buttonTop:k+a.buttonPosition.y,inputTop:k+a.inputPosition.y-10}},j.prototype.getYTDExtremes=function(E,a,k){var tt=this.chart.time,et,rt=new tt.Date(E),nt=tt.get("FullYear",rt),ot=k?tt.Date.UTC(nt,0,1):+new tt.Date(nt,0,1);et=Math.max(a,ot);var st=rt.getTime();return{max:Math.min(E||st,st),min:et}},j.prototype.render=function(E,a){var k=this.chart,tt=k.renderer,et=k.container,rt=k.options,nt=rt.rangeSelector,ot=pick$W(rt.chart.style&&rt.chart.style.zIndex,0)+1,st=nt.inputEnabled,lt=this.rendered;if(nt.enabled!==!1){if(!lt&&(this.group=tt.g("range-selector-group").attr({zIndex:7}).add(),this.div=createElement$3("div",void 0,{position:"relative",height:0,zIndex:ot}),this.buttonOptions.length&&this.renderButtons(),et.parentNode&&et.parentNode.insertBefore(this.div,et),st)){this.inputGroup=tt.g("input-group").add(this.group);var ht=this.drawInput("min");this.minDateBox=ht.dateBox,this.minLabel=ht.label,this.minInput=ht.input;var ut=this.drawInput("max");this.maxDateBox=ut.dateBox,this.maxLabel=ut.label,this.maxInput=ut.input}if(st){this.setInputValue("min",E),this.setInputValue("max",a);var dt=k.scroller&&k.scroller.getUnionExtremes()||k.xAxis[0]||{};if(defined$r(dt.dataMin)&&defined$r(dt.dataMax)){var ft=k.xAxis[0].minRange||0;this.setInputExtremes("min",dt.dataMin,Math.min(dt.dataMax,this.getInputValue("max"))-ft),this.setInputExtremes("max",Math.max(dt.dataMin,this.getInputValue("min"))+ft,dt.dataMax)}if(this.inputGroup){var pt=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(gt){if(gt){var yt=gt.getBBox().width;yt&&(gt.attr({x:pt}),pt+=yt+nt.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},j.prototype.renderButtons=function(){var E=this,a=this,k=a.buttons,tt=a.chart,et=a.options,rt=defaultOptions$6.lang,nt=tt.renderer,ot=merge$Q(et.buttonTheme),st=ot&&ot.states,lt=ot.width||28;delete ot.width,delete ot.states,this.buttonGroup=nt.g("range-selector-buttons").add(this.group);var ht=this.dropdown=createElement$3("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);addEvent$E(ht,"touchstart",function(){ht.style.fontSize="16px"}),[[H.isMS?"mouseover":"mouseenter"],[H.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(ut){var dt=ut[0],ft=ut[1];addEvent$E(ht,dt,function(){var pt=k[E.currentButtonIndex()];pt&&fireEvent$j(pt.element,ft||dt)})}),this.zoomText=nt.label(rt&&rt.rangeSelectorZoom||"",0).attr({padding:et.buttonTheme.padding,height:et.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(et.labelStyle),ot["stroke-width"]=pick$W(ot["stroke-width"],0)),createElement$3("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,ht),this.buttonOptions.forEach(function(ut,dt){createElement$3("option",{textContent:ut.title||ut.text},void 0,ht),k[dt]=nt.button(ut.text,0,0,function(ft){var pt=ut.events&&ut.events.click,gt;pt&&(gt=pt.call(ut,ft)),gt!==!1&&E.clickButton(dt),E.isActive=!0},ot,st&&st.hover,st&&st.select,st&&st.disabled).attr({"text-align":"center",width:lt}).add(E.buttonGroup),ut.title&&k[dt].attr("title",ut.title)})},j.prototype.alignElements=function(){var E=this,a=this,k=a.buttonGroup,tt=a.buttons,et=a.chart,rt=a.group,nt=a.inputGroup,ot=a.options,st=a.zoomText,lt=et.options,ht=lt.exporting&&lt.exporting.enabled!==!1&&lt.navigation&&lt.navigation.buttonOptions,ut=ot.buttonPosition,dt=ot.inputPosition,ft=ot.verticalAlign,pt=function(Ht,jt){return ht&&E.titleCollision(et)&&ft==="top"&&jt.align==="right"&&jt.y-Ht.getBBox().height-12<(ht.y||0)+(ht.height||0)+et.spacing[0]?-40:0},gt=et.plotLeft;if(rt&&ut&&dt){var yt=ut.x-et.spacing[3];if(k){if(this.positionButtons(),!this.initialButtonGroupWidth){var mt=0;st&&(mt+=st.getBBox().width+5),tt.forEach(function(Ht,jt){mt+=Ht.width,jt!==tt.length-1&&(mt+=ot.buttonSpacing)}),this.initialButtonGroupWidth=mt}gt-=et.spacing[3],this.updateButtonStates();var xt=pt(k,ut);this.alignButtonGroup(xt),rt.placed=k.placed=et.hasLoaded}var wt=0;nt&&(wt=pt(nt,dt),dt.align==="left"?yt=gt:dt.align==="right"&&(yt=-Math.max(et.axisOffset[1],-wt)),nt.align({y:dt.y,width:nt.getBBox().width,align:dt.align,x:dt.x+yt-2},!0,et.spacingBox),nt.placed=et.hasLoaded),this.handleCollision(wt),rt.align({verticalAlign:ft},!0,et.spacingBox);var Mt=rt.alignAttr.translateY,At=rt.getBBox().height+20,St=0;if(ft==="bottom"){var $t=et.legend&&et.legend.options,Tt=$t&&$t.verticalAlign==="bottom"&&$t.enabled&&!$t.floating?et.legend.legendHeight+pick$W($t.margin,10):0;At=At+Tt-20,St=Mt-At-(ot.floating?0:ot.y)-(et.titleOffset?et.titleOffset[2]:0)-10}ft==="top"?(ot.floating&&(St=0),et.titleOffset&&et.titleOffset[0]&&(St=et.titleOffset[0]),St+=et.margin[0]-et.spacing[0]||0):ft==="middle"&&(dt.y===ut.y?St=Mt:(dt.y||ut.y)&&(dt.y<0||ut.y<0?St-=Math.min(dt.y,ut.y):St=Mt-At)),rt.translate(ot.x,ot.y+Math.floor(St));var Pt=this,It=Pt.minInput,Lt=Pt.maxInput,Nt=Pt.dropdown;ot.inputEnabled&&It&&Lt&&(It.style.marginTop=rt.translateY+"px",Lt.style.marginTop=rt.translateY+"px"),Nt&&(Nt.style.marginTop=rt.translateY+"px")}},j.prototype.alignButtonGroup=function(E,a){var k=this,tt=k.chart,et=k.options,rt=k.buttonGroup;k.buttons;var nt=et.buttonPosition,ot=tt.plotLeft-tt.spacing[3],st=nt.x-tt.spacing[3];nt.align==="right"?st+=E-ot:nt.align==="center"&&(st-=ot/2),rt&&rt.align({y:nt.y,width:pick$W(a,this.initialButtonGroupWidth),align:nt.align,x:st},!0,tt.spacingBox)},j.prototype.positionButtons=function(){var E=this,a=E.buttons,k=E.chart,tt=E.options,et=E.zoomText,rt=k.hasLoaded?"animate":"attr",nt=tt.buttonPosition,ot=k.plotLeft,st=ot;et&&et.visibility!=="hidden"&&(et[rt]({x:pick$W(ot+nt.x,ot)}),st+=nt.x+et.getBBox().width+5),this.buttonOptions.forEach(function(lt,ht){a[ht].visibility!=="hidden"?(a[ht][rt]({x:st}),st+=a[ht].width+tt.buttonSpacing):a[ht][rt]({x:ot})})},j.prototype.handleCollision=function(E){var a=this,k=this,tt=k.chart,et=k.buttonGroup,rt=k.inputGroup,nt=this.options,ot=nt.buttonPosition,st=nt.dropdown,lt=nt.inputPosition,ht=function(){var ft=0;return a.buttons.forEach(function(pt){var gt=pt.getBBox();gt.width>ft&&(ft=gt.width)}),ft},ut=function(ft){if(rt&&et){var pt=rt.alignAttr.translateX+rt.alignOptions.x-E+rt.getBBox().x+2,gt=rt.alignOptions.width,yt=et.alignAttr.translateX+et.getBBox().x;return yt+ft>pt&&pt+gt>yt&&ot.y<lt.y+rt.getBBox().height}return!1},dt=function(){rt&&et&&rt.attr({translateX:rt.alignAttr.translateX+(tt.axisOffset[1]>=-E?0:-E),translateY:rt.alignAttr.translateY+et.getBBox().height+10})};if(et){if(st==="always"){this.collapseButtons(E),ut(ht())&&dt();return}st==="never"&&this.expandButtons()}rt&&et?lt.align===ot.align||ut(this.initialButtonGroupWidth+20)?st==="responsive"?(this.collapseButtons(E),ut(ht())&&dt()):dt():st==="responsive"&&this.expandButtons():et&&st==="responsive"&&(this.initialButtonGroupWidth>tt.plotWidth?this.collapseButtons(E):this.expandButtons())},j.prototype.collapseButtons=function(E){var a=this,k=a.buttons,tt=a.buttonOptions,et=a.chart,rt=a.dropdown,nt=a.options,ot=a.zoomText,st=et.userOptions.rangeSelector&&et.userOptions.rangeSelector.buttonTheme||{},lt=function(dt){return{text:dt?dt+" ▾":"▾",width:"auto",paddingLeft:pick$W(nt.buttonTheme.paddingLeft,st.padding,8),paddingRight:pick$W(nt.buttonTheme.paddingRight,st.padding,8)}};ot&&ot.hide();var ht=!1;tt.forEach(function(dt,ft){var pt=k[ft];pt.state!==2?pt.hide():(pt.show(),pt.attr(lt(dt.text)),ht=!0)}),ht||(rt&&(rt.selectedIndex=0),k[0].show(),k[0].attr(lt(this.zoomText&&this.zoomText.textStr)));var ut=nt.buttonPosition.align;this.positionButtons(),(ut==="right"||ut==="center")&&this.alignButtonGroup(E,k[this.currentButtonIndex()].getBBox().width),this.showDropdown()},j.prototype.expandButtons=function(){var E=this,a=E.buttons,k=E.buttonOptions,tt=E.options,et=E.zoomText;this.hideDropdown(),et&&et.show(),k.forEach(function(rt,nt){var ot=a[nt];ot.show(),ot.attr({text:rt.text,width:tt.buttonTheme.width||28,paddingLeft:pick$W(tt.buttonTheme.paddingLeft,"unset"),paddingRight:pick$W(tt.buttonTheme.paddingRight,"unset")}),ot.state<2&&ot.setState(0)}),this.positionButtons()},j.prototype.currentButtonIndex=function(){var E=this.dropdown;return E&&E.selectedIndex>0?E.selectedIndex-1:0},j.prototype.showDropdown=function(){var E=this,a=E.buttonGroup,k=E.buttons,tt=E.chart,et=E.dropdown;if(a&&et){var rt=a.translateX,nt=a.translateY,ot=k[this.currentButtonIndex()].getBBox();css$2(et,{left:tt.plotLeft+rt+"px",top:nt+.5+"px",width:ot.width+"px",height:ot.height+"px"}),this.hasVisibleDropdown=!0}},j.prototype.hideDropdown=function(){var E=this.dropdown;E&&(css$2(E,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},j.prototype.getHeight=function(){var E=this,a=E.options,k=E.group,tt=a.inputPosition,et=a.buttonPosition,rt=a.y,nt=et.y,ot=tt.y,st=0,lt;return a.height?a.height:(this.alignElements(),st=k?k.getBBox(!0).height+13+rt:0,lt=Math.min(ot,nt),(ot<0&&nt<0||ot>0&&nt>0)&&(st+=Math.abs(lt)),st)},j.prototype.titleCollision=function(E){return!(E.options.title.text||E.options.subtitle.text)},j.prototype.update=function(E){var a=this.chart;merge$Q(!0,a.options.rangeSelector,E),this.destroy(),this.init(a),this.render()},j.prototype.destroy=function(){var E=this,a=E.minInput,k=E.maxInput;E.eventsToUnbind&&(E.eventsToUnbind.forEach(function(tt){return tt()}),E.eventsToUnbind=void 0),destroyObjectProperties$1(E.buttons),a&&(a.onfocus=a.onblur=a.onchange=null),k&&(k.onfocus=k.onblur=k.onchange=null),objectEach$d(E,function(tt,et){tt&&et!=="chart"&&(tt instanceof SVGElement?tt.destroy():tt instanceof window.HTMLElement&&discardElement$2(tt)),tt!==j.prototype[et]&&(E[et]=null)},this)},j}();RangeSelector.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];RangeSelector.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};function preferredInputType(j){var E=j.indexOf("%L")!==-1;if(E)return"text";var a=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(tt){return j.indexOf("%"+tt)!==-1}),k=["H","k","I","l","M","S"].some(function(tt){return j.indexOf("%"+tt)!==-1});return a&&k?"datetime-local":a?"date":k?"time":"text"}Axis.prototype.minFromRange=function(){var j=this.range,E=j.type,a,k=this.max,tt,et,rt=this.chart.time,nt=function(ot,st){var lt=E==="year"?"FullYear":"Month",ht=new rt.Date(ot),ut=rt.get(lt,ht);return rt.set(lt,ht,ut+st),ut===rt.get(lt,ht)&&rt.set("Date",ht,0),ht.getTime()-ot};return isNumber$o(j)?(a=k-j,et=j):(a=k+nt(k,-j.count),this.chart&&(this.chart.fixedRange=k-a)),tt=pick$W(this.dataMin,Number.MIN_VALUE),isNumber$o(a)||(a=tt),a<=tt&&(a=tt,typeof et>"u"&&(et=nt(a,j.count)),this.newMax=Math.min(a+et,this.dataMax)),isNumber$o(k)||(a=void 0),a};if(!H.RangeSelector){var chartDestroyEvents_1=[],initRangeSelector_1=function(j){var E,a=j.rangeSelector,k,tt,et;function rt(){a&&(E=j.xAxis[0].getExtremes(),k=j.legend,et=a&&a.options.verticalAlign,isNumber$o(E.min)&&a.render(E.min,E.max),k.display&&et==="top"&&et===k.options.verticalAlign&&(tt=merge$Q(j.spacingBox),k.options.layout==="vertical"?tt.y=j.plotTop:tt.y+=a.getHeight(),k.group.placed=!1,k.align(tt)))}if(a){var nt=find$b(chartDestroyEvents_1,function(ot){return ot[0]===j});nt||chartDestroyEvents_1.push([j,[addEvent$E(j.xAxis[0],"afterSetExtremes",function(ot){a&&a.render(ot.min,ot.max)}),addEvent$E(j,"redraw",rt)]]),rt()}};addEvent$E(Chart$1,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new RangeSelector(this))}),addEvent$E(Chart$1,"beforeRender",function(){var j=this,E=j.axes,a=j.rangeSelector,k;a&&(isNumber$o(a.deferredYTDClick)&&(a.clickButton(a.deferredYTDClick),delete a.deferredYTDClick),E.forEach(function(tt){tt.updateNames(),tt.setScale()}),j.getAxisMargins(),a.render(),k=a.options.verticalAlign,a.options.floating||(k==="bottom"?this.extraBottomMargin=!0:k!=="middle"&&(this.extraTopMargin=!0)))}),addEvent$E(Chart$1,"update",function(j){var E=this,a=j.options,k=a.rangeSelector,tt=E.rangeSelector,et,rt=this.extraBottomMargin,nt=this.extraTopMargin;k&&k.enabled&&!defined$r(tt)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=tt=new RangeSelector(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,tt&&(initRangeSelector_1(this),et=k&&k.verticalAlign||tt.options&&tt.options.verticalAlign,tt.options.floating||(et==="bottom"?this.extraBottomMargin=!0:et!=="middle"&&(this.extraTopMargin=!0)),(this.extraBottomMargin!==rt||this.extraTopMargin!==nt)&&(this.isDirtyBox=!0))}),addEvent$E(Chart$1,"render",function(){var j=this,E=j.rangeSelector,a;E&&!E.options.floating&&(E.render(),a=E.options.verticalAlign,a==="bottom"?this.extraBottomMargin=!0:a!=="middle"&&(this.extraTopMargin=!0))}),addEvent$E(Chart$1,"getMargins",function(){var j=this.rangeSelector,E;j&&(E=j.getHeight(),this.extraTopMargin&&(this.plotTop+=E),this.extraBottomMargin&&(this.marginBottom+=E))}),Chart$1.prototype.callbacks.push(initRangeSelector_1),addEvent$E(Chart$1,"destroy",function(){for(var E=0;E<chartDestroyEvents_1.length;E++){var a=chartDestroyEvents_1[E];if(a[0]===this){a[1].forEach(function(k){return k()}),chartDestroyEvents_1.splice(E,1);return}}}),H.RangeSelector=RangeSelector}var __extends$1X=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),animObject$4=animationExports.animObject,format$7=FormatUtilities.format,getOptions$2=DefaultOptions.getOptions,pointTooltipFormatter=Point$5.prototype.tooltipFormatter,_a$c=Series$e.prototype,seriesInit=_a$c.init,seriesProcessData=_a$c.processData,addEvent$D=Utilities.addEvent,arrayMax$4=Utilities.arrayMax,arrayMin$4=Utilities.arrayMin,clamp$a=Utilities.clamp,defined$q=Utilities.defined,extend$11=Utilities.extend,find$a=Utilities.find,isNumber$n=Utilities.isNumber,isString$3=Utilities.isString,merge$P=Utilities.merge,pick$V=Utilities.pick,splat$7=Utilities.splat,StockChart=function(j){__extends$1X(E,j);function E(){return j!==null&&j.apply(this,arguments)||this}return E.prototype.init=function(a,k){var tt=getOptions$2(),et=a.xAxis,rt=a.yAxis,nt=pick$V(a.navigator&&a.navigator.enabled,tt.navigator.enabled,!0);a.xAxis=a.yAxis=void 0;var ot=merge$P({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:nt},scrollbar:{enabled:pick$V(tt.scrollbar&&tt.scrollbar.enabled,!0)},rangeSelector:{enabled:pick$V(tt.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:pick$V(tt.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},a,{isStock:!0});a.xAxis=et,a.yAxis=rt,ot.xAxis=splat$7(a.xAxis||{}).map(function(st,lt){return merge$P(getDefaultAxisOptions("xAxis",st),tt.xAxis,tt.xAxis&&tt.xAxis[lt],st,getForcedAxisOptions("xAxis",a))}),ot.yAxis=splat$7(a.yAxis||{}).map(function(st,lt){return merge$P(getDefaultAxisOptions("yAxis",st),tt.yAxis,tt.yAxis&&tt.yAxis[lt],st)}),j.prototype.init.call(this,ot,k)},E.prototype.createAxis=function(a,k){return k.axis=merge$P(getDefaultAxisOptions(a,k.axis),k.axis,getForcedAxisOptions(a,this.userOptions)),j.prototype.createAxis.call(this,a,k)},E}(Chart$1);(function(j){function E(a,k,tt){return new j(a,k,tt)}j.stockChart=E})(StockChart||(StockChart={}));function getDefaultAxisOptions(j,E){return j==="xAxis"?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:j==="yAxis"?{labels:{y:-2},opposite:pick$V(E.opposite,!0),showLastLabel:!!(E.categories||E.type==="category"),title:{text:null}}:{}}function getForcedAxisOptions(j,E){if(j==="xAxis"){var a=getOptions$2(),k=pick$V(E.navigator&&E.navigator.enabled,a.navigator.enabled,!0),tt={type:"datetime",categories:void 0};return k&&(tt.startOnTick=!1,tt.endOnTick=!1),tt}return{}}addEvent$D(Series$e,"setOptions",function(j){var E;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?E={borderWidth:0,shadow:!1}:!this.is("scatter")&&!this.is("sma")&&(E={marker:{enabled:!1,radius:2}}),E&&(j.plotOptions[this.type]=merge$P(j.plotOptions[this.type],E)))});addEvent$D(Axis,"autoLabelAlign",function(j){var E=this.chart,a=this.options,k=E._labelPanes=E._labelPanes||{},tt,et=this.options.labels;this.chart.options.isStock&&this.coll==="yAxis"&&(tt=a.top+","+a.height,!k[tt]&&et.enabled&&(et.x===15&&(et.x=0),typeof et.align>"u"&&(et.align="right"),k[tt]=this,j.align="right",j.preventDefault()))});addEvent$D(Axis,"destroy",function(){var j=this.chart,E=this.options&&this.options.top+","+this.options.height;E&&j._labelPanes&&j._labelPanes[E]===this&&delete j._labelPanes[E]});addEvent$D(Axis,"getPlotLinePath",function(j){var E=this,a=this.isLinked&&!this.series?this.linkedParent.series:this.series,k=E.chart,tt=k.renderer,et=E.left,rt=E.top,nt,ot,st,lt,ht=[],ut=[],dt,ft,pt=j.translatedValue,gt=j.value,yt=j.force,mt;function xt(wt){var Mt=wt==="xAxis"?"yAxis":"xAxis",At=E.options[Mt];return isNumber$n(At)?[k[Mt][At]]:isString$3(At)?[k.get(At)]:a.map(function(St){return St[Mt]})}(k.options.isStock&&j.acrossPanes!==!1&&E.coll==="xAxis"||E.coll==="yAxis")&&(j.preventDefault(),ut=xt(E.coll),dt=E.isXAxis?k.yAxis:k.xAxis,dt.forEach(function(wt){if(!defined$q(wt.options.id)||wt.options.id.indexOf("navigator")===-1){var Mt=wt.isXAxis?"yAxis":"xAxis",At=defined$q(wt.options[Mt])?k[Mt][wt.options[Mt]]:k[Mt][0];E===At&&ut.push(wt)}}),ft=ut.length?[]:[E.isXAxis?k.yAxis[0]:k.xAxis[0]],ut.forEach(function(wt){ft.indexOf(wt)===-1&&!find$a(ft,function(Mt){return Mt.pos===wt.pos&&Mt.len===wt.len})&&ft.push(wt)}),mt=pick$V(pt,E.translate(gt,null,null,j.old)),isNumber$n(mt)&&(E.horiz?ft.forEach(function(wt){var Mt;ot=wt.pos,lt=ot+wt.len,nt=st=Math.round(mt+E.transB),yt!=="pass"&&(nt<et||nt>et+E.width)&&(yt?nt=st=clamp$a(nt,et,et+E.width):Mt=!0),Mt||ht.push(["M",nt,ot],["L",st,lt])}):ft.forEach(function(wt){var Mt;nt=wt.pos,st=nt+wt.len,ot=lt=Math.round(rt+E.height-mt),yt!=="pass"&&(ot<rt||ot>rt+E.height)&&(yt?ot=lt=clamp$a(ot,rt,rt+E.height):Mt=!0),Mt||ht.push(["M",nt,ot],["L",st,lt])})),j.path=ht.length>0?tt.crispPolyLine(ht,j.lineWidth||1):null)});SVGRenderer.prototype.crispPolyLine=function(j,E){for(var a=0;a<j.length;a=a+2){var k=j[a],tt=j[a+1];k[1]===tt[1]&&(k[1]=tt[1]=Math.round(k[1])-E%2/2),k[2]===tt[2]&&(k[2]=tt[2]=Math.round(k[2])+E%2/2)}return j};addEvent$D(Axis,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});addEvent$D(Axis,"afterDrawCrosshair",function(j){if(!(!this.crosshair||!this.crosshair.label||!this.crosshair.label.enabled||!this.cross||!isNumber$n(this.min)||!isNumber$n(this.max))){var E=this.chart,a=this.logarithmic,k=this.crosshair.label,tt=this.horiz,et=this.opposite,rt=this.left,nt=this.top,ot=this.crossLabel,st,lt,ht,ut=k.format,dt="",ft,pt,gt=this.options.tickPosition==="inside",yt=this.crosshair.snap!==!1,mt=0,xt=j.e||this.cross&&this.cross.e,wt=j.point,Mt=this.min,At=this.max;a&&(Mt=a.lin2log(Mt),At=a.lin2log(At)),pt=tt?"center":et?this.labelAlign==="right"?"right":"left":this.labelAlign==="left"?"left":"center",ot||(ot=this.crossLabel=E.renderer.label("",0,void 0,k.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(wt?wt.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:k.align||pt,padding:pick$V(k.padding,8),r:pick$V(k.borderRadius,3),zIndex:2}).add(this.labelGroup),E.styledMode||ot.attr({fill:k.backgroundColor||wt&&wt.series&&wt.series.color||palette.neutralColor60,stroke:k.borderColor||"","stroke-width":k.borderWidth||0}).css(extend$11({color:palette.backgroundColor,fontWeight:"normal",fontSize:"11px",textAlign:"center"},k.style||{}))),tt?(st=yt?(wt.plotX||0)+rt:xt.chartX,lt=nt+(et?0:this.height)):(st=et?this.width+rt:0,lt=yt?(wt.plotY||0)+nt:xt.chartY),!ut&&!k.formatter&&(this.dateTime&&(dt="%b %d, %Y"),ut="{value"+(dt?":"+dt:"")+"}");var St=yt?this.isXAxis?wt.x:wt.y:this.toValue(tt?xt.chartX:xt.chartY),$t=wt?wt.series.isPointInside(wt):isNumber$n(St)&&St>Mt&&St<At,Tt="";ut?Tt=format$7(ut,{value:St},E):k.formatter&&isNumber$n(St)&&(Tt=k.formatter.call(this,St)),ot.attr({text:Tt,x:st,y:lt,visibility:$t?"visible":"hidden"}),ht=ot.getBBox(),isNumber$n(ot.y)&&(tt?(gt&&!et||!gt&&et)&&(lt=ot.y-ht.height):lt=ot.y-ht.height/2),tt?ft={left:rt-ht.x,right:rt+this.width-ht.x}:ft={left:this.labelAlign==="left"?rt:0,right:this.labelAlign==="right"?rt+this.width:E.chartWidth},ot.translateX<ft.left&&(mt=ft.left-ot.translateX),ot.translateX+ht.width>=ft.right&&(mt=-(ot.translateX+ht.width-ft.right)),ot.attr({x:st+mt,y:lt,anchorX:tt?st:this.opposite?0:E.chartWidth,anchorY:tt?this.opposite?E.chartHeight:0:lt+ht.height/2})}});Series$e.prototype.init=function(){seriesInit.apply(this,arguments),this.initCompare(this.options.compare)};Series$e.prototype.setCompare=function(j){this.initCompare(j),this.userOptions.compare=j};Series$e.prototype.initCompare=function(j){this.modifyValue=j==="value"||j==="percent"?function(E,a){var k=this.compareValue;return typeof E<"u"&&typeof k<"u"?(j==="value"?E-=k:E=100*(E/k)-(this.options.compareBase===100?0:100),a&&(a.change=E),E):0}:null,this.chart.hasRendered&&(this.isDirty=!0)};Series$e.prototype.forceCropping=function(){var j=this.chart,E=this.options,a=E.dataGrouping,k=this.allowDG!==!1&&a&&pick$V(a.enabled,j.options.isStock);return k};Series$e.prototype.processData=function(j){var E=this,a,k=-1,tt,et,rt=E.options.compareStart===!0?0:1,nt,ot;if(seriesProcessData.apply(this,arguments),E.xAxis&&E.processedYData){for(tt=E.processedXData,et=E.processedYData,nt=et.length,E.pointArrayMap&&(k=E.pointArrayMap.indexOf(E.options.pointValKey||E.pointValKey||"y")),a=0;a<nt-rt;a++)if(ot=et[a]&&k>-1?et[a][k]:et[a],isNumber$n(ot)&&tt[a+rt]>=E.xAxis.min&&ot!==0){E.compareValue=ot;break}}};addEvent$D(Series$e,"afterGetExtremes",function(j){var E=j.dataExtremes;if(this.modifyValue&&E){var a=[this.modifyValue(E.dataMin),this.modifyValue(E.dataMax)];E.dataMin=arrayMin$4(a),E.dataMax=arrayMax$4(a)}});Axis.prototype.setCompare=function(j,E){this.isXAxis||(this.series.forEach(function(a){a.setCompare(j)}),pick$V(E,!0)&&this.chart.redraw())};Point$5.prototype.tooltipFormatter=function(j){var E=this,a=E.series.chart.numberFormatter;return j=j.replace("{point.change}",(E.change>0?"+":"")+a(E.change,pick$V(E.series.tooltipOptions.changeDecimals,2))),pointTooltipFormatter.apply(this,[j])};addEvent$D(Series$e,"render",function(){var j=this.chart,E;if(!(j.is3d&&j.is3d())&&!j.polar&&this.xAxis&&!this.xAxis.isRadial&&this.options.clip!==!1){if(E=this.yAxis.len,this.xAxis.axisLine){var a=j.plotTop+j.plotHeight-this.yAxis.pos-this.yAxis.len,k=Math.floor(this.xAxis.axisLine.strokeWidth()/2);a>=0&&(E-=Math.max(k-a,0))}if((!j.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)&&(this.clipBox=this.clipBox||merge$P(j.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=E),j.hasRendered){var tt=animObject$4(this.options.animation),et=this.getSharedClipKey(tt),rt=j.sharedClips[et];if(rt){rt.animate({width:this.xAxis.len,height:E});var nt=j.sharedClips[et+"m"];nt&&nt.animate({width:this.xAxis.len})}}}});addEvent$D(Chart$1,"update",function(j){var E=j.options;"scrollbar"in E&&this.navigator&&(merge$P(!0,this.options.scrollbar,E.scrollbar),this.navigator.update({},!1),delete E.scrollbar)});const StockChart$1=StockChart;/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/modules/stock
 * @requires highcharts
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */var G$5=H;G$5.Scrollbar=Scrollbar;G$5.StockChart=G$5.stockChart=StockChart$1.stockChart;Scrollbar.compose(G$5.Axis);OrdinalAxis$1.compose(G$5.Axis,G$5.Series,G$5.Chart);/**
 * @license Highstock JS v9.2.2 (2021-08-24)
 * @module highcharts/highstock
 *
 * (c) 2009-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */G$7.product="Highstock";var doc$f=H.doc,win$6=H.win,merge$O=Utilities.merge;function addClass$1(j,E){j.classList?j.classList.add(E):j.className.indexOf(E)<0&&(j.className+=E)}function escapeStringForHTML$1(j){return j.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#x27;").replace(/\//g,"&#x2F;")}function getElement$2(j){return doc$f.getElementById(j)}function getFakeMouseEvent$2(j){if(typeof win$6.MouseEvent=="function")return new win$6.MouseEvent(j);if(doc$f.createEvent){var E=doc$f.createEvent("MouseEvent");if(E.initMouseEvent)return E.initMouseEvent(j,!0,!0,win$6,j==="click"?1:0,0,0,0,0,!1,!1,!1,!1,0,null),E}return{type:j}}function getHeadingTagNameForElement$1(j){var E=function(et){var rt=parseInt(et.slice(1),10),nt=Math.min(6,rt+1);return"h"+nt},a=function(et){return/H[1-6]/.test(et)},k=function(et){for(var rt=et;rt=rt.previousSibling;){var nt=rt.tagName||"";if(a(nt))return nt}return""},tt=function(et){var rt=k(et);if(rt)return E(rt);var nt=et.parentElement;if(!nt)return"p";var ot=nt.tagName;return a(ot)?E(ot):tt(nt)};return tt(j)}function removeElement$5(j){j&&j.parentNode&&j.parentNode.removeChild(j)}function reverseChildNodes$1(j){for(var E=j.childNodes.length;E--;)j.appendChild(j.childNodes[E])}function setElAttrs$4(j,E){Object.keys(E).forEach(function(a){var k=E[a];k===null?j.removeAttribute(a):j.setAttribute(a,k)})}function stripHTMLTagsFromString$2(j){return typeof j=="string"?j.replace(/<\/?[^>]+(>|$)/g,""):j}function visuallyHideElement$2(j){var E={position:"absolute",width:"1px",height:"1px",overflow:"hidden",whiteSpace:"nowrap",clip:"rect(1px, 1px, 1px, 1px)",marginTop:"-3px","-ms-filter":"progid:DXImageTransform.Microsoft.Alpha(Opacity=1)",filter:"alpha(opacity=1)",opacity:"0.01"};merge$O(!0,j.style,E)}var HTMLUtilities={addClass:addClass$1,escapeStringForHTML:escapeStringForHTML$1,getElement:getElement$2,getFakeMouseEvent:getFakeMouseEvent$2,getHeadingTagNameForElement:getHeadingTagNameForElement$1,removeElement:removeElement$5,reverseChildNodes:reverseChildNodes$1,setElAttrs:setElAttrs$4,stripHTMLTagsFromString:stripHTMLTagsFromString$2,visuallyHideElement:visuallyHideElement$2},stripHTMLTags$3=HTMLUtilities.stripHTMLTagsFromString,doc$e=H.doc,defined$p=Utilities.defined,find$9=Utilities.find,fireEvent$i=Utilities.fireEvent;function getChartTitle$5(j){return stripHTMLTags$3(j.options.title.text||j.langFormat("accessibility.defaultChartTitle",{chart:j}))}function getAxisDescription$2(j){return j&&(j.userOptions&&j.userOptions.accessibility&&j.userOptions.accessibility.description||j.axisTitle&&j.axisTitle.textStr||j.options.id||j.categories&&"categories"||j.dateTime&&"Time"||"values")}function getAxisRangeDescription$2(j){var E=j.options||{};return E.accessibility&&typeof E.accessibility.rangeDescription<"u"?E.accessibility.rangeDescription:j.categories?getCategoryAxisRangeDesc(j):j.dateTime&&(j.min===0||j.dataMin===0)?getAxisTimeLengthDesc(j):getAxisFromToDescription(j)}function getCategoryAxisRangeDesc(j){var E=j.chart;return j.dataMax&&j.dataMin?E.langFormat("accessibility.axis.rangeCategories",{chart:E,axis:j,numCategories:j.dataMax-j.dataMin+1}):""}function getAxisTimeLengthDesc(j){var E=j.chart,a={},k="Seconds";a.Seconds=((j.max||0)-(j.min||0))/1e3,a.Minutes=a.Seconds/60,a.Hours=a.Minutes/60,a.Days=a.Hours/24,["Minutes","Hours","Days"].forEach(function(et){a[et]>2&&(k=et)});var tt=a[k].toFixed(k!=="Seconds"&&k!=="Minutes"?1:0);return E.langFormat("accessibility.axis.timeRange"+k,{chart:E,axis:j,range:tt.replace(".0","")})}function getAxisFromToDescription(j){var E=j.chart,a=E.options&&E.options.accessibility&&E.options.accessibility.screenReaderSection.axisRangeDateFormat||"",k=function(tt){return j.dateTime?E.time.dateFormat(a,j[tt]):j[tt]};return E.langFormat("accessibility.axis.rangeFromTo",{chart:E,axis:j,rangeFrom:k("min"),rangeTo:k("max")})}function getSeriesFirstPointElement$1(j){if(j.points&&j.points.length){var E=find$9(j.points,function(a){return!!a.graphic});return E&&E.graphic&&E.graphic.element}}function getSeriesA11yElement$1(j){var E=getSeriesFirstPointElement$1(j);return E&&E.parentNode||j.graph&&j.graph.element||j.group&&j.group.element}function unhideChartElementFromAT$7(j,E){E.setAttribute("aria-hidden",!1),!(E===j.renderTo||!E.parentNode||E.parentNode===doc$e.body)&&(Array.prototype.forEach.call(E.parentNode.childNodes,function(a){a.hasAttribute("aria-hidden")||a.setAttribute("aria-hidden",!0)}),unhideChartElementFromAT$7(j,E.parentNode))}function hideSeriesFromAT$1(j){var E=getSeriesA11yElement$1(j);E&&E.setAttribute("aria-hidden",!0)}function getSeriesFromName$1(j,E){return E?(j.series||[]).filter(function(a){return a.name===E}):j.series}function getPointFromXY$1(j,E,a){for(var k=j.length,tt;k--;)if(tt=find$9(j[k].points||[],function(et){return et.x===E&&et.y===a}),tt)return tt}function getRelativePointAxisPosition(j,E){if(!defined$p(j.dataMin)||!defined$p(j.dataMax))return 0;var a=j.toPixels(j.dataMin),k=j.toPixels(j.dataMax),tt=j.coll==="xAxis"?"x":"y",et=j.toPixels(E[tt]||0);return(et-a)/(k-a)}function scrollToPoint$1(j){var E=j.series.xAxis,a=j.series.yAxis,k=E&&E.scrollbar?E:a,tt=k&&k.scrollbar;if(tt&&defined$p(tt.to)&&defined$p(tt.from)){var et=tt.to-tt.from,rt=getRelativePointAxisPosition(k,j);tt.updatePosition(rt-et/2,rt+et/2),fireEvent$i(tt,"changed",{from:tt.from,to:tt.to,trigger:"scrollbar",DOMEvent:null})}}var ChartUtilities={getChartTitle:getChartTitle$5,getAxisDescription:getAxisDescription$2,getAxisRangeDescription:getAxisRangeDescription$2,getPointFromXY:getPointFromXY$1,getSeriesFirstPointElement:getSeriesFirstPointElement$1,getSeriesFromName:getSeriesFromName$1,getSeriesA11yElement:getSeriesA11yElement$1,unhideChartElementFromAT:unhideChartElementFromAT$7,hideSeriesFromAT:hideSeriesFromAT$1,scrollToPoint:scrollToPoint$1},find$8=Utilities.find;function KeyboardNavigationHandler(j,E){this.chart=j,this.keyCodeMap=E.keyCodeMap||[],this.validate=E.validate,this.init=E.init,this.terminate=E.terminate,this.response={success:1,prev:2,next:3,noHandler:4,fail:5}}KeyboardNavigationHandler.prototype={run:function(j){var E=j.which||j.keyCode,a=this.response.noHandler,k=find$8(this.keyCodeMap,function(tt){return tt[0].indexOf(E)>-1});return k?a=k[1].call(this,E,j):E===9&&(a=this.response[j.shiftKey?"prev":"next"]),a}};var doc$d=H.doc,removeElement$4=HTMLUtilities.removeElement,extend$10=Utilities.extend,DOMElementProvider=function(){this.elements=[]};extend$10(DOMElementProvider.prototype,{createElement:function(){var j=doc$d.createElement.apply(doc$d,arguments);return this.elements.push(j),j},destroyCreatedElements:function(){this.elements.forEach(function(j){removeElement$4(j)}),this.elements=[]}});var addEvent$C=Utilities.addEvent,extend$$=Utilities.extend,EventProvider=function(){this.eventRemovers=[]};extend$$(EventProvider.prototype,{addEvent:function(){var j=addEvent$C.apply(H,arguments);return this.eventRemovers.push(j),j},removeAddedEvents:function(){this.eventRemovers.forEach(function(j){j()}),this.eventRemovers=[]}});var unhideChartElementFromAT$6=ChartUtilities.unhideChartElementFromAT,doc$c=H.doc,win$5=H.win,removeElement$3=HTMLUtilities.removeElement,getFakeMouseEvent$1=HTMLUtilities.getFakeMouseEvent,extend$_=Utilities.extend,fireEvent$h=Utilities.fireEvent,merge$N=Utilities.merge,functionsToOverrideByDerivedClasses={init:function(){},getKeyboardNavigation:function(){},onChartUpdate:function(){},onChartRender:function(){},destroy:function(){}};function AccessibilityComponent(){}AccessibilityComponent.prototype={initBase:function(j){this.chart=j,this.eventProvider=new EventProvider,this.domElementProvider=new DOMElementProvider,this.keyCodes={left:37,right:39,up:38,down:40,enter:13,space:32,esc:27,tab:9}},addEvent:function(){return this.eventProvider.addEvent.apply(this.eventProvider,arguments)},createElement:function(){return this.domElementProvider.createElement.apply(this.domElementProvider,arguments)},fireEventOnWrappedOrUnwrappedElement:function(j,E){var a=E.type;doc$c.createEvent&&(j.dispatchEvent||j.fireEvent)?j.dispatchEvent?j.dispatchEvent(E):j.fireEvent(a,E):fireEvent$h(j,a,E)},fakeClickEvent:function(j){if(j){var E=getFakeMouseEvent$1("click");this.fireEventOnWrappedOrUnwrappedElement(j,E)}},addProxyGroup:function(j){this.createOrUpdateProxyContainer();var E=this.createElement("div");return Object.keys(j||{}).forEach(function(a){j[a]!==null&&E.setAttribute(a,j[a])}),this.chart.a11yProxyContainer.appendChild(E),E},createOrUpdateProxyContainer:function(){var j=this.chart,E=j.renderer.box;j.a11yProxyContainer=j.a11yProxyContainer||this.createProxyContainerElement(),E.nextSibling!==j.a11yProxyContainer&&j.container.insertBefore(j.a11yProxyContainer,E.nextSibling)},createProxyContainerElement:function(){var j=doc$c.createElement("div");return j.className="highcharts-a11y-proxy-container",j},createProxyButton:function(j,E,a,k,tt){var et=j.element,rt=this.createElement("button"),nt=merge$N({"aria-label":et.getAttribute("aria-label")},a);return Object.keys(nt).forEach(function(ot){nt[ot]!==null&&rt.setAttribute(ot,nt[ot])}),rt.className="highcharts-a11y-proxy-button",j.hasClass("highcharts-no-tooltip")&&(rt.className+=" highcharts-no-tooltip"),tt&&this.addEvent(rt,"click",tt),this.setProxyButtonStyle(rt),this.updateProxyButtonPosition(rt,k||j),this.proxyMouseEventsForButton(et,rt),E.appendChild(rt),nt["aria-hidden"]||unhideChartElementFromAT$6(this.chart,rt),rt},getElementPosition:function(j){var E=j.element,a=this.chart.renderTo;if(a&&E&&E.getBoundingClientRect){var k=E.getBoundingClientRect(),tt=a.getBoundingClientRect();return{x:k.left-tt.left,y:k.top-tt.top,width:k.right-k.left,height:k.bottom-k.top}}return{x:0,y:0,width:1,height:1}},setProxyButtonStyle:function(j){merge$N(!0,j.style,{borderWidth:"0",backgroundColor:"transparent",cursor:"pointer",outline:"none",opacity:"0.001",filter:"alpha(opacity=1)",zIndex:"999",overflow:"hidden",padding:"0",margin:"0",display:"block",position:"absolute"}),j.style["-ms-filter"]="progid:DXImageTransform.Microsoft.Alpha(Opacity=1)"},updateProxyButtonPosition:function(j,E){var a=this.getElementPosition(E);merge$N(!0,j.style,{width:(a.width||1)+"px",height:(a.height||1)+"px",left:(Math.round(a.x)||0)+"px",top:(Math.round(a.y)||0)+"px"})},proxyMouseEventsForButton:function(j,E){var a=this;["click","touchstart","touchend","touchcancel","touchmove","mouseover","mouseenter","mouseleave","mouseout"].forEach(function(k){var tt=k.indexOf("touch")===0;a.addEvent(E,k,function(et){var rt=tt?a.cloneTouchEvent(et):a.cloneMouseEvent(et);j&&a.fireEventOnWrappedOrUnwrappedElement(j,rt),et.stopPropagation(),k!=="touchstart"&&k!=="touchmove"&&k!=="touchend"&&et.preventDefault()},{passive:!1})})},cloneMouseEvent:function(j){if(typeof win$5.MouseEvent=="function")return new win$5.MouseEvent(j.type,j);if(doc$c.createEvent){var E=doc$c.createEvent("MouseEvent");if(E.initMouseEvent)return E.initMouseEvent(j.type,j.bubbles,j.cancelable,j.view||win$5,j.detail,j.screenX,j.screenY,j.clientX,j.clientY,j.ctrlKey,j.altKey,j.shiftKey,j.metaKey,j.button,j.relatedTarget),E}return getFakeMouseEvent$1(j.type)},cloneTouchEvent:function(j){var E=function(tt){for(var et=[],rt=0;rt<tt.length;++rt){var nt=tt.item(rt);nt&&et.push(nt)}return et};if(typeof win$5.TouchEvent=="function"){var a=new win$5.TouchEvent(j.type,{touches:E(j.touches),targetTouches:E(j.targetTouches),changedTouches:E(j.changedTouches),ctrlKey:j.ctrlKey,shiftKey:j.shiftKey,altKey:j.altKey,metaKey:j.metaKey,bubbles:j.bubbles,cancelable:j.cancelable,composed:j.composed,detail:j.detail,view:j.view});return j.defaultPrevented&&a.preventDefault(),a}var k=this.cloneMouseEvent(j);return k.touches=j.touches,k.changedTouches=j.changedTouches,k.targetTouches=j.targetTouches,k},destroyBase:function(){removeElement$3(this.chart.a11yProxyContainer),this.domElementProvider.destroyCreatedElements(),this.eventProvider.removeAddedEvents()}};extend$_(AccessibilityComponent.prototype,functionsToOverrideByDerivedClasses);var doc$b=H.doc,win$4=H.win,addEvent$B=Utilities.addEvent,fireEvent$g=Utilities.fireEvent,getElement$1=HTMLUtilities.getElement;addEvent$B(doc$b,"keydown",function(j){var E=j.which||j.keyCode,a=27;E===a&&H.charts&&H.charts.forEach(function(k){k&&k.dismissPopupContent&&k.dismissPopupContent()})});Chart$1.prototype.dismissPopupContent=function(){var j=this;fireEvent$g(this,"dismissPopupContent",{},function(){j.tooltip&&j.tooltip.hide(0),j.hideExportMenu()})};function KeyboardNavigation(j,E){this.init(j,E)}KeyboardNavigation.prototype={init:function(j,E){var a=this,k=this.eventProvider=new EventProvider;this.chart=j,this.components=E,this.modules=[],this.currentModuleIx=0,this.update(),k.addEvent(this.tabindexContainer,"keydown",function(tt){return a.onKeydown(tt)}),k.addEvent(this.tabindexContainer,"focus",function(tt){return a.onFocus(tt)}),["mouseup","touchend"].forEach(function(tt){return k.addEvent(doc$b,tt,function(){return a.onMouseUp()})}),["mousedown","touchstart"].forEach(function(tt){return k.addEvent(j.renderTo,tt,function(){a.isClickingChart=!0})}),k.addEvent(j.renderTo,"mouseover",function(){a.pointerIsOverChart=!0}),k.addEvent(j.renderTo,"mouseout",function(){a.pointerIsOverChart=!1}),this.modules.length&&this.modules[0].init(1)},update:function(j){var E=this.chart.options.accessibility,a=E&&E.keyboardNavigation,k=this.components;this.updateContainerTabindex(),a&&a.enabled&&j&&j.length?(this.modules=j.reduce(function(tt,et){var rt=k[et].getKeyboardNavigation();return tt.concat(rt)},[]),this.updateExitAnchor()):(this.modules=[],this.currentModuleIx=0,this.removeExitAnchor())},onFocus:function(j){var E=this.chart,a=j.relatedTarget&&E.container.contains(j.relatedTarget);!this.exiting&&!this.tabbingInBackwards&&!this.isClickingChart&&!a&&this.modules[0]&&this.modules[0].init(1),this.exiting=!1},onMouseUp:function(){if(delete this.isClickingChart,!this.keyboardReset&&!this.pointerIsOverChart){var j=this.chart,E=this.modules&&this.modules[this.currentModuleIx||0];E&&E.terminate&&E.terminate(),j.focusElement&&j.focusElement.removeFocusBorder(),this.currentModuleIx=0,this.keyboardReset=!0}},onKeydown:function(j){var E=j||win$4.event,a,k=this.modules&&this.modules.length&&this.modules[this.currentModuleIx];if(this.keyboardReset=!1,this.exiting=!1,k){var tt=k.run(E);tt===k.response.success?a=!0:tt===k.response.prev?a=this.prev():tt===k.response.next&&(a=this.next()),a&&(E.preventDefault(),E.stopPropagation())}},prev:function(){return this.move(-1)},next:function(){return this.move(1)},move:function(j){var E=this.modules&&this.modules[this.currentModuleIx];E&&E.terminate&&E.terminate(j),this.chart.focusElement&&this.chart.focusElement.removeFocusBorder(),this.currentModuleIx+=j;var a=this.modules&&this.modules[this.currentModuleIx];if(a){if(a.validate&&!a.validate())return this.move(j);if(a.init)return a.init(j),!0}return this.currentModuleIx=0,this.exiting=!0,j>0?this.exitAnchor.focus():this.tabindexContainer.focus(),!1},updateExitAnchor:function(){var j="highcharts-end-of-chart-marker-"+this.chart.index,E=getElement$1(j);this.removeExitAnchor(),E?(this.makeElementAnExitAnchor(E),this.exitAnchor=E):this.createExitAnchor()},updateContainerTabindex:function(){var j=this.chart.options.accessibility,E=j&&j.keyboardNavigation,a=!(E&&E.enabled===!1),k=this.chart,tt=k.container,et;k.renderTo.hasAttribute("tabindex")?(tt.removeAttribute("tabindex"),et=k.renderTo):et=tt,this.tabindexContainer=et;var rt=et.getAttribute("tabindex");a&&!rt?et.setAttribute("tabindex","0"):a||k.container.removeAttribute("tabindex")},makeElementAnExitAnchor:function(j){var E=this.tabindexContainer.getAttribute("tabindex")||0;j.setAttribute("class","highcharts-exit-anchor"),j.setAttribute("tabindex",E),j.setAttribute("aria-hidden",!1),this.addExitAnchorEventsToEl(j)},createExitAnchor:function(){var j=this.chart,E=this.exitAnchor=doc$b.createElement("div");j.renderTo.appendChild(E),this.makeElementAnExitAnchor(E)},removeExitAnchor:function(){this.exitAnchor&&this.exitAnchor.parentNode&&(this.exitAnchor.parentNode.removeChild(this.exitAnchor),delete this.exitAnchor)},addExitAnchorEventsToEl:function(j){var E=this.chart,a=this;this.eventProvider.addEvent(j,"focus",function(k){var tt=k||win$4.event,et,rt=tt.relatedTarget&&E.container.contains(tt.relatedTarget),nt=!(rt||a.exiting);nt?(a.tabbingInBackwards=!0,a.tabindexContainer.focus(),delete a.tabbingInBackwards,tt.preventDefault(),a.modules&&a.modules.length&&(a.currentModuleIx=a.modules.length-1,et=a.modules[a.currentModuleIx],et&&et.validate&&!et.validate()?a.prev():et&&et.init(-1))):a.exiting=!1})},destroy:function(){this.removeExitAnchor(),this.eventProvider.removeAddedEvents(),this.chart.container.removeAttribute("tabindex")}};var animObject$3=animationExports.animObject,addEvent$A=Utilities.addEvent,extend$Z=Utilities.extend,find$7=Utilities.find,fireEvent$f=Utilities.fireEvent,isNumber$m=Utilities.isNumber,pick$U=Utilities.pick,syncTimeout$1=Utilities.syncTimeout,removeElement$2=HTMLUtilities.removeElement,stripHTMLTags$2=HTMLUtilities.stripHTMLTagsFromString,getChartTitle$4=ChartUtilities.getChartTitle;function scrollLegendToItem(j,E){var a=j.allItems[E].pageIx,k=j.currentPage;typeof a<"u"&&a+1!==k&&j.scroll(1+a-k)}function shouldDoLegendA11y(j){var E=j.legend&&j.legend.allItems,a=j.options.legend.accessibility||{};return!!(E&&E.length&&!(j.colorAxis&&j.colorAxis.length)&&a.enabled!==!1)}Chart$1.prototype.highlightLegendItem=function(j){var E=this.legend.allItems,a=this.accessibility&&this.accessibility.components.legend.highlightedLegendItemIx;return E[j]?(isNumber$m(a)&&E[a]&&fireEvent$f(E[a].legendGroup.element,"mouseout"),scrollLegendToItem(this.legend,j),this.setFocusToElement(E[j].legendItem,E[j].a11yProxyElement),fireEvent$f(E[j].legendGroup.element,"mouseover"),!0):!1};addEvent$A(Legend,"afterColorizeItem",function(j){var E=this.chart,a=E.options.accessibility,k=j.item;a.enabled&&k&&k.a11yProxyElement&&k.a11yProxyElement.setAttribute("aria-pressed",j.visible?"true":"false")});var LegendComponent=function(){};LegendComponent.prototype=new AccessibilityComponent;extend$Z(LegendComponent.prototype,{init:function(){var j=this;this.proxyElementsList=[],this.recreateProxies(),this.addEvent(Legend,"afterScroll",function(){this.chart===j.chart&&(j.updateProxiesPositions(),j.updateLegendItemProxyVisibility(),this.chart.highlightLegendItem(j.highlightedLegendItemIx))}),this.addEvent(Legend,"afterPositionItem",function(E){this.chart===j.chart&&this.chart.renderer&&j.updateProxyPositionForItem(E.item)}),this.addEvent(Legend,"afterRender",function(){this.chart===j.chart&&this.chart.renderer&&j.recreateProxies()&&syncTimeout$1(function(){return j.updateProxiesPositions()},animObject$3(pick$U(this.chart.renderer.globalAnimation,!0)).duration)})},updateLegendItemProxyVisibility:function(){var j=this.chart.legend,E=j.allItems||[],a=j.currentPage||1,k=j.clipHeight||0;E.forEach(function(tt){var et=tt.pageIx||0,rt=tt._legendItemPos?tt._legendItemPos[1]:0,nt=tt.legendItem?Math.round(tt.legendItem.getBBox().height):0,ot=rt+nt-j.pages[et]>k||et!==a-1;tt.a11yProxyElement&&(tt.a11yProxyElement.style.visibility=ot?"hidden":"visible")})},onChartRender:function(){shouldDoLegendA11y(this.chart)||this.removeProxies()},onChartUpdate:function(){this.updateLegendTitle()},updateProxiesPositions:function(){for(var j=0,E=this.proxyElementsList;j<E.length;j++){var a=E[j],k=a.element,tt=a.posElement;this.updateProxyButtonPosition(k,tt)}},updateProxyPositionForItem:function(j){var E=find$7(this.proxyElementsList,function(a){return a.item===j});E&&this.updateProxyButtonPosition(E.element,E.posElement)},recreateProxies:function(){return this.removeProxies(),shouldDoLegendA11y(this.chart)?(this.addLegendProxyGroup(),this.addLegendListContainer(),this.proxyLegendItems(),this.updateLegendItemProxyVisibility(),!0):!1},removeProxies:function(){removeElement$2(this.legendProxyGroup),this.proxyElementsList=[]},updateLegendTitle:function(){var j=this.chart,E=stripHTMLTags$2((j.legend&&j.legend.options.title&&j.legend.options.title.text||"").replace(/<br ?\/?>/g," ")),a=j.langFormat("accessibility.legend.legendLabel"+(E?"":"NoTitle"),{chart:j,legendTitle:E,chartTitle:getChartTitle$4(j)});this.legendProxyGroup&&this.legendProxyGroup.setAttribute("aria-label",a)},addLegendProxyGroup:function(){var j=this.chart.options.accessibility,E=j.landmarkVerbosity==="all"?"region":null;this.legendProxyGroup=this.addProxyGroup({"aria-label":"_placeholder_",role:E})},addLegendListContainer:function(){if(this.legendProxyGroup){var j=this.legendListContainer=this.createElement("ul");j.style.listStyle="none",this.legendProxyGroup.appendChild(j)}},proxyLegendItems:function(){var j=this,E=this.chart.legend&&this.chart.legend.allItems||[];E.forEach(function(a){a.legendItem&&a.legendItem.element&&j.proxyLegendItem(a)})},proxyLegendItem:function(j){if(!(!j.legendItem||!j.legendGroup||!this.legendListContainer)){var E=this.chart.langFormat("accessibility.legend.legendItem",{chart:this.chart,itemName:stripHTMLTags$2(j.name),item:j}),a={tabindex:-1,"aria-pressed":j.visible,"aria-label":E},k=j.legendGroup.div?j.legendItem:j.legendGroup,tt=this.createElement("li");this.legendListContainer.appendChild(tt),j.a11yProxyElement=this.createProxyButton(j.legendItem,tt,a,k),this.proxyElementsList.push({item:j,element:j.a11yProxyElement,posElement:k})}},getKeyboardNavigation:function(){var j=this.keyCodes,E=this,a=this.chart;return new KeyboardNavigationHandler(a,{keyCodeMap:[[[j.left,j.right,j.up,j.down],function(k){return E.onKbdArrowKey(this,k)}],[[j.enter,j.space],function(k){return H.isFirefox&&k===j.space?this.response.success:E.onKbdClick(this)}]],validate:function(){return E.shouldHaveLegendNavigation()},init:function(k){return E.onKbdNavigationInit(k)},terminate:function(){a.legend.allItems.forEach(function(k){return k.setState("",!0)})}})},onKbdArrowKey:function(j,E){var a=this.keyCodes,k=j.response,tt=this.chart,et=tt.options.accessibility,rt=tt.legend.allItems.length,nt=E===a.left||E===a.up?-1:1,ot=tt.highlightLegendItem(this.highlightedLegendItemIx+nt);return ot?(this.highlightedLegendItemIx+=nt,k.success):rt>1&&et.keyboardNavigation.wrapAround?(j.init(nt),k.success):k[nt>0?"next":"prev"]},onKbdClick:function(j){var E=this.chart.legend.allItems[this.highlightedLegendItemIx];return E&&E.a11yProxyElement&&fireEvent$f(E.a11yProxyElement,"click"),j.response.success},shouldHaveLegendNavigation:function(){var j=this.chart,E=j.options.legend||{},a=j.legend&&j.legend.allItems,k=j.colorAxis&&j.colorAxis.length,tt=E.accessibility||{};return!!(a&&j.legend.display&&!k&&tt.enabled&&tt.keyboardNavigation&&tt.keyboardNavigation.enabled)},onKbdNavigationInit:function(j){var E=this.chart,a=E.legend.allItems.length-1,k=j>0?0:a;E.highlightLegendItem(k),this.highlightedLegendItemIx=k}});var extend$Y=Utilities.extend,getChartTitle$3=ChartUtilities.getChartTitle,unhideChartElementFromAT$5=ChartUtilities.unhideChartElementFromAT,removeElement$1=HTMLUtilities.removeElement,getFakeMouseEvent=HTMLUtilities.getFakeMouseEvent;function getExportMenuButtonElement(j){return j.exportSVGElements&&j.exportSVGElements[0]}Chart$1.prototype.showExportMenu=function(){var j=getExportMenuButtonElement(this);if(j){var E=j.element;E.onclick&&E.onclick(getFakeMouseEvent("click"))}};Chart$1.prototype.hideExportMenu=function(){var j=this,E=j.exportDivElements;E&&j.exportContextMenu&&(E.forEach(function(a){a&&a.className==="highcharts-menu-item"&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout"))}),j.highlightedExportItemIx=0,j.exportContextMenu.hideMenu(),j.container.focus())};Chart$1.prototype.highlightExportItem=function(j){var E=this.exportDivElements&&this.exportDivElements[j],a=this.exportDivElements&&this.exportDivElements[this.highlightedExportItemIx],k;return E&&E.tagName==="LI"&&!(E.children&&E.children.length)?(k=!!(this.renderTo.getElementsByTagName("g")[0]||{}).focus,E.focus&&k&&E.focus(),a&&a.onmouseout&&a.onmouseout(getFakeMouseEvent("mouseout")),E.onmouseover&&E.onmouseover(getFakeMouseEvent("mouseover")),this.highlightedExportItemIx=j,!0):!1};Chart$1.prototype.highlightLastExportItem=function(){var j=this,E;if(j.exportDivElements){for(E=j.exportDivElements.length;E--;)if(j.highlightExportItem(E))return!0}return!1};function exportingShouldHaveA11y(j){var E=j.options.exporting,a=getExportMenuButtonElement(j);return!!(E&&E.enabled!==!1&&E.accessibility&&E.accessibility.enabled&&a&&a.element)}var MenuComponent=function(){};MenuComponent.prototype=new AccessibilityComponent;extend$Y(MenuComponent.prototype,{init:function(){var j=this.chart,E=this;this.addEvent(j,"exportMenuShown",function(){E.onMenuShown()}),this.addEvent(j,"exportMenuHidden",function(){E.onMenuHidden()})},onMenuHidden:function(){var j=this.chart.exportContextMenu;j&&j.setAttribute("aria-hidden","true"),this.isExportMenuShown=!1,this.setExportButtonExpandedState("false")},onMenuShown:function(){var j=this.chart,E=j.exportContextMenu;E&&(this.addAccessibleContextMenuAttribs(),unhideChartElementFromAT$5(j,E)),this.isExportMenuShown=!0,this.setExportButtonExpandedState("true")},setExportButtonExpandedState:function(j){var E=this.exportButtonProxy;E&&E.setAttribute("aria-expanded",j)},onChartRender:function(){var j=this.chart,E=j.options.accessibility;if(removeElement$1(this.exportProxyGroup),exportingShouldHaveA11y(j)){this.exportProxyGroup=this.addProxyGroup(E.landmarkVerbosity==="all"?{"aria-label":j.langFormat("accessibility.exporting.exportRegionLabel",{chart:j,chartTitle:getChartTitle$3(j)}),role:"region"}:{});var a=getExportMenuButtonElement(this.chart);this.exportButtonProxy=this.createProxyButton(a,this.exportProxyGroup,{"aria-label":j.langFormat("accessibility.exporting.menuButtonLabel",{chart:j}),"aria-expanded":!1})}},addAccessibleContextMenuAttribs:function(){var j=this.chart,E=j.exportDivElements;if(E&&E.length){E.forEach(function(k){k&&(k.tagName==="LI"&&!(k.children&&k.children.length)?k.setAttribute("tabindex",-1):k.setAttribute("aria-hidden","true"))});var a=E[0]&&E[0].parentNode;a&&(a.removeAttribute("aria-hidden"),a.setAttribute("aria-label",j.langFormat("accessibility.exporting.chartMenuLabel",{chart:j})))}},getKeyboardNavigation:function(){var j=this.keyCodes,E=this.chart,a=this;return new KeyboardNavigationHandler(E,{keyCodeMap:[[[j.left,j.up],function(){return a.onKbdPrevious(this)}],[[j.right,j.down],function(){return a.onKbdNext(this)}],[[j.enter,j.space],function(){return a.onKbdClick(this)}]],validate:function(){return!!E.exporting&&E.options.exporting.enabled!==!1&&E.options.exporting.accessibility.enabled!==!1},init:function(){var k=a.exportButtonProxy,tt=E.exportingGroup;tt&&k&&E.setFocusToElement(tt,k)},terminate:function(){E.hideExportMenu()}})},onKbdPrevious:function(j){for(var E=this.chart,a=E.options.accessibility,k=j.response,tt=E.highlightedExportItemIx||0;tt--;)if(E.highlightExportItem(tt))return k.success;return a.keyboardNavigation.wrapAround?(E.highlightLastExportItem(),k.success):k.prev},onKbdNext:function(j){for(var E=this.chart,a=E.options.accessibility,k=j.response,tt=(E.highlightedExportItemIx||0)+1;tt<E.exportDivElements.length;++tt)if(E.highlightExportItem(tt))return k.success;return a.keyboardNavigation.wrapAround?(E.highlightExportItem(0),k.success):k.next},onKbdClick:function(j){var E=this.chart,a=E.exportDivElements[E.highlightedExportItemIx],k=getExportMenuButtonElement(E).element;return this.isExportMenuShown?this.fakeClickEvent(a):(this.fakeClickEvent(k),E.highlightExportItem(0)),j.response.success}});var seriesTypes$4=SeriesRegistry$1.seriesTypes,doc$a=H.doc,defined$o=Utilities.defined,extend$X=Utilities.extend,fireEvent$e=Utilities.fireEvent,getPointFromXY=ChartUtilities.getPointFromXY,getSeriesFromName=ChartUtilities.getSeriesFromName,scrollToPoint=ChartUtilities.scrollToPoint;Series$e.prototype.keyboardMoveVertical=!0;["column","pie"].forEach(function(j){seriesTypes$4[j]&&(seriesTypes$4[j].prototype.keyboardMoveVertical=!1)});function getPointIndex(j){var E=j.index,a=j.series.points,k=a.length;if(a[E]!==j){for(;k--;)if(a[k]===j)return k}else return E}function isSkipSeries(j){var E=j.chart.options.accessibility,a=E.keyboardNavigation.seriesNavigation,k=j.options.accessibility||{},tt=k.keyboardNavigation;return tt&&tt.enabled===!1||k.enabled===!1||j.options.enableMouseTracking===!1||!j.visible||a.pointNavigationEnabledThreshold&&a.pointNavigationEnabledThreshold<=j.points.length}function isSkipPoint(j){var E=j.series.chart.options.accessibility,a=j.options.accessibility&&j.options.accessibility.enabled===!1;return j.isNull&&E.keyboardNavigation.seriesNavigation.skipNullPoints||j.visible===!1||j.isInside===!1||a||isSkipSeries(j.series)}function getClosestPoint(j,E,a,k){var tt=1/0,et,rt,nt,ot=E.points.length,st=function(lt){return!(defined$o(lt.plotX)&&defined$o(lt.plotY))};if(!st(j)){for(;ot--;)et=E.points[ot],!st(et)&&(nt=(j.plotX-et.plotX)*(j.plotX-et.plotX)*(a||1)+(j.plotY-et.plotY)*(j.plotY-et.plotY)*(k||1),nt<tt&&(tt=nt,rt=ot));return defined$o(rt)?E.points[rt]:void 0}}Point$5.prototype.highlight=function(){var j=this.series.chart;return this.isNull?j.tooltip&&j.tooltip.hide(0):this.onMouseOver(),scrollToPoint(this),this.graphic&&j.setFocusToElement(this.graphic),j.highlightedPoint=this,this};Chart$1.prototype.highlightAdjacentPoint=function(j){var E=this,a=E.series,k=E.highlightedPoint,tt=k&&getPointIndex(k)||0,et=k&&k.series.points,rt=E.series&&E.series[E.series.length-1],nt=rt&&rt.points&&rt.points[rt.points.length-1],ot,st;if(!a[0]||!a[0].points)return!1;if(!k)st=j?a[0].points[0]:nt;else if(ot=a[k.series.index+(j?1:-1)],st=et[tt+(j?1:-1)],!st&&ot&&(st=ot.points[j?0:ot.points.length-1]),!st)return!1;return isSkipPoint(st)?(ot=st.series,isSkipSeries(ot)?E.highlightedPoint=j?ot.points[ot.points.length-1]:ot.points[0]:E.highlightedPoint=st,E.highlightAdjacentPoint(j)):st.highlight()};Series$e.prototype.highlightFirstValidPoint=function(){var j=this.chart.highlightedPoint,E=(j&&j.series)===this?getPointIndex(j):0,a=this.points,k=a.length;if(a&&k){for(var tt=E;tt<k;++tt)if(!isSkipPoint(a[tt]))return a[tt].highlight();for(var et=E;et>=0;--et)if(!isSkipPoint(a[et]))return a[et].highlight()}return!1};Chart$1.prototype.highlightAdjacentSeries=function(j){var E=this,a=E.highlightedPoint,k=E.series&&E.series[E.series.length-1],tt=k&&k.points&&k.points[k.points.length-1],et,rt,nt;return E.highlightedPoint?(et=E.series[a.series.index+(j?-1:1)],!et||(rt=getClosestPoint(a,et,4),!rt)?!1:isSkipSeries(et)?(rt.highlight(),nt=E.highlightAdjacentSeries(j),nt||(a.highlight(),!1)):(rt.highlight(),rt.series.highlightFirstValidPoint())):(et=j?E.series&&E.series[0]:k,rt=j?et&&et.points&&et.points[0]:tt,rt?rt.highlight():!1)};Chart$1.prototype.highlightAdjacentPointVertical=function(j){var E=this.highlightedPoint,a=1/0,k;return!defined$o(E.plotX)||!defined$o(E.plotY)?!1:(this.series.forEach(function(tt){isSkipSeries(tt)||tt.points.forEach(function(et){if(!(!defined$o(et.plotY)||!defined$o(et.plotX)||et===E)){var rt=et.plotY-E.plotY,nt=Math.abs(et.plotX-E.plotX),ot=Math.abs(rt)*Math.abs(rt)+nt*nt*4;tt.yAxis&&tt.yAxis.reversed&&(rt*=-1),!(rt<=0&&j||rt>=0&&!j||ot<5||isSkipPoint(et))&&ot<a&&(a=ot,k=et)}})}),k?k.highlight():!1)};function highlightFirstValidPointInChart(j){var E=!1;return delete j.highlightedPoint,E=j.series.reduce(function(a,k){return a||k.highlightFirstValidPoint()},!1),E}function highlightLastValidPointInChart(j){for(var E=j.series.length,a=E,k=!1;a--&&(j.highlightedPoint=j.series[a].points[j.series[a].points.length-1],k=j.series[a].highlightFirstValidPoint(),!k););return k}function updateChartFocusAfterDrilling(j){highlightFirstValidPointInChart(j),j.focusElement&&j.focusElement.removeFocusBorder()}function SeriesKeyboardNavigation(j,E){this.keyCodes=E,this.chart=j}extend$X(SeriesKeyboardNavigation.prototype,{init:function(){var j=this,E=this.chart,a=this.eventProvider=new EventProvider;a.addEvent(Series$e,"destroy",function(){return j.onSeriesDestroy(this)}),a.addEvent(E,"afterDrilldown",function(){updateChartFocusAfterDrilling(this)}),a.addEvent(E,"drilldown",function(k){var tt=k.point,et=tt.series;j.lastDrilledDownPoint={x:tt.x,y:tt.y,seriesName:et?et.name:""}}),a.addEvent(E,"drillupall",function(){setTimeout(function(){j.onDrillupAll()},10)}),a.addEvent(Point$5,"afterSetState",function(){var k=this,tt=k.graphic&&k.graphic.element;E.highlightedPoint===k&&doc$a.activeElement!==tt&&tt&&tt.focus&&tt.focus()})},onDrillupAll:function(){var j=this.lastDrilledDownPoint,E=this.chart,a=j&&getSeriesFromName(E,j.seriesName),k;j&&a&&defined$o(j.x)&&defined$o(j.y)&&(k=getPointFromXY(a,j.x,j.y)),E.container&&E.container.focus(),k&&k.highlight&&k.highlight(),E.focusElement&&E.focusElement.removeFocusBorder()},getKeyboardNavigationHandler:function(){var j=this,E=this.keyCodes,a=this.chart,k=a.inverted;return new KeyboardNavigationHandler(a,{keyCodeMap:[[k?[E.up,E.down]:[E.left,E.right],function(tt){return j.onKbdSideways(this,tt)}],[k?[E.left,E.right]:[E.up,E.down],function(tt){return j.onKbdVertical(this,tt)}],[[E.enter,E.space],function(tt,et){var rt=a.highlightedPoint;return rt&&(et.point=rt,fireEvent$e(rt.series,"click",et),rt.firePointEvent("click")),this.response.success}]],init:function(tt){return j.onHandlerInit(this,tt)},terminate:function(){return j.onHandlerTerminate()}})},onKbdSideways:function(j,E){var a=this.keyCodes,k=E===a.right||E===a.down;return this.attemptHighlightAdjacentPoint(j,k)},onKbdVertical:function(j,E){var a=this.chart,k=this.keyCodes,tt=E===k.down||E===k.right,et=a.options.accessibility.keyboardNavigation.seriesNavigation;if(et.mode&&et.mode==="serialize")return this.attemptHighlightAdjacentPoint(j,tt);var rt=a.highlightedPoint&&a.highlightedPoint.series.keyboardMoveVertical?"highlightAdjacentPointVertical":"highlightAdjacentSeries";return a[rt](tt),j.response.success},onHandlerInit:function(j,E){var a=this.chart;return E>0?highlightFirstValidPointInChart(a):highlightLastValidPointInChart(a),j.response.success},onHandlerTerminate:function(){var j=this.chart;j.tooltip&&j.tooltip.hide(0);var E=j.highlightedPoint&&j.highlightedPoint.series;E&&E.onMouseOut&&E.onMouseOut(),j.highlightedPoint&&j.highlightedPoint.onMouseOut&&j.highlightedPoint.onMouseOut(),delete j.highlightedPoint},attemptHighlightAdjacentPoint:function(j,E){var a=this.chart,k=a.options.accessibility.keyboardNavigation.wrapAround,tt=a.highlightAdjacentPoint(E);return tt?j.response.success:k?j.init(E?1:-1):j.response[E?"next":"prev"]},onSeriesDestroy:function(j){var E=this.chart,a=E.highlightedPoint&&E.highlightedPoint.series===j;a&&(delete E.highlightedPoint,E.focusElement&&E.focusElement.removeFocusBorder())},destroy:function(){this.eventProvider.removeAddedEvents()}});var escapeStringForHTML=HTMLUtilities.escapeStringForHTML,stripHTMLTagsFromString$1=HTMLUtilities.stripHTMLTagsFromString;function getChartAnnotationLabels(j){var E=j.annotations||[];return E.reduce(function(a,k){return k.options&&k.options.visible!==!1&&(a=a.concat(k.labels)),a},[])}function getLabelText(j){return j.options&&j.options.accessibility&&j.options.accessibility.description||j.graphic&&j.graphic.text&&j.graphic.text.textStr||""}function getAnnotationLabelDescription(j){var E=j.options&&j.options.accessibility&&j.options.accessibility.description;if(E)return E;var a=j.chart,k=getLabelText(j),tt=j.points,et=function(ut){return ut.graphic&&ut.graphic.element&&ut.graphic.element.getAttribute("aria-label")||""},rt=function(ut){var dt=ut.accessibility&&ut.accessibility.valueDescription||et(ut),ft=ut&&ut.series.name||"";return(ft?ft+", ":"")+"data point "+dt},nt=tt.filter(function(ut){return!!ut.graphic}).map(rt).filter(function(ut){return!!ut}),ot=nt.length,st=ot>1?"MultiplePoints":ot?"SinglePoint":"NoPoints",lt="accessibility.screenReaderSection.annotations.description"+st,ht={annotationText:k,annotation:j,numPoints:ot,annotationPoint:nt[0],additionalAnnotationPoints:nt.slice(1)};return a.langFormat(lt,ht)}function getAnnotationListItems(j){var E=getChartAnnotationLabels(j);return E.map(function(a){var k=escapeStringForHTML(stripHTMLTagsFromString$1(getAnnotationLabelDescription(a)));return k?"<li>"+k+"</li>":""})}function getAnnotationsInfoHTML$1(j){var E=j.annotations;if(!(E&&E.length))return"";var a=getAnnotationListItems(j);return'<ul style="list-style-type: none">'+a.join(" ")+"</ul>"}function getPointAnnotationTexts$1(j){var E=getChartAnnotationLabels(j.series.chart),a=E.filter(function(k){return k.points.indexOf(j)>-1});return a.length?a.map(function(k){return""+getLabelText(k)}):[]}var AnnotationsA11y={getAnnotationsInfoHTML:getAnnotationsInfoHTML$1,getAnnotationLabelDescription,getAnnotationListItems,getPointAnnotationTexts:getPointAnnotationTexts$1},getPointAnnotationTexts=AnnotationsA11y.getPointAnnotationTexts,getAxisDescription$1=ChartUtilities.getAxisDescription,getSeriesFirstPointElement=ChartUtilities.getSeriesFirstPointElement,getSeriesA11yElement=ChartUtilities.getSeriesA11yElement,unhideChartElementFromAT$4=ChartUtilities.unhideChartElementFromAT,format$6=FormatUtilities.format,numberFormat=FormatUtilities.numberFormat,reverseChildNodes=HTMLUtilities.reverseChildNodes,stripHTMLTags$1=HTMLUtilities.stripHTMLTagsFromString,find$6=Utilities.find,isNumber$l=Utilities.isNumber,pick$T=Utilities.pick,defined$n=Utilities.defined;function findFirstPointWithGraphic(j){var E=j.index;return!j.series||!j.series.data||!defined$n(E)?null:find$6(j.series.data,function(a){return!!(a&&typeof a.index<"u"&&a.index>E&&a.graphic&&a.graphic.element)})||null}function shouldAddDummyPoint(j){var E=j.series&&j.series.is("sunburst"),a=j.isNull;return a&&!E}function makeDummyElement(j,E){var a=j.series.chart.renderer,k=a.rect(E.x,E.y,1,1);return k.attr({class:"highcharts-a11y-dummy-point",fill:"none",opacity:0,"fill-opacity":0,"stroke-opacity":0}),k}function addDummyPointElement(j){var E=j.series,a=findFirstPointWithGraphic(j),k=a&&a.graphic,tt=k?k.parentGroup:E.graph||E.group,et=a?{x:pick$T(j.plotX,a.plotX,0),y:pick$T(j.plotY,a.plotY,0)}:{x:pick$T(j.plotX,0),y:pick$T(j.plotY,0)},rt=makeDummyElement(j,et);if(tt&&tt.element)return j.graphic=rt,j.hasDummyGraphic=!0,rt.add(tt),tt.element.insertBefore(rt.element,k?k.element:null),rt.element}function hasMorePointsThanDescriptionThreshold(j){var E=j.chart.options.accessibility,a=E.series.pointDescriptionEnabledThreshold;return!!(a!==!1&&j.points&&j.points.length>=a)}function shouldSetScreenReaderPropsOnPoints(j){var E=j.options.accessibility||{};return!hasMorePointsThanDescriptionThreshold(j)&&!E.exposeAsGroupOnly}function shouldSetKeyboardNavPropsOnPoints(j){var E=j.chart.options.accessibility,a=E.keyboardNavigation.seriesNavigation;return!!(j.points&&(j.points.length<a.pointNavigationEnabledThreshold||a.pointNavigationEnabledThreshold===!1))}function shouldDescribeSeriesElement(j){var E=j.chart,a=E.options.chart,k=a.options3d&&a.options3d.enabled,tt=E.series.length>1,et=E.options.accessibility.series.describeSingleSeries,rt=(j.options.accessibility||{}).exposeAsGroupOnly,nt=k&&tt;return!nt&&(tt||et||rt||hasMorePointsThanDescriptionThreshold(j))}function pointNumberToString(j,E){var a=j.series.chart,k=a.options.accessibility.point||{},tt=j.series.tooltipOptions||{},et=a.options.lang;return isNumber$l(E)?numberFormat(E,k.valueDecimals||tt.valueDecimals||-1,et.decimalPoint,et.accessibility.thousandsSep||et.thousandsSep):E}function getSeriesDescriptionText(j){var E=j.options.accessibility||{},a=E.description;return a&&j.chart.langFormat("accessibility.series.description",{description:a,series:j})||""}function getSeriesAxisDescriptionText(j,E){var a=j[E];return j.chart.langFormat("accessibility.series."+E+"Description",{name:getAxisDescription$1(a),series:j})}function getPointA11yTimeDescription(j){var E=j.series,a=E.chart,k=a.options.accessibility.point||{},tt=E.xAxis&&E.xAxis.dateTime;if(tt){var et=tt.getXDateFormat(j.x||0,a.options.tooltip.dateTimeLabelFormats),rt=k.dateFormatter&&k.dateFormatter(j)||k.dateFormat||et;return a.time.dateFormat(rt,j.x||0,void 0)}}function getPointXDescription(j){var E=getPointA11yTimeDescription(j),a=j.series.xAxis||{},k=a.categories&&defined$n(j.category)&&(""+j.category).replace("<br/>"," "),tt=j.id&&j.id.indexOf("highcharts-")<0,et="x, "+j.x;return j.name||E||k||(tt?j.id:et)}function getPointArrayMapValueDescription(j,E,a){var k=E||"",tt=a||"",et=function(nt){var ot=pointNumberToString(j,pick$T(j[nt],j.options[nt]));return nt+": "+k+ot+tt},rt=j.series.pointArrayMap;return rt.reduce(function(nt,ot){return nt+(nt.length?", ":"")+et(ot)},"")}function getPointValue(j){var E=j.series,a=E.chart.options.accessibility.point||{},k=E.tooltipOptions||{},tt=a.valuePrefix||k.valuePrefix||"",et=a.valueSuffix||k.valueSuffix||"",rt=typeof j.value<"u"?"value":"y",nt=pointNumberToString(j,j[rt]);return j.isNull?E.chart.langFormat("accessibility.series.nullPointValue",{point:j}):E.pointArrayMap?getPointArrayMapValueDescription(j,tt,et):tt+nt+et}function getPointAnnotationDescription(j){var E=j.series.chart,a="accessibility.series.pointAnnotationsDescription",k=getPointAnnotationTexts(j),tt={point:j,annotations:k};return k.length?E.langFormat(a,tt):""}function getPointValueDescription(j){var E=j.series,a=E.chart,k=a.options.accessibility.point.valueDescriptionFormat,tt=pick$T(E.xAxis&&E.xAxis.options.accessibility&&E.xAxis.options.accessibility.enabled,!a.angular),et=tt?getPointXDescription(j):"",rt={point:j,index:defined$n(j.index)?j.index+1:"",xDescription:et,value:getPointValue(j),separator:tt?", ":""};return format$6(k,rt,a)}function defaultPointDescriptionFormatter$1(j){var E=j.series,a=E.chart,k=getPointValueDescription(j),tt=j.options&&j.options.accessibility&&j.options.accessibility.description,et=tt?" "+tt:"",rt=a.series.length>1&&E.name?" "+E.name+".":"",nt=getPointAnnotationDescription(j),ot=nt?" "+nt:"";return j.accessibility=j.accessibility||{},j.accessibility.valueDescription=k,k+et+rt+ot}function setPointScreenReaderAttribs(j,E){var a=j.series,k=a.chart.options.accessibility.point||{},tt=a.options.accessibility||{},et=stripHTMLTags$1(tt.pointDescriptionFormatter&&tt.pointDescriptionFormatter(j)||k.descriptionFormatter&&k.descriptionFormatter(j)||defaultPointDescriptionFormatter$1(j));E.setAttribute("role","img"),E.setAttribute("aria-label",et)}function describePointsInSeries(j){var E=shouldSetScreenReaderPropsOnPoints(j),a=shouldSetKeyboardNavPropsOnPoints(j);(E||a)&&j.points.forEach(function(k){var tt=k.graphic&&k.graphic.element||shouldAddDummyPoint(k)&&addDummyPointElement(k),et=k.options&&k.options.accessibility&&k.options.accessibility.enabled===!1;tt&&(tt.setAttribute("tabindex","-1"),tt.style.outline="0",E&&!et?setPointScreenReaderAttribs(k,tt):tt.setAttribute("aria-hidden",!0))})}function defaultSeriesDescriptionFormatter$1(j){var E=j.chart,a=E.types||[],k=getSeriesDescriptionText(j),tt=function(lt){return E[lt]&&E[lt].length>1&&j[lt]},et=getSeriesAxisDescriptionText(j,"xAxis"),rt=getSeriesAxisDescriptionText(j,"yAxis"),nt={name:j.name||"",ix:j.index+1,numSeries:E.series&&E.series.length,numPoints:j.points&&j.points.length,series:j},ot=a.length>1?"Combination":"",st=E.langFormat("accessibility.series.summary."+j.type+ot,nt)||E.langFormat("accessibility.series.summary.default"+ot,nt);return st+(k?" "+k:"")+(tt("yAxis")?" "+rt:"")+(tt("xAxis")?" "+et:"")}function describeSeriesElement(j,E){var a=j.options.accessibility||{},k=j.chart.options.accessibility,tt=k.landmarkVerbosity;a.exposeAsGroupOnly?E.setAttribute("role","img"):tt==="all"&&E.setAttribute("role","region"),E.setAttribute("tabindex","-1"),E.style.outline="0",E.setAttribute("aria-label",stripHTMLTags$1(k.series.descriptionFormatter&&k.series.descriptionFormatter(j)||defaultSeriesDescriptionFormatter$1(j)))}function describeSeries$1(j){var E=j.chart,a=getSeriesFirstPointElement(j),k=getSeriesA11yElement(j),tt=E.is3d&&E.is3d();k&&(k.lastChild===a&&!tt&&reverseChildNodes(k),describePointsInSeries(j),unhideChartElementFromAT$4(E,k),shouldDescribeSeriesElement(j)?describeSeriesElement(j,k):k.setAttribute("aria-label",""))}var SeriesDescriber={describeSeries:describeSeries$1,defaultPointDescriptionFormatter:defaultPointDescriptionFormatter$1,defaultSeriesDescriptionFormatter:defaultSeriesDescriptionFormatter$1,getPointA11yTimeDescription,getPointXDescription,getPointValue,getPointValueDescription},doc$9=H.doc,setElAttrs$3=HTMLUtilities.setElAttrs,visuallyHideElement$1=HTMLUtilities.visuallyHideElement,Announcer=function(){function j(E,a){this.chart=E,this.domElementProvider=new DOMElementProvider,this.announceRegion=this.addAnnounceRegion(a)}return j.prototype.destroy=function(){this.domElementProvider.destroyCreatedElements()},j.prototype.announce=function(E){var a=this;AST.setElementHTML(this.announceRegion,E),this.clearAnnouncementRegionTimer&&clearTimeout(this.clearAnnouncementRegionTimer),this.clearAnnouncementRegionTimer=setTimeout(function(){a.announceRegion.innerHTML="",delete a.clearAnnouncementRegionTimer},1e3)},j.prototype.addAnnounceRegion=function(E){var a=this.chart.announcerContainer||this.createAnnouncerContainer(),k=this.domElementProvider.createElement("div");return setElAttrs$3(k,{"aria-hidden":!1,"aria-live":E}),visuallyHideElement$1(k),a.appendChild(k),k},j.prototype.createAnnouncerContainer=function(){var E=this.chart,a=doc$9.createElement("div");return setElAttrs$3(a,{"aria-hidden":!1,style:"position:relative",class:"highcharts-announcer-container"}),E.renderTo.insertBefore(a,E.renderTo.firstChild),E.announcerContainer=a,a},j}(),extend$W=Utilities.extend,defined$m=Utilities.defined,getChartTitle$2=ChartUtilities.getChartTitle,defaultPointDescriptionFormatter=SeriesDescriber.defaultPointDescriptionFormatter,defaultSeriesDescriptionFormatter=SeriesDescriber.defaultSeriesDescriptionFormatter;function chartHasAnnounceEnabled(j){return!!j.options.accessibility.announceNewData.enabled}function findPointInDataArray(j){var E=j.series.data.filter(function(a){return j.x===a.x&&j.y===a.y});return E.length===1?E[0]:j}function getUniqueSeries(j,E){var a=(j||[]).concat(E||[]).reduce(function(k,tt){return k[tt.name+tt.index]=tt,k},{});return Object.keys(a).map(function(k){return a[k]})}var NewDataAnnouncer=function(j){this.chart=j};extend$W(NewDataAnnouncer.prototype,{init:function(){var j=this.chart,E=j.options.accessibility.announceNewData,a=E.interruptUser?"assertive":"polite";this.lastAnnouncementTime=0,this.dirty={allSeries:{}},this.eventProvider=new EventProvider,this.announcer=new Announcer(j,a),this.addEventListeners()},destroy:function(){this.eventProvider.removeAddedEvents(),this.announcer.destroy()},addEventListeners:function(){var j=this,E=this.chart,a=this.eventProvider;a.addEvent(E,"afterDrilldown",function(){j.lastAnnouncementTime=0}),a.addEvent(Series$e,"updatedData",function(){j.onSeriesUpdatedData(this)}),a.addEvent(E,"afterAddSeries",function(k){j.onSeriesAdded(k.series)}),a.addEvent(Series$e,"addPoint",function(k){j.onPointAdded(k.point)}),a.addEvent(E,"redraw",function(){j.announceDirtyData()})},onSeriesUpdatedData:function(j){var E=this.chart;j.chart===E&&chartHasAnnounceEnabled(E)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[j.name+j.index]=j)},onSeriesAdded:function(j){chartHasAnnounceEnabled(this.chart)&&(this.dirty.hasDirty=!0,this.dirty.allSeries[j.name+j.index]=j,this.dirty.newSeries=defined$m(this.dirty.newSeries)?void 0:j)},onPointAdded:function(j){var E=j.series.chart;this.chart===E&&chartHasAnnounceEnabled(E)&&(this.dirty.newPoint=defined$m(this.dirty.newPoint)?void 0:j)},announceDirtyData:function(){var j=this.chart,E=this;if(j.options.accessibility.announceNewData&&this.dirty.hasDirty){var a=this.dirty.newPoint;a&&(a=findPointInDataArray(a)),this.queueAnnouncement(Object.keys(this.dirty.allSeries).map(function(k){return E.dirty.allSeries[k]}),this.dirty.newSeries,a),this.dirty={allSeries:{}}}},queueAnnouncement:function(j,E,a){var k=this,tt=this.chart,et=tt.options.accessibility.announceNewData;if(et.enabled){var rt=+new Date,nt=rt-this.lastAnnouncementTime,ot=Math.max(0,et.minAnnounceInterval-nt),st=getUniqueSeries(this.queuedAnnouncement&&this.queuedAnnouncement.series,j),lt=this.buildAnnouncementMessage(st,E,a);lt&&(this.queuedAnnouncement&&clearTimeout(this.queuedAnnouncementTimer),this.queuedAnnouncement={time:rt,message:lt,series:st},this.queuedAnnouncementTimer=setTimeout(function(){k&&k.announcer&&(k.lastAnnouncementTime=+new Date,k.announcer.announce(k.queuedAnnouncement.message),delete k.queuedAnnouncement,delete k.queuedAnnouncementTimer)},ot))}},buildAnnouncementMessage:function(j,E,a){var k=this.chart,tt=k.options.accessibility.announceNewData;if(tt.announcementFormatter){var et=tt.announcementFormatter(j,E,a);if(et!==!1)return et.length?et:null}var rt=H.charts&&H.charts.length>1?"Multiple":"Single",nt=E?"newSeriesAnnounce"+rt:a?"newPointAnnounce"+rt:"newDataAnnounce",ot=getChartTitle$2(k);return k.langFormat("accessibility.announceNewData."+nt,{chartTitle:ot,seriesDesc:E?defaultSeriesDescriptionFormatter(E):null,pointDesc:a?defaultPointDescriptionFormatter(a):null,point:a,series:E})}});var addEvent$z=Utilities.addEvent,merge$M=Utilities.merge;function isWithinDescriptionThreshold(j){var E=j.chart.options.accessibility;return j.points.length<E.series.pointDescriptionEnabledThreshold||E.series.pointDescriptionEnabledThreshold===!1}function shouldForceMarkers(j){var E=j.chart,a=E.options.accessibility.enabled,k=(j.options.accessibility&&j.options.accessibility.enabled)!==!1;return a&&k&&isWithinDescriptionThreshold(j)}function hasIndividualPointMarkerOptions(j){return!!(j._hasPointMarkers&&j.points&&j.points.length)}function unforceSeriesMarkerOptions(j){var E=j.resetA11yMarkerOptions;E&&merge$M(!0,j.options,{marker:{enabled:E.enabled,states:{normal:{opacity:E.states&&E.states.normal&&E.states.normal.opacity}}}})}function forceZeroOpacityMarkerOptions(j){merge$M(!0,j,{marker:{enabled:!0,states:{normal:{opacity:0}}}})}function getPointMarkerOpacity(j){return j.marker.states&&j.marker.states.normal&&j.marker.states.normal.opacity||1}function unforcePointMarkerOptions(j){merge$M(!0,j.marker,{states:{normal:{opacity:getPointMarkerOpacity(j)}}})}function handleForcePointMarkers(j){for(var E=j.points.length;E--;){var a=j.points[E],k=a.options;delete a.hasForcedA11yMarker,k.marker&&(k.marker.enabled?(unforcePointMarkerOptions(k),a.hasForcedA11yMarker=!1):(forceZeroOpacityMarkerOptions(k),a.hasForcedA11yMarker=!0))}}function addForceMarkersEvents(){addEvent$z(Series$e,"render",function(){var j=this,E=j.options;shouldForceMarkers(j)?(E.marker&&E.marker.enabled===!1&&(j.a11yMarkersForced=!0,forceZeroOpacityMarkerOptions(j.options)),hasIndividualPointMarkerOptions(j)&&handleForcePointMarkers(j)):j.a11yMarkersForced&&(delete j.a11yMarkersForced,unforceSeriesMarkerOptions(j))}),addEvent$z(Series$e,"afterSetOptions",function(j){this.resetA11yMarkerOptions=merge$M(j.options.marker||{},this.userOptions.marker||{})}),addEvent$z(Series$e,"afterRender",function(){var j=this;j.chart.styledMode&&(j.markerGroup&&j.markerGroup[j.a11yMarkersForced?"addClass":"removeClass"]("highcharts-a11y-markers-hidden"),hasIndividualPointMarkerOptions(j)&&j.points.forEach(function(E){E.graphic&&(E.graphic[E.hasForcedA11yMarker?"addClass":"removeClass"]("highcharts-a11y-marker-hidden"),E.graphic[E.hasForcedA11yMarker===!1?"addClass":"removeClass"]("highcharts-a11y-marker-visible"))}))})}var extend$V=Utilities.extend,hideSeriesFromAT=ChartUtilities.hideSeriesFromAT,describeSeries=SeriesDescriber.describeSeries;H.SeriesAccessibilityDescriber=SeriesDescriber;addForceMarkersEvents();var SeriesComponent=function(){};SeriesComponent.prototype=new AccessibilityComponent;extend$V(SeriesComponent.prototype,{init:function(){this.newDataAnnouncer=new NewDataAnnouncer(this.chart),this.newDataAnnouncer.init(),this.keyboardNavigation=new SeriesKeyboardNavigation(this.chart,this.keyCodes),this.keyboardNavigation.init(),this.hideTooltipFromATWhenShown(),this.hideSeriesLabelsFromATWhenShown()},hideTooltipFromATWhenShown:function(){var j=this;this.addEvent(Tooltip,"refresh",function(){this.chart===j.chart&&this.label&&this.label.element&&this.label.element.setAttribute("aria-hidden",!0)})},hideSeriesLabelsFromATWhenShown:function(){this.addEvent(this.chart,"afterDrawSeriesLabels",function(){this.series.forEach(function(j){j.labelBySeries&&j.labelBySeries.attr("aria-hidden",!0)})})},onChartRender:function(){var j=this.chart;j.series.forEach(function(E){var a=(E.options.accessibility&&E.options.accessibility.enabled)!==!1&&E.visible;a?describeSeries(E):hideSeriesFromAT(E)})},getKeyboardNavigation:function(){return this.keyboardNavigation.getKeyboardNavigationHandler()},destroy:function(){this.newDataAnnouncer.destroy(),this.keyboardNavigation.destroy()}});var unhideChartElementFromAT$3=ChartUtilities.unhideChartElementFromAT,noop$d=H.noop,removeElement=HTMLUtilities.removeElement,setElAttrs$2=HTMLUtilities.setElAttrs,extend$U=Utilities.extend,pick$S=Utilities.pick;function chartHasMapZoom(j){return!!(j.mapZoom&&j.mapNavButtons&&j.mapNavButtons.length)}H.Axis.prototype.panStep=function(j,E){var a=E||3,k=this.getExtremes(),tt=(k.max-k.min)/a*j,et=k.max+tt,rt=k.min+tt,nt=et-rt;j<0&&rt<k.dataMin?(rt=k.dataMin,et=rt+nt):j>0&&et>k.dataMax&&(et=k.dataMax,rt=et-nt),this.setExtremes(rt,et)};var ZoomComponent=noop$d;ZoomComponent.prototype=new AccessibilityComponent;extend$U(ZoomComponent.prototype,{init:function(){var j=this,E=this.chart;["afterShowResetZoom","afterDrilldown","drillupall"].forEach(function(a){j.addEvent(E,a,function(){j.updateProxyOverlays()})})},onChartUpdate:function(){var j=this.chart,E=this;j.mapNavButtons&&j.mapNavButtons.forEach(function(a,k){unhideChartElementFromAT$3(j,a.element),E.setMapNavButtonAttrs(a.element,"accessibility.zoom.mapZoom"+(k?"Out":"In"))})},setMapNavButtonAttrs:function(j,E){var a=this.chart,k=a.langFormat(E,{chart:a});setElAttrs$2(j,{tabindex:-1,role:"button","aria-label":k})},onChartRender:function(){this.updateProxyOverlays()},updateProxyOverlays:function(){var j=this.chart;removeElement(this.drillUpProxyGroup),removeElement(this.resetZoomProxyGroup),j.resetZoomButton&&this.recreateProxyButtonAndGroup(j.resetZoomButton,"resetZoomProxyButton","resetZoomProxyGroup",j.langFormat("accessibility.zoom.resetZoomButton",{chart:j})),j.drillUpButton&&this.recreateProxyButtonAndGroup(j.drillUpButton,"drillUpProxyButton","drillUpProxyGroup",j.langFormat("accessibility.drillUpButton",{chart:j,buttonText:j.getDrilldownBackText()}))},recreateProxyButtonAndGroup:function(j,E,a,k){removeElement(this[a]),this[a]=this.addProxyGroup(),this[E]=this.createProxyButton(j,this[a],{"aria-label":k,tabindex:-1})},getMapZoomNavigation:function(){var j=this.keyCodes,E=this.chart,a=this;return new KeyboardNavigationHandler(E,{keyCodeMap:[[[j.up,j.down,j.left,j.right],function(k){return a.onMapKbdArrow(this,k)}],[[j.tab],function(k,tt){return a.onMapKbdTab(this,tt)}],[[j.space,j.enter],function(){return a.onMapKbdClick(this)}]],validate:function(){return chartHasMapZoom(E)},init:function(k){return a.onMapNavInit(k)}})},onMapKbdArrow:function(j,E){var a=this.keyCodes,k=E===a.up||E===a.down?"yAxis":"xAxis",tt=E===a.left||E===a.up?-1:1;return this.chart[k][0].panStep(tt),j.response.success},onMapKbdTab:function(j,E){var a,k=this.chart,tt=j.response,et=E.shiftKey,rt=et&&!this.focusedMapNavButtonIx||!et&&this.focusedMapNavButtonIx;return k.mapNavButtons[this.focusedMapNavButtonIx].setState(0),rt?(k.mapZoom(),tt[et?"prev":"next"]):(this.focusedMapNavButtonIx+=et?-1:1,a=k.mapNavButtons[this.focusedMapNavButtonIx],k.setFocusToElement(a.box,a.element),a.setState(2),tt.success)},onMapKbdClick:function(j){return this.fakeClickEvent(this.chart.mapNavButtons[this.focusedMapNavButtonIx].element),j.response.success},onMapNavInit:function(j){var E=this.chart,a=E.mapNavButtons[0],k=E.mapNavButtons[1],tt=j>0?a:k;E.setFocusToElement(tt.box,tt.element),tt.setState(2),this.focusedMapNavButtonIx=j>0?0:1},simpleButtonNavigation:function(j,E,a){var k=this.keyCodes,tt=this,et=this.chart;return new KeyboardNavigationHandler(et,{keyCodeMap:[[[k.tab,k.up,k.down,k.left,k.right],function(rt,nt){var ot=rt===k.tab&&nt.shiftKey||rt===k.left||rt===k.up;return this.response[ot?"prev":"next"]}],[[k.space,k.enter],function(){var rt=a(this,et);return pick$S(rt,this.response.success)}]],validate:function(){var rt=et[j]&&et[j].box&&tt[E];return rt},init:function(){et.setFocusToElement(et[j].box,tt[E])}})},getKeyboardNavigation:function(){return[this.simpleButtonNavigation("resetZoomButton","resetZoomProxyButton",function(j,E){E.zoomOut()}),this.simpleButtonNavigation("drillUpButton","drillUpProxyButton",function(j,E){return E.drillUp(),j.response.prev}),this.getMapZoomNavigation()]}});var unhideChartElementFromAT$2=ChartUtilities.unhideChartElementFromAT,getAxisRangeDescription$1=ChartUtilities.getAxisRangeDescription,setElAttrs$1=HTMLUtilities.setElAttrs,addEvent$y=Utilities.addEvent,extend$T=Utilities.extend;function shouldRunInputNavigation(j){return Boolean(j.rangeSelector&&j.rangeSelector.inputGroup&&j.rangeSelector.inputGroup.element.getAttribute("visibility")!=="hidden"&&j.options.rangeSelector.inputEnabled!==!1&&j.rangeSelector.minInput&&j.rangeSelector.maxInput)}Chart$1.prototype.highlightRangeSelectorButton=function(j){var E=this.rangeSelector&&this.rangeSelector.buttons||[],a=this.highlightedRangeSelectorItemIx,k=this.rangeSelector&&this.rangeSelector.selected;return typeof a<"u"&&E[a]&&a!==k&&E[a].setState(this.oldRangeSelectorItemState||0),this.highlightedRangeSelectorItemIx=j,E[j]?(this.setFocusToElement(E[j].box,E[j].element),j!==k&&(this.oldRangeSelectorItemState=E[j].state,E[j].setState(1)),!0):!1};addEvent$y(RangeSelector,"afterBtnClick",function(){if(this.chart.accessibility&&this.chart.accessibility.components.rangeSelector)return this.chart.accessibility.components.rangeSelector.onAfterBtnClick()});var RangeSelectorComponent=function(){};RangeSelectorComponent.prototype=new AccessibilityComponent;extend$T(RangeSelectorComponent.prototype,{init:function(){var j=this.chart;this.announcer=new Announcer(j,"polite")},onChartUpdate:function(){var j=this.chart,E=this,a=j.rangeSelector;a&&(this.updateSelectorVisibility(),this.setDropdownAttrs(),a.buttons&&a.buttons.length&&a.buttons.forEach(function(k){E.setRangeButtonAttrs(k)}),a.maxInput&&a.minInput&&["minInput","maxInput"].forEach(function(k,tt){var et=a[k];et&&(unhideChartElementFromAT$2(j,et),E.setRangeInputAttrs(et,"accessibility.rangeSelector."+(tt?"max":"min")+"InputLabel"))}))},updateSelectorVisibility:function(){var j=this.chart,E=j.rangeSelector,a=E&&E.dropdown,k=E&&E.buttons||[],tt=function(et){return et.setAttribute("aria-hidden",!0)};E&&E.hasVisibleDropdown&&a?(unhideChartElementFromAT$2(j,a),k.forEach(function(et){return tt(et.element)})):(a&&tt(a),k.forEach(function(et){return unhideChartElementFromAT$2(j,et.element)}))},setDropdownAttrs:function(){var j=this.chart,E=j.rangeSelector&&j.rangeSelector.dropdown;if(E){var a=j.langFormat("accessibility.rangeSelector.dropdownLabel",{rangeTitle:j.options.lang.rangeSelectorZoom});E.setAttribute("aria-label",a),E.setAttribute("tabindex",-1)}},setRangeButtonAttrs:function(j){setElAttrs$1(j.element,{tabindex:-1,role:"button"})},setRangeInputAttrs:function(j,E){var a=this.chart;setElAttrs$1(j,{tabindex:-1,"aria-label":a.langFormat(E,{chart:a})})},onButtonNavKbdArrowKey:function(j,E){var a=j.response,k=this.keyCodes,tt=this.chart,et=tt.options.accessibility.keyboardNavigation.wrapAround,rt=E===k.left||E===k.up?-1:1,nt=tt.highlightRangeSelectorButton(tt.highlightedRangeSelectorItemIx+rt);return nt?a.success:et?(j.init(rt),a.success):a[rt>0?"next":"prev"]},onButtonNavKbdClick:function(j){var E=j.response,a=this.chart,k=a.oldRangeSelectorItemState===3;return k||this.fakeClickEvent(a.rangeSelector.buttons[a.highlightedRangeSelectorItemIx].element),E.success},onAfterBtnClick:function(){var j=this.chart,E=getAxisRangeDescription$1(j.xAxis[0]),a=j.langFormat("accessibility.rangeSelector.clickButtonAnnouncement",{chart:j,axisRangeDescription:E});a&&this.announcer.announce(a)},onInputKbdMove:function(j){var E=this.chart,a=E.rangeSelector,k=E.highlightedInputRangeIx=(E.highlightedInputRangeIx||0)+j,tt=k>1||k<0;if(tt)E.accessibility&&(E.accessibility.keyboardNavigation.tabindexContainer.focus(),E.accessibility.keyboardNavigation[j<0?"prev":"next"]());else if(a){var et=a[k?"maxDateBox":"minDateBox"],rt=a[k?"maxInput":"minInput"];et&&rt&&E.setFocusToElement(et,rt)}},onInputNavInit:function(j){var E=this,a=this,k=this.chart,tt=j>0?0:1,et=k.rangeSelector,rt=et&&et[tt?"maxDateBox":"minDateBox"],nt=et&&et.minInput,ot=et&&et.maxInput,st=tt?ot:nt;if(k.highlightedInputRangeIx=tt,rt&&nt&&ot){k.setFocusToElement(rt,st),this.removeInputKeydownHandler&&this.removeInputKeydownHandler();var lt=function(dt){var ft=(dt.which||dt.keyCode)===E.keyCodes.tab;ft&&(dt.preventDefault(),dt.stopPropagation(),a.onInputKbdMove(dt.shiftKey?-1:1))},ht=addEvent$y(nt,"keydown",lt),ut=addEvent$y(ot,"keydown",lt);this.removeInputKeydownHandler=function(){ht(),ut()}}},onInputNavTerminate:function(){var j=this.chart.rangeSelector||{};j.maxInput&&j.hideInput("max"),j.minInput&&j.hideInput("min"),this.removeInputKeydownHandler&&(this.removeInputKeydownHandler(),delete this.removeInputKeydownHandler)},initDropdownNav:function(){var j=this,E=this.chart,a=E.rangeSelector,k=a&&a.dropdown;a&&k&&(E.setFocusToElement(a.buttonGroup,k),this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeDropdownKeydownHandler=addEvent$y(k,"keydown",function(tt){var et=(tt.which||tt.keyCode)===j.keyCodes.tab;et&&(tt.preventDefault(),tt.stopPropagation(),E.accessibility&&(E.accessibility.keyboardNavigation.tabindexContainer.focus(),E.accessibility.keyboardNavigation[tt.shiftKey?"prev":"next"]()))}))},getRangeSelectorButtonNavigation:function(){var j=this.chart,E=this.keyCodes,a=this;return new KeyboardNavigationHandler(j,{keyCodeMap:[[[E.left,E.right,E.up,E.down],function(k){return a.onButtonNavKbdArrowKey(this,k)}],[[E.enter,E.space],function(){return a.onButtonNavKbdClick(this)}]],validate:function(){return!!(j.rangeSelector&&j.rangeSelector.buttons&&j.rangeSelector.buttons.length)},init:function(k){var tt=j.rangeSelector;if(tt&&tt.hasVisibleDropdown)a.initDropdownNav();else if(tt){var et=tt.buttons.length-1;j.highlightRangeSelectorButton(k>0?0:et)}},terminate:function(){a.removeDropdownKeydownHandler&&(a.removeDropdownKeydownHandler(),delete a.removeDropdownKeydownHandler)}})},getRangeSelectorInputNavigation:function(){var j=this.chart,E=this;return new KeyboardNavigationHandler(j,{keyCodeMap:[],validate:function(){return shouldRunInputNavigation(j)},init:function(a){E.onInputNavInit(a)},terminate:function(){E.onInputNavTerminate()}})},getKeyboardNavigation:function(){return[this.getRangeSelectorButtonNavigation(),this.getRangeSelectorInputNavigation()]},destroy:function(){this.removeDropdownKeydownHandler&&this.removeDropdownKeydownHandler(),this.removeInputKeydownHandler&&this.removeInputKeydownHandler(),this.announcer&&this.announcer.destroy()}});var format$5=FormatUtilities.format,doc$8=H.doc,extend$S=Utilities.extend,pick$R=Utilities.pick,getAnnotationsInfoHTML=AnnotationsA11y.getAnnotationsInfoHTML,getAxisDescription=ChartUtilities.getAxisDescription,getAxisRangeDescription=ChartUtilities.getAxisRangeDescription,getChartTitle$1=ChartUtilities.getChartTitle,unhideChartElementFromAT$1=ChartUtilities.unhideChartElementFromAT,addClass=HTMLUtilities.addClass,getElement=HTMLUtilities.getElement,getHeadingTagNameForElement=HTMLUtilities.getHeadingTagNameForElement,setElAttrs=HTMLUtilities.setElAttrs,stripHTMLTagsFromString=HTMLUtilities.stripHTMLTagsFromString,visuallyHideElement=HTMLUtilities.visuallyHideElement;function stripEmptyHTMLTags(j){return j.replace(/<(\w+)[^>]*?>\s*<\/\1>/g,"")}function getTypeDescForMapChart(j,E){return E.mapTitle?j.langFormat("accessibility.chartTypes.mapTypeDescription",E):j.langFormat("accessibility.chartTypes.unknownMap",E)}function getTypeDescForCombinationChart(j,E){return j.langFormat("accessibility.chartTypes.combinationChart",E)}function getTypeDescForEmptyChart(j,E){return j.langFormat("accessibility.chartTypes.emptyChart",E)}function buildTypeDescriptionFromSeries(j,E,a){var k=E[0],tt=j.langFormat("accessibility.seriesTypeDescriptions."+k,a),et=j.series&&j.series.length<2?"Single":"Multiple";return(j.langFormat("accessibility.chartTypes."+k+et,a)||j.langFormat("accessibility.chartTypes.default"+et,a))+(tt?" "+tt:"")}function getTableSummary(j){return j.langFormat("accessibility.table.tableSummary",{chart:j})}Chart$1.prototype.getTypeDescription=function(j){var E=j[0],a=this.series&&this.series[0]||{},k={numSeries:this.series.length,numPoints:a.points&&a.points.length,chart:this,mapTitle:a.mapTitle};return E?E==="map"?getTypeDescForMapChart(this,k):this.types.length>1?getTypeDescForCombinationChart(this,k):buildTypeDescriptionFromSeries(this,j,k):getTypeDescForEmptyChart(this,k)};var InfoRegionsComponent=function(){};InfoRegionsComponent.prototype=new AccessibilityComponent;extend$S(InfoRegionsComponent.prototype,{init:function(){var j=this.chart,E=this;this.initRegionsDefinitions(),this.addEvent(j,"aftergetTableAST",function(a){E.onDataTableCreated(a)}),this.addEvent(j,"afterViewData",function(a){E.dataTableDiv=a,setTimeout(function(){E.focusDataTable()},300)}),this.announcer=new Announcer(j,"assertive")},initRegionsDefinitions:function(){var j=this;this.screenReaderSections={before:{element:null,buildContent:function(E){var a=E.options.accessibility.screenReaderSection.beforeChartFormatter;return a?a(E):j.defaultBeforeChartFormatter(E)},insertIntoDOM:function(E,a){a.renderTo.insertBefore(E,a.renderTo.firstChild)},afterInserted:function(){typeof j.sonifyButtonId<"u"&&j.initSonifyButton(j.sonifyButtonId),typeof j.dataTableButtonId<"u"&&j.initDataTableButton(j.dataTableButtonId)}},after:{element:null,buildContent:function(E){var a=E.options.accessibility.screenReaderSection.afterChartFormatter;return a?a(E):j.defaultAfterChartFormatter()},insertIntoDOM:function(E,a){a.renderTo.insertBefore(E,a.container.nextSibling)},afterInserted:function(){j.chart.accessibility&&j.chart.accessibility.keyboardNavigation.updateExitAnchor()}}}},onChartRender:function(){var j=this;this.linkedDescriptionElement=this.getLinkedDescriptionElement(),this.setLinkedDescriptionAttrs(),Object.keys(this.screenReaderSections).forEach(function(E){j.updateScreenReaderSection(E)})},getLinkedDescriptionElement:function(){var j=this.chart.options,E=j.accessibility.linkedDescription;if(E){if(typeof E!="string")return E;var a=format$5(E,this.chart),k=doc$8.querySelectorAll(a);if(k.length===1)return k[0]}},setLinkedDescriptionAttrs:function(){var j=this.linkedDescriptionElement;j&&(j.setAttribute("aria-hidden","true"),addClass(j,"highcharts-linked-description"))},updateScreenReaderSection:function(j){var E=this.chart,a=this.screenReaderSections[j],k=a.buildContent(E),tt=a.element=a.element||this.createElement("div"),et=tt.firstChild||this.createElement("div");this.setScreenReaderSectionAttribs(tt,j),AST.setElementHTML(et,k),tt.appendChild(et),a.insertIntoDOM(tt,E),visuallyHideElement(et),unhideChartElementFromAT$1(E,et),a.afterInserted&&a.afterInserted()},setScreenReaderSectionAttribs:function(j,E){var a="accessibility.screenReaderSection."+E+"RegionLabel",k=this.chart,tt=k.langFormat(a,{chart:k,chartTitle:getChartTitle$1(k)}),et="highcharts-screen-reader-region-"+E+"-"+k.index;setElAttrs(j,{id:et,"aria-label":tt}),j.style.position="relative",k.options.accessibility.landmarkVerbosity==="all"&&tt&&j.setAttribute("role","region")},defaultBeforeChartFormatter:function(){var j=this.chart,E=j.options.accessibility.screenReaderSection.beforeChartFormat,a=this.getAxesDescription(),k=j.sonify&&j.options.sonification&&j.options.sonification.enabled,tt="highcharts-a11y-sonify-data-btn-"+j.index,et="hc-linkto-highcharts-data-table-"+j.index,rt=getAnnotationsInfoHTML(j),nt=j.langFormat("accessibility.screenReaderSection.annotations.heading",{chart:j}),ot={headingTagName:getHeadingTagNameForElement(j.renderTo),chartTitle:getChartTitle$1(j),typeDescription:this.getTypeDescriptionText(),chartSubtitle:this.getSubtitleText(),chartLongdesc:this.getLongdescText(),xAxisDescription:a.xAxis,yAxisDescription:a.yAxis,playAsSoundButton:k?this.getSonifyButtonText(tt):"",viewTableButton:j.getCSV?this.getDataTableButtonText(et):"",annotationsTitle:rt?nt:"",annotationsList:rt},st=H.i18nFormat(E,ot,j);return this.dataTableButtonId=et,this.sonifyButtonId=tt,stripEmptyHTMLTags(st)},defaultAfterChartFormatter:function(){var j=this.chart,E=j.options.accessibility.screenReaderSection.afterChartFormat,a={endOfChartMarker:this.getEndOfChartMarkerText()},k=H.i18nFormat(E,a,j);return stripEmptyHTMLTags(k)},getLinkedDescription:function(){var j=this.linkedDescriptionElement,E=j&&j.innerHTML||"";return stripHTMLTagsFromString(E)},getLongdescText:function(){var j=this.chart.options,E=j.caption,a=E&&E.text,k=this.getLinkedDescription();return j.accessibility.description||k||a||""},getTypeDescriptionText:function(){var j=this.chart;return j.types?j.options.accessibility.typeDescription||j.getTypeDescription(j.types):""},getDataTableButtonText:function(j){var E=this.chart,a=E.langFormat("accessibility.table.viewAsDataTableButtonText",{chart:E,chartTitle:getChartTitle$1(E)});return'<button id="'+j+'">'+a+"</button>"},getSonifyButtonText:function(j){var E=this.chart;if(E.options.sonification&&E.options.sonification.enabled===!1)return"";var a=E.langFormat("accessibility.sonification.playAsSoundButtonText",{chart:E,chartTitle:getChartTitle$1(E)});return'<button id="'+j+'">'+a+"</button>"},getSubtitleText:function(){var j=this.chart.options.subtitle;return stripHTMLTagsFromString(j&&j.text||"")},getEndOfChartMarkerText:function(){var j=this.chart,E=j.langFormat("accessibility.screenReaderSection.endOfChartMarker",{chart:j}),a="highcharts-end-of-chart-marker-"+j.index;return'<div id="'+a+'">'+E+"</div>"},onDataTableCreated:function(j){var E=this.chart;if(E.options.accessibility.enabled){this.viewDataTableButton&&this.viewDataTableButton.setAttribute("aria-expanded","true");var a=j.tree.attributes||{};a.tabindex=-1,a.summary=getTableSummary(E),j.tree.attributes=a}},focusDataTable:function(){var j=this.dataTableDiv,E=j&&j.getElementsByTagName("table")[0];E&&E.focus&&E.focus()},initSonifyButton:function(j){var E=this,a=this.sonifyButton=getElement(j),k=this.chart,tt=function(et){a&&(a.setAttribute("aria-hidden","true"),a.setAttribute("aria-label","")),et.preventDefault(),et.stopPropagation();var rt=k.langFormat("accessibility.sonification.playAsSoundClickAnnouncement",{chart:k});E.announcer.announce(rt),setTimeout(function(){a&&(a.removeAttribute("aria-hidden"),a.removeAttribute("aria-label")),k.sonify&&k.sonify()},1e3)};a&&k&&(setElAttrs(a,{tabindex:-1}),a.onclick=function(et){var rt=k.options.accessibility&&k.options.accessibility.screenReaderSection.onPlayAsSoundClick;(rt||tt).call(this,et,k)})},initDataTableButton:function(j){var E=this.viewDataTableButton=getElement(j),a=this.chart,k=j.replace("hc-linkto-","");E&&(setElAttrs(E,{tabindex:-1,"aria-expanded":!!getElement(k)}),E.onclick=a.options.accessibility.screenReaderSection.onViewDataTableClick||function(){a.viewData()})},getAxesDescription:function(){var j=this.chart,E=function(nt,ot){var st=j[nt];return st.length>1||st[0]&&pick$R(st[0].options.accessibility&&st[0].options.accessibility.enabled,ot)},a=!!j.types&&j.types.indexOf("map")<0,k=!!j.hasCartesianSeries,tt=E("xAxis",!j.angular&&k&&a),et=E("yAxis",k&&a),rt={};return tt&&(rt.xAxis=this.getAxisDescriptionText("xAxis")),et&&(rt.yAxis=this.getAxisDescriptionText("yAxis")),rt},getAxisDescriptionText:function(j){var E=this.chart,a=E[j];return E.langFormat("accessibility.axis."+j+"Description"+(a.length>1?"Plural":"Singular"),{chart:E,names:a.map(function(k){return getAxisDescription(k)}),ranges:a.map(function(k){return getAxisRangeDescription(k)}),numAxes:a.length})},destroy:function(){this.announcer&&this.announcer.destroy()}});var unhideChartElementFromAT=ChartUtilities.unhideChartElementFromAT,getChartTitle=ChartUtilities.getChartTitle,doc$7=H.doc,stripHTMLTags=HTMLUtilities.stripHTMLTagsFromString,extend$R=Utilities.extend,ContainerComponent=function(){};ContainerComponent.prototype=new AccessibilityComponent;extend$R(ContainerComponent.prototype,{onChartUpdate:function(){this.handleSVGTitleElement(),this.setSVGContainerLabel(),this.setGraphicContainerAttrs(),this.setRenderToAttrs(),this.makeCreditsAccessible()},handleSVGTitleElement:function(){var j=this.chart,E="highcharts-title-"+j.index,a=stripHTMLTags(j.langFormat("accessibility.svgContainerTitle",{chartTitle:getChartTitle(j)}));if(a.length){var k=this.svgTitleElement=this.svgTitleElement||doc$7.createElementNS("http://www.w3.org/2000/svg","title");k.textContent=a,k.id=E,j.renderTo.insertBefore(k,j.renderTo.firstChild)}},setSVGContainerLabel:function(){var j=this.chart,E=j.langFormat("accessibility.svgContainerLabel",{chartTitle:getChartTitle(j)});j.renderer.box&&E.length&&j.renderer.box.setAttribute("aria-label",E)},setGraphicContainerAttrs:function(){var j=this.chart,E=j.langFormat("accessibility.graphicContainerLabel",{chartTitle:getChartTitle(j)});E.length&&j.container.setAttribute("aria-label",E)},setRenderToAttrs:function(){var j=this.chart;j.options.accessibility.landmarkVerbosity!=="disabled"?j.renderTo.setAttribute("role","region"):j.renderTo.removeAttribute("role"),j.renderTo.setAttribute("aria-label",j.langFormat("accessibility.chartContainerLabel",{title:getChartTitle(j),chart:j}))},makeCreditsAccessible:function(){var j=this.chart,E=j.credits;E&&(E.textStr&&E.element.setAttribute("aria-label",j.langFormat("accessibility.credits",{creditsStr:stripHTMLTags(E.textStr)})),unhideChartElementFromAT(j,E.element))},getKeyboardNavigation:function(){var j=this.chart;return new KeyboardNavigationHandler(j,{keyCodeMap:[],validate:function(){return!0},init:function(){var E=j.accessibility;E&&E.keyboardNavigation.tabindexContainer.focus()}})},destroy:function(){this.chart.renderTo.setAttribute("aria-hidden",!0)}});var doc$6=H.doc,isMS=H.isMS,win$3=H.win,whcm={isHighContrastModeActive:function(){var j=/(Edg)/.test(win$3.navigator.userAgent);if(win$3.matchMedia&&j)return win$3.matchMedia("(-ms-high-contrast: active)").matches;if(isMS&&win$3.getComputedStyle){var E=doc$6.createElement("div"),a="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";E.style.backgroundImage="url("+a+")",doc$6.body.appendChild(E);var k=(E.currentStyle||win$3.getComputedStyle(E)).backgroundImage;return doc$6.body.removeChild(E),k==="none"}return!1},setHighContrastTheme:function(j){j.highContrastModeActive=!0;var E=j.options.accessibility.highContrastTheme;j.update(E,!1),j.series.forEach(function(a){var k=E.plotOptions[a.type]||{};a.update({color:k.color||"windowText",colors:[k.color||"windowText"],borderColor:k.borderColor||"window"}),a.points.forEach(function(tt){tt.options&&tt.options.color&&tt.update({color:k.color||"windowText",borderColor:k.borderColor||"window"},!1)})}),j.redraw()}},theme={chart:{backgroundColor:"window"},title:{style:{color:"windowText"}},subtitle:{style:{color:"windowText"}},colorAxis:{minColor:"windowText",maxColor:"windowText",stops:[]},colors:["windowText"],xAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},yAxis:{gridLineColor:"windowText",labels:{style:{color:"windowText"}},lineColor:"windowText",minorGridLineColor:"windowText",tickColor:"windowText",title:{style:{color:"windowText"}}},tooltip:{backgroundColor:"window",borderColor:"windowText",style:{color:"windowText"}},plotOptions:{series:{lineColor:"windowText",fillColor:"window",borderColor:"windowText",edgeColor:"windowText",borderWidth:1,dataLabels:{connectorColor:"windowText",color:"windowText",style:{color:"windowText",textOutline:"none"}},marker:{lineColor:"windowText",fillColor:"windowText"}},pie:{color:"window",colors:["window"],borderColor:"windowText",borderWidth:1},boxplot:{fillColor:"window"},candlestick:{lineColor:"windowText",fillColor:"window"},errorbar:{fillColor:"window"}},legend:{backgroundColor:"window",itemStyle:{color:"windowText"},itemHoverStyle:{color:"windowText"},itemHiddenStyle:{color:"#555"},title:{style:{color:"windowText"}}},credits:{style:{color:"windowText"}},labels:{style:{color:"windowText"}},drilldown:{activeAxisLabelStyle:{color:"windowText"},activeDataLabelStyle:{color:"windowText"}},navigation:{buttonOptions:{symbolStroke:"windowText",theme:{fill:"window"}}},rangeSelector:{buttonTheme:{fill:"window",stroke:"windowText",style:{color:"windowText"},states:{hover:{fill:"window",stroke:"windowText",style:{color:"windowText"}},select:{fill:"#444",stroke:"windowText",style:{color:"windowText"}}}},inputBoxBorderColor:"windowText",inputStyle:{backgroundColor:"window",color:"windowText"},labelStyle:{color:"windowText"}},navigator:{handles:{backgroundColor:"window",borderColor:"windowText"},outlineColor:"windowText",maskFill:"transparent",series:{color:"windowText",lineColor:"windowText"},xAxis:{gridLineColor:"windowText"}},scrollbar:{barBackgroundColor:"#444",barBorderColor:"windowText",buttonArrowColor:"windowText",buttonBackgroundColor:"window",buttonBorderColor:"windowText",rifleColor:"windowText",trackBackgroundColor:"window",trackBorderColor:"windowText"}},Options={accessibility:{enabled:!0,screenReaderSection:{beforeChartFormat:"<{headingTagName}>{chartTitle}</{headingTagName}><div>{typeDescription}</div><div>{chartSubtitle}</div><div>{chartLongdesc}</div><div>{playAsSoundButton}</div><div>{viewTableButton}</div><div>{xAxisDescription}</div><div>{yAxisDescription}</div><div>{annotationsTitle}{annotationsList}</div>",afterChartFormat:"{endOfChartMarker}",axisRangeDateFormat:"%Y-%m-%d %H:%M:%S"},series:{describeSingleSeries:!1,pointDescriptionEnabledThreshold:200},point:{valueDescriptionFormat:"{index}. {xDescription}{separator}{value}."},landmarkVerbosity:"all",linkedDescription:'*[data-highcharts-chart="{index}"] + .highcharts-description',keyboardNavigation:{enabled:!0,focusBorder:{enabled:!0,hideBrowserFocusOutline:!0,style:{color:palette.highlightColor80,lineWidth:2,borderRadius:3},margin:2},order:["series","zoom","rangeSelector","legend","chartMenu"],wrapAround:!0,seriesNavigation:{skipNullPoints:!0,pointNavigationEnabledThreshold:!1}},announceNewData:{enabled:!1,minAnnounceInterval:5e3,interruptUser:!1}},legend:{accessibility:{enabled:!0,keyboardNavigation:{enabled:!0}}},exporting:{accessibility:{enabled:!0}}},langOptions={accessibility:{defaultChartTitle:"Chart",chartContainerLabel:"{title}. Highcharts interactive chart.",svgContainerLabel:"Interactive chart",drillUpButton:"{buttonText}",credits:"Chart credits: {creditsStr}",thousandsSep:",",svgContainerTitle:"",graphicContainerLabel:"",screenReaderSection:{beforeRegionLabel:"Chart screen reader information, {chartTitle}.",afterRegionLabel:"",annotations:{heading:"Chart annotations summary",descriptionSinglePoint:"{annotationText}. Related to {annotationPoint}",descriptionMultiplePoints:"{annotationText}. Related to {annotationPoint}{ Also related to, #each(additionalAnnotationPoints)}",descriptionNoPoints:"{annotationText}"},endOfChartMarker:"End of interactive chart."},sonification:{playAsSoundButtonText:"Play as sound, {chartTitle}",playAsSoundClickAnnouncement:"Play"},legend:{legendLabelNoTitle:"Toggle series visibility, {chartTitle}",legendLabel:"Chart legend: {legendTitle}",legendItem:"Show {itemName}"},zoom:{mapZoomIn:"Zoom chart",mapZoomOut:"Zoom out chart",resetZoomButton:"Reset zoom"},rangeSelector:{dropdownLabel:"{rangeTitle}",minInputLabel:"Select start date.",maxInputLabel:"Select end date.",clickButtonAnnouncement:"Viewing {axisRangeDescription}"},table:{viewAsDataTableButtonText:"View as data table, {chartTitle}",tableSummary:"Table representation of chart."},announceNewData:{newDataAnnounce:"Updated data for chart {chartTitle}",newSeriesAnnounceSingle:"New data series: {seriesDesc}",newPointAnnounceSingle:"New data point: {pointDesc}",newSeriesAnnounceMultiple:"New data series in chart {chartTitle}: {seriesDesc}",newPointAnnounceMultiple:"New data point in chart {chartTitle}: {pointDesc}"},seriesTypeDescriptions:{boxplot:"Box plot charts are typically used to display groups of statistical data. Each data point in the chart can have up to 5 values: minimum, lower quartile, median, upper quartile, and maximum.",arearange:"Arearange charts are line charts displaying a range between a lower and higher value for each point.",areasplinerange:"These charts are line charts displaying a range between a lower and higher value for each point.",bubble:"Bubble charts are scatter charts where each data point also has a size value.",columnrange:"Columnrange charts are column charts displaying a range between a lower and higher value for each point.",errorbar:"Errorbar series are used to display the variability of the data.",funnel:"Funnel charts are used to display reduction of data in stages.",pyramid:"Pyramid charts consist of a single pyramid with item heights corresponding to each point value.",waterfall:"A waterfall chart is a column chart where each column contributes towards a total end value."},chartTypes:{emptyChart:"Empty chart",mapTypeDescription:"Map of {mapTitle} with {numSeries} data series.",unknownMap:"Map of unspecified region with {numSeries} data series.",combinationChart:"Combination chart with {numSeries} data series.",defaultSingle:"Chart with {numPoints} data {#plural(numPoints, points, point)}.",defaultMultiple:"Chart with {numSeries} data series.",splineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",splineMultiple:"Line chart with {numSeries} lines.",lineSingle:"Line chart with {numPoints} data {#plural(numPoints, points, point)}.",lineMultiple:"Line chart with {numSeries} lines.",columnSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",columnMultiple:"Bar chart with {numSeries} data series.",barSingle:"Bar chart with {numPoints} {#plural(numPoints, bars, bar)}.",barMultiple:"Bar chart with {numSeries} data series.",pieSingle:"Pie chart with {numPoints} {#plural(numPoints, slices, slice)}.",pieMultiple:"Pie chart with {numSeries} pies.",scatterSingle:"Scatter chart with {numPoints} {#plural(numPoints, points, point)}.",scatterMultiple:"Scatter chart with {numSeries} data series.",boxplotSingle:"Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotMultiple:"Boxplot with {numSeries} data series.",bubbleSingle:"Bubble chart with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleMultiple:"Bubble chart with {numSeries} data series."},axis:{xAxisDescriptionSingular:"The chart has 1 X axis displaying {names[0]}. {ranges[0]}",xAxisDescriptionPlural:"The chart has {numAxes} X axes displaying {#each(names, -1) }and {names[-1]}.",yAxisDescriptionSingular:"The chart has 1 Y axis displaying {names[0]}. {ranges[0]}",yAxisDescriptionPlural:"The chart has {numAxes} Y axes displaying {#each(names, -1) }and {names[-1]}.",timeRangeDays:"Range: {range} days.",timeRangeHours:"Range: {range} hours.",timeRangeMinutes:"Range: {range} minutes.",timeRangeSeconds:"Range: {range} seconds.",rangeFromTo:"Range: {rangeFrom} to {rangeTo}.",rangeCategories:"Range: {numCategories} categories."},exporting:{chartMenuLabel:"Chart menu",menuButtonLabel:"View chart menu",exportRegionLabel:"Chart menu, {chartTitle}"},series:{summary:{default:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",defaultCombination:"{name}, series {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",line:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",lineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",spline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",splineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",column:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",columnCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",bar:"{name}, bar series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bars, bar)}.",barCombination:"{name}, series {ix} of {numSeries}. Bar series with {numPoints} {#plural(numPoints, bars, bar)}.",pie:"{name}, pie {ix} of {numSeries} with {numPoints} {#plural(numPoints, slices, slice)}.",pieCombination:"{name}, series {ix} of {numSeries}. Pie with {numPoints} {#plural(numPoints, slices, slice)}.",scatter:"{name}, scatter plot {ix} of {numSeries} with {numPoints} {#plural(numPoints, points, point)}.",scatterCombination:"{name}, series {ix} of {numSeries}, scatter plot with {numPoints} {#plural(numPoints, points, point)}.",boxplot:"{name}, boxplot {ix} of {numSeries} with {numPoints} {#plural(numPoints, boxes, box)}.",boxplotCombination:"{name}, series {ix} of {numSeries}. Boxplot with {numPoints} {#plural(numPoints, boxes, box)}.",bubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",bubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}.",map:"{name}, map {ix} of {numSeries} with {numPoints} {#plural(numPoints, areas, area)}.",mapCombination:"{name}, series {ix} of {numSeries}. Map with {numPoints} {#plural(numPoints, areas, area)}.",mapline:"{name}, line {ix} of {numSeries} with {numPoints} data {#plural(numPoints, points, point)}.",maplineCombination:"{name}, series {ix} of {numSeries}. Line with {numPoints} data {#plural(numPoints, points, point)}.",mapbubble:"{name}, bubble series {ix} of {numSeries} with {numPoints} {#plural(numPoints, bubbles, bubble)}.",mapbubbleCombination:"{name}, series {ix} of {numSeries}. Bubble series with {numPoints} {#plural(numPoints, bubbles, bubble)}."},description:"{description}",xAxisDescription:"X axis, {name}",yAxisDescription:"Y axis, {name}",nullPointValue:"No value",pointAnnotationsDescription:"{Annotation: #each(annotations). }"}}},error$1=Utilities.error,pick$Q=Utilities.pick;function traverseSetOption(j,E,a){for(var k=j,tt,et=0;et<E.length-1;++et)tt=E[et],k=k[tt]=pick$Q(k[tt],{});k[E[E.length-1]]=a}function deprecateFromOptionsMap(j,E,a,k){function tt(nt,ot){return ot.reduce(function(st,lt){return st[lt]},nt)}var et=tt(j.options,E),rt=tt(j.options,a);Object.keys(k).forEach(function(nt){var ot,st=et[nt];typeof st<"u"&&(traverseSetOption(rt,k[nt],st),error$1(32,!1,j,(ot={},ot[E.join(".")+"."+nt]=a.join(".")+"."+k[nt].join("."),ot)))})}function copyDeprecatedChartOptions(j){var E=j.options.chart,a=j.options.accessibility||{};["description","typeDescription"].forEach(function(k){var tt;E[k]&&(a[k]=E[k],error$1(32,!1,j,(tt={},tt["chart."+k]="use accessibility."+k,tt)))})}function copyDeprecatedAxisOptions(j){j.axes.forEach(function(E){var a=E.options;a&&a.description&&(a.accessibility=a.accessibility||{},a.accessibility.description=a.description,error$1(32,!1,j,{"axis.description":"use axis.accessibility.description"}))})}function copyDeprecatedSeriesOptions(j){var E={description:["accessibility","description"],exposeElementToA11y:["accessibility","exposeAsGroupOnly"],pointDescriptionFormatter:["accessibility","pointDescriptionFormatter"],skipKeyboardNavigation:["accessibility","keyboardNavigation","enabled"]};j.series.forEach(function(a){Object.keys(E).forEach(function(k){var tt,et=a.options[k];typeof et<"u"&&(traverseSetOption(a.options,E[k],k==="skipKeyboardNavigation"?!et:et),error$1(32,!1,j,(tt={},tt["series."+k]="series."+E[k].join("."),tt)))})})}function copyDeprecatedTopLevelAccessibilityOptions(j){deprecateFromOptionsMap(j,["accessibility"],["accessibility"],{pointDateFormat:["point","dateFormat"],pointDateFormatter:["point","dateFormatter"],pointDescriptionFormatter:["point","descriptionFormatter"],pointDescriptionThreshold:["series","pointDescriptionEnabledThreshold"],pointNavigationThreshold:["keyboardNavigation","seriesNavigation","pointNavigationEnabledThreshold"],pointValueDecimals:["point","valueDecimals"],pointValuePrefix:["point","valuePrefix"],pointValueSuffix:["point","valueSuffix"],screenReaderSectionFormatter:["screenReaderSection","beforeChartFormatter"],describeSingleSeries:["series","describeSingleSeries"],seriesDescriptionFormatter:["series","descriptionFormatter"],onTableAnchorClick:["screenReaderSection","onViewDataTableClick"],axisRangeDateFormat:["screenReaderSection","axisRangeDateFormat"]})}function copyDeprecatedKeyboardNavigationOptions(j){deprecateFromOptionsMap(j,["accessibility","keyboardNavigation"],["accessibility","keyboardNavigation","seriesNavigation"],{skipNullPoints:["skipNullPoints"],mode:["mode"]})}function copyDeprecatedLangOptions(j){deprecateFromOptionsMap(j,["lang","accessibility"],["lang","accessibility"],{legendItem:["legend","legendItem"],legendLabel:["legend","legendLabel"],mapZoomIn:["zoom","mapZoomIn"],mapZoomOut:["zoom","mapZoomOut"],resetZoomButton:["zoom","resetZoomButton"],screenReaderRegionLabel:["screenReaderSection","beforeRegionLabel"],rangeSelectorButton:["rangeSelector","buttonText"],rangeSelectorMaxInput:["rangeSelector","maxInputLabel"],rangeSelectorMinInput:["rangeSelector","minInputLabel"],svgContainerEnd:["screenReaderSection","endOfChartMarker"],viewAsDataTable:["table","viewAsDataTableButtonText"],tableSummary:["table","tableSummary"]})}function copyDeprecatedOptions(j){copyDeprecatedChartOptions(j),copyDeprecatedAxisOptions(j),j.series&&copyDeprecatedSeriesOptions(j),copyDeprecatedTopLevelAccessibilityOptions(j),copyDeprecatedKeyboardNavigationOptions(j),copyDeprecatedLangOptions(j)}var format$4=FormatUtilities.format,pick$P=Utilities.pick;function stringTrim(j){return j.trim&&j.trim()||j.replace(/^\s+|\s+$/g,"")}function formatExtendedStatement(j,E){var a=j.indexOf("#each("),k=j.indexOf("#plural("),tt=j.indexOf("["),et=j.indexOf("]"),rt,nt;if(a>-1){var ot=j.slice(a).indexOf(")")+a,st=j.substring(0,a),lt=j.substring(ot+1),ht=j.substring(a+6,ot),ut=ht.split(","),dt=Number(ut[1]),ft=void 0;if(nt="",rt=E[ut[0]],rt){dt=isNaN(dt)?rt.length:dt,ft=dt<0?rt.length+dt:Math.min(dt,rt.length);for(var pt=0;pt<ft;++pt)nt+=st+rt[pt]+lt}return nt.length?nt:""}if(k>-1){var gt=j.slice(k).indexOf(")")+k,yt=j.substring(k+8,gt),mt=yt.split(","),xt=Number(E[mt[0]]);switch(xt){case 0:nt=pick$P(mt[4],mt[1]);break;case 1:nt=pick$P(mt[2],mt[1]);break;case 2:nt=pick$P(mt[3],mt[1]);break;default:nt=mt[1]}return nt?stringTrim(nt):""}if(tt>-1){var wt=j.substring(0,tt),Mt=Number(j.substring(tt+1,et)),At=void 0;return rt=E[wt],!isNaN(Mt)&&rt&&(Mt<0?(At=rt[rt.length+Mt],typeof At>"u"&&(At=rt[0])):(At=rt[Mt],typeof At>"u"&&(At=rt[rt.length-1]))),typeof At<"u"?At:""}return"{"+j+"}"}H.i18nFormat=function(j,E,a){var k=function(ot,st){var lt=ot.slice(st||0),ht=lt.indexOf("{"),ut=lt.indexOf("}");if(ht>-1&&ut>ht)return{statement:lt.substring(ht+1,ut),begin:st+ht+1,end:st+ut}},tt=[],et,rt,nt=0;do et=k(j,nt),rt=j.substring(nt,et&&et.begin-1),rt.length&&tt.push({value:rt,type:"constant"}),et&&tt.push({value:et.statement,type:"statement"}),nt=et?et.end+1:nt+1;while(et);return tt.forEach(function(ot){ot.type==="statement"&&(ot.value=formatExtendedStatement(ot.value,E))}),format$4(tt.reduce(function(ot,st){return ot+st.value},""),E,a)};Chart$1.prototype.langFormat=function(j,E){for(var a=j.split("."),k=this.options.lang,tt=0;tt<a.length;++tt)k=k&&k[a[tt]];return typeof k=="string"?H.i18nFormat(k,E,this):""};var addEvent$x=Utilities.addEvent,extend$Q=Utilities.extend,pick$O=Utilities.pick,svgElementBorderUpdateTriggers=["x","y","transform","width","height","r","d","stroke-width"];function addDestroyFocusBorderHook(j){if(!j.focusBorderDestroyHook){var E=j.destroy;j.destroy=function(){return j.focusBorder&&j.focusBorder.destroy&&j.focusBorder.destroy(),E.apply(j,arguments)},j.focusBorderDestroyHook=E}}function removeDestroyFocusBorderHook(j){j.focusBorderDestroyHook&&(j.destroy=j.focusBorderDestroyHook,delete j.focusBorderDestroyHook)}function addUpdateFocusBorderHooks(j){for(var E=[],a=1;a<arguments.length;a++)E[a-1]=arguments[a];j.focusBorderUpdateHooks||(j.focusBorderUpdateHooks={},svgElementBorderUpdateTriggers.forEach(function(k){var tt=k+"Setter",et=j[tt]||j._defaultSetter;j.focusBorderUpdateHooks[tt]=et,j[tt]=function(){var rt=et.apply(j,arguments);return j.addFocusBorder.apply(j,E),rt}}))}function removeUpdateFocusBorderHooks(j){j.focusBorderUpdateHooks&&(Object.keys(j.focusBorderUpdateHooks).forEach(function(E){var a=j.focusBorderUpdateHooks[E];a===j._defaultSetter?delete j[E]:j[E]=a}),delete j.focusBorderUpdateHooks)}extend$Q(SVGElement.prototype,{addFocusBorder:function(j,E){this.focusBorder&&this.removeFocusBorder();var a=this.getBBox(),k=pick$O(j,3);a.x+=this.translateX?this.translateX:0,a.y+=this.translateY?this.translateY:0;var tt=a.x-k,et=a.y-k,rt=a.width+2*k,nt=a.height+2*k;function ot(pt){var gt=0,yt=0;return pt.attr("text-anchor")==="middle"?gt=yt=.5:pt.rotation?gt=.25:yt=.75,{x:gt,y:yt}}var st=this instanceof SVGLabel;if(this.element.nodeName==="text"||st){var lt=!!this.rotation,ht=st?{x:lt?1:0,y:0}:ot(this),ut=+this.attr("x"),dt=+this.attr("y");if(isNaN(ut)||(tt=ut-a.width*ht.x-k),isNaN(dt)||(et=dt-a.height*ht.y-k),st&&lt){var ft=rt;rt=nt,nt=ft,isNaN(ut)||(tt=ut-a.height*ht.x-k),isNaN(dt)||(et=dt-a.width*ht.y-k)}}this.focusBorder=this.renderer.rect(tt,et,rt,nt,parseInt((E&&E.r||0).toString(),10)).addClass("highcharts-focus-border").attr({zIndex:99}).add(this.parentGroup),this.renderer.styledMode||this.focusBorder.attr({stroke:E&&E.stroke,"stroke-width":E&&E.strokeWidth}),addUpdateFocusBorderHooks(this,j,E),addDestroyFocusBorderHook(this)},removeFocusBorder:function(){removeUpdateFocusBorderHooks(this),removeDestroyFocusBorderHook(this),this.focusBorder&&(this.focusBorder.destroy(),delete this.focusBorder)}});Chart$1.prototype.renderFocusBorder=function(){var j=this.focusElement,E=this.options.accessibility.keyboardNavigation.focusBorder;j&&(j.removeFocusBorder(),E.enabled&&j.addFocusBorder(E.margin,{stroke:E.style.color,strokeWidth:E.style.lineWidth,r:E.style.borderRadius}))};Chart$1.prototype.setFocusToElement=function(j,E){var a=this.options.accessibility.keyboardNavigation.focusBorder,k=E||j.element;k&&k.focus&&(k.hcEvents&&k.hcEvents.focusin||addEvent$x(k,"focusin",function(){}),k.focus(),a.hideBrowserFocusOutline&&(k.style.outline="none")),this.focusElement&&this.focusElement.removeFocusBorder(),this.focusElement=j,this.renderFocusBorder()};var doc$5=H.doc,defaultOptions$5=DefaultOptions.defaultOptions,addEvent$w=Utilities.addEvent,extend$P=Utilities.extend,fireEvent$d=Utilities.fireEvent,merge$L=Utilities.merge;merge$L(!0,defaultOptions$5,Options,{accessibility:{highContrastTheme:theme},lang:langOptions});H.A11yChartUtilities=ChartUtilities;H.A11yHTMLUtilities=HTMLUtilities;H.KeyboardNavigationHandler=KeyboardNavigationHandler;H.AccessibilityComponent=AccessibilityComponent;function Accessibility(j){this.init(j)}Accessibility.prototype={init:function(j){if(this.chart=j,!doc$5.addEventListener||!j.renderer.isSVG){j.renderTo.setAttribute("aria-hidden",!0);return}copyDeprecatedOptions(j),this.initComponents(),this.keyboardNavigation=new KeyboardNavigation(j,this.components),this.update()},initComponents:function(){var j=this.chart,E=j.options.accessibility;this.components={container:new ContainerComponent,infoRegions:new InfoRegionsComponent,legend:new LegendComponent,chartMenu:new MenuComponent,rangeSelector:new RangeSelectorComponent,series:new SeriesComponent,zoom:new ZoomComponent},E.customComponents&&extend$P(this.components,E.customComponents);var a=this.components;this.getComponentOrder().forEach(function(k){a[k].initBase(j),a[k].init()})},getComponentOrder:function(){if(!this.components)return[];if(!this.components.series)return Object.keys(this.components);var j=Object.keys(this.components).filter(function(E){return E!=="series"});return["series"].concat(j)},update:function(){var j=this.components,E=this.chart,a=E.options.accessibility;fireEvent$d(E,"beforeA11yUpdate"),E.types=this.getChartTypes(),this.getComponentOrder().forEach(function(k){j[k].onChartUpdate(),fireEvent$d(E,"afterA11yComponentUpdate",{name:k,component:j[k]})}),this.keyboardNavigation.update(a.keyboardNavigation.order),!E.highContrastModeActive&&whcm.isHighContrastModeActive()&&whcm.setHighContrastTheme(E),fireEvent$d(E,"afterA11yUpdate",{accessibility:this})},destroy:function(){var j=this.chart||{},E=this.components;Object.keys(E).forEach(function(a){E[a].destroy(),E[a].destroyBase()}),this.keyboardNavigation&&this.keyboardNavigation.destroy(),j.renderTo&&j.renderTo.setAttribute("aria-hidden",!0),j.focusElement&&j.focusElement.removeFocusBorder()},getChartTypes:function(){var j={};return this.chart.series.forEach(function(E){j[E.type]=1}),Object.keys(j)}};Chart$1.prototype.updateA11yEnabled=function(){var j=this.accessibility,E=this.options.accessibility;E&&E.enabled?j?j.update():this.accessibility=j=new Accessibility(this):j?(j.destroy&&j.destroy(),delete this.accessibility):this.renderTo.setAttribute("aria-hidden",!0)};addEvent$w(Chart$1,"render",function(j){this.a11yDirty&&this.renderTo&&(delete this.a11yDirty,this.updateA11yEnabled());var E=this.accessibility;E&&E.getComponentOrder().forEach(function(a){E.components[a].onChartRender()})});addEvent$w(Chart$1,"update",function(j){var E=j.options.accessibility;E&&(E.customComponents&&(this.options.accessibility.customComponents=E.customComponents,delete E.customComponents),merge$L(!0,this.options.accessibility,E),this.accessibility&&this.accessibility.destroy&&(this.accessibility.destroy(),delete this.accessibility)),this.a11yDirty=!0});addEvent$w(Point$5,"update",function(){this.series.chart.accessibility&&(this.series.chart.a11yDirty=!0)});["addSeries","init"].forEach(function(j){addEvent$w(Chart$1,j,function(){this.a11yDirty=!0})});["update","updatedData","remove"].forEach(function(j){addEvent$w(Series$e,j,function(){this.chart.accessibility&&(this.chart.a11yDirty=!0)})});["afterDrilldown","drillupall"].forEach(function(j){addEvent$w(Chart$1,j,function(){this.accessibility&&this.accessibility.update()})});addEvent$w(Chart$1,"destroy",function(){this.accessibility&&this.accessibility.destroy()});var addEvent$v=Utilities.addEvent,fireEvent$c=Utilities.fireEvent,objectEach$c=Utilities.objectEach,pick$N=Utilities.pick,removeEvent$2=Utilities.removeEvent,eventEmitterMixin={addEvents:function(){var j=this,E=function(k){addEvent$v(k,H.isTouchDevice?"touchstart":"mousedown",function(tt){j.onMouseDown(tt)},{passive:!1})};if(E(this.graphic.element),(j.labels||[]).forEach(function(k){k.options.useHTML&&k.graphic.text&&E(k.graphic.text.element)}),objectEach$c(j.options.events,function(k,tt){var et=function(rt){(tt!=="click"||!j.cancelClick)&&k.call(j,j.chart.pointer.normalize(rt),j.target)};(j.nonDOMEvents||[]).indexOf(tt)===-1?j.graphic.on(tt,et):addEvent$v(j,tt,et,{passive:!1})}),j.options.draggable&&(addEvent$v(j,"drag",j.onDrag),!j.graphic.renderer.styledMode)){var a={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[j.options.draggable]};j.graphic.css(a),(j.labels||[]).forEach(function(k){k.options.useHTML&&k.graphic.text&&k.graphic.text.css(a)})}j.isUpdating||fireEvent$c(j,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag()),this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(j){var E=this,a=E.chart.pointer,k,tt;j.preventDefault&&j.preventDefault(),j.button!==2&&(j=a.normalize(j),k=j.chartX,tt=j.chartY,E.cancelClick=!1,E.chart.hasDraggedAnnotation=!0,E.removeDrag=addEvent$v(H.doc,H.isTouchDevice?"touchmove":"mousemove",function(et){E.hasDragged=!0,et=a.normalize(et),et.prevChartX=k,et.prevChartY=tt,fireEvent$c(E,"drag",et),k=et.chartX,tt=et.chartY},H.isTouchDevice?{passive:!1}:void 0),E.removeMouseUp=addEvent$v(H.doc,H.isTouchDevice?"touchend":"mouseup",function(et){var rt=pick$N(E.target&&E.target.annotation,E.target);rt&&(rt.cancelClick=E.hasDragged),E.cancelClick=E.hasDragged,E.hasDragged=!1,E.chart.hasDraggedAnnotation=!1,fireEvent$c(pick$N(rt,E),"afterUpdate"),E.onMouseUp(et)},H.isTouchDevice?{passive:!1}:void 0))},onMouseUp:function(j){var E=this.chart,a=this.target||this,k=E.options.annotations,tt=E.annotations.indexOf(a);this.removeDocEvents(),k[tt]=a.options},onDrag:function(j){if(this.chart.isInsidePlot(j.chartX-this.chart.plotLeft,j.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var E=this.mouseMoveToTranslation(j);this.options.draggable==="x"&&(E.y=0),this.options.draggable==="y"&&(E.x=0),this.points.length?this.translate(E.x,E.y):(this.shapes.forEach(function(a){a.translate(E.x,E.y)}),this.labels.forEach(function(a){a.translate(E.x,E.y)})),this.redraw(!1)}},mouseMoveToRadians:function(j,E,a){var k=j.prevChartY-a,tt=j.prevChartX-E,et=j.chartY-a,rt=j.chartX-E,nt;return this.chart.inverted&&(nt=tt,tt=k,k=nt,nt=rt,rt=et,et=nt),Math.atan2(et,rt)-Math.atan2(k,tt)},mouseMoveToTranslation:function(j){var E=j.chartX-j.prevChartX,a=j.chartY-j.prevChartY,k;return this.chart.inverted&&(k=a,a=E,E=k),{x:E,y:a}},mouseMoveToScale:function(j,E,a){var k=j.prevChartX-E,tt=j.prevChartY-a,et=j.chartX-E,rt=j.chartY-a,nt=(et||1)/(k||1),ot=(rt||1)/(tt||1),st;return this.chart.inverted&&(st=ot,ot=nt,nt=st),{x:nt,y:ot}},destroy:function(){this.removeDocEvents(),removeEvent$2(this),this.hcEvents=null}},merge$K=Utilities.merge,pick$M=Utilities.pick,ControlPoint=function(){function j(E,a,k,tt){this.addEvents=eventEmitterMixin.addEvents,this.graphic=void 0,this.mouseMoveToRadians=eventEmitterMixin.mouseMoveToRadians,this.mouseMoveToScale=eventEmitterMixin.mouseMoveToScale,this.mouseMoveToTranslation=eventEmitterMixin.mouseMoveToTranslation,this.onDrag=eventEmitterMixin.onDrag,this.onMouseDown=eventEmitterMixin.onMouseDown,this.onMouseUp=eventEmitterMixin.onMouseUp,this.removeDocEvents=eventEmitterMixin.removeDocEvents,this.nonDOMEvents=["drag"],this.chart=E,this.target=a,this.options=k,this.index=pick$M(k.index,tt)}return j.prototype.setVisibility=function(E){this.graphic.attr("visibility",E?"visible":"hidden"),this.options.visible=E},j.prototype.render=function(){var E=this.chart,a=this.options;this.graphic=E.renderer.symbol(a.symbol,0,0,a.width,a.height).add(E.controlPointsGroup).css(a.style),this.setVisibility(a.visible),this.addEvents()},j.prototype.redraw=function(E){this.graphic[E?"animate":"attr"](this.options.positioner.call(this,this.target))},j.prototype.destroy=function(){eventEmitterMixin.destroy.call(this),this.graphic&&(this.graphic=this.graphic.destroy()),this.chart=null,this.target=null,this.options=null},j.prototype.update=function(E){var a=this.chart,k=this.target,tt=this.index,et=merge$K(!0,this.options,E);this.destroy(),this.constructor(a,k,et,tt),this.render(a.controlPointsGroup),this.redraw()},j}(),defined$l=Utilities.defined,fireEvent$b=Utilities.fireEvent,MockPoint=function(){function j(E,a,k){this.isInside=void 0,this.negative=void 0,this.plotX=void 0,this.plotY=void 0,this.ttBelow=void 0,this.x=void 0,this.y=void 0,this.mock=!0,this.series={visible:!0,chart:E,getPlotBox:Series$e.prototype.getPlotBox},this.target=a||null,this.options=k,this.applyOptions(this.getOptions())}return j.fromPoint=function(E){return new j(E.series.chart,null,{x:E.x,y:E.y,xAxis:E.series.xAxis,yAxis:E.series.yAxis})},j.pointToPixels=function(E,a){var k=E.series,tt=k.chart,et=E.plotX,rt=E.plotY,nt;return tt.inverted&&(E.mock?(et=E.plotY,rt=E.plotX):(et=tt.plotWidth-E.plotY,rt=tt.plotHeight-E.plotX)),k&&!a&&(nt=k.getPlotBox(),et+=nt.translateX,rt+=nt.translateY),{x:et,y:rt}},j.pointToOptions=function(E){return{x:E.x,y:E.y,xAxis:E.series.xAxis,yAxis:E.series.yAxis}},j.prototype.hasDynamicOptions=function(){return typeof this.options=="function"},j.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options},j.prototype.applyOptions=function(E){this.command=E.command,this.setAxis(E,"x"),this.setAxis(E,"y"),this.refresh()},j.prototype.setAxis=function(E,a){var k=a+"Axis",tt=E[k],et=this.series.chart;this.series[k]=tt instanceof Axis?tt:defined$l(tt)?et[k][tt]||et.get(tt):null},j.prototype.toAnchor=function(){var E=[this.plotX,this.plotY,0,0];return this.series.chart.inverted&&(E[0]=this.plotY,E[1]=this.plotX),E},j.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}},j.prototype.isInsidePlot=function(){var E=this.plotX,a=this.plotY,k=this.series.xAxis,tt=this.series.yAxis,et={x:E,y:a,isInsidePlot:!0};return k&&(et.isInsidePlot=defined$l(E)&&E>=0&&E<=k.len),tt&&(et.isInsidePlot=et.isInsidePlot&&defined$l(a)&&a>=0&&a<=tt.len),fireEvent$b(this.series.chart,"afterIsInsidePlot",et),et.isInsidePlot},j.prototype.refresh=function(){var E=this.series,a=E.xAxis,k=E.yAxis,tt=this.getOptions();a?(this.x=tt.x,this.plotX=a.toPixels(tt.x,!0)):(this.x=null,this.plotX=tt.x),k?(this.y=tt.y,this.plotY=k.toPixels(tt.y,!0)):(this.y=null,this.plotY=tt.y),this.isInside=this.isInsidePlot()},j.prototype.translate=function(E,a,k,tt){this.hasDynamicOptions()||(this.plotX+=k,this.plotY+=tt,this.refreshOptions())},j.prototype.scale=function(E,a,k,tt){if(!this.hasDynamicOptions()){var et=this.plotX*k,rt=this.plotY*tt,nt=(1-k)*E,ot=(1-tt)*a;this.plotX=nt+et,this.plotY=ot+rt,this.refreshOptions()}},j.prototype.rotate=function(E,a,k){if(!this.hasDynamicOptions()){var tt=Math.cos(k),et=Math.sin(k),rt=this.plotX,nt=this.plotY,ot=void 0,st=void 0;rt-=E,nt-=a,ot=rt*tt-nt*et,st=rt*et+nt*tt,this.plotX=ot+E,this.plotY=st+a,this.refreshOptions()}},j.prototype.refreshOptions=function(){var E=this.series,a=E.xAxis,k=E.yAxis;this.x=this.options.x=a?this.options.x=a.toValue(this.plotX,!0):this.plotX,this.y=this.options.y=k?k.toValue(this.plotY,!0):this.plotY},j}(),isObject$7=Utilities.isObject,isString$2=Utilities.isString,merge$J=Utilities.merge,splat$6=Utilities.splat,controllableMixin={init:function(j,E,a){this.annotation=j,this.chart=j.chart,this.options=E,this.points=[],this.controlPoints=[],this.index=a,this.linkPoints(),this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var j=this.options;return j.points||j.point&&splat$6(j.point)},attrsFromOptions:function(j){var E=this.constructor.attrsMap,a={},k,tt,et=this.chart.styledMode;for(k in j)tt=E[k],tt&&(!et||["fill","stroke","stroke-width"].indexOf(tt)===-1)&&(a[tt]=j[k]);return a},anchor:function(j){var E=j.series.getPlotBox(),a=j.series.chart,k=j.mock?j.toAnchor():Tooltip.prototype.getAnchor.call({chart:j.series.chart},j),tt={x:k[0]+(this.options.x||0),y:k[1]+(this.options.y||0),height:k[2]||0,width:k[3]||0};return{relativePosition:tt,absolutePosition:merge$J(tt,{x:tt.x+(j.mock?E.translateX:a.plotLeft),y:tt.y+(j.mock?E.translateY:a.plotTop)})}},point:function(j,E){if(j&&j.series)return j;if(!E||E.series===null){if(isObject$7(j))E=new MockPoint(this.chart,this,j);else if(isString$2(j))E=this.chart.get(j)||null;else if(typeof j=="function"){var a=j.call(E,this);E=a.series?a:new MockPoint(this.chart,this,j)}}return E},linkPoints:function(){var j=this.getPointsOptions(),E=this.points,a=j&&j.length||0,k,tt;for(k=0;k<a;k++){if(tt=this.point(j[k],E[k]),!tt){E.length=0;return}tt.mock&&tt.refresh(),E[k]=tt}return E},addControlPoints:function(){var j=this.options.controlPoints;(j||[]).forEach(function(E,a){var k=merge$J(this.options.controlPointOptions,E);k.index||(k.index=a),j[a]=k,this.controlPoints.push(new ControlPoint(this.chart,this,k))},this)},shouldBeDrawn:function(){return Boolean(this.points.length)},render:function(j){this.controlPoints.forEach(function(E){E.render()})},redraw:function(j){this.controlPoints.forEach(function(E){E.redraw(j)})},transform:function(j,E,a,k,tt){if(this.chart.inverted){var et=E;E=a,a=et}this.points.forEach(function(rt,nt){this.transformPoint(j,E,a,k,tt,nt)},this)},transformPoint:function(j,E,a,k,tt,et){var rt=this.points[et];rt.mock||(rt=this.points[et]=MockPoint.fromPoint(rt)),rt[j](E,a,k,tt)},translate:function(j,E){this.transform("translate",null,null,j,E)},translatePoint:function(j,E,a){this.transformPoint("translate",null,null,j,E,a)},translateShape:function(j,E){var a=this.annotation.chart,k=this.annotation.userOptions,tt=a.annotations.indexOf(this.annotation),et=a.options.annotations[tt];this.translatePoint(j,E,0),et[this.collection][this.index].point=this.options.point,k[this.collection][this.index].point=this.options.point},rotate:function(j,E,a){this.transform("rotate",j,E,a)},scale:function(j,E,a,k){this.transform("scale",j,E,a,k)},setControlPointsVisibility:function(j){this.controlPoints.forEach(function(E){E.setVisibility(j)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy()),this.tracker&&(this.tracker=this.tracker.destroy()),this.controlPoints.forEach(function(j){j.destroy()}),this.chart=null,this.points=null,this.controlPoints=null,this.options=null,this.annotation&&(this.annotation=null)},update:function(j){var E=this.annotation,a=merge$J(!0,this.options,j),k=this.graphic.parentGroup;this.destroy(),this.constructor(E,a,this.index),this.render(k),this.redraw()}},addEvent$u=Utilities.addEvent,defined$k=Utilities.defined,merge$I=Utilities.merge,uniqueKey$2=Utilities.uniqueKey,defaultMarkers={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};SVGRenderer.prototype.addMarker=function(j,E){var a={attributes:{id:j}},k={stroke:E.color||"none",fill:E.color||"rgba(0, 0, 0, 0.75)"};a.children=E.children&&E.children.map(function(rt){return merge$I(k,rt)});var tt=merge$I(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},E,a),et=this.definition(tt);return et.id=j,et};function createMarkerSetter(j){return function(E){this.attr(j,"url(#"+E+")")}}var markerMixin={markerEndSetter:createMarkerSetter("marker-end"),markerStartSetter:createMarkerSetter("marker-start"),setItemMarkers:function(j){var E=j.options,a=j.chart,k=a.options.defs,tt=E.fill,et=defined$k(tt)&&tt!=="none"?tt:E.stroke,rt=function(nt){var ot=E[nt],st,lt,ht,ut;if(ot){for(ht in k)if(st=k[ht],(ot===(st.attributes&&st.attributes.id)||ot===st.id)&&st.tagName==="marker"){lt=st;break}lt&&(ut=j[nt]=a.renderer.addMarker((E.id||uniqueKey$2())+"-"+ot,merge$I(lt,{color:et})),j.attr(nt,ut.getAttribute("id")))}};["markerStart","markerEnd"].forEach(rt)}};addEvent$u(Chart$1,"afterGetContainer",function(){this.options.defs=merge$I(defaultMarkers,this.options.defs||{})});var extend$O=Utilities.extend,TRACKER_FILL="rgba(192,192,192,"+(H.svg?1e-4:.002)+")",ControllablePath=function(){function j(E,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.setMarkers=markerMixin.setItemMarkers,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translate=controllableMixin.translate,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="path",this.init(E,a,k),this.collection="shapes"}return j.prototype.toD=function(){var E=this.options.d;if(E)return typeof E=="function"?E.call(this):E;var a=this.points,k=a.length,tt=k,et=a[0],rt=tt&&this.anchor(et).absolutePosition,nt=0,ot,st=[];if(rt)for(st.push(["M",rt.x,rt.y]);++nt<k&&tt;)et=a[nt],ot=et.command||"L",rt=this.anchor(et).absolutePosition,ot==="M"?st.push([ot,rt.x,rt.y]):ot==="L"?st.push([ot,rt.x,rt.y]):ot==="Z"&&st.push([ot]),tt=et.series.visible;return tt?this.chart.renderer.crispLine(st,this.graphic.strokeWidth()):null},j.prototype.shouldBeDrawn=function(){return controllableMixin.shouldBeDrawn.call(this)||Boolean(this.options.d)},j.prototype.render=function(E){var a=this.options,k=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(k).add(E),a.className&&this.graphic.addClass(a.className),this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(E),this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:TRACKER_FILL,fill:TRACKER_FILL,"stroke-width":this.graphic.strokeWidth()+a.snap*2}),controllableMixin.render.call(this),extend$O(this.graphic,{markerStartSetter:markerMixin.markerStartSetter,markerEndSetter:markerMixin.markerEndSetter}),this.setMarkers(this)},j.prototype.redraw=function(E){var a=this.toD(),k=E?"animate":"attr";a?(this.graphic[k]({d:a}),this.tracker[k]({d:a})):(this.graphic.attr({d:"M 0 "+-9e9}),this.tracker.attr({d:"M 0 "+-9e9})),this.graphic.placed=this.tracker.placed=Boolean(a),controllableMixin.redraw.call(this,E)},j.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"},j}(),merge$H=Utilities.merge,ControllableRect=function(){function j(E,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="rect",this.translate=controllableMixin.translateShape,this.init(E,a,k),this.collection="shapes"}return j.prototype.render=function(E){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9e9,0,0).attr(a).add(E),controllableMixin.render.call(this)},j.prototype.redraw=function(E){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[E?"animate":"attr"]({x:a.x,y:a.y,width:this.options.width,height:this.options.height}):this.attr({x:0,y:-9e9}),this.graphic.placed=Boolean(a),controllableMixin.redraw.call(this,E)},j.attrsMap=merge$H(ControllablePath.attrsMap,{width:"width",height:"height"}),j}(),merge$G=Utilities.merge,ControllableCircle=function(){function j(E,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="circle",this.translate=controllableMixin.translateShape,this.init(E,a,k),this.collection="shapes"}return j.prototype.render=function(E){var a=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9e9,0).attr(a).add(E),controllableMixin.render.call(this)},j.prototype.redraw=function(E){var a=this.anchor(this.points[0]).absolutePosition;a?this.graphic[E?"animate":"attr"]({x:a.x,y:a.y,r:this.options.r}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=Boolean(a),controllableMixin.redraw.call(this,E)},j.prototype.setRadius=function(E){this.options.r=E},j.attrsMap=merge$G(ControllablePath.attrsMap,{r:"r"}),j}(),format$3=FormatUtilities.format,symbols$2=SVGRenderer.prototype.symbols,extend$N=Utilities.extend,isNumber$k=Utilities.isNumber,pick$L=Utilities.pick,ControllableLabel=function(){function j(E,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.init(E,a,k),this.collection="labels"}return j.alignedPosition=function(E,a){var k=E.align,tt=E.verticalAlign,et=(a.x||0)+(E.x||0),rt=(a.y||0)+(E.y||0),nt,ot;return k==="right"?nt=1:k==="center"&&(nt=2),nt&&(et+=(a.width-(E.width||0))/nt),tt==="bottom"?ot=1:tt==="middle"&&(ot=2),ot&&(rt+=(a.height-(E.height||0))/ot),{x:Math.round(et),y:Math.round(rt)}},j.justifiedOptions=function(E,a,k,tt){var et=k.align,rt=k.verticalAlign,nt=a.box?0:a.padding||0,ot=a.getBBox(),st={align:et,verticalAlign:rt,x:k.x,y:k.y,width:a.width,height:a.height},lt=(tt.x||0)-E.plotLeft,ht=(tt.y||0)-E.plotTop,ut;return ut=lt+nt,ut<0&&(et==="right"?st.align="left":st.x=(st.x||0)-ut),ut=lt+ot.width-nt,ut>E.plotWidth&&(et==="left"?st.align="right":st.x=(st.x||0)+E.plotWidth-ut),ut=ht+nt,ut<0&&(rt==="bottom"?st.verticalAlign="top":st.y=(st.y||0)-ut),ut=ht+ot.height-nt,ut>E.plotHeight&&(rt==="top"?st.verticalAlign="bottom":st.y=(st.y||0)+E.plotHeight-ut),st},j.prototype.translatePoint=function(E,a){controllableMixin.translatePoint.call(this,E,a,0)},j.prototype.translate=function(E,a){var k=this.annotation.chart,tt=this.annotation.userOptions,et=k.annotations.indexOf(this.annotation),rt=k.options.annotations,nt=rt[et];if(k.inverted){var ot=E;E=a,a=ot}this.options.x+=E,this.options.y+=a,nt[this.collection][this.index].x=this.options.x,nt[this.collection][this.index].y=this.options.y,tt[this.collection][this.index].x=this.options.x,tt[this.collection][this.index].y=this.options.y},j.prototype.render=function(E){var a=this.options,k=this.attrsFromOptions(a),tt=a.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,a.shape,null,null,a.useHTML,null,"annotation-label").attr(k).add(E),this.annotation.chart.styledMode||(tt.color==="contrast"&&(tt.color=this.annotation.chart.renderer.getContrast(j.shapesWithoutBackground.indexOf(a.shape)>-1?"#FFFFFF":a.backgroundColor)),this.graphic.css(a.style).shadow(a.shadow)),a.className&&this.graphic.addClass(a.className),this.graphic.labelrank=a.labelrank,controllableMixin.render.call(this)},j.prototype.redraw=function(E){var a=this.options,k=this.text||a.format||a.text,tt=this.graphic,et=this.points[0];tt.attr({text:k?format$3(k,et.getLabelConfig(),this.annotation.chart):a.formatter.call(et,this)});var rt=this.anchor(et),nt=this.position(rt);nt?(tt.alignAttr=nt,nt.anchorX=rt.absolutePosition.x,nt.anchorY=rt.absolutePosition.y,tt[E?"animate":"attr"](nt)):tt.attr({x:0,y:-9999}),tt.placed=!!nt,controllableMixin.redraw.call(this,E)},j.prototype.anchor=function(E){var a=controllableMixin.anchor.apply(this,arguments),k=this.options.x||0,tt=this.options.y||0;return a.absolutePosition.x-=k,a.absolutePosition.y-=tt,a.relativePosition.x-=k,a.relativePosition.y-=tt,a},j.prototype.position=function(E){var a=this.graphic,k=this.annotation.chart,tt=this.points[0],et=this.options,rt=E.absolutePosition,nt=E.relativePosition,ot,st,lt,ht,ut=tt.series.visible&&MockPoint.prototype.isInsidePlot.call(tt),dt=a.width,ft=dt===void 0?0:dt,pt=a.height,gt=pt===void 0?0:pt;return ut&&(et.distance?ot=Tooltip.prototype.getPosition.call({chart:k,distance:pick$L(et.distance,16)},ft,gt,{plotX:nt.x,plotY:nt.y,negative:tt.negative,ttBelow:tt.ttBelow,h:nt.height||nt.width}):et.positioner?ot=et.positioner.call(this):(st={x:rt.x,y:rt.y,width:0,height:0},ot=j.alignedPosition(extend$N(et,{width:ft,height:gt}),st),this.options.overflow==="justify"&&(ot=j.alignedPosition(j.justifiedOptions(k,a,et,ot),st))),et.crop&&(lt=ot.x-k.plotLeft,ht=ot.y-k.plotTop,ut=k.isInsidePlot(lt,ht)&&k.isInsidePlot(lt+ft,ht+gt))),ut?ot:null},j.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"},j.shapesWithoutBackground=["connector"],j}();symbols$2.connector=function(j,E,a,k,tt){var et=tt&&tt.anchorX,rt=tt&&tt.anchorY,nt,ot,st=a/2;return isNumber$k(et)&&isNumber$k(rt)&&(nt=[["M",et,rt]],ot=E-rt,ot<0&&(ot=-k-ot),ot<a&&(st=et<j+a/2?ot:a-ot),rt>E+k?nt.push(["L",j+st,E+k]):rt<E?nt.push(["L",j+st,E]):et<j?nt.push(["L",j,E+k/2]):et>j+a&&nt.push(["L",j+a,E+k/2])),nt||[]};var ControllableImage=function(){function j(E,a,k){this.addControlPoints=controllableMixin.addControlPoints,this.anchor=controllableMixin.anchor,this.attr=controllableMixin.attr,this.attrsFromOptions=controllableMixin.attrsFromOptions,this.destroy=controllableMixin.destroy,this.getPointsOptions=controllableMixin.getPointsOptions,this.init=controllableMixin.init,this.linkPoints=controllableMixin.linkPoints,this.point=controllableMixin.point,this.rotate=controllableMixin.rotate,this.scale=controllableMixin.scale,this.setControlPointsVisibility=controllableMixin.setControlPointsVisibility,this.shouldBeDrawn=controllableMixin.shouldBeDrawn,this.transform=controllableMixin.transform,this.transformPoint=controllableMixin.transformPoint,this.translatePoint=controllableMixin.translatePoint,this.translateShape=controllableMixin.translateShape,this.update=controllableMixin.update,this.type="image",this.translate=controllableMixin.translateShape,this.init(E,a,k),this.collection="shapes"}return j.prototype.render=function(E){var a=this.attrsFromOptions(this.options),k=this.options;this.graphic=this.annotation.chart.renderer.image(k.src,0,-9e9,k.width,k.height).attr(a).add(E),this.graphic.width=k.width,this.graphic.height=k.height,controllableMixin.render.call(this)},j.prototype.redraw=function(E){var a=this.anchor(this.points[0]),k=ControllableLabel.prototype.position.call(this,a);k?this.graphic[E?"animate":"attr"]({x:k.x,y:k.y}):this.graphic.attr({x:0,y:-9e9}),this.graphic.placed=Boolean(k),controllableMixin.redraw.call(this,E)},j.attrsMap={width:"width",height:"height",zIndex:"zIndex"},j}(),getDeferredAnimation=animationExports.getDeferredAnimation,chartProto=Chart$1.prototype,addEvent$t=Utilities.addEvent,defined$j=Utilities.defined,destroyObjectProperties=Utilities.destroyObjectProperties,erase=Utilities.erase,extend$M=Utilities.extend,find$5=Utilities.find,fireEvent$a=Utilities.fireEvent,merge$F=Utilities.merge,pick$K=Utilities.pick,splat$5=Utilities.splat,wrap$a=Utilities.wrap,Annotation=function(){function j(E,a){this.annotation=void 0,this.coll="annotations",this.collection=void 0,this.animationConfig=void 0,this.graphic=void 0,this.group=void 0,this.labelCollector=void 0,this.labelsGroup=void 0,this.shapesGroup=void 0;var k;this.chart=E,this.points=[],this.controlPoints=[],this.coll="annotations",this.labels=[],this.shapes=[],this.options=merge$F(this.defaultOptions,a),this.userOptions=a,k=this.getLabelsAndShapesOptions(this.options,a),this.options.labels=k.labels,this.options.shapes=k.shapes,this.init(E,this.options)}return j.prototype.init=function(){var E=this.chart,a=this.options.animation;this.linkPoints(),this.addControlPoints(),this.addShapes(),this.addLabels(),this.setLabelCollector(),this.animationConfig=getDeferredAnimation(E,a)},j.prototype.getLabelsAndShapesOptions=function(E,a){var k={};return["labels","shapes"].forEach(function(tt){E[tt]&&(a[tt]?k[tt]=splat$5(a[tt]).map(function(et,rt){return merge$F(E[tt][rt],et)}):k[tt]=E[tt])}),k},j.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(E,a){var k=this.initShape(E,a);merge$F(!0,this.options.shapes[a],k.options)},this)},j.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(E,a){var k=this.initLabel(E,a);merge$F(!0,this.options.labels[a],k.options)},this)},j.prototype.addClipPaths=function(){this.setClipAxes(),this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},j.prototype.setClipAxes=function(){var E=this.chart.xAxis,a=this.chart.yAxis,k=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(tt,et){var rt=et&&(et.point||et.points&&et.points[0]);return[E[rt&&rt.xAxis]||tt[0],a[rt&&rt.yAxis]||tt[1]]},[]);this.clipXAxis=k[0],this.clipYAxis=k[1]},j.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},j.prototype.setLabelCollector=function(){var E=this;E.labelCollector=function(){return E.labels.reduce(function(a,k){return k.options.allowOverlap||a.push(k.graphic),a},[])},E.chart.labelCollectors.push(E.labelCollector)},j.prototype.setOptions=function(E){this.options=merge$F(this.defaultOptions,E)},j.prototype.redraw=function(E){this.linkPoints(),this.graphic||this.render(),this.clipRect&&this.clipRect.animate(this.getClipBox()),this.redrawItems(this.shapes,E),this.redrawItems(this.labels,E),controllableMixin.redraw.call(this,E)},j.prototype.redrawItems=function(E,a){for(var k=E.length;k--;)this.redrawItem(E[k],a)},j.prototype.renderItems=function(E){for(var a=E.length;a--;)this.renderItem(E[a])},j.prototype.render=function(){var E=this.chart.renderer;this.graphic=E.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add(),this.shapesGroup=E.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip),this.labelsGroup=E.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic),this.addClipPaths(),this.clipRect&&this.graphic.clip(this.clipRect),this.renderItems(this.shapes),this.renderItems(this.labels),this.addEvents(),controllableMixin.render.call(this)},j.prototype.setVisibility=function(E){var a=this.options,k=this.chart.navigationBindings,tt=pick$K(E,!a.visible);this.graphic.attr("visibility",tt?"visible":"hidden"),tt||(this.setControlPointsVisibility(!1),k.activeAnnotation===this&&k.popup&&k.popup.formType==="annotation-toolbar"&&fireEvent$a(k,"closePopup")),a.visible=tt},j.prototype.setControlPointsVisibility=function(E){var a=function(k){k.setControlPointsVisibility(E)};controllableMixin.setControlPointsVisibility.call(this,E),this.shapes.forEach(a),this.labels.forEach(a)},j.prototype.destroy=function(){var E=this.chart,a=function(k){k.destroy()};this.labels.forEach(a),this.shapes.forEach(a),this.clipXAxis=null,this.clipYAxis=null,erase(E.labelCollectors,this.labelCollector),eventEmitterMixin.destroy.call(this),controllableMixin.destroy.call(this),destroyObjectProperties(this,E)},j.prototype.remove=function(){return this.chart.removeAnnotation(this)},j.prototype.update=function(E,a){var k=this.chart,tt=this.getLabelsAndShapesOptions(this.userOptions,E),et=k.annotations.indexOf(this),rt=merge$F(!0,this.userOptions,E);rt.labels=tt.labels,rt.shapes=tt.shapes,this.destroy(),this.constructor(k,rt),k.options.annotations[et]=rt,this.isUpdating=!0,pick$K(a,!0)&&k.redraw(),fireEvent$a(this,"afterUpdate"),this.isUpdating=!1},j.prototype.initShape=function(E,a){var k=merge$F(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},E),tt=new j.shapesMap[k.type](this,k,a);return tt.itemType="shape",this.shapes.push(tt),tt},j.prototype.initLabel=function(E,a){var k=merge$F(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},E),tt=new ControllableLabel(this,k,a);return tt.itemType="label",this.labels.push(tt),tt},j.prototype.redrawItem=function(E,a){E.linkPoints(),E.shouldBeDrawn()?(E.graphic||this.renderItem(E),E.redraw(pick$K(a,!0)&&E.graphic.placed),E.points.length&&this.adjustVisibility(E)):this.destroyItem(E)},j.prototype.adjustVisibility=function(E){var a=!1,k=E.graphic;E.points.forEach(function(tt){tt.series.visible!==!1&&tt.visible!==!1&&(a=!0)}),a?k.visibility==="hidden"&&k.show():k.hide()},j.prototype.destroyItem=function(E){erase(this[E.itemType+"s"],E),E.destroy()},j.prototype.renderItem=function(E){E.render(E.itemType==="label"?this.labelsGroup:this.shapesGroup)},j.ControlPoint=ControlPoint,j.MockPoint=MockPoint,j.shapesMap={rect:ControllableRect,circle:ControllableCircle,path:ControllablePath,image:ControllableImage},j.types={},j}();merge$F(!0,Annotation.prototype,controllableMixin,eventEmitterMixin,merge$F(Annotation.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:palette.neutralColor100,borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return defined$j(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:palette.neutralColor100,"stroke-width":2,fill:palette.backgroundColor},visible:!1,events:{}},events:{},zIndex:6}}));H.extendAnnotation=function(j,E,a,k){E=E||Annotation,extend$M(j.prototype,merge$F(E.prototype,a)),j.prototype.defaultOptions=merge$F(j.prototype.defaultOptions,k||{})};extend$M(chartProto,{initAnnotation:function(j){var E=Annotation.types[j.type]||Annotation,a=new E(this,j);return this.annotations.push(a),a},addAnnotation:function(j,E){var a=this.initAnnotation(j);return this.options.annotations.push(a.options),pick$K(E,!0)&&(a.redraw(),a.graphic.attr({opacity:1})),a},removeAnnotation:function(j){var E=this.annotations,a=j.coll==="annotations"?j:find$5(E,function(k){return k.options.id===j});a&&(fireEvent$a(a,"remove"),erase(this.options.annotations,a.options),erase(E,a),a.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox),this.annotations.forEach(function(j){j.redraw(),j.graphic.animate({opacity:1},j.animationConfig)})}});chartProto.collectionsWithUpdate.push("annotations");chartProto.collectionsWithInit.annotations=[chartProto.addAnnotation];addEvent$t(Chart$1,"afterInit",function(){this.annotations=[],this.options.annotations||(this.options.annotations=[])});chartProto.callbacks.push(function(j){j.plotBoxClip=this.renderer.clipRect(this.plotBox),j.controlPointsGroup=j.renderer.g("control-points").attr({zIndex:99}).clip(j.plotBoxClip).add(),j.options.annotations.forEach(function(E,a){if(!j.annotations.some(function(tt){return tt.options===E})){var k=j.initAnnotation(E);j.options.annotations[a]=k.options}}),j.drawAnnotations(),addEvent$t(j,"redraw",j.drawAnnotations),addEvent$t(j,"destroy",function(){j.plotBoxClip.destroy(),j.controlPointsGroup.destroy()}),addEvent$t(j,"exportData",function(E){var a=j.annotations,k=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,tt=!E.dataRows[1].xValues,et=j.options.lang&&j.options.lang.exportData&&j.options.lang.exportData.annotationHeader,rt=function(ft){var pt;return k&&(pt=k(ft),pt!==!1)?pt:(pt=et+" "+ft,tt?{columnTitle:pt,topLevelColumnTitle:pt}:pt)},nt=E.dataRows[0].length,ot=j.options.exporting&&j.options.exporting.csv&&j.options.exporting.csv.annotations&&j.options.exporting.csv.annotations.itemDelimiter,st=j.options.exporting&&j.options.exporting.csv&&j.options.exporting.csv.annotations&&j.options.exporting.csv.annotations.join;a.forEach(function(ft){ft.options.labelOptions.includeInDataExport&&ft.labels.forEach(function(pt){if(pt.options.text){var gt=pt.options.text;pt.points.forEach(function(yt){var mt=yt.x,xt=yt.series.xAxis?yt.series.xAxis.options.index:-1,wt=!1;if(xt===-1){for(var Mt=E.dataRows[0].length,At=new Array(Mt),St=0;St<Mt;++St)At[St]="";At.push(gt),At.xValues=[],At.xValues[xt]=mt,E.dataRows.push(At),wt=!0}if(wt||E.dataRows.forEach(function($t,Tt){!wt&&$t.xValues&&xt!==void 0&&mt===$t.xValues[xt]&&(st&&$t.length>nt?$t[$t.length-1]+=ot+gt:$t.push(gt),wt=!0)}),!wt){for(var Mt=E.dataRows[0].length,At=new Array(Mt),St=0;St<Mt;++St)At[St]="";At[0]=mt,At.push(gt),At.xValues=[],xt!==void 0&&(At.xValues[xt]=mt),E.dataRows.push(At)}})}})});var lt=0;E.dataRows.forEach(function(ft){lt=Math.max(lt,ft.length)});for(var ht=lt-E.dataRows[0].length,ut=0;ut<ht;ut++){var dt=rt(ut+1);tt?(E.dataRows[0].push(dt.topLevelColumnTitle),E.dataRows[1].push(dt.columnTitle)):E.dataRows[0].push(dt)}})});wrap$a(Pointer.prototype,"onContainerMouseDown",function(j){this.chart.hasDraggedAnnotation||j.apply(this,Array.prototype.slice.call(arguments,1))});H.Annotation=Annotation;var chartNavigation={initUpdate:function(j){j.navigation||(j.navigation={updates:[],update:function(E,a){this.updates.forEach(function(k){k.update.call(k.context,E,a)})}})},addUpdate:function(j,E){E.navigation||this.initUpdate(E),E.navigation.updates.push({update:j,context:E})}},format$2=FormatUtilities.format,setOptions$1=DefaultOptions.setOptions,addEvent$s=Utilities.addEvent,attr=Utilities.attr,fireEvent$9=Utilities.fireEvent,isArray$7=Utilities.isArray,isFunction$1=Utilities.isFunction,isNumber$j=Utilities.isNumber,isObject$6=Utilities.isObject,merge$E=Utilities.merge,objectEach$b=Utilities.objectEach,pick$J=Utilities.pick,doc$4=H.doc,win$2=H.win,PREFIX$1="highcharts-";function closestPolyfill(j,E){var a=win$2.Element.prototype,k=a.matches||a.msMatchesSelector||a.webkitMatchesSelector,tt=null;if(a.closest)tt=a.closest.call(j,E);else do{if(k.call(j,E))return j;j=j.parentElement||j.parentNode}while(j!==null&&j.nodeType===1);return tt}var bindingsUtils={getFieldType:function(j){return{string:"text",number:"number",boolean:"checkbox"}[typeof j]},updateRectSize:function(j,E){var a=E.chart,k=E.options.typeOptions,tt=isNumber$j(k.xAxis)&&a.xAxis[k.xAxis],et=isNumber$j(k.yAxis)&&a.yAxis[k.yAxis];if(tt&&et){var rt=tt.toValue(j[tt.horiz?"chartX":"chartY"]),nt=et.toValue(j[et.horiz?"chartX":"chartY"]),ot=rt-k.point.x,st=k.point.y-nt;E.update({typeOptions:{background:{width:a.inverted?st:ot,height:a.inverted?ot:st}}})}},getAssignedAxis:function(j){return j.filter(function(E){var a=E.axis.min,k=E.axis.max,tt=pick$J(E.axis.minPointOffset,0);return isNumber$j(a)&&isNumber$j(k)&&E.value>=a-tt&&E.value<=k+tt&&!E.axis.options.isInternal})[0]}},NavigationBindings=function(){function j(E,a){this.boundClassNames=void 0,this.selectedButton=void 0,this.chart=E,this.options=a,this.eventsToUnbind=[],this.container=doc$4.getElementsByClassName(this.options.bindingsClassName||"")}return j.prototype.initEvents=function(){var E=this,a=E.chart,k=E.container,tt=E.options;E.boundClassNames={},objectEach$b(tt.bindings||{},function(et){E.boundClassNames[et.className]=et}),[].forEach.call(k,function(et){E.eventsToUnbind.push(addEvent$s(et,"click",function(rt){var nt=E.getButtonEvents(et,rt);nt&&nt.button.className.indexOf("highcharts-disabled-btn")===-1&&E.bindingsButtonClick(nt.button,nt.events,rt)}))}),objectEach$b(tt.events||{},function(et,rt){isFunction$1(et)&&E.eventsToUnbind.push(addEvent$s(E,rt,et,{passive:!1}))}),E.eventsToUnbind.push(addEvent$s(a.container,"click",function(et){!a.cancelClick&&a.isInsidePlot(et.chartX-a.plotLeft,et.chartY-a.plotTop,{visiblePlotOnly:!0})&&E.bindingsChartClick(this,et)})),E.eventsToUnbind.push(addEvent$s(a.container,H.isTouchDevice?"touchmove":"mousemove",function(et){E.bindingsContainerMouseMove(this,et)},H.isTouchDevice?{passive:!1}:void 0))},j.prototype.initUpdate=function(){var E=this;chartNavigation.addUpdate(function(a){E.update(a)},this.chart)},j.prototype.bindingsButtonClick=function(E,a,k){var tt=this,et=tt.chart;tt.selectedButtonElement&&(fireEvent$9(tt,"deselectButton",{button:tt.selectedButtonElement}),tt.nextEvent&&(tt.currentUserDetails&&tt.currentUserDetails.coll==="annotations"&&et.removeAnnotation(tt.currentUserDetails),tt.mouseMoveEvent=tt.nextEvent=!1)),tt.selectedButton=a,tt.selectedButtonElement=E,fireEvent$9(tt,"selectButton",{button:E}),a.init&&a.init.call(tt,E,k),(a.start||a.steps)&&et.renderer.boxWrapper.addClass(PREFIX$1+"draw-mode")},j.prototype.bindingsChartClick=function(E,a){E=this.chart;var k=this,tt=k.activeAnnotation,et=k.selectedButton,rt=E.renderer.boxWrapper;tt&&(!tt.cancelClick&&!a.activeAnnotation&&a.target.parentNode&&!closestPolyfill(a.target,"."+PREFIX$1+"popup")?fireEvent$9(k,"closePopup"):tt.cancelClick&&setTimeout(function(){tt.cancelClick=!1},0)),!(!et||!et.start)&&(k.nextEvent?(k.nextEvent(a,k.currentUserDetails),k.steps&&(k.stepIndex++,et.steps[k.stepIndex]?k.mouseMoveEvent=k.nextEvent=et.steps[k.stepIndex]:(fireEvent$9(k,"deselectButton",{button:k.selectedButtonElement}),rt.removeClass(PREFIX$1+"draw-mode"),et.end&&et.end.call(k,a,k.currentUserDetails),k.nextEvent=!1,k.mouseMoveEvent=!1,k.selectedButton=null))):(k.currentUserDetails=et.start.call(k,a),k.currentUserDetails&&et.steps?(k.stepIndex=0,k.steps=!0,k.mouseMoveEvent=k.nextEvent=et.steps[k.stepIndex]):(fireEvent$9(k,"deselectButton",{button:k.selectedButtonElement}),rt.removeClass(PREFIX$1+"draw-mode"),k.steps=!1,k.selectedButton=null,et.end&&et.end.call(k,a,k.currentUserDetails))))},j.prototype.bindingsContainerMouseMove=function(E,a){this.mouseMoveEvent&&this.mouseMoveEvent(a,this.currentUserDetails)},j.prototype.fieldsToOptions=function(E,a){return objectEach$b(E,function(k,tt){var et=parseFloat(k),rt=tt.split("."),nt=a,ot=rt.length-1;isNumber$j(et)&&!k.match(/px/g)&&!tt.match(/format/g)&&(k=et),k!==""&&k!=="undefined"&&rt.forEach(function(st,lt){var ht=pick$J(rt[lt+1],"");ot===lt?nt[st]=k:(nt[st]||(nt[st]=ht.match(/\d/g)?[]:{}),nt=nt[st])})}),a},j.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},j.prototype.annotationToFields=function(E){var a=E.options,k=j.annotationsEditable,tt=k.nestedOptions,et=this.utils.getFieldType,rt=pick$J(a.type,a.shapes&&a.shapes[0]&&a.shapes[0].type,a.labels&&a.labels[0]&&a.labels[0].itemType,"label"),nt=j.annotationsNonEditable[a.langKey]||[],ot={langKey:a.langKey,type:rt};function st(lt,ht,ut,dt){var ft;ut&&lt&&nt.indexOf(ht)===-1&&((ut.indexOf&&ut.indexOf(ht))>=0||ut[ht]||ut===!0)&&(isArray$7(lt)?(dt[ht]=[],lt.forEach(function(pt,gt){isObject$6(pt)?(dt[ht][gt]={},objectEach$b(pt,function(yt,mt){st(yt,mt,tt[ht],dt[ht][gt])})):st(pt,0,tt[ht],dt[ht])})):isObject$6(lt)?(ft={},isArray$7(dt)?(dt.push(ft),ft[ht]={},ft=ft[ht]):dt[ht]=ft,objectEach$b(lt,function(pt,gt){st(pt,gt,ht===0?ut:tt[ht],ft)})):ht==="format"?dt[ht]=[format$2(lt,E.labels[0].points[0]).toString(),"text"]:isArray$7(dt)?dt.push([lt,et(lt)]):dt[ht]=[lt,et(lt)])}return objectEach$b(a,function(lt,ht){ht==="typeOptions"?(ot[ht]={},objectEach$b(a[ht],function(ut,dt){st(ut,dt,tt,ot[ht])})):st(lt,ht,k[rt],ot)}),ot},j.prototype.getClickedClassNames=function(E,a){for(var k=a.target,tt=[],et;k;)if(et=attr(k,"class"),et&&(tt=tt.concat(et.split(" ").map(function(rt){return[rt,k]}))),k=k.parentNode,k===E)return tt;return tt},j.prototype.getButtonEvents=function(E,a){var k=this,tt=this.getClickedClassNames(E,a),et;return tt.forEach(function(rt){k.boundClassNames[rt[0]]&&!et&&(et={events:k.boundClassNames[rt[0]],button:rt[1]})}),et},j.prototype.update=function(E){this.options=merge$E(!0,this.options,E),this.removeEvents(),this.initEvents()},j.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(E){E()})},j.prototype.destroy=function(){this.removeEvents()},j.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]},j.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]},j}();NavigationBindings.prototype.utils=bindingsUtils;Chart$1.prototype.initNavigationBindings=function(){var j=this,E=j.options;E&&E.navigation&&E.navigation.bindings&&(j.navigationBindings=new NavigationBindings(j,E.navigation),j.navigationBindings.initEvents(),j.navigationBindings.initUpdate())};addEvent$s(Chart$1,"load",function(){this.initNavigationBindings()});addEvent$s(Chart$1,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});addEvent$s(NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});addEvent$s(Annotation,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});function selectableAnnotation(j){var E=j.prototype.defaultOptions.events&&j.prototype.defaultOptions.events.click;function a(k){var tt=this,et=tt.chart.navigationBindings,rt=et.activeAnnotation;E&&E.call(tt,k),rt!==tt?(et.deselectAnnotation(),et.activeAnnotation=tt,tt.setControlPointsVisibility(!0),fireEvent$9(et,"showPopup",{annotation:tt,formType:"annotation-toolbar",options:et.annotationToFields(tt),onSubmit:function(nt){var ot={},st;nt.actionType==="remove"?(et.activeAnnotation=!1,et.chart.removeAnnotation(tt)):(et.fieldsToOptions(nt.fields,ot),et.deselectAnnotation(),st=ot.typeOptions,tt.options.type==="measure"&&(st.crosshairY.enabled=st.crosshairY.strokeWidth!==0,st.crosshairX.enabled=st.crosshairX.strokeWidth!==0),tt.update(ot))}})):fireEvent$9(et,"closePopup"),k.activeAnnotation=!0}merge$E(!0,j.prototype.defaultOptions.events,{click:a})}H.Annotation&&(selectableAnnotation(Annotation),objectEach$b(Annotation.types,function(j){selectableAnnotation(j)}));setOptions$1({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(j){var E=this.chart.pointer.getCoordinates(j),a=this.utils.getAssignedAxis(E.xAxis),k=this.utils.getAssignedAxis(E.yAxis),tt=this.chart.options.navigation;if(!(!a||!k))return this.chart.addAnnotation(merge$E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:a.value,y:k.value,xAxis:a.axis.options.index,yAxis:k.axis.options.index},r:5}]},tt.annotationsOptions,tt.bindings.circleAnnotation.annotationsOptions))},steps:[function(j,E){var a=E.options.shapes[0].point,k=this.chart.inverted,tt,et,rt;isNumber$j(a.xAxis)&&isNumber$j(a.yAxis)&&(tt=this.chart.xAxis[a.xAxis].toPixels(a.x),et=this.chart.yAxis[a.yAxis].toPixels(a.y),rt=Math.max(Math.sqrt(Math.pow(k?et-j.chartX:tt-j.chartX,2)+Math.pow(k?tt-j.chartY:et-j.chartY,2)),5)),E.update({shapes:[{r:rt}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(j){var E=this.chart.pointer.getCoordinates(j),a=this.utils.getAssignedAxis(E.xAxis),k=this.utils.getAssignedAxis(E.yAxis);if(!(!a||!k)){var tt=a.value,et=k.value,rt=a.axis.options.index,nt=k.axis.options.index,ot=this.chart.options.navigation;return this.chart.addAnnotation(merge$E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:rt,yAxis:nt,x:tt,y:et},{xAxis:rt,yAxis:nt,x:tt,y:et},{xAxis:rt,yAxis:nt,x:tt,y:et},{xAxis:rt,yAxis:nt,x:tt,y:et}]}]},ot.annotationsOptions,ot.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(j,E){var a=E.options.shapes[0].points,k=this.chart.pointer.getCoordinates(j),tt=this.utils.getAssignedAxis(k.xAxis),et=this.utils.getAssignedAxis(k.yAxis),rt,nt;tt&&et&&(rt=tt.value,nt=et.value,a[1].x=rt,a[2].x=rt,a[2].y=nt,a[3].y=nt,E.update({shapes:[{points:a}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(j){var E=this.chart.pointer.getCoordinates(j),a=this.utils.getAssignedAxis(E.xAxis),k=this.utils.getAssignedAxis(E.yAxis),tt=this.chart.options.navigation;if(!(!a||!k))return this.chart.addAnnotation(merge$E({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:k.axis.options.index,x:a.value,y:k.value},overflow:"none",crop:!0}]},tt.annotationsOptions,tt.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});addEvent$s(Chart$1,"render",function(){var j=this,E=j.navigationBindings,a="highcharts-disabled-btn";if(j&&E){var k=!1;j.series.forEach(function(tt){!tt.options.isInternal&&tt.visible&&(k=!0)}),objectEach$b(E.boundClassNames,function(tt,et){if(j.navigationBindings&&j.navigationBindings.container&&j.navigationBindings.container[0]){var rt=j.navigationBindings.container[0].querySelectorAll("."+et);if(rt)for(var nt=0;nt<rt.length;nt++){var ot=rt[nt];tt.noDataState==="normal"||k?ot.className.indexOf(a)!==-1&&ot.classList.remove(a):ot.className.indexOf(a)===-1&&(ot.className+=" "+a)}}})}});addEvent$s(NavigationBindings,"closePopup",function(){this.deselectAnnotation()});var doc$3=H.doc,isFirefox=H.isFirefox,getOptions$1=DefaultOptions.getOptions,addEvent$r=Utilities.addEvent,createElement$2=Utilities.createElement,defined$i=Utilities.defined,fireEvent$8=Utilities.fireEvent,isArray$6=Utilities.isArray,isObject$5=Utilities.isObject,isString$1=Utilities.isString,objectEach$a=Utilities.objectEach,pick$I=Utilities.pick,stableSort$3=Utilities.stableSort,wrap$9=Utilities.wrap,indexFilter=/\d/g,PREFIX="highcharts-",DIV="div",INPUT="input",LABEL="label",BUTTON="button",SELECT="select",OPTION="option",SPAN="span",UL="ul",LI="li",H3="h3";wrap$9(Pointer.prototype,"onContainerMouseDown",function(j,E){var a=E.target&&E.target.className;isString$1(a)&&a.indexOf(PREFIX+"popup-field")>=0||j.apply(this,Array.prototype.slice.call(arguments,1))});H.Popup=function(j,E,a){this.init(j,E,a)};H.Popup.prototype={init:function(j,E,a){this.chart=a,this.container=createElement$2(DIV,{className:PREFIX+"popup highcharts-no-tooltip"},null,j),this.lang=this.getLangpack(),this.iconsURL=E,this.addCloseBtn()},addCloseBtn:function(){var j=this,E,a=this.iconsURL;E=createElement$2(DIV,{className:PREFIX+"popup-close"},null,this.container),E.style["background-image"]="url("+(a.match(/png|svg|jpeg|jpg|gif/ig)?a:a+"close.svg")+")",["click","touchstart"].forEach(function(k){addEvent$r(E,k,function(){j.chart?fireEvent$8(j.chart.navigationBindings,"closePopup"):j.closePopup()})})},addColsContainer:function(j){var E,a;return a=createElement$2(DIV,{className:PREFIX+"popup-lhs-col"},null,j),E=createElement$2(DIV,{className:PREFIX+"popup-rhs-col"},null,j),createElement$2(DIV,{className:PREFIX+"popup-rhs-col-wrapper"},null,E),{lhsCol:a,rhsCol:E}},addInput:function(j,E,a,k){var tt=j.split("."),et=tt[tt.length-1],rt=this.lang,nt=PREFIX+E+"-"+et;nt.match(indexFilter)||createElement$2(LABEL,{htmlFor:nt},void 0,a).appendChild(doc$3.createTextNode(rt[et]||et)),k!==""&&createElement$2(INPUT,{name:nt,value:k[0],type:k[1],className:PREFIX+"popup-field"},void 0,a).setAttribute(PREFIX+"data-name",j)},addButton:function(j,E,a,k,tt){var et=this,rt=this.closePopup,nt=this.getFields,ot;return ot=createElement$2(BUTTON,void 0,void 0,j),ot.appendChild(doc$3.createTextNode(E)),["click","touchstart"].forEach(function(st){addEvent$r(ot,st,function(){return rt.call(et),k(nt(tt,a))})}),ot},getFields:function(j,E){var a=j.querySelectorAll("input"),k="#"+PREFIX+"select-series > option:checked",tt="#"+PREFIX+"select-volume > option:checked",et=j.querySelectorAll(k)[0],rt=j.querySelectorAll(tt)[0],nt,ot,st;return st={actionType:E,linkedTo:et&&et.getAttribute("value"),fields:{}},[].forEach.call(a,function(lt){ot=lt.getAttribute(PREFIX+"data-name"),nt=lt.getAttribute(PREFIX+"data-series-id"),nt?st.seriesId=lt.value:ot?st.fields[ot]=lt.value:st.type=lt.value}),rt&&(st.fields["params.volumeSeriesID"]=rt.getAttribute("value")),st},showPopup:function(){var j=this.container,E=PREFIX+"annotation-toolbar",a=j.querySelectorAll("."+PREFIX+"popup-close")[0];this.formType=void 0,j.innerHTML="",j.className.indexOf(E)>=0&&(j.classList.remove(E),j.removeAttribute("style")),j.appendChild(a),j.style.display="block",j.style.height=""},closePopup:function(){var j=pick$I(this.popup&&this.popup.container,this.container);j.style.display="none"},showForm:function(j,E,a,k){E&&(this.popup=E.navigationBindings.popup,this.showPopup(),j==="indicators"&&this.indicators.addForm.call(this,E,a,k),j==="annotation-toolbar"&&this.annotations.addToolbar.call(this,E,a,k),j==="annotation-edit"&&this.annotations.addForm.call(this,E,a,k),j==="flag"&&this.annotations.addForm.call(this,E,a,k,!0),this.formType=j,this.container.style.height=this.container.offsetHeight+"px")},getLangpack:function(){return getOptions$1().lang.navigation.popup},annotations:{addToolbar:function(j,E,a){var k=this,tt=this.lang,et=this.popup.container,rt=this.showForm,nt=PREFIX+"annotation-toolbar",ot;et.className.indexOf(nt)===-1&&(et.className+=" "+nt),j&&(et.style.top=j.plotTop+10+"px"),createElement$2(SPAN,void 0,void 0,et).appendChild(doc$3.createTextNode(pick$I(tt[E.langKey]||E.langKey,E.shapes&&E.shapes[0].type))),ot=this.addButton(et,tt.removeButton||"remove","remove",a,et),ot.className+=" "+PREFIX+"annotation-remove-button",ot.style["background-image"]="url("+this.iconsURL+"destroy.svg)",ot=this.addButton(et,tt.editButton||"edit","edit",function(){rt.call(k,"annotation-edit",j,E,a)},et),ot.className+=" "+PREFIX+"annotation-edit-button",ot.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(j,E,a,k){var tt=this.popup.container,et=this.lang,rt,nt;j&&(nt=createElement$2("h2",{className:PREFIX+"popup-main-title"},void 0,tt),nt.appendChild(doc$3.createTextNode(et[E.langKey]||E.langKey||"")),nt=createElement$2(DIV,{className:PREFIX+"popup-lhs-col "+PREFIX+"popup-lhs-full"},null,tt),rt=createElement$2(DIV,{className:PREFIX+"popup-bottom-row"},null,tt),this.annotations.addFormFields.call(this,nt,j,"",E,[],!0),this.addButton(rt,k?et.addButton||"add":et.saveButton||"save",k?"add":"save",a,tt))},addFormFields:function(j,E,a,k,tt,et){var rt=this,nt=this.annotations.addFormFields,ot=this.addInput,st=this.lang,lt,ht;E&&(objectEach$a(k,function(ut,dt){lt=a!==""?a+"."+dt:dt,isObject$5(ut)&&(!isArray$6(ut)||isArray$6(ut)&&isObject$5(ut[0])?(ht=st[dt]||dt,ht.match(indexFilter)||tt.push([!0,ht,j]),nt.call(rt,j,E,lt,ut,tt,!1)):tt.push([rt,lt,"annotation",j,ut]))}),et&&(stableSort$3(tt,function(ut){return ut[1].match(/format/g)?-1:1}),isFirefox&&tt.reverse(),tt.forEach(function(ut){ut[0]===!0?createElement$2(SPAN,{className:PREFIX+"annotation-title"},void 0,ut[2]).appendChild(doc$3.createTextNode(ut[1])):ot.apply(ut[0],ut.splice(1))})))}},indicators:{addForm:function(j,E,a){var k,tt=this.indicators,et=this.lang,rt;j&&(this.tabs.init.call(this,j),k=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content"),this.addColsContainer(k[0]),tt.addIndicatorList.call(this,j,k[0],"add"),rt=k[0].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(rt,et.addButton||"add","add",a,rt),this.addColsContainer(k[1]),tt.addIndicatorList.call(this,j,k[1],"edit"),rt=k[1].querySelectorAll("."+PREFIX+"popup-rhs-col")[0],this.addButton(rt,et.saveButton||"save","edit",a,rt),this.addButton(rt,et.removeButton||"remove","remove",a,rt))},addIndicatorList:function(j,E,a){var k=this,tt=E.querySelectorAll("."+PREFIX+"popup-lhs-col")[0],et=E.querySelectorAll("."+PREFIX+"popup-rhs-col")[0],rt=a==="edit",nt=rt?j.series:j.options.plotOptions,ot=this.indicators.addFormFields,st,lt,ht;j&&(lt=createElement$2(UL,{className:PREFIX+"indicator-list"},null,tt),st=et.querySelectorAll("."+PREFIX+"popup-rhs-col-wrapper")[0],objectEach$a(nt,function(ut,dt){var ft=ut.options;if(ut.params||ft&&ft.params){var pt=k.indicators.getNameType(ut,dt),gt=pt.type;ht=createElement$2(LI,{className:PREFIX+"indicator-list"},void 0,lt),ht.appendChild(doc$3.createTextNode(pt.name)),["click","touchstart"].forEach(function(yt){addEvent$r(ht,yt,function(){ot.call(k,j,rt?ut:nt[gt],pt.type,st),rt&&ut.options&&createElement$2(INPUT,{type:"hidden",name:PREFIX+"id-"+gt,value:ut.options.id},null,st).setAttribute(PREFIX+"data-series-id",ut.options.id)})})}}),lt.childNodes.length>0&&lt.childNodes[0].click())},getNameType:function(j,E){var a=j.options,k=H.seriesTypes,tt=k[E]&&k[E].prototype.nameBase||E.toUpperCase(),et=E;return a&&a.type&&(et=j.options.type,tt=j.name),{name:tt,type:et}},listAllSeries:function(j,E,a,k,tt){var et=PREFIX+E+"-type-"+j,rt=this.lang,nt,ot;a&&(createElement$2(LABEL,{htmlFor:et},null,k).appendChild(doc$3.createTextNode(rt[E]||E)),nt=createElement$2(SELECT,{name:et,className:PREFIX+"popup-field"},null,k),nt.setAttribute("id",PREFIX+"select-"+E),a.series.forEach(function(st){ot=st.options,!ot.params&&ot.id&&ot.id!==PREFIX+"navigator-series"&&createElement$2(OPTION,{value:ot.id},null,nt).appendChild(doc$3.createTextNode(ot.name||ot.id))}),defined$i(tt)&&(nt.value=tt))},addFormFields:function(j,E,a,k){var tt=E.params||E.options.params,et=this.indicators.getNameType;k.innerHTML="",createElement$2(H3,{className:PREFIX+"indicator-title"},void 0,k).appendChild(doc$3.createTextNode(et(E,a).name)),createElement$2(INPUT,{type:"hidden",name:PREFIX+"type-"+a,value:a},null,k),this.indicators.listAllSeries.call(this,a,"series",j,k,E.linkedParent&&tt.volumeSeriesID),tt.volumeSeriesID&&this.indicators.listAllSeries.call(this,a,"volume",j,k,E.linkedParent&&E.linkedParent.options.id),this.indicators.addParamInputs.call(this,j,"params",tt,a,k)},addParamInputs:function(j,E,a,k,tt){var et=this,rt=this.indicators.addParamInputs,nt=this.addInput,ot;j&&objectEach$a(a,function(st,lt){ot=E+"."+lt,st!==void 0&&(isObject$5(st)?(nt.call(et,ot,k,tt,""),rt.call(et,j,ot,st,k,tt)):ot!=="params.volumeSeriesID"&&nt.call(et,ot,k,tt,[st,"text"]))})},getAmount:function(){var j=this.series,E=0;return j.forEach(function(a){var k=a.options;(a.params||k&&k.params)&&E++}),E}},tabs:{init:function(j){var E=this.tabs,a=this.indicators.getAmount.call(j),k;j&&(k=E.addMenuItem.call(this,"add"),E.addMenuItem.call(this,"edit",a),E.addContentItem.call(this,"add"),E.addContentItem.call(this,"edit"),E.switchTabs.call(this,a),E.selectTab.call(this,k,0))},addMenuItem:function(j,E){var a=this.popup.container,k=PREFIX+"tab-item",tt=this.lang,et;return E===0&&(k+=" "+PREFIX+"tab-disabled"),et=createElement$2(SPAN,{className:k},void 0,a),et.appendChild(doc$3.createTextNode(tt[j+"Button"]||j)),et.setAttribute(PREFIX+"data-tab-type",j),et},addContentItem:function(){var j=this.popup.container;return createElement$2(DIV,{className:PREFIX+"tab-item-content "+PREFIX+"no-mousewheel"},null,j)},switchTabs:function(j){var E=this,a=this.popup.container,k=a.querySelectorAll("."+PREFIX+"tab-item"),tt;k.forEach(function(et,rt){tt=et.getAttribute(PREFIX+"data-tab-type"),!(tt==="edit"&&j===0)&&["click","touchstart"].forEach(function(nt){addEvent$r(et,nt,function(){E.tabs.deselectAll.call(E),E.tabs.selectTab.call(E,this,rt)})})})},selectTab:function(j,E){var a=this.popup.container.querySelectorAll("."+PREFIX+"tab-item-content");j.className+=" "+PREFIX+"tab-item-active",a[E].className+=" "+PREFIX+"tab-item-show"},deselectAll:function(){var j=this.popup.container,E=j.querySelectorAll("."+PREFIX+"tab-item"),a=j.querySelectorAll("."+PREFIX+"tab-item-content"),k;for(k=0;k<E.length;k++)E[k].classList.remove(PREFIX+"tab-item-active"),a[k].classList.remove(PREFIX+"tab-item-show")}}};addEvent$r(NavigationBindings,"showPopup",function(j){this.popup||(this.popup=new H.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/9.2.2/gfx/stock-icons/",this.chart)),this.popup.showForm(j.formType,this.chart,j.options,j.onSubmit)});addEvent$r(NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()});H.Popup;var addEvent$q=Utilities.addEvent,extend$L=Utilities.extend,merge$D=Utilities.merge,pick$H=Utilities.pick,splat$4=Utilities.splat;Chart$1.prototype.collectionsWithUpdate.push("pane");var Pane=function(){function j(E,a){this.background=void 0,this.center=void 0,this.chart=void 0,this.options=void 0,this.coll="pane",this.defaultOptions={center:["50%","50%"],size:"85%",innerSize:"0%",startAngle:0},this.defaultBackgroundOptions={shape:"circle",borderWidth:1,borderColor:palette.neutralColor20,backgroundColor:{linearGradient:{x1:0,y1:0,x2:0,y2:1},stops:[[0,palette.backgroundColor],[1,palette.neutralColor10]]},from:-Number.MAX_VALUE,innerRadius:0,to:Number.MAX_VALUE,outerRadius:"105%"},this.init(E,a)}return j.prototype.init=function(E,a){this.chart=a,this.background=[],a.pane.push(this),this.setOptions(E)},j.prototype.setOptions=function(E){this.options=E=merge$D(this.defaultOptions,this.chart.angular?{background:{}}:void 0,E)},j.prototype.render=function(){var E=this.options,a=this.options.background,k=this.chart.renderer,tt,et;if(this.group||(this.group=k.g("pane-group").attr({zIndex:E.zIndex||0}).add()),this.updateCenter(),a)for(a=splat$4(a),tt=Math.max(a.length,this.background.length||0),et=0;et<tt;et++)a[et]&&this.axis?this.renderBackground(merge$D(this.defaultBackgroundOptions,a[et]),et):this.background[et]&&(this.background[et]=this.background[et].destroy(),this.background.splice(et,1))},j.prototype.renderBackground=function(E,a){var k="animate",tt={class:"highcharts-pane "+(E.className||"")};this.chart.styledMode||extend$L(tt,{fill:E.backgroundColor,stroke:E.borderColor,"stroke-width":E.borderWidth}),this.background[a]||(this.background[a]=this.chart.renderer.path().add(this.group),k="attr"),this.background[a][k]({d:this.axis.getPlotBandPath(E.from,E.to,E)}).attr(tt)},j.prototype.updateCenter=function(E){this.center=(E||this.axis||{}).center=centeredSeriesMixin.getCenter.call(this)},j.prototype.update=function(E,a){merge$D(!0,this.options,E),this.setOptions(this.options),this.render(),this.chart.axes.forEach(function(k){k.pane===this&&(k.pane=null,k.update({},a))},this)},j}();function isInsidePane(j,E,a){return Math.sqrt(Math.pow(j-a[0],2)+Math.pow(E-a[1],2))<=a[2]/2}Chart$1.prototype.getHoverPane=function(j){var E=this,a;return j&&E.pane.forEach(function(k){var tt=j.chartX-E.plotLeft,et=j.chartY-E.plotTop,rt=E.inverted?et:tt,nt=E.inverted?tt:et;isInsidePane(rt,nt,k.center)&&(a=k)}),a};addEvent$q(Chart$1,"afterIsInsidePlot",function(j){var E=this;E.polar&&(j.isInsidePlot=E.pane.some(function(a){return isInsidePane(j.x,j.y,a.center)}))});addEvent$q(Pointer,"beforeGetHoverData",function(j){var E=this.chart;E.polar?(E.hoverPane=E.getHoverPane(j),j.filter=function(a){return a.visible&&!(!j.shared&&a.directTouch)&&pick$H(a.options.enableMouseTracking,!0)&&(!E.hoverPane||a.xAxis.pane===E.hoverPane)}):E.hoverPane=void 0});addEvent$q(Pointer,"afterGetHoverData",function(j){var E=this.chart;j.hoverPoint&&j.hoverPoint.plotX&&j.hoverPoint.plotY&&E.hoverPane&&!isInsidePane(j.hoverPoint.plotX,j.hoverPoint.plotY,E.hoverPane.center)&&(j.hoverPoint=void 0)});H.Pane=Pane;const Pane$1=H.Pane;var defaultOptions$4=DefaultOptions.defaultOptions,noop$c=H.noop,addEvent$p=Utilities.addEvent,correctFloat$3=Utilities.correctFloat,defined$h=Utilities.defined,extend$K=Utilities.extend,fireEvent$7=Utilities.fireEvent,merge$C=Utilities.merge,pick$G=Utilities.pick,relativeLength$2=Utilities.relativeLength,wrap$8=Utilities.wrap,RadialAxis;(function(j){var E=[],a={gridLineWidth:1,labels:{align:void 0,distance:15,x:0,y:void 0,style:{textOverflow:"none"}},maxPadding:0,minPadding:0,showLastLabel:!1,tickLength:0},k={labels:{align:"center",x:0,y:void 0},minorGridLineWidth:0,minorTickInterval:"auto",minorTickLength:10,minorTickPosition:"inside",minorTickWidth:1,tickLength:10,tickPosition:"inside",tickWidth:2,title:{rotation:0},zIndex:2},tt={gridLineInterpolation:"circle",gridLineWidth:1,labels:{align:"right",x:-3,y:-2},showLastLabel:!1,title:{x:4,text:null,rotation:90}};function et(){this.autoConnect=this.isCircular&&typeof pick$G(this.userMax,this.options.max)>"u"&&correctFloat$3(this.endAngleRad-this.startAngleRad)===correctFloat$3(2*Math.PI),!this.isCircular&&this.chart.inverted&&this.max++,this.autoConnect&&(this.max+=this.categories&&1||this.pointRange||this.closestPointRange||0)}function rt(jt,Dt){return E.indexOf(jt)===-1&&(E.push(jt),addEvent$p(jt,"afterInit",mt),addEvent$p(jt,"autoLabelAlign",xt),addEvent$p(jt,"destroy",wt),addEvent$p(jt,"init",Mt),addEvent$p(jt,"initialAxisTranslation",At)),E.indexOf(Dt)===-1&&(E.push(Dt),addEvent$p(Dt,"afterGetLabelPosition",St),addEvent$p(Dt,"afterGetPosition",$t),wrap$8(Dt.prototype,"getMarkPath",Ht)),jt}j.compose=rt;function nt(){var jt=this;return function(){if(jt.isRadial&&jt.tickPositions&&jt.options.labels&&jt.options.labels.allowOverlap!==!0)return jt.tickPositions.map(function(Dt){return jt.ticks[Dt]&&jt.ticks[Dt].label}).filter(function(Dt){return Boolean(Dt)})}}function ot(){return noop$c}function st(jt,Dt,Ft){var kt=this.pane.center,Bt=jt.value,Gt,Yt,Vt,qt;return this.isCircular?(defined$h(Bt)?jt.point&&(Gt=jt.point.shapeArgs||{},Gt.start&&(Bt=this.chart.inverted?this.translate(jt.point.rectPlotY,!0):jt.point.x)):(Vt=jt.chartX||0,qt=jt.chartY||0,Bt=this.translate(Math.atan2(qt-Ft,Vt-Dt)-this.startAngleRad,!0)),Yt=this.getPosition(Bt),Vt=Yt.x,qt=Yt.y):(defined$h(Bt)||(Vt=jt.chartX,qt=jt.chartY),defined$h(Vt)&&defined$h(qt)&&(Ft=kt[1]+this.chart.plotTop,Bt=this.translate(Math.min(Math.sqrt(Math.pow(Vt-Dt,2)+Math.pow(qt-Ft,2)),kt[2]/2)-kt[3]/2,!0))),[Bt,Vt||0,qt||0]}function lt(jt,Dt,Ft){var kt=this.pane.center,Bt=this.chart,Gt=this.left||0,Yt=this.top||0,Vt,qt=pick$G(Dt,kt[2]/2-this.offset),Xt;return typeof Ft>"u"&&(Ft=this.horiz?0:this.center&&-this.center[3]/2),Ft&&(qt+=Ft),this.isCircular||typeof Dt<"u"?(Xt=this.chart.renderer.symbols.arc(Gt+kt[0],Yt+kt[1],qt,qt,{start:this.startAngleRad,end:this.endAngleRad,open:!0,innerR:0}),Xt.xBounds=[Gt+kt[0]],Xt.yBounds=[Yt+kt[1]-qt]):(Vt=this.postTranslate(this.angleRad,qt),Xt=[["M",this.center[0]+Bt.plotLeft,this.center[1]+Bt.plotTop],["L",Vt.x,Vt.y]]),Xt}function ht(){var jt=this.constructor.prototype;jt.getOffset.call(this),this.chart.axisOffset[this.side]=0}function ut(jt,Dt,Ft){var kt=this.chart,Bt=function(Ce){if(typeof Ce=="string"){var Xe=parseInt(Ce,10);return Jt.test(Ce)&&(Xe=Xe*Vt/100),Xe}return Ce},Gt=this.center,Yt=this.startAngleRad,Vt=Gt[2]/2,qt=Math.min(this.offset,0),Xt=this.left||0,Kt=this.top||0,Jt=/%$/,de=this.isCircular,te,se,ce,be,Te,Oe,ke=pick$G(Bt(Ft.outerRadius),Vt),oe=Bt(Ft.innerRadius),ae=pick$G(Bt(Ft.thickness),10);if(this.options.gridLineInterpolation==="polygon")Oe=this.getPlotLinePath({value:jt}).concat(this.getPlotLinePath({value:Dt,reverse:!0}));else{jt=Math.max(jt,this.min),Dt=Math.min(Dt,this.max);var ve=this.translate(jt),we=this.translate(Dt);de||(ke=ve||0,oe=we||0),Ft.shape==="circle"||!de?(te=-Math.PI/2,se=Math.PI*1.5,Te=!0):(te=Yt+(ve||0),se=Yt+(we||0)),ke-=qt,ae-=qt,Oe=kt.renderer.symbols.arc(Xt+Gt[0],Kt+Gt[1],ke,ke,{start:Math.min(te,se),end:Math.max(te,se),innerR:pick$G(oe,ke-ae),open:Te}),de&&(ce=(se+te)/2,be=Xt+Gt[0]+Gt[2]/2*Math.cos(ce),Oe.xBounds=ce>-Math.PI/2&&ce<Math.PI/2?[be,kt.plotWidth]:[0,be],Oe.yBounds=[Kt+Gt[1]+Gt[2]/2*Math.sin(ce)],Oe.yBounds[0]+=ce>-Math.PI&&ce<0||ce>Math.PI?-10:10)}return Oe}function dt(jt){var Dt=this,Ft=this.pane.center,kt=this.chart,Bt=kt.inverted,Gt=jt.reverse,Yt=this.pane.options.background?this.pane.options.background[0]||this.pane.options.background:{},Vt=Yt.innerRadius||"0%",qt=Yt.outerRadius||"100%",Xt=Ft[0]+kt.plotLeft,Kt=Ft[1]+kt.plotTop,Jt=this.height,de=jt.isCrosshair,te=Ft[3]/2,se=jt.value,ce,be,Te,Oe,ke,oe,ae,ve,we,Ce=this.getPosition(se),Xe=Ce.x,li=Ce.y;if(de&&(ve=this.getCrosshairPosition(jt,Xt,Kt),se=ve[0],Xe=ve[1],li=ve[2]),this.isCircular)be=Math.sqrt(Math.pow(Xe-Xt,2)+Math.pow(li-Kt,2)),Te=typeof Vt=="string"?relativeLength$2(Vt,1):Vt/be,Oe=typeof qt=="string"?relativeLength$2(qt,1):qt/be,Ft&&te&&(ce=te/be,Te<ce&&(Te=ce),Oe<ce&&(Oe=ce)),we=[["M",Xt+Te*(Xe-Xt),Kt-Te*(Kt-li)],["L",Xe-(1-Oe)*(Xe-Xt),li+(1-Oe)*(Kt-li)]];else if(se=this.translate(se),se&&(se<0||se>Jt)&&(se=0),this.options.gridLineInterpolation==="circle")we=this.getLinePath(0,se,te);else if(we=[],kt[Bt?"yAxis":"xAxis"].forEach(function(Xi){Xi.pane===Dt.pane&&(ke=Xi)}),ke){ae=ke.tickPositions,ke.autoConnect&&(ae=ae.concat([ae[0]])),Gt&&(ae=ae.slice().reverse()),se&&(se+=te);for(var ri=0;ri<ae.length;ri++)oe=ke.getPosition(ae[ri],se),we.push(ri?["L",oe.x,oe.y]:["M",oe.x,oe.y])}return we}function ft(jt,Dt){var Ft=this.translate(jt);return this.postTranslate(this.isCircular?Ft:this.angleRad,pick$G(this.isCircular?Dt:Ft<0?0:Ft,this.center[2]/2)-this.offset)}function pt(){var jt=this.center,Dt=this.chart,Ft=this.options.title;return{x:Dt.plotLeft+jt[0]+(Ft.x||0),y:Dt.plotTop+jt[1]-{high:.5,middle:.25,low:0}[Ft.align]*jt[2]+(Ft.y||0)}}function gt(jt){jt.beforeSetTickPositions=et,jt.createLabelCollector=nt,jt.getCrosshairPosition=st,jt.getLinePath=lt,jt.getOffset=ht,jt.getPlotBandPath=ut,jt.getPlotLinePath=dt,jt.getPosition=ft,jt.getTitlePosition=pt,jt.postTranslate=Tt,jt.setAxisSize=It,jt.setAxisTranslation=Lt,jt.setOptions=Nt}function yt(jt){jt.isHidden=!0,jt.createLabelCollector=ot,jt.getOffset=noop$c,jt.redraw=Pt,jt.render=Pt,jt.setScale=noop$c,jt.setCategories=noop$c,jt.setTitle=noop$c}function mt(){var jt=this.chart,Dt=this.options,Ft=jt.angular&&this.isXAxis,kt=this.pane,Bt=kt&&kt.options;!Ft&&kt&&(jt.angular||jt.polar)&&(this.angleRad=(Dt.angle||0)*Math.PI/180,this.startAngleRad=(Bt.startAngle-90)*Math.PI/180,this.endAngleRad=(pick$G(Bt.endAngle,Bt.startAngle+360)-90)*Math.PI/180,this.offset=Dt.offset||0)}function xt(jt){this.isRadial&&(jt.align=void 0,jt.preventDefault())}function wt(){if(this.chart&&this.chart.labelCollectors){var jt=this.labelCollector?this.chart.labelCollectors.indexOf(this.labelCollector):-1;jt>=0&&this.chart.labelCollectors.splice(jt,1)}}function Mt(jt){var Dt=this.chart,Ft=Dt.inverted,kt=Dt.angular,Bt=Dt.polar,Gt=this.isXAxis,Yt=this.coll,Vt=kt&&Gt,qt=Dt.options,Xt=jt.userOptions.pane||0,Kt=this.pane=Dt.pane&&Dt.pane[Xt],Jt;if(Yt==="colorAxis"){this.isRadial=!1;return}kt?(Vt?yt(this):gt(this),Jt=!Gt,Jt&&(this.defaultPolarOptions=k)):Bt&&(gt(this),Jt=this.horiz,this.defaultPolarOptions=Jt?a:merge$C(Yt==="xAxis"?AxisDefaults$1.defaultXAxisOptions:AxisDefaults$1.defaultYAxisOptions,tt),Ft&&Yt==="yAxis"&&(this.defaultPolarOptions.stackLabels=AxisDefaults$1.defaultYAxisOptions.stackLabels,this.defaultPolarOptions.reversedStacks=!0)),kt||Bt?(this.isRadial=!0,qt.chart.zoomType=null,this.labelCollector||(this.labelCollector=this.createLabelCollector()),this.labelCollector&&Dt.labelCollectors.push(this.labelCollector)):this.isRadial=!1,Kt&&Jt&&(Kt.axis=this),this.isCircular=Jt}function At(){this.isRadial&&this.beforeSetTickPositions()}function St(jt){var Dt=this.label;if(Dt){var Ft=this.axis,kt=Dt.getBBox(),Bt=Ft.options.labels,Gt=(Ft.translate(this.pos)+Ft.startAngleRad+Math.PI/2)/Math.PI*180%360,Yt=Math.round(Gt),Vt=defined$h(Bt.y)?0:-kt.height*.3,qt=Bt.y,Xt,Kt=20,Jt=Bt.align,de="end",te=Yt<0?Yt+360:Yt,se=te,ce=0,be=0;Ft.isRadial&&(Xt=Ft.getPosition(this.pos,Ft.center[2]/2+relativeLength$2(pick$G(Bt.distance,-25),Ft.center[2]/2,-Ft.center[2]/2)),Bt.rotation==="auto"?Dt.attr({rotation:Gt}):defined$h(qt)||(qt=Ft.chart.renderer.fontMetrics(Dt.styles&&Dt.styles.fontSize).b-kt.height/2),defined$h(Jt)||(Ft.isCircular?(kt.width>Ft.len*Ft.tickInterval/(Ft.max-Ft.min)&&(Kt=0),Gt>Kt&&Gt<180-Kt?Jt="left":Gt>180+Kt&&Gt<360-Kt?Jt="right":Jt="center"):Jt="center",Dt.attr({align:Jt})),Jt==="auto"&&Ft.tickPositions.length===2&&Ft.isCircular&&(te>90&&te<180?te=180-te:te>270&&te<=360&&(te=540-te),se>180&&se<=360&&(se=360-se),(Ft.pane.options.startAngle===Yt||Ft.pane.options.startAngle===Yt+360||Ft.pane.options.startAngle===Yt-360)&&(de="start"),Yt>=-90&&Yt<=90||Yt>=-360&&Yt<=-270||Yt>=270&&Yt<=360?Jt=de==="start"?"right":"left":Jt=de==="start"?"left":"right",se>70&&se<110&&(Jt="center"),te<15||te>=180&&te<195?ce=kt.height*.3:te>=15&&te<=35?ce=de==="start"?0:kt.height*.75:te>=195&&te<=215?ce=de==="start"?kt.height*.75:0:te>35&&te<=90?ce=de==="start"?-kt.height*.25:kt.height:te>215&&te<=270&&(ce=de==="start"?kt.height:-kt.height*.25),se<15?be=de==="start"?-kt.height*.15:kt.height*.15:se>165&&se<=180&&(be=de==="start"?kt.height*.15:-kt.height*.15),Dt.attr({align:Jt}),Dt.translate(be,ce+Vt)),jt.pos.x=Xt.x+(Bt.x||0),jt.pos.y=Xt.y+(qt||0))}}function $t(jt){this.axis.getPosition&&extend$K(jt.pos,this.axis.getPosition(this.pos))}function Tt(jt,Dt){var Ft=this.chart,kt=this.center;return jt=this.startAngleRad+jt,{x:Ft.plotLeft+kt[0]+Math.cos(jt)*Dt,y:Ft.plotTop+kt[1]+Math.sin(jt)*Dt}}function Pt(){this.isDirty=!1}function It(){var jt=this.constructor.prototype,Dt,Ft;jt.setAxisSize.call(this),this.isRadial&&(this.pane.updateCenter(this),Dt=this.center=this.pane.center.slice(),this.isCircular?this.sector=this.endAngleRad-this.startAngleRad:(Ft=this.postTranslate(this.angleRad,Dt[3]/2),Dt[0]=Ft.x-this.chart.plotLeft,Dt[1]=Ft.y-this.chart.plotTop),this.len=this.width=this.height=(Dt[2]-Dt[3])*pick$G(this.sector,1)/2)}function Lt(){var jt=this.constructor.prototype;jt.setAxisTranslation.call(this),this.center&&(this.isCircular?this.transA=(this.endAngleRad-this.startAngleRad)/(this.max-this.min||1):this.transA=(this.center[2]-this.center[3])/2/(this.max-this.min||1),this.isXAxis?this.minPixelPadding=this.transA*this.minPointOffset:this.minPixelPadding=0)}function Nt(jt){var Dt=this.options=merge$C(this.constructor.defaultOptions,this.defaultPolarOptions,defaultOptions$4[this.coll],jt);Dt.plotBands||(Dt.plotBands=[]),fireEvent$7(this,"afterSetOptions")}function Ht(jt,Dt,Ft,kt,Bt,Gt,Yt){var Vt=this.axis,qt,Xt;return Vt.isRadial?(qt=Vt.getPosition(this.pos,Vt.center[2]/2+kt),Xt=["M",Dt,Ft,"L",qt.x,qt.y]):Xt=jt.call(this,Dt,Ft,kt,Bt,Gt,Yt),Xt}})(RadialAxis||(RadialAxis={}));const RadialAxis$1=RadialAxis;var __extends$1W=globalThis&&globalThis.__extends||function(){var j=function(E,a){return j=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(k,tt){k.__proto__=tt}||function(k,tt){for(var et in tt)tt.hasOwnProperty(et)&&(k[et]=tt[et])},j(E,a)};return function(E,a){j(E,a);function k(){this.constructor=E}E.prototype=a===null?Object.create(a):(k.prototype=a.prototype,new k)}}(),pointProto=Point$5.prototype,defined$g=Utilities.defined,isNumber$i=Utilities.isNumber,AreaRangePoin