/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.BrowserLauncher;
import com.vaadin.base.devserver.FileWatcher;
import com.vaadin.base.devserver.startup.DevModeInitializer;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeHandlerManagerImpl
implements DevModeHandlerManager {
    private DevModeHandler devModeHandler;
    private BrowserLauncher browserLauncher;
    private FileWatcher themeFilesWatcher;

    public Class<?>[] getHandlesTypes() {
        return DevModeStartupListener.class.getAnnotation(HandlesTypes.class).value();
    }

    public void setDevModeHandler(DevModeHandler devModeHandler) {
        if (this.devModeHandler != null) {
            throw new IllegalStateException("Unable to initialize dev mode handler. A handler is already present: " + this.devModeHandler);
        }
        this.devModeHandler = devModeHandler;
    }

    public DevModeHandler getDevModeHandler() {
        return this.devModeHandler;
    }

    public void initDevModeHandler(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        this.setDevModeHandler(DevModeInitializer.initDevModeHandler(classes, context));
        this.startWatchingThemeFolder(context);
        this.setDevModeStarted(context);
        this.browserLauncher = new BrowserLauncher(context);
    }

    private void startWatchingThemeFolder(VaadinContext context) {
        ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
        if (config.isProductionMode() || config.frontendHotdeploy()) {
            return;
        }
        try {
            File projectFolder = config.getProjectFolder();
            Optional themeName = FrontendUtils.getThemeName((File)projectFolder);
            if (themeName.isEmpty()) {
                DevModeHandlerManagerImpl.getLogger().debug("Found no custom theme in the project. Skipping watching the theme files");
                return;
            }
            File watchDirectory = new File(projectFolder, Path.of("frontend/", "themes", (String)themeName.get()).toString());
            Optional liveReload = BrowserLiveReloadAccessor.getLiveReloadFromContext((VaadinContext)context);
            if (liveReload.isPresent()) {
                this.themeFilesWatcher = new FileWatcher((SerializableConsumer<File>)(SerializableConsumer & Serializable)file -> ((BrowserLiveReload)liveReload.get()).reload(), watchDirectory);
                this.themeFilesWatcher.start();
            } else {
                DevModeHandlerManagerImpl.getLogger().error("Browser live reload is not available. Failed to start live-reload for theme files");
            }
        }
        catch (Exception e) {
            DevModeHandlerManagerImpl.getLogger().error("Failed to start live-reload for theme files", (Throwable)e);
        }
    }

    public void stopDevModeHandler() {
        if (this.devModeHandler != null) {
            this.devModeHandler.stop();
            this.devModeHandler = null;
        }
        if (this.themeFilesWatcher != null) {
            try {
                this.themeFilesWatcher.stop();
            }
            catch (Exception e) {
                DevModeHandlerManagerImpl.getLogger().error("Failed to stop theme files watcher", (Throwable)e);
            }
        }
    }

    public void launchBrowserInDevelopmentMode(String url) {
        this.browserLauncher.launchBrowserInDevelopmentMode(url);
    }

    private void setDevModeStarted(VaadinContext context) {
        context.setAttribute(DevModeHandlerAlreadyStartedAttribute.class, (Object)new DevModeHandlerAlreadyStartedAttribute());
    }

    public static boolean isDevModeAlreadyStarted(VaadinContext context) {
        assert (context != null);
        return context.getAttribute(DevModeHandlerAlreadyStartedAttribute.class) != null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeHandlerManagerImpl.class);
    }

    private static final class DevModeHandlerAlreadyStartedAttribute
    implements Serializable {
        private DevModeHandlerAlreadyStartedAttribute() {
        }
    }
}

