/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileWatcher
implements Serializable {
    private static final long DEFAULT_TIMEOUT = 1000L;
    private final FileAlterationMonitor monitor;
    private long timeout = 1000L;

    public FileWatcher(SerializableConsumer<File> onChangeConsumer, File ... watchDirectory) {
        this(onChangeConsumer, (SerializablePredicate<File>)(SerializablePredicate & Serializable)file -> true, watchDirectory);
    }

    public FileWatcher(SerializableConsumer<File> onChangeConsumer, SerializablePredicate<File> fileFilter, File ... watchDirectory) {
        this((FileAlterationListener)new DefaultFileListener(onChangeConsumer), fileFilter, watchDirectory);
    }

    public FileWatcher(FileAlterationListener listener, SerializablePredicate<File> fileFilter, File ... watchDirectory) {
        Objects.requireNonNull(watchDirectory, "Watch directory cannot be empty");
        if (watchDirectory.length < 1) {
            throw new IllegalArgumentException("Watch directory cannot be empty");
        }
        Objects.requireNonNull(fileFilter, "File filter cannot be empty");
        Objects.requireNonNull(listener, "File alteration listener cannot be empty");
        this.monitor = new FileAlterationMonitor(this.timeout);
        Arrays.stream(watchDirectory).forEach(dir -> {
            FileAlterationObserver observer = new FileAlterationObserver(dir, arg_0 -> fileFilter.test(arg_0));
            observer.addListener(listener);
            this.monitor.addObserver(observer);
        });
    }

    public void start() throws Exception {
        this.monitor.start();
    }

    public void stop() throws Exception {
        this.monitor.stop();
    }

    public void stop(long stopInterval) throws Exception {
        this.monitor.stop(stopInterval);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private static final class DefaultFileListener
    extends FileAlterationListenerAdaptor
    implements Serializable {
        private final SerializableConsumer<File> onChangeConsumer;

        public DefaultFileListener(SerializableConsumer<File> onChangeConsumer) {
            this.onChangeConsumer = onChangeConsumer;
        }

        public void onDirectoryChange(File directory) {
            this.onChangeConsumer.accept((Object)directory);
        }

        public void onDirectoryDelete(File directory) {
            this.onChangeConsumer.accept((Object)directory);
        }

        public void onFileChange(File file) {
            this.onChangeConsumer.accept((Object)file);
        }

        public void onFileDelete(File file) {
            this.onChangeConsumer.accept((Object)file);
        }
    }
}

