/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.internal.hilla.EndpointRequestUtil;
import com.vaadin.flow.server.Platform;
import com.vaadin.flow.server.Version;
import java.io.Serializable;
import java.util.LinkedHashSet;

public class ServerInfo
implements Serializable {
    private final String flowVersion = Version.getFullVersion();
    private final String vaadinVersion = this.fetchVaadinVersion();
    private final String javaVersion = this.fetchJavaVersion();
    private final String osVersion = this.fetchOperatingSystem();
    private final String productName = this.fetchProductName();
    private final String hillaVersion = this.fetchHillaVersion();

    private String fetchJavaVersion() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return vendor + " " + version;
    }

    private String fetchOperatingSystem() {
        String arch = System.getProperty("os.arch");
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return arch + " " + name + " " + version;
    }

    private String fetchVaadinVersion() {
        return ServerInfo.isVaadinAvailable() ? Platform.getVaadinVersion().orElse("?") : "-";
    }

    private String fetchHillaVersion() {
        return EndpointRequestUtil.isHillaAvailable() ? Platform.getHillaVersion().orElse("?") : "-";
    }

    private String fetchProductName() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (ServerInfo.isVaadinAvailable()) {
            result.add("Vaadin");
        }
        if (EndpointRequestUtil.isHillaAvailable()) {
            result.add("Hilla");
        }
        return String.join((CharSequence)",", result);
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public String getVaadinVersion() {
        return this.vaadinVersion;
    }

    public String getHillaVersion() {
        return this.hillaVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    private static boolean isVaadinAvailable() {
        return Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/com.vaadin/vaadin-core/pom.properties") != null;
    }
}

