/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.AbstractDevServerRunner;
import com.vaadin.base.devserver.BrowserLauncher;
import com.vaadin.base.devserver.DevBundleBuildingHandler;
import com.vaadin.base.devserver.ExternalDependencyWatcher;
import com.vaadin.base.devserver.ThemeLiveUpdater;
import com.vaadin.base.devserver.startup.DevModeInitializer;
import com.vaadin.base.devserver.startup.DevModeStartupListener;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.VaadinInitializerException;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeHandlerManagerImpl
implements DevModeHandlerManager {
    private DevModeHandler devModeHandler;
    private BrowserLauncher browserLauncher;
    private final Set<Closeable> watchers = new HashSet<Closeable>();

    public Class<?>[] getHandlesTypes() {
        return DevModeStartupListener.class.getAnnotation(HandlesTypes.class).value();
    }

    public void setDevModeHandler(DevModeHandler devModeHandler) {
        if (this.devModeHandler != null) {
            throw new IllegalStateException("Unable to initialize dev mode handler. A handler is already present: " + this.devModeHandler);
        }
        this.devModeHandler = devModeHandler;
    }

    public DevModeHandler getDevModeHandler() {
        return this.devModeHandler;
    }

    public void initDevModeHandler(Set<Class<?>> classes, VaadinContext context) throws VaadinInitializerException {
        this.setDevModeHandler(DevModeInitializer.initDevModeHandler(classes, context));
        CompletableFuture.runAsync(() -> {
            DevModeHandler devModeHandler = this.getDevModeHandler();
            if (devModeHandler instanceof AbstractDevServerRunner) {
                ((AbstractDevServerRunner)devModeHandler).waitForDevServer();
            } else if (devModeHandler instanceof DevBundleBuildingHandler) {
                DevBundleBuildingHandler devBundleBuilder = (DevBundleBuildingHandler)devModeHandler;
                devBundleBuilder.waitForDevBundle();
            }
            ApplicationConfiguration config = ApplicationConfiguration.get((VaadinContext)context);
            this.startWatchingThemeFolder(context, config);
            this.watchExternalDependencies(context, config);
        });
        this.setDevModeStarted(context);
        this.browserLauncher = new BrowserLauncher(context);
    }

    private void watchExternalDependencies(VaadinContext context, ApplicationConfiguration config) {
        File frontendFolder = FrontendUtils.getProjectFrontendDir((AbstractConfiguration)config);
        File jarFrontendResourcesFolder = FrontendUtils.getJarResourcesFolder((File)frontendFolder);
        this.watchers.add(new ExternalDependencyWatcher(context, jarFrontendResourcesFolder));
    }

    private void startWatchingThemeFolder(VaadinContext context, ApplicationConfiguration config) {
        if (config.getMode() != Mode.DEVELOPMENT_BUNDLE) {
            return;
        }
        try {
            Optional maybeThemeName = ThemeUtils.getThemeName((VaadinContext)context);
            if (maybeThemeName.isEmpty()) {
                DevModeHandlerManagerImpl.getLogger().debug("Found no custom theme in the project. Skipping watching the theme files");
                return;
            }
            List activeThemes = ThemeUtils.getActiveThemes((VaadinContext)context);
            for (String themeName : activeThemes) {
                File themeFolder = ThemeUtils.getThemeFolder((File)FrontendUtils.getProjectFrontendDir((AbstractConfiguration)config), (String)themeName);
                this.watchers.add(new ThemeLiveUpdater(themeFolder, context));
            }
        }
        catch (Exception e) {
            DevModeHandlerManagerImpl.getLogger().error("Failed to start live-reload for theme files", (Throwable)e);
        }
    }

    public void stopDevModeHandler() {
        if (this.devModeHandler != null) {
            this.devModeHandler.stop();
            this.devModeHandler = null;
        }
        for (Closeable watcher : this.watchers) {
            try {
                watcher.close();
            }
            catch (IOException e) {
                DevModeHandlerManagerImpl.getLogger().error("Failed to stop watcher " + watcher.getClass().getName(), (Throwable)e);
            }
        }
        this.watchers.clear();
    }

    public void launchBrowserInDevelopmentMode(String url) {
        this.browserLauncher.launchBrowserInDevelopmentMode(url);
    }

    private void setDevModeStarted(VaadinContext context) {
        context.setAttribute(DevModeHandlerAlreadyStartedAttribute.class, (Object)new DevModeHandlerAlreadyStartedAttribute());
    }

    public static boolean isDevModeAlreadyStarted(VaadinContext context) {
        assert (context != null);
        return context.getAttribute(DevModeHandlerAlreadyStartedAttribute.class) != null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(DevModeHandlerManagerImpl.class);
    }

    private static final class DevModeHandlerAlreadyStartedAttribute
    implements Serializable {
        private DevModeHandlerAlreadyStartedAttribute() {
        }
    }
}

