/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import jakarta.websocket.CloseReason;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketConnection
implements WebSocket.Listener {
    private final Consumer<String> onMessage;
    private final Runnable onClose;
    private final CompletableFuture<WebSocket> clientWebsocket = new CompletableFuture();
    private final List<CharSequence> parts = new ArrayList<CharSequence>();

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ViteWebsocketConnection.class);
    }

    public ViteWebsocketConnection(int port, String path, String subProtocol, Consumer<String> onMessage, Runnable onClose, Consumer<Throwable> onConnectionFailure) {
        this.onMessage = onMessage;
        this.onClose = onClose;
        String wsHost = "http://127.0.0.1".replace("http://", "ws://");
        URI uri = URI.create(wsHost + ":" + port + path);
        HttpClient.newHttpClient().newWebSocketBuilder().subprotocols(subProtocol, new String[0]).buildAsync(uri, this).whenComplete((webSocket, failure) -> {
            if (failure == null) {
                ViteWebsocketConnection.getLogger().debug("Connection to {} using the {} protocol established", (Object)uri, (Object)webSocket.getSubprotocol());
                if (this.clientWebsocket.complete((WebSocket)webSocket)) {
                    ViteWebsocketConnection.getLogger().trace("Websocket future completed in client build completion");
                }
            } else {
                ViteWebsocketConnection.getLogger().debug("Failed to connect to {}", (Object)uri);
                this.clientWebsocket.completeExceptionally((Throwable)failure);
                onConnectionFailure.accept((Throwable)failure);
            }
        });
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        ViteWebsocketConnection.getLogger().debug("Connected using the {} protocol", (Object)webSocket.getSubprotocol());
        if (this.clientWebsocket.complete(webSocket)) {
            ViteWebsocketConnection.getLogger().trace("Websocket future completed in onOpen");
        }
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.onClose.run();
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        if (!last) {
            ViteWebsocketConnection.getLogger().debug("Partial message from Vite: {}", (Object)data);
            this.parts.add(data);
        } else {
            Object msg = "";
            while (!this.parts.isEmpty()) {
                msg = (String)msg + this.parts.remove(0);
            }
            msg = (String)msg + data;
            ViteWebsocketConnection.getLogger().debug("Message from Vite: {}", msg);
            this.onMessage.accept((String)msg);
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    public void send(String message) throws InterruptedException, ExecutionException {
        CompletableFuture<WebSocket> send = this.clientWebsocket.get().sendText(message, false);
        send.get();
    }

    public void close() throws InterruptedException, ExecutionException {
        ViteWebsocketConnection.getLogger().debug("Closing the connection");
        if (this.clientWebsocket.isDone()) {
            WebSocket client = this.clientWebsocket.get();
            if (!client.isOutputClosed()) {
                CompletableFuture<WebSocket> closeRequest = client.sendClose(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), "");
                try {
                    closeRequest.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    ViteWebsocketConnection.getLogger().debug("Timed out waiting for close request");
                }
            }
        } else {
            this.clientWebsocket.cancel(true);
        }
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        ViteWebsocketConnection.getLogger().debug("Error from Vite websocket connection", error);
        WebSocket.Listener.super.onError(webSocket, error);
    }
}

