/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.base.devserver.DebugWindowMessage;
import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.base.devserver.DevToolsMessageHandler;
import com.vaadin.base.devserver.FeatureFlagMessage;
import com.vaadin.base.devserver.ProductAndMessage;
import com.vaadin.base.devserver.ServerInfo;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.DevToolsToken;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.communication.AtmospherePushConnection;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.Capabilities;
import com.vaadin.pro.licensechecker.Capability;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.PreTrial;
import com.vaadin.pro.licensechecker.PreTrialCreationException;
import com.vaadin.pro.licensechecker.PreTrialLicenseValidationException;
import com.vaadin.pro.licensechecker.Product;
import elemental.json.JsonObject;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugWindowConnection
implements BrowserLiveReload {
    private final ClassLoader classLoader;
    private VaadinContext context;
    private final ConcurrentHashMap<WeakReference<AtmosphereResource>, AtmospherePushConnection.FragmentedMessage> resources = new ConcurrentHashMap();
    private BrowserLiveReload.Backend backend = null;
    private static final EnumMap<BrowserLiveReload.Backend, List<String>> IDENTIFIER_CLASSES = new EnumMap(BrowserLiveReload.Backend.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private List<DevToolsMessageHandler> plugins;

    DebugWindowConnection(VaadinContext context) {
        this(DebugWindowConnection.class.getClassLoader(), context);
    }

    DebugWindowConnection(ClassLoader classLoader, VaadinContext context) {
        this.classLoader = classLoader;
        this.context = context;
        this.findPlugins();
    }

    private void findPlugins() {
        ServiceLoader<DevToolsMessageHandler> loader = ServiceLoader.load(DevToolsMessageHandler.class, this.classLoader);
        this.plugins = new ArrayList<DevToolsMessageHandler>();
        for (DevToolsMessageHandler s : loader) {
            this.plugins.add(s);
        }
    }

    public BrowserLiveReload.Backend getBackend() {
        if (this.backend != null) {
            return this.backend;
        }
        for (Map.Entry<BrowserLiveReload.Backend, List<String>> entry : IDENTIFIER_CLASSES.entrySet()) {
            BrowserLiveReload.Backend backendCandidate = entry.getKey();
            boolean found = true;
            for (String clazz : entry.getValue()) {
                try {
                    this.classLoader.loadClass(clazz);
                }
                catch (ClassNotFoundException e) {
                    DebugWindowConnection.getLogger().debug("Class {} not found, excluding {}", (Object)clazz, (Object)backendCandidate);
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            this.backend = backendCandidate;
            break;
        }
        return this.backend;
    }

    public void setBackend(BrowserLiveReload.Backend backend) {
        assert (backend != null);
        this.backend = backend;
    }

    protected DevToolsInterface getDevToolsInterface(AtmosphereResource resource) {
        return new DevToolsInterfaceImpl(this, resource);
    }

    public void onConnect(AtmosphereResource resource) {
        if (DevToolsToken.getToken().equals(resource.getRequest().getParameter("token"))) {
            this.handleConnect(resource);
        } else {
            DebugWindowConnection.getLogger().debug("Connection denied because of a missing or invalid token. Either the host is not on the 'vaadin.devmode.hosts-allowed' list or it is using an outdated token");
            try {
                resource.close();
            }
            catch (IOException e) {
                DebugWindowConnection.getLogger().debug("Error closing the denied websocket connection", (Throwable)e);
            }
        }
    }

    private void handleConnect(AtmosphereResource resource) {
        resource.suspend(-1L);
        this.resources.put(new WeakReference<AtmosphereResource>(resource), new AtmospherePushConnection.FragmentedMessage());
        resource.getBroadcaster().broadcast((Object)"{\"command\": \"hello\"}", resource);
        for (DevToolsMessageHandler plugin : this.plugins) {
            plugin.handleConnect(this.getDevToolsInterface(resource));
        }
        this.send(resource, "serverInfo", new ServerInfo());
        this.send(resource, "featureFlags", new FeatureFlagMessage(FeatureFlags.get((VaadinContext)this.context).getFeatures().stream().filter(feature -> !feature.equals((Object)FeatureFlags.EXAMPLE)).collect(Collectors.toList())));
    }

    private void send(AtmosphereResource resource, String command, Object data) {
        try {
            this.send(resource, this.objectMapper.writeValueAsString((Object)new DebugWindowMessage(command, data)));
        }
        catch (Exception e) {
            DebugWindowConnection.getLogger().error("Error sending message", (Throwable)e);
        }
    }

    private void send(AtmosphereResource resource, String json) {
        resource.getBroadcaster().broadcast((Object)json, resource);
    }

    public void onDisconnect(AtmosphereResource resource) {
        for (DevToolsMessageHandler plugin : this.plugins) {
            plugin.handleDisconnect(this.getDevToolsInterface(resource));
        }
        if (!this.resources.keySet().removeIf(resourceRef -> resource.equals(resourceRef.get()))) {
            String uuid = resource.uuid();
            DebugWindowConnection.getLogger().warn("Push connection {} is not a live-reload connection or already closed", (Object)uuid);
        }
    }

    public boolean isLiveReload(AtmosphereResource resource) {
        return this.getRef(resource) != null;
    }

    @Deprecated
    public void broadcast(JsonObject msg) {
        this.broadcast(JacksonUtils.readTree((String)msg.toJson()));
    }

    public void broadcast(ObjectNode msg) {
        ((ConcurrentHashMap.KeySetView)this.resources.keySet()).forEach(resourceRef -> {
            AtmosphereResource resource = (AtmosphereResource)resourceRef.get();
            if (resource != null) {
                resource.getBroadcaster().broadcast((Object)msg.toString(), resource);
            }
        });
    }

    public void reload() {
        ObjectNode msg = JacksonUtils.createObjectNode();
        msg.put("command", "reload");
        this.broadcast(msg);
    }

    public void refresh(boolean refreshLayouts) {
        ObjectNode msg = JacksonUtils.createObjectNode();
        msg.put("command", "reload");
        msg.put("strategy", refreshLayouts ? "full-refresh" : "refresh");
        this.broadcast(msg);
    }

    public void update(String path, String content) {
        ObjectNode msg = JacksonUtils.createObjectNode();
        msg.put("command", "update");
        msg.put("path", path);
        msg.put("content", content);
        this.broadcast(msg);
    }

    public void onMessage(AtmosphereResource resource, String message) {
        if (message.isEmpty()) {
            DebugWindowConnection.getLogger().debug("Received live reload heartbeat");
            return;
        }
        ObjectNode json = JacksonUtils.readTree((String)message);
        String command = json.get("command").textValue();
        JsonNode data = json.get("data");
        if ("setFeature".equals(command)) {
            FeatureFlags.get((VaadinContext)this.context).setEnabled(data.get("featureId").textValue(), data.get("enabled").booleanValue());
        } else if ("reportTelemetry".equals(command)) {
            DevModeUsageStatistics.handleBrowserData(data);
        } else if ("downloadLicense".equals(command)) {
            this.handleLicenseKeyDownload(resource, data);
        } else if ("checkLicense".equals(command)) {
            this.handleLicenseCheck(resource, data);
        } else if ("startPreTrialLicense".equals(command)) {
            this.handlePreTrialStart(resource, data);
        } else {
            DevToolsMessageHandler plugin;
            boolean handled = false;
            Iterator<DevToolsMessageHandler> iterator = this.plugins.iterator();
            while (iterator.hasNext() && !(handled = (plugin = iterator.next()).handleMessage(command, data, this.getDevToolsInterface(resource)))) {
            }
            if (!handled && command != null && !command.startsWith("copilot-")) {
                DebugWindowConnection.getLogger().info("Unknown command from the browser: " + command);
            }
        }
    }

    private void handleLicenseCheck(AtmosphereResource resource, JsonNode data) {
        String name = data.get("name").textValue();
        String version = data.get("version").textValue();
        Product product = new Product(name, version);
        PreTrial preTrial = null;
        String command = null;
        String errorMessage = "";
        try {
            LicenseChecker.checkLicense((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.DEVELOPMENT, null, (Capabilities)Capabilities.of((Capability)Capability.PRE_TRIAL));
        }
        catch (PreTrialLicenseValidationException e) {
            DevModeUsageStatistics.collectEvent("pre-trial/" + product.getName());
            errorMessage = e.getMessage();
            preTrial = e.getPreTrial();
            command = "license-check-nokey";
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            command = "license-check-failed";
        }
        if (command == null) {
            this.send(resource, "license-check-ok", product);
        } else {
            ProductAndMessage pm = new ProductAndMessage(product, preTrial, errorMessage);
            this.send(resource, command, pm);
        }
    }

    private void handleLicenseKeyDownload(AtmosphereResource resource, JsonNode data) {
        String name = data.get("name").textValue();
        String version = data.get("version").textValue();
        Product product = new Product(name, version);
        LicenseChecker.checkLicenseAsync((String)product.getName(), (String)product.getVersion(), (BuildType)BuildType.DEVELOPMENT, (LicenseChecker.Callback)new LicenseDownloadCallback(resource, product));
        this.send(resource, "license-download-started", product);
    }

    private void handlePreTrialStart(AtmosphereResource resource, JsonNode data) {
        try {
            PreTrial preTrial = LicenseChecker.startPreTrial();
            DevModeUsageStatistics.collectEvent("pre-trial/activated");
            this.send(resource, "license-pretrial-started", preTrial);
        }
        catch (PreTrialCreationException.Expired ex) {
            this.send(resource, "license-pretrial-expired", null);
        }
        catch (Exception ex) {
            DevModeUsageStatistics.collectEvent("pre-trial/activation-failed");
            this.send(resource, "license-pretrial-failed", null);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DebugWindowConnection.class.getName());
    }

    public AtmospherePushConnection.FragmentedMessage getOrCreateFragmentedMessage(AtmosphereResource resource) {
        WeakReference<AtmosphereResource> ref = this.getRef(resource);
        if (ref == null) {
            throw new IllegalStateException("Tried to create a fragmented message for a non-existing resource");
        }
        return this.resources.get(ref);
    }

    private WeakReference<AtmosphereResource> getRef(AtmosphereResource resource) {
        return this.resources.keySet().stream().filter(resourceRef -> resource.equals(resourceRef.get())).findFirst().orElse(null);
    }

    public void clearFragmentedMessage(AtmosphereResource resource) {
        WeakReference<AtmosphereResource> ref = this.getRef(resource);
        if (ref == null) {
            DebugWindowConnection.getLogger().debug("Tried to clear the fragmented message for a non-existing resource: {}", (Object)resource);
            return;
        }
        this.resources.put(ref, new AtmospherePushConnection.FragmentedMessage());
    }

    public void sendHmrEvent(String event, JsonNode eventData) {
        ObjectNode msg = JacksonUtils.createObjectNode();
        msg.put("command", "hmr");
        ObjectNode data = JacksonUtils.createObjectNode();
        msg.set("data", (JsonNode)data);
        data.put("event", event);
        data.set("eventData", eventData);
        this.broadcast(msg);
    }

    static {
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.JREBEL, Collections.singletonList("org.zeroturnaround.jrebel.vaadin.JRebelInitializer"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.HOTSWAP_AGENT, Collections.singletonList("org.hotswap.agent.plugin.vaadin.VaadinIntegration"));
        IDENTIFIER_CLASSES.put(BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS, Arrays.asList("com.vaadin.flow.spring.SpringServlet", "org.springframework.boot.devtools.livereload.LiveReloadServer"));
    }

    public static class DevToolsInterfaceImpl
    implements DevToolsInterface {
        private DebugWindowConnection debugWindowConnection;
        private AtmosphereResource resource;

        private DevToolsInterfaceImpl(DebugWindowConnection debugWindowConnection, AtmosphereResource resource) {
            this.debugWindowConnection = debugWindowConnection;
            this.resource = resource;
        }

        @Override
        public void send(String command, Object data) {
            ObjectNode msg = JacksonUtils.createObjectNode();
            msg.put("command", command);
            if (data instanceof JsonNode) {
                JsonNode jsonNode = (JsonNode)data;
                msg.set("data", jsonNode);
            } else if (data != null) {
                msg.set("data", (JsonNode)JacksonUtils.beanToJson((Object)data));
            }
            this.debugWindowConnection.send(this.resource, msg.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DevToolsInterfaceImpl that = (DevToolsInterfaceImpl)o;
            return Objects.equals(this.debugWindowConnection, that.debugWindowConnection) && Objects.equals(this.resource, that.resource);
        }

        public int hashCode() {
            return Objects.hash(this.debugWindowConnection, this.resource);
        }
    }

    private class LicenseDownloadCallback
    implements LicenseChecker.Callback {
        private final AtmosphereResource resource;
        private final Product product;

        public LicenseDownloadCallback(AtmosphereResource resource, Product product) {
            this.resource = resource;
            this.product = product;
        }

        public void ok() {
            DebugWindowConnection.this.send(this.resource, "license-download-completed", this.product);
        }

        public void failed(Exception e) {
            DebugWindowConnection.this.send(this.resource, "license-download-failed", this.product);
        }
    }
}

