/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.DevServerOutputTracker;
import com.vaadin.base.devserver.DevServerWatchDog;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.UrlUtil;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.FrontendVersion;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDevServerRunner
implements DevModeHandler {
    private static final String START_FAILURE = "Couldn't start dev server because";
    private static final String DEV_SERVER_HOST = "http://localhost";
    private static final String FAILED_MSG = "\n------------------ Frontend compilation failed. ------------------\n\n";
    private static final String SUCCEED_MSG = "\n----------------- Frontend compiled successfully. -----------------\n\n";
    private static final String START = "\n------------------ Starting Frontend compilation. ------------------\n";
    private static final String LOG_START = "Running {} to compile frontend resources. This may take a moment, please stand by...";
    private static final String DEFAULT_TIMEOUT_FOR_PATTERN = "60000";
    private static final String DEV_SERVER_PORTFILE_UUID_PROPERTY = "vaadin.frontend.devserver.portfile.uuid";
    private static final Pattern WEBPACK_ILLEGAL_CHAR_PATTERN = Pattern.compile("\"|%22");
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_TIMEOUT = 120000;
    private final File npmFolder;
    private volatile int port;
    private final AtomicReference<Process> devServerProcess = new AtomicReference();
    private final boolean reuseDevServer;
    private final File devServerPortFile;
    private AtomicBoolean isDevServerFailedToStart = new AtomicBoolean();
    private transient BrowserLiveReload liveReload;
    private final CompletableFuture<Void> devServerStartFuture;
    private final AtomicReference<DevServerWatchDog> watchDog = new AtomicReference();
    private boolean usingAlreadyStartedProcess = false;
    private ApplicationConfiguration applicationConfiguration;
    private String failedOutput = null;

    protected AbstractDevServerRunner(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        this.npmFolder = npmFolder;
        this.port = runningPort;
        this.applicationConfiguration = (ApplicationConfiguration)lookup.lookup(ApplicationConfiguration.class);
        this.reuseDevServer = this.applicationConfiguration.reuseDevServer();
        this.devServerPortFile = AbstractDevServerRunner.getDevServerPortFile(npmFolder);
        BrowserLiveReloadAccessor liveReloadAccess = (BrowserLiveReloadAccessor)lookup.lookup(BrowserLiveReloadAccessor.class);
        this.liveReload = liveReloadAccess != null ? liveReloadAccess.getLiveReload(this.applicationConfiguration.getContext()) : null;
        BiConsumer<Void, Throwable> action = (value, exception) -> {
            waitFor.getNow(null);
            this.runOnFutureComplete();
        };
        this.devServerStartFuture = waitFor.whenCompleteAsync((BiConsumer)action);
    }

    private void runOnFutureComplete() {
        try {
            this.doStartDevModeServer();
        }
        catch (ExecutionFailedException exception) {
            AbstractDevServerRunner.getLogger().error(null, (Throwable)exception);
            throw new CompletionException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDevModeServer() throws ExecutionFailedException {
        if (this.port > 0) {
            if (!this.checkConnection()) {
                throw new IllegalStateException(String.format("%s %s port '%d' is defined but it's not working properly", this.getServerName(), START_FAILURE, this.port));
            }
            this.reuseExistingPort(this.port);
            return;
        }
        this.port = AbstractDevServerRunner.getRunningDevServerPort(this.npmFolder);
        if (this.port > 0) {
            if (this.checkConnection()) {
                this.reuseExistingPort(this.port);
                return;
            }
            AbstractDevServerRunner.getLogger().warn(String.format("%s port '%d' is defined but it's not working properly. Using a new free port...", this.getServerName(), this.port));
            this.port = 0;
        }
        this.validateFiles();
        long start = System.nanoTime();
        AbstractDevServerRunner.getLogger().info("Starting " + this.getServerName());
        this.watchDog.set(new DevServerWatchDog());
        this.port = AbstractDevServerRunner.getFreePort();
        this.saveRunningDevServerPort();
        try {
            Process process = this.doStartDevServer();
            this.devServerProcess.set(process);
            if (!this.isRunning()) {
                throw new IllegalStateException(this.getServerName() + " exited prematurely");
            }
            long ms = (System.nanoTime() - start) / 1000000L;
            AbstractDevServerRunner.getLogger().info("Started {}. Time: {}ms", (Object)this.getServerName(), (Object)ms);
        }
        finally {
            if (this.devServerProcess.get() == null) {
                this.removeRunningDevServerPort();
            }
        }
    }

    protected void validateFiles() throws ExecutionFailedException {
        assert (this.getPort() == 0);
        File binary = this.getServerBinary();
        File config = this.getServerConfig();
        if (!this.getProjectRoot().exists()) {
            AbstractDevServerRunner.getLogger().warn("No project folder '{}' exists", (Object)this.getProjectRoot());
            throw new ExecutionFailedException("Couldn't start dev server because the target execution folder doesn't exist.");
        }
        if (!binary.exists()) {
            AbstractDevServerRunner.getLogger().warn("'{}' doesn't exist. Did you run `npm install`?", (Object)binary);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist. `npm install` has not run or failed.", START_FAILURE, binary));
        }
        if (!binary.canExecute()) {
            AbstractDevServerRunner.getLogger().warn(" '{}' is not an executable. Did you run `npm install`?", (Object)binary);
            throw new ExecutionFailedException(String.format("%s '%s' is not an executable. `npm install` has not run or failed.", START_FAILURE, binary));
        }
        if (!config.canRead()) {
            AbstractDevServerRunner.getLogger().warn("{} configuration '{}' is not found or is not readable.", (Object)this.getServerName(), (Object)config);
            throw new ExecutionFailedException(String.format("%s '%s' doesn't exist or is not readable.", START_FAILURE, config));
        }
    }

    protected abstract File getServerBinary();

    protected abstract File getServerConfig();

    protected abstract String getServerName();

    protected abstract List<String> getServerStartupCommand(String var1);

    protected void updateServerStartupEnvironment(FrontendVersion nodeVersion, Map<String, String> environment) {
        environment.put("watchDogPort", Integer.toString(this.getWatchDog().getWatchDogPort()));
    }

    protected abstract Pattern getServerSuccessPattern();

    protected abstract Pattern getServerFailurePattern();

    protected Process doStartDevServer() {
        FrontendVersion nodeVersion;
        ApplicationConfiguration config = this.getApplicationConfiguration();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(this.getProjectRoot());
        boolean useHomeNodeExec = config.getBooleanProperty("require.home.node", false);
        boolean nodeAutoUpdate = config.getBooleanProperty("node.auto.update", false);
        boolean useGlobalPnpm = config.getBooleanProperty("pnpm.global", false);
        FrontendToolsSettings settings = new FrontendToolsSettings(this.getProjectRoot().getAbsolutePath(), (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setForceAlternativeNode(useHomeNodeExec);
        settings.setAutoUpdate(nodeAutoUpdate);
        settings.setUseGlobalPnpm(useGlobalPnpm);
        FrontendTools tools = new FrontendTools(settings);
        tools.validateNodeAndNpmVersion();
        String nodeExec = null;
        nodeExec = useHomeNodeExec ? tools.forceAlternativeNodeExecutable() : tools.getNodeExecutable();
        List<String> command = this.getServerStartupCommand(nodeExec);
        FrontendUtils.console((String)"\u001b[38;5;35m%s\u001b[0m", (Object)START);
        if (AbstractDevServerRunner.getLogger().isDebugEnabled()) {
            AbstractDevServerRunner.getLogger().debug(FrontendUtils.commandToString((String)this.getProjectRoot().getAbsolutePath(), command));
        }
        processBuilder.command(command);
        Map<String, String> environment = processBuilder.environment();
        try {
            nodeVersion = tools.getNodeVersion();
        }
        catch (FrontendUtils.UnknownVersionException e) {
            AbstractDevServerRunner.getLogger().error("Unable to determine node version", (Throwable)e);
            nodeVersion = new FrontendVersion(16, 0, 0);
        }
        this.updateServerStartupEnvironment(nodeVersion, environment);
        try {
            Process process = processBuilder.redirectErrorStream(true).start();
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
            DevServerOutputTracker outputTracker = new DevServerOutputTracker(process.getInputStream(), this.getServerSuccessPattern(), this.getServerFailurePattern(), this::onDevServerCompilation);
            outputTracker.find();
            AbstractDevServerRunner.getLogger().info(LOG_START, (Object)this.getServerName());
            int timeout = Integer.parseInt(config.getStringProperty("devmode.webpack.output.pattern.timeout", DEFAULT_TIMEOUT_FOR_PATTERN));
            outputTracker.awaitFirstMatch(timeout);
            return process;
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().error("Failed to start the " + this.getServerName() + " process", (Throwable)e);
        }
        catch (InterruptedException e) {
            AbstractDevServerRunner.getLogger().debug(this.getServerName() + " process start has been interrupted", (Throwable)e);
        }
        return null;
    }

    protected void onDevServerCompilation(DevServerOutputTracker.Result result) {
        if (result.isSuccess()) {
            FrontendUtils.console((String)"\u001b[38;5;35m%s\u001b[0m", (Object)SUCCEED_MSG);
            this.failedOutput = null;
        } else {
            FrontendUtils.console((String)"\u001b[38;5;196m%s\u001b[0m", (Object)FAILED_MSG);
            this.failedOutput = result.getOutput();
        }
    }

    public String getFailedOutput() {
        return this.failedOutput;
    }

    protected DevServerWatchDog getWatchDog() {
        return this.watchDog.get();
    }

    protected void triggerLiveReload() {
        if (this.liveReload != null) {
            this.liveReload.reload();
        }
    }

    public File getProjectRoot() {
        return this.npmFolder;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected boolean checkConnection() {
        try {
            HttpURLConnection connection = this.prepareConnection("/index.html", "GET");
            return connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().debug("Error checking dev server connection", (Throwable)e);
            return false;
        }
    }

    private static int getRunningDevServerPort(File npmFolder) {
        int port = 0;
        File portFile = AbstractDevServerRunner.getDevServerPortFile(npmFolder);
        if (portFile.canRead()) {
            try {
                String portString = FileUtils.readFileToString((File)portFile, (Charset)StandardCharsets.UTF_8).trim();
                if (!portString.isEmpty()) {
                    port = Integer.parseInt(portString);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return port;
    }

    private void removeRunningDevServerPort() {
        FileUtils.deleteQuietly((File)this.devServerPortFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getFreePort() {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            int n = s.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find a free port for running the dev server", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    private void reuseExistingPort(int port) {
        AbstractDevServerRunner.getLogger().info("Reusing {} running at {}:{}", new Object[]{this.getServerName(), DEV_SERVER_HOST, port});
        this.usingAlreadyStartedProcess = true;
        this.saveRunningDevServerPort();
        this.watchDog.set(null);
    }

    private void saveRunningDevServerPort() {
        try {
            FileUtils.writeStringToFile((File)this.devServerPortFile, (String)String.valueOf(this.port), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static File getDevServerPortFile(File npmFolder) {
        String jvmUuid = System.getProperty(DEV_SERVER_PORTFILE_UUID_PROPERTY);
        if (jvmUuid == null) {
            jvmUuid = UUID.randomUUID().toString();
            System.setProperty(DEV_SERVER_PORTFILE_UUID_PROPERTY, jvmUuid);
        }
        String frontendBuildPath = npmFolder.getAbsolutePath();
        String uniqueUid = UUID.nameUUIDFromBytes((jvmUuid + frontendBuildPath).getBytes(StandardCharsets.UTF_8)).toString();
        return new File(System.getProperty("java.io.tmpdir"), uniqueUid);
    }

    public void waitForDevServer() {
        this.devServerStartFuture.join();
    }

    boolean isRunning() {
        Process process = this.devServerProcess.get();
        return process != null && process.isAlive() || this.usingAlreadyStartedProcess;
    }

    public void stop() {
        Process process;
        if (this.reuseDevServer) {
            return;
        }
        try {
            this.prepareConnection("/stop", "GET").getResponseCode();
        }
        catch (IOException e) {
            AbstractDevServerRunner.getLogger().debug(this.getServerName() + " does not support the `/stop` command.", (Throwable)e);
        }
        DevServerWatchDog watchDogInstance = this.watchDog.get();
        if (watchDogInstance != null) {
            watchDogInstance.stop();
        }
        if ((process = this.devServerProcess.get()) != null && process.isAlive()) {
            process.destroy();
        }
        this.devServerProcess.set(null);
        this.usingAlreadyStartedProcess = false;
        this.removeRunningDevServerPort();
    }

    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        URL uri = new URL("http://localhost:" + this.getPort() + path);
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        connection.setRequestMethod(method);
        connection.setReadTimeout(120000);
        connection.setConnectTimeout(120000);
        return connection;
    }

    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.devServerStartFuture.isDone()) {
            try {
                this.devServerStartFuture.getNow(null);
            }
            catch (CompletionException exception) {
                this.isDevServerFailedToStart.set(true);
                throw this.getCause(exception);
            }
            if (request.getHeader("X-DevModePoll") != null) {
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write("Ready");
                return true;
            }
            return false;
        }
        if (request.getHeader("X-DevModePoll") == null) {
            InputStream inputStream = AbstractDevServerRunner.class.getResourceAsStream("dev-mode-not-ready.html");
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.getWriter().write("Pending");
        }
        response.setContentType("text/html;charset=utf-8");
        response.setHeader("X-DevModePending", "true");
        return true;
    }

    public boolean serveDevModeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isDevServerFailedToStart.get() || !this.devServerStartFuture.isDone()) {
            return false;
        }
        String requestFilename = request.getPathInfo();
        if (HandlerHelper.isPathUnsafe((String)requestFilename) || WEBPACK_ILLEGAL_CHAR_PATTERN.matcher(requestFilename).find()) {
            AbstractDevServerRunner.getLogger().info("Blocked attempt to access file: {}", (Object)requestFilename);
            response.setStatus(403);
            return true;
        }
        if (StaticFileServer.APP_THEME_PATTERN.matcher(requestFilename).find()) {
            requestFilename = "/VAADIN/static" + requestFilename;
        }
        if (requestFilename.equals("") || requestFilename.equals("/")) {
            return false;
        }
        String devServerRequestPath = UrlUtil.encodeURI((String)requestFilename);
        if (request.getQueryString() != null) {
            devServerRequestPath = devServerRequestPath + "?" + request.getQueryString();
        }
        HttpURLConnection connection = this.prepareConnection(devServerRequestPath, request.getMethod());
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header2;
            connection.setRequestProperty(header2, "Connect".equals(header2 = (String)headerNames.nextElement()) ? "close" : request.getHeader(header2));
        }
        AbstractDevServerRunner.getLogger().debug("Requesting resource from {} {}", (Object)this.getServerName(), (Object)connection.getURL());
        int responseCode = connection.getResponseCode();
        if (responseCode == 404) {
            AbstractDevServerRunner.getLogger().debug("Resource not served by {} {}", (Object)this.getServerName(), (Object)devServerRequestPath);
            return false;
        }
        AbstractDevServerRunner.getLogger().debug("Served resource by {}: {} {}", new Object[]{this.getServerName(), responseCode, devServerRequestPath});
        connection.getHeaderFields().forEach((header, values) -> {
            if (header != null) {
                if ("Transfer-Encoding".equals(header)) {
                    return;
                }
                response.addHeader(header, (String)values.get(0));
            }
        });
        if (responseCode == 200) {
            this.writeStream(response.getOutputStream(), connection.getInputStream());
        } else if (responseCode < 400) {
            response.setStatus(responseCode);
        } else {
            response.sendError(responseCode);
        }
        response.getOutputStream().close();
        return true;
    }

    private RuntimeException getCause(Throwable exception) {
        if (exception instanceof CompletionException) {
            return this.getCause(exception.getCause());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new IllegalStateException(exception);
    }

    protected void writeStream(ServletOutputStream outputStream, InputStream inputStream) throws IOException {
        int bytes;
        byte[] buffer = new byte[32768];
        while ((bytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytes);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractDevServerRunner.class);
    }
}

