/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.AbstractDevServerRunner;
import com.vaadin.base.devserver.DevServerOutputTracker;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.FrontendVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebpackHandler
extends AbstractDevServerRunner {
    private static final String DEFAULT_OUTPUT_PATTERN = ": Compiled.";
    private static final String DEFAULT_ERROR_PATTERN = ": Failed to compile.";
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";

    public WebpackHandler(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        super(lookup, runningPort, npmFolder, waitFor);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(WebpackHandler.class);
    }

    @Override
    protected void onDevServerCompilation(DevServerOutputTracker.Result result) {
        super.onDevServerCompilation(result);
        this.triggerLiveReload();
    }

    @Override
    protected List<String> getServerStartupCommand(String nodeExec) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeExec);
        command.add(this.getServerBinary().getAbsolutePath());
        command.add("--config");
        command.add(this.getServerConfig().getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.getPort()));
        command.add("--watch-options-stdin");
        String customParameters = this.getApplicationConfiguration().getStringProperty("devmode.webpack.options", "");
        if (!customParameters.isEmpty()) {
            command.addAll(Arrays.asList(customParameters.split(" +")));
            WebpackHandler.getLogger().info("Starting {} using: {}", (Object)this.getServerName(), (Object)String.join((CharSequence)" ", command));
        } else {
            command.add("--devtool=eval-source-map");
            command.add("--mode=development");
        }
        return command;
    }

    @Override
    protected void updateServerStartupEnvironment(FrontendVersion nodeVersion, Map<String, String> environment) {
        super.updateServerStartupEnvironment(nodeVersion, environment);
        if (!nodeVersion.isOlderThan(new FrontendVersion(17, 0, 0))) {
            environment.put("NODE_OPTIONS", "--openssl-legacy-provider");
        }
    }

    @Override
    protected String getServerName() {
        return "Webpack";
    }

    @Override
    protected File getServerBinary() {
        return new File(this.getProjectRoot(), WEBPACK_SERVER);
    }

    @Override
    protected File getServerConfig() {
        return new File(this.getProjectRoot(), "webpack.config.js");
    }

    @Override
    protected Pattern getServerSuccessPattern() {
        return Pattern.compile(this.getApplicationConfiguration().getStringProperty("devmode.webpack.output.success.pattern", DEFAULT_OUTPUT_PATTERN));
    }

    @Override
    protected Pattern getServerFailurePattern() {
        return Pattern.compile(this.getApplicationConfiguration().getStringProperty("devmode.webpack.output.error.pattern", DEFAULT_ERROR_PATTERN));
    }
}

