/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.ProKey;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ProjectHelpers {
    private ProjectHelpers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String generateProjectId(String projectFolder) {
        Path gradleFile;
        Path projectPath = Paths.get(projectFolder, new String[0]);
        File pomFile = projectPath.resolve("pom.xml").toFile();
        if (pomFile.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document pom = db.parse(pomFile);
                String groupId = ProjectHelpers.getFirstElementTextByName(pom.getDocumentElement(), "groupId");
                String artifactId = ProjectHelpers.getFirstElementTextByName(pom.getDocumentElement(), "artifactId");
                return "pom" + ProjectHelpers.createHash(groupId + artifactId);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                ProjectHelpers.getLogger().debug("Failed to parse maven project id from " + pomFile.getPath(), (Throwable)e);
            }
        }
        if (!(gradleFile = projectPath.resolve("settings.gradle")).toFile().exists()) return ProjectHelpers.createHash("default-project-id");
        try (Stream<String> stream = Files.lines(gradleFile);){
            String projectName = stream.filter(line -> line.contains("rootProject.name")).findFirst().orElse("default-project-id");
            if (projectName.contains("=")) {
                projectName = projectName.substring(projectName.indexOf("=") + 1).replace('\'', ' ').trim();
            }
            String string = "gradle" + ProjectHelpers.createHash(projectName);
            return string;
        }
        catch (IOException e) {
            ProjectHelpers.getLogger().debug("Failed to parse gradle project id from " + gradleFile.toFile().getPath(), (Throwable)e);
        }
        return ProjectHelpers.createHash("default-project-id");
    }

    static String createHash(String string) {
        if (string != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(string.getBytes(StandardCharsets.UTF_8));
                byte[] digest = md.digest();
                return Hex.encodeHexString((byte[])digest);
            }
            catch (Exception e) {
                ProjectHelpers.getLogger().debug("Missing hash algorithm", (Throwable)e);
            }
        }
        return "[NA]";
    }

    static String getFirstElementTextByName(Element parent, String nodeName) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(nodeName)) continue;
            return nodeList.item(i).getTextContent();
        }
        return null;
    }

    static String getProjectSource(String projectFolder) {
        Path projectPath = Paths.get(projectFolder, new String[0]);
        try {
            String projectSource = ProjectHelpers.getMavenProjectSource(projectPath);
            if (projectSource != null) {
                return projectSource;
            }
            projectSource = ProjectHelpers.getGradleProjectSource(projectPath);
            if (projectSource != null) {
                return projectSource;
            }
        }
        catch (Exception e) {
            ProjectHelpers.getLogger().debug("Failed to parse project id from " + projectPath.toAbsolutePath(), (Throwable)e);
        }
        return "[NA]";
    }

    private static String getMavenProjectSource(Path projectPath) throws ParserConfigurationException, SAXException, IOException {
        File pomFile = projectPath.resolve("pom.xml").toFile();
        if (!pomFile.exists()) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document pom = db.parse(pomFile);
        NodeList nodeList = pom.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String comment;
            if (nodeList.item(i).getNodeType() != 8 || !(comment = nodeList.item(i).getTextContent()).contains("Vaadin project from")) continue;
            return comment.substring(comment.indexOf("Vaadin project from") + "Vaadin project from".length()).trim();
        }
        return null;
    }

    private static String getGradleProjectSource(Path projectPath) throws IOException {
        Path gradleFile = projectPath.resolve("settings.gradle");
        if (gradleFile.toFile().exists()) {
            try (Stream<String> stream = Files.lines(gradleFile);){
                String projectName = stream.filter(line -> line.contains("Vaadin project from")).findFirst().orElse(null);
                if (projectName != null) {
                    String string = projectName.substring(projectName.indexOf("Vaadin project from") + "Vaadin project from".length()).trim();
                    return string;
                }
            }
        }
        return null;
    }

    static File resolveVaadinHomeDirectory() {
        String userHome = System.getProperty("user.home");
        return new File(userHome, ".vaadin");
    }

    static File resolveStatisticsStore() {
        File vaadinHome;
        try {
            vaadinHome = ProjectHelpers.resolveVaadinHomeDirectory();
        }
        catch (Exception e) {
            ProjectHelpers.getLogger().debug("Failed to find .vaadin directory ", (Throwable)e);
            vaadinHome = null;
        }
        if (vaadinHome == null) {
            try {
                vaadinHome = File.createTempFile(".vaadin", UUID.randomUUID().toString());
                FileUtils.forceMkdir((File)vaadinHome);
            }
            catch (IOException e) {
                ProjectHelpers.getLogger().debug("Failed to create temp directory ", (Throwable)e);
                return null;
            }
        }
        return new File(vaadinHome, "usage-statistics.json");
    }

    static File resolveUserKeyLocation() {
        File vaadinHome = ProjectHelpers.resolveVaadinHomeDirectory();
        return new File(vaadinHome, "userKey");
    }

    static String getProKey() {
        ProKey proKey = ProKey.get();
        return proKey != null ? proKey.getKey() : null;
    }

    static String getUserKey() {
        ProKey localKey;
        File userKeyFile = ProjectHelpers.resolveUserKeyLocation();
        if (userKeyFile.exists()) {
            try {
                localKey = ProKey.fromFile(userKeyFile);
                if (localKey != null && localKey.getKey() != null) {
                    return localKey.getKey();
                }
            }
            catch (IOException e) {
                ProjectHelpers.getLogger().debug("Failed to load userKey", (Throwable)e);
            }
        }
        try {
            localKey = new ProKey("GENERATED", "user-" + UUID.randomUUID());
            localKey.toFile(userKeyFile);
            return localKey.getKey();
        }
        catch (IOException e) {
            ProjectHelpers.getLogger().debug("Failed to write generated userKey", (Throwable)e);
            return null;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DevModeUsageStatistics.class.getName());
    }
}

