/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dialog;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-dialog")
@NpmPackage(value="@vaadin/vaadin-dialog", version="2.4.5")
@JsModule(value="@vaadin/vaadin-dialog/src/vaadin-dialog.js")
@HtmlImport(value="frontend://bower_components/vaadin-dialog/src/vaadin-dialog.html")
public abstract class GeneratedVaadinDialog<R extends GeneratedVaadinDialog<R>>
extends Component {
    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpenedBoolean() {
        return this.getElement().getProperty("opened", false);
    }

    protected void setOpened(boolean opened) {
        this.getElement().setProperty("opened", opened);
    }

    protected String getAriaLabelString() {
        return this.getElement().getProperty("ariaLabel");
    }

    protected void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("ariaLabel", ariaLabel == null ? "" : ariaLabel);
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new OpenedChangeEvent<GeneratedVaadinDialog>(this, event.isUserOriginated())));
    }

    public static class OpenedChangeEvent<R extends GeneratedVaadinDialog<R>>
    extends ComponentEvent<R> {
        private final boolean opened;

        public OpenedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((GeneratedVaadinDialog)((Object)source)).isOpenedBoolean();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

