/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dialog;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.internal.OverlayClassListProxy;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Tag(value="vaadin-dialog")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.0.0"), @NpmPackage(value="@vaadin/dialog", version="24.0.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/dialog/src/vaadin-dialog.js"), @JsModule(value="./flow-component-renderer.js")})
public class Dialog
extends Component
implements HasComponents,
HasSize,
HasStyle,
HasThemeVariant<DialogVariant> {
    private static final String OVERLAY_LOCATOR_JS = "this.$.overlay";
    private boolean autoAddedToTheUi;
    private int onCloseConfigured;
    private String width;
    private String minWidth;
    private String maxWidth;
    private String height;
    private String minHeight;
    private String maxHeight;
    private DialogHeader dialogHeader;
    private DialogFooter dialogFooter;
    private Registration afterProgrammaticNavigationListenerRegistration;
    private Map<Element, Registration> childDetachListenerMap = new HashMap<Element, Registration>();
    private ElementDetachListener childDetachListener = (ElementDetachListener & Serializable)e -> {
        boolean childDetachedFromContainer;
        Element child = e.getSource();
        boolean bl = childDetachedFromContainer = !this.getElement().getChildren().anyMatch(containerChild -> Objects.equals(child, containerChild));
        if (childDetachedFromContainer) {
            this.childDetachListenerMap.get(child).remove();
            this.childDetachListenerMap.remove(child);
            this.updateVirtualChildNodeIds();
        }
    };

    public Dialog() {
        this.getElement().getNode().addAttachListener(this::attachComponentRenderer);
        this.setOpened(false);
        this.getElement().addEventListener("opened-changed", (DomEventListener & Serializable)event -> {
            if (!this.isOpened()) {
                this.setModality(false);
            }
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
        this.addListener(DialogResizeEvent.class, (ComponentEventListener & Serializable)event -> {
            this.width = event.getWidth();
            this.height = event.getHeight();
        });
    }

    public void setWidth(String value) {
        this.width = value;
        this.setDimension("width", value);
    }

    public void setMinWidth(String value) {
        this.minWidth = value;
        this.setDimension("min-width", value);
    }

    public void setMaxWidth(String value) {
        this.maxWidth = value;
        this.setDimension("max-width", value);
    }

    public void setHeight(String value) {
        this.height = value;
        this.setDimension("height", value);
    }

    public void setMinHeight(String value) {
        this.minHeight = value;
        this.setDimension("min-height", value);
    }

    public void setMaxHeight(String value) {
        this.maxHeight = value;
        this.setDimension("max-height", value);
    }

    public String getWidth() {
        return this.width;
    }

    public String getMinWidth() {
        return this.minWidth;
    }

    public String getMaxWidth() {
        return this.maxWidth;
    }

    public String getHeight() {
        return this.height;
    }

    public String getMinHeight() {
        return this.minHeight;
    }

    public String getMaxHeight() {
        return this.maxHeight;
    }

    public Registration addDialogCloseActionListener(ComponentEventListener<DialogCloseActionEvent> listener) {
        if (this.isOpened()) {
            this.ensureOnCloseConfigured();
        }
        Registration openedRegistration = this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> {
            if (this.isOpened()) {
                this.ensureOnCloseConfigured();
            } else {
                this.onCloseConfigured = 0;
            }
        });
        Registration registration = this.addListener(DialogCloseActionEvent.class, listener);
        return (Registration & Serializable)() -> {
            if (this.isOpened()) {
                --this.onCloseConfigured;
            }
            openedRegistration.remove();
            registration.remove();
        };
    }

    public Registration addResizeListener(ComponentEventListener<DialogResizeEvent> listener) {
        return this.addListener(DialogResizeEvent.class, listener);
    }

    public Dialog(Component ... components) {
        this();
        this.add(components);
    }

    public void add(Collection<Component> components) {
        super.add(components);
        this.updateVirtualChildNodeIds();
    }

    public void addComponentAtIndex(int index, Component component) {
        super.addComponentAtIndex(index, component);
        this.updateVirtualChildNodeIds();
    }

    public boolean isCloseOnEsc() {
        return !this.getElement().getProperty("noCloseOnEsc", false);
    }

    public void setCloseOnEsc(boolean closeOnEsc) {
        this.getElement().setProperty("noCloseOnEsc", !closeOnEsc);
    }

    public boolean isCloseOnOutsideClick() {
        return !this.getElement().getProperty("noCloseOnOutsideClick", false);
    }

    public void setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.getElement().setProperty("noCloseOnOutsideClick", !closeOnOutsideClick);
    }

    public void open() {
        this.setOpened(true);
    }

    public void close() {
        this.setOpened(false);
    }

    public void setModal(boolean modal) {
        this.getElement().setProperty("modeless", !modal);
        this.getUI().ifPresent(ui -> ui.setChildComponentModal((Component)this, modal));
    }

    public boolean isModal() {
        return !this.getElement().getProperty("modeless", false);
    }

    public void setDraggable(boolean draggable) {
        this.getElement().setProperty("draggable", draggable);
    }

    public boolean isDraggable() {
        return this.getElement().getProperty("draggable", false);
    }

    public void setResizable(boolean resizable) {
        this.getElement().setProperty("resizable", resizable);
    }

    public boolean isResizable() {
        return this.getElement().getProperty("resizable", false);
    }

    public void setHeaderTitle(String title) {
        this.getElement().setProperty("headerTitle", title);
    }

    public String getHeaderTitle() {
        return this.getElement().getProperty("headerTitle", "");
    }

    public DialogHeader getHeader() {
        if (this.dialogHeader == null) {
            this.dialogHeader = new DialogHeader(this);
        }
        return this.dialogHeader;
    }

    public DialogFooter getFooter() {
        if (this.dialogFooter == null) {
            this.dialogFooter = new DialogFooter(this);
        }
        return this.dialogFooter;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getUI().ifPresent(ui -> ui.setChildComponentModal((Component)this, visible && this.isModal()));
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        UI ui = this.getCurrentUI();
        StateTree.ExecutionRegistration addToUiRegistration = ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
            if (this.getElement().getNode().getParent() == null) {
                ui.addToModalComponent((Component)this);
                ui.setChildComponentModal((Component)this, this.isModal());
                this.autoAddedToTheUi = true;
            }
            if (this.afterProgrammaticNavigationListenerRegistration != null) {
                this.afterProgrammaticNavigationListenerRegistration.remove();
            }
        });
        if (ui.getSession() != null) {
            this.afterProgrammaticNavigationListenerRegistration = ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> {
                if (event.getLocationChangeEvent().getTrigger() == NavigationTrigger.PROGRAMMATIC) {
                    addToUiRegistration.remove();
                    this.afterProgrammaticNavigationListenerRegistration.remove();
                }
            });
        }
    }

    private void ensureOnCloseConfigured() {
        if (this.onCloseConfigured == 0) {
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.doEnsureOnCloseConfigured((UI)ui)));
        }
        ++this.onCloseConfigured;
    }

    private void doEnsureOnCloseConfigured(UI ui) {
        if (this.onCloseConfigured > 0) {
            ui.getPage().executeJs("var f = function(e) {  if (e.type == 'vaadin-overlay-escape-press' && !$0.noCloseOnEsc ||      e.type == 'vaadin-overlay-outside-click' && !$0.noCloseOnOutsideClick) {    e.preventDefault();    $0.dispatchEvent(new CustomEvent('vaadin-dialog-close-action'));  }};$0.$.overlay.addEventListener('vaadin-overlay-outside-click', f);$0.$.overlay.addEventListener('vaadin-overlay-escape-press', f);$0.addEventListener('opened-changed', function(){ if (!$0.opened) { $0.$.overlay.removeEventListener('vaadin-overlay-outside-click',f);$0.$.overlay.removeEventListener('vaadin-overlay-escape-press', f);} });", new Serializable[]{this.getElement()});
        }
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
        }
        this.setModality(opened && this.isModal());
        this.getElement().setProperty("opened", opened);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    private void setModality(boolean modal) {
        if (this.isAttached()) {
            this.getUI().ifPresent(ui -> ui.setChildComponentModal((Component)this, modal));
        }
    }

    public Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent((ComponentEvent)new OpenedChangeEvent(this, event.isUserOriginated())));
    }

    public Registration addAttachListener(ComponentEventListener<AttachEvent> listener) {
        return super.addAttachListener(listener);
    }

    public Registration addDetachListener(ComponentEventListener<DetachEvent> listener) {
        return super.addDetachListener(listener);
    }

    private void updateVirtualChildNodeIds() {
        this.getElement().getChildren().forEach(child -> {
            if (!this.childDetachListenerMap.containsKey(child)) {
                this.childDetachListenerMap.put((Element)child, child.addDetachListener(this.childDetachListener));
            }
        });
        this.getElement().setPropertyList("virtualChildNodeIds", this.getElement().getChildren().map(element -> element.getNode().getId()).collect(Collectors.toList()));
        this.getElement().callJsFunction("requestContentUpdate", new Serializable[0]);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        Shortcuts.setShortcutListenOnElement((String)OVERLAY_LOCATOR_JS, (Component)this);
        this.initHeaderFooterRenderer();
        this.updateVirtualChildNodeIds();
    }

    protected String getAriaLabel() {
        return this.getElement().getProperty("ariaLabel");
    }

    protected void setAriaLabel(String ariaLabel) {
        this.getElement().setProperty("ariaLabel", ariaLabel == null ? "" : ariaLabel);
    }

    private void initHeaderFooterRenderer() {
        if (this.dialogHeader != null) {
            this.dialogHeader.setRendererCreated(false);
            this.dialogHeader.initRenderer();
        }
        if (this.dialogFooter != null) {
            this.dialogFooter.setRendererCreated(false);
            this.dialogFooter.initRenderer();
        }
    }

    private void setDimension(String dimension, String value) {
        this.getElement().executeJs("this.$.overlay.$.overlay.style[$0]=$1", new Serializable[]{dimension, value});
    }

    private void attachComponentRenderer() {
        this.getElement().executeJs("Vaadin.FlowComponentHost.patchVirtualContainer(this)", new Serializable[0]);
        String appId = UI.getCurrent().getInternals().getAppId();
        this.getElement().executeJs("this.renderer = (root) => Vaadin.FlowComponentHost.setChildNodes($0, this.virtualChildNodeIds, root)", new Serializable[]{appId});
        this.setDimension("width", this.width);
        this.setDimension("min-width", this.minWidth);
        this.setDimension("max-width", this.maxWidth);
        this.setDimension("height", this.height);
        this.setDimension("min-height", this.minHeight);
        this.setDimension("max-height", this.maxHeight);
    }

    public void setClassName(String className) {
        this.getClassNames().clear();
        if (className != null) {
            this.addClassNames(className.split(" "));
        }
    }

    public ClassList getClassNames() {
        return new OverlayClassListProxy((HasStyle)this);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("Dialog does not support adding styles to overlay");
    }

    @DomEvent(value="resize")
    public static class DialogResizeEvent
    extends ComponentEvent<Dialog> {
        private final String width;
        private final String height;

        public DialogResizeEvent(Dialog source, boolean fromClient, @EventData(value="event.detail.width") String width, @EventData(value="event.detail.height") String height) {
            super((Component)source, fromClient);
            this.width = width;
            this.height = height;
        }

        public String getWidth() {
            return this.width;
        }

        public String getHeight() {
            return this.height;
        }
    }

    @DomEvent(value="vaadin-dialog-close-action")
    public static class DialogCloseActionEvent
    extends ComponentEvent<Dialog> {
        public DialogCloseActionEvent(Dialog source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static final class DialogHeader
    extends DialogHeaderFooter {
        private DialogHeader(Dialog dialog) {
            super("headerRenderer", dialog);
        }
    }

    public static final class DialogFooter
    extends DialogHeaderFooter {
        private DialogFooter(Dialog dialog) {
            super("footerRenderer", dialog);
        }
    }

    public static class OpenedChangeEvent
    extends ComponentEvent<Dialog> {
        private final boolean opened;

        public OpenedChangeEvent(Dialog source, boolean fromClient) {
            super((Component)source, fromClient);
            this.opened = source.isOpened();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }

    static abstract class DialogHeaderFooter
    implements Serializable {
        protected final Element root;
        private final String rendererFunction;
        private final Component dialog;
        boolean rendererCreated = false;

        protected DialogHeaderFooter(String rendererFunction, Component dialog) {
            this.rendererFunction = rendererFunction;
            this.dialog = dialog;
            this.root = new Element("div");
            this.root.getStyle().set("display", "contents");
        }

        public void add(Component ... components) {
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to add cannot be null");
                this.root.appendChild(new Element[]{component.getElement()});
            }
            if (!this.isRendererCreated()) {
                this.initRenderer();
            }
        }

        public void remove(Component ... components) {
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to remove cannot be null");
                if (!this.root.equals((Object)component.getElement().getParent())) continue;
                this.root.removeChild(new Element[]{component.getElement()});
            }
            if (this.root.getChildCount() == 0) {
                this.dialog.getElement().executeJs("this." + this.rendererFunction + " = null;", new Serializable[0]);
                this.setRendererCreated(false);
            }
        }

        public void removeAll() {
            this.root.removeAllChildren();
            this.dialog.getElement().executeJs("this." + this.rendererFunction + " = null;", new Serializable[0]);
            this.setRendererCreated(false);
        }

        void initRenderer() {
            if (this.root.getChildCount() == 0) {
                return;
            }
            this.dialog.getElement().appendChild(new Element[]{this.root});
            this.dialog.getElement().executeJs("this." + this.rendererFunction + " = (root) => {if (root.firstChild) {    return;}root.appendChild($0);}", new Serializable[]{this.root});
            this.setRendererCreated(true);
        }

        boolean isRendererCreated() {
            return this.rendererCreated;
        }

        void setRendererCreated(boolean rendererCreated) {
            this.rendererCreated = rendererCreated;
        }
    }
}

