/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.VaadinUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/vaadin/gradle/VaadinPrepareFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "vaadinPrepareFrontend", "", "vaadin-gradle-plugin"})
public class VaadinPrepareFrontendTask
extends DefaultTask {
    public VaadinPrepareFrontendTask() {
        this.setGroup("Vaadin");
        this.setDescription("checks that node and npm tools are installed, copies frontend resources available inside `.jar` dependencies to `node_modules`, and creates or updates `package.json` and `webpack.config.json` files.");
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        this.getProject().getTasks().getByName("processResources").mustRunAfter(objectArray);
        objectArray = new Object[1];
        ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        objectArray[0] = VaadinUtilsKt.getJars(VaadinUtilsKt.getRuntimeClasspath(configurationContainer));
        this.dependsOn(objectArray);
    }

    @TaskAction
    public final void vaadinPrepareFrontend() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        VaadinFlowPluginExtension extension = VaadinFlowPluginExtension.Companion.get(project);
        this.getLogger().info(Intrinsics.stringPlus((String)"Running the vaadinPrepareFrontend task with effective configuration ", (Object)extension));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        GradlePluginAdapter adapter = new GradlePluginAdapter(project2, true);
        File tokenFile = BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)((PluginAdapterBase)adapter));
        if (extension.getRequireHomeNodeExec()) {
            FrontendTools tools = VaadinUtilsKt.createFrontendTools(extension);
            tools.forceAlternativeNodeExecutable();
        }
        this.getLogger().info(Intrinsics.stringPlus((String)"Generated token file ", (Object)tokenFile));
        boolean bl = tokenFile.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "token file " + tokenFile + " doesn't exist!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BuildFrontendUtil.prepareFrontend((PluginAdapterBase)((PluginAdapterBase)adapter));
    }
}

