/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/vaadin/gradle/VaadinBuildFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "vaadinBuildFrontend", "", "vaadin-gradle-plugin"})
public class VaadinBuildFrontendTask
extends DefaultTask {
    public VaadinBuildFrontendTask() {
        this.setGroup("Vaadin");
        this.setDescription("Builds the frontend bundle with webpack");
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"classes"};
        this.dependsOn(objectArray);
        this.getProject().getTasks().withType(Jar.class, arg_0 -> VaadinBuildFrontendTask._init_$lambda$0(1.INSTANCE, arg_0));
    }

    @TaskAction
    public final void vaadinBuildFrontend() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        VaadinFlowPluginExtension extension = VaadinFlowPluginExtension.Companion.get(project);
        this.getLogger().info("Running the vaadinBuildFrontend task with effective configuration " + extension);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        GradlePluginAdapter adapter = new GradlePluginAdapter(project2, false);
        File tokenFile = BuildFrontendUtil.getTokenFile((PluginAdapterBase)((PluginAdapterBase)adapter));
        if (!tokenFile.exists()) {
            boolean bl = false;
            String string = "token file " + tokenFile + " doesn't exist!";
            throw new IllegalStateException(string.toString());
        }
        BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)adapter);
        if (adapter.generateBundle()) {
            BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)((PluginAdapterBase)adapter));
        } else {
            this.getLogger().info("Not running webpack since generateBundle is false");
        }
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)adapter);
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

