/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.PrepareFrontendInputProperties;
import com.vaadin.gradle.PrepareFrontendOutputProperties;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.VaadinUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0006H\u0017J\b\u0010\n\u001a\u00020\bH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vaadin/gradle/VaadinPrepareFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "extension", "Lcom/vaadin/gradle/VaadinFlowPluginExtension;", "inputProperties", "Lcom/vaadin/gradle/PrepareFrontendInputProperties;", "outputProperties", "Lcom/vaadin/gradle/PrepareFrontendOutputProperties;", "getTaskInputProperties", "getTaskOutputProperties", "vaadinPrepareFrontend", "", "vaadin-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nVaadinPrepareFrontendTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaadinPrepareFrontendTask.kt\ncom/vaadin/gradle/VaadinPrepareFrontendTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public class VaadinPrepareFrontendTask
extends DefaultTask {
    @NotNull
    private final VaadinFlowPluginExtension extension;
    @NotNull
    private final PrepareFrontendInputProperties inputProperties;
    @NotNull
    private final PrepareFrontendOutputProperties outputProperties;

    public VaadinPrepareFrontendTask() {
        this.setGroup("Vaadin");
        this.setDescription("checks that node and npm tools are installed, copies frontend resources available inside `.jar` dependencies to `node_modules`, and creates or updates `package.json` and `webpack.config.json` files.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.extension = VaadinFlowPluginExtension.Companion.get(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.inputProperties = new PrepareFrontendInputProperties(project2);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        this.outputProperties = new PrepareFrontendOutputProperties(project3);
        TaskContainer taskContainer = this.getProject().getTasks();
        String string = this.extension.getProcessResourcesTaskName();
        Intrinsics.checkNotNull((Object)string);
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        taskContainer.getByName(string).mustRunAfter(objectArray);
        objectArray = new Object[1];
        ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
        String string2 = this.extension.getDependencyScope();
        Intrinsics.checkNotNull((Object)string2);
        Configuration configuration = configurationContainer.getByName(string2);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(...)");
        objectArray[0] = VaadinUtilsKt.getJars(configuration);
        this.dependsOn(objectArray);
        if (this.extension.getAlwaysExecutePrepareFrontend()) {
            this.doNotTrackState("State tracking is disabled. Use the 'alwaysExecutePrepareFrontend' plugin setting to enable the feature");
        }
    }

    @Nested
    @NotNull
    public PrepareFrontendInputProperties getTaskInputProperties() {
        return this.inputProperties;
    }

    @Nested
    @NotNull
    public PrepareFrontendOutputProperties getTaskOutputProperties() {
        return this.outputProperties;
    }

    @TaskAction
    public final void vaadinPrepareFrontend() {
        Object[] objectArray = new Object[]{this.extension.getGeneratedTsFolder().getAbsolutePath()};
        this.getProject().delete(objectArray);
        this.getLogger().info("Running the vaadinPrepareFrontend task with effective configuration " + this.extension);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GradlePluginAdapter adapter = new GradlePluginAdapter(project, true);
        File tokenFile = BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)((PluginAdapterBase)adapter));
        if (this.extension.getRequireHomeNodeExec()) {
            FrontendTools tools = VaadinUtilsKt.createFrontendTools(this.extension);
            tools.forceAlternativeNodeExecutable();
        }
        this.getLogger().info("Generated token file " + tokenFile);
        if (!tokenFile.exists()) {
            boolean bl = false;
            String string = "token file " + tokenFile + " doesn't exist!";
            throw new IllegalStateException(string.toString());
        }
        BuildFrontendUtil.prepareFrontend((PluginAdapterBase)((PluginAdapterBase)adapter));
    }
}

