/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.gradle.PluginEffectiveConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vaadin/gradle/VaadinCleanTask;", "Lorg/gradle/api/DefaultTask;", "()V", "config", "Lcom/vaadin/gradle/PluginEffectiveConfiguration;", "clean", "", "vaadin-gradle-plugin"})
public class VaadinCleanTask
extends DefaultTask {
    @NotNull
    private final PluginEffectiveConfiguration config;

    public VaadinCleanTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.config = PluginEffectiveConfiguration.Companion.get$vaadin_gradle_plugin(project);
        this.setGroup("Vaadin");
        this.setDescription("Cleans the project completely and removes 'generated' folders, node_modules, src/main/bundles/, webpack.generated.js, vite.generated.js, tsconfig.json, types.d.ts, pnpm-lock.yaml, pnpmfile.js, .pnpmfile.cjs and package-lock.json");
        Object[] objectArray = new Object[]{"clean"};
        this.dependsOn(objectArray);
    }

    @TaskAction
    public final void clean() {
        Project project = this.getProject();
        Object[] objectArray = new Object[13];
        objectArray[0] = this.config.getGeneratedTsFolder();
        Object object = this.config.getFrontendDirectory().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        objectArray[1] = FilesKt.resolve((File)((File)object), (String)"generated").getAbsolutePath();
        objectArray[2] = this.getProject().getProjectDir() + "/node_modules";
        objectArray[3] = this.getProject().getProjectDir() + "/src/main/bundles/";
        objectArray[4] = this.getProject().getProjectDir() + "/src/main/dev-bundle/";
        objectArray[5] = this.getProject().getProjectDir() + "/package-lock.json";
        objectArray[6] = this.getProject().getProjectDir() + "/webpack.generated.js";
        objectArray[7] = this.getProject().getProjectDir() + "/vite.generated.js";
        objectArray[8] = this.getProject().getProjectDir() + "/.pnpmfile.cjs";
        objectArray[9] = this.getProject().getProjectDir() + "/pnpm-lock.yaml";
        objectArray[10] = this.getProject().getProjectDir() + "/pnpmfile.js";
        objectArray[11] = this.getProject().getProjectDir() + "/tsconfig.json";
        objectArray[12] = this.getProject().getProjectDir() + "/types.d.ts";
        project.delete(objectArray);
    }
}

