/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle.plugin;

import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.plugin.EngineGenerateTask;
import com.vaadin.gradle.plugin.EngineProjectExtension;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.GeneratorException;
import com.vaadin.hilla.engine.GeneratorProcessor;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/vaadin/gradle/plugin/EngineGenerateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "engineGenerate", "", "vaadin-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nEngineGenerateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EngineGenerateTask.kt\ncom/vaadin/gradle/plugin/EngineGenerateTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n37#2,2:91\n*S KotlinDebug\n*F\n+ 1 EngineGenerateTask.kt\ncom/vaadin/gradle/plugin/EngineGenerateTask\n*L\n71#1:91,2\n*E\n"})
public class EngineGenerateTask
extends DefaultTask {
    public EngineGenerateTask() {
        this.setGroup("Vaadin");
        this.setDescription("Hilla Generate Task");
        Object[] objectArray = new Object[]{"classes", "hillaConfigure"};
        this.dependsOn(objectArray);
        this.getProject().getTasks().withType(Jar.class, arg_0 -> EngineGenerateTask._init_$lambda$0(1.INSTANCE, arg_0));
    }

    @TaskAction
    public final void engineGenerate() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        EngineProjectExtension extension = EngineProjectExtension.Companion.get(project);
        this.getLogger().info("Running the engineGenerate task with effective Hilla configuration " + extension);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VaadinFlowPluginExtension vaadinExtension = VaadinFlowPluginExtension.Companion.get(project2);
        this.getLogger().info("Running the engineGenerate task with effective Vaadin configuration " + extension);
        Path path = this.getProject().getProjectDir().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path baseDir = path;
        Path path2 = baseDir.resolve((String)vaadinExtension.getProjectBuildDir().get());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path buildDir = path2;
        try {
            EngineConfiguration engineConfiguration = Objects.requireNonNull(EngineConfiguration.loadDirectory((Path)buildDir));
            Intrinsics.checkNotNullExpressionValue((Object)engineConfiguration, (String)"requireNonNull(...)");
            EngineConfiguration conf = engineConfiguration;
            List<URL> urls2 = conf.getClassPath().stream().map(arg_0 -> EngineGenerateTask.engineGenerate$lambda$1(engineGenerate.urls.1.INSTANCE, arg_0)).toList();
            Intrinsics.checkNotNull(urls2);
            Collection $this$toTypedArray$iv = urls2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            URLClassLoader classLoader = new URLClassLoader(thisCollection$iv.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Boolean isProductionMode = (Boolean)vaadinExtension.getProductionMode().getOrElse((Object)false);
            ClassLoader classLoader2 = classLoader;
            Intrinsics.checkNotNull((Object)isProductionMode);
            ParserProcessor parserProcessor = new ParserProcessor(conf, classLoader2, isProductionMode.booleanValue());
            GeneratorProcessor generatorProcessor = new GeneratorProcessor(conf, extension.getNodeCommand(), isProductionMode.booleanValue());
            parserProcessor.process();
            generatorProcessor.process();
        }
        catch (IOException e) {
            throw new GradleException("Loading saved configuration failed", (Throwable)e);
        }
        catch (GeneratorException e) {
            throw new GradleException("Execution failed", (Throwable)e);
        }
        catch (ParserException e) {
            throw new GradleException("Execution failed", (Throwable)e);
        }
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final URL engineGenerate$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (URL)$tmp0.invoke(p0);
    }
}

