/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.treegrid;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridArrayUpdater;
import com.vaadin.flow.component.treegrid.CollapseEvent;
import com.vaadin.flow.component.treegrid.ExpandEvent;
import com.vaadin.flow.component.treegrid.TreeGridArrayUpdater;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.hierarchy.HasHierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsModule(value="@vaadin/vaadin-grid/src/vaadin-grid-tree-toggle.js")
@HtmlImport(value="frontend://bower_components/vaadin-grid/src/vaadin-grid-tree-toggle.html")
public class TreeGrid<T>
extends Grid<T>
implements HasHierarchicalDataProvider<T> {
    private final ValueProvider<T, String> defaultUniqueKeyProvider = (ValueProvider & Serializable)item -> String.valueOf(item.hashCode());

    public TreeGrid() {
        super(50, (SerializableBiFunction<GridArrayUpdater.UpdateQueueData, Integer, Grid.UpdateQueue>)(SerializableBiFunction & Serializable)(x$0, x$1) -> new TreeGridUpdateQueue((GridArrayUpdater.UpdateQueueData)x$0, (int)x$1), new TreeDataCommunicatorBuilder());
        this.setUniqueKeyProperty("key");
        this.getArrayUpdater().getUpdateQueueData().setHasExpandedItems((SerializableSupplier<Boolean>)((SerializableSupplier & Serializable)() -> this.getDataCommunicator().hasExpandedItems()));
    }

    public TreeGrid(Class<T> beanType) {
        super(beanType, (SerializableBiFunction<GridArrayUpdater.UpdateQueueData, Integer, Grid.UpdateQueue>)(SerializableBiFunction & Serializable)(x$0, x$1) -> new TreeGridUpdateQueue((GridArrayUpdater.UpdateQueueData)x$0, (int)x$1), new TreeDataCommunicatorBuilder());
        this.setUniqueKeyProperty("key");
        this.getArrayUpdater().getUpdateQueueData().setHasExpandedItems((SerializableSupplier<Boolean>)((SerializableSupplier & Serializable)() -> this.getDataCommunicator().hasExpandedItems()));
    }

    @Override
    protected GridArrayUpdater createDefaultArrayUpdater(SerializableBiFunction<GridArrayUpdater.UpdateQueueData, Integer, Grid.UpdateQueue> updateQueueFactory) {
        return new TreeGridArrayUpdaterImpl(updateQueueFactory);
    }

    public TreeGrid(HierarchicalDataProvider<T, ?> dataProvider) {
        this();
        this.setDataProvider((DataProvider<T, ?>)dataProvider);
    }

    public void setUniqueKeyDataGenerator(String propertyName, ValueProvider<T, String> uniqueKeyProvider) {
        this.setUniqueKeyProperty(propertyName);
        this.setUniqueKeyProvider(uniqueKeyProvider);
        this.getDataProvider().refreshAll();
    }

    @Override
    protected ValueProvider<T, String> getUniqueKeyProvider() {
        return Optional.ofNullable(super.getUniqueKeyProvider()).orElse(this.defaultUniqueKeyProvider);
    }

    public Registration addExpandListener(ComponentEventListener<ExpandEvent<T, TreeGrid<T>>> listener) {
        return ComponentUtil.addListener((Component)this, ExpandEvent.class, listener);
    }

    public Registration addCollapseListener(ComponentEventListener<CollapseEvent<T, TreeGrid<T>>> listener) {
        return ComponentUtil.addListener((Component)this, CollapseEvent.class, listener);
    }

    @Override
    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        if (!(dataProvider instanceof HierarchicalDataProvider)) {
            throw new IllegalArgumentException("TreeGrid only accepts hierarchical data providers. An example of interface to be used: HierarchicalDataProvider");
        }
        super.setDataProvider(dataProvider);
    }

    public Grid.Column<T> addHierarchyColumn(ValueProvider<T, ?> valueProvider) {
        Grid.Column column = this.addColumn(TemplateRenderer.of((String)"<vaadin-grid-tree-toggle leaf='[[item.leaf]]' expanded='{{expanded}}' level='[[level]]'>[[item.name]]</vaadin-grid-tree-toggle>").withProperty("leaf", (ValueProvider & Serializable)item -> !this.getDataCommunicator().hasChildren(item)).withProperty("name", (ValueProvider & Serializable)value -> String.valueOf(valueProvider.apply(value))));
        SerializableComparator & Serializable comparator = (SerializableComparator & Serializable)(a, b) -> TreeGrid.compareMaybeComparables(valueProvider.apply(a), valueProvider.apply(b));
        column.setComparator(comparator);
        return column;
    }

    public Grid.Column<T> setHierarchyColumn(String propertyName) {
        return this.setHierarchyColumn(propertyName, null);
    }

    public Grid.Column<T> setHierarchyColumn(String propertyName, ValueProvider<T, ?> valueProvider) {
        List<String> currentPropertyList = this.getColumns().stream().map(Grid.Column::getKey).filter(Objects::nonNull).collect(Collectors.toList());
        this.resetColumns(propertyName, valueProvider, currentPropertyList);
        return this.getColumnByKey(propertyName);
    }

    public Grid.Column<T> setColumns(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider, Collection<String> propertyNames) {
        if (this.getPropertySet() == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type. To construct Grid from a bean type, please provide a beanType argumentto the constructor: Grid<Person> grid = new Grid<>(Person.class)");
        }
        this.resetColumns(hierarchyPropertyName, valueProvider, propertyNames);
        return this.getColumnByKey(hierarchyPropertyName);
    }

    private void resetColumns(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider, Collection<String> propertyList) {
        this.getColumns().forEach(this::removeColumn);
        propertyList.stream().distinct().forEach(key -> this.addColumn((String)key, hierarchyPropertyName, valueProvider));
    }

    private void addColumn(String key, String hierarchyPropertyName, ValueProvider<T, ?> valueProvider) {
        if (key.equals(hierarchyPropertyName)) {
            this.addHierarchyColumn(hierarchyPropertyName, valueProvider);
        } else {
            this.addColumn(key);
        }
    }

    private void addHierarchyColumn(String hierarchyPropertyName, ValueProvider<T, ?> valueProvider) {
        if (valueProvider != null) {
            this.addHierarchyColumn(valueProvider).setKey(hierarchyPropertyName);
        } else {
            this.addHierarchyColumn(hierarchyPropertyName);
        }
    }

    private Grid.Column<T> addHierarchyColumn(String propertyName) {
        PropertyDefinition property;
        if (this.getPropertySet() == null) {
            throw new UnsupportedOperationException("This method can't be used for a Grid that isn't constructed from a bean type. To construct Grid from a bean type, please provide a beanType argumentto the constructor: Grid<Person> grid = new Grid<>(Person.class)");
        }
        Objects.requireNonNull(propertyName, "Hierarchy Property name can't be null");
        try {
            property = (PropertyDefinition)this.getPropertySet().getProperty(propertyName).get();
        }
        catch (IllegalArgumentException | NoSuchElementException exception) {
            throw new IllegalArgumentException("There is no such hierarchy property name in the beanType used for construction of the grid:Trying to get '" + propertyName + "' from '" + this.getPropertySet() + "'");
        }
        return this.addHierarchyColumn(property);
    }

    private Grid.Column<T> addHierarchyColumn(PropertyDefinition<T, ?> property) {
        Grid.Column<T> column = this.addHierarchyColumn((ValueProvider & Serializable)item -> String.valueOf(property.getGetter().apply(item))).setHeader(property.getCaption());
        try {
            return column.setKey(property.getName());
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException("Multiple columns for the same property: " + property.getName());
        }
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setParentRequestedRange(int start, int length, String parentKey) {
        Object item = this.getDataCommunicator().getKeyMapper().get(parentKey);
        if (item != null) {
            this.getDataCommunicator().setParentRequestedRange(start, length, item);
        }
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setParentRequestedRanges(JsonArray array) {
        for (int index = 0; index < array.length(); ++index) {
            JsonObject object = array.getObject(index);
            this.setParentRequestedRange((int)object.getNumber("firstIndex"), (int)object.getNumber("size"), object.getString("parentKey"));
        }
    }

    @ClientCallable(value=DisabledUpdateMode.ONLY_WHEN_ENABLED)
    private void updateExpandedState(String key, boolean expanded) {
        Object item = this.getDataCommunicator().getKeyMapper().get(key);
        if (item != null) {
            if (expanded) {
                this.expand((Collection<T>)Arrays.asList(item), true);
            } else {
                this.collapse((Collection<T>)Arrays.asList(item), true);
            }
        }
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void confirmParentUpdate(int id, String parentKey) {
        this.getDataCommunicator().confirmUpdate(id, parentKey);
    }

    public void expand(T ... items) {
        this.expand((Collection<T>)Arrays.asList(items));
    }

    public void expand(Collection<T> items) {
        this.expand(items, false);
    }

    protected void expand(Collection<T> items, boolean userOriginated) {
        Collection expandedItems = this.getDataCommunicator().expand(items);
        this.fireEvent(new ExpandEvent(this, userOriginated, expandedItems));
    }

    public void expandRecursively(Stream<T> items, int depth) {
        this.expandRecursively(items.collect(Collectors.toList()), depth);
    }

    public void expandRecursively(Collection<T> items, int depth) {
        this.getDataCommunicator().expand(this.getItemsWithChildrenRecursively(items, depth));
    }

    public void collapse(T ... items) {
        this.collapse((Collection<T>)Arrays.asList(items));
    }

    public void collapse(Collection<T> items) {
        this.collapse(items, false);
    }

    protected void collapse(Collection<T> items, boolean userOriginated) {
        Collection collapsedItems = this.getDataCommunicator().collapse(items);
        this.fireEvent(new CollapseEvent(this, userOriginated, collapsedItems));
    }

    public void collapseRecursively(Stream<T> items, int depth) {
        this.collapseRecursively(items.collect(Collectors.toList()), depth);
    }

    public void collapseRecursively(Collection<T> items, int depth) {
        this.getDataCommunicator().collapse(this.getItemsWithChildrenRecursively(items, depth));
    }

    protected Collection<T> getItemsWithChildrenRecursively(Collection<T> items, int depth) {
        ArrayList itemsWithChildren = new ArrayList();
        if (depth < 0) {
            return itemsWithChildren;
        }
        items.stream().filter(arg_0 -> this.getDataCommunicator().hasChildren(arg_0)).forEach(item -> {
            itemsWithChildren.add(item);
            itemsWithChildren.addAll(this.getItemsWithChildrenRecursively(this.getDataProvider().fetchChildren(new HierarchicalQuery(null, item)).collect(Collectors.toList()), depth - 1));
        });
        return itemsWithChildren;
    }

    public boolean isExpanded(T item) {
        return this.getDataCommunicator().isExpanded(item);
    }

    @Override
    public HierarchicalDataCommunicator<T> getDataCommunicator() {
        return (HierarchicalDataCommunicator)super.getDataCommunicator();
    }

    @Override
    public HierarchicalDataProvider<T, SerializablePredicate<T>> getDataProvider() {
        if (!(super.getDataProvider() instanceof HierarchicalDataProvider)) {
            return null;
        }
        return (HierarchicalDataProvider)super.getDataProvider();
    }

    private static class TreeDataCommunicatorBuilder<T>
    extends Grid.DataCommunicatorBuilder<T, TreeGridArrayUpdater> {
        private TreeDataCommunicatorBuilder() {
        }

        @Override
        protected DataCommunicator<T> build(Element element, CompositeDataGenerator<T> dataGenerator, TreeGridArrayUpdater arrayUpdater, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
            return new HierarchicalDataCommunicator(dataGenerator, (HierarchicalArrayUpdater)arrayUpdater, (SerializableConsumer & Serializable)data -> element.callJsFunction("$connector.updateHierarchicalData", new Serializable[]{data}), element.getNode(), uniqueKeyProviderSupplier);
        }
    }

    private class TreeGridArrayUpdaterImpl
    implements TreeGridArrayUpdater {
        private GridArrayUpdater.UpdateQueueData data;
        private SerializableBiFunction<GridArrayUpdater.UpdateQueueData, Integer, Grid.UpdateQueue> updateQueueFactory;

        public TreeGridArrayUpdaterImpl(SerializableBiFunction<GridArrayUpdater.UpdateQueueData, Integer, Grid.UpdateQueue> updateQueueFactory) {
            this.updateQueueFactory = updateQueueFactory;
        }

        public TreeGridUpdateQueue startUpdate(int sizeChange) {
            return (TreeGridUpdateQueue)this.updateQueueFactory.apply((Object)this.data, (Object)sizeChange);
        }

        public void initialize() {
            TreeGrid.this.initConnector();
            TreeGrid.this.updateSelectionModeOnClient();
            TreeGrid.this.getDataCommunicator().setRequestedRange(0, TreeGrid.this.getPageSize());
        }

        @Override
        public void setUpdateQueueData(GridArrayUpdater.UpdateQueueData data) {
            this.data = data;
        }

        @Override
        public GridArrayUpdater.UpdateQueueData getUpdateQueueData() {
            return this.data;
        }
    }

    private static final class TreeGridUpdateQueue
    extends Grid.UpdateQueue
    implements HierarchicalArrayUpdater.HierarchicalUpdate {
        private TreeGridUpdateQueue(GridArrayUpdater.UpdateQueueData data, int size) {
            super(data, size);
        }

        public void set(int start, List<JsonValue> items, String parentKey) {
            this.enqueue("$connector.set", new Serializable[]{Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()), parentKey});
        }

        @Override
        public void clear(int start, int length) {
            if (!((Boolean)this.getData().getHasExpandedItems().get()).booleanValue()) {
                this.enqueue("$connector.clearExpanded", new Serializable[0]);
            }
            super.clear(start, length);
        }

        public void clear(int start, int length, String parentKey) {
            this.enqueue("$connector.clear", new Serializable[]{Integer.valueOf(start), Integer.valueOf(length), parentKey});
        }

        public void commit(int updateId, String parentKey, int levelSize) {
            this.enqueue("$connector.confirmParent", new Serializable[]{Integer.valueOf(updateId), parentKey, Integer.valueOf(levelSize)});
            this.commit();
        }
    }
}

