/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.data.provider.ComponentDataGenerator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.Optional;

class GridSorterComponentRenderer<SOURCE>
extends ComponentRenderer<Component, SOURCE> {
    private final AbstractColumn<?> column;
    private final Component component;

    public GridSorterComponentRenderer(AbstractColumn<?> column, Component component) {
        this.column = column;
        this.component = component;
    }

    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
        GridSorterComponentRendering rendering = new GridSorterComponentRendering(contentTemplate);
        container.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(container.getNode(), (SerializableConsumer & Serializable)context -> this.setupTemplateWhenAttached(context.getUI(), container, rendering, keyMapper)));
        return rendering;
    }

    private void setupTemplateWhenAttached(UI ui, Element owner, GridSorterComponentRendering rendering, DataKeyMapper<SOURCE> keyMapper) {
        String templateInnerHtml;
        String appId = ui.getInternals().getAppId();
        Element templateElement = rendering.getTemplateElement();
        owner.appendChild(new Element[]{templateElement});
        Element container = new Element("div");
        owner.appendVirtualChild(new Element[]{container});
        rendering.setContainer(container);
        if (this.component != null) {
            container.appendChild(new Element[]{this.component.getElement()});
            templateInnerHtml = String.format("<flow-component-renderer appid=\"%s\" nodeid=\"%s\"></flow-component-renderer>", appId, this.component.getElement().getNode().getId());
        } else {
            templateInnerHtml = "";
        }
        this.column.setBaseHeaderTemplate(templateInnerHtml);
        if (this.column.hasSortingIndicators()) {
            templateInnerHtml = this.column.addGridSorter(templateInnerHtml);
        }
        templateElement.setProperty("innerHTML", templateInnerHtml);
    }

    private class GridSorterComponentRendering
    extends ComponentDataGenerator<SOURCE>
    implements Rendering<SOURCE> {
        private Element templateElement;

        public GridSorterComponentRendering(Element templateElement) {
            super((ComponentRenderer)GridSorterComponentRenderer.this, null);
            this.templateElement = templateElement;
        }

        public Element getTemplateElement() {
            return this.templateElement;
        }

        public Optional<DataGenerator<SOURCE>> getDataGenerator() {
            return Optional.of(this);
        }
    }
}

