/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro;

import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.gridpro.EditorType;
import com.vaadin.flow.component.gridpro.GridPro;
import com.vaadin.flow.component.gridpro.ItemUpdater;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class EditColumnConfigurator<T>
implements Serializable {
    private final GridPro.EditColumn<T> column;

    public EditColumnConfigurator(GridPro.EditColumn<T> column) {
        assert (column != null);
        this.column = column;
    }

    private Grid.Column<T> configureColumn(ItemUpdater<T, String> itemUpdater, EditorType type, List<String> options) {
        this.column.setEditorType(type);
        this.column.setItemUpdater(itemUpdater);
        this.column.setOptions(options);
        return this.getColumn();
    }

    public Grid.Column<T> getColumn() {
        return this.column;
    }

    public Grid.Column<T> text(ItemUpdater<T, String> itemUpdater) {
        return this.configureColumn(itemUpdater, EditorType.TEXT, Collections.emptyList());
    }

    public Grid.Column<T> checkbox(ItemUpdater<T, Boolean> itemUpdater) {
        ItemUpdater<Object, String> & Serializable wrapper = (ItemUpdater<Object, String> & Serializable)(item, value) -> itemUpdater.accept(item, Boolean.valueOf(value));
        return this.configureColumn(wrapper, EditorType.CHECKBOX, Collections.emptyList());
    }

    public Grid.Column<T> select(ItemUpdater<T, String> itemUpdater, List<String> options) {
        Objects.requireNonNull(options);
        return this.configureColumn(itemUpdater, EditorType.SELECT, options);
    }

    public Grid.Column<T> select(ItemUpdater<T, String> itemUpdater, String ... options) {
        return this.select(itemUpdater, Arrays.asList(options));
    }

    public <E extends Enum<E>> Grid.Column<T> select(ItemUpdater<T, E> itemUpdater, Class<E> enumType, SerializableFunction<E, String> getStringRepresentation) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        Enum[] items = (Enum[])enumType.getEnumConstants();
        ArrayList<String> itemsList = new ArrayList<String>();
        for (Enum item2 : items) {
            String stringRepresentation = (String)getStringRepresentation.apply((Object)item2);
            if (map.containsKey(stringRepresentation)) {
                throw new IllegalArgumentException("Enum constants " + map.get(stringRepresentation) + " and " + item2 + " both have the same string representation: " + stringRepresentation);
            }
            map.put(stringRepresentation, item2);
            itemsList.add(stringRepresentation);
        }
        ItemUpdater<Object, String> & Serializable wrapper = (ItemUpdater<Object, String> & Serializable)(item, value) -> itemUpdater.accept(item, map.get(value));
        return this.select(wrapper, itemsList);
    }

    public <E extends Enum<E>> Grid.Column<T> select(ItemUpdater<T, E> itemUpdater, Class<E> enumType) {
        return this.select(itemUpdater, enumType, Object::toString);
    }
}

