/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.gridpro;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.gridpro.EditColumnConfigurator;
import com.vaadin.flow.component.gridpro.EditorType;
import com.vaadin.flow.component.gridpro.ItemUpdater;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Tag(value="vaadin-grid-pro")
@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/vaadin-grid-pro/src/vaadin-grid-pro.html"), @HtmlImport(value="frontend://bower_components/vaadin-grid-pro/src/vaadin-grid-pro-edit-column.html")})
public class GridPro<E>
extends Grid<E> {
    private Map<String, Grid.Column<E>> idToColumnMap = new HashMap<String, Grid.Column<E>>();

    public GridPro(Class<E> beanType) {
        super(beanType);
        this.setup();
    }

    public GridPro() {
        this.setup();
    }

    public GridPro(int pageSize) {
        super(pageSize);
        this.setup();
    }

    private void setup() {
        this.addItemPropertyChangedListener((ComponentEventListener & Serializable)e -> {
            EditColumn column = (EditColumn)this.idToColumnMap.get(e.getPath());
            column.getItemUpdater().accept(e.getItem(), e.getSourceItem().get(e.getPath()).asString());
        });
    }

    public EditColumnConfigurator<E> addEditColumn(ValueProvider<E, ?> valueProvider) {
        EditColumn column = (EditColumn)this.addColumn(valueProvider, this::createEditColumn);
        return new EditColumnConfigurator(column);
    }

    public EditColumnConfigurator<E> addEditColumn(Renderer<E> renderer) {
        EditColumn column = (EditColumn)this.addColumn(renderer, this::createEditColumn);
        return new EditColumnConfigurator(column);
    }

    public EditColumnConfigurator<E> addEditColumn(String propertyName) {
        EditColumn column = (EditColumn)this.addColumn(propertyName, this::createEditColumn);
        return new EditColumnConfigurator(column);
    }

    public void setEnterNextRow(boolean enterNextRow) {
        this.getElement().setProperty("enterNextRow", enterNextRow);
    }

    @Synchronize(value={"enter-next-row-changed"})
    public boolean getEnterNextRow() {
        return this.getElement().getProperty("enterNextRow", false);
    }

    public void setKeepEditorOpen(boolean keepEditorOpen) {
        this.getElement().setProperty("keepEditorOpen", keepEditorOpen);
    }

    @Synchronize(value={"keep-editor-open-changed"})
    public boolean getKeepEditorOpen() {
        return this.getElement().getProperty("keepEditorOpen", false);
    }

    protected EditColumn<E> createEditColumn(Renderer<E> renderer, String columnId) {
        EditColumn<E> column = new EditColumn<E>(this, columnId, renderer);
        this.idToColumnMap.put(columnId, column);
        return column;
    }

    public Registration addItemPropertyChangedListener(ComponentEventListener<ItemPropertyChangedEvent<E>> listener) {
        return ComponentUtil.addListener((Component)this, ItemPropertyChangedEvent.class, listener);
    }

    @DomEvent(value="item-property-changed")
    public static class ItemPropertyChangedEvent<E>
    extends ComponentEvent<GridPro<E>> {
        private E item;
        private JsonObject sourceItem;
        private String path;

        public ItemPropertyChangedEvent(GridPro<E> source, boolean fromClient, @EventData(value="event.detail.item") JsonObject item, @EventData(value="event.detail.path") String path) {
            super(source, fromClient);
            this.sourceItem = item;
            this.item = source.getDataCommunicator().getKeyMapper().get(item.getString("key"));
            this.path = path;
        }

        public E getItem() {
            return this.item;
        }

        public JsonObject getSourceItem() {
            return this.sourceItem;
        }

        public String getPath() {
            return this.path;
        }
    }

    @Tag(value="vaadin-grid-pro-edit-column")
    public static class EditColumn<T>
    extends Grid.Column<T> {
        private ItemUpdater<T, String> itemUpdater;

        public EditColumn(GridPro<T> grid, String columnId, Renderer<T> renderer) {
            super(grid, columnId, renderer);
        }

        protected EditColumn<T> setItemUpdater(ItemUpdater<T, String> itemUpdater) {
            this.itemUpdater = itemUpdater;
            return this;
        }

        protected ItemUpdater<T, String> getItemUpdater() {
            return this.itemUpdater;
        }

        protected EditColumn<T> setEditorType(EditorType type) {
            this.getElement().setProperty("editorType", type == null ? "text" : type.getTypeName());
            return this;
        }

        @Synchronize(value={"editor-type-changed"})
        protected String getEditorType() {
            return this.getElement().getProperty("editorType", "text");
        }

        protected EditColumn<T> setOptions(List<String> options) {
            this.getElement().setPropertyJson("editorOptions", (JsonValue)JsonSerializer.toJson(options));
            return this;
        }

        @Synchronize(value={"editor-options-changed"})
        protected List<String> getOptions() {
            return JsonSerializer.toObjects(String.class, (JsonArray)((JsonArray)this.getElement().getPropertyRaw("editorOptions")));
        }
    }
}

