/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.util.Locale;

@Tag(value="iron-icon")
@NpmPackage(value="@vaadin/vaadin-icons", version="20.0.0")
@JsModule(value="@vaadin/vaadin-icons/vaadin-icons.js")
public class Icon
extends Component
implements HasStyle,
ClickNotifier<Icon> {
    private static final String ICON_ATTRIBUTE_NAME = "icon";
    private static final String ICON_COLLECTION_NAME = "vaadin";

    public Icon() {
        this(VaadinIcon.VAADIN_H);
    }

    public Icon(VaadinIcon icon) {
        this(ICON_COLLECTION_NAME, icon.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public Icon(String icon) {
        this(ICON_COLLECTION_NAME, icon);
    }

    @Deprecated
    public Icon(String collection, String icon) {
        this.getElement().setAttribute(ICON_ATTRIBUTE_NAME, collection + ':' + icon);
    }

    public void setSize(String size) {
        if (size == null) {
            this.getStyle().remove("width");
            this.getStyle().remove("height");
        } else {
            this.getStyle().set("width", size);
            this.getStyle().set("height", size);
        }
    }

    public void setColor(String color) {
        if (color == null) {
            this.getStyle().remove("color");
        } else {
            this.getStyle().set("color", color);
        }
    }

    public String getColor() {
        return this.getStyle().get("color");
    }
}

