/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.component.icon;

/**
 * Enumeration of all icons in the <a href="https://vaadin.com/icons">Vaadin
 * Icons</a> collection.
 * <p>
 * These instances can be used to create {@link Icon} components either by using
 * their {@link #create()} method or by passing them to Icon's constructor.
 *
 * @author Vaadin Ltd
 *
 */
public enum VaadinIcon implements IconFactory {

    ABACUS, ABSOLUTE_POSITION, ACADEMY_CAP, ACCESSIBILITY, ACCORDION_MENU, ADD_DOCK, ADJUST, ADOBE_FLASH, AIRPLANE, ALARM, ALIGN_CENTER, ALIGN_JUSTIFY, ALIGN_LEFT, ALIGN_RIGHT, ALT_A, ALT, AMBULANCE, ANCHOR, ANGLE_DOUBLE_DOWN, ANGLE_DOUBLE_LEFT, ANGLE_DOUBLE_RIGHT, ANGLE_DOUBLE_UP, ANGLE_DOWN, ANGLE_LEFT, ANGLE_RIGHT, ANGLE_UP, ARCHIVE, ARCHIVES, AREA_SELECT, ARROW_BACKWARD, ARROW_CIRCLE_DOWN_O, ARROW_CIRCLE_DOWN, ARROW_CIRCLE_LEFT_O, ARROW_CIRCLE_LEFT, ARROW_CIRCLE_RIGHT_O, ARROW_CIRCLE_RIGHT, ARROW_CIRCLE_UP_O, ARROW_CIRCLE_UP, ARROW_DOWN, ARROW_FORWARD, ARROW_LEFT, ARROW_LONG_DOWN, ARROW_LONG_LEFT, ARROW_RIGHT, ARROW_UP, ARROWS_CROSS, ARROWS_LONG_H, ARROWS_LONG_RIGHT, ARROWS_LONG_UP, ARROWS_LONG_V, ARROWS, ASTERISK, AT, AUTOMATION, BACKSPACE_A, BACKSPACE, BACKWARDS, BAN, BAR_CHART_H, BAR_CHART_V, BAR_CHART, BARCODE, BED, BELL_O, BELL_SLASH_O, BELL_SLASH, BELL, BOAT, BOLD, BOLT, BOMB, BOOK_DOLLAR, BOOK_PERCENT, BOOK, BOOKMARK_O, BOOKMARK, BRIEFCASE, BROWSER, BUG_O, BUG, BUILDING_O, BUILDING, BULLETS, BULLSEYE, BUS,
    /**
     * @deprecated Use BUS instead.
     */
    @Deprecated
    BUSS, BUTTON, CALC_BOOK, CALC, CALENDAR_BRIEFCASE, CALENDAR_CLOCK, CALENDAR_ENVELOPE, CALENDAR_O, CALENDAR_USER, CALENDAR, CAMERA, CAR, CARET_DOWN, CARET_LEFT, CARET_RIGHT, CARET_SQUARE_DOWN_O, CARET_SQUARE_LEFT_O, CARET_SQUARE_RIGHT_O, CARET_SQUARE_UP_O, CARET_UP, CART_O, CART, CASH, CHART_3D, CHART_GRID, CHART_LINE, CHART_TIMELINE, CHART, CHAT, CHECK_CIRCLE_O, CHECK_CIRCLE, CHECK_SQUARE_O, CHECK_SQUARE, CHECK, CHEVRON_CIRCLE_DOWN_O, CHEVRON_CIRCLE_DOWN, CHEVRON_CIRCLE_LEFT_O, CHEVRON_CIRCLE_LEFT, CHEVRON_CIRCLE_RIGHT_O, CHEVRON_CIRCLE_RIGHT, CHEVRON_CIRCLE_UP_O, CHEVRON_CIRCLE_UP, CHEVRON_DOWN_SMALL, CHEVRON_DOWN, CHEVRON_LEFT_SMALL, CHEVRON_LEFT, CHEVRON_RIGHT_SMALL, CHEVRON_RIGHT, CHEVRON_UP_SMALL, CHEVRON_UP, CHILD, CIRCLE_THIN, CIRCLE, CLIPBOARD_CHECK, CLIPBOARD_CROSS, CLIPBOARD_HEART, CLIPBOARD_PULSE, CLIPBOARD_TEXT, CLIPBOARD_USER, CLIPBOARD, CLOCK, CLOSE_BIG, CLOSE_CIRCLE_O, CLOSE_CIRCLE, CLOSE_SMALL, CLOSE, CLOUD_DOWNLOAD_O, CLOUD_DOWNLOAD, CLOUD_O, CLOUD_UPLOAD_O, CLOUD_UPLOAD, CLOUD, CLUSTER, CODE, COFFEE, COG_O, COG, COGS, COIN_PILES, COINS, COMBOBOX, COMMENT_ELLIPSIS_O, COMMENT_ELLIPSIS, COMMENT_O, COMMENT, COMMENTS_O, COMMENTS, COMPILE, COMPRESS_SQUARE, COMPRESS, CONNECT_O, CONNECT, CONTROLLER, COPY_O, COPY, COPYRIGHT, CORNER_LOWER_LEFT, CORNER_LOWER_RIGHT, CORNER_UPPER_LEFT, CORNER_UPPER_RIGHT, CREDIT_CARD, CROP, CROSS_CUTLERY, CROSSHAIRS, CSS, CTRL_A, CTRL, CUBE, CUBES, CURLY_BRACKETS, CURSOR_O, CURSOR, CUTLERY, DASHBOARD, DATABASE, DATE_INPUT, DEINDENT, DEL_A, DEL, DENTAL_CHAIR, DESKTOP, DIAMOND_O, DIAMOND, DIPLOMA_SCROLL, DIPLOMA, DISC, DOCTOR_BRIEFCASE, DOCTOR, DOLLAR, DOT_CIRCLE, DOWNLOAD_ALT, DOWNLOAD, DROP, EDIT, EJECT, ELASTIC, ELLIPSIS_CIRCLE_O, ELLIPSIS_CIRCLE, ELLIPSIS_DOTS_H, ELLIPSIS_DOTS_V, ELLIPSIS_H, ELLIPSIS_V, ENTER_ARROW, ENTER, ENVELOPE_O, ENVELOPE_OPEN_O, ENVELOPE_OPEN, ENVELOPE, ENVELOPES_O, ENVELOPES, ERASER, ESC_A, ESC, EURO, EXCHANGE, EXCLAMATION_CIRCLE_O, EXCLAMATION_CIRCLE, EXCLAMATION, EXIT_O, EXIT, EXPAND_FULL, EXPAND_SQUARE, EXPAND, EXTERNAL_BROWSER, EXTERNAL_LINK, EYE_SLASH, EYE, EYEDROPPER, FACEBOOK_SQUARE, FACEBOOK, FACTORY, FAMILY, FAST_BACKWARD, FAST_FORWARD, FEMALE, FILE_ADD, FILE_CODE, FILE_FONT, FILE_MOVIE, FILE_O, FILE_PICTURE, FILE_PRESENTATION, FILE_PROCESS, FILE_REFRESH, FILE_REMOVE, FILE_SEARCH, FILE_SOUND, FILE_START, FILE_TABLE, FILE_TEXT_O, FILE_TEXT, FILE_TREE_SMALL, FILE_TREE_SUB, FILE_TREE, FILE_ZIP, FILE, FILL, FILM, FILTER, FIRE, FLAG_CHECKERED, FLAG_O, FLAG, FLASH, FLASK, FLIGHT_LANDING, FLIGHT_TAKEOFF, FLIP_H, FLIP_V, FOLDER_ADD, FOLDER_O, FOLDER_OPEN_O, FOLDER_OPEN, FOLDER_REMOVE, FOLDER_SEARCH, FOLDER, FONT, FORM, FORWARD, FROWN_O,
    /**
     * @deprecated Use FUNCTION instead.
     */
    @Deprecated
    FUNCION, FUNCTION, FUNNEL, GAMEPAD, GAVEL, GIFT, GLASS, GLASSES, GLOBE_WIRE, GLOBE, GOLF, GOOGLE_PLUS_SQUARE, GOOGLE_PLUS, GRAB, GRID_BEVEL, GRID_BIG_O, GRID_BIG, GRID_H, GRID_SMALL_O, GRID_SMALL, GRID_V, GRID, GROUP, HAMMER, HAND, HANDLE_CORNER, HANDS_UP, HANDSHAKE, HARDDRIVE_O, HARDDRIVE, HASH, HEADER, HEADPHONES, HEADSET, HEALTH_CARD, HEART_O, HEART, HOME_O, HOME, HOSPITAL, HOURGLASS_EMPTY, HOURGLASS_END, HOURGLASS_START, HOURGLASS, INBOX, INDENT, INFO_CIRCLE_O, INFO_CIRCLE, INFO, INPUT, INSERT, INSTITUTION, INVOICE, ITALIC, KEY_O, KEY, KEYBOARD_O, KEYBOARD, LAPTOP, LAYOUT, LEVEL_DOWN_BOLD, LEVEL_DOWN, LEVEL_LEFT_BOLD, LEVEL_LEFT, LEVEL_RIGHT_BOLD, LEVEL_RIGHT, LEVEL_UP_BOLD, LEVEL_UP, LIFEBUOY, LIGHTBULB, LINE_BAR_CHART, LINE_CHART, LINE_H, LINE_V, LINES_LIST, LINES, LINK, LIST_OL, LIST_SELECT, LIST_UL, LIST, LOCATION_ARROW_CIRCLE_O, LOCATION_ARROW_CIRCLE, LOCATION_ARROW, LOCK, MAGIC, MAGNET, MAILBOX, MALE, MAP_MARKER, MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, MARGIN, MEDAL,
    /**
     * @deprecated Use MEGAPHONE instead.
     */
    @Deprecated
    MEGAFONE, MEGAPHONE, MEH_O, MENU, MICROPHONE, MINUS_CIRCLE_O, MINUS_CIRCLE, MINUS_SQUARE_O, MINUS, MOBILE_BROWSER, MOBILE_RETRO, MOBILE, MODAL_LIST, MODAL, MONEY_DEPOSIT, MONEY_EXCHANGE, MONEY_WITHDRAW, MONEY, MOON_O, MOON, MORNING, MOVIE, MUSIC, MUTE, NATIVE_BUTTON, NEWSPAPER, NOTEBOOK, NURSE, OFFICE, OPEN_BOOK, OPTION_A, OPTION, OPTIONS, ORIENTATION, OUT, OUTBOX, PACKAGE, PADDING_BOTTOM, PADDING_LEFT, PADDING_RIGHT, PADDING_TOP, PADDING, PAINT_ROLL, PAINTBRUSH,
    /**
     * @deprecated Use PALETTE instead.
     */
    @Deprecated
    PALETE, PALETTE, PANEL, PAPERCLIP, PAPERPLANE_O, PAPERPLANE, PARAGRAPH, PASSWORD, PASTE, PAUSE, PENCIL, PHONE_LANDLINE, PHONE, PICTURE, PIE_BAR_CHART, PIE_CHART, PIGGY_BANK_COIN, PIGGY_BANK, PILL, PILLS, PIN_POST, PIN, PLAY_CIRCLE_O, PLAY_CIRCLE, PLAY, PLUG, PLUS_CIRCLE_O, PLUS_CIRCLE, PLUS_MINUS, PLUS_SQUARE_O, PLUS, POINTER, POWER_OFF, PRESENTATION, PRINT, PROGRESSBAR, PUZZLE_PIECE, PYRAMID_CHART, QRCODE, QUESTION_CIRCLE_O, QUESTION_CIRCLE, QUESTION, QUOTE_LEFT, QUOTE_RIGHT, RANDOM, RASTER_LOWER_LEFT, RASTER, RECORDS, RECYCLE, REFRESH, REPLY_ALL, REPLY, RESIZE_H, RESIZE_V, RETWEET, RHOMBUS, ROAD_BRANCH, ROAD_BRANCHES, ROAD_SPLIT, ROAD, ROCKET, ROTATE_LEFT, ROTATE_RIGHT, RSS_SQUARE, RSS, SAFE_LOCK, SAFE, SCALE_UNBALANCE, SCALE, SCATTER_CHART, SCISSORS, SCREWDRIVER, SEARCH_MINUS, SEARCH_PLUS, SEARCH, SELECT, SERVER, SHARE_SQUARE, SHARE, SHIELD, SHIFT_ARROW, SHIFT, SHOP, SIGN_IN_ALT, SIGN_IN, SIGN_OUT_ALT, SIGN_OUT, SIGNAL, SITEMAP, SLIDER, SLIDERS, SMILEY_O, SORT, SOUND_DISABLE, SPARK_LINE, SPECIALIST, SPINNER_ARC, SPINNER_THIRD, SPINNER, SPLINE_AREA_CHART, SPLINE_CHART, SPLIT_H, SPLIT_V, SPLIT, SPOON, SQUARE_SHADOW, STAR_HALF_LEFT_O, STAR_HALF_LEFT, STAR_HALF_RIGHT_O, STAR_HALF_RIGHT, STAR_O, STAR, START_COG, STEP_BACKWARD, STEP_FORWARD, STETHOSCOPE, STOCK, STOP_COG, STOP, STOPWATCH, STORAGE, STRIKETHROUGH, SUBSCRIPT, SUITCASE, SUN_DOWN, SUN_O, SUN_RISE, SUPERSCRIPT, SWORD, TAB_A, TAB, TABLE, TABLET, TABS, TAG, TAGS, TASKS, TAXI, TEETH, TERMINAL, TEXT_HEIGHT, TEXT_INPUT, TEXT_LABEL, TEXT_WIDTH, THIN_SQUARE, THUMBS_DOWN_O, THUMBS_DOWN, THUMBS_UP_O, THUMBS_UP, TICKET, TIME_BACKWARD, TIME_FORWARD, TIMER, TOOLBOX, TOOLS, TOOTH, TOUCH, TRAIN, TRASH, TREE_TABLE,
    /**
     * @deprecated Use TRENDING_DOWN instead.
     */
    @Deprecated
    TRENDIND_DOWN, TRENDING_DOWN, TRENDING_UP, TROPHY, TRUCK, TWIN_COL_SELECT, TWITTER_SQUARE, TWITTER, UMBRELLA, UNDERLINE, UNLINK, UNLOCK, UPLOAD_ALT, UPLOAD, USER_CARD, USER_CHECK, USER_CLOCK, USER_HEART, USER_STAR, USER, USERS, VAADIN_H, VAADIN_V, VIEWPORT, VIMEO_SQUARE, VIMEO, VOLUME_DOWN, VOLUME_OFF, VOLUME_UP, VOLUME, WALLET, WARNING, WORKPLACE, WRENCH, YOUTUBE_SQUARE, YOUTUBE;

    /**
     * Creates a new {@link Icon} instance with the icon determined by the name
     * of this instance.
     *
     * @return a new instance of {@link Icon} component
     */
    public Icon create() {
        return new Icon(this);
    }
}
