/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.HasTooltip;
import java.util.Locale;

@Tag(value="vaadin-icon")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.0.0"), @NpmPackage(value="@vaadin/icons", version="24.0.0"), @NpmPackage(value="@vaadin/icon", version="24.0.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/icons/vaadin-iconset.js"), @JsModule(value="@vaadin/icon/vaadin-icon.js")})
public class Icon
extends Component
implements HasStyle,
ClickNotifier<Icon>,
HasTooltip {
    private static final String ICON_ATTRIBUTE_NAME = "icon";
    private static final String ICON_COLLECTION_NAME = "vaadin";
    private static final String STYLE_FILL = "fill";

    public Icon() {
        this(VaadinIcon.VAADIN_H);
    }

    public Icon(VaadinIcon icon) {
        this(ICON_COLLECTION_NAME, icon.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public Icon(String icon) {
        this(ICON_COLLECTION_NAME, icon);
    }

    public Icon(String collection, String icon) {
        this.getElement().setAttribute(ICON_ATTRIBUTE_NAME, collection + ":" + icon);
    }

    public void setSize(String size) {
        if (size == null) {
            this.getStyle().remove("width");
            this.getStyle().remove("height");
        } else {
            this.getStyle().set("width", size);
            this.getStyle().set("height", size);
        }
    }

    public void setColor(String color) {
        if (color == null) {
            this.getStyle().remove(STYLE_FILL);
        } else {
            this.getStyle().set(STYLE_FILL, color);
        }
    }

    public String getColor() {
        return this.getStyle().get(STYLE_FILL);
    }
}

