/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.icon;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.AbstractIcon;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.util.Locale;

@NpmPackage(value="@vaadin/icons", version="24.3.16")
@JsModule(value="@vaadin/icons/vaadin-iconset.js")
public class Icon
extends AbstractIcon<Icon> {
    private static final String ICON_ATTRIBUTE_NAME = "icon";
    private static final String ICON_COLLECTION_NAME = "vaadin";
    private static final String STYLE_FILL = "fill";

    public Icon() {
        this(VaadinIcon.VAADIN_H);
    }

    public Icon(VaadinIcon icon) {
        this(ICON_COLLECTION_NAME, icon.name().toLowerCase(Locale.ENGLISH).replace('_', '-'));
    }

    public Icon(String icon) {
        this(ICON_COLLECTION_NAME, icon);
    }

    public Icon(String collection, String icon) {
        this.getElement().setAttribute(ICON_ATTRIBUTE_NAME, collection + ":" + icon);
    }

    @Override
    public void setColor(String color) {
        if (color == null) {
            this.getStyle().remove(STYLE_FILL);
        } else {
            this.getStyle().set(STYLE_FILL, color);
        }
    }

    @Override
    public String getColor() {
        return this.getStyle().get(STYLE_FILL);
    }
}

