/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.listbox.VaadinItem;
import com.vaadin.flow.component.listbox.dataview.ListBoxDataView;
import com.vaadin.flow.component.listbox.dataview.ListBoxListDataView;
import com.vaadin.flow.data.binder.HasItemComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.DataViewUtils;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.HasListDataView;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-list-box")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.2.10"), @NpmPackage(value="@vaadin/list-box", version="23.2.10"), @NpmPackage(value="@vaadin/vaadin-list-box", version="23.2.10")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/list-box/src/vaadin-list-box.js")})
public abstract class ListBoxBase<C extends ListBoxBase<C, ITEM, VALUE>, ITEM, VALUE>
extends AbstractSinglePropertyField<C, VALUE>
implements HasItemComponents<ITEM>,
HasSize,
HasListDataView<ITEM, ListBoxListDataView<ITEM>>,
HasDataView<ITEM, Void, ListBoxDataView<ITEM>>,
HasStyle {
    private final AtomicReference<DataProvider<ITEM, ?>> dataProvider = new AtomicReference<ListDataProvider>(DataProvider.ofItems((Object[])new Object[0]));
    private List<ITEM> items;
    private ItemLabelGenerator<ITEM> itemLabelGenerator = String::valueOf;
    private ComponentRenderer<? extends Component, ITEM> itemRenderer = new TextRenderer(this.itemLabelGenerator);
    private SerializablePredicate<ITEM> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();
    private Registration dataProviderListenerRegistration;
    private int lastNotifiedDataSize = -1;
    private volatile int lastFetchedDataSize = -1;
    private SerializableConsumer<UI> sizeRequest;

    <P> ListBoxBase(String propertyName, Class<P> elementPropertyType, VALUE defaultValue, SerializableBiFunction<C, P, VALUE> presentationToModel, SerializableBiFunction<C, VALUE, P> modelToPresentation) {
        super(propertyName, defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
    }

    @Deprecated
    public void setDataProvider(DataProvider<ITEM, ?> dataProvider) {
        this.dataProvider.set(Objects.requireNonNull(dataProvider));
        DataViewUtils.removeComponentFilterAndSortComparator((Component)this);
        this.clear();
        this.rebuild();
        this.setupDataProviderListener(this.dataProvider.get());
    }

    private void setupDataProviderListener(DataProvider<ITEM, ?> dataProvider) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
        }
        this.dataProviderListenerRegistration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.refresh(((DataChangeEvent.DataRefreshEvent)event).getItem());
            } else {
                this.clear();
                this.rebuild();
            }
        });
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getDataProvider() != null) {
            this.setupDataProviderListener(this.getDataProvider());
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        if (this.dataProviderListenerRegistration != null) {
            this.dataProviderListenerRegistration.remove();
            this.dataProviderListenerRegistration = null;
        }
        super.onDetach(detachEvent);
    }

    @Deprecated
    public DataProvider<ITEM, ?> getDataProvider() {
        return this.dataProvider.get();
    }

    public ComponentRenderer<? extends Component, ITEM> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, ITEM> itemRenderer) {
        this.itemRenderer = Objects.requireNonNull(itemRenderer);
        this.getItemComponents().forEach(this::refreshContent);
    }

    public void setItemLabelGenerator(ItemLabelGenerator<ITEM> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.setRenderer((ComponentRenderer<? extends Component, ITEM>)new TextRenderer(this.itemLabelGenerator));
    }

    public ItemLabelGenerator<ITEM> getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemEnabledProvider(SerializablePredicate<ITEM> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    public SerializablePredicate<ITEM> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        throw new UnsupportedOperationException("Not supported by the client-side web-component: https://github.com/vaadin/vaadin-list-box/issues/19");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        this.removeAll();
        AtomicReference<DataProvider<ITEM, ?>> atomicReference = this.dataProvider;
        synchronized (atomicReference) {
            AtomicInteger itemCounter = new AtomicInteger(0);
            this.items = this.getDataProvider().fetch(DataViewUtils.getQuery((Component)this)).collect(Collectors.toList());
            this.items.stream().map(this::createItemComponent).forEach(component -> {
                this.add(new Component[]{component});
                itemCounter.incrementAndGet();
            });
            this.lastFetchedDataSize = itemCounter.get();
            if (this.sizeRequest == null) {
                this.sizeRequest = (SerializableConsumer & Serializable)ui -> {
                    this.fireSizeEvent();
                    this.sizeRequest = null;
                };
                this.runBeforeClientResponse(this.sizeRequest);
            }
        }
    }

    private VaadinItem<ITEM> createItemComponent(ITEM item) {
        VaadinItem<ITEM> itemComponent = new VaadinItem<ITEM>(item);
        this.refresh(itemComponent);
        return itemComponent;
    }

    private void refresh(ITEM item) {
        this.getItemComponents().stream().filter(vaadinItem -> this.getItemId(vaadinItem.getItem()).equals(this.getItemId(item))).findFirst().ifPresent(this::refresh);
    }

    private void refresh(VaadinItem<ITEM> itemComponent) {
        this.refreshContent(itemComponent);
        this.refreshEnabled(itemComponent);
    }

    private void refreshContent(VaadinItem<ITEM> itemComponent) {
        itemComponent.removeAll();
        itemComponent.add(new Component[]{this.itemRenderer.createComponent(itemComponent.getItem())});
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    private void refreshEnabled(VaadinItem<ITEM> itemComponent) {
        itemComponent.setEnabled(this.itemEnabledProvider.test(itemComponent.getItem()));
    }

    List<ITEM> getItems() {
        return this.items;
    }

    List<VaadinItem<ITEM>> getItemComponents() {
        return this.getChildren().filter(VaadinItem.class::isInstance).map(component -> (VaadinItem)((Object)component)).collect(Collectors.toList());
    }

    public ListBoxDataView<ITEM> setItems(DataProvider<ITEM, Void> dataProvider) {
        this.setDataProvider(dataProvider);
        return this.getGenericDataView();
    }

    public ListBoxDataView<ITEM> setItems(InMemoryDataProvider<ITEM> inMemoryDataProvider) {
        DataProviderWrapper convertedDataProvider = new DataProviderWrapper<ITEM, Void, SerializablePredicate<ITEM>>((DataProvider)inMemoryDataProvider, (InMemoryDataProvider)inMemoryDataProvider){
            final /* synthetic */ InMemoryDataProvider val$inMemoryDataProvider;
            {
                this.val$inMemoryDataProvider = inMemoryDataProvider;
                super(arg0);
            }

            protected SerializablePredicate<ITEM> getFilter(Query<ITEM, Void> query) {
                return Optional.ofNullable(this.val$inMemoryDataProvider.getFilter()).orElse((SerializablePredicate & Serializable)item -> true);
            }
        };
        return this.setItems((DataProvider<ITEM, Void>)convertedDataProvider);
    }

    public ListBoxListDataView<ITEM> setItems(ListDataProvider<ITEM> listDataProvider) {
        this.setDataProvider((DataProvider<ITEM, ?>)listDataProvider);
        return this.getListDataView();
    }

    @Deprecated
    public void setItems(Stream<ITEM> streamOfItems) {
        this.setItems((ListDataProvider<ITEM>)DataProvider.fromStream(streamOfItems));
    }

    public ListBoxListDataView<ITEM> getListDataView() {
        return new ListBoxListDataView(this::getDataProvider, this, (SerializableBiConsumer & Serializable)(filter, sorting) -> this.rebuild());
    }

    public ListBoxDataView<ITEM> getGenericDataView() {
        return new ListBoxDataView(this::getDataProvider, this);
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    private void fireSizeEvent() {
        int newSize = this.lastFetchedDataSize;
        if (this.lastNotifiedDataSize != newSize) {
            this.lastNotifiedDataSize = newSize;
            this.fireEvent((ComponentEvent)new ItemCountChangeEvent((Component)this, newSize, false));
        }
    }

    protected Object getItemId(ITEM item) {
        return this.getIdentifierProvider().apply(item);
    }

    private IdentifierProvider<ITEM> getIdentifierProvider() {
        IdentifierProvider identifierProviderObject = (IdentifierProvider)ComponentUtil.getData((Component)this, IdentifierProvider.class);
        if (identifierProviderObject != null) {
            return identifierProviderObject;
        }
        DataProvider<ITEM, ?> dataProvider = this.getDataProvider();
        if (dataProvider != null) {
            return arg_0 -> dataProvider.getId(arg_0);
        }
        return IdentifierProvider.identity();
    }
}

