/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

@Tag(value="vaadin-login-overlay")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="22.0.16"), @NpmPackage(value="@vaadin/login", version="22.0.16"), @NpmPackage(value="@vaadin/vaadin-login", version="22.0.16")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/login/src/vaadin-login-overlay.js")})
public class LoginOverlay
extends AbstractLogin {
    private Component title;
    private boolean autoAddedToTheUi;

    public LoginOverlay() {
        this.initEnsureDetachListener();
    }

    public LoginOverlay(LoginI18n i18n) {
        super(i18n);
        this.initEnsureDetachListener();
    }

    private void initEnsureDetachListener() {
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
            this.setEnabled(true);
        }
        this.getElement().setProperty("opened", opened);
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.add(new Component[]{this});
                this.autoAddedToTheUi = true;
            });
        }
    }

    public void setTitle(String title) {
        this.setTitle((Component)null);
        this.getElement().setProperty("title", title);
    }

    @Synchronize(property="title", value={"title-changed"})
    public String getTitleAsText() {
        if (this.title != null) {
            return this.title.getElement().getText();
        }
        return this.getElement().getProperty("title");
    }

    public void setTitle(Component title) {
        if (this.isOpened()) {
            return;
        }
        if (this.title != null) {
            this.title.getElement().removeFromParent();
        }
        this.title = title;
        if (title == null) {
            return;
        }
        title.getElement().setAttribute("slot", "title");
        this.getElement().appendChild(new Element[]{title.getElement()});
    }

    public Component getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.getElement().setProperty("description", description);
    }

    @Synchronize(property="description", value={"description-changed"})
    public String getDescription() {
        return this.getElement().getProperty("description");
    }
}

