/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.login.AbstractLogin;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.internal.OverlayClassListProxy;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-login-overlay")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.5"), @NpmPackage(value="@vaadin/login", version="24.2.5")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/login/src/vaadin-login-overlay.js")})
public class LoginOverlay
extends AbstractLogin
implements HasStyle {
    private Component title;
    private LoginOverlayFooter footer;
    private LoginOverlayCustomFormArea customFormArea;
    private boolean autoAddedToTheUi;
    private Registration afterProgrammaticNavigationListenerRegistration;

    public LoginOverlay() {
        this.initEnsureDetachListener();
    }

    public LoginOverlay(LoginI18n i18n) {
        super(i18n);
        this.initEnsureDetachListener();
    }

    private void initEnsureDetachListener() {
        this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> {
            if (this.autoAddedToTheUi && !this.isOpened()) {
                this.getElement().removeFromParent();
                this.autoAddedToTheUi = false;
            }
        });
    }

    public void close() {
        this.setOpened(false);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setOpened(boolean opened) {
        if (opened) {
            this.ensureAttached();
            this.setEnabled(true);
        }
        this.getElement().setProperty("opened", opened);
    }

    private UI getCurrentUI() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            throw new IllegalStateException("UI instance is not available. It means that you are calling this method out of a normal workflow where it's always implicitly set. That may happen if you call the method from the custom thread without 'UI::access' or from tests without proper initialization.");
        }
        return ui;
    }

    private void ensureAttached() {
        if (this.getElement().getNode().getParent() == null) {
            UI ui = this.getCurrentUI();
            StateTree.ExecutionRegistration addToUiRegistration = ui.beforeClientResponse((Component)ui, (SerializableConsumer & Serializable)context -> {
                ui.addToModalComponent((Component)this);
                this.autoAddedToTheUi = true;
                if (this.afterProgrammaticNavigationListenerRegistration != null) {
                    this.afterProgrammaticNavigationListenerRegistration.remove();
                }
            });
            if (ui.getSession() != null) {
                this.afterProgrammaticNavigationListenerRegistration = ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> {
                    if (event.getLocationChangeEvent().getTrigger() == NavigationTrigger.PROGRAMMATIC) {
                        addToUiRegistration.remove();
                        this.afterProgrammaticNavigationListenerRegistration.remove();
                    }
                });
            }
        }
    }

    public void setTitle(String title) {
        this.setTitle((Component)null);
        this.getElement().setProperty("title", title);
    }

    @Synchronize(property="title", value={"title-changed"})
    public String getTitleAsText() {
        if (this.title != null) {
            return this.title.getElement().getText();
        }
        return this.getElement().getProperty("title");
    }

    public void setTitle(Component title) {
        if (this.isOpened()) {
            return;
        }
        if (this.title != null) {
            this.title.getElement().removeFromParent();
        }
        this.title = title;
        if (title == null) {
            return;
        }
        SlotUtils.addToSlot((HasElement)this, (String)"title", (Component[])new Component[]{title});
    }

    public Component getTitle() {
        return this.title;
    }

    public void setDescription(String description) {
        this.getElement().setProperty("description", description);
    }

    @Synchronize(property="description", value={"description-changed"})
    public String getDescription() {
        return this.getElement().getProperty("description");
    }

    public LoginOverlayCustomFormArea getCustomFormArea() {
        if (this.customFormArea == null) {
            this.customFormArea = new LoginOverlayCustomFormArea(this);
        }
        return this.customFormArea;
    }

    public LoginOverlayFooter getFooter() {
        if (this.footer == null) {
            this.footer = new LoginOverlayFooter(this);
        }
        return this.footer;
    }

    public void setClassName(String className) {
        this.getClassNames().clear();
        if (className != null) {
            this.addClassNames(className.split(" "));
        }
    }

    public ClassList getClassNames() {
        return new OverlayClassListProxy((HasStyle)this);
    }

    public Style getStyle() {
        throw new UnsupportedOperationException("LoginOverlay does not support adding styles to overlay wrapper");
    }

    public static final class LoginOverlayCustomFormArea
    extends LoginOverlayContent {
        private LoginOverlayCustomFormArea(LoginOverlay overlay) {
            super("custom-form-area", overlay);
        }
    }

    public static final class LoginOverlayFooter
    extends LoginOverlayContent {
        private LoginOverlayFooter(LoginOverlay overlay) {
            super("footer", overlay);
        }
    }

    static abstract class LoginOverlayContent
    implements Serializable {
        private final LoginOverlay overlay;
        private final String slot;

        protected LoginOverlayContent(String slot, LoginOverlay overlay) {
            this.slot = slot;
            this.overlay = overlay;
        }

        public void add(Component ... components) {
            if (this.overlay.isOpened()) {
                throw new UnsupportedOperationException("LoginOverlay does not support adding content when opened");
            }
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to add cannot be null");
                SlotUtils.addToSlot((HasElement)this.overlay, (String)this.slot, (Component[])new Component[]{component});
            }
        }

        public void remove(Component ... components) {
            if (this.overlay.isOpened()) {
                throw new UnsupportedOperationException("LoginOverlay does not support removing content when opened");
            }
            Objects.requireNonNull(components, "Components should not be null");
            for (Component component : components) {
                Objects.requireNonNull(component, "Component to remove cannot be null");
                Element element = component.getElement();
                if (!this.overlay.getElement().equals((Object)element.getParent()) || !Objects.equals(element.getAttribute("slot"), this.slot)) continue;
                element.removeAttribute("slot");
                this.overlay.getElement().removeChild(new Element[]{element});
            }
        }

        public void removeAll() {
            if (this.overlay.isOpened()) {
                throw new UnsupportedOperationException("LoginOverlay does not support removing content when opened");
            }
            SlotUtils.clearSlot((HasElement)this.overlay, (String)this.slot);
        }
    }
}

