/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.login;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonNull;
import elemental.json.JsonValue;
import java.io.Serializable;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogin
extends Component
implements HasEnabled {
    private static final String LOGIN_EVENT = "login";
    private static final String PROP_ACTION = "action";
    private static final String PROP_DISABLED = "disabled";
    private static final String PROP_ERROR = "error";
    private static final String PROP_NO_FORGOT_PASSWORD = "noForgotPassword";
    private static final PropertyChangeListener NO_OP = (PropertyChangeListener & Serializable)event -> {};
    private Registration registration;

    public AbstractLogin() {
        this(LoginI18n.createDefault());
        this.getElement().setProperty("_preventAutoEnable", true);
        this.registerDefaultLoginListener();
    }

    public AbstractLogin(LoginI18n i18n) {
        this.setI18n(i18n);
    }

    private void registerDefaultLoginListener() {
        DomListenerRegistration disabledPropertyRegistration = this.getElement().addPropertyChangeListener(PROP_DISABLED, LOGIN_EVENT, NO_OP);
        Registration loginListenerRegistration = this.addLoginListener((ComponentEventListener<LoginEvent>)(ComponentEventListener & Serializable)e -> {
            this.setEnabled(false);
            this.setError(false);
        });
        this.registration = Registration.combine((Registration[])new Registration[]{disabledPropertyRegistration, loginListenerRegistration});
    }

    public void setAction(String action) {
        if (action == null) {
            this.getElement().removeProperty(PROP_ACTION);
            if (this.registration == null) {
                this.registerDefaultLoginListener();
            }
        } else {
            this.getElement().setProperty(PROP_ACTION, action);
            if (this.registration != null) {
                this.registration.remove();
                this.registration = null;
            }
            this.warnIfActionAndLoginListenerUsedTogether();
        }
    }

    public String getAction() {
        return this.getElement().getProperty(PROP_ACTION, "");
    }

    public void setError(boolean error) {
        if (error) {
            this.setEnabled(true);
        }
        this.getElement().setProperty(PROP_ERROR, error);
    }

    @Synchronize(property="error", value={"error-changed"})
    public boolean isError() {
        return this.getElement().getProperty(PROP_ERROR, false);
    }

    public void setForgotPasswordButtonVisible(boolean forgotPasswordButtonVisible) {
        this.getElement().setProperty(PROP_NO_FORGOT_PASSWORD, !forgotPasswordButtonVisible);
    }

    public boolean isForgotPasswordButtonVisible() {
        return !this.getElement().getProperty(PROP_NO_FORGOT_PASSWORD, false);
    }

    public void setI18n(LoginI18n i18n) {
        this.getElement().setPropertyJson("i18n", JsonSerializer.toJson((Object)i18n));
    }

    LoginI18n getI18n() {
        JsonValue json = (JsonValue)this.getElement().getPropertyRaw("i18n");
        if (json == null || json instanceof JsonNull) {
            return null;
        }
        return (LoginI18n)JsonSerializer.toObject(LoginI18n.class, (JsonValue)json);
    }

    public void showErrorMessage(String title, String message) {
        LoginI18n loginI18n = this.getI18n();
        if (loginI18n == null) {
            loginI18n = LoginI18n.createDefault();
        }
        if (loginI18n.getErrorMessage() == null) {
            loginI18n.setErrorMessage(new LoginI18n.ErrorMessage());
        }
        loginI18n.getErrorMessage().setTitle(title);
        loginI18n.getErrorMessage().setMessage(message);
        this.setI18n(loginI18n);
        this.setError(true);
    }

    public Registration addLoginListener(ComponentEventListener<LoginEvent> listener) {
        Registration registration = ComponentUtil.addListener((Component)this, LoginEvent.class, listener);
        this.warnIfActionAndLoginListenerUsedTogether();
        return registration;
    }

    public Registration addForgotPasswordListener(ComponentEventListener<ForgotPasswordEvent> listener) {
        return ComponentUtil.addListener((Component)this, ForgotPasswordEvent.class, listener, domReg -> domReg.setDisabledUpdateMode(DisabledUpdateMode.ALWAYS));
    }

    public void onEnabledStateChanged(boolean enabled) {
        this.getElement().setProperty(PROP_DISABLED, !enabled);
    }

    private void warnIfActionAndLoginListenerUsedTogether() {
        if (this.getElement().hasProperty(PROP_ACTION) && !this.getListeners(LoginEvent.class).isEmpty()) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Using the action attribute together with login listeners is discouraged. See the AbstractLogin JavaDoc for more information. This may throw an exception in the future.");
        }
    }

    @DomEvent(value="login")
    public static class LoginEvent
    extends ComponentEvent<AbstractLogin> {
        private String username;
        private String password;

        public LoginEvent(AbstractLogin source, boolean fromClient, @EventData(value="event.detail.username") String username, @EventData(value="event.detail.password") String password) {
            super((Component)source, fromClient);
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }

    @DomEvent(value="forgot-password")
    public static class ForgotPasswordEvent
    extends ComponentEvent<AbstractLogin> {
        public ForgotPasswordEvent(AbstractLogin source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

