/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

@Element(value="vaadin-map")
public class MapElement
extends TestBenchElement {
    public MapReference getMapReference() {
        ExpressionExecutor expressionExecutor = new ExpressionExecutor(this);
        return new MapReference(expressionExecutor, "map");
    }

    public void clickAtCoordinates(double x, double y) {
        Rectangle mapRectangle = this.getRect();
        int startLeft = -mapRectangle.width / 2;
        int startTop = -mapRectangle.height / 2;
        List pixelCoordinates = (List)this.executeScript("return arguments[0].configuration.getPixelFromCoordinate([arguments[1], arguments[2]])", new Object[]{this, x, y});
        int clickX = startLeft + ((Number)pixelCoordinates.get(0)).intValue();
        int clickY = startTop + ((Number)pixelCoordinates.get(1)).intValue();
        new Actions(this.getDriver()).moveToElement((WebElement)this, clickX, clickY).click().build().perform();
    }

    public TestBenchElement getAttributionContainer() {
        return this.$("div").attributeContains("class", "ol-attribution").first();
    }

    public List<TestBenchElement> getAttributionItems() {
        return this.getAttributionContainer().$("li").all();
    }

    public void disableInteractions() {
        String script = "const interactions = arguments[0].configuration.getInteractions();interactions.forEach(interaction => interaction.setActive && interaction.setActive(false));";
        this.executeScript(script, new Object[]{this});
    }

    public static class IconReference
    extends ConfigurationObjectReference {
        private IconReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public double getOpacity() {
            return this.getDouble("getOpacity()", new Object[0]);
        }

        public double getRotation() {
            return this.getDouble("getRotation()", new Object[0]);
        }

        public double getScale() {
            return this.getDouble("getScale()", new Object[0]);
        }

        public String getColor() {
            if (this.get("getColor()", new Object[0]) == null) {
                return null;
            }
            int r = this.getInt("getColor()[0]", new Object[0]);
            int g = this.getInt("getColor()[1]", new Object[0]);
            int b = this.getInt("getColor()[2]", new Object[0]);
            return String.format("rgb(%s, %s, %s)", r, g, b);
        }

        public String getSrc() {
            return this.getString("getSrc()", new Object[0]);
        }
    }

    public static class GeometryReference
    extends ConfigurationObjectReference {
        private GeometryReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public Coordinate getCoordinates() {
            return new Coordinate(this.getDouble("getCoordinates()[0]", new Object[0]), this.getDouble("getCoordinates()[1]", new Object[0]));
        }
    }

    public static class StyleReference
    extends ConfigurationObjectReference {
        private StyleReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public IconReference getImage() {
            return new IconReference(this.executor, this.path("getImage()", new Object[0]));
        }
    }

    public static class FeatureReference
    extends ConfigurationObjectReference {
        private FeatureReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public GeometryReference getGeometry() {
            return new GeometryReference(this.executor, this.path("getGeometry()", new Object[0]));
        }

        public StyleReference getStyle() {
            return new StyleReference(this.executor, this.path("getStyle()", new Object[0]));
        }
    }

    public static class FeatureCollectionReference
    extends ConfigurationObjectReference {
        private FeatureCollectionReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public long getLength() {
            return this.getLong("getLength()", new Object[0]);
        }

        public FeatureReference getFeature(int index) {
            return new FeatureReference(this.executor, this.path("item(%s)", index));
        }
    }

    public static class VectorSourceReference
    extends SourceReference {
        private VectorSourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public FeatureCollectionReference getFeatures() {
            return new FeatureCollectionReference(this.executor, this.path("getFeaturesCollection()", new Object[0]));
        }
    }

    public static class ImageWmsSourceReference
    extends SourceReference {
        private ImageWmsSourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public String getUrl() {
            return this.getString("url_", new Object[0]);
        }

        public Object getParam(String name) {
            return this.get("params_['%s']", name);
        }

        public String getServerType() {
            return this.getString("serverType_", new Object[0]);
        }

        public String getCrossOrigin() {
            return this.getString("crossOrigin_", new Object[0]);
        }

        public float getRatio() {
            return this.getFloat("ratio_", new Object[0]).floatValue();
        }
    }

    public static class TileWmsSourceReference
    extends UrlTileSourceReference {
        private TileWmsSourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public Object getParam(String name) {
            return this.get("params_['%s']", name);
        }

        public String getServerType() {
            return this.getString("serverType_", new Object[0]);
        }
    }

    public static class XyzSourceReference
    extends UrlTileSourceReference {
        private XyzSourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }
    }

    public static abstract class UrlTileSourceReference
    extends SourceReference {
        private UrlTileSourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public String getPrimaryUrl() {
            return this.getString("getUrls()[0]", new Object[0]);
        }
    }

    public static class SourceReference
    extends ConfigurationObjectReference {
        private SourceReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public XyzSourceReference asXyzSource() {
            return new XyzSourceReference(this.executor, this.expression);
        }

        public TileWmsSourceReference asTileWmsSource() {
            return new TileWmsSourceReference(this.executor, this.expression);
        }

        public ImageWmsSourceReference asImageWmsSource() {
            return new ImageWmsSourceReference(this.executor, this.expression);
        }

        public VectorSourceReference asVectorSource() {
            return new VectorSourceReference(this.executor, this.expression);
        }
    }

    public static class LayerReference
    extends ConfigurationObjectReference {
        private LayerReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public SourceReference getSource() {
            return new SourceReference(this.executor, this.path("getSource()", new Object[0]));
        }

        public boolean isVisible() {
            return this.getBoolean("getVisible()", new Object[0]);
        }

        public float getOpacity() {
            return this.getFloat("getOpacity()", new Object[0]).floatValue();
        }

        public Long getZIndex() {
            return this.getLong("getZIndex()", new Object[0]);
        }
    }

    public static class LayerCollectionReference
    extends ConfigurationObjectReference {
        private LayerCollectionReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public long getLength() {
            return this.getLong("getLength()", new Object[0]);
        }

        public LayerReference getLayer(int index) {
            return new LayerReference(this.executor, this.path("item(%s)", index));
        }

        public LayerReference getLayer(String id) {
            return new LayerReference(this.executor, this.path("getArray().find(layer => layer.id === '%s')", id));
        }
    }

    public static class ViewReference
    extends ConfigurationObjectReference {
        private ViewReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public Coordinate getCenter() {
            return new Coordinate(this.getDouble("getCenter()[0]", new Object[0]), this.getDouble("getCenter()[1]", new Object[0]));
        }

        public void setCenter(Coordinate coordinate) {
            this.executor.executeScript(this.path("setCenter([%s, %s])", coordinate.getX(), coordinate.getY()));
        }

        public float getZoom() {
            return this.getFloat("getZoom()", new Object[0]).floatValue();
        }

        public void setZoom(float zoom) {
            this.executor.executeScript(this.path("setZoom(%s)", Float.valueOf(zoom)));
        }

        public float getRotation() {
            return this.getFloat("getRotation()", new Object[0]).floatValue();
        }

        public void setRotation(float rotation) {
            this.executor.executeScript(this.path("setRotation(%s)", Float.valueOf(rotation)));
        }
    }

    public static class MapReference
    extends ConfigurationObjectReference {
        private MapReference(ExpressionExecutor executor, String expression) {
            super(executor, expression);
        }

        public ViewReference getView() {
            return new ViewReference(this.executor, this.path("getView()", new Object[0]));
        }

        public LayerCollectionReference getLayers() {
            return new LayerCollectionReference(this.executor, this.path("getLayers()", new Object[0]));
        }
    }

    public static class Coordinate {
        private final double x;
        private final double y;

        public Coordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    public static abstract class ConfigurationObjectReference {
        ExpressionExecutor executor;
        String expression;

        private ConfigurationObjectReference(ExpressionExecutor executor, String expression) {
            this.executor = executor;
            this.expression = expression;
        }

        public String path(String path, Object ... args) {
            return this.expression + "." + String.format(path, args);
        }

        public Object get(String path, Object ... args) {
            String expression = this.path(path, args);
            return this.executor.executeExpression(expression);
        }

        public boolean getBoolean(String path, Object ... args) {
            return (Boolean)this.get(path, args);
        }

        public String getString(String path, Object ... args) {
            return (String)this.get(path, args);
        }

        public Integer getInt(String path, Object ... args) {
            Number number = (Number)this.get(path, args);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }

        public Long getLong(String path, Object ... args) {
            Number number = (Number)this.get(path, args);
            return number != null ? Long.valueOf(number.longValue()) : null;
        }

        public Float getFloat(String path, Object ... args) {
            Number number = (Number)this.get(path, args);
            return number != null ? Float.valueOf(number.floatValue()) : null;
        }

        public Double getDouble(String path, Object ... args) {
            Number number = (Number)this.get(path, args);
            return number != null ? Double.valueOf(number.doubleValue()) : null;
        }

        public String getTypeName() {
            return this.getString("typeName", new Object[0]);
        }

        public boolean exists() {
            return (Boolean)this.executor.executeExpression("!!" + this.expression);
        }
    }

    private static class ExpressionExecutor {
        private final MapElement mapElement;

        private ExpressionExecutor(MapElement mapElement) {
            this.mapElement = mapElement;
        }

        public Object executeScript(String script) {
            return this.mapElement.executeScript("const map = arguments[0].configuration;" + script, new Object[]{this.mapElement});
        }

        public Object executeExpression(String expression) {
            return this.mapElement.executeScript("const map = arguments[0].configuration; return " + expression, new Object[]{this.mapElement});
        }
    }
}

