/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import com.google.common.collect.ImmutableMap;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.plugin.common.AnnotationValuesExtractor;
import com.vaadin.flow.plugin.common.BundleConfigurationReader;
import com.vaadin.flow.plugin.common.ClassPathIntrospector;
import com.vaadin.flow.plugin.common.ThemedURLTranslator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FrontendDataProvider {
    private final boolean shouldBundle;
    private final boolean shouldMinify;
    private final boolean shouldHash;
    private final Map<String, Set<File>> fragments;
    private final Set<File> shellFileImports;

    public FrontendDataProvider(boolean shouldBundle, boolean shouldMinify, boolean shouldHash, File es6SourceDirectory, AnnotationValuesExtractor annotationValuesExtractor, File fragmentConfigurationFile, Map<String, Set<String>> userDefinedFragments) {
        this.shouldBundle = shouldBundle;
        this.shouldMinify = shouldMinify;
        this.shouldHash = shouldHash;
        this.fragments = shouldBundle ? this.resolveFragmentFiles(es6SourceDirectory, fragmentConfigurationFile, userDefinedFragments) : Collections.emptyMap();
        this.shellFileImports = this.resolveShellFileImports(es6SourceDirectory, annotationValuesExtractor, this.fragments.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public boolean shouldBundle() {
        return this.shouldBundle;
    }

    public boolean shouldMinify() {
        return this.shouldMinify;
    }

    public boolean shouldHash() {
        return this.shouldHash;
    }

    public Set<String> createFragmentFiles(File targetDirectory) {
        return this.fragments.entrySet().stream().map(entry -> this.createFragmentFile(targetDirectory, (String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    public String createShellFile(File targetDirectory) {
        Path shellFile = targetDirectory.toPath().resolve("vaadin-flow-bundle.html");
        try {
            Files.write(shellFile, this.getShellFileImports(targetDirectory), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create shell file '%s'", shellFile), e);
        }
        return shellFile.toAbsolutePath().toString();
    }

    protected ThemedURLTranslator getTranslator(File es6SourceDirectory, ClassPathIntrospector introspector) {
        return new ThemedURLTranslator(url -> new File(es6SourceDirectory, this.removeFlowPrefixes((String)url)), introspector);
    }

    private Map<String, Set<File>> resolveFragmentFiles(File es6SourceDirectory, File fragmentConfigurationFile, Map<String, Set<String>> userFragments) {
        HashMap result = new HashMap();
        if (fragmentConfigurationFile != null && fragmentConfigurationFile.isFile()) {
            new BundleConfigurationReader(fragmentConfigurationFile).getFragments().forEach((fragmentName, fragmentPaths) -> result.merge(fragmentName, this.findInSourceDirectory(es6SourceDirectory, (Set<String>)fragmentPaths), this::mergeSets));
        }
        userFragments.forEach((fragmentName, fragmentPaths) -> result.merge(fragmentName, this.findInSourceDirectory(es6SourceDirectory, (Set<String>)fragmentPaths), this::mergeSets));
        return Collections.unmodifiableMap(result);
    }

    private Set<File> findInSourceDirectory(File es6SourceDirectory, Set<String> fragmentPaths) {
        return fragmentPaths.stream().map(fragmentPath -> this.getFileFromSourceDirectory(es6SourceDirectory, (String)fragmentPath)).collect(Collectors.toSet());
    }

    private File getFileFromSourceDirectory(File es6SourceDirectory, String fragmentImportPath) {
        File fragmentFile = new File(es6SourceDirectory, fragmentImportPath);
        if (!fragmentFile.isFile()) {
            throw new IllegalArgumentException(String.format("The fragment file path '%s' was resolved to '%s', which either does not exist or not a file.", fragmentImportPath, fragmentFile));
        }
        return fragmentFile;
    }

    private <T> Set<T> mergeSets(Set<T> one, Set<T> two) {
        HashSet<T> result = new HashSet<T>(one);
        result.addAll(two);
        return result;
    }

    private Set<File> resolveShellFileImports(File es6SourceDirectory, AnnotationValuesExtractor annotationValuesExtractor, Set<File> fragmentFiles) {
        Map<Class<? extends Annotation>, Set<String>> annotationValues = annotationValuesExtractor.extractAnnotationValues((Map<Class<? extends Annotation>, String>)ImmutableMap.of(StyleSheet.class, (Object)"value", JavaScript.class, (Object)"value"));
        Collection<Set<String>> htmlImports = annotationValuesExtractor.extractAnnotationValues(Collections.singletonMap(HtmlImport.class, "value")).values();
        Set<String> htmlImportUrls = htmlImports.isEmpty() ? Collections.emptySet() : htmlImports.iterator().next();
        annotationValues.put(HtmlImport.class, this.getTranslator(es6SourceDirectory, annotationValuesExtractor).applyTheme(htmlImportUrls));
        return annotationValues.values().stream().flatMap(Collection::stream).map(this::removeFlowPrefixes).map(annotationImport -> this.getFileFromSourceDirectory(es6SourceDirectory, (String)annotationImport)).filter(fileInSourceDirectory -> !fragmentFiles.contains(fileInSourceDirectory)).collect(Collectors.toSet());
    }

    private String removeFlowPrefixes(String url) {
        return url.replace("context://", "").replace("frontend://", "").replace("base://", "");
    }

    private String createFragmentFile(File targetDirectory, String fragmentName, Set<File> filesFromFragment) {
        List fragmentImports = filesFromFragment.stream().map(fileFromFragment -> this.relativeToTargetDirectory(targetDirectory, (File)fileFromFragment)).map(this::toFrontendImport).collect(Collectors.toList());
        String fragmentFileName = fragmentName.endsWith(".html") ? fragmentName : fragmentName + ".html";
        Path fragmentFile = targetDirectory.toPath().resolve(fragmentFileName);
        try {
            Files.write(fragmentFile, fragmentImports, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create fragment file '%s'", fragmentFile), e);
        }
        return fragmentFile.toString();
    }

    private List<String> getShellFileImports(File targetDirectory) {
        return this.shellFileImports.stream().map(fileNotInFragments -> this.relativeToTargetDirectory(targetDirectory, (File)fileNotInFragments)).map(this::toFrontendImport).collect(Collectors.toList());
    }

    private String relativeToTargetDirectory(File targetDirectory, File fragmentFilePath) {
        return targetDirectory.toPath().relativize(fragmentFilePath.toPath()).toString();
    }

    private String toFrontendImport(String importToFormat) {
        String importWithReplacedBackslashes = importToFormat.replace("\\", "/");
        if (importToFormat.endsWith(".js")) {
            return String.format("<script type='text/javascript' src='%s'></script>", importWithReplacedBackslashes);
        }
        if (importToFormat.endsWith(".css")) {
            return String.format("<link rel='stylesheet' href='%s'>", importWithReplacedBackslashes);
        }
        return String.format("<link rel='import' href='%s'>", importWithReplacedBackslashes);
    }
}

