/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.production;

import com.vaadin.flow.plugin.common.ArtifactData;
import java.util.Objects;

public class WebJarPackage {
    private final ArtifactData webJar;
    private final String packageName;
    private final String pathToPackage;

    public WebJarPackage(ArtifactData webJar, String packageName, String pathToPackage) {
        this.webJar = Objects.requireNonNull(webJar);
        this.packageName = Objects.requireNonNull(packageName);
        this.pathToPackage = Objects.requireNonNull(pathToPackage);
    }

    public ArtifactData getWebJar() {
        return this.webJar;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPathToPackage() {
        return this.pathToPackage;
    }

    public static WebJarPackage selectCorrectPackage(WebJarPackage package1, WebJarPackage package2) {
        String normalizedVersion2;
        if (!Objects.equals(package1.packageName, package2.packageName)) {
            throw new IllegalArgumentException(String.format("Cannot process packages with different names: '%s' and '%s'", package1.packageName, package2.packageName));
        }
        String normalizedVersion1 = WebJarPackage.normalizeVersion(package1.webJar.getVersion());
        if (Objects.equals(normalizedVersion1, normalizedVersion2 = WebJarPackage.normalizeVersion(package2.webJar.getVersion()))) {
            return Objects.equals(normalizedVersion1, package1.webJar.getVersion()) ? package1 : package2;
        }
        throw new IllegalArgumentException(String.format("Two webJars have same name and different versions: '%s' and '%s', there should be no version differences", package1.webJar, package2.webJar));
    }

    private static String normalizeVersion(String version) {
        if (version.charAt(0) == 'v') {
            return version.substring(1);
        }
        return version;
    }
}

