/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.production;

import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.vaadin.flow.plugin.common.FrontendToolsManager;
import java.io.File;
import java.util.Map;
import java.util.Objects;

public class TranspilationStep {
    private final FrontendToolsManager frontendToolsManager;

    public TranspilationStep(FrontendToolsManager frontendToolsManager, ProxyConfig proxyConfig, String nodeVersion, String yarnVersion, int networkConcurrency) {
        this.frontendToolsManager = Objects.requireNonNull(frontendToolsManager);
        frontendToolsManager.installFrontendTools(proxyConfig, nodeVersion, yarnVersion, networkConcurrency);
    }

    public void transpileFiles(File es6SourceDirectory, File outputDirectory, boolean skipEs5) {
        Map<String, File> transpilationResult = this.frontendToolsManager.transpileFiles(es6SourceDirectory, outputDirectory, skipEs5);
        if (transpilationResult.isEmpty()) {
            throw new IllegalStateException("Received no transpilation results from frontend tools");
        }
        transpilationResult.values().stream().filter(configurationOutput -> !configurationOutput.isDirectory()).findAny().ifPresent(nonExistingDirectory -> {
            throw new IllegalStateException(String.format("Transpilation output at '%s' is not a directory or does not exist", nonExistingDirectory));
        });
    }
}

