/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class JarContentsManager {
    private static final String JAR_PATH_SEPARATOR = "/";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsPath(File jar, String filePath) {
        this.requireFileExistence(jar);
        Objects.requireNonNull(filePath);
        try (JarFile jarFile = new JarFile(jar, false);){
            boolean bl = jarFile.getJarEntry(filePath) != null;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to retrieve file '%s' from jar '%s'", filePath, jar), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getFileContents(File jar, String filePath) {
        this.requireFileExistence(jar);
        Objects.requireNonNull(filePath);
        try (JarFile jarFile = new JarFile(jar, false);){
            byte[] byArray = this.getJarEntryContents(jarFile, jarFile.getJarEntry(filePath));
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to retrieve file '%s' from jar '%s'", filePath, jar), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> findFiles(File jar, String baseDirectoryName, String fileName) {
        this.requireFileExistence(jar);
        Objects.requireNonNull(baseDirectoryName);
        Objects.requireNonNull(fileName);
        try (JarFile jarFile = new JarFile(jar, false);){
            List<String> list = jarFile.stream().filter(entry -> !entry.isDirectory()).map(ZipEntry::getName).filter(path -> path.startsWith(baseDirectoryName)).filter(path -> path.endsWith(JAR_PATH_SEPARATOR + fileName)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void requireFileExistence(File jar) {
        if (!Objects.requireNonNull(jar).isFile()) {
            throw new IllegalArgumentException(String.format("Expect '%s' to be an existing file", jar));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getJarEntryContents(JarFile jarFile, JarEntry entry) {
        if (entry == null) {
            return null;
        }
        try (InputStream entryStream = jarFile.getInputStream(entry);){
            byte[] byArray = IOUtils.toByteArray((InputStream)entryStream);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to get entry '%s' contents from jar file '%s'", entry, jarFile), e);
        }
    }

    public void copyFilesFromJarTrimmingBasePath(File jar, String jarDirectoryToCopyFrom, File outputDirectory, String ... wildcardPathExclusions) {
        this.requireFileExistence(jar);
        if (!Objects.requireNonNull(outputDirectory).isDirectory()) {
            throw new IllegalArgumentException(String.format("Expect '%s' to be an existing directory", outputDirectory));
        }
        String basePath = this.normalizeJarBasePath(jarDirectoryToCopyFrom);
        try (JarFile jarFile = new JarFile(jar, false);){
            jarFile.stream().filter(file -> !file.isDirectory()).filter(file -> file.getName().toLowerCase(Locale.ENGLISH).startsWith(basePath.toLowerCase(Locale.ENGLISH))).filter(file -> this.isFileIncluded((ZipEntry)file, wildcardPathExclusions)).forEach(jarEntry -> this.copyJarEntryTrimmingBasePath(jarFile, (ZipEntry)jarEntry, basePath, outputDirectory));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to extract files from jarFile '%s' to directory '%s'", jar, outputDirectory), e);
        }
    }

    private String normalizeJarBasePath(String rawPath) {
        if (rawPath == null || rawPath.isEmpty()) {
            return "";
        }
        return rawPath.endsWith(JAR_PATH_SEPARATOR) ? rawPath : rawPath + JAR_PATH_SEPARATOR;
    }

    private boolean isFileIncluded(ZipEntry file, String ... pathExclusions) {
        String filePath = file.getName();
        return Stream.of(pathExclusions).noneMatch(exclusionRule -> FilenameUtils.wildcardMatch((String)filePath, (String)exclusionRule));
    }

    private void copyJarEntryTrimmingBasePath(JarFile jarFile, ZipEntry jarEntry, String basePath, File outputDirectory) {
        String fullPath = jarEntry.getName();
        String relativePath = fullPath.substring(fullPath.toLowerCase(Locale.ENGLISH).indexOf(basePath.toLowerCase(Locale.ENGLISH)) + basePath.length());
        try {
            FileUtils.copyInputStreamToFile((InputStream)jarFile.getInputStream(jarEntry), (File)new File(outputDirectory, relativePath));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to extract jar entry '%s' from jarFile '%s'", jarEntry, outputDirectory), e);
        }
    }
}

